var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}

	this._getNextStep = function (mapArray, i, j, x, y) {
		var route = core.maps._automaticRoute_bfs(i, j, x, y);
		if (route[x + "," + y] == null) return [];
		var ans = [],
			nowX = x,
			nowY = y;
		while (nowX != i || nowY != j) {
			var dir = route[nowX + "," + nowY];
			ans.push({ 'direction': dir, 'x': nowX, 'y': nowY });
			nowX -= core.utils.scan[dir].x;
			nowY -= core.utils.scan[dir].y;
		}
		ans.reverse();
		if (ans.length == 0) {
			if (i > x && !core.maps.noPass(i - 1, j)) {
				ans.push({ 'direction': 'left', 'x': x, 'y': y });
			} else if (i < x && !core.maps.noPass(i + 1, j)) {
				ans.push({ 'direction': 'right', 'x': x, 'y': y });
			} else if (j < y && !core.maps.noPass(i, j + 1)) {
				ans.push({ 'direction': 'up', 'x': x, 'y': y });
			} else if (j > y && !core.maps.noPass(i, j - 1)) {
				ans.push({ 'direction': 'down', 'x': x, 'y': y });
			}
		}
		return ans;
	};

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "wargame": function () {
	// 在此增加新插件
	// 此插件为第二棒编写

	// 计算出地图上所以可以移动到的格子
	this.showMoveable = function () {
		var loc = core.status.hero.loc;
		var max = 4;
		if (flags.slow) max = 2;
		if (flags.juqi) max *= 2;
		core.clearAirwall();
		core.clearMoveable();
		core.putBg2Events();
		var moveable = [];
		for (var i = 0; i < core.bigmap.width; i++) {
			for (var j = 0; j < core.bigmap.height; j++) {
				var dx = Math.abs(i - loc.x);
				var dy = Math.abs(j - loc.y);
				if (dx + dy > max) continue;
				if (dx + dy > 0) {
					var block = core.getBlock(i, j);
					if (block) {
						if ((block.block.event.cls != 'items' && block.block.id != 12) && (block.block.id != 81 && block.block.id != 82 && block.block.id != 83)) continue;
					}
					var moveStep = core.automaticRoute(i, j);
					if (moveStep.length > max) continue;
					if (moveStep.length <= 0) continue;
				}
				moveable.push([i, j]);
			}
		}
		flags.moveable = moveable;
		flags.loc = [loc.x, loc.y];
		flags.juqi = 0;
		core.drawMoveable();
	};

	//清除地图上所有绿色方格
	this.clearMoveable = function () {
		for (var i = 0; i < core.bigmap.width; i++) {
			for (var j = 0; j < core.bigmap.height; j++) {
				var bgNumber = core.getBgNumber(i, j);
				if (bgNumber == 900) {
					core.setBgFgBlock('bg', 0, i, j);
				}
			}
		}
	};

	// 在地图上以绿方格的形式表示勇士可以行动到的格子
	this.drawMoveable = function () {
		if (!flags.moveable) return;
		core.clearMoveable();
		for (var k in flags.moveable) {
			var toX = flags.moveable[k][0];
			var toY = flags.moveable[k][1];
			core.setBgFgBlock('bg', 900, toX, toY);
		}
	};


	// 清除所有空气墙
	this.clearAirwall = function () {
		for (var i = 0; i < core.bigmap.width; i++) {
			for (var j = 0; j < core.bigmap.height; j++) {
				var blockId = core.getBlockId(i, j);
				if (blockId == 'airwall') {
					core.removeBlock(i, j);
				}
			}
		}
	};

	// 将所有道具放到bg层，方便怪物们行动
	this.putItems2Bg = function () {
		for (var i = 0; i < core.bigmap.width; i++) {
			for (var j = 0; j < core.bigmap.height; j++) {
				var block = core.getBlock(i, j);
				if (block) {
					if (block.block.event.cls == 'items') {
						core.setBgFgBlock('bg', block.block.id, i, j);
						core.removeBlock(i, j);
					}
				}
			}
		}
	};

	this.putNets2Bg = function () {
		for (var i = 0; i < core.bigmap.width; i++) {
			for (var j = 0; j < core.bigmap.height; j++) {
				var id = core.getBlockId(i, j);
				if (id == 'poisonNet') {
					core.setBgFgBlock('bg', 12, i, j);
					core.removeBlock(i, j);
				}
			}
		}
	};


	// 将所有墙放到bg层，方便飞行怪物们行动
	this.putWalls2Bg = function () {
		for (var i = 0; i < core.bigmap.width; i++) {
			for (var j = 0; j < core.bigmap.height; j++) {
				var block = core.getBlock(i, j);
				if (block) {
					if (block.block.event.id == 'yellowWall') {
						core.setBgFgBlock('bg', block.block.id, i, j);
						core.removeBlock(i, j);
					}
				}
			}
		}
	};

	// 将所有bg层的道具以及墙恢复到事件层
	this.putBg2Events = function () {
		for (var i = 0; i < core.bigmap.width; i++) {
			for (var j = 0; j < core.bigmap.height; j++) {
				var bg = core.getBgNumber(i, j);
				var block = core.getBlockId(i, j);
				if (bg && bg != 900 && !block) {
					core.setBlock(bg, i, j);
					core.setBgFgBlock('bg', 0, i, j);
				}
			}
		}
	};

	// 勇士行动后，轮到怪物行动
	this.afterMove = function () {
		var flooId = core.status.floorId;
		if (flooId != 'MT1' && flooId != 'MT2') return;
		core.poisonMap();
		core.clearMoveable();
		core.putBg2Events();
		core.putItems2Bg();
		core.putNets2Bg();
		core.drawMap(core.status.floorId, function () {
			core.enemyMove();
		});
		//core.showPoison();
	};

	// 怪物移动
	this.enemyMove = function (isFly) {
		var loc = core.status.hero.loc;
		var action = [];

		var allBlocks = core.status.thisMap.blocks;
		allBlocks = allBlocks.sort(function (a, b) {
			return (a.x + a.y * 13 > b.x + b.y * 13) ? 1 : -1;
		});
		for (var i in allBlocks) {
			if (flags.shengshui) {
				break;
			}
			var block = allBlocks[i];
			if (!block.disable && block.event.cls.indexOf('enemy') == 0) {
				var x = block.x;
				var y = block.y;
				var enemy = core.material.enemys[block.event.id];
				var special = enemy.special;

				//空军不在这一轮行动
				if (!!core.hasSpecial(special, 100) + !!isFly == 1) {
					continue;
				}

				var fx = x;
				var fy = y;

				var route = core.automaticRoute(x, y);
				if (route.length > 1) {
					fx = route[0].x;
					fy = route[0].y;
					route.shift();
					route.reverse();

					var simpleRoute = [];
					var count = 2;
					if (flags.round > 15) count++;
					if (flags.round > 30) count++;
					if (core.hasSpecial(special, 102)) count *= 2;
					var init = count;

					for (var k in route) {
						if (count <= 0) break;
						simpleRoute.push(core.reverseDirection(route[k].direction));
						count--;
					}
					action.push({ "type": "move", "loc": [x, y], "time": 250, "keep": true, "steps": simpleRoute });
					//core.moveBlock(x, y, simpleRoute, 250, true, function () {

					if (route[init]) {
						fx = route[init].x;
						fy = route[init].y;
					}

					// 第三棒加入内容
					core.setBlock('airwall', fx, fy);
					if (core.status.floorId == 'MT2') {
						var step = route.length > init ? init : Math.max(0, init - 1);

						var poisonEnemy = core.getFlag('_enemyPoison');
						if (poisonEnemy[y][x]) {
							core.recordEnemyStep([x, y], step, [fx, fy]);
						} else {
							var poisonMap = core.getFlag('_poisonArray');
							for (var l = 0; l < init; l++) {
								if (l >= route.length) break;
								var rx = route[l].x,
									ry = route[l].y;
								if (poisonMap[ry][rx] && !poisonEnemy[y][x]) {
									core.recordEnemyStep([rx, ry], init - l, [fx, fy]);
									break;
								}
							}
						}
						core.showPoison();
					}
					// 第三棒加入内容结束

					if (core.nearHero(fx, fy)) {
						var damage = enemy.atk - core.status.hero.def;
						if (damage < 0) damage = 0;
						if (core.hasSpecial(special, 12)) action.push({ "type": "insert", "name": "毒衰咒处理", "args": [0] }); //中毒
						if (core.hasSpecial(special, 13)) action.push({ "type": "insert", "name": "毒衰咒处理", "args": [1] }); //衰弱
						if (core.hasSpecial(special, 101)) action.push({ "type": "insert", "name": "毒衰咒处理", "args": [3] }); //迟缓
						if (core.hasSpecial(special, 2)) damage = enemy.atk; //魔攻
						if (core.hasSpecial(special, 22)) damage += enemy.damage; //固伤

						if (damage > 0) {
							action.push({ "type": "setValue", "name": "status:hp", "value": "status:hp-" + damage });
							action.push({ "type": "function", "function": "function(){\ncore.tiaoziDamage(-" + damage + ");\n}" });
							action.push({ "type": "playSound", "name": "attack.mp3" });
							action.push({ "type": "sleep", "time": "500" });
							//action.push(enemy.name + '对终末进行攻击，终末受到' + damage + '点伤害');
						}
					}
				}
			}
		}
		core.insertAction(action, null, null, function () {
			if (isFly) {
				flags.shengshui = 0;

				core.insertAction(core.getCommonEvent('每回合处理'));
			} else {
				core.clearAirwall();
				core.putWalls2Bg();
				if (core.status.floorId == 'MT2') core.poisoned2Death();
				core.drawMap(core.status.floorId, function () {
					core.enemyMove(true);
				});
			}
		});
	};
},
    "image": function () {
	// 在此增加新插件

	var src = "data:image/png;base64,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";

	var srcItems = "data:image/png;base64,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";

	var initCloud = function () {
		if (core.material.images.terrains && core.material.images.items) {
			core.material.images.terrains.src = src;
			core.material.images.items.src = srcItems;
		} else
			setTimeout(initCloud, 100);
	};
	initCloud();
},
    "edge": function () {
	// 在此增加新插件

	if (!core.maps._canMoveHero_checkPointOrigin) core.maps._canMoveHero_checkPointOrigin = core.clone(core.maps._canMoveHero_checkPoint);
	core.maps._canMoveHero_checkPoint = function (x, y, direction, floorId, extraData) {
		if (core.maps._canMoveHero_checkPointOrigin(x, y, direction, floorId, extraData)) {

			var nx = x + core.utils.scan[direction].x,
				ny = y + core.utils.scan[direction].y;

			//1、检查该点的bridge属性，和下一点的brideg属性，如果有一方为属性，可通过，不检查2
			if (this._canMoveHero_checkCannotInOut([
					extraData.bgArray[y][x], extraData.fgArray[y][x], extraData.eventArray[y][x]
				], "cannotOut", "bridge"))
				return true;

			if (this._canMoveHero_checkCannotInOut([
					extraData.bgArray[ny][nx], extraData.fgArray[ny][nx], extraData.eventArray[ny][nx]
				], "cannotIn", "bridge"))
				return true;

			//2、检查该点的edge属性，和下一点的edge属性，如果双方有一方是edge属性，另一方不是edge属性，则不能移动

			var in1 = true;
			var in2 = true;

			if (this._canMoveHero_checkCannotInOut([
					extraData.bgArray[y][x], extraData.fgArray[y][x], extraData.eventArray[y][x]
				], "cannotOut", "edge"))
				in1 = false;

			if (this._canMoveHero_checkCannotInOut([
					extraData.bgArray[ny][nx], extraData.fgArray[ny][nx], extraData.eventArray[ny][nx]
				], "cannotIn", "edge"))
				in2 = false;

			if (in1 + in2 == 1) return false;
			return true;
		} else { return false; }
	};

	//重写getBgNumber方法，强制不读缓存
	core.maps.getBgNumber = function (x, y, floorId, noCache) {
		return core.maps._getBgFgNumber('bg', x, y, floorId, true);
	};


	core.maps.generateMovableArray = function (floorId, x, y, direction) {
		floorId = floorId || core.status.floorId;
		if (!floorId) return null;
		var width = core.floors[floorId].width,
			height = core.floors[floorId].height;
		var bgArray = core.maps.getBgMapArray(floorId, true),
			fgArray = core.maps.getFgMapArray(floorId),
			eventArray = core.maps.getMapArray(floorId);

		var generate = function (x, y, direction) {
			if (direction != null) {
				return core.maps._canMoveHero_checkPoint(x, y, direction, floorId, {
					bgArray: bgArray,
					fgArray: fgArray,
					eventArray: eventArray
				});
			}
			return ["left", "down", "up", "right"].filter(function (direction) {
				return core.maps._canMoveHero_checkPoint(x, y, direction, floorId, {
					bgArray: bgArray,
					fgArray: fgArray,
					eventArray: eventArray
				});
			});
		};

		if (x != null && y != null) return generate(x, y, direction);
		var array = [];
		for (var x = 0; x < width; x++) {
			array[x] = [];
			for (var y = 0; y < height; y++) {
				array[x][y] = generate(x, y);
			}
		}
		return array;
	};
},
    "tiaozi": function () {
	// 在此增加新插件
	this.tiaozi = function (neirong, yanse) { //跳字
		if (core.status.replay.replaying) {} else {
			var shangsheng = 1;
			var gaodu = 0;
			var tiaozizhong = 0;
			var herox = core.status.hero.loc.x,
				heroy = core.status.hero.loc.y;
			var name = "tiaozi" + Math.floor(Math.random() * 1000000); //如不需要连续跳字可不加随机数
			core.createCanvas(name, (herox - 1) * 32 - 9, (heroy - 1) * 32 + gaodu, 96, 64, 74);
			core.fillText(name, neirong, 32, 32, yanse, "bold 17px Verdana");
			var fade = setInterval(function () {
				if (gaodu >= -6 && shangsheng == 1) {
					gaodu = gaodu - 1;
					if (gaodu == -6) { shangsheng = 0; }
				} else if (gaodu <= 12) {
					gaodu = gaodu + 1;
					if (gaodu == 12) { tiaozizhong = 1; }
				}
				core.relocateCanvas(name, (herox - 1) * 32 - 9, (heroy - 1) * 32 + gaodu);
				if (tiaozizhong == 1) {
					delete core.animateFrame.asyncId[fade];
					clearInterval(fade);
					core.deleteCanvas(name);
				}
			}, 16);
			core.animateFrame.asyncId[fade] = true;
		}
	};

	this.tiaoziDamage = function (hp) {
		var offset = '';
		if (hp == 0) return;
		else if (hp < 0) {
			hp = -hp;
			if (hp < 10) offset = '   ';
			else if (hp < 100) offset = '  ';
			else if (hp < 1000) offset = ' ';
			core.tiaozi(offset + hp, '#FF0000');
		} else if (hp > 0) {
			if (hp < 10) offset = '   ';
			else if (hp < 100) offset = '  ';
			else if (hp < 1000) offset = ' ';
			core.tiaozi(offset + hp, '#00FF00');
		}
	};
},
    "poisonEnemy": function () {
	// 在此增加新插件
	// 第三棒
	// 怪物中毒，创建一个13x13的矩阵，数字表示怪物中毒后走的次数

	this.createEnemyPoisonArray = function () {
		var array = [
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
		];
		core.setFlag('_enemyPoison', array);

	}

	this.poisonMap = function () {
		var array = core.getFlag('_poisonArray', [
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
		]);
		for (var i = 0; i < core.bigmap.width; i++) {
			for (var j = 0; j < core.bigmap.height; j++) {
				var id = core.getBlockId(i, j),
					id2 = core.getBgNumber(i, j);
				if (id == 'poisonNet' || id2 == 12) array[j][i] = 1;
			}
		}
		core.setFlag('_poisonArray', array);
	}

	this.recordEnemyStep = function (loc, step, aim) {
		if (core.status.floorId == 'MT2') {
			var array = core.getFlag('_enemyPoison'),
				x = loc[0],
				y = loc[1],
				fx = aim[0],
				fy = aim[1];
			var num = array[y][x];
			array[fy][fx] = num + step;
			array[y][x] = 0;
			core.setFlag('_enemyPoison', array);
		}
	}

	this.showPoison = function () {
		if (core.status.floorId == 'MT2') {
			core.createCanvas('_poison', 0, 0, core.bigmap.width * 32, core.bigmap.height * 32, 86);
			core.clearMap('_poison');
			var array = core.getFlag('_enemyPoison');
			for (var i = 0; i < core.bigmap.width; i++) {
				for (var j = 0; j < core.bigmap.height; j++) {
					var num = array[j][i];
					if (!num) continue;
					core.fillBoldText('_poison', num * core.values.poisonDamage, i * 32, j * 32 + 11, 'white', "bold 11px Arial ");
				}
			}
		}
	}

	this.poisoned2Death = function () {
		if (core.status.floorId == 'MT2') {
			var array = core.getFlag('_enemyPoison');
			for (var i = 0; i < core.bigmap.width; i++) {
				for (var j = 0; j < core.bigmap.height; j++) {
					var num = array[j][i];
					if (num) {
						var damage = (num) * core.values.poisonDamage;
						var block = core.getBlock(i, j);
						if (block && block.block.event.cls == 'enemys') {
							if (core.enemys.enemys[block.block.event.id].hp <= damage) {
								core.drawTip(core.enemys.enemys[block.block.event.id].name + '被毒死了');
								core.removeBlock(i, j);
								array[j][i] = 0;
								core.showPoison();
							}
						} else continue;
					}
				}
			}
		}
	}

	this.putNet = function () {
		if (function () {
				var block = core.getBlock(core.nextX(), core.nextY());
				var bg = core.getBgNumber(core.nextX(), core.nextY());
				if (!block) {
					if (!bg || bg == 900) {
						core.setBlock(12, core.nextX(), core.nextY());
						return true;
					}
				} else if (block.block.event.cls == 'enemys') {
					if (!bg) {
						core.setBgFgBlock('bg', 12, core.nextX(), core.nextY());
						return true;
					}
				}
			}()) {
			core.drawTip('放置成功！');
		} else {
			core.drawTip('放置失败');
			core.addItem('skill1');
		}
	}
},
    "yb": function () {
	// 在此增加新插件
	this.yb = function () {
		var eNum = 230;
		if (core.getFlag('4turn', 0) >= 7) eNum = 245;
		else if (core.getFlag('4turn', 0) >= 4) eNum = 246;
		for (var i = 1; i < core.__SIZE__ - 1; i++) {
			for (var j = 1; j < core.__SIZE__ - 1; j++) {
				var num = 0;
				for (var ni = -1; ni <= 1; ni++) {
					for (var nj = -1; nj <= 1; nj++) {
						var block = core.getBlock(i + ni, j + nj);
						if (ni == 0 && nj == 0) {
							if (block) var zt = 1;
							else var zt = 0;

						} else {
							if (block && block.block.id != 4) num++;
						}
					}
				}
				if (num == 3) zt = 1;
				else if (num != 2) zt = 0;
				if (zt) {
					core.setBgFgBlock('bg', eNum, i, j);
				} else {
					//core.removeBlock(i, j)
				}
			}
		}
		core.clearEvents();
		core.putBg2Events();
	}

	this.clearEvents = function () {
		for (var i = 1; i < core.__SIZE__ - 1; i++) {
			for (var j = 1; j < core.__SIZE__ - 1; j++) {
				core.removeBlock(i, j);
			}
		}
	}

	this.clearBg = function () {
		for (var i = 0; i < core.__SIZE__; i++) {
			for (var j = 0; j < core.__SIZE__; j++) {
				core.setBgFgBlock('bg', 0, i, j);
			}
		}
	}

	this.tryYb = function () {
		for (var i = 1; i < core.__SIZE__ - 1; i++) {
			for (var j = 1; j < core.__SIZE__ - 1; j++) {
				var num = 0;
				for (var ni = -1; ni <= 1; ni++) {
					for (var nj = -1; nj <= 1; nj++) {
						var block = core.getBlock(i + ni, j + nj);
						if (ni == 0 && nj == 0) {
							if (block) var zt = 1;
							else var zt = 0;

						} else {
							if (block && block.block.id != 4) num++;
						}
					}
				}
				if (num == 3) zt = 1;
				else if (num != 2) zt = 0;
				if (zt) {
					core.setBgFgBlock('bg', 167, i, j);
				}
			}
		}
	}
}
}