# 楼层MAP数据提取完成报告

## 📋 项目总结

已成功从所有楼层文件中提取并汇总map数组数据。

## ✅ 完成内容

### 提取的楼层数
- **总楼层数**: 27层
- **楼层列表**: MT0, MT1, MT2, ..., MT22, MT23e, MT23s, MT23w, MT_1
- **统一标准**: 所有楼层均为 13×13 的网格地图（169个格子）

### 生成的文件

#### 1. **all_maps.json** (完整版)
- 文件大小: 58 KB
- 包含: 楼层ID + 源文件名 + map二维数组
- 用途: 完整数据备份，包含追踪信息
- 格式: JSON标准格式
- 特点: 易于程序处理

#### 2. **all_maps_simplified.json** (简化版)
- 包含: 仅楼层ID + map二维数组
- 用途: 程序调用时使用，文件更精简
- 格式: JSON标准格式
- 特点: 去除冗余信息，提高处理效率

#### 3. **all_maps_readable.txt** (易读文本版)
- 文件大小: 25 KB
- 包含: 所有楼层的map数据，以数组形式显示
- 用途: 人工查看、验证、分析
- 格式: 纯文本，格式化输出
- 特点: 直观易读，便于视觉检查

#### 4. **all_maps_report.txt** (统计报告)
- 包含: 楼层列表及统计信息
- 信息: 每个楼层的宽度、高度、总格子数
- 用途: 快速了解地图整体情况
- 特点: 简洁明了

## 📊 数据统计

```
楼层ID     | 尺寸      | 总格子数
-----------|-----------|----------
MT0-MT22   | 13 × 13   | 169
MT23e      | 13 × 13   | 169
MT23s      | 13 × 13   | 169
MT23w      | 13 × 13   | 169
MT_1       | 13 × 13   | 169
```

## 🔧 使用方式

### JavaScript/Node.js
```javascript
// 使用简化版JSON
const maps = require('./all_maps_simplified.json');
const mt0Map = maps.MT0;  // 获取MT0层的map数据

// 访问具体的map数据
console.log(maps.MT0[0][0]);  // 获取第一行第一列的值
```

### 纯文本查看
```bash
# 直接打开查看
cat all_maps_readable.txt
cat all_maps_report.txt
```

## 📝 提取方法

使用Node.js脚本自动化提取：
1. `extract_maps.js` - 从所有MT*.js文件提取map数组
2. `generate_formats.js` - 生成多种格式的输出文件

## ✨ 特点

✓ 全量提取：27个楼层，100%覆盖  
✓ 多格式输出：JSON、文本、报告  
✓ 数据验证：所有数据均已验证和解析  
✓ 易于维护：清晰的结构和命名  
✓ 可编程：JSON格式便于程序处理  

---

**生成时间**: 2026年1月30日  
**位置**: `d:\新建文件夹 (7)\dist\project\floors\`
