const fs = require('fs');
const path = require('path');

// 读取已生成的JSON文件
const jsonPath = path.join(__dirname, 'all_maps.json');
const allMaps = JSON.parse(fs.readFileSync(jsonPath, 'utf8'));

// 创建一个简化版本：只包含楼层ID和map数据（不含file信息）
const simplifiedMaps = {};
Object.keys(allMaps).sort().forEach(floorId => {
    simplifiedMaps[floorId] = allMaps[floorId].map;
});

// 保存简化版本
const simplifiedPath = path.join(__dirname, 'all_maps_simplified.json');
fs.writeFileSync(simplifiedPath, JSON.stringify(simplifiedMaps, null, 2), 'utf8');
console.log(`✓ 简化版已保存: all_maps_simplified.json`);

// 创建易读的文本版本
let textContent = '所有楼层MAP数据汇总\n';
textContent += '='.repeat(50) + '\n\n';

Object.keys(simplifiedMaps).sort().forEach(floorId => {
    const map = simplifiedMaps[floorId];
    const width = map[0] ? map[0].length : 0;
    const height = map.length;
    
    textContent += `楼层ID: ${floorId}\n`;
    textContent += `尺寸: ${width} × ${height}\n`;
    textContent += `数据:\n`;
    
    // 将二维数组转为纯文本显示
    map.forEach(row => {
        textContent += '  [' + row.join(', ').padEnd(60) + ']\n';
    });
    
    textContent += '\n' + '-'.repeat(50) + '\n\n';
});

const textPath = path.join(__dirname, 'all_maps_readable.txt');
fs.writeFileSync(textPath, textContent, 'utf8');
console.log(`✓ 易读文本版已保存: all_maps_readable.txt`);

// 创建一个统计报告
let reportContent = '楼层MAP数据统计报告\n';
reportContent += '='.repeat(60) + '\n\n';

const floorIds = Object.keys(simplifiedMaps).sort();
reportContent += `总楼层数: ${floorIds.length}\n\n`;
reportContent += '楼层列表:\n';
reportContent += '-'.repeat(60) + '\n';

floorIds.forEach(floorId => {
    const map = simplifiedMaps[floorId];
    const width = map[0] ? map[0].length : 0;
    const height = map.length;
    const totalCells = width * height;
    
    reportContent += `${floorId.padEnd(10)} | 尺寸: ${width.toString().padEnd(2)} × ${height.toString().padEnd(2)} | 总格子数: ${totalCells}\n`;
});

reportContent += '-'.repeat(60) + '\n';

const textStatPath = path.join(__dirname, 'all_maps_report.txt');
fs.writeFileSync(textStatPath, reportContent, 'utf8');
console.log(`✓ 统计报告已保存: all_maps_report.txt`);

console.log(`\n✓ 全部生成完成！`);
console.log(`生成的文件：`);
console.log(`  1. all_maps.json (包含源文件信息)`);
console.log(`  2. all_maps_simplified.json (简化版JSON)`);
console.log(`  3. all_maps_readable.txt (易读文本格式)`);
console.log(`  4. all_maps_report.txt (统计报告)`);
