var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {
	core.registerReplayAction('jsb', (action) => {
		if (action != 'jsb') return false
		core.insertCommonEvent('记事本')
		core.replay()
		return true
	})
	core.registerReplayAction("keyinMenu", (action) => {
		if (action != 'keyinMenu') return false
		core.insertCommonEvent('刻印选择')
		core.replay()
		return true
	})
	core.registerReplayAction('mj', (action) => {
		if (action != 'mj') return false
		core.insertCommonEvent('密卷')
		core.replay()
		return true
	})
	core.registerReplayAction('usk1', (action) => {
		if (action != 'usk1') return false
		core.useSkill(1, core.getFlag('sk1', 1), 1)
		core.replay()
		return true
	})
	core.registerReplayAction('usk2', (action) => {
		if (action != 'usk2') return false
		core.useSkill(2, core.getFlag('sk2', 1), 1)
		core.replay()
		return true
	})
	core.registerReplayAction('usk3', (action) => {
		if (action != 'usk3') return false
		core.useSkill(3, core.getFlag('sk3', 1), 1)
		core.replay()
		return true
	})
	core.registerReplayAction('ts', (action) => {
		if (action != 'ts') return false
		core.tishen()
		core.replay()
		return true
	})
	console.log("插件编写测试");

	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作。
		// 若需要进行切分图片，可以使用 core.splitImage() 函数，或直接在全塔属性-图片切分中操作
		// 
		core.ui.statusBar.init();

	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "resizeTo11": function () {
	if (main.mode == 'editor') {
		return;
	}

	// 在不修改libs的情况下将页面适配为11x11
	core.__SIZE__ = 11;
	core.__PIXELS__ = core.__SIZE__ * 32;
	core.__HALF_SIZE__ = 5;
	// core.bigmap.width = core.__SIZE__;
	// core.bigmap.height = core.__SIZE__;
	core.actions.SIZE = core.__SIZE__;
	core.actions.HSIZE = core.__HALF_SIZE__;
	core.actions.LAST = core.__SIZE__ - 1;
	core.actions.CHOICES_LEFT = 3;
	core.actions.CHOICES_RIGHT = core.actions.LAST - core.actions.CHOICES_LEFT;
	core.ui.SIZE = core.__SIZE__;
	core.ui.HSIZE = core.__HALF_SIZE__;
	core.ui.LAST = core.__SIZE__ - 1;
	core.ui.PIXEL = core.__PIXELS__;
	core.ui.HPIXEL = core.__PIXELS__ / 2;
},
    "statusBar": function () {
	main.dom.floorMsgGroup.style.display = 'none';
	main.dom.statusBar.style.display = 'none';
	main.dom.toolBar.style.display = 'none';

	const GAMEVIEW_WIDTH = 640;
	const GAMEVIEW_HEIGHT = 422;

	const GAMEVIEW_WIDTH_VERTICAL = 388;
	const GAMEVIEW_HEIGHT_VERTICAL = 630;

	const BAR_WIDTH = 125;
	const BAR_HEIGHT_VERTICAL = 130;
	const BORDER_WIDTH = 18;
	const BORDER_HEIGHT = 24;
	
	const ITEM_BOX_LEFT = 13;
	const ITEM_BOX_TOP = 190;
	const ITEM_BOX_LEFT_VERTICAL = 120;
	const ITEM_BOX_TOP_VERTICAL = 20;

	const ITEM_ICON_OUTER_SIZE = 33;

	const EQUIP_BLOCK_LEFT = 525;
	const EQUIP_BLOCK_TOP = 40;
	const EQUIP_BLOCK_LEFT_VERTICAL = 275;
	const EQUIP_BLOCK_TOP_VERTICAL = 20;

	const KEY_BLOCK_LEFT = EQUIP_BLOCK_LEFT;
	const KEY_BLOCK_LEFT_VERTICAL = 264;
	const KEY_BLOCK_TOP_VERTICAL = 520;

	const INFO_BLOCK_LEFT = EQUIP_BLOCK_LEFT;
	const INFO_BLOCK_TOP = 220;
	const INFO_BLOCK_LEFT_VERTICAL = 25;
	const INFO_BLOCK_TOP_VERTICAL = 510;

	const TOOL_BOX_LEFT = EQUIP_BLOCK_LEFT;
	const TOOL_BOX_TOP = 318;
	const TOOL_BOX_LEFT_VERTICAL = 309;
	const TOOL_BOX_TOP_VERTICAL = 520;

	const TOOL_ICON_OUTER_SIZE = 34;

	const INFO_BAR_HEIGHT = 22;
	const INFO_BAR_HEIGHT_VERTICAL = 10;
	const INFO_BAR_TOP = GAMEVIEW_HEIGHT - INFO_BAR_HEIGHT;
	const INFO_BAR_TOP_VERTICAL = GAMEVIEW_HEIGHT_VERTICAL - INFO_BAR_HEIGHT_VERTICAL - 100;

	const TEXT_COLOR = "#E1E1E1";

	const FORCE_COUNTABLE_ITEMS = ["centerFly"];

	const outerBackground = document.createElement('canvas');
	outerBackground.style.position = 'absolute';
	outerBackground.style.zIndex = 5;
	outerBackground.id = 'outerBackground';
	main.dom.outerBackground = outerBackground;
	main.dom.startPanel.insertAdjacentElement('afterend', outerBackground);

	const outerUI = document.createElement('canvas');
	outerUI.style.position = 'absolute';
	outerUI.style.zIndex = 165;
	outerUI.id = 'outerUI';
	main.dom.outerUI = outerUI;
	outerBackground.insertAdjacentElement('afterend', outerUI);
	setTimeout(function () {
		// Should be executed immediately after init()
		main.canvas.outerUI = outerUI.getContext('2d');
	});
	outerUI.onclick = function (e) {
		try {
			e.preventDefault();
			if (!core.isPlaying()) return false;
			const left = core.dom.gameGroup.offsetLeft;
			const top = core.dom.gameGroup.offsetTop;
			const px = parseInt((e.clientX - left) / core.domStyle.scale),
				py = parseInt((e.clientY - top) / core.domStyle.scale);
			core.ui.statusBar.onclick(px, py);
		} catch (ee) {
			main.log(ee);
		}
	}

	const _resize_gameGroup = function (obj) {
		const gameGroup = core.dom.gameGroup;
		gameGroup.style.width = obj.totalWidth + "px";
		gameGroup.style.height = obj.totalHeight + "px";
		gameGroup.style.left = (obj.clientWidth - obj.totalWidth) / 2 + "px";
		gameGroup.style.top = (obj.clientHeight - obj.totalHeight) / 2 + "px";

		core.dom.musicBtn.style.right = (obj.clientWidth - obj.totalWidth) / 2 + "px";
		core.dom.musicBtn.style.bottom = (obj.clientHeight - obj.totalHeight) / 2 - 27 + "px";
		core.dom.enlargeBtn.style.right = (obj.clientWidth - obj.totalWidth) / 2 + 31 + "px";
		core.dom.enlargeBtn.style.bottom = (obj.clientHeight - obj.totalHeight) / 2 - 27 + "px";

		main.dom.startBackground.src = main.styles.startBackground;
	}

	const _resize_canvas = function (obj) {
		main.dom.outerBackground.style.width = obj.totalWidth + 'px';
		main.dom.outerBackground.style.height = obj.totalHeight + 'px';
		main.dom.outerUI.style.width = obj.totalWidth + 'px';
		main.dom.outerUI.style.height = obj.totalHeight + 'px';

		const innerSize = (obj.canvasWidth * core.domStyle.scale) + "px";
		for (let i = 0; i < core.dom.gameCanvas.length; ++i)
			core.dom.gameCanvas[i].style.width = core.dom.gameCanvas[i].style.height = innerSize;
		core.dom.gif.style.width = core.dom.gif.style.height = innerSize;
		core.dom.gif2.style.width = core.dom.gif2.style.height = innerSize;
		core.dom.gameDraw.style.width = core.dom.gameDraw.style.height = innerSize;
		core.dom.gameDraw.style.top = obj.gameDrawBox.top * core.domStyle.scale + "px";
		core.dom.gameDraw.style.left = (obj.gameDrawBox.left) * core.domStyle.scale + "px";

		// resize bigmap
		core.bigmap.canvas.forEach(function (cn) {
			const ratio = core.canvas[cn].canvas.hasAttribute('isHD') ? core.domStyle.ratio : 1;
			core.canvas[cn].canvas.style.width = core.canvas[cn].canvas.width / ratio * core.domStyle.scale + "px";
			core.canvas[cn].canvas.style.height = core.canvas[cn].canvas.height / ratio * core.domStyle.scale + "px";
		});
		// resize dynamic canvas
		for (const name in core.dymCanvas) {
			const ctx = core.dymCanvas[name],
				canvas = ctx.canvas;
			const ratio = canvas.hasAttribute('isHD') ? core.domStyle.ratio : 1;
			canvas.style.width = canvas.width / ratio * core.domStyle.scale + "px";
			canvas.style.height = canvas.height / ratio * core.domStyle.scale + "px";
			canvas.style.left = parseFloat(canvas.getAttribute("_left")) * core.domStyle.scale + "px";
			canvas.style.top = parseFloat(canvas.getAttribute("_top")) * core.domStyle.scale + "px";
		}
		// resize next
		main.dom.next.style.width = main.dom.next.style.height = 5 * core.domStyle.scale + "px";
		main.dom.next.style.borderBottomWidth = main.dom.next.style.borderRightWidth = 4 * core.domStyle.scale + "px";

	}

	core.control.resize = function () {
		if (main.mode == 'editor') return;

		const clientWidth = main.dom.body.clientWidth,
			clientHeight = main.dom.body.clientHeight;
		const canvasWidth = core.__PIXELS__;

		const isVertical = clientHeight > clientWidth;
		core.domStyle.isVertical = isVertical;

		const totalWidth = isVertical ? GAMEVIEW_WIDTH_VERTICAL : GAMEVIEW_WIDTH,
			totalHeight = isVertical ? GAMEVIEW_HEIGHT_VERTICAL : GAMEVIEW_HEIGHT;

		const maxRatio = Math.min(clientWidth / totalWidth, clientHeight / totalHeight);

		core.domStyle.availableScale = [];
		[1, 1.25, 1.5, 1.75, 2].forEach(function (v) {
			if (maxRatio >= v) {
				core.domStyle.availableScale.push(v);
			}
		});

		if (core.domStyle.availableScale.indexOf(core.domStyle.scale) < 0) {
			core.domStyle.scale = Math.min(1, maxRatio);
		} else if (core.getLocalStorage('scale') == null && core.domStyle.availableScale.length >= 2) {
			core.domStyle.scale = core.domStyle.availableScale[core.domStyle.availableScale.length - 2];
			core.setLocalStorage('scale', core.domStyle.scale);
		}

		const totalWidthScaled = totalWidth * core.domStyle.scale,
			totalHeightScaled = totalHeight * core.domStyle.scale;

		const gameDrawBox = isVertical ? { left: BORDER_WIDTH, top: BAR_HEIGHT_VERTICAL + BORDER_HEIGHT } : { left: BAR_WIDTH + BORDER_WIDTH, top: BORDER_HEIGHT };

		const obj = {
			clientWidth: clientWidth,
			clientHeight: clientHeight,
			canvasWidth: canvasWidth,
			totalWidth: totalWidthScaled,
			totalHeight: totalHeightScaled,
			gameDrawBox: gameDrawBox,
			globalAttribute: core.status.globalAttribute || core.initStatus.globalAttribute,
		};

		_resize_gameGroup(obj);
		_resize_canvas(obj);

		if (core.status.automaticRoute == null) core.status.automaticRoute = {};
		core.control.setViewport(32, 32);
		core.updateStatusBar();
	}

	class StatusBar {
		constructor() {
			this.itemMx = [
				["book", "wand", "fly"],
				["bomb", "fls", "pickaxe"],
				["downFly","earthquake","bigKey"],
			];
		}
		init() {
			this.toolbarAction = [
				[main.core.openKeyBoard, main.core.openQuickShop, function () { core.insertAction([{ type: "insert", name: "游戏说明" }]); } ],
				[main.core.save, main.core.load, main.core.openSettings]
			];
			this.replayAction = [
				[core.triggerReplay, core.stopReplay, core.rewindReplay],
				[core.speedDownReplay, core.speedUpReplay, core.saveReplay]
			];
		}
		update() {
			this._update_background();
			this._update_props();
			this._update_items();
			this._update_equips();
			this._update_keys();
			this._update_infoWindow();
			this._update_infoBar();
			this.update_itemBars();
			this.update_skills();
		}
		update_skills(){
			
			//我知道这有点蠢 但是算了吧 简化啥的之后再说
			//ITEM_BOX_LEFT + j * 33, posy = ITEM_BOX_TOP + i * 32
			var image = core.material.images.items
			
			//for (let i = 0; i < this.itemMx.length; i++)
			var iconList = [
				('sk1_'+core.getFlag('sk1',1)),
				('sk2_'+core.getFlag('sk2',1)),
				('sk3_'+core.getFlag('sk3',1))
			]
			var iconList2 = [
				'tishen','pain_keyin','I300'
			]
			//var icon1 = core.material.icons.items[core.getFlag('sk1',"sk1_1")],
			//	icon2 = core.material.icons.items[core.getFlag('sk2',"sk2_1")],
			//	icon3 = core.material.icons.items[core.getFlag('sk3',"sk3_1")]
			if(core.getFlag('sk1')===3&&core.getFlag('sk1_3')!=1&&core.hasFlag("sk1_3")){
				var iconList = [
				('sk1_3_'+core.getFlag('sk1_3',2)),
				('sk2_'+core.getFlag('sk2',1)),
				('sk3_'+core.getFlag('sk3',1))
			]
			}
			if(core.domStyle.isVertical){
				//定义：最左边x坐标为550
				//core.clearMap("outerUI")
				//const posx = ITEM_BOX_LEFT_VERTICAL + i * 29, posy = ITEM_BOX_TOP_VERTICAL + j * 28;
				//for (let i = 0; i < iconList.length; i++){
				//}
				//core.drawImage('outerUI', image, 0, 32 * icon1, 32,32, ITEM_BOX_LEFT_VERTICAL + 1 * 29, ITEM_BOX_TOP_VERTICAL + 1 * 28, 28, 28);
				//core.drawImage('outerUI', image, 0, 32 * icon2, 32,32, ITEM_BOX_LEFT_VERTICAL + 2 * 29, ITEM_BOX_TOP_VERTICAL + 2 * 28, 28, 28);
				//core.drawImage('outerUI', image, 0, 32 * icon3, 32,32, ITEM_BOX_LEFT_VERTICAL + 3 * 29, ITEM_BOX_TOP_VERTICAL + 3 * 28, 28, 28);
				core.clearMap("outerUI",145,550,95,95)
				for (let i = 0; i < iconList.length; i++){
					var unable = ''
					if(core.hasFlag(String('skill'+(i+1)+'CD'))||((i===2 && core.status.hero.mana < 4)||i==2 && core.getFlag('sk3',1)==4 && core.status.hero.mana < 6)){
						unable = 'b'
					}
					core.drawImage('outerUI', image, 0, 32 * core.material.icons.items[(iconList[i]+unable)], 32, 32, 145 + i * 34, 550, 32, 32);
				}
				for (let j = 0; j < iconList2.length; j++){
					var unable = ''
					if(j === 0 && (core.hasFlag('tishenCD')|| core.status.hero.mana === 0)){
					   unable = 'b'
					}
					core.drawImage('outerUI', image, 0, 32 * core.material.icons.items[(iconList2[j]+unable)], 32, 32, 145 + j * 34, 550+ 32 , 32, 32);
				}
				   }else{
				core.clearMap("outerUI",ITEM_BOX_LEFT,ITEM_BOX_TOP+ 4 * 32,99,64)
				for (let i = 0; i < iconList.length; i++){
					var unable = ''
					if(core.hasFlag(String('skill'+(i+1)+'CD'))||((i===2 && core.status.hero.mana < 4)||i==2 && core.getFlag('sk3',1)==4 && core.status.hero.mana < 6)){
						unable = 'b'
					}
					core.drawImage('outerUI', image, 0, 32 * core.material.icons.items[(iconList[i]+unable)], 32, 32, ITEM_BOX_LEFT + i * 33, ITEM_BOX_TOP+ 4 * 32 , 32, 32);
				}
				for (let j = 0; j < iconList2.length; j++){
					var unable = ''
					if(j === 0 && (core.hasFlag('tishenCD')|| core.status.hero.mana === 0)){
					   unable = 'b'
					}
					core.drawImage('outerUI', image, 0, 32 * core.material.icons.items[(iconList2[j]+unable)], 32, 32, ITEM_BOX_LEFT + j * 33, ITEM_BOX_TOP+ 5 * 32 , 32, 32);
				}
				//const posx = ITEM_BOX_LEFT + j * 33, posy = ITEM_BOX_TOP + i * 32;
				//core.drawImage('outerUI', image, 0, 32 * icon1, 32, 32, ITEM_BOX_LEFT, ITEM_BOX_TOP+ 4 * 32 , 32, 32);
				//core.drawImage('outerUI', image, 0, 32 * icon2, 32, 32, ITEM_BOX_LEFT + 1 * 33, ITEM_BOX_TOP + 4 * 32, 32, 32);
				//core.drawImage('outerUI', image, 0, 32 * icon3, 32, 32, ITEM_BOX_LEFT +2 * 33, ITEM_BOX_TOP+ 4 * 32 , 32, 32);
			}
			
			if(core.domStyle.isVertical){
				//core.clearMap("outerUI",145,550,95,65)
				//core.drawImage('outerUI', image, 0, 32 * core.material.icons.items[(iconList[i]+unable)], 32, 32, 145 + i * 33, 550, 32, 32);
			if(core.hasFlag('skill1CD')){
				core.fillText('outerUI', core.getFlag("skill1CD",0), 145 + 16, 550 +20, '#FFFF00', "bold 18px Verdana");
			}else if(core.hasFlag('sk1_3MovingTime')){
				core.fillText('outerUI', core.getFlag("sk1_3MovingTime",0), 145 + 16, 550 +20, '#00CCFF', "bold 18px Verdana");
			}
			if(core.getFlag('sk1',1)===2){
				core.fillText('outerUI', core.getFlag("sticks",0), 145 + 25, 550 +28, '#00CCFF', "bold 12px Verdana");
			}
			if(core.getFlag('sk2',1)===3){
				core.fillText('outerUI', core.getFlag("sltz3",0), 145 + 25+ 32, 550 +28, '#FFFF00', "bold 12px Verdana");
			}
			if(core.hasFlag('skill2CD')){
				core.fillText('outerUI', core.getFlag("skill2CD",0), 145+33+ 16, 550 +20, '#FFFF00', "bold 18px Verdana");
			}
			core.fillText('outerUI', core.getStatus("mana",0), 145 + 25, 550 +32+28, '#F43232', "bold 12px Verdana");
			if(core.hasFlag('mijuanCD')){
				core.fillText('outerUI', core.getFlag("mijuanCD",0), 145+33*2+ 16, 550 +21+32, '#FFFF00', "bold 18px Verdana");
			}
			if(core.hasFlag("tishenCD")){
			   core.fillText('outerUI', core.getFlag("tishenCD",0), 145 + 16, 550 +32+21, '#FFFF00', "bold 16px Verdana");
			}
			core.fillText('outerUI', core.getStatus('name'), 224, 543, '#FFFFFF', "9px Verdana");
				
			}else{
			if(core.getFlag('sk1',1)===2){
				core.fillText('outerUI', core.getFlag("sticks",0), ITEM_BOX_LEFT+ 25 , ITEM_BOX_TOP +32*4+28, '#00CCFF', "bold 12px Verdana");
			}
			if(core.getFlag('sk2',1)===3){
				core.fillText('outerUI', core.getFlag("sltz3",0), ITEM_BOX_LEFT+ 25+32 , ITEM_BOX_TOP +32*4+28, '#FFFF00', "bold 12px Verdana");
			}
			if(core.hasFlag('skill1CD')){
				core.fillText('outerUI', core.getFlag("skill1CD",0), ITEM_BOX_LEFT + 16, ITEM_BOX_TOP + 32*4+20, '#FFFF00', "bold 18px Verdana");
			}else if(core.hasFlag('sk1_3MovingTime')){
				core.fillText('outerUI', core.getFlag("sk1_3MovingTime",0), ITEM_BOX_LEFT + 16, ITEM_BOX_TOP + 32*4+20, '#00CCFF', "bold 18px Verdana");
			}
			if(core.hasFlag('skill2CD')){
				core.fillText('outerUI', core.getFlag("skill2CD",0), ITEM_BOX_LEFT +33+ 16, ITEM_BOX_TOP +32*4+20, '#FFFF00', "bold 18px Verdana");
			}
			if(core.hasFlag('mijuanCD')){
				core.fillText('outerUI', core.getFlag("mijuanCD",0), ITEM_BOX_LEFT +33*2+ 16, ITEM_BOX_TOP +32*5+20, '#FFFF00', "bold 18px Verdana");
			}
			core.fillText('outerUI', core.getStatus("mana",0), ITEM_BOX_LEFT + 25, ITEM_BOX_TOP +32*5+28, '#F43232', "bold 12px Verdana");
			if(core.hasFlag("tishenCD")){
			   core.fillText('outerUI', core.getFlag("tishenCD",0), ITEM_BOX_LEFT + 16, ITEM_BOX_TOP +32*5+21, '#FFFF00', "bold 16px Verdana");
			}
			core.fillText('outerUI', core.getStatus('name'), 90, 310, '#FFFFFF', "8px Verdana");
				
			}
			
		}
		update_itemBars() {
			this.itemMx = [
				["book", "wand", "fly"],
				["bomb", "fls", "pickaxe"],
				["downFly","earthquake","bigKey"],
			];
		}
		_update_background(updatedFloorTitle) {
			const bgctx = main.dom.outerBackground.getContext("2d");
			const uictx = main.dom.outerUI.getContext("2d");
			if (core.domStyle.isVertical) {
				bgctx.canvas.width = GAMEVIEW_WIDTH_VERTICAL;
				bgctx.canvas.height = GAMEVIEW_HEIGHT_VERTICAL;
				uictx.canvas.width = GAMEVIEW_WIDTH_VERTICAL;
				uictx.canvas.height = GAMEVIEW_HEIGHT_VERTICAL;
				const bg = core.material.images.images["statusBackground_vertical.png"];
				bgctx.drawImage(bg, 0,0, GAMEVIEW_WIDTH_VERTICAL, GAMEVIEW_HEIGHT_VERTICAL);
				//bgctx.fillRect(0, INFO_BAR_TOP_VERTICAL, GAMEVIEW_WIDTH, INFO_BAR_HEIGHT_VERTICAL);
				core.setTextAlign('outerUI', 'center');
			} else {
				bgctx.canvas.width = GAMEVIEW_WIDTH;
				bgctx.canvas.height = GAMEVIEW_HEIGHT;
				uictx.canvas.width = GAMEVIEW_WIDTH;
				uictx.canvas.height = GAMEVIEW_HEIGHT;
				const bg = core.material.images.images["statusBackground.jpg"];
				bgctx.drawImage(bg, 0, 0, GAMEVIEW_WIDTH, GAMEVIEW_HEIGHT - INFO_BAR_HEIGHT);
				//bgctx.fillStyle = null;
				//bgctx.fillRect(0, INFO_BAR_TOP, GAMEVIEW_WIDTH, INFO_BAR_HEIGHT);
				core.setTextAlign('outerUI', 'center');
			}
		}
		// 更新属性
		_update_props(updatedFloorTitle) {
			if (!updatedFloorTitle && core.status.floorId) {
				updatedFloorTitle = core.status.maps[core.status.floorId].title;
			}
			const statusList = ['hp', 'atk', 'def', 'money'];
			const drawStatusList = (baseX, baseY) => {
				let curh = baseY;
				core.setTextAlign('outerUI', 'right');
				statusList.forEach((item) => {
					// 四舍五入
					core.status.hero[item] = Math.round(core.status.hero[item]);
					// 大数据格式化
					core.fillText("outerUI", core.getRealStatus(item), baseX, curh, TEXT_COLOR);
					curh += 24;
				});
				core.setTextAlign('outerUI', 'center');
			};
			if (core.domStyle.isVertical) {
				//core.clearMap("outerUI", 10, 0, 105, 120);
				core.setFont("outerUI", 'bold 16px Verdana');
				if (updatedFloorTitle) {
					core.fillText("outerUI", updatedFloorTitle, 195, 122, TEXT_COLOR);
				}
				drawStatusList(96, 46);
			} else {
				core.clearMap("outerUI", 10, 40, 105, 130);
				core.setFont("outerUI", 'bold 16px Verdana');
				if (updatedFloorTitle) {
					core.fillText("outerUI", updatedFloorTitle, 62, 61, TEXT_COLOR);
				}
				drawStatusList(110, 93);
			}
		}
		_update_items(){
			const drawItemMx = (drawFn) => {
				for (let i = 0; i < this.itemMx.length; i++) {
					for (let j = 0; j < this.itemMx[i].length; j++) {
						var item = this.itemMx[i][j];
						drawFn(i, j, item);
					}
				}
			};
			const drawItem = (item, posx, posy) => {
				const icon = core.material.icons.items[item], image = core.material.images.items;
				if(core.domStyle.isVertical){
				   core.drawImage('outerUI', image, 0, 32 * icon, 32,32, posx, posy, 28, 28);
				   }else{
				core.drawImage('outerUI', image, 0, 32 * icon, 32, 32, posx, posy, 32, 32);
			}
				const cnt = core.itemCount(item);
				if ((core.items.items[item].cls === "tools" && cnt > 1) || FORCE_COUNTABLE_ITEMS.includes(item)) {
					core.fillText('outerUI', cnt, posx + 25, posy + 28, '#FFFFFF', "bold 12px Verdana");
				}
				// if (this.selectId == item)
				//     core.strokeRect('outerUI', posx + 17, posy - 4, 40, 40, '#FFD700');
			}
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", ITEM_BOX_LEFT_VERTICAL, ITEM_BOX_TOP_VERTICAL, 105, 86);
				drawItemMx((i, j, item) => {
					if (core.hasItem(item)) {
						const posx = ITEM_BOX_LEFT_VERTICAL + i * 29, posy = ITEM_BOX_TOP_VERTICAL + j * 28;
						drawItem(item, posx, posy);
					}
				});
			} else {
				core.clearMap("outerUI", ITEM_BOX_LEFT, ITEM_BOX_TOP, 105, 185);
				drawItemMx((i, j, item) => {
					if (core.hasItem(item)) {
						const posx = ITEM_BOX_LEFT + j * 33, posy = ITEM_BOX_TOP + i * 32;
						drawItem(item, posx, posy);
					}
				});
			}
		}
		_update_equips() {
			core.setFont("outerUI", 'bold 16px Verdana');
			const drawEquip = (baseX, baseY, id, color, back) => {
				if (!id) core.fillText("outerUI", back, baseX + 50, baseY + 22, color);
				else {
					core.fillText("outerUI", core.material.items[id].name, baseX + 32, baseY + 22, color);
					var icon = core.material.icons.items[id];
					core.drawImage('outerUI', core.material.images.items, 0, 32 * icon, 32, 32, baseX + 64, baseY, 32, 32);
				}
			};
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL, 105, 95);
				drawEquip(EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL + 9, core.getFlag("nowWeapon"), "#FFCFAE", "无武器");
				drawEquip(EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL + 56, core.getFlag("nowShield"), "#D1CEFF", "无防具");
			} else {
				core.clearMap("outerUI", EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP, 105, 95);
				drawEquip(EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP + 8, core.getFlag("nowWeapon"), "#FFCFAE", "无武器");
				drawEquip(EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP + 59, core.getFlag("nowShield"), "#D1CEFF", "无防具");
			}
		}
		_update_keys() {
			const drawKeyList = (baseX, baseY, lines, rows) => {
				const todraw = [], keyList = ['yellowKey', 'blueKey', 'redKey'];
				let total = 0;
				keyList.forEach(function (key, i) {
					todraw[i] = core.itemCount(key);
					total += todraw[i];
				});
				if (total > lines * rows) {
					let dn = 2;
					if (!core.domStyle.isVertical){
						for (let i = 0; i <= dn; i++) {
						let deltaX = i * 32, deltaY = parseInt((lines - 1) / 2 * 14);
						this.drawKey(keyList[i], baseX + deltaX, baseY + deltaY);
						core.setFont("outerUI", 'bold 14px Verdana');
						core.setTextAlign("outerUI", "left");
						core.fillText("outerUI", todraw[i], baseX + deltaX + 10, baseY + deltaY + 20, TEXT_COLOR);
					}}else{
						for (let i = 0; i < 3; i++){
						this.drawKey(keyList[i], baseX , baseY + 32*i);
						core.setFont("outerUI", 'bold 14px Verdana');
						core.setTextAlign("outerUI", "left");
						core.fillText("outerUI", todraw[i], baseX + 10, baseY + 32*i+ 16, TEXT_COLOR);
						}
					}
				} else {
					let dn = 2, dc = 0;
					while (dn >= 0 && dc < lines * rows) {
						if (todraw[dn]) {
							this.drawKey(keyList[dn], baseX + (dc % rows) * 14, baseY + parseInt(dc / rows) * 17);
							todraw[dn]--, dc++;
						} else dn--;
					}
				}
			};
			if (core.domStyle.isVertical) {
				//core.clearMap("outerUI", KEY_BLOCK_LEFT_VERTICAL, KEY_BLOCK_TOP_VERTICAL, 105, 75);
				drawKeyList(KEY_BLOCK_LEFT_VERTICAL + 3, KEY_BLOCK_TOP_VERTICAL + 2, 6, 2);
			} else {
				//core.clearMap("outerUI", KEY_BLOCK_LEFT, 140, 105, 75);
				drawKeyList(KEY_BLOCK_LEFT + 3, 142, 3, 7);
			}
		}
		drawKey(key, x, y) {
			let sx = 3, sy = 0;
			if (key == "blueKey") sx += 16;
			else if (key == "yellowKey") sy += 16;
			core.drawImage("outerUI", core.statusBar.icons.keys, sx, sy, 10, 16, x, y, 10, 16);
		}
		_update_infoWindow() {
			const itemId = this.selectedItem;
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", INFO_BLOCK_LEFT_VERTICAL, INFO_BLOCK_TOP_VERTICAL, 100, 110);
				if (this.selectedItem) {
					const icon = core.material.icons.items[itemId];
					core.fillText("outerUI", core.material.items[itemId].name, INFO_BLOCK_LEFT_VERTICAL+25, INFO_BLOCK_TOP_VERTICAL +20, "#D1CEFF","bold 16px Verdana");
					core.drawImage('outerUI', core.material.images.items, 0, 32 * icon, 32, 32, INFO_BLOCK_LEFT_VERTICAL+60, INFO_BLOCK_TOP_VERTICAL, 32, 32);
					core.ui.drawTextContent("outerUI", core.material.items[itemId].text, {
						left: INFO_BLOCK_LEFT_VERTICAL ,
						top: INFO_BLOCK_TOP_VERTICAL + 30,
						maxWidth: 100,
						color: "#D1CEFF"
					});
				}
			} else {
				core.clearMap("outerUI", INFO_BLOCK_LEFT, INFO_BLOCK_TOP, 105, 100);
				if (this.selectedItem) {
					const icon = core.material.icons.items[itemId];
					core.fillText("outerUI", core.material.items[itemId].name, INFO_BLOCK_LEFT + 32, INFO_BLOCK_TOP + 25, "#D1CEFF","bold 16px Verdana");
					core.drawImage('outerUI', core.material.images.items, 0, 32 * icon, 32, 32, INFO_BLOCK_LEFT + 64, INFO_BLOCK_TOP + 4, 32, 32);
					core.ui.drawTextContent("outerUI", core.material.items[itemId].text, {
						left: INFO_BLOCK_LEFT + 1,
						top: INFO_BLOCK_TOP + 36,
						maxWidth: 105,
						color: "#D1CEFF"
					});
				}
			}
		}
		showItemInfo(itemId) {
			this.selectedItem = itemId;
			this._update_infoWindow();
		}
		clearItemInfo() {
			this.selectedItem = null;
			this._update_infoWindow();
		}
		_update_toolBox() {
			if (core.domStyle.isVertical){
			var tools = core.isReplaying() ?
				[
					[core.status.replay.pausing ? "play" : "pause", "speedDown"],
					["stop", "speedUp"],
					["rewind","save"],
				] : [
					["keyboard", "save"],
					["shop", "load"],
					["help","settings"],
				];	
			}else{
			var tools = core.isReplaying() ?
				[
					[core.status.replay.pausing ? "play" : "pause", "stop", "rewind"],
					["speedDown", "speedUp", "save"],
				] : [
					["keyboard", "shop", "help"],
					["save", "load", "settings"],
				];}
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", TOOL_BOX_LEFT_VERTICAL, TOOL_BOX_TOP_VERTICAL, 115, 80);
				for (let i = 0; i < tools.length; i++) {
					for (let j = 0; j < tools[i].length; j++) {
						core.drawIcon("outerUI", tools[i][j], TOOL_BOX_LEFT_VERTICAL + j * 32, TOOL_BOX_TOP_VERTICAL + i * 32, 30, 30);
					}
				}
			} else {
				core.clearMap("outerUI", TOOL_BOX_LEFT, TOOL_BOX_TOP, 115, 80);
				for (let i = 0; i < tools.length; i++) {
					for (let j = 0; j < tools[i].length; j++) {
						core.drawIcon("outerUI", tools[i][j], TOOL_BOX_LEFT + j * 34, TOOL_BOX_TOP + i * 34, 32, 32);
					}
				}
			}
		}
		onclick(x, y) {
			const makeBox = ([x, y], [w, h]) => {
				return [[x, y], [x + w, y + h]];
			}
			const gridify = ([x, y], [gw, gh]) => {
				return [parseInt(x / gw), parseInt(y / gh)];
			}
			const useItem = (itemId) => {
				if (!core.hasItem(itemId)) return;
				if (core.material.items[itemId].cls == "constants") {
					switch (itemId) {
						case "book":
							core.openBook(true);
							break;
						case "fly":
							core.useFly(true);
							break;
						case "wand":
							core.insertAction({
								type: "useItem",
								id: itemId
							});
							break;
						case "snow":
							core.useItem("snow");
							break;
						default:
							this.showItemInfo(itemId);
					}
				} else if (itemId != this.selectedItem) {
					this.showItemInfo(itemId);
				} else {
					switch (itemId) {
						case "centerFly":
							core.ui._drawCenterFly();
							break;
						default:
							core.useItem(itemId);
					}
				}
			}
			const inRect = ([x, y], [[sx, sy], [dx, dy]]) => {
				return sx <= x && x <= dx && sy <= y && y <= dy;
			};
			const relativeTo = ([x, y], [ax, ay]) => {
				return [x - ax, y - ay];
			}
			const pos = [x, y];
			if (core.domStyle.isVertical) {
				const itemBox = makeBox([ITEM_BOX_LEFT_VERTICAL, ITEM_BOX_TOP_VERTICAL], [32 * 5, 33 * 3]);
				if (inRect(pos, itemBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					const [gx, gy] = gridify(relativeTo(pos, itemBox[0]), [32, 33]);
					const itemId = this.itemMx[gx][gy];
					useItem(itemId);
					return;
				}
				const toolBox = makeBox([TOOL_BOX_LEFT_VERTICAL, TOOL_BOX_TOP_VERTICAL], [34 * 3, 34 * 2]);
				if (inRect(pos, toolBox)) {
					const [row, col] = gridify(relativeTo(pos, toolBox[0]), [34, 34]);
					if (core.isReplaying()) {
						this.replayAction[col][row].call(core);
					} else if (core.isPlaying()) {
						this.toolbarAction[col][row].call(core, true);
					}
					return;
				}
				
				//skills自绘的触摸
				//core.drawImage('outerUI', image, 0, 32 * core.material.icons.items[(iconList[i]+unable)], 32, 32, 145 + i * 34, 550, 32, 32);
				//const skillBox = makeBox([])
				const skillBox = makeBox([145,550],[33 * 3, 64])
				if (inRect(pos, skillBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					const [gx, gy] = gridify(relativeTo(pos, skillBox[0]), [33, 32]);
					if(gy===0){
						core.useSkill(gx+1,core.getFlag(String('sk'+(gx+1)),1),core.getFlag('time',1))
					}else{
						if(gx===0){
							core.tishen()
						}else if (gx===1){
							
							
							core.insertCommonEvent('刻印选择')
						}else{
							
							core.insertCommonEvent('密卷')
							
						}
							  }
					return;
				}
				
			} else {
				const itemBox = makeBox([ITEM_BOX_LEFT, ITEM_BOX_TOP], [33 * 3, 32 * 4]);
				if (inRect(pos, itemBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					const [gx, gy] = gridify(relativeTo(pos, itemBox[0]), [33, 32]);
					const itemId = this.itemMx[gy][gx];
					useItem(itemId);
					return;
				}
				const toolBox = makeBox([TOOL_BOX_LEFT, TOOL_BOX_TOP], [34 * 3, 34 * 2]);
				if (inRect(pos, toolBox)) {
					const [row, col] = gridify(relativeTo(pos, toolBox[0]), [34, 34]);
					if (core.isReplaying()) {
						this.replayAction[col][row].call(core);
					} else if (core.isPlaying()) {
						this.toolbarAction[col][row].call(core, true);
					}
					return;
				}
				
				//skills自绘的触摸
				
				//const makeBox = ([x, y], [w, h]) => {
				//return [[x, y], [x + w, y + h]];
				
				//const relativeTo = ([x, y], [ax, ay]) => {
				//return [x - ax, y - ay];}
				
				//const gridify = ([x, y], [gw, gh]) => {
				//return [parseInt(x / gw), parseInt(y / gh)];}
				
				//pos即触摸坐标
				const skillBox = makeBox([ITEM_BOX_LEFT,ITEM_BOX_TOP + 4*32],[33 * 3, 64])
				if (inRect(pos, skillBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					const [gx, gy] = gridify(relativeTo(pos, skillBox[0]), [33, 32]);
					if(gy===0){
						core.useSkill(gx+1,core.getFlag(String('sk'+(gx+1)),1),1)
					}else{
						if(gx===0){
							core.tishen()
						}else if (gx===1){
							
							core.insertCommonEvent('刻印选择')
						}else{
							
							core.insertCommonEvent('密卷')
							
						}
							  }
					return;
				}
			}
		}
		infoText;
		infocnt = 0;
		_update_infoBar() {
			core.setTextAlign('outerUI', 'left');
			const text = this.infoText;
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", 0, INFO_BAR_TOP_VERTICAL, 140, 70);
				core.setFont("outerUI", 'bold 14px Verdana');
				if (text) {
					core.ui.drawTextContent("outerUI",text, {
						left: 25 ,
						top: INFO_BAR_TOP_VERTICAL,
						maxWidth: 100,
						color:  TEXT_COLOR,
						font : "Bold Verdana"
					});
					//core.fillText("outerUI", text, 10, INFO_BAR_TOP_VERTICAL, TEXT_COLOR);
				}
			} else {
				core.clearMap("outerUI", 0, INFO_BAR_TOP, GAMEVIEW_WIDTH, INFO_BAR_HEIGHT);
				core.setFont("outerUI", 'bold 16px Verdana');
				if (text) {
					core.fillText("outerUI", text, 10, INFO_BAR_TOP + 16, TEXT_COLOR);
				}
			}
			core.setTextAlign('outerUI', 'center');
		}
		print(text, cnt = 1) {
			this.infoText = text;
			this.infocnt = cnt;
			this._update_infoBar();
		}
		static infoRules = [
			{ id: "lava", text: "岩浆好热啊!" },
			{ id: "upFloor", text: "你看到了楼梯" },
			{ id: "downFloor", text: "你看到了楼梯" },
			{ id: "blueShop", text: "你看到了一个祭坛" },
			{ id: "man", text: "你看到了一个老人" },
			{ id: "woman", text: "你看到了一个商人" },
			{ id: "fairy", text: "你看到了一个商人" },
			{ id: "thief", text: "你看到了一个小偷" },
		]
		printEnvironmentInfo() {
			if (!this.infocnt) {
				return;
			}
			const ids = [];
			for (const block of core.status.thisMap.blocks) {
				if (!block.disable && core.nearHero(block.x, block.y)) ids.push(block.event.id);
			}
			for (const infoRule of StatusBar.infoRules) {
				if (ids.indexOf(infoRule.id) >= 0) {
					this.print(infoRule.text);
					return;
				}
			}
		}
		clearInfo(etype) {
			this.clearItemInfo();
			if (this.infocnt == 1) {
				setTimeout(() => {
					if (this.infocnt === 0) {
						this.infoText = void 0;
						this._update_infoBar();
					}
				}, 200);
				this.infocnt = 0;
			} else if (this.infocnt > 1) {
				this.infocnt--;
			}
		}
	}

	core.ui.statusBar = new StatusBar();

	core.control.clearStatusBar = function () {
		core.clearMap("outerUI");
	}
	// init() called in `afterLoadResources`.
},
    "override": function () {

	core.statusBar.icons = {
		'floor': 0,
		'name': null,
		'lv': 1,
		'hpmax': 2,
		'hp': 3,
		'atk': 4,
		'def': 5,
		'mdef': 6,
		'money': 7,
		'experience': 8,
		'up': 9,
		'book': 10,
		'fly': 11,
		'toolbox': 12,
		'keyboard': 13,
		'shop': 14,
		'save': 15,
		'load': 16,
		'settings': 17,
		'play': 18,
		'pause': 19,
		'stop': 20,
		'speedDown': 21,
		'speedUp': 22,
		'rewind': 23,
		'equipbox': 24,
		'mana': 25,
		'skill': 26,
		'paint': 27,
		'erase': 28,
		'empty': 29,
		'exit': 30,
		'btn1': 31,
		'btn2': 32,
		'btn3': 33,
		'btn4': 34,
		'btn5': 35,
		'btn6': 36,
		'btn7': 37,
		'btn8': 38,
		'keys': 39,
		'help': 40,
		'battle': 41
	};



	var _clickSL = core.actions._clickSL;
	core.actions._clickSL = function (x, y) {
		var page = core.status.event.data.page,
			offset = core.status.event.data.offset;
		var index = page * 10 + offset;

		// 上一页
		if ((x == this.HSIZE - 1 || x == this.HSIZE - 2) && y == this.LAST) {
			core.ui._drawSLPanel(10 * (page - 1) + offset);
			return;
		}
		// 下一页
		if ((x == this.HSIZE + 1 || x == this.HSIZE + 2) && y == this.LAST) {
			core.ui._drawSLPanel(10 * (page + 1) + offset);
			return;
		}
		if ((x == this.HSIZE - 3 || x == this.HSIZE + 3) && y == this.LAST) {
			return;
		}
		_clickSL.call(this, x, y);
	}

	var _sys_longClick_lockControl = core.actions._sys_longClick_lockControl;
	core.actions._sys_longClick_lockControl = function (x, y) {
		if (!core.status.lockControl) return false;

		// 长按SL上下页快速翻页
		if (["save", "load", "replayLoad", "replayRemain"].indexOf(core.status.event.id) >= 0) {
			if (y == this.LAST && x <= this.HSIZE + 3 && x >= this.HSIZE - 3) {
				core.actions._clickSL(x, y);
				return true;
			}
		}
		return _sys_longClick_lockControl.call(this, x, y);
	}
	core.registerAction('longClick', '_sys_longClick_lockControl', core.actions._sys_longClick_lockControl, 50);

	//对不起我从星趴塔抄的请不要杀我m(>_<)m
	events.prototype._sys_battle = function (data, callback) {
		if (core.hasFlag("tishenTime")) return
		// 检查战前事件
		var beforeBattle = []
		core.push(beforeBattle, core.floors[core.status.floorId].beforeBattle[data.x + ',' + data.y])
		core.push(beforeBattle, (core.material.enemys[data.event.id] || {}).beforeBattle)
		if (beforeBattle.length > 0) {
			core.push(beforeBattle, [{ type: 'battle', x: data.x, y: data.y }])
			core.clearContinueAutomaticRoute()

			// 自动存档
			var inAction = core.status.event.id == 'action'
			if (inAction) {
				core.insertAction(beforeBattle, data.x, data.y)
				core.doAction()
			} else {
				core.autosave(true)
				core.insertAction(beforeBattle, data.x, data.y, callback)
			}
		} else {
			this.battle(data.event.id, data.x, data.y, false, callback)
		}
	}
	events.prototype.battle = function (id, x, y, force, callback) {
		core.saveAndStopAutomaticRoute();
		id = id || core.getBlockId(x, y);
		const cls = core.getClsFromId(id);
		if (!id || !cls || !(cls === 'enemys' || cls === 'enemy48')) return core.clearContinueAutomaticRoute(callback);
		if (!id) return core.clearContinueAutomaticRoute(callback);

		// 非强制战斗
		//if (!core.enemys.canBattle(id, x, y) && !force && !core.status.event.id && !["SeaGawu", "LionGawu", "ADMasao", "SOMasao", "Masao"].includes(id)) {
		//	core.stopSound();
		//	core.drawTip("你打不过此怪物！", id);
		//	return core.clearContinueAutomaticRoute(callback);
		//}

		// 自动存档
		if (!core.status.event.id && !flags.jianqi) core.autosave(true);
		// 战前事件
		if (!this.beforeBattle(id, x, y))
			return core.clearContinueAutomaticRoute(callback);
		// 战后事件

		this.afterBattle(id, x, y, callback)
	}

	//抄完了

	core.control._moveHero_moving = function () {
		core.status.heroStop = false;
		core.status.automaticRoute.moveDirectly = false;
		var move = function () {
			if (!core.status.heroStop) {
				if (core.hasFlag('debug') && core.status.ctrlDown) {
					if (core.status.heroMoving != 0) return;
					// 检测是否穿出去
					var nx = core.nextX(),
						ny = core.nextY();
					if (nx < 1 || nx >= core.bigmap.width - 1 || ny < 1 || ny >= core.bigmap.height - 1) return;
					core.eventMoveHero([core.getHeroLoc('direction')], core.values.moveSpeed, move);
				} else {
					core.moveAction();
					setTimeout(move, 50);
				}
			}
		}
		move();
	}

	core.control._drawHero_updateViewport = function (x, y, offset) {}

	var _drawThumbnail_drawTempCanvas = core.maps._drawThumbnail_drawTempCanvas;
	core.maps._drawThumbnail_drawTempCanvas = function (floorId, blocks, options) {
		if (main.mode == 'editor') {
			_drawThumbnail_drawTempCanvas.call(this, floorId, blocks, options);
			return;
		}

		var width = core.floors[floorId].width;
		var height = core.floors[floorId].height;
		// 绘制到tempCanvas上面
		var tempCanvas = core.bigmap.tempCanvas;
		options.v2 = false;
		tempCanvas.canvas.width = width * 32;
		tempCanvas.canvas.height = height * 32;
		options.ctx = tempCanvas;

		var hasHero = core.status.hero != null,
			flags = null;
		if (options.flags) {
			if (!hasHero) core.status.hero = {};
			flags = core.status.hero.flags;
			core.status.hero.flags = options.flags;
		}
		this._drawThumbnail_realDrawTempCanvas(floorId, blocks, options);

		if (!hasHero) delete core.status.hero;
		else if (flags != null) core.status.hero.flags = flags;
		tempCanvas.setTransform(1, 0, 0, 1, 0, 0);
	}

	var _drawThumbnail_drawToTarget = core.maps._drawThumbnail_drawToTarget;
	core.maps._drawThumbnail_drawToTarget = function (floorId, options) {
		if (main.mode == 'editor') {
			_drawThumbnail_drawToTarget.call(this, floorId, options);
			return;
		}

		var ctx = core.getContextByName(options.ctx);
		if (ctx == null) return;
		var x = options.x || 0,
			y = options.y || 0,
			size = options.size || core.__PIXELS__;
		var tempCanvas = core.bigmap.tempCanvas;
		core.drawImage(ctx, tempCanvas.canvas, 32, 32, core.__PIXELS__, core.__PIXELS__, x, y, size, size);
	}

	var _drawWindowSkin = core.ui.drawWindowSkin;
	core.ui.drawWindowSkin = function (background, ctx, x, y, w, h, direction, px, py) {
		_drawWindowSkin.call(this, background, ctx, x, y, w, h, direction, px, py);

		var c = parseInt(w / 2);
		core.drawImage(ctx, background, 160, 90, 16, 6, x + c - 8, y, 16, 6);
	}

	var _drawPagination = ui.prototype.drawPagination;
	core.ui.drawPagination = function (page, totalPage, y) {
		if (["save", "load", "replayLoad", "replayRemain", "replaySince"].indexOf(core.status.event.id) >= 0) {
			if (totalPage <= 1) return;
			if (y == null) y = this.LAST;

			core.setFillStyle('ui', '#DDDDDD');
			var length = core.calWidth('ui', page, this._buildFont(15, true));

			core.setTextAlign('ui', 'left');
			core.fillText('ui', page, parseInt((this.PIXEL - length) / 2), y * 32 + 19);

			core.setTextAlign('ui', 'center');
			if (page > 1)
				core.fillText('ui', '上一页', this.HPIXEL - 48, y * 32 + 19);
			if (page < totalPage)
				core.fillText('ui', '下一页', this.HPIXEL + 48, y * 32 + 19);
			return;
		}
		_drawPagination.call(this, page, totalPage, y);
	}

	core.ui.drawHelp = function () {
		core.clearUI();
		core.status.event.id = 'help';
		core.lockControl();
		core.setAlpha('ui', 1);
		core.fillRect('ui', 0, 0, this.PIXEL, this.PIXEL, '#FFFFFF');
		core.drawImage('ui', core.material.images.keyboard, 0, 0, 416, 416, 0, 0, 352, 352);
	}

	core.actions._getClickLoc = function (x, y) {
		var size = 32 * core.domStyle.scale;
		var left = main.dom.gameDraw.offsetLeft + main.dom.gameGroup.offsetLeft;
		var top = main.dom.gameDraw.offsetTop + main.dom.gameGroup.offsetTop;
		var loc = { 'x': Math.max(x - left, 0), 'y': Math.max(y - top, 0), 'size': size };
		return loc;
	}

	core.enemys.getDamageString = function (enemy, x, y, floorId) {
		if (typeof enemy == 'string') enemy = core.material.enemys[enemy];
		var damage = this.getDamage(enemy, x, y, floorId);

		var color = '#000000';

		if (damage == null) {
			damage = "???";
			color = '#FF2222';
		} else if (core.hasFlag('shield2Time')) {
			damage = '封术吸印';
			color = '#00CCFF';
		} else {
			if (core.hasFlag('addhp')) {
				if (damage < core.status.hero.hp) color = '#11FF11';
				else color = '#FF2222';
			} else if (damage <= 0) color = '#11FF11';
			else if (damage < core.status.hero.hp / 3) color = '#FFFFFF';
			else if (damage < core.status.hero.hp * 2 / 3) color = '#FFFF00';
			else if (damage < core.status.hero.hp) color = '#FF9933';
			else color = '#FF2222';

			damage = core.formatBigNumber(damage, true);
			if (core.enemys.hasSpecial(enemy, 19))
				damage += "+";
			if (core.enemys.hasSpecial(enemy, 21))
				damage += "-";
			if (core.enemys.hasSpecial(enemy, 11))
				damage += "^";
		}

		return {
			"damage": damage,
			"color": color
		};
	}

	core.ui._drawBook_drawDamage = function (index, enemy, offset, position) {
		core.setTextAlign('ui', 'center');
		var damage = enemy.damage,
			color = '#FFFF00';
		if (damage == null) {
			damage = '不可攻击';
			color = '#FF2222';
		}
		if (damage == 0) {
			damage = '无危险';
			color = '#11FF11';
		} else {
			if (damage >= core.status.hero.hp) color = '#FF2222';
			else if (damage >= core.status.hero.hp * 2 / 3) color = '#FF9933';
			else if (damage <= 0) color = '#11FF11';
			damage = core.formatBigNumber(damage);
			if (core.enemys.hasSpecial(enemy, 19)) damage += "+";
			if (core.enemys.hasSpecial(enemy, 21)) damage += "-";
			if (core.enemys.hasSpecial(enemy, 11)) damage += "^";
		}
		if (enemy.notBomb) damage += "[b]";
		core.fillText('ui', damage, offset, position, color, this._buildFont(13, true));
	}

	core.control.checkBlock = function () {
		var x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y'),
			loc = x + "," + y;
		var damage = core.status.checkBlock.damage[loc];
		if (damage) {
			core.status.hero.hp -= damage;
			core.drawTip("你受到了 " + damage + " 点魔法伤害");
			core.playSound('zone.mp3');
			core.setFlag('tishen', true)
			this._checkBlock_disableQuickShop();
			core.status.hero.statistics.extraDamage += damage;
			if (core.status.hero.hp <= 0) {
				core.status.hero.hp = 0;
				core.updateStatusBar();
				core.events.lose();
				return;
			} else {
				core.updateStatusBar();
			}
		}
		this._checkBlock_ambush(core.status.checkBlock.ambush[loc]);
		this._checkBlock_repulse(core.status.checkBlock.repulse[loc]);
	}

	core.registerSystemEvent("man", function (data, callback) {
		var a = parseInt(core.status.floorId.substring(2));
		var b = core.nextX();
		var c = core.nextY();
		core.insertAction([
			{ "type": "insert", "name": "对话", "args": [a, b, c, 0] },
		]);
		//console.log(data);
		if (callback) callback();
	});

	core.registerSystemEvent("woman", function (data, callback) {
		var name = core.status.floorId + '@' + core.nextX() + '@' + core.nextY() + '@' + 'A';
		if (core.getFlag(name, 0) == 1) {
			var a = parseInt(core.status.floorId.substring(2));
			var b = core.nextX();
			var c = core.nextY();
			core.insertAction([
				{ "type": "insert", "name": "对话", "args": [a, b, c, 1] },
			]);
		} else {
			core.insertAction([
				{ "type": "insert", "name": "商人", "args": [0] },
			]);
		}
		//console.log(data);
		if (callback) callback();
	});

	core.registerSystemEvent("specialwall", function (data, callback) {
		if (data.event.id == 'whiteWall' || core.getFlag('talking') > 0) {
			core.insertAction({ 'type': 'openDoor', loc: [data.x, data.y] });
			if (data.event.id != 'whiteWall') {
				core.setFlag('end', 1);
			}
			core.setFlag('talking', 0); //穿墙之后不能再次穿墙
		}
		//console.log(data);
		if (callback) callback();
	});

	core.registerSystemEvent("fakeWall", function (data, callback) {
		if (data.event.id == 'blueWall') {
			core.insertAction([
				{ "type": "openDoor", loc: [data.x, data.y] },
			]);
		}
		//console.log(data);
		if (callback) callback();
	});

	core.ui._drawWindowSelector = function (background, x, y, w, h) {
		w = Math.round(w) + 48;
		h = Math.round(h);
		var ctx = core.ui.createCanvas("_selector", x - 24, y, w, h, 165);
		ctx.canvas.id = '';
		this._drawSelector(ctx, background, w, h);
	}

	core.ui._drawSelector = function (ctx, background, w, h, left, top) {
		left = left || 0;
		top = top || 0;
		ctx = this.getContextByName(ctx);
		if (!ctx) return;
		if (typeof background == 'string')
			background = core.material.images.images[background];
		if (!(background instanceof Image)) return;
		// badge
		ctx.drawImage(background, 132, 68, 24, 24, left + 4, top + 4, 24, 24);
		ctx.drawImage(background, 132, 68, 24, 24, w - left - 28, top + 4, 24, 24);
	}

	core.ui.drawTip = function (text, id, clear) {
		core.ui.statusBar.print(text);
	}

	core.ui.clearMap = function (name, x, y, width, height) {
		if (name == 'all') {
			for (var m in core.canvas) {
				core.canvas[m].clearRect(0, 0, core.bigmap.width * 32, core.bigmap.height * 32);
			}
			core.clearMap("outerUI");
			core.dom.gif.innerHTML = "";
			core.removeGlobalAnimate();
		} else {
			var ctx = this.getContextByName(name);
			if (ctx) ctx.clearRect(x || 0, y || 0, width || ctx.canvas.width, height || ctx.canvas.height);
		}
	}

	core.control._updateStatusBar_setToolboxIcon = function () {
		core.ui.statusBar._update_toolBox();
	}

	var _changeFloor_getInfo = core.events._changeFloor_getInfo;
	core.events._changeFloor_getInfo = function (floorId, stair, heroLoc, time) {
		var info = _changeFloor_getInfo.call(this, floorId, stair, heroLoc, time);
		if (info == null) return null;
		info.time = 0;
		info.origin = floorId;
		return info;
	}

	core.events._changeFloor_afterChange = function (info, callback) {
		if (!info.locked) core.unlockControl();
		core.status.replay.animate = false;
		core.events.afterChangeFloor(info.floorId);

		if (info.origin == ':before') core.ui.statusBar.print('走下了楼梯')
		else if (info.origin == ':next') core.ui.statusBar.print('登上了楼梯')
		if (callback) callback();
	}

	if (window.jsinterface && window.jsinterface.requestLandscape) {
		window.jsinterface.requestLandscape();
	}
},
    "shop": function () {
	// 【全局商店】相关的功能
	// 
	// 打开一个全局商店
	// shopId：要打开的商店id；noRoute：是否不计入录像
	this.openShop = function (shopId, noRoute) {
		var shop = core.status.shops[shopId];
		// Step 1: 检查能否打开此商店
		if (!this.canOpenShop(shopId)) {
			core.drawTip("该商店尚未开启");
			return false;
		}

		// Step 2: （如有必要）记录打开商店的脚本事件
		if (!noRoute) {
			core.status.route.push("shop:" + shopId);
		}

		// Step 3: 检查道具商店 or 公共事件
		if (shop.item) {
			if (core.openItemShop) {
				core.openItemShop(shopId);
			} else {
				core.playSound('操作失败');
				core.insertAction("道具商店插件不存在！请检查是否存在该插件！");
			}
			return;
		}
		if (shop.commonEvent) {
			core.insertCommonEvent(shop.commonEvent, shop.args);
			return;
		}

		_shouldProcessKeyUp = true;

		// Step 4: 执行标准公共商店    
		core.insertAction(this._convertShop(shop));
		return true;
	}

	////// 将一个全局商店转变成可预览的公共事件 //////
	this._convertShop = function (shop) {
		return [
			{ "type": "function", "function": "function() {core.addFlag('@temp@shop', 1);}" },
			{
				"type": "while",
				"condition": "true",
				"data": [
					// 检测能否访问该商店
					{
						"type": "if",
						"condition": "core.isShopVisited('" + shop.id + "')",
						"true": [
							// 可以访问，直接插入执行效果
							{ "type": "function", "function": "function() { core.plugin._convertShop_replaceChoices('" + shop.id + "', false) }" },
						],
						"false": [
							// 不能访问的情况下：检测能否预览
							{
								"type": "if",
								"condition": shop.disablePreview,
								"true": [
									// 不可预览，提示并退出
									{ "type": "playSound", "name": "操作失败" },
									"当前无法访问该商店！",
									{ "type": "break" },
								],
								"false": [
									// 可以预览：将商店全部内容进行替换
									{ "type": "tip", "text": "当前处于预览模式，不可购买" },
									{ "type": "function", "function": "function() { core.plugin._convertShop_replaceChoices('" + shop.id + "', true) }" },
								]
							}
						]
					}
				]
			},
			{ "type": "function", "function": "function() {core.addFlag('@temp@shop', -1);}" }
		];
	}

	this._convertShop_replaceChoices = function (shopId, previewMode) {
		var shop = core.status.shops[shopId];
		var choices = (shop.choices || []).filter(function (choice) {
			if (choice.condition == null || choice.condition == '') return true;
			try { return core.calValue(choice.condition); } catch (e) { return true; }
		}).map(function (choice) {
			var ableToBuy = core.calValue(choice.need);
			return {
				"text": choice.text,
				"icon": choice.icon,
				"color": ableToBuy && !previewMode ? choice.color : [153, 153, 153, 1],
				"action": ableToBuy && !previewMode ? [{ "type": "playSound", "name": "商店" }].concat(choice.action) : [
					{ "type": "playSound", "name": "操作失败" },
					{ "type": "tip", "text": previewMode ? "预览模式下不可购买" : "购买条件不足" }
				]
			};
		}).concat({ "text": "离开", "action": [{ "type": "playSound", "name": "取消" }, { "type": "break" }] });
		core.insertAction({ "type": "choices", "text": shop.text, "choices": choices });
	}

	/// 是否访问过某个快捷商店
	this.isShopVisited = function (id) {
		if (!core.hasFlag("__shops__")) core.setFlag("__shops__", {});
		var shops = core.getFlag("__shops__");
		if (!shops[id]) shops[id] = {};
		return shops[id].visited;
	}

	/// 当前应当显示的快捷商店列表
	this.listShopIds = function () {
		return Object.keys(core.status.shops).filter(function (id) {
			return core.isShopVisited(id) || !core.status.shops[id].mustEnable;
		});
	}

	/// 是否能够打开某个商店
	this.canOpenShop = function (id) {
		if (this.isShopVisited(id)) return true;
		var shop = core.status.shops[id];
		if (shop.item || shop.commonEvent || shop.mustEnable) return false;
		return true;
	}

	/// 启用或禁用某个快捷商店
	this.setShopVisited = function (id, visited) {
		if (!core.hasFlag("__shops__")) core.setFlag("__shops__", {});
		var shops = core.getFlag("__shops__");
		if (!shops[id]) shops[id] = {};
		if (visited) shops[id].visited = true;
		else delete shops[id].visited;
	}

	/// 能否使用快捷商店
	this.canUseQuickShop = function (id) {
		// 如果返回一个字符串，表示不能，字符串为不能使用的提示
		// 返回null代表可以使用

		// 检查当前楼层的canUseQuickShop选项是否为false
		if (core.status.thisMap.canUseQuickShop === false)
			return '当前楼层不能使用快捷商店。';
		return null;
	}

	var _shouldProcessKeyUp = true;

	/// 允许商店X键退出
	core.registerAction('keyUp', 'shops', function (keycode) {
		if (!core.status.lockControl || core.status.event.id != 'action') return false;
		if ((keycode == 13 || keycode == 32) && !_shouldProcessKeyUp) {
			_shouldProcessKeyUp = true;
			return true;
		}

		if (!core.hasFlag("@temp@shop") || core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (keycode == 88 || keycode == 27) { // X, ESC
			core.actions._clickAction(core.actions.HSIZE, topIndex + choices.length - 1);
			return true;
		}
		return false;
	}, 60);

	/// 允许长按空格或回车连续执行操作
	core.registerAction('keyDown', 'shops', function (keycode) {
		if (!core.status.lockControl || !core.hasFlag("@temp@shop") || core.status.event.id != 'action') return false;
		if (core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (keycode == 13 || keycode == 32) { // Space, Enter
			core.actions._clickAction(core.actions.HSIZE, topIndex + core.status.event.selection);
			_shouldProcessKeyUp = false;
			return true;
		}
		return false;
	}, 60);

	// 允许长按屏幕连续执行操作
	core.registerAction('longClick', 'shops', function (x, y, px, py) {
		if (!core.status.lockControl || !core.hasFlag("@temp@shop") || core.status.event.id != 'action') return false;
		if (core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (x >= core.actions.CHOICES_LEFT && x <= core.actions.CHOICES_RIGHT && y >= topIndex && y < topIndex + choices.length) {
			core.actions._clickAction(x, y);
			return true;
		}
		return false;
	}, 60);
},
    "ai": function () {
	// 在此增加新插件
	// a=[]
	// for (let x = 1; x <= 11; x++) {
	// 	for (let y = 1; y <= 5; y++) {
	// 		a.push(`"${x},${y}": aaa`);
	// 	}
	// }
	// console.log(a.join(''))
	// 
	// 
	const scanOrder = ['up', 'down', 'left', 'right'];
	const scanMap = { 'down': 1, 'up': 2, 'right': 4, 'left': 8 };
	const moveMap = { 'down': 'up', 'up': 'down', 'right': 'left', 'left': 'right' };
	var blackStick = core.getFlag('blackStick', []) //被插黑棒的blocks的[x,y,floorId]
	this.route_bfs = function (startX, startY, maxDepth, destX, destY) {
		var route = {},
			order = [],
			canMoveArray = core.generateMovableArray();
		// 使用优先队列
		var queue = new PriorityQueue({ comparator: function (a, b) { return a.depth - b.depth; } });
		route[startX + "," + startY] = { 'direction': 0, 'deep': 0 };
		queue.queue({ depth: 0, x: startX, y: startY });
		var blocks = Object.assign({}, core.getMapBlocksObj());
		while (queue.length != 0) {
			var curr = queue.dequeue(),
				deep = curr.depth,
				nowX = curr.x,
				nowY = curr.y;

			if (deep >= (maxDepth || 999)) break;
			for (var direction in core.utils.scan) {
				if (!core.inArray(canMoveArray[nowX][nowY], direction)) continue;
				var nx = nowX + core.utils.scan[direction].x;
				var ny = nowY + core.utils.scan[direction].y;
				if (nx < 0 || nx >= core.bigmap.width || ny < 0 || ny >= core.bigmap.height) continue;
				if (route[nx + "," + ny] != null) {
					if (route[nx + "," + ny].deep == deep + 1) route[nx + "," + ny].direction += scanMap[direction];
					continue;
				}
				if (nx == destX && ny == destY) {
					route[nx + "," + ny] = direction;
					break;
				}
				if (blocks[nx + "," + ny]) {
					if (!blocks[nx + "," + ny].disable && blocks[nx + "," + ny].event.trigger == 'battle') {
						order.push(blocks[nx + "," + ny])
					} else continue;
				}
				route[nx + "," + ny] = { 'direction': scanMap[direction], 'deep': deep + 1 };
				queue.queue({ depth: deep + 1, x: nx, y: ny });
			}
			if (route[destX + "," + destY] != null) break;
		}
		return [route, order, blocks];
	}
	this.aiTurn = function (args) {
		return core.aiTurnAction(args)
	}
	this.aiTurnAction = function (args) {
		var x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y')
		var maxdepth = 5
		if (core.status.floorId == 'MT40' || core.status.floorId == 'outer1') {
			maxdepth = 999
		}
		var [route, order, blocks] = this.route_bfs(x, y, maxdepth)
		let todo = []
		// console.log(route,order,blocks)
		order.forEach(block => {
			var routeinfo = route[block.x + ',' + block.y]
			//!(core.getFlag("blackStick", []).includes(String(block.x + ',' + block.y + ',' + core.status.floorId)))
			if (!(core.including(core.getFlag("blackStick", []), String(block.x + ',' + block.y + ',' + core.status.floorId))) && !(core.hasFlag("tishenTime"))) { //如果替身中/被插住就不能动&造成伤害了
				if (routeinfo.deep <= 1 && !core.hasFlag("tishenTime") && !core.hasFlag('wudi')) { //替身的时候不会攻击
					// 播放战斗音效和动画
					core.playSound('attack.mp3');
					core.drawImage("animate", core.statusBar.icons.battle, 0, 0, 32, 32, (x - 1) * 32, (y - 1) * 32, 32, 32);
					setTimeout(function () {
						core.clearMap("animate", (x - 1) * 32, (y - 1) * 32, 32, 32);
					}, 100);
					var damageInfo = core.getDamageInfo(block.event.id, null, block.x, block.y, core.status.floorId)
					if (damageInfo == null) {
						damageInfo = { 'per_damage': core.getEnemyValue(block.event.id, 'atk', block.x, block.y, core.status.floorId) - core.getRealStatusOrDefault(core.status.hero, 'def') }
					};
					if (!core.hasFlag("shield2Time")) { //没蓝盾就挨打吧您
						if (damageInfo.per_damage >= core.status.hero.hp) {
							core.status.hero.hp = 0;
							core.updateStatusBar();
							core.events.lose('战斗失败');
							return;
						}
						if (core.hasFlag("shieldTime")) {
							core.status.hero.hp -= damageInfo.per_damage * 0.3;


						} else {
							core.status.hero.hp -= damageInfo.per_damage;
						}
						core.setFlag('tishen', 1) //被打的时候允许秒替
					} else {

						if (core.hasFlag("shield2Mana")) {
							core.addStatus('mana', 1)
							core.setFlag('shield2Mana', 0)
							core.playSound('insta.wav')
							core.playSound('item.mp3')
							core.drawTip('封术吸印生效，你回复了一点奥义点')
						} else {
							core.playSound('insta.wav')
						}

					}

					if (core.status.floorId == 'outer1' && core.getBlockId(block.x, block.y) === 'zeno') { //zeno二阶段独立计算（有活我就放，没活我平A，纯！）
						console.log('a')
						core.addFlag('ZeSk3CD', -1)
						core.addFlag('ZeSk2CD', -1)
						core.addFlag('ZeSk1CD', -1)
						if (core.getFlag('ZeSk3CD') < 1) {
							var IDs = [228, 220, 219]
							core.setFlag('ZeSk3CD', 8)
							core.drawTip('魔王·芝诺使用了召唤术！')
							for (var i = 0; i < 3; i += 1) {
								var ranX = core.rand(10) + 2,
									ranY = core.rand(10) + 2
								while (core.getBlockCls(ranX, ranY) != null) {
									ranX = core.rand(10) + 2
									ranY = core.rand(10) + 2
								}
								if (!core.isReplaying()) core.drawAnimate("tishen", ranX, ranY)
								core.setBlock(IDs[core.rand(3)], ranX, ranY)
							}
						}

						if (core.getFlag('ZeSk2CD') < 1) {
							core.setFlag('ZeSk2CD', 3)
							core.playSound('CG-S2-1.wav')
							core.drawAnimate('crush', block.x, block.y)
							if (routeinfo.deep <= 2) { //被征到了
								var toX = core.getHeroLoc('x'),
									toY = core.getHeroLoc('y')
								if (!core.isReplaying()) {
									core.playSound('attack.mp3')
									core.drawImage("animate", core.statusBar.icons.battle, 0, 0, 32, 32, (core.getHeroLoc('x') - 1) * 32, (core.getHeroLoc('y') - 1) * 32, 32, 32)
									core.addStatus('hp', core.getStatus('def') - 1500) //zeno攻击为1500
									core.drawTip('魔王·芝诺使用了震荡波！你受到了 ' + String(1500 - core.getStatus('def')) + '点伤害')
									setTimeout(function () {
										core.clearMap("animate", (x - 1) * 32, (y - 1) * 32, 32, 32)
									}, 100)
									if (block.x > core.getHeroLoc('x')) {
										toX -= 1
									} else if (block.x < core.getHeroLoc('x')) {
										toX += 1
									}
									if (block.y > core.getHeroLoc('y')) {
										toY -= 1
									} else if (block.y < core.getHeroLoc('y')) {
										toY += 1
									}
									if (core.isReplaying()) {
										core.moveHeroTo(toX, toY)
									} else {
										core.jumpHero(toX, toY, 200)
									}

								}

							}
							return
						}
						if (core.getFlag('ZeSk1CD') < 1) { //xy范围：1-11
							core.setFlag('ZeSk1CD', 5)
							var ranX = core.rand(10) + 2,
								ranY = core.rand(10) + 2
							while (core.getBlockCls(ranX, ranY) != null) {
								ranX = core.rand(10) + 2
								ranY = core.rand(10) + 2
							}
							core.playSound('centerFly.mp3')
							core.drawTip('魔王·芝诺使用了瞬移！')
							core.setBlock(block.id, ranX, ranY);
							core.moveEnemyOnPoint(block.x, block.y, ranX, ranY);
							core.removeBlock(block.x, block.y)
							return

						}



					}

				} else if (!(core.floors[core.status.floorId].afterBattle[block.x + "," + block.y]) && !(core.hasSpecial(core.getEnemyInfo(block.event.id, null, block.x, block.y).special, 28))) {
					if (core.inArray(['MT2', 'MT25', 'MT30', 'MT44', 'MT49'], core.status.floorId)) {
						return
					}

					if (core.status.floorId == 'outer1' && core.getBlockId(block.x, block.y) === 'zeno') { //zeno二阶段独立计算
						console.log('a')
						core.addFlag('ZeSk3CD', -1)
						core.addFlag('ZeSk2CD', -1)
						core.addFlag('ZeSk1CD', -1)
						if (core.getFlag('ZeSk3CD') < 1) {
							var IDs = [228, 220, 219]
							core.setFlag('ZeSk3CD', 8)
							core.drawTip('魔王·芝诺使用了召唤术！')
							for (var i = 0; i < 3; i += 1) {
								var ranX = core.rand(10) + 2,
									ranY = core.rand(10) + 2
								while (core.getBlockCls(ranX, ranY) != null) {
									ranX = core.rand(10) + 2
									ranY = core.rand(10) + 2
								}
								if (!core.isReplaying()) core.drawAnimate("tishen", ranX, ranY)
								core.setBlock(IDs[core.rand(3)], ranX, ranY)
							}
						}

						if (core.getFlag('ZeSk2CD') < 1) {
							core.setFlag('ZeSk2CD', 3)
							core.playSound('CG-S2-1.wav')
							core.drawAnimate('crush', block.x, block.y)
							if (routeinfo.deep <= 2) { //被征到了
								var toX = core.getHeroLoc('x'),
									toY = core.getHeroLoc('y')
								if (!core.isReplaying()) {
									core.playSound('attack.mp3')
									core.drawImage("animate", core.statusBar.icons.battle, 0, 0, 32, 32, (core.getHeroLoc('x') - 1) * 32, (core.getHeroLoc('y') - 1) * 32, 32, 32)
									core.addStatus('hp', core.getStatus('def') - 1500) //zeno攻击为1500
									core.drawTip('魔王·芝诺使用了震荡波！你受到了 ' + String(1500 - core.getStatus('def')) + '点伤害')
									setTimeout(function () {
										core.clearMap("animate", (x - 1) * 32, (y - 1) * 32, 32, 32)
									}, 100)
									if (block.x > core.getHeroLoc('x')) {
										toX -= 1
									} else if (block.x < core.getHeroLoc('x')) {
										toX += 1
									}
									if (block.y > core.getHeroLoc('y')) {
										toY -= 1
									} else if (block.y < core.getHeroLoc('y')) {
										toY += 1
									}
									if (core.isReplaying()) {
										core.moveHeroTo(toX, toY)
									} else {
										core.jumpHero(toX, toY, 200)
									}

								}

							}
							return
						}
						if (core.getFlag('ZeSk1CD') < 1) { //xy范围：1-11
							core.setFlag('ZeSk1CD', 5)
							var ranX = core.rand(10) + 2,
								ranY = core.rand(10) + 2
							while (core.getBlockCls(ranX, ranY) != null) {
								ranX = core.rand(10) + 2
								ranY = core.rand(10) + 2
							}
							core.playSound('centerFly.mp3')
							core.drawTip('魔王·芝诺使用了瞬移！')
							core.setBlock(block.id, ranX, ranY);
							core.moveEnemyOnPoint(block.x, block.y, ranX, ranY);
							core.removeBlock(block.x, block.y)
							return

						}



					}

					for (let index = 0; index < scanOrder.length; index++) {
						const direction = scanOrder[index];
						if (!(scanMap[moveMap[direction]] & routeinfo.direction)) continue;
						var nx = block.x + core.utils.scan[direction].x;
						var ny = block.y + core.utils.scan[direction].y;
						if (blocks[nx + ',' + ny]) continue;

						var movetime = 50
						if (core.isReplaying()) {
							movetime = 10
						}
						// todo.push({"type": "move", "loc": [block.x,block.y], "time": movetime, "keep": true, "steps": [direction+":1"]})
						// todo.push({"type": "move", "loc": [block.x,block.y], "time": movetime, "keep": true, "async":true, "steps": [direction+":1"]})

						// todo.push({"type": "move", "loc": [block.x,block.y], "time": movetime, "keep": false, "async":true, "steps": [direction+":1"]})
						// moveBlock(block.x, block.y, [direction], movetime, false, null)
						core.removeBlock(block.x, block.y)
						core.setBlock(block.id, nx, ny);
						core.moveEnemyOnPoint(block.x, block.y, nx, ny);

						blocks[nx + ',' + ny] = block
						blocks[x + ',' + y] = null
						// blocks[block.x+','+block.y]=null

						return


					}

				}
			}

		})

		if (core.getFlag("shield2Time", 0) === 1) {
			core.drawTip('封术吸印已失效')
			core.playSound("tishen.wav")
			core.setFlag("nowShield", null)
			core.setFlag("shield2Time", 0)
		} else if (core.hasFlag("shield2Time")) {
			core.addFlag('shield2Time', -1)
		}
		if (core.getFlag("shieldTime", 0) === 1) {
			core.drawTip('忍体术·御已失效')
			core.playSound("tishen.wav")
			core.setFlag('nowShield', null)
			core.setFlag("shieldTime", 0)
		} else if (core.hasFlag("shieldTime")) {
			core.addFlag('shieldTime', -1)
		}
		if (todo.length) {
			// console.log(JSON.stringify(core.status.automaticRoute))
			if (args.from === 'step') core.saveAndStopAutomaticRoute();
			var moveStep = core.status.automaticRoute.moveStepBeforeStop;
			core.insertAction(todo, null, null, args.from === 'step' ? () => {
				core.status.automaticRoute.moveStepBeforeStop = moveStep
				if (core.status.event.id == null)
					core.continueAutomaticRoute();
				else
					core.clearContinueAutomaticRoute();
			} : null)
		}

		core.updateStatusBar();

		return { 'movingCount': todo.length }
	}
},
    "skills": function () {

	this.dealDamage = function (id, damage, x, y) {
		core.playSound('attack.mp3');
		if (!core.hasFlag('noBattleAnimate')) core.drawImage("animate", core.statusBar.icons.battle, 0, 0, 32, 32, (x - 1) * 32, (y - 1) * 32, 32, 32);
		if (core.including(core.getFlag("blackStick", []), String(x + ',' + y + ',' + core.status.floorId))) { //如果被插棒了伤害就暴增到1.5倍
			damage *= 1.5
		}
		core.setEnemyOnPoint(x, y, null, 'hp', damage, '-=')
		if (core.getEnemyValue(core.getBlockId(x, y), 'hp', x, y, core.status.floorId) <= 0 && core.getBlockCls(x, y) === 'enemys') {
			var todo = core.getFlag('todo', [])
			var enemy = core.material.enemys[core.getBlockId(x, y)]
			var money = 0
			money += core.getEnemyValue(enemy, 'money', x, y) || 0;
			if (core.floors[core.status.floorId].afterBattle[x + "," + y] || enemy.afterBattle) {
				core.push(todo, core.floors[core.status.floorId].afterBattle[x + "," + y]);
				core.push(todo, enemy.afterBattle);
				if (core.hasFlag('todo')) {
					core.insertAction(core.getFlag('todo', []))
					if (!core.isReplaying()) core.lockControl()
					core.setFlag('todo', [])
				} else { core.setFlag('todo', todo) }
			}
			if (core.status.floorId === 'MT40' && core.hasFlag('40fBattle')) {
				core.addFlag('40BossBattle', 1)
				if (core.getFlag("40BossBattle", 0) >= 12) {
					core.insertAction({ "type": "insert", "loc": [0, 7] })
				}
			}
			if (!core.hasFlag('noMoney')) {
				core.addStatus("money", money);
				core.drawTip(enemy.name + ' 被打败了，你获得了 ' + money + ' 金币')
			}
			if (core.getFlag("blackStick", []).includes(String(x + ',' + y + ',' + core.status.floorId))) {
				var bs = core.getFlag("blackStick", [])
				bs = bs.filter(function (item) {
					return item !== String(x + ',' + y + ',' + core.status.floorId);
				});
				core.setFlag("blackStick", bs)
			}
			core.removeBlock(x, y)
			delete((flags.enemyOnPoint || {})[core.status.floorId] || {})[x + "," + y];
		}
		setTimeout(function () {
			if (!core.hasFlag('noBattleAnimate')) core.clearMap("animate", (x - 1) * 32, (y - 1) * 32, 32, 32);
		}, 100);
	}

	this.tishen = function () { //这是替身
		core.status.route.push('ts')
		//tishen为替身术是否符合使用条件，
		//tishenTime是替身现在的时长
		//tishenCD是替身术的冷却
		//而status里的inTishen为是否处于替身术（也许存读档会有用）
		if (!core.hasFlag('tishen')) {
			core.drawTip('未受击状态下不可使用替身术')
			return
		}
		if (core.hasFlag('tishenCD')) {
			core.drawTip('替身术还在冷却中')
			return
		}
		if (core.status.hero.mana <= 0 && !core.hasFlag('tishenNoConsume')) {
			core.drawTip('奥义点不足')
			return
		}
		core.setFlag('tishen', 0) //替身接替身？想得美
		var blocks = []
		var scan = core.utils.scan;
		for (var direction in scan) {

			var delta = scan[direction];
			var x = core.getHeroLoc('x') + delta.x,
				y = core.getHeroLoc('y') + delta.y
			var block = core.getBlock(x, y);
			if (core.getBlockCls(x, y) === 'enemys') {
				blocks.push([x, y])
			}
		}
		if (!core.hasFlag('tishenNoConsume')) core.addStatus('mana', -1)
		if (blocks.length === 0) { //周围没有敌人，是夹激阻域伤害，原地替身


			core.setFlag('tishenTime', 5)
			if (core.hasFlag('longerTishen')) {
				core.setFlag("tishenTime", 9)
			}
			core.setFlag("tishenCD", 15)
			if (core.hasFlag('fastTishen')) {
				core.setFlag('tishenCD', 10)
			}
			core.tishenOn()
			core.setHeroOpacity(0.7)
			core.updateStatusBar()
			core.drawAnimate('tishen', core.getHeroLoc('x'), core.getHeroLoc('y'))
		} else { //周围至少有一个敌人
			if (blocks.length === 1) {
				var nx = core.getHeroLoc('x') - (core.getHeroLoc('x') - blocks[0][0]) * 2,
					ny = core.getHeroLoc('y') - (core.getHeroLoc('y') - blocks[0][1]) * 2
				if (core.getBlock(nx, ny) === null || core.getBlockCls(nx, ny) === 'enemys') { //有地方替身才行，不然原地替

					core.setFlag('tishenTime', 5)
					if (core.hasFlag('longerTishen')) {
						core.setFlag("tishenTime", 9)
					}
					core.tishenOn()
					core.drawAnimate('tishen', core.getHeroLoc('x'), core.getHeroLoc('y'))
					core.setFlag('tishenCD', 15)
					if (core.hasFlag('fastTishen')) {
						core.setFlag('tishenCD', 10)
					}
					core.setHeroOpacity(0.7)
					core.moveHeroTo(nx, ny)
					core.clearMap('hero');
					core.drawHero();
					core.updateStatusBar();

					return
				} else {

					core.setFlag('tishenTime', 5)
					if (core.hasFlag('longerTishen')) {
						core.setFlag("tishenTime", 9)
					}
					core.tishenOn()
					core.setFlag('tishenCD', 15)
					if (core.hasFlag('fastTishen')) {
						core.setFlag('tishenCD', 10)
					}
					core.setHeroOpacity(0.7)
					core.updateStatusBar()
					core.drawAnimate('tishen', core.getHeroLoc('x'), core.getHeroLoc('y'))
					return
				}

			} else {
				for (var i = 0; i < blocks.length; i++) {
					var block = blocks[i]
					var nx = core.getHeroLoc('x') - (core.getHeroLoc('x') - block[0]) * 2,
						ny = core.getHeroLoc('y') - (core.getHeroLoc('y') - block[1]) * 2
					if (core.getBlock(nx, ny) === null) {

						core.drawAnimate('tishen', core.getHeroLoc('x'), core.getHeroLoc('y'))
						core.setFlag('tishenTime', 5)
						if (core.hasFlag('longerTishen')) {
							core.setFlag("tishenTime", 9)
						}
						core.tishenOn()
						core.setHeroOpacity(0.7)
						core.moveHeroTo(nx, ny)
						core.clearMap('hero');
						core.drawHero();
						core.setFlag('tishenCD', 15)
						if (core.hasFlag('fastTishen')) {
							core.setFlag('tishenCD', 10)
						}
						core.updateStatusBar()

						return
					} else {
						continue
					}
				}
				//实在没地方就原地替身

				core.drawAnimate('tishen', core.getHeroLoc('x'), core.getHeroLoc('y'))
				core.setFlag('tishenTime', 5)
				if (core.hasFlag('longerTishen')) {
					core.setFlag("tishenTime", 9)
				}
				core.tishenOn()
				core.setFlag('tishenCD', 15)
				core.setHeroOpacity(0.7)
				core.updateStatusBar()
				if (core.hasFlag('fastTishen')) {
					core.setFlag('tishenCD', 10)
				}
				return
			}
		}

	}

	this.useSkill = function (skill, level, time) {

		if (core.hasFlag("tishenTime")) { //使用技能立刻结束替身免伤
			core.addFlag("tishenTime", -1);
			if (!core.hasFlag("tishenTime")) {
				core.drawTip('替身免伤效果已结束')
				core.setHeroOpacity(1)
				core.tishenOff()
			}
		}

		core.updateStatusBar() //经常刷新是好习惯！
		core.autosave()

		//////正常玩的时候使用的代码///////
		if (skill === 1) {
			core.status.route.push('usk1')
			// 一技能-万象天引
			if (core.getFlag('skill1CD', 0) != 0) {
				core.drawTip('技能还在冷却中')
				return
			}
			if (level === 3) {
				//超哥捅人
				//core.insertCommonEvent('地图选择', ["请选择任意敌人"], null, null, function () {
				//if(!core.isReplaying()) core.lockControl()
				if (core.getFlag('sk1_3', 1) === 1) { //sk1_3,即超哥万象天引的段数，第一次和第二次不加cd（CD设10）


					core.insertCommonEvent('地图选择', ["请选择任意敌人"], null, null, function () {
						if (!core.isReplaying()) core.lockControl()
						core.setFlag('skill_1_3Mana', false)
						var x = core.getFlag('selectedX'),
							y = core.getFlag('selectedY'),
							heroX = core.getHeroLoc('x'),
							heroY = core.getHeroLoc('y')
						var xDis = Math.abs(x - core.getHeroLoc('x')),
							yDis = Math.abs(y - core.getHeroLoc('y'))
						if ((heroX > x - 2 || heroX < x + 2) || (heroY > y - 2 || heroY < y + 2) || xDis > 7 || yDis > 7) {
							if (core.getBlockCls(x, y) != 'enemys') {
								core.drawTip('取消使用')
								if (!core.isReplaying()) core.unlockControl()
								return
							}

							core.updateStatusBar()
							if (xDis > yDis) {
								if (x > heroX) {
									core.setHeroLoc('direction', 'right')
								} else {
									core.setHeroLoc('direction', 'left')
								}
							} else {
								if (y > heroY) {
									core.setHeroLoc('direction', 'down')
								} else {
									core.setHeroLoc('direction', 'up')
								}
							}
							core.clearMap('hero')
							core.drawHero()
							if (core.getBlock(core.nextX(1), core.nextY(1)) != null && !(x === core.nextX(1) && y === core.nextY(1))) {
								core.drawTip('前方已有方块，不能使用')
								if (!core.isReplaying()) core.unlockControl()
								return
							}

							if (core.status.hero.mana < core.status.hero.manamax && !core.hasFlag("skill_1_3Mana")) {
								core.addStatus('mana', 1);
								core.setFlag('skill_1_3Mana', true)
							} //这万象天引肯定抓得到人，包给豆的


							core.playSound('CG-S1-1.wav')
							core.playSound('CG-S1-1V.wav')
							var hp_enemy = core.getEnemyValue(core.getBlockId(x, y), 'hp', x, y, core.status.floorId)
							if (!core.isset(core.floors[core.status.floorId].afterBattle[x + "," + y])) {
								if (!core.isReplaying()) {
									core.jumpBlock(x, y, core.nextX(1), core.nextY(1), 300, true, function () {
										core.moveEnemyOnPoint(x, y, core.nextX(1), core.nextY(1))
										core.setEnemyOnPoint(x, y, null, 'hp', hp_enemy)

										core.dealDamage(core.getBlockId(core.nextX(1), core.nextY(1)), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(core.nextX(1), core.nextY(1)), 'def', core.nextX(1), core.nextY(1), null)), core.nextX(1), core.nextY(1))
										if (core.getFlag('todo', []).length > 0) {
											core.insertAction(core.getFlag('todo', []))
											core.setFlag('todo', [])
										}

										if (!core.isReplaying()) core.unlockControl()
									})
								} else { //录像特供
									core.moveEnemy(x, y, core.nextX(1), core.nextY(1))
									core.dealDamage(core.getBlockId(core.nextX(1), core.nextY(1)), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(core.nextX(1), core.nextY(1)), 'def', core.nextX(1), core.nextY(1), null)), core.nextX(1), core.nextY(1))
									if (core.getFlag('todo', []).length > 0) {
										core.insertAction(core.getFlag('todo', []))
										core.setFlag('todo', [])
									}
								}
							} else {
								core.dealDamage(core.getBlockId(x, y), 2 * Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null)), x, y)
								if (core.getFlag('todo', []).length > 0) {
									core.insertAction(core.getFlag('todo', []))
									core.setFlag('todo', [])
								}
								if (!core.isReplaying()) core.unlockControl()
							}
							core.setFlag("sk1_3", 2)
							core.setFlag('sk1_3MovingTime', 5) //乱动就直接进CD

						} else {
							core.drawTip('取消使用')
							if (!core.isReplaying()) core.unlockControl()
							return
						}
					})
				} else if (core.getFlag('sk1_3', 1) === 2) { //二阶-把人吊在天上……靠这玩意我能做出来吗
					core.insertCommonEvent('地图选择', ["请选择任意敌人"], null, null, function () {
						if (!core.isReplaying()) core.lockControl()

						var x = core.getFlag('selectedX'),
							y = core.getFlag('selectedY'),
							heroX = core.getHeroLoc('x'),
							heroY = core.getHeroLoc('y')
						var xDis = Math.abs(x - core.getHeroLoc('x')),
							yDis = Math.abs(y - core.getHeroLoc('y'))
						if (core.getBlockCls(x, y) != 'enemys') {
							core.drawTip('取消使用')
							if (!core.isReplaying()) core.unlockControl()
							return
						}

						if (xDis > 2 || yDis > 2) {
							core.drawTip('距离太远了，取消使用')
							if (!core.isReplaying()) core.unlockControl()
							return
						}

						if (core.status.hero.mana < core.status.hero.manamax && !core.hasFlag("skill_1_3Mana")) {
							core.addStatus('mana', 1);
							core.setFlag('skill_1_3Mana', true)
						} //这万象天引肯定抓得到人，包给豆的

						if (xDis > yDis) {
							if (x > heroX) {
								core.setHeroLoc('direction', 'right')
							} else {
								core.setHeroLoc('direction', 'left')
							}
						} else {
							if (y > heroY) {
								core.setHeroLoc('direction', 'down')
							} else {
								core.setHeroLoc('direction', 'up')
							}
						}
						core.clearMap('hero')
						core.drawHero()
						core.setFlag("sk1_3", 3)

						core.playSound('CG-S1-2V.wav')
						if (!core.isReplaying()) {
							var waitTime = 0
							for (i = 0; i < 5; i += 1) { //共1.5倍伤害
								setTimeout(function () {
									core.dealDamage(core.getBlockId(x, y), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null)) * 0.3, x, y)
								}, waitTime)
								waitTime += 100
							}
							setTimeout(function () {
								if (!core.isReplaying()) core.unlockControl()
								core.setFlag('sk1_3MovingTime', 5)
							}, 500)
						} else { //录像特供
							core.dealDamage(core.getBlockId(x, y), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null)) * 1.5, x, y)
							core.setFlag('sk1_3MovingTime', 5)
						}
					})

				} else { //三阶-砸地
					core.insertCommonEvent('地图选择', ["请选择任意敌人"], null, null, function () {

						core.setFlag('skill1CD', 10)
						core.setFlag("sk1_3", 1)

						var x = core.getFlag('selectedX'),
							y = core.getFlag('selectedY'),
							heroX = core.getHeroLoc('x'),
							heroY = core.getHeroLoc('y')
						var xDis = Math.abs(x - core.getHeroLoc('x')),
							yDis = Math.abs(y - core.getHeroLoc('y'))
						if (core.getBlockCls(x, y) != 'enemys') {
							core.drawTip('取消使用')
							if (!core.isReplaying()) core.unlockControl()
							return
						}
						if (xDis > 2 || yDis > 2) {
							core.drawTip('距离太远了，取消使用')
							if (!core.isReplaying()) core.unlockControl()
							return
						}
						if (core.getBlock(core.nextX(1), core.nextY(1)) != null && !(x === core.nextX(1) && y === core.nextY(1))) {
							core.drawTip('前方已有方块，不能使用')
							if (!core.isReplaying()) core.unlockControl()
							return
						}

						if (core.status.hero.mana < core.status.hero.manamax && !core.hasFlag("skill_1_3Mana")) {
							core.addStatus('mana', 1);
							core.setFlag('skill_1_3Mana', true)
						} //这万象天引肯定抓得到人，包给豆的


						if (xDis > yDis) {
							if (x > heroX) {
								core.setHeroLoc('direction', 'right')
							} else {
								core.setHeroLoc('direction', 'left')
							}
						} else {
							if (y > heroY) {
								core.setHeroLoc('direction', 'down')
							} else {
								core.setHeroLoc('direction', 'up')
							}
						}
						core.clearMap('hero')
						core.drawHero()

						core.playSound('CG-S1-3V.wav')
						if (!core.isReplaying()) {
							if (!core.isset(core.floors[core.status.floorId].afterBattle[x + "," + y])) {
								var hp_enemy = core.getEnemyValue(core.getBlockId(x, y), 'hp', x, y, core.status.floorId)
								core.jumpBlock(x, y, core.nextX(), core.nextY(), 500, true,
									function () {
										if (x != core.nextX() || y != core.nextY()) core.moveEnemyOnPoint(x, y, core.nextX(), core.nextY())
										core.setEnemyOnPoint(x, y, null, 'hp', hp_enemy)
										core.dealDamage(core.getBlockId(core.nextX(), core.nextY()), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(core.nextX(), core.nextY()), 'def', core.nextX(), core.nextY(), null)) * 0.5, core.nextX(), core.nextY())
										if (core.getBlockCls(core.nextX(2), core.nextY(2), core.status.floorId, true) === null && !core.isset(core.floors[core.status.floorId].afterBattle[x + "," + y])) {
											core.moveEnemy(core.nextX(1), core.nextY(1), core.nextX(2), core.nextY(2))
											core.moveHeroTo(core.nextX(1), core.nextY(1))
										}
										setTimeout(function () {
											core.playSound('CG-S1-3b.wav')
											core.dealDamage(core.getBlockId(core.nextX(), core.nextY()), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(core.nextX(), core.nextY()), 'def', core.nextX(), core.nextY(), null)) * 1, core.nextX(), core.nextY())
											if (!core.isReplaying()) core.unlockControl()
										}, 800)




									}
								)
							} else {
								core.jumpBlock(x, y, x, y, 500, true, function () {
									core.dealDamage(core.getBlockId(x, y), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null)) * 1, x, y)
									setTimeout(function () {
										core.playSound('CG-S1-3b.wav')
										core.dealDamage(core.getBlockId(x, y), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null)) * 1, x, y)
									}, 800)
								})
							}
						} else { //录像特供
							if (!core.isset(core.floors[core.status.floorId].afterBattle[x + "," + y])) {
								var hp_enemy = core.getEnemyValue(core.getBlockId(x, y), 'hp', x, y, core.status.floorId)
								core.moveEnemy(x, y, core.nextX(), core.nextY())
								if (x != core.nextX() || y != core.nextY()) core.moveEnemyOnPoint(x, y, core.nextX(), core.nextY())
								core.setEnemyOnPoint(x, y, null, 'hp', hp_enemy)
								core.dealDamage(core.getBlockId(core.nextX(), core.nextY()), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(core.nextX(), core.nextY()), 'def', core.nextX(), core.nextY(), null)) * 0.5, core.nextX(), core.nextY())
								if (core.getBlockCls(core.nextX(2), core.nextY(2), core.status.floorId, true) === null && !core.isset(core.floors[core.status.floorId].afterBattle[x + "," + y])) {
									core.moveEnemy(core.nextX(1), core.nextY(1), core.nextX(2), core.nextY(2))
									core.moveHeroTo(core.nextX(1), core.nextY(1))
								}
								core.dealDamage(core.getBlockId(core.nextX(), core.nextY()), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(core.nextX(), core.nextY()), 'def', core.nextX(), core.nextY(), null)) * 1, core.nextX(), core.nextY())







							} else {
								core.dealDamage(core.getBlockId(x, y), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null)) * 2, x, y)


							}
						}

					})


				}





			} else if (level === 2) {
				//百战插棒
				core.insertCommonEvent('地图选择', ["请选择任意敌人"], null, null, function () {
					if (!core.isReplaying()) core.lockControl()
					var distance = 4 //如何呢，这就是我们百战佩恩的超大范围
					var x = core.getFlag('selectedX'),
						y = core.getFlag('selectedY'),
						heroX = core.getHeroLoc('x'),
						heroY = core.getHeroLoc('y')
					var xDis = Math.abs(x - core.getHeroLoc('x')),
						yDis = Math.abs(y - core.getHeroLoc('y'))

					if (xDis + yDis > distance) {
						core.drawTip('距离太远了')
						if (!core.isReplaying()) core.unlockControl()
						return
					}

					if (core.getBlockCls(x, y) != 'enemys') {
						core.drawTip('取消使用')
						if (!core.isReplaying()) core.unlockControl()
						return
					}


					core.updateStatusBar()
					if (xDis > yDis) {
						if (x > heroX) {
							core.setHeroLoc('direction', 'right')
						} else {
							core.setHeroLoc('direction', 'left')
						}
					} else {
						if (y > heroY) {
							core.setHeroLoc('direction', 'down')
						} else {
							core.setHeroLoc('direction', 'up')
						}
					}
					core.clearMap('hero')
					core.drawHero()
					if (core.getBlock(core.nextX(1), core.nextY(1)) != null && !(x === core.nextX(1) && y === core.nextY(1))) {
						core.drawTip('前方已有方块，不能使用')
						if (!core.isReplaying()) core.unlockControl()
						return
					}

					core.setFlag('skill1CD', 8)

					var sound = core.rand(2) === 1 ? 'BZ-S1-1.wav' : 'BZ-S1-2.wav'
					core.playSound(sound)
					var hp_enemy = core.getEnemyValue(core.getBlockId(x, y), 'hp', x, y, core.status.floorId)
					if (!core.isReplaying()) {
						if (!core.isset(core.floors[core.status.floorId].afterBattle[x + "," + y])) {
							core.jumpBlock(x, y, core.nextX(1), core.nextY(1), 300, true, function () {
								core.moveEnemyOnPoint(x, y, core.nextX(1), core.nextY(1))
								core.setEnemyOnPoint(x, y, null, 'hp', hp_enemy)
								if (core.status.hero.mana < core.status.hero.manamax) core.addStatus('mana', 1) //这万象天引肯定抓得到人，包给豆的
								core.dealDamage(core.getBlockId(core.nextX(1), core.nextY(1)), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(core.nextX(1), core.nextY(1)), 'def', core.nextX(1), core.nextY(1), null)), core.nextX(1), core.nextY(1))
								if (core.getFlag('todo', []).length > 0) {
									core.insertAction(core.getFlag('todo', []))
									core.setFlag('todo', [])
								}
								//插插棒

								var enemy = core.getEnemyInfo(core.getBlockId(core.nextX(), core.nextY()), null, core.nextX(), core.nextY(), core.status.floorId)
								//return enemy && !enemy.notBomb;


								if (core.getFlag('sticks', 0) > 2) {
									var a = core.getFlag("blackStick", [])
									a.push(String(core.nextX(1) + ',' + core.nextY(1) + ',' + core.status.floorId + ',' + (core.getFlag('sticks', 0) + 2)))
									core.setFlag('sticks', 0)
									//插入格式：(x,y,楼层名,时长)
									core.setFlag("blackStick", a)
									if (!core.isReplaying()) core.unlockControl()
									core.drawAnimate("blackStick", core.nextX(1), core.nextY(1), false)
									core.updateStatusBar()

								} else {
									if (!core.isReplaying()) core.unlockControl()
									core.insertCommonEvent('地图选择', ["请选择想投掷到的地点，若在范围外视为取消投掷"], null, null, function () {
										if (!core.isReplaying()) core.lockControl()
										var distance = 4 //如何呢，这就是我们百战佩恩的超大范围
										var x = core.getFlag('selectedX'),
											y = core.getFlag('selectedY'),
											heroX = core.getHeroLoc('x'),
											heroY = core.getHeroLoc('y')
										var xDis = Math.abs(x - core.getHeroLoc('x')),
											yDis = Math.abs(y - core.getHeroLoc('y'))
										if (xDis > distance || yDis > distance || core.getBlock(x, y) !== null) {
											core.drawTip('已取消投掷')
											if (!core.isReplaying()) core.unlockControl()
											return
										}
										core.playSound("CG-S1-1.wav")
										core.drawTip('哈！')
										core.moveEnemyOnPoint(core.nextX(1), core.nextY(1), x, y)
										core.jumpBlock(core.nextX(1), core.nextY(1), x, y, 500, true)
										if (!core.isReplaying()) core.unlockControl()
									})
								}

							})

						} else {
							if (core.hasFlag('wxtyEX')) {
								if (core.getFlag('sticks', 0) > 2) {
									var a = core.getFlag("blackStick", [])
									a.push(String(x + ',' + y + ',' + core.status.floorId + ',' + (core.getFlag('sticks', 0) + 2)))
									core.setFlag('sticks', 0)
									//插入格式：(x,y,楼层名,时长)
									core.setFlag("blackStick", a)
									core.drawAnimate("blackStick", x, y, false)
									core.updateStatusBar()

								}
							}
							core.dealDamage(core.getBlockId(x, y), 2 * Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null)), x, y)
							if (core.getFlag('todo', []).length > 0) {
								core.insertAction(core.getFlag('todo', []))
								core.setFlag('todo', [])
							}
							if (!core.isReplaying()) core.unlockControl()
						}
					} else { //录像特供
						if (!core.isset(core.floors[core.status.floorId].afterBattle[x + "," + y])) {
							core.moveEnemy(x, y, core.nextX(), core.nextY());
							if (core.status.hero.mana < core.status.hero.manamax) core.addStatus('mana', 1) //这万象天引肯定抓得到人，包给豆的
							core.dealDamage(core.getBlockId(core.nextX(1), core.nextY(1)), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(core.nextX(1), core.nextY(1)), 'def', core.nextX(1), core.nextY(1), null)), core.nextX(1), core.nextY(1))

							if (core.getFlag('sticks', 0) > 2) {
								var a = core.getFlag("blackStick", [])
								a.push(String(core.nextX(1) + ',' + core.nextY(1) + ',' + core.status.floorId + ',' + (core.getFlag('sticks', 0) + 2)))
								core.setFlag('sticks', 0)
								//插入格式：(x,y,楼层名,时长)
								core.setFlag("blackStick", a)
								core.updateStatusBar()

							} else {

								core.insertCommonEvent('地图选择', ["请选择想投掷到的地点，若在范围外视为取消投掷"], null, null, function () {
									if (!core.isReplaying()) core.lockControl()
									var distance = 4 //如何呢，这就是我们百战佩恩的超大范围
									var x = core.getFlag('selectedX'),
										y = core.getFlag('selectedY'),
										heroX = core.getHeroLoc('x'),
										heroY = core.getHeroLoc('y')
									var xDis = Math.abs(x - core.getHeroLoc('x')),
										yDis = Math.abs(y - core.getHeroLoc('y'))
									if (xDis > distance || yDis > distance || core.getBlock(x, y) !== null) {
										core.drawTip('已取消投掷')

										return
									}
									core.moveEnemy(core.nextX(1), core.nextY(), x, y)
								})
							}

						} else {
							core.dealDamage(core.getBlockId(core.nextX(1), core.nextY(1)), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(core.nextX(1), core.nextY(1)), 'def', core.nextX(1), core.nextY(1), null)), core.nextX(1), core.nextY(1))
							if (core.hasFlag('wxtyEX')) {
								if (core.getFlag('sticks', 0) > 2) {
									var a = core.getFlag("blackStick", [])
									a.push(String(x + ',' + y + ',' + core.status.floorId + ',' + (core.getFlag('sticks', 0) + 2)))
									core.setFlag('sticks', 0)
									//插入格式：(x,y,楼层名,时长)
									core.setFlag("blackStick", a)
									core.updateStatusBar()

								}
							}
							core.dealDamage(core.getBlockId(x, y), 2 * Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null)), x, y)
						}
						if (core.getFlag('todo', []).length > 0) {
							core.insertAction(core.getFlag('todo', []))
							core.setFlag('todo', [])
							if (!core.isReplaying()) core.lockControl()
						}
					}
				})

			} else {
				//old佩恩插插棒
				var distance = core.hasFlag('sk1_1_lv2') ? 4 : 3 //未获得刻印则只有三格
				core.insertCommonEvent('地图选择', ["请选择任意敌人"], null, null, function () {
					if (!core.isReplaying()) core.lockControl()
					var x = core.getFlag('selectedX'),
						y = core.getFlag('selectedY'),
						heroX = core.getHeroLoc('x'),
						heroY = core.getHeroLoc('y')
					var xDis = Math.abs(x - core.getHeroLoc('x')),
						yDis = Math.abs(y - core.getHeroLoc('y'))

					if (xDis + yDis > distance) {
						core.drawTip('距离太远了')
						if (!core.isReplaying()) core.unlockControl()
						return
					}

					if (core.getBlockCls(x, y) != 'enemys') {
						core.drawTip('取消使用')
						if (!core.isReplaying()) core.unlockControl()
						return
					}


					core.updateStatusBar()
					if (xDis > yDis) {
						if (x > heroX) {
							core.setHeroLoc('direction', 'right')
						} else {
							core.setHeroLoc('direction', 'left')
						}
					} else {
						if (y > heroY) {
							core.setHeroLoc('direction', 'down')
						} else {
							core.setHeroLoc('direction', 'up')
						}
					}
					core.clearMap('hero')
					core.drawHero()
					if (core.getBlock(core.nextX(1), core.nextY(1)) != null && !(x === core.nextX(1) && y === core.nextY(1))) {
						core.drawTip('前方已有方块，不能使用')
						if (!core.isReplaying()) core.unlockControl()
						return
					}

					core.setFlag('skill1CD', 8) //插到就3回合不动，常态无棒比百战强，但上限比百战低，CD给一样应该可以
					var sound = core.rand(2) === 1 ? 'S1-1.wav' : 'S1-2.wav'
					core.playSound(sound)
					var hp_enemy = core.getEnemyValue(core.getBlockId(x, y), 'hp', x, y, core.status.floorId)

					if (!core.isset(core.floors[core.status.floorId].afterBattle[x + "," + y])) { //无战后事件？
						if (!core.isReplaying()) {
							core.jumpBlock(x, y, core.nextX(1), core.nextY(1), 300, true, function () {
								core.moveEnemyOnPoint(x, y, core.nextX(1), core.nextY(1))
								core.setEnemyOnPoint(x, y, null, 'hp', hp_enemy)
								if (core.status.hero.mana < core.status.hero.manamax) core.addStatus('mana', 1) //这万象天引肯定抓得到人，包给豆的
								core.dealDamage(core.getBlockId(core.nextX(1), core.nextY(1)), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(core.nextX(1), core.nextY(1)), 'def', core.nextX(1), core.nextY(1), null)), core.nextX(1), core.nextY(1))
								if (core.getFlag('todo', []).length > 0) {
									core.insertAction(core.getFlag('todo', []))
									core.setFlag('todo', [])
								}
								if (core.getBlockCls(core.nextX(1), core.nextY(1)) === null) {
									if (!core.isReplaying()) core.unlockControl()
									return
								}
								//插插棒
								//var enemy = core.material.enemys[block.event.id];
								core.drawAnimate("blackStick", core.nextX(1), core.nextY(1), false)
								var block1 = core.getBlock(core.nextX(1), core.nextY(1))
								//console.log(block1)
								var enemy = core.getEnemyInfo(block1.id, null, block1.x, block1.y, core.status.floorId)
								//return enemy && !enemy.notBomb;

								var a = core.getFlag("blackStick", [])
								a.push(String(core.nextX(1) + ',' + core.nextY(1) + ',' + core.status.floorId + ',3'))
								//插入格式：(x,y,楼层名,时长)
								core.setFlag("blackStick", a)
								if (core.getFlag('todo', []).length > 0) {
									core.insertAction(core.getFlag('todo', []))
									core.setFlag('todo', [])
								}
								if (!core.isReplaying()) core.unlockControl()

							})
						} else { //录像特供
							core.moveEnemy(x, y, core.nextX(1), core.nextY(1))
							if (core.status.hero.mana < core.status.hero.manamax) core.addStatus('mana', 1) //这万象天引肯定抓得到人，包给豆的
							core.dealDamage(core.getBlockId(core.nextX(1), core.nextY(1)), Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(core.nextX(1), core.nextY(1)), 'def', core.nextX(1), core.nextY(1), null)), core.nextX(1), core.nextY(1))
							if (core.getFlag('todo', []).length > 0) {
								core.insertAction(core.getFlag('todo', []))
								if (!core.isReplaying()) core.lockControl()
								core.setFlag('todo', [])
							}


							//插插棒

							var a = core.getFlag("blackStick", [])
							a.push(String(core.nextX(1) + ',' + core.nextY(1) + ',' + core.status.floorId + ',3'))
							//插入格式：(x,y,楼层名,时长)
							core.setFlag("blackStick", a)

						}
					} else { //有战后事件
						if (core.status.hero.mana < core.status.hero.manamax) core.addStatus('mana', 1) //这万象天引肯定抓得到人，包给豆的
						if (core.hasFlag('wxtyEX')) {
							if (!core.isReplaying()) core.drawAnimate("blackStick", x, y, false)
							var a = core.getFlag("blackStick", [])
							a.push(String(x + ',' + y + ',' + core.status.floorId + ',3'))
							//插入格式：(x,y,楼层名,时长)
							core.setFlag("blackStick", a)
						}
						core.dealDamage(core.getBlockId(x, y), 2 * Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null)), x, y)
						//console.log(block1)
						if (core.getFlag('todo', []).length > 0) {
							core.insertAction(core.getFlag('todo', []))
							core.setFlag('todo', [])
						}
						if (!core.isReplaying()) core.unlockControl()
					}

				})
			}

		} else if (skill === 2) {
			core.status.route.push('usk2')
			var manaGot = false //神罗天征打中人才能给豆
			if (!core.isReplaying()) core.lockControl()
			// 二技能-神罗天征
			if (core.getFlag('skill2CD', 0) != 0) {
				core.drawTip('技能还在冷却中')
				if (!core.isReplaying()) core.unlockControl()
				return
			}
			if (level === 3) {
				//超哥大神罗
				//var sound = core.rand(2) === 1 ? 'S2-1.wav' : 'S2-2.wav'
				//core.playSound(sound)




				core.updateStatusBar()

				core.insertCommonEvent('地图选择', ["选择佩恩四周任意一格或佩恩所在格使用神罗天征"], null, null, function () {


					if (!core.isReplaying()) core.lockControl()
					var x = core.getFlag('selectedX'),
						y = core.getFlag('selectedY'),
						heroX = core.getHeroLoc('x'),
						heroY = core.getHeroLoc('y')
					var xDis = Math.abs(x - core.getHeroLoc('x')),
						yDis = Math.abs(y - core.getHeroLoc('y'))

					if (xDis > 1 || yDis > 1) {
						core.drawTip('取消使用')
						if (!core.isReplaying()) core.unlockControl()
						return
					}



					if (xDis === 0 && yDis === 0) {

						if (core.getFlag('sltz3', 0) < 2) {
							core.drawTip('充能点不足！')
							if (!core.isReplaying()) core.unlockControl()
							return
						}
						core.playSound('CG-S2-1.wav')
						core.playSound('CG-S2-1V.wav')

						core.setFlag('skill2CD', 5)
						core.addFlag("sltz3", -2)
						var scan = core.utils.scan
						for (var direction in scan) {
							var delta = scan[direction];
							var x = core.getHeroLoc('x') + delta.x,
								y = core.getHeroLoc('y') + delta.y
							if (core.getBlockCls(x, y) === 'enemys') {
								var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
								core.dealDamage(core.getBlockId(x, y), per_damage * 2, x, y) //2倍伤害，主要推一下占模
								//if (core.getBlockCls(x + delta.x, y + delta.y, core.status.floorId, true) === 'null') {
								//	var oriEnemyHP = core.getEnemyValue(core.getBlockId(x, y), 'hp', x, y, null),
								//		oriEnemyATK = core.getEnemyValue(core.getBlockId(x, y), 'atk', x, y, null),
								//		oriEnemyDEF = core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null)
								//	core.setBlock(core.getBlockId(x, y), x + delta.x, y + delta.y)
								//	core.setEnemyOnPoint(x + delta.x, y + delta.y, core.status.floorId, 'hp', oriEnemyHP)
								//	core.setEnemyOnPoint(x + delta.x, y + delta.y, core.status.floorId, 'atk', oriEnemyATK)
								//	core.setEnemyOnPoint(x + delta.x, y + delta.y, core.status.floorId, 'def', oriEnemyDEF)
								//}
								var oriX = x,
									oriY = y,
									endX = x,
									endY = y
								//console.log(endX + delta.x, endY + delta.y)
								//var endX = 8 , endY = 3
								if (!core.isset(core.floors[core.status.floorId].afterBattle[x + "," + y])) { //无战后事件？
									while (core.getBlockCls(endX + delta.x, endY + delta.y, core.status.floorId, false) === null) {
										console.log(endX, endY)
										endX += delta.x;
										endY += delta.y;
									}
								} else {
									endX = x
									endY = y //有战后事件就别征飞了吧
								}

								var oriEnemyHP = core.getEnemyValue(core.getBlockId(oriX, oriY), 'hp', oriX, oriY, null)
								if (!core.isReplaying()) {
									core.jumpBlock(oriX, oriY, endX, endY, 500, true)
								} else {
									core.moveEnemy(oriX, oriY, endX, endY)
								}
								core.setEnemyOnPoint(endX, endY, core.status.floorId, 'hp', oriEnemyHP)


								manaGot = true //打到人了，给豆
							}

							if (core.getFlag('todo', []).length > 0) {
								core.insertAction(core.getFlag('todo', []))
								core.setFlag('todo', [])
							}
						}
						if (core.status.hero.mana < core.status.hero.manamax && manaGot) {
							core.addStatus('mana', 1);
							core.updateStatusBar()
						}
						if (!core.isReplaying()) core.unlockControl()

					} else if (xDis === 1 || yDis === 1) { //小神罗
						if (core.getFlag('sltz3', 0) < 1) {
							core.drawTip('充能点不足！')
							if (!core.isReplaying()) core.unlockControl()
							return
						}

						if (core.getFlag('selectedX') == heroX) {
							if (core.getFlag('selectedY') > heroY) {
								core.setHeroLoc('direction', 'down')
							} else {
								core.setHeroLoc('direction', 'up')
							}
						} else {
							if (core.getFlag('selectedX') > heroX) {
								core.setHeroLoc('direction', 'right')
							} else {
								core.setHeroLoc('direction', 'left')
							}
						}

						core.playSound('CG-S2-2.wav')
						core.playSound('CG-S2-2V.wav')
						core.clearMap('hero')
						core.drawHero()
						core.setFlag('skill2CD', 5)
						core.addFlag("sltz3", -1)
						var scan = core.utils.scan

						for (var direction in scan) {
							var delta = scan[direction];
							var x = core.getHeroLoc('x') + delta.x,
								y = core.getHeroLoc('y') + delta.y
							if (core.getBlockCls(x, y) === 'enemys') {
								var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
								core.dealDamage(core.getBlockId(x, y), per_damage * 1, x, y) //1倍伤害，主要推一下占模
								manaGot = true //打到人了，给豆
							}
							if (x == core.getFlag('selectedX') && y == core.getFlag('selectedY')) {
								var oriX = x,
									oriY = y,
									endX = x,
									endY = y

								while (core.getBlockCls(endX + delta.x, endY + delta.y, core.status.floorId, false) === null) {
									console.log(endX, endY)
									endX += delta.x;
									endY += delta.y;
								}

								var oriEnemyHP = core.getEnemyValue(core.getBlockId(oriX, oriY), 'hp', oriX, oriY, null)
								if (!core.isReplaying()) {
									core.jumpBlock(oriX, oriY, endX, endY, 500, true)
								} else {
									core.moveEnemy(oriX, oriY, endX, endY)
								}
								core.setEnemyOnPoint(endX, endY, core.status.floorId, 'hp', oriEnemyHP)

								if (!core.isReplaying()) core.unlockControl()
								if (core.status.hero.mana < core.status.hero.manamax && manaGot) {
									core.addStatus('mana', 1);
									core.updateStatusBar()
								}

							}
						}
					}



				})



				//处理战后事件
				//console.log(core.getFlag('todo', [])) core.insertAction(core.getFlag('todo'), []) core.setFlag('todo', []) setTimeout(function () { core.clearMap('animate') }, 100);


				if (!core.isReplaying()) { core.unlockControl() }

			} else if (level === 2) {
				//百战大神罗
				core.setFlag('skill2CD', 12) //我管你有的没的，跟我的12cd大征说去吧
				if (!core.isReplaying()) core.lockControl()
				core.updateStatusBar()
				var sound = 'BZ-S2-3.wav'
				core.playSound(sound, 100, function () {

				})
				var waitTime = 0
				if (core.isReplaying()) { //录像特供
					var scan = core.utils.scan2;
					for (var direction in scan) {
						var delta = scan[direction];
						var x = core.getHeroLoc('x') + delta.x,
							y = core.getHeroLoc('y') + delta.y
						if (core.getBlockCls(x, y) === 'enemys') {
							var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
							if (core.hasItem('cross') && core.including(["zombie", "zombieKnight", "vampire"], core.getBlockId(x, y))) {
								per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
							}
							if (core.hasItem('knife') && core.getBlockId(x, y) === 'magicDragon') {
								per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
							}
							core.dealDamage(core.getBlockId(x, y), per_damage * 5, x, y) //5倍伤害,这就是大征！！
							manaGot = true //打到人了，给豆

						}
						if (core.status.hero.mana < core.status.hero.manamax && manaGot) {
							core.addStatus('mana', 1);
							core.updateStatusBar()
						}
					}
					core.dealDamage(core.getBlockId(x, y), per_damage * 5, core.getHeroLoc('x'), core.getHeroLoc('y'))
				} else {
					core.setHeroOpacity(0)
					core.drawAnimate('sltz2', core.getHeroLoc('x'), core.getHeroLoc('y'), false, function () {
						core.setHeroOpacity(1)
					})

					for (let i = 0; i < 20; i++) {
						waitTime += 250

						setTimeout(function () {
							if (!core.isReplaying()) core.lockControl()
							var scan = core.utils.scan2;
							for (var direction in scan) {
								var delta = scan[direction];
								var x = core.getHeroLoc('x') + delta.x,
									y = core.getHeroLoc('y') + delta.y
								if (core.getBlockCls(x, y) === 'enemys') {
									var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
									if (core.hasItem('cross') && core.including(["zombie", "zombieKnight", "vampire"], core.getBlockId(x, y))) {
										per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
									}
									if (core.hasItem('knife') && core.getBlockId(x, y) === 'magicDragon') {
										per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
									}

									core.dealDamage(core.getBlockId(x, y), per_damage * 0.25, x, y) //5倍伤害,这就是大征！！
									manaGot = true //打到人了，给豆

								}
							}

							var xh = core.getHeroLoc('x'),
								yh = core.getHeroLoc('y')
							if (core.getBlockCls(xh, yh) === 'enemys') {
								var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(xh, yh), 'def', xh, yh, null))
								if (core.hasItem('cross') && core.including(["zombie", "zombieKnight", "vampire"], core.getBlockId(x, y))) {
									per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
								}
								if (core.hasItem('knife') && core.getBlockId(x, y) === 'magicDragon') {
									per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
								}

								core.dealDamage(core.getBlockId(xh, yh), per_damage * 0.25, xh, yh) //5倍伤害,这就是大征！！
								manaGot = true //打到人了，给豆
							}



							if (i === 19) {
								console.log(core.getFlag('todo', []))
								if (!core.isReplaying()) core.unlockControl()
								if (core.getFlag('todo', []).length > 0) {
									core.insertAction(core.getFlag('todo', []))
									core.setFlag('todo', [])

								}
								if (core.status.hero.mana < core.status.hero.manamax && manaGot) {
									core.addStatus('mana', 1);
									core.updateStatusBar()
								}

								core.setFlag('todo', [])
								setTimeout(function () { core.clearMap('animate') }, 100);
							}

						}, waitTime)

					}
				}

				//处理战后事件
				core.insertAction({
					"type": "while",
					"condition": "!core.same({},core.animateFrame.asyncId)",
					"data": [{
						"type": "sleep",
						"time": 100
					}, ],
				})
				if (core.getFlag('todo', []).length > 0) {
					core.insertAction(core.getFlag('todo', []))
					core.setFlag('todo', [])
				}
				core.setFlag('todo', [])

				setTimeout(function () { core.clearMap('animate') }, 100);

			} else {

				core.setFlag('skill2CD', 5)
				core.setFlag('noBattleAnimate', 1)

				core.updateStatusBar()
				//old佩恩神罗
				var sound = core.rand(2) === 1 ? 'S2-1.wav' : 'S2-2.wav'
				if (!core.isReplaying()) core.lockControl()
				core.playSound(sound, 100, function () {

					if (!core.isReplaying()) { core.unlockControl() }
				})

				if (!core.isReplaying()) {
					//core.stopAutomaticRoute()
					if (!core.isReplaying()) core.lockControl()

					setTimeout(function () {
						if (!core.isReplaying()) core.lockControl()
						core.setHeroOpacity(0)
						core.drawAnimate('sltz1', core.getHeroLoc('x'), core.getHeroLoc('y'), false, function () {
							core.setHeroOpacity(1)
						})
						var blocks = []
						var scan = core.hasFlag('sk2_1_lv2') ? core.utils.scan2 : core.utils.scan; //未获得刻印则只有周围四格
						for (var direction in scan) {
							if (!core.isReplaying()) core.lockControl()
							var delta = scan[direction];
							var x = core.getHeroLoc('x') + delta.x,
								y = core.getHeroLoc('y') + delta.y
							var block = core.getBlock(x, y);

							if (!(block == null || block.disable || block.event.cls.indexOf('enemy') != 0)) {
								var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
								if (core.hasItem('cross') && core.including(["zombie", "zombieKnight", "vampire"], core.getBlockId(x, y))) {
									per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
								}
								if (core.hasItem('knife') && core.getBlockId(x, y) === 'magicDragon') {
									per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
								}
								core.dealDamage(core.getBlockId(x, y), per_damage * 2.5, x, y)
								manaGot = true //打到人了，给豆
							}
							core.setFlag('skill2CD', 5)

						}

						var x = core.getHeroLoc('x'),
							y = core.getHeroLoc('y')
						var block = core.getBlock(x, y);

						if (!(block == null || block.disable || block.event.cls.indexOf('enemy') != 0)) {
							var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
							if (core.hasItem('cross') && core.including(["zombie", "zombieKnight", "vampire"], core.getBlockId(x, y))) {
								per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
							}
							if (core.hasItem('knife') && core.getBlockId(x, y) === 'magicDragon') {
								per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
							}
							core.dealDamage(core.getBlockId(x, y), per_damage * 2.5, x, y)
							manaGot = true //打到人了，给豆
						}

						if (core.status.hero.mana < core.status.hero.manamax && manaGot) {
							core.addStatus('mana', 1);
							core.updateStatusBar()
						}
						if (core.getFlag('todo', []).length > 0) {
							core.insertAction(core.getFlag('todo', []))
							if (!core.isReplaying()) core.lockControl()
							core.setFlag('todo', [])
						}

						if (!core.isReplaying()) core.lockControl()
						core.setFlag('noBattleAnimate', 0)
					}, 700)

				} else { //录像特供！！
					var scan = core.hasFlag('sk2_1_lv2') ? core.utils.scan2 : core.utils.scan; //未获得刻印则只有周围四格
					for (var direction in scan) {
						var delta = scan[direction];
						var x = core.getHeroLoc('x') + delta.x,
							y = core.getHeroLoc('y') + delta.y
						if (core.getBlockCls(x, y) === 'enemys') {
							var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
							if (core.hasItem('cross') && core.including(["zombie", "zombieKnight", "vampire"], core.getBlockId(x, y))) {
								per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
							}
							if (core.hasItem('knife') && core.getBlockId(x, y) === 'magicDragon') {
								per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
							}
							core.dealDamage(core.getBlockId(x, y), per_damage * 2.5, x, y)
							manaGot = true //打到人了，给豆
						}
					}

					var x = core.getHeroLoc('x'),
						y = core.getHeroLoc('y')

					if (core.getBlockCls(x, y) === 'enemys') {
						var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
						if (core.hasItem('cross') && core.including(["zombie", "zombieKnight", "vampire"], core.getBlockId(x, y))) {
							per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
						}
						if (core.hasItem('knife') && core.getBlockId(x, y) === 'magicDragon') {
							per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
						}
						core.dealDamage(core.getBlockId(x, y), per_damage * 2.5, x, y)
						manaGot = true //打到人了，给豆
					}

					core.setFlag('skill2CD', 5)
					if (core.status.hero.mana < core.status.hero.manamax && manaGot) {
						core.addStatus('mana', 1);
						core.updateStatusBar()
					}
					if (core.getFlag('todo', []).length > 0) {
						core.insertAction(core.getFlag('todo', []))
						core.setFlag('todo', [])
					}

				}
				//处理战后事件



				core.setFlag('todo', [])
				if (!core.isReplaying()) {
					setTimeout(function () {
						core.clearMap('animate')
					}, 100)
				}
			}


		} else {
			core.status.route.push('usk3')

			// 奥义
			if (core.status.hero.mana >= 4) { //没豆还想开奥义？
				core.setFlag('bossFinish', true)
				if (level === 3) { //超哥-佩恩六道
					core.insertCommonEvent('地图选择', ['即将使用轮回六道，请选择奥义目标'], null, null, function () {


						core.setFlag('noBattleAnimate', 1)
						var x = core.getFlag("selectedX"),
							y = core.getFlag("selectedY"),
							heroX = core.getHeroLoc('x'),
							heroY = core.getHeroLoc('y')
						if (core.getBlockCls(x, y) != 'enemys') {
							core.drawTip('取消使用')
							return
						}

						if (!core.isReplaying()) {
							if (!core.isReplaying()) core.lockControl()
							core.addStatus('mana', -4)
							core.pauseBgm()
							if (!core.isReplaying()) core.lockControl()
							core.setHeroOpacity(0)
							core.drawTip('我们是佩恩……')
							core.drawAnimate('pain6_1', heroX, heroY, false, function () {
								core.drawTip('……是神！')
								core.drawAnimate("pain6_2", x, y, false, function () {
									setTimeout(function () {
										core.drawAnimate('pain6_3', heroX, heroY, false, function () {
											if (core.getFlag('todo', []).length > 0) {
												core.insertAction(core.getFlag('todo', []))
												if (!core.isReplaying()) core.lockControl()
												core.setFlag('todo', [])
											}
											core.setHeroOpacity(1)
											core.setFlag('noBattleAnimate', 0)
											if (!core.isReplaying()) core.unlockControl()
											core.resumeBgm()
										})
									}, 500)
								})
								setTimeout(function () {
									core.dealDamage(core.getBlockId(x, y), hero.atk * 7, x, y)
									if (core.getFlag('todo', []).length > 0) {
										core.insertAction(core.getFlag('todo', []))
										core.setFlag('todo', [])
									}
									var a = core.getFlag("blackStick", [])
									a.push(String(core.nextX(1) + ',' + core.nextY(1) + ',' + core.status.floorId + ',' + 5))
									//插入格式：(x,y,楼层名,时长)
									core.setFlag("blackStick", a)
								}, 2150)
							})
						} else {
							core.dealDamage(core.getBlockId(x, y), hero.atk * 7, x, y)
							core.addStatus('mana', -4)
							if (core.getFlag('todo', []).length > 0) {
								core.insertAction(core.getFlag('todo', []))
								core.setFlag('todo', [])
							}
						}

					})
				} else if (level === 2) { //百战-超神罗天征
					core.insertCommonEvent('地图选择', ['即将使用超·神罗天征，再次点击佩恩以确定'], null, null, function () {
						if (!core.isReplaying()) core.lockControl()
						var x = core.getFlag("selectedX"),
							y = core.getFlag("selectedY"),
							heroX = core.getHeroLoc('x'),
							heroY = core.getHeroLoc('y')
						if (x === heroX && y == heroY) {
							if (core.isReplaying()) {
								core.addStatus('mana', -4)

								for (var i = -6; i < 7; i++) {
									for (var j = -6; j < 7; j++) {
										if (i === 6 || j === 6 || i === -6 || j === -6) {
											continue
										} else {
											var x1 = heroX + i,
												y1 = heroY + j
											if (core.getBlockCls(x1, y1) === 'enemys') {
												var per_damage1 = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x1, y1), 'def', x1, y1, null))
												if (core.hasItem('cross') && core.including(["zombie", "zombieKnight", "vampire"], core.getBlockId(x, y))) {
													per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
												}
												if (core.hasItem('knife') && core.getBlockId(x, y) === 'magicDragon') {
													per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
												}
												core.dealDamage(core.getBlockId(x1, y1), per_damage1 * 4, x1, y1)
												if (core.getFlag('todo', []).length > 0) { //奇怪，为什么缺了这个代码也能执行战后呢？
													core.insertAction(core.getFlag('todo', []))
													core.setFlag('todo', [])
												}
											}
										}
									}
								}
								return
							} else {
								core.pauseBgm()

								core.playSound('BZ-AY.wav', 100, function () { core.resumeBgm() })
								core.drawTip('我的痛苦在你之上！')

								core.addStatus('mana', -4)
								core.updateStatusBar()

								core.setHeroOpacity(0)
								core.setBlock()
								core.drawAnimate('dazheng', heroX, heroY)
								setTimeout(function () {
									core.setCurtain([255, 255, 255], 500)

									setTimeout(function () {
										core.setCurtain([255, 255, 255, 0.5], 500)
										core.vibrate('vertical', 3500, 3, 2)
									}, 1500)
									var waitTime2 = 400
									setTimeout(function () {
										core.setFlag('noBattleAnimate', false)
										for (var r = 0; r < 10; r++) {
											waitTime2 += 400
											setTimeout(function () {
												for (var i = -6; i < 7; i++) {
													for (var j = -6; j < 7; j++) {
														if (i === 6 || j === 6 || i === -6 || j === -6) {
															continue
														} else {
															var x1 = heroX + i,
																y1 = heroY + j
															if (core.getBlockCls(x1, y1) === 'enemys') {
																var per_damage1 = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x1, y1), 'def', x1, y1, null))
																if (core.hasItem('cross') && core.including(["zombie", "zombieKnight", "vampire"], core.getBlockId(x, y))) {
																	per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
																}
																if (core.hasItem('knife') && core.getBlockId(x, y) === 'magicDragon') {
																	per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x, y), 'def', x, y, null))
																}
																core.dealDamage(core.getBlockId(x1, y1), per_damage1 * 0.4, x1, y1)
																if (core.getFlag('todo', []).length > 0) { //奇怪，为什么缺了这个代码也能执行战后呢？
																	core.insertAction(core.getFlag('todo', []))
																	core.setFlag('todo', [])
																}
															}
														}
													}
												}
											}, waitTime2) //共4s
										}
									}, 1000)

									setTimeout(function () {
										core.setCurtain([255, 255, 255], 500)
									}, 4500)
									setTimeout(function () {
										core.setCurtain([255, 255, 255, 0], 500)
										core.setFlag('noBattleAnimate', true)
										core.drawAnimate('csltz2', 6, 6, false, function () {
											core.setCurtain([255, 255, 255], 1)
											core.setCurtain([255, 255, 255, 0], 500)
											core.drawAnimate('dazhengBack', heroX, heroY, false, function () {
												core.setHeroOpacity(1);
												if (!core.isReplaying()) core.unlockControl()
											})
										})
										core.drawTip('休想阻挡这和平之道……')
										core.setFlag('noBattleAnimate', false)

									}, 5000)
								}, 1000)
							}

						} else {
							core.drawTip('已取消使用')
							if (!core.isReplaying()) core.unlockControl()
							return
						}
					})
				} else { //old牢佩-地爆天星
					core.insertCommonEvent('地图选择', ['选择地爆天星的目标'], null, null, function () {

						if (!core.isReplaying()) core.lockControl()
						var x = core.getFlag("selectedX"),
							y = core.getFlag("selectedY"),
							heroX = core.getHeroLoc('x'),
							heroY = core.getHeroLoc('y')

						if (core.isReplaying()) { //录像特供
							if (core.hasFlag('sk3_1_lv2')) { //打完骷髅队长才能开进阶到21格
								var targets = [
									[x - 2, y],
									[x - 2, y - 1],
									[x - 2, y + 1],
									[x + 2, y],
									[x + 2, y - 1],
									[x + 2, y + 1],
									[x - 1, y + 2],
									[x + 1, y + 2],
									[x, y + 2],
									[x, y - 2],
									[x - 1, y - 2],
									[x + 1, y - 2],
									[x, y - 2],

									[x - 1, y - 1],
									[x, y - 1],
									[x + 1, y - 1],
									[x - 1, y],
									[x, y],
									[x + 1, y],
									[x - 1, y + 1],
									[x, y + 1],
									[x + 1, y + 1],
								]
							} else {
								var targets = [
									[x, y],
									[x + 1, y],
									[x - 1, y],
									[x + 1, y + 1],
									[x, y + 1],
									[x - 1, y + 1],
									[x + 1, y - 1],
									[x, y - 1],
									[x - 1, y - 1],
								]

							}
							if (core.hasFlag('sk3_4') && core.getStatus('mana', 4) == 6) {
								core.addStatus('mana', -6)
								for (var i = 0; i < targets.length; i++) {
									var x1 = targets[i][0],
										y1 = targets[i][1]
									if (core.getBlockCls(x1, y1) === 'enemys') {
										var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x1, y1), 'def', x1, y1, null))

										if (core.hasItem('cross') && core.including(["zombie", "zombieKnight", "vampire"], core.getBlockId(x, y))) {
											per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x1, y1), 'def', x1, y1, null))
										}
										if (core.hasItem('knife') && core.getBlockId(x, y) === 'magicDragon') {
											per_damage = Math.floor(core.status.hero.atk * 2 - core.getEnemyValue(core.getBlockId(x1, y1), 'def', x1, y1, null))
										}

										if (core.getBlockId(x1, y1) === 'redKing') {
											core.setEnemy("redKing", 'atk', 500)
											core.setEnemy("redKing", 'def', 100)
											core.setFlag('495', 1)
											core.setEnemyOnPoint(x1, y1, core.status.floorId, 'atk', 500)
											core.setEnemyOnPoint(x1, y1, core.status.floorId, 'def', 100)
											per_damage = Math.floor(core.status.hero.atk - 100)
										}
										core.dealDamage(core.getBlockId(x1, y1), per_damage * 7, x1, y1)
										if (core.getBlockCls(x1, y1) !== null) {
											core.setEnemyOnPoint(x1, y1, core.status.floorId, 'special', 'null')
											var a = core.getFlag("blackStick", [])
											a.push(String(x1 + ',' + y1 + ',' + core.status.floorId + ',3'))
											//插入格式：(x,y,楼层名,时长)
											core.setFlag("blackStick", a)
										}


									}
								}
							} else {
								core.addStatus('mana', -4)
								for (var i = 0; i < targets.length; i++) {
									var x1 = targets[i][0],
										y1 = targets[i][1]
									if (core.getBlockCls(x1, y1) === 'enemys') {
										var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x1, y1), 'def', x1, y1, null))

										if (core.getBlockId(x1, y1) === 'redKing') {
											core.setEnemy("redKing", 'atk', 500)
											core.setEnemy("redKing", 'def', 100)
											core.setFlag('495', 1)
											core.setEnemyOnPoint(6, 3, core.status.floorId, 'atk', 500)
											core.setEnemyOnPoint(6, 3, core.status.floorId, 'def', 100)
											per_damage = Math.floor(core.status.hero.atk - 100)
										}
										core.dealDamage(core.getBlockId(x1, y1), per_damage * 5, x1, y1)
									}
								}
							}

							return
						} //录像特供结束
						var liudao = false
						core.playSound('AY.wav', 100)
						if (core.hasFlag('sk3_4') && core.getStatus('mana', 4) === 6) { //六道地爆天星
							liudao = true
							core.addStatus('mana', -6)
							core.updateStatusBar()
							core.drawTip('通往和平的道路，我会一直坚定地走到最后……！')

						} else {
							core.addStatus('mana', -4)
							core.updateStatusBar()
							core.drawTip('你也给我感受一下痛苦吧！')
						}


						setTimeout(
							function () {

								var money1 = 0
								var todoo = []
								if (core.hasFlag('sk3_1_lv2')) { //打完骷髅队长才能开进阶到21格
									var targets = [
										[x - 2, y],
										[x - 2, y - 1],
										[x - 2, y + 1],
										[x + 2, y],
										[x + 2, y - 1],
										[x + 2, y + 1],
										[x - 1, y + 2],
										[x + 1, y + 2],
										[x, y + 2],
										[x, y - 2],
										[x - 1, y - 2],
										[x + 1, y - 2],
										[x, y - 2],

										[x - 1, y - 1],
										[x, y - 1],
										[x + 1, y - 1],
										[x - 1, y],
										[x, y],
										[x + 1, y],
										[x - 1, y + 1],
										[x, y + 1],
										[x + 1, y + 1],
									]
								} else {
									var targets = [
										[x, y],
										[x + 1, y],
										[x - 1, y],
										[x + 1, y + 1],
										[x, y + 1],
										[x - 1, y + 1],
										[x + 1, y - 1],
										[x, y - 1],
										[x - 1, y - 1],
									]

								}
								if (liudao) { //六道地爆天星

									for (var i = 0; i < targets.length; i++) {
										var x1 = targets[i][0],
											y1 = targets[i][1]
										if (core.getBlockCls(x1, y1) === 'enemys') {
											var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x1, y1), 'def', x1, y1, null))

											if (core.getBlockId(x1, y1) === 'redKing') {
												core.setEnemy("redKing", 'atk', 500)
												core.setEnemy("redKing", 'def', 100)
												core.setFlag('495', 1)
												core.setEnemyOnPoint(6, 3, core.status.floorId, 'atk', 500)
												core.setEnemyOnPoint(6, 3, core.status.floorId, 'def', 100)
												if (!core.hasFlag('495')) todoo.push("\t[redKing]这个术……！\n居然能够将我封印至1成功力，可真有你的啊……！")
												per_damage = Math.floor(core.status.hero.atk - 100)
											}
											if (core.getEnemyValue(core.getBlockId(x1, y1), 'hp', x1, y1, null) > per_damage * 7) {
												core.dealDamage(core.getBlockId(x1, y1), per_damage * 7, x1, y1)
												core.setEnemyOnPoint(x1, y1, core.status.floorId, 'special', 'null')
												var a = core.getFlag("blackStick", [])
												a.push(String(x1 + ',' + y1 + ',' + core.status.floorId + ',3'))
												//插入格式：(x,y,楼层名,时长)
												core.setFlag("blackStick", a)

											} else {
												//被地爆天星打私了的代码
												if (core.hasSpecial(core.material.enemys[core.getBlockId(x1, y1)].special, 29)) {
													core.setFlag('bossFinish', 1)
												}
												core.playSound('attack.mp3')
												var enemy = core.material.enemys[core.getBlockId(x1, y1)]
												//console.log(enemy.afterBattle)
												if (core.floors[core.status.floorId].afterBattle[x1 + "," + y1] || core.isset(enemy.afterBattle)) {
													core.push(todoo, core.floors[core.status.floorId].afterBattle[x1 + "," + y1]);
													core.push(todoo, enemy.afterBattle);
												}
												if (core.status.floorId === 'MT40' && core.hasFlag('40fBattle')) {
													core.addFlag('40BossBattle', 1)
													if (core.getFlag("40BossBattle", 0) >= 11) {
														core.insertAction({ "type": "insert", "loc": [0, 7] })
													}
												}

												//console.log(core.getEnemyValue(core.getBlockId(x1, y1), 'money', x1, y1))
												money1 = core.getEnemyValue(core.getBlockId(x1, y1), 'money', x1, y1)
												core.addStatus("money", money1)
												core.jumpBlock(x1, y1, x, 0, 1000, false)

											}

										}
									}

								} else { //普通地爆天星
									for (var i = 0; i < targets.length; i++) {
										var x1 = targets[i][0],
											y1 = targets[i][1]
										if (core.getBlockCls(x1, y1) === 'enemys') {
											var per_damage = Math.floor(core.status.hero.atk - core.getEnemyValue(core.getBlockId(x1, y1), 'def', x1, y1, null))

											if (core.getBlockId(x1, y1) === 'redKing') {
												core.setEnemy("redKing", 'atk', 500)
												core.setEnemy("redKing", 'def', 100)
												core.setFlag('495', 1)
												core.setEnemyOnPoint(6, 3, core.status.floorId, 'atk', 500)
												core.setEnemyOnPoint(6, 3, core.status.floorId, 'def', 100)
												if (!core.hasFlag('495')) todoo.push("\t[redKing]这个术……！\n居然能够将我封印至1成功力，可真有你的啊……！")
												per_damage = Math.floor(core.status.hero.atk - 100)
											}
											if (core.getEnemyValue(core.getBlockId(x1, y1), 'hp', x1, y1, null) > per_damage * 5) {
												core.dealDamage(core.getBlockId(x1, y1), per_damage * 5, x1, y1)
											} else {
												//被地爆天星打私了的代码
												if (core.hasSpecial(core.material.enemys[core.getBlockId(x1, y1)].special, 29)) {
													core.setFlag('bossFinish', 1)
												}
												core.playSound('attack.mp3')
												var enemy = core.material.enemys[core.getBlockId(x1, y1)]
												//console.log(enemy.afterBattle)
												if (core.floors[core.status.floorId].afterBattle[x1 + "," + y1] || core.isset(enemy.afterBattle)) {
													core.push(todoo, core.floors[core.status.floorId].afterBattle[x1 + "," + y1]);
													core.push(todoo, enemy.afterBattle);
												}
												if (core.status.floorId === 'MT40' && core.hasFlag('40fBattle')) {
													core.addFlag('40BossBattle', 1)
													if (core.getFlag("40BossBattle", 0) >= 11) {
														core.insertAction({ "type": "insert", "loc": [0, 7] })
													}
												}

												//console.log(core.getEnemyValue(core.getBlockId(x1, y1), 'money', x1, y1))
												money1 = core.getEnemyValue(core.getBlockId(x1, y1), 'money', x1, y1)
												core.addStatus("money", money1)
												core.jumpBlock(x1, y1, x, 0, 1000, false)

											}

										}
									}
								}

								core.insertAction(todoo)



							}, 2500
						)

						setTimeout(function () {
							if (core.getBlock(core.getHeroLoc('x'), core.getHeroLoc('y')) != null) {
								var vanishBlock = core.getBlockId(core.getHeroLoc('x'), core.getHeroLoc('y'))
							}
							if (!core.isReplaying()) core.unlockControl()
							core.setBlock(362, core.getHeroLoc('x'), core.getHeroLoc('y'));
							core.jumpBlock(heroX, heroY, x, 0, 700, false, function () {

							})

							core.drawAnimate('dbtx', x, 1)
						}, 2000)



					})


				}
			} else {
				core.drawTip('奥义点不足！')
				return
			}

		}


		//if (core.getFlag('todo', []).length > 0) {
		//	core.insertAction(core.getFlag('todo', []))
		//	core.setFlag('todo', [])
		//}
		//处理战后事件



	}
},
    "including": function () {
	// 在此增加新插件

	//判定list列表里有没有某个元素含有item字符
	this.including = function (list, item) {
		for (let i = 0; i < list.length; i++) {
			if (list[i].includes(item)) {
				return (true)
			}
		}
		return (false)
	}
	//得到list列表里有含有item字符元素的索引
	this.getIndex = function (list, item) {
		for (let i = 0; i < list.length; i++) {
			if (list[i].includes(item)) {
				return (i)
			}
		}
		return (null)

	}

	this.moveHeroTo = function (x, y) {
		core.setHeroLoc('x', x)
		core.setHeroLoc('y', y)
		core.clearMap('hero')
		core.drawHero()
	}

	this.removeFromList = function (list, item) {
		var newList = []
		for (let i = 0; i < list.length; i++) {
			if (list[i] === item) {
				continue
			}
			newList.push(item)
		}
		return newList
	}

	this.blackStickMinus = function (x, y, time) {
		if (core.including(core.getFlag("blackStick", []), String(x + ',' + y + ',' + core.status.floorId))) {
			var newlist = [],
				oldlist = core.getFlag("blackStick", [])
			for (let i = 0; i < oldlist.length; i++) {
				var item = oldlist[i].split(',')
				if (item[3] === '1') {

				} else {
					newlist.push(String(x + ',' + y + ',' + core.status.floorId + ',' + (Number(item[3]) - time)))
				}
			}
			core.setFlag("blackStick", newlist)
		} else {
			return
		}
	}

	this.blackStickAdd = function (x, y, time) {
		if (core.including(core.getFlag("blackStick", []), String(x + ',' + y + ',' + core.status.floorId))) {
			var newlist = [],
				oldlist = core.getFlag("blackStick", [])
			for (let i = 0; i < oldlist.length; i++) {
				var item = oldlist[i].split(',')
				if (item[3] === '1') {

				} else {
					newlist.push(String(x + ',' + y + ',' + core.status.floorId + ',' + (Number(item[3]) + time)))
				}
			}
			core.setFlag("blackStick", newlist)
		} else {
			return
		}
	}

	this.sleep = function (time) {
		core.insertAction({
			"type": "sleep",
			"time": time
		})
	}

	this.battleWith = function (x, y) {
		if (core.getBlockCls(x, y) === 'enemys') {
			core.playSound('attack.mp3');
			core.drawImage("animate", core.statusBar.icons.battle, 0, 0, 32, 32, (x - 1) * 32, (y - 1) * 32, 32, 32);
			core.addStatus('hp', 0 - core.getDamage(core.getBlockId(x, y, core.status.floorId), x, y, core.status.floorId))
			if (core.getStatus('hp') <= 0) {
				core.lose()
				return
			}
			var money = core.getEnemyValue('money', core.getBlockId(x, y, core.status.floorId), x, y, core.status.floorId)
			if (core.hasItem('coin')) { money *= 2 }
			core.addStatus('money', money)
			core.drawTip(String(core.getEnemyInfo(core.getBlockId(x, y, core.status.floorId), x, y, core.status.floorId).name) + ' 被打败了，你获得了 ' + String(money) + ' 金币')
			core.clearMap("animate", (x - 1) * 32, (y - 1) * 32, 32, 32)
			core.insertAction(core.floors[core.status.floorId].afterBattle[x + "," + y])
			core.insertAction(core.material.enemys[core.getBlockId(x, y)].afterBattle)
			core.removeBlock(x, y, core.status.floorId)

		} else {
			return //没怪打个集贸
		}
	}

	this.autoSpin = function (xDis, yDis, x, y) {
		if (xDis > yDis) {
			if (x > core.getHeroLoc('x')) {
				core.setHeroLoc('direction', 'right')
			} else {
				core.setHeroLoc('direction', 'left')
			}
		} else {
			if (y > core.getHeroLoc('y')) {
				core.setHeroLoc('direction', 'down')
			} else {
				core.setHeroLoc('direction', 'up')
			}
		}
	}

	this.moveEnemy = function (sx, sy, ex, ey) {
		if (sx === ex && sy === ey) { return } //原地乱蹦啥阴间
		core.setBlock(core.getBlockId(sx, sy), ex, ey)
		core.moveEnemyOnPoint(sx, sy, ex, ey)
		core.removeBlock(sx, sy)

	}






},
    "tishenAbility": function () {
	// 原理是修改全图的可通行性
	this.tishenOn = function () {
		if (core.status.thisMap) {
			var floorCache = core.getFloorCache()
			var blocks = core.status.thisMap.blocks
			for (var i = 0; i < blocks.length; i++) {
				if (blocks[i].event && blocks[i].event.cls.indexOf('enemy') == 0) {
					blocks[i].event.noPass = false
					if (floorCache.enemys[blocks[i].x + ',' + blocks[i].y] && floorCache.enemys[blocks[i].x + ',' + blocks[i].y].specialName) {
						blocks[i].event.noPass = true
					}
				}
			}
		}
		core.setFlag('__heroOpacity__', 0.5)
		core.setStatus('inTishen', true)
		core.drawHero()
		core.updateStatusBar()
	}

	this.tishenOff = function () {
		if (core.status.thisMap) {
			var blocks = core.status.thisMap.blocks
			for (var i = 0; i < blocks.length; i++) {
				if (blocks[i].event && blocks[i].event.cls.indexOf('enemy') == 0) {
					blocks[i].event.noPass = true
				}
			}
		}
		core.setStatus('inTishen', false)
		core.setFlag('__heroOpacity__', 1)
		core.drawHero()
		core.updateStatusBar()
	}

	this.getFloorCache = function () {
		if (core.getStatus('floorCache') == null) {
			var cache = { enemys: {} }
			var floorId = core.status.floorId
			cache.floorId = floorId
			core.status.maps[floorId].blocks.forEach(function (block) {
				if (core.isset(block.event) && !block.disable) {
					// 获得该图块的ID
					var id = block.event.id,
						__enemy = core.material.enemys[id]
					// 检查是不是怪物，且是否拥有该特殊属性
					if (core.isset(__enemy)) {
						var temp = { id: id }
						temp.special = __enemy.special
						temp.specialName = __enemy.specialName
						cache.enemys[block.x + ',' + block.y] = temp
					}
				}
			})
			core.setStatus('floorCache', cache)
		}
		return core.getStatus('floorCache')
	}


},
    "bigTiji": undefined
}