main.challenges['none'] = { 'id': 'none', 'name': '标准', 'hard': 10, 'script': function () { } }
main.challenges['3648'] = {
    'id': '3648',
    'name': '36F没有暗道，48F没有警卫',
    'hard': 10,
    'script': function () {
        main.floors.MT36.map.forEach(x => [...x.keys()].forEach(y => x[y] -= (x[y] == 3 ? 2 : 0)));
        main.floors.MT48.map[1][1] = 0
    }
}
main.challenges['105p'] = {
    'id': '105p',
    'name': '怪物攻防+5%',
    'hard': 10,
    'script': function () {
        for (var i in enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80) {
            enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].atk = Math.floor(enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].atk * 1.05)
            enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].def = Math.floor(enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].def * 1.05)
        }
    }
}
main.challenges['r1b1'] = {
    'id': 'r1b1',
    'name': '红宝石+1 蓝宝石-1',
    'hard': 10,
    'script': function () {
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.redGem = {
            "cls": "items",
            "name": "红宝石",
            "text": "攻击+${core.values.redGem+1}",
            "itemEffect": "core.status.hero.atk += core.values.redGem * core.status.thisMap.ratio + 1",
            "itemEffectTip": "，提升 ${core.values.redGem * core.status.thisMap.ratio+1} 点攻击",
            "useItemEffect": "core.status.hero.atk += core.values.redGem + 1",
            "canUseItemEffect": "true"
        };
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.blueGem = {
            "cls": "items",
            "name": "蓝宝石",
            "text": "，防御+${core.values.blueGem-1}",
            "itemEffect": "core.status.hero.def += core.values.blueGem * core.status.thisMap.ratio-1",
            "itemEffectTip": "，提升 ${core.values.blueGem * core.status.thisMap.ratio - 1} 点防御",
            "useItemEffect": "core.status.hero.def += core.values.blueGem - 1",
            "canUseItemEffect": "true"
        };
    }
}
main.challenges['shop'] = {
    'id': 'shop',
    'name': '商店打包出售',
    'hard': 10,
    'script': function () {
        data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.firstData.shops = [
            {
                "id": "shop1",
                "text": "\t[贪婪之神,blueShop]勇士啊, 给我${20+10*flag:次数*(flag:次数-1)}金币就可以：",
                "textInList": "一区商店",
                "mustEnable": true,
                "disablePreview": false,
                "choices": [
                    {
                        "text": "生命+${100*flag:次数} 攻击+2 防御+4",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:hp",
                                "operator": "+=",
                                "value": "100*flag:次数"
                            },
                            {
                                "type": "setValue",
                                "name": "status:atk",
                                "operator": "+=",
                                "value": "2"
                            },
                            {
                                "type": "setValue",
                                "name": "status:def",
                                "operator": "+=",
                                "value": "4"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    }
                ]
            },
            {
                "id": "shop2",
                "text": "\t[贪婪之神,blueShop]勇士啊, 给我${20+10*flag:次数*(flag:次数-1)}金币就可以：",
                "textInList": "二区商店",
                "mustEnable": true,
                "disablePreview": false,
                "choices": [
                    {
                        "text": "生命+${100*flag:次数} 攻击+4 防御+8",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:hp",
                                "operator": "+=",
                                "value": "100*flag:次数"
                            },
                            {
                                "type": "setValue",
                                "name": "status:atk",
                                "operator": "+=",
                                "value": "4"
                            },
                            {
                                "type": "setValue",
                                "name": "status:def",
                                "operator": "+=",
                                "value": "8"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    }
                ]
            },
            {
                "id": "shop3",
                "text": "\t[贪婪之神,blueShop]勇士啊, 给我${20+10*flag:次数*(flag:次数-1)}金币就可以：",
                "textInList": "四区商店",
                "mustEnable": true,
                "disablePreview": false,
                "choices": [
                    {
                        "text": "生命+${100*flag:次数} 攻击+8 防御+16",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:hp",
                                "operator": "+=",
                                "value": "100*flag:次数"
                            },
                            {
                                "type": "setValue",
                                "name": "status:atk",
                                "operator": "+=",
                                "value": "8"
                            },
                            {
                                "type": "setValue",
                                "name": "status:def",
                                "operator": "+=",
                                "value": "16"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    }
                ]
            },
            {
                "id": "shop4",
                "text": "\t[贪婪之神,blueShop]勇士啊, 给我${20+10*flag:次数*(flag:次数-1)}金币就可以：",
                "textInList": "五区商店",
                "mustEnable": true,
                "disablePreview": false,
                "choices": [
                    {
                        "text": "生命+${100*flag:次数} 攻击+10 防御+20",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:hp",
                                "operator": "+=",
                                "value": "100*flag:次数"
                            },
                            {
                                "type": "setValue",
                                "name": "status:atk",
                                "operator": "+=",
                                "value": "10"
                            },
                            {
                                "type": "setValue",
                                "name": "status:def",
                                "operator": "+=",
                                "value": "20"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    }
                ]
            },
            {
                "id": "shop5",
                "text": "\t[商人,woman]我能以100金币一把的价格回收黄钥匙！",
                "textInList": "回收钥匙商店",
                "mustEnable": true,
                "disablePreview": false,
                "choices": [
                    {
                        "text": "我太需要了",
                        "need": "item:yellowKey>=1",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "+=",
                                "value": "100"
                            },
                            {
                                "type": "setValue",
                                "name": "item:yellowKey",
                                "operator": "-=",
                                "value": "1"
                            }
                        ]
                    },
                    {
                        "text": "我要卖10把",
                        "need": "item:yellowKey>=10",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "+=",
                                "value": "1000"
                            },
                            {
                                "type": "setValue",
                                "name": "item:yellowKey",
                                "operator": "-=",
                                "value": "10"
                            }
                        ]
                    }
                ]
            }
        ]
    }
}
main.challenges['RPGDamage'] = {
    'id': 'RPGDamage',
    'name': '防御纸糊',
    'hard': 10,
    'script': function () {
        functions_d6ad677b_427a_4623_b50f_a445a3b0ef8a.enemys.getDamageInfo = function (enemy, hero, x, y, floorId) {
            // 获得战斗伤害信息（实际伤害计算函数）
            // 
            // 参数说明：
            // enemy：该怪物信息
            // hero：勇士的当前数据；如果对应项不存在则会从core.status.hero中取。
            // x,y：该怪物的坐标（查看手册和强制战斗时为undefined）
            // floorId：该怪物所在的楼层
            // 后面三个参数主要是可以在光环等效果上可以适用
            floorId = floorId || core.status.floorId;

            var hero_hp = core.getRealStatusOrDefault(hero, 'hp'),
                hero_atk = core.getRealStatusOrDefault(hero, 'atk'),
                hero_def = core.getRealStatusOrDefault(hero, 'def'),
                hero_mdef = core.getRealStatusOrDefault(hero, 'mdef'),
                origin_hero_hp = core.getStatusOrDefault(hero, 'hp'),
                origin_hero_atk = core.getStatusOrDefault(hero, 'atk'),
                origin_hero_def = core.getStatusOrDefault(hero, 'def');

            // 勇士的负属性都按0计算
            hero_hp = Math.max(0, hero_hp);
            hero_atk = Math.max(0, hero_atk);
            hero_def = Math.max(0, hero_def);
            hero_mdef = Math.max(0, hero_mdef);

            // 怪物的各项数据
            // 对坚固模仿等处理扔到了脚本编辑-getEnemyInfo之中
            var enemyInfo = core.enemys.getEnemyInfo(enemy, hero, x, y, floorId);
            var mon_hp = enemyInfo.hp,
                mon_atk = enemyInfo.atk,
                mon_def = enemyInfo.def,
                mon_money = enemyInfo.money,
                mon_exp = enemyInfo.exp,
                mon_special = enemyInfo.special;

            // 技能的处理
            if (core.getFlag('skill', 0) == 1) { // 开启了技能1：二倍斩
                hero_atk *= 2; // 计算时攻击力翻倍    
            }
            if (core.hasItem('cross') && ["zombie", "zombieKnight", "vampire"].indexOf(enemy.id) >= 0) {
                hero_atk *= 2;
            }
            if (core.hasItem('knife') && enemy.id == "magicDragon") {
                hero_atk *= 2;
            }

            // 如果是无敌属性，且勇士未持有十字架
            if (core.hasSpecial(mon_special, 20) && !core.hasItem("cross"))
                return null; // 不可战斗

            // 战前造成的额外伤害（可被护盾抵消）
            var init_damage = 0;

            // 吸血
            if (core.hasSpecial(mon_special, 11)) {
                var vampire_damage = hero_hp * enemy.vampire;


                // 如果有神圣盾免疫吸血等可以在这里写
                // 也可以用hasItem和hasEquip来判定装备
                // if (core.hasFlag('shield5')) vampire_damage = 0;

                vampire_damage = Math.floor(vampire_damage) || 0;
                // 加到自身
                if (enemy.add) // 如果加到自身
                    mon_hp += vampire_damage;

                init_damage += vampire_damage;
            }

            // 每回合怪物对勇士造成的战斗伤害
            var per_damage = mon_atk * mon_atk / (mon_atk + hero_def);
            // 魔攻：战斗伤害就是怪物攻击力
            if (core.hasSpecial(mon_special, 2)) per_damage = mon_atk;
            // 战斗伤害不能为负值
            if (per_damage < 0) per_damage = 0;

            // 2连击 & 3连击 & N连击
            if (core.hasSpecial(mon_special, 4)) per_damage *= 2;
            if (core.hasSpecial(mon_special, 5)) per_damage *= 3;
            if (core.hasSpecial(mon_special, 6)) per_damage *= (enemy.n || 4);

            // 每回合的反击伤害；反击是按照勇士的攻击次数来计算回合
            var counterDamage = 0;
            if (core.hasSpecial(mon_special, 8))
                counterDamage += Math.floor((enemy.counterAttack || core.values.counterAttack) * hero_atk);

            // 先攻
            if (core.hasSpecial(mon_special, 1)) init_damage += per_damage;
            if (core.getFlag('attackFirst', 0) == 1) init_damage += per_damage;
            // 破甲
            if (core.hasSpecial(mon_special, 7))
                init_damage += Math.floor((enemy.breakArmor || core.values.breakArmor) * hero_def);

            // 净化
            if (core.hasSpecial(mon_special, 9))
                init_damage += Math.floor((enemy.purify || core.values.purify) * hero_mdef);


            // 勇士每回合对怪物造成的伤害
            var hero_per_damage = Math.max(hero_atk * hero_atk / (hero_atk + mon_def), 0);

            // 如果没有破防，则不可战斗
            if (hero_per_damage <= 0) return null;

            // 勇士的攻击回合数；为怪物生命除以每回合伤害向上取整
            var turn = Math.ceil(mon_hp / hero_per_damage);

            // ------ 支援 ----- //
            // 这个递归最好想明白为什么，flag:__extraTurn__是怎么用的
            var guards = core.getFlag("__guards__" + x + "_" + y, enemyInfo.guards);
            var guard_before_current_enemy = false; // ------ 支援怪是先打(true)还是后打(false)？
            turn += core.getFlag("__extraTurn__", 0);
            if (guards.length > 0) {
                if (!guard_before_current_enemy) { // --- 先打当前怪物，记录当前回合数
                    core.setFlag("__extraTurn__", turn);
                }
                // 获得那些怪物组成小队战斗
                for (var i = 0; i < guards.length; i++) {
                    var gx = guards[i][0],
                        gy = guards[i][1],
                        gid = guards[i][2];
                    // 递归计算支援怪伤害信息，这里不传x,y保证不会重复调用
                    // 这里的mdef传0，因为护盾应该只会被计算一次
                    var info = core.enemys.getDamageInfo(core.material.enemys[gid], { hp: origin_hero_hp, atk: origin_hero_atk, def: origin_hero_def, mdef: 0 });
                    if (info == null) { // 小队中任何一个怪物不可战斗，直接返回null
                        core.removeFlag("__extraTurn__");
                        return null;
                    }
                    // 已经进行的回合数
                    core.setFlag("__extraTurn__", info.turn);
                    init_damage += info.damage;
                    mon_money += info.mon_money;
                    mon_exp += info.mon_exp;
                }
                if (guard_before_current_enemy) { // --- 先打支援怪物，增加当前回合数
                    turn += core.getFlag("__extraTurn__", 0);
                }
            }
            core.removeFlag("__extraTurn__");
            // ------ 支援END ------ //

            // 最终伤害：初始伤害 + 怪物对勇士造成的伤害 + 反击伤害
            var damage = init_damage + (turn - 1) * per_damage + turn * counterDamage;
            // 再扣去护盾
            damage -= hero_mdef;

            // 检查是否允许负伤
            if (!core.flags.enableNegativeDamage)
                damage = Math.max(0, damage);

            // 最后处理仇恨和固伤（因为这两个不能被护盾减伤）
            if (core.hasSpecial(mon_special, 17)) { // 仇恨
                damage += core.getFlag('hatred', 0);
            }
            if (core.hasSpecial(mon_special, 22)) { // 固伤
                damage += enemy.damage || 0;
            }

            return {
                "mon_hp": Math.floor(mon_hp),
                "mon_atk": Math.floor(mon_atk),
                "mon_def": Math.floor(mon_def),
                "init_damage": Math.floor(init_damage),
                "per_damage": Math.floor(per_damage),
                "hero_per_damage": Math.floor(hero_per_damage),
                "turn": Math.floor(turn),
                "damage": Math.floor(damage),
                "mon_money": Math.floor(mon_money),
                "mon_exp": Math.floor(mon_exp)
            };
        }
    }
}
main.challenges['51taptap'] = {
    'id': '51taptap',
    'name': '50层魔塔taptap版',
    'hard': 10,
    'superPotion_atk_ratio': 1,
    'superPotion_def_ratio': 1,
    'superPotion_hp_ratio': 0,
    'swordEmperor_hp': 8000,
    'script': function () {
        enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80.redPriest.money = 18;
        enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80.zombie.money = 22;
        enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80.octopus.money = 500;
        enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80.blueGuard.money = 50;
        enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80.blackKing.special = 15;
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.bomb.useItemEffect =
            "(function () {\n\tvar bombList = []; // 炸掉的怪物坐标列表\n\tvar todo = []; // 炸弹后事件\n\tvar money = 0,\n\t\texp = 0; // 炸弹获得的金币和经验\n\n\tvar canBomb = function (x, y) {\n\t\tvar block = core.getBlock(x, y);\n\t\tif (block == null || block.disable || block.event.cls.indexOf('enemy') != 0) return false;\n\t\tvar enemy = core.material.enemys[block.event.id];\n\t\treturn enemy && !enemy.notBomb;\n\t};\n\n\tvar bomb = function (x, y) {\n\t\tif (!canBomb(x, y)) return;\n\t\tbombList.push([x, y]);\n\t\tvar id = core.getBlockId(x, y),\n\t\t\tenemy = core.material.enemys[id];\n\t\tmoney += core.getEnemyValue(enemy, 'money', x, y) || 0;\n\t\texp += core.getEnemyValue(enemy, 'exp', x, y) || 0;\n\t\tcore.push(todo, core.floors[core.status.floorId].afterBattle[x + \",\" + y]);\n\t\tcore.push(todo, enemy.afterBattle);\n\t\tcore.removeBlock(x, y);\n\t}\n\n\t// 如果要多方向可炸，把这里的false改成true\n\tif (true) {\n\t\tvar scan = core.utils.scan; // 多方向炸时默认四方向，如果要改成八方向炸可以改成 core.utils.scan2\n\t\tfor (var direction in scan) {\n\t\t\tvar delta = scan[direction];\n\t\t\tbomb(core.getHeroLoc('x') + delta.x, core.getHeroLoc('y') + delta.y);\n\t\t}\n\t} else {\n\t\t// 仅炸当前\n\t\tbomb(core.nextX(), core.nextY());\n\t}\n\n\tif (bombList.length == 0) {\n\t\tcore.playSound('操作失败');\n\t\tcore.drawTip('当前无法使用' + core.material.items[itemId].name, itemId);\n\t\tcore.addItem(itemId, 1);\n\t\treturn;\n\t}\n\n\tcore.playSound('炸弹');\n\tcore.drawTip(core.material.items[itemId].name + '使用成功', itemId);\n\n\t// 取消这里的注释可以炸弹后获得金币和经验\n\n\t// 取消这里的注释可以炸弹引发战后事件\n\tif (todo.length > 0) core.insertAction(todo);\n\n})();";

        delete main.floors.MT32.events['6,10'];
        delete main.floors.MT33.events['9,10'];
        main.floors.MT33.map[10][1] = 224;
        main.floors.MT33.map[11][2] = 225;
        main.floors.MT35.map[3][5] = 0;
        main.floors.MT35.map[3][6] = 0;
        main.floors.MT35.map[3][7] = 0;
        main.floors.MT15.map[8][11]--;
        main.floors.MT40.events['6,7'].splice(2, 1);
        main.floors.MT1.firstArrive = [{ "type": "setEnemyOnPoint", "loc": [[2, 2], [3, 2], [4, 2], [8, 2], [9, 2], [10, 2], [6, 1], [3, 4], [4, 4], [5, 4], [7, 4], [8, 4], [9, 4]], "floorId": "MT40", "name": "special", "value": "1" }]
        main.floors.MT41.events['10,2'][0].true =
            main.floors.MT41.events['10,2'][0].true.concat(main.floors.MT41.afterBattle['10,2']);
        main.floors.MT41.events['10,2'][0].true.splice(-1, 1);
        main.floors.MT48.map[5][11] = 0;
        main.floors.MT2.events['11,7'][1].choices[0].action[1].value = '(Math.floor((status:atk*0.03)))'
        main.floors.MT2.events['11,7'][1].choices[0].action[2].value = '(Math.floor((status:def*0.03)))'

        delete main.floors.MT41.afterBattle['10,2'];
        var origin_updateCheckBlock = functions_d6ad677b_427a_4623_b50f_a445a3b0ef8a.control.updateCheckBlock;

        functions_d6ad677b_427a_4623_b50f_a445a3b0ef8a.control.updateCheckBlock =
            function (floorId) {
                // 领域、夹击、阻击等的伤害值计算
                floorId = floorId || core.status.floorId;
                if (!floorId || !core.status.maps) return;

                origin_updateCheckBlock(floorId);

                for (var i in core.status.checkBlock.damage)
                    core.status.checkBlock.damage[i] = Math.min(core.status.checkBlock.damage[i], core.status.hero.hp - 1)
            }
    }
}
main.challenges['64121'] = {
    'id': '64121',
    'name': '641的21层魔塔',
    'hard': 10,
    'superPotion_atk_ratio': 0,
    'superPotion_def_ratio': 0,
    'superPotion_hp_ratio': 1,
    'naming': '护盾${core.status.hero.mdef}',
    'script': function () {
        for (var i in enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80) {
            enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].atk =
                Math.floor(enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].atk * 0.5)
            enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].def =
                Math.floor(enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].def * 0.5)
            enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].hp =
                Math.floor(enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].hp * 0.5)
            enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].money =
                Math.floor(enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].money * 0.5)
        }
        enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80.yellowGuard.atk -= 2;
        enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80.vampire.money = 24;
        main.floors.MT1.map[11][2] = 50;
        main.floors.MT2.events['11,4'] = [
            {
                'type': 'comment',
                'text': '\\d\\c[24]\\i[I361]\\i[A367]\\c\r[rgb(224,210,69)](+500G)'
            },
            '\t[老登,man]谢谢你救了我，为了感谢你的帮助请收下这些礼物。',
            {
                'type': 'setValue',
                'name': 'status:money',
                'operator': '+=',
                'value': '500'
            },
            { 'type': 'hide', 'remove': true, 'time': 200 },
        ];
        main.floors.MT2.events['11,7'][1].choices[0].action[1].value =
            '(Math.floor((status:atk*0.03)))'
        main.floors.MT2.events['11,7'][1].choices[0].action[2].value =
            '(Math.floor((status:def*0.03)))'
        main.floors.MT2.events['11,11'] = [
            '\t[小偷,thief]帮你开13楼的门',
            {
                'type': 'hide',
                'loc': [[6, 6], [6, 7], [6, 8], [6, 9]],
                'floorId': 'MT13',
                'remove': true,
                'time': 500
            },
            { 'type': 'hide', 'remove': true, 'time': 500 },
        ]
        main.floors.MT3.events['5,9'].splice(11, 1);
        main.floors.MT3.events['11,4'].splice(
            1, 0, '\t[老人,man]送你一个破墙镐！',
            { 'type': 'setValue', 'name': 'item:pickaxe', 'value': 'item:pickaxe+1' })
        main.floors.MT5.map[9][4] = 49;
        main.floors.MT9.map[8][11] = 0;
        main.floors.MT10.afterBattle['6,1'][0].true.splice(2, 12);
        main.floors.MT12.events['1,1'] = [
            {
                'type': 'comment',
                'text':
                    '\\d\\c[24]\\i[I361]\\c\r[rgb(244,108,108)](-800G)\\c[24]\\i[T358]\\i[greenKey]\\c\r[rgb(244,108,108](+1)'
            },
            {
                'type': 'if',
                'condition': 'switch:A',
                'true': [
                    '\t[商人,woman]你注意到9、16、18层的暗道了吗？',
                    { 'type': 'hide', 'remove': true },
                ],
                'false': [
                    {
                        'type': 'choices',
                        'text': '\t[商人,woman]我800金币卖1把珍稀的绿钥匙，你买吗？',
                        'choices': [
                            {
                                'text': '我太需要了',
                                'need': 'status:money>=800',
                                'action': [
                                    {
                                        'type': 'setValue',
                                        'name': 'status:money',
                                        'operator': '-=',
                                        'value': '800'
                                    },
                                    {
                                        'type': 'setValue',
                                        'name': 'status:mdef',
                                        'operator': '+=',
                                        'value': '5'
                                    },
                                    {
                                        'type': 'setValue',
                                        'name': 'item:greenKey',
                                        'operator': '+=',
                                        'value': '1'
                                    },
                                    { 'type': 'setValue', 'name': 'switch:A', 'value': 'true' },
                                ]
                            },
                            {
                                'text': '离开',
                                'action': [

                                ]
                            },
                        ]
                    },
                ]
            },
        ]
        main.floors.MT13.map[5][6] = 56;
        main.floors.MT19.map[3][6] = 53;
        delete main.floors.MT19.events['6,3'];
        main.floors.MT20.afterBattle['6,6'].splice(3, 4);
        delete main.floors.MT21.changeFloor['6,11'];
        main.floors.MT21.map[6][6] = 208;
        main.floors.MT21.map[5][6] = 84;
        main.floors.MT21.map[6][5] = 84;
        main.floors.MT21.map[7][6] = 84;
        main.floors.MT21.map[6][7] = 84;
        main.floors.MT21.afterBattle['6,6'] = [{ 'type': 'win', 'reason': 'win' }];
        main.floors.MT1.firstArrive = [{
            'type': 'setEnemyOnPoint',
            'loc': [[6, 6]],
            'floorId': 'MT21',
            'name': 'hp',
            'value': '1476'
        }]

        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.redPotion.itemEffect = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.bluePotion.itemEffect = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.redPotion.itemEffectTip = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.bluePotion.itemEffectTip = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.redGem.itemEffect =
            'core.status.hero.mdef += 1'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.blueGem.itemEffect =
            'core.status.hero.mdef += 1'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.redGem.itemEffectTip =
            '，提升一点护盾，当前护盾为${core.status.hero.mdef}'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.blueGem.itemEffectTip =
            '，提升一点护盾，当前护盾为${core.status.hero.mdef}'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword1.itemEffect =
            'core.status.hero.atk += 5;\ncore.setFlag(\'nowWeapon\', \'sword1\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword2.itemEffect =
            'core.status.hero.atk += 10;\ncore.setFlag(\'nowWeapon\', \'sword2\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword1.itemEffectTip =
            '，提升 5 点攻击'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword2.itemEffectTip =
            '，提升 10 点攻击'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield1.itemEffect =
            'core.status.hero.def += 5;\ncore.setFlag(\'nowShield\', \'shield1\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield2.itemEffect =
            'core.status.hero.def += 10;\ncore.setFlag(\'nowShield\', \'shield2\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield1.itemEffectTip =
            '，提升 5 点防御'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield2.itemEffectTip =
            '，提升 10 点防御'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.pickaxe.useItemEffect =
            '(function () {\n\tvar canBreak = function (x, y) {\n\t\tvar block = core.getBlock(x, y);\n\t\tif (block == null || block.disable) return false;\n\t\treturn block.event.canBreak;\n\t};\n\n\tvar success = false;\n\tvar pickaxeFourDirections = false; // 是否多方向破；如果是将其改成true\n\tif (pickaxeFourDirections) {\n\t\t// 多方向破\n\t\tfor (var direction in core.utils.scan) { // 多方向破默认四方向，如需改成八方向请将这两个scan改为scan2\n\t\t\tvar delta = core.utils.scan[direction];\n\t\t\tvar nx = core.getHeroLoc(\'x\') + delta.x,\n\t\t\t\tny = core.getHeroLoc(\'y\') + delta.y;\n\t\t\ttrue\n\t\t\tif (canBreak(nx, ny)) {\n\t\t\t\tcore.removeBlock(nx, ny);\n\t\t\t\tsuccess = true;\n\t\t\t}\n\t\t}\n\t} else {\n\t\t// 仅破当前\n\t\tif (canBreak(core.nextX(), core.nextY())) {\n\t\t\tcore.removeBlock(core.nextX(), core.nextY());\n\t\t\tsuccess = true;\n\t\t}\n\t}\n\n\tif (success) {\n\t\tcore.playSound(\'破墙镐\');\n\t\tcore.drawTip(core.material.items[itemId].name + \'使用成功\', itemId);\n\t} else {\n\t\t// 无法使用\n\t\tcore.playSound(\'操作失败\');\n\t\tcore.drawTip("当前无法使用" + core.material.items[itemId].name, itemId);\n\t\tcore.addItem(itemId, 1);\n\t\treturn;\n\t}\n})();';
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.bomb.useItemEffect =
            '(function () {\n\tvar bombList = []; // 炸掉的怪物坐标列表\n\tvar todo = []; // 炸弹后事件\n\tvar money = 0,\n\t\texp = 0; // 炸弹获得的金币和经验\n\n\tvar canBomb = function (x, y) {\n\t\tvar block = core.getBlock(x, y);\n\t\tif (block == null || block.disable || block.event.cls.indexOf(\'enemy\') != 0) return false;\n\t\tvar enemy = core.material.enemys[block.event.id];\n\t\treturn enemy && !enemy.notBomb;\n\t};\n\n\tvar bomb = function (x, y) {\n\t\tif (!canBomb(x, y)) return;\n\t\tbombList.push([x, y]);\n\t\tvar id = core.getBlockId(x, y),\n\t\t\tenemy = core.material.enemys[id];\n\t\tmoney += core.getEnemyValue(enemy, \'money\', x, y) || 0;\n\t\texp += core.getEnemyValue(enemy, \'exp\', x, y) || 0;\n\t\tcore.push(todo, core.floors[core.status.floorId].afterBattle[x + "," + y]);\n\t\tcore.push(todo, enemy.afterBattle);\n\t\tcore.removeBlock(x, y);\n\t}\n\n\t// 如果要多方向可炸，把这里的false改成true\n\tif (true) {\n\t\tvar scan = core.utils.scan; // 多方向炸时默认四方向，如果要改成八方向炸可以改成 core.utils.scan2\n\t\tfor (var direction in scan) {\n\t\t\tvar delta = scan[direction];\n\t\t\tbomb(core.getHeroLoc(\'x\') + delta.x, core.getHeroLoc(\'y\') + delta.y);\n\t\t}\n\t} else {\n\t\t// 仅炸当前\n\t\tbomb(core.nextX(), core.nextY());\n\t}\n\n\tif (bombList.length == 0) {\n\t\tcore.playSound(\'操作失败\');\n\t\tcore.drawTip(\'当前无法使用\' + core.material.items[itemId].name, itemId);\n\t\tcore.addItem(itemId, 1);\n\t\treturn;\n\t}\n\n\tcore.playSound(\'炸弹\');\n\tcore.drawTip(core.material.items[itemId].name + \'使用成功\', itemId);\n\n\t// 取消这里的注释可以炸弹后获得金币和经验\n\n\t// 取消这里的注释可以炸弹引发战后事件\n\tif (todo.length > 0) core.insertAction(todo);\n\n})();';

        data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.firstData.shops[0] = {
            'id': 'shop1',
            'text':
                '\t[贪婪之神,blueShop]勇士啊, 给我${10+5*flag:次数*(flag:次数-1)}金币就可以：',
            'textInList': '一区商店',
            'mustEnable': true,
            'disablePreview': false,
            'choices': [
                {
                    'text': '生命+100',
                    'need': 'status:money>=10+5*flag:次数*(flag:次数-1)',
                    'action': [
                        { 'type': 'playSound', 'name': 'item.mp3' },
                        {
                            'type': 'setValue',
                            'name': 'status:hp',
                            'operator': '+=',
                            'value': '100'
                        },
                        {
                            'type': 'setValue',
                            'name': 'status:money',
                            'operator': '-=',
                            'value': '10+5*flag:次数*(flag:次数-1)'
                        },
                        {
                            'type': 'setValue',
                            'name': 'flag:次数',
                            'operator': '+=',
                            'value': '1'
                        },
                    ]
                },
                {
                    'text': '攻击+2',
                    'need': 'status:money>=10+5*flag:次数*(flag:次数-1)',
                    'action': [
                        { 'type': 'playSound', 'name': 'item.mp3' },
                        {
                            'type': 'setValue',
                            'name': 'status:atk',
                            'operator': '+=',
                            'value': '2'
                        },
                        {
                            'type': 'setValue',
                            'name': 'status:money',
                            'operator': '-=',
                            'value': '10+5*flag:次数*(flag:次数-1)'
                        },
                        {
                            'type': 'setValue',
                            'name': 'flag:次数',
                            'operator': '+=',
                            'value': '1'
                        },
                    ]
                },
                {
                    'text': '防御+4',
                    'need': 'status:money>=10+5*flag:次数*(flag:次数-1)',
                    'action': [
                        { 'type': 'playSound', 'name': 'item.mp3' },
                        {
                            'type': 'setValue',
                            'name': 'status:def',
                            'operator': '+=',
                            'value': '4'
                        },
                        {
                            'type': 'setValue',
                            'name': 'status:money',
                            'operator': '-=',
                            'value': '10+5*flag:次数*(flag:次数-1)'
                        },
                        {
                            'type': 'setValue',
                            'name': 'flag:次数',
                            'operator': '+=',
                            'value': '1'
                        },
                    ]
                },
            ]
        };
        data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.firstData.shops[1] = {
            'id': 'shop2',
            'text':
                '\t[贪婪之神,blueShop]勇士啊, 给我${10+5*flag:次数*(flag:次数-1)}金币就可以：',
            'textInList': '二区商店',
            'mustEnable': true,
            'disablePreview': false,
            'choices': [
                {
                    'text': '生命+100',
                    'need': 'status:money>=10+5*flag:次数*(flag:次数-1)',
                    'action': [
                        { 'type': 'playSound', 'name': 'item.mp3' },
                        {
                            'type': 'setValue',
                            'name': 'status:hp',
                            'operator': '+=',
                            'value': '100'
                        },
                        {
                            'type': 'setValue',
                            'name': 'status:money',
                            'operator': '-=',
                            'value': '10+5*flag:次数*(flag:次数-1)'
                        },
                        {
                            'type': 'setValue',
                            'name': 'flag:次数',
                            'operator': '+=',
                            'value': '1'
                        },
                    ]
                },
                {
                    'text': '攻击+4',
                    'need': 'status:money>=10+5*flag:次数*(flag:次数-1)',
                    'action': [
                        { 'type': 'playSound', 'name': 'item.mp3' },
                        {
                            'type': 'setValue',
                            'name': 'status:atk',
                            'operator': '+=',
                            'value': '4'
                        },
                        {
                            'type': 'setValue',
                            'name': 'status:money',
                            'operator': '-=',
                            'value': '10+5*flag:次数*(flag:次数-1)'
                        },
                        {
                            'type': 'setValue',
                            'name': 'flag:次数',
                            'operator': '+=',
                            'value': '1'
                        },
                    ]
                },
                {
                    'text': '防御+8',
                    'need': 'status:money>=10+5*flag:次数*(flag:次数-1)',
                    'action': [
                        { 'type': 'playSound', 'name': 'item.mp3' },
                        {
                            'type': 'setValue',
                            'name': 'status:def',
                            'operator': '+=',
                            'value': '8'
                        },
                        {
                            'type': 'setValue',
                            'name': 'status:money',
                            'operator': '-=',
                            'value': '10+5*flag:次数*(flag:次数-1)'
                        },
                        {
                            'type': 'setValue',
                            'name': 'flag:次数',
                            'operator': '+=',
                            'value': '1'
                        },
                    ]
                },
            ]
        }
    }
}
main.challenges['seal'] = {
    'id': 'seal',
    'name': '完蛋了我被封印了功力只剩一成',
    'hard': 10,
    'superPotion_atk_ratio': 7.4,
    'superPotion_def_ratio': 7.4,
    'superPotion_hp_ratio': 0,
    redKing_hp: 800, redKing_atk: 500, redKing_def: 100,
    swordEmperor_hp: 500, swordEmperor_atk: 158, swordEmperor_def: 19,
    redKing_seal_hp: 80, redKing_seal_atk: 50, redKing_seal_def: 10,
    swordEmperor_seal_hp: 500, swordEmperor_seal_atk: 158, swordEmperor_seal_def: 19,
    'script': function () {
        main.floors.MT1.events['7,10'][1] =
            '本塔修改内容：\n怪物属性和勇者属性都除以10，向下取整。\n宝石血瓶效果也除以10，向下取整。\n商店效果也除以10，向下取整。\n剑盾效果也除以10。'
        main.floors.MT1.events['7,10'][2] =
            '本塔修改内容：\n封印五区商店的时候不小心把楼层也封印了，因此五区商店在4层。\n接触这个商店后可以用左侧道具栏的快捷商店，不限地形。\n2F商人加的3%是向上取整的。\n由于已经封印了魔王了，所以结局不论如何也只有te了，因此不用留破墙镐下楼器等。'
        main.floors.MT1.firstArrive = [
            '\t[hero]完蛋了，我被封印了，功力只剩一成', {
                'type': 'setValue',
                'name': 'status:hp',
                'operator': '/=',
                'value': '10'
            },
            {
                'type': 'setValue',
                'name': 'status:atk',
                'operator': '/=',
                'value': '10'
            },
            {
                'type': 'setValue',
                'name': 'status:def',
                'operator': '/=',
                'value': '10'
            }
        ]
        main.floors.MT2.events['11,7'][1].choices[0].action[1].value =
            '(Math.ceil((status:atk*0.03)))'
        main.floors.MT2.events['11,7'][1].choices[0].action[2].value =
            '(Math.ceil((status:def*0.03)))'
        main.floors.MT3.events['5,9'][2] =
            '\t[魔王,redKing]欢迎来到魔塔 你是第10位挑战者 你若能打败我所有的手下 我就与你0.1对0.1的决斗 现在你必须接受我的安排'
        main.floors.MT3.events['5,9'][11].value = '4'
        main.floors.MT3.events['5,9'][12].value = '1'
        main.floors.MT3.events['5,9'][13].value = '1'
        main.floors.MT24.events['6,1'].data.splice(2, 1);
        data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.values.blueGem = 0
        data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.values.redGem = 0
        data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.values.redPotion /= 10
        data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.values.bluePotion /= 10
        for (var i in enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80) {
            enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].atk =
                Math.floor(enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].atk * 0.1)
            enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].def =
                Math.floor(enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].def * 0.1)
            enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].hp =
                Math.floor(enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80[i].hp * 0.1)
        }
        enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80.brownWizard.zone /= 10
        enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80.redWizard.zone /= 10
        enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80.blackKing.repulse /= 10
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword1.itemEffect =
            'core.status.hero.atk += 1;\ncore.setFlag(\'nowWeapon\', \'sword1\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword2.itemEffect =
            'core.status.hero.atk += 2;\ncore.setFlag(\'nowWeapon\', \'sword2\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword3.itemEffect =
            'core.status.hero.atk += 4;\ncore.setFlag(\'nowWeapon\', \'sword3\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword4.itemEffect =
            'core.status.hero.atk += 5;\ncore.setFlag(\'nowWeapon\', \'sword4\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword5.itemEffect =
            'core.status.hero.atk += 10;\ncore.setFlag(\'nowWeapon\', \'sword5\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword1.itemEffectTip =
            '，提升 1 点攻击'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword2.itemEffectTip =
            '，提升 2 点攻击'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword3.itemEffectTip =
            '，提升 4 点攻击'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword4.itemEffectTip =
            '，提升 5 点攻击'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.sword5.itemEffectTip =
            '，提升 10 点攻击'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield1.itemEffect =
            'core.status.hero.def += 1;\ncore.setFlag(\'nowShield\', \'shield1\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield2.itemEffect =
            'core.status.hero.def += 2;\ncore.setFlag(\'nowShield\', \'shield2\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield3.itemEffect =
            'core.status.hero.def += 4;\ncore.setFlag(\'nowShield\', \'shield3\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield4.itemEffect =
            'core.status.hero.def += 5;\ncore.setFlag(\'nowShield\', \'shield4\');'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield5.itemEffect =
            'core.status.hero.def += 10;\ncore.setFlag(\'nowShield\', \'shield5\');core.setFlag(\'shield5\', 1);'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield1.itemEffectTip =
            '，提升 1 点防御'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield2.itemEffectTip =
            '，提升 2 点防御'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield3.itemEffectTip =
            '，提升 4 点防御'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield4.itemEffectTip =
            '，提升 5 点防御'
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield5.itemEffectTip =
            '，提升 10 点防御，并免疫魔法伤害'
        data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.firstData.shops = [
            {
                "id": "shop1",
                "text": "\t[贪婪之神,blueShop]勇士啊, 给我${20+10*flag:次数*(flag:次数-1)}金币就可以：",
                "textInList": "一区商店",
                "mustEnable": true,
                "disablePreview": false,
                "choices": [
                    {
                        "text": "生命+${10*flag:次数}",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:hp",
                                "operator": "+=",
                                "value": "10*flag:次数"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    },
                    {
                        "text": "攻击+1",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:atk",
                                "operator": "+=",
                                "value": "1"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    },
                    {
                        "text": "防御+2",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:def",
                                "operator": "+=",
                                "value": "2"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    }
                ]
            },
            {
                "id": "shop2",
                "text": "\t[贪婪之神,blueShop]勇士啊, 给我${20+10*flag:次数*(flag:次数-1)}金币就可以：",
                "textInList": "二区商店",
                "mustEnable": true,
                "disablePreview": false,
                "choices": [
                    {
                        "text": "生命+${10*flag:次数}",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:hp",
                                "operator": "+=",
                                "value": "10*flag:次数"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    },
                    {
                        "text": "攻击+0",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:atk",
                                "operator": "+=",
                                "value": "0"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    },
                    {
                        "text": "防御+0",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:def",
                                "operator": "+=",
                                "value": "0"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    }
                ]
            },
            {
                "id": "shop3",
                "text": "\t[贪婪之神,blueShop]勇士啊, 给我${20+10*flag:次数*(flag:次数-1)}金币就可以：",
                "textInList": "四区商店",
                "mustEnable": true,
                "disablePreview": false,
                "choices": [
                    {
                        "text": "生命+${10*flag:次数}",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:hp",
                                "operator": "+=",
                                "value": "10*flag:次数"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    },
                    {
                        "text": "攻击+0",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:atk",
                                "operator": "+=",
                                "value": "0"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    },
                    {
                        "text": "防御+1",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:def",
                                "operator": "+=",
                                "value": "1"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    }
                ]
            },
            {
                "id": "shop4",
                "text": "\t[贪婪之神,blueShop]勇士啊, 给我${20+10*flag:次数*(flag:次数-1)}金币就可以：",
                "textInList": "五区商店",
                "mustEnable": true,
                "disablePreview": false,
                "choices": [
                    {
                        "text": "生命+${10*flag:次数}",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:hp",
                                "operator": "+=",
                                "value": "10*flag:次数"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    },
                    {
                        "text": "攻击+1",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:atk",
                                "operator": "+=",
                                "value": "1"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    },
                    {
                        "text": "防御+2",
                        "need": "status:money>=20+10*flag:次数*(flag:次数-1)",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:def",
                                "operator": "+=",
                                "value": "2"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "-=",
                                "value": "20+10*flag:次数*(flag:次数-1)"
                            },
                            {
                                "type": "setValue",
                                "name": "flag:次数",
                                "operator": "+=",
                                "value": "1"
                            }
                        ]
                    }
                ]
            },
            {
                "id": "shop5",
                "text": "\t[商人,woman]我能以100金币一把的价格回收黄钥匙！",
                "textInList": "回收钥匙商店",
                "mustEnable": true,
                "disablePreview": false,
                "choices": [
                    {
                        "text": "我太需要了",
                        "need": "item:yellowKey>=1",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "+=",
                                "value": "100"
                            },
                            {
                                "type": "setValue",
                                "name": "item:yellowKey",
                                "operator": "-=",
                                "value": "1"
                            }
                        ]
                    },
                    {
                        "text": "我要卖10把",
                        "need": "item:yellowKey>=10",
                        "action": [
                            {
                                "type": "playSound",
                                "name": "item.mp3"
                            },
                            {
                                "type": "setValue",
                                "name": "status:money",
                                "operator": "+=",
                                "value": "1000"
                            },
                            {
                                "type": "setValue",
                                "name": "item:yellowKey",
                                "operator": "-=",
                                "value": "10"
                            }
                        ]
                    }
                ]
            }
        ]
    }
}
main.challenges['rx2bx0'] = {
    'id': 'rx2bx0',
    'name': '红宝石*2 蓝宝石盾无效',
    'hard': 10,
    'script': function () {
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.redGem = {
            'cls': 'items',
            'name': '红宝石',
            'text': '攻击+${core.values.redGem+1}',
            'itemEffect':
                'core.status.hero.atk += core.values.redGem * core.status.thisMap.ratio + 1',
            'itemEffectTip':
                '，提升 ${core.values.redGem * core.status.thisMap.ratio+1} 点攻击',
            'useItemEffect': 'core.status.hero.atk += core.values.redGem + 1',
            'canUseItemEffect': 'true'
        };
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.blueGem = {
            'cls': 'items',
            'name': '蓝宝石',
            'text': '',
            'itemEffect': '',
            'itemEffectTip': '',
            'useItemEffect': '',
            'canUseItemEffect': 'true'
        };
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield1.itemEffect = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield2.itemEffect = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield3.itemEffect = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield4.itemEffect = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield5.itemEffect = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield1.itemEffectTip = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield2.itemEffectTip = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield3.itemEffectTip = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield4.itemEffectTip = ''
        items_296f5d02_12fd_4166_a7c1_b5e830c9ee3a.shield5.itemEffectTip = ''
    }
}
