# UI编辑器

## 基础操作

打开编辑界面后即可编辑，通过添加新操作可以向ui中添加新的内容。点击一个操作后可以选中该操作，被选中的操作将呈现黄色，可按住ctrl多选。此时点击鼠标右键，可以打开右键菜单，包括在上方插入、复制等操作。执行在上方或下方插入时，会在鼠标点击的操作上方或下方插入，执行复制或剪切时会复制或剪切所有被选中的操作，被剪切的操作将会呈现灰色。当ui编辑到一半时，可以点击保存按钮进行保存，当ui未保存时，保存按钮应当显示为黄色，点击保存后，如果保存成功，按钮会短暂变成绿色。当ui编辑完成后，可以点击预览按钮从头开始预览ui，确认符合预期后，可以点击编译按钮将操作编译为js代码，然后将该代码按照编译完成的注释操作，将代码放入插件中，在需要的地方插入即可。

## 注意事项

- 设置过渡不会立刻生效，会在下一个动画帧中生效，因此设置之后可能需要大概20~50ms的等待操作
- 画布无法更改名称
- 对于绘制成段文本，如果设置了打字机速度，那么两个该操作不能同时进行
- 临时禁用只对预览有效，编译时被临时禁用的操作仍会被编译
- 遇到问题或bug、建议等请在造塔群及时反馈

## 编译

该操作会将当前编辑器显示的所有操作编译为js代码。编译完成后，应当放到插件中一个形式为`this.xxx = function () { ui内容 }`的函数中，在需要显示该ui时，只需执行代码`core.xxx()`

示例：

```js
// 插件中
this.myUi = function() {
    // 请复制以下内容至插件中以使用
    // 使用案例：
    /* 
    插件中：
    this.showMyUi = function () {
        函数内容
    }
    调用时：
    core.showMyUi();
    */
    var _sprite_0 = new Sprite(100, 100, 100, 100, 200, 'game', '_sprite_0');
    _sprite_0.setCss('display: none;');

    action_0_6();

    function action_0_6() {
        _sprite_0.setCss('display: block;');
        _sprite_0.move(100, 100);
        _sprite_0.resize(100, 100);
        _sprite_0.canvas.style.zIndex = '200';
        core.setAlpha(_sprite_0.context, 0.5);
        core.fillEllipse(_sprite_0.context, 50, 50, 30, 50, 0, '');
        var ctx = _sprite_0.context;
        ctx.moveTo(0, 20);
        ctx.bezierCurveTo(10, 10, 50, 50, 50, 100);
        ctx.strokeStyle = '#fff';
        ctx.lineWidth = 5;
        ctx.stoke();
        _sprite_0.context.globalCompositeOperation = 'difference';
        core.fillRect(_sprite_0.context, 0, 0, 100, 100, '');
        setTimeout(action_7_8, 1000);
    }
    function action_7_8() {
        var res = _sprite_0.canvas.style.transition;
        if (res !== '') res += ', ';
        res += 'left 300ms ease-out 0ms';
        _sprite_0.canvas.style.transition = res;
        setTimeout(action_9_9, 50);
    }
    function action_9_9() {
        _sprite_0.resize(100, 100, true);
    }
}

// 需要显示ui时
core.myUi();
```

## 预览

预览分为两种，一种是编辑时的即时预览，这种预览会显示所有的画布，并无视等待和删除，确保你能够看到所有的绘制内容，如果你想要隐藏某个操作，可以打开该操作的详细信息，然后将临时禁用勾上，这样就能隐藏该操作了。

第二种是点击预览按钮时发生的，这种预览会尽可能地还原编译后的执行结果，让你能够完整地预览ui。

## 保存

显而易见，该操作可以保存现在正在编辑的ui。注意，ui会保存在样板根目录下的_ui文件夹，以base64的形式进行保存。当你编辑了ui时，保存按钮会呈现黄色，说明此时你还没有保存，此时切出编辑页面会弹出提示。点击保存后，会出现短暂的保存中字样（保存快的话可能看不清），如果保存成功，会出现成功字样，并会将背景短暂地改成绿色

## 临时禁用

该操作可以让你能够禁用某个操作，让你在不删除操作的情况下看到删除之后的效果。该操作只对预览有效，这意味着编译仍会编译被禁用的操作。

## 编辑

### 创建画布

| 事件名称       | 创建画布 |
| ---           | ---      |
| 事件原形       | 创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深)       |
| 功能描述       | 创建一个新的画布        |
| 输入参数 1     | 名称：画布的名称 |
| 输入参数 2     | 横坐标：画布的起点横坐标（左上角）        |
| 输入参数 3     | 纵坐标：画布的起点纵坐标（左上角）        |
| 输入参数 4     | 宽度：画布的宽度        |
| 输入参数 5     | 高度：画布的高度        |
| 输入参数 6     | 纵深：画布的显示优先级，数值越大优先级越高        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 创建画布 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
……
```

### 等待

| 事件名称       | 等待 |
| ---           | ---      |
| 事件原形       | 等待(毫秒数)       |
| 功能描述       | 等待一定时间后再执行后续操作        |
| 输入参数 1     | 毫秒数：等待的时间长度 |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 等待 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
等待(毫秒数);
```

### 设置过渡

| 事件名称       | 设置过渡 |
| ---           | ---      |
| 事件原形       | 设置过渡(作用画布, 作用效果, 过渡时间, 过渡方式, 延迟)       |
| 功能描述       | 指定画布前两个命令之间的渐变式变化        |
| 输入参数 1     | 作用画布：画布的名称 |
| 输入参数 2     | 作用效果：可用于transition的style    |
| 输入参数 3     | 过渡时间：变化的时间长度 |
| 输入参数 4     | 过渡方式：过渡方式，包括ease-out  ease-in  ease-in-out  linear  bezier-curve()等  |
| 输入参数 5     | 延迟：当指定属性变化后，多长时间后开始过渡 |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

| 常见作用效果       | 说明 |
| ---           | ---      |
| left       | x轴方向的位置       |
| top      | y轴方向的位置       |
| opacity    | 不透明度       |
| background-color  | 背景色       |
| transform  | 2D和3D变换       |
| filter     | 滤镜       |
| border     | 边框       |

| 过渡方式       | 说明 |
| ---           | ---      |
| ease-out      | 先快后慢       |
| ease-in       | 先慢后快        |
| ease-in-out   | 慢-快-慢        |
| linear        | 线性变化（匀速）        |
| bezier-curve()  | 指定按照贝塞尔曲线的形式变化，1表示到达终点，0表示起点        |

例：
```js
/* 这是UI编辑器中 设置过渡 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
设置过渡(作用画布, 作用效果, 过渡时间, 过渡方式, 延迟);
移动画布(名称, 横坐标, 纵坐标);
```

### 删除画布

| 事件名称       | 删除画布 |
| ---           | ----------- |
| 事件原形       | 删除画布(作用画布)       |
| 功能描述       | 删除一个已经存在的画布        |
| 输入参数 1     | 作用画布：画布的名称 |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 画布已经存在        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 删除画布 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
删除画布(名称);
```

### 移动画布

| 事件名称       | 移动画布 |
| ---           | ---      |
| 事件原形       | 移动画布(作用画布, 横坐标, 纵坐标, 移动模式)       |
| 功能描述       | 移动指定画布一定指定距离        |
| 输入参数 1     | 作用画布：画布的名称 |
| 输入参数 2     | 横坐标：画布的起点横坐标（左上角）        |
| 输入参数 3     | 纵坐标：画布的起点纵坐标（左上角）        |
| 输入参数 4     | 移动模式：是，则为相对坐标模式，否则为绝对坐标模式 |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

| 移动模式       | 说明 |
| ---           | ---      |
| 绝对坐标       | 横纵坐标为画布移动后左上角的坐标位置       |
| 相对坐标       | 横纵坐标为画布在横向与纵向上移动的距离值        |

例：
```js
/* 这是UI编辑器中 移动画布 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
移动画布(名称, 横坐标, 纵坐标，false);
```

### 缩放画布

| 事件名称       | 缩放画布 |
| ---           | ---      |
| 事件原形       | 缩放画布(作用画布, 宽度, 高度, 修改样式)       |
| 功能描述       | 调整画布至指定尺寸大小        |
| 输入参数 1     | 作用画布：画布的名称 |
| 输入参数 2     | 宽度：画布新的宽度尺寸        |
| 输入参数 3     | 高度：画布新的高度尺寸        |
| 输入参数 4     | 修改样式：如果是，那么只会修改css的长宽，导致模糊，如果不是，那么会修改画布的长宽，清晰，但会清空已绘制内容        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 缩放画布 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
缩放画布(名称, 宽度, 高度, false);
```

### 旋转画布

| 事件名称       | 旋转画布 |
| ---           | ---      |
| 事件原形       | 旋转画布(作用画布, 中心横坐标, 中心纵坐标, 角度)       |
| 功能描述       | 指定画布以指定的中心点旋转一定的角度        |
| 输入参数 1     | 作用画布：画布的名称 |
| 输入参数 2     | 中心横坐标：旋转中心的横坐标        |
| 输入参数 3     | 中心纵坐标：旋转中心的纵坐标       |
| 输入参数 4     | 角度：旋转的角度，正数顺时针旋转，负数逆时针旋转        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 旋转画布 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
旋转画布(名称, 中心横坐标, 中心纵坐标, 角度);
```

### 擦除画布

| 事件名称       | 擦除画布 |
| ---           | ----------- |
| 事件原形       | 擦除画布(作用画布, 横坐标, 纵坐标, 宽度, 高度)       |
| 功能描述       | 擦除画布指定区域内的所有内容        |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 横坐标：区域的起点横坐标（左上角）        |
| 输入参数 3     | 纵坐标：区域的起点纵坐标（左上角）        |
| 输入参数 4     | 宽度：区域的宽度        |
| 输入参数 5     | 高度：区域的高度        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

如果不填的话，默认擦除全部

例：
```js
/* 这是UI编辑器中 擦除画布 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
擦除画布(名称, 横坐标, 纵坐标, 宽度, 高度);
```

### 设置CSS效果

| 事件名称       | 设置CSS效果 |
| ---           | ----------- |
| 事件原形       | 设置CSS效果(作用画布, CSS效果)       |
| 功能描述       | 修改指定画布的样式        |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | CSS效果：编辑框内输入自定义的CSS效果       |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

| 常用CSS效果     | 说明 |
| ---           | ---      |
| opacity         | 不透明度，一个浮点型数字，在0~1区间内       |
| background-color | 背景色，可以使用`#rgba  #rrggbbaa  #rgb  #rrggbb  rgb(r,g,b)  rgba(r,g,b,a)  英文单词`共7种形式  |
| background-image | 背景图片，可使用`url(project/images/image.png)`的形式  |
| box-shadow      | 元素阴影，形式为 `x偏移 y偏移 阴影大小 颜色, x偏移 y偏移 阴影大小 颜色`  |
| transform       | 元素的2D和3D转换，用法过多，请百度搜索或在mdn搜索  |
| filter          | 元素滤镜，同上  |

例：
```js
/* 这是UI编辑器中 设置CSS效果 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
设置CSS效果(名称, CSS效果);
```

### 设置混合方式

| 事件名称       | 设置混合方式 |
| ---           | ----------- |
| 事件原形       | 设置混合方式(作用画布, 混合方式)       |
| 功能描述       | 设置新绘制的内容与已绘制的内容间的叠加方式        |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 混合方式：设置画布的混合方式        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

混合方式说明：包括`color color-burn color-dodge copy darken destination-atop destination-in destination-out destination-over difference exclusion hard-light hue lighten lighter luminosity multiply overlay saturation screen soft-light source-atop source-in source-out source-over xor`共26种，默认为source-over，其余效果请自行百度或尝试

例：
```js
/* 这是UI编辑器中 设置混合方式 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
设置混合方式(名称, 混合方式);
```

### 设置绘制滤镜

| 事件名称       | 设置绘制滤镜 |
| ---           | ----------- |
| 事件原形       | 设置绘制滤镜(作用画布, 滤镜)       |
| 功能描述       | 设置在绘制时的滤镜，不影响已绘制内容        |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 滤镜：编辑框内输入自定义的滤镜        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

| 常见滤镜       | 说明 |
| ---           | ---      |
| blur         | 高斯模糊，用法示例：blur(5px)       |
| brightness   | 亮度，100%为原始亮度，用法示例：brightness(120%)  |
| contrast     | 对比度，100%为原始对比度，用法示例：contrast(80%)  |
| grayscale    | 灰度，0%为原始灰度，设为100%将会变成黑白，用法示例：grayscale(75%)  |
| opacity      | 不透明度，100%为原始不透明度，设为0%将会完全透明，用法示例：opacity(80%)  |

滤镜填写示例：`blur(5px)brightness(120%)grayscale(50%)`，注意会完全覆盖之前的效果，也就是说之前的效果会全部失效

例：
```js
/* 这是UI编辑器中 设置绘制滤镜 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
设置绘制滤镜(名称, 滤镜);
```

### 设置阴影

| 事件名称       | 设置阴影 |
| ---           | ----------- |
| 事件原形       | 设置阴影(作用画布, 阴影模糊, 阴影颜色, 阴影横坐标, 阴影纵坐标)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 阴影模糊：阴影的高斯模糊，与设置绘制滤镜的blur相同        |
| 输入参数 3     | 阴影颜色：与设置css效果中对background-color的描述相同        |
| 输入参数 4     | 阴影横坐标：阴影偏移绘制位置的横坐标        |
| 输入参数 5     | 阴影纵坐标：阴影偏移绘制位置的纵坐标        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 设置阴影 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
设置阴影(名称, 阴影模糊, 阴影颜色, 宽度, 高度);
```

### 设置文本属性

| 事件名称       | 设置文本属性 |
| ---           | ----------- |
| 事件原形       | 设置文本属性(作用画布, 文本方向, 文本对齐, 文本基线)       |
| 功能描述       | 设置文本方向、文本对齐、文本基线        |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 文本方向：文字阅读的方向       |
| 输入参数 3     | 文本对齐：文本水平对齐的方向       |
| 输入参数 4     | 文本基线：文本竖直对齐的方向       |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

| 文本方向       | 说明 |
| ---           | ---      |
| ltr           | 从左往右       |
| rtl           | 从右往左       |

| 文本对齐       | 说明 |
| ---           | ---      |
| left          | 左对齐       |
| center        | 居中对齐       |
| right         | 右对齐       |

| 文本基线       | 说明 |
| ---           | ---      |
| bottom        | 底部对齐       |
| middle        | 居中对齐       |
| top           | 顶部对齐       |

例：
```js
/* 这是UI编辑器中 设置文本信息 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
设置文本属性(名称, 文本方向, 文本对齐, 文本基线);
```

### 设置不透明度

| 事件名称       | 设置不透明度 |
| ---           | ----------- |
| 事件原形       | 设置不透明度(作用画布, 文本不透明度)       |
| 功能描述       | 设置画布之后绘制的不透明度        |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 不透明度：要设置到的不透明度       |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

该操作对已绘制内容没有影响，如果想要对已绘制内容也产生影响，请使用设置css

例：
```js
/* 这是UI编辑器中 设置不透明度 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
设置不透明度(名称, 不透明度);
```

### 保存画布属性

| 事件名称       | 保存画布属性 |
| ---           | ----------- |
| 事件原形       | 保存画布属性(作用画布)       |
| 功能描述       | 保存画布属性，注意之会保存之前设置的属性，如文本属性，不会保存绘制内容        |
| 输入参数 1     | 作用画布：画布的名称        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 保存画布属性 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
保存画布属性(名称);
```

### 回退画布属性

| 事件名称       | 回退画布属性 |
| ---           | ----------- |
| 事件原形       | 回退画布属性(作用画布)       |
| 功能描述       | 回退画布属性，注意只会回退画布的属性，如文本属性，不会回退绘制内容        |
| 输入参数 1     | 作用画布：画布的名称        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 回退画布属性 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
回退画布属性(名称);
```

### 绘制直线

| 事件名称       | 绘制直线 |
| ---           | ----------- |
| 事件原形       | 绘制直线(作用画布, 起点横坐标, 起点纵坐标, 终点横坐标, 终点纵坐标, 连线宽度, 连线颜色)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 起点横坐标：       |
| 输入参数 3     | 起点纵坐标：       |
| 输入参数 4     | 终点横坐标：        |
| 输入参数 4     | 终点纵坐标：       |
| 输入参数 7     | 连线宽度：       |
| 输入参数 8     | 连线颜色：       |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制直线 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制直线(名称, 起点横坐标, 起点纵坐标, 终点横坐标, 终点纵坐标, 连线宽度, 连线颜色);
```

### 绘制弧线

| 事件名称       | 绘制弧线 |
| ---           | ----------- |
| 事件原形       | 绘制弧线(作用画布, 中心横坐标, 中心纵坐标, 半径, 起始弧度, 终止弧度, 是否为边框, 线条宽度, 颜色)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 横坐标        |
| 输入参数 3     | 纵坐标        |
| 输入参数 4     | 半径        |
| 输入参数 4     | 起始弧度        |
| 输入参数 4     | 终止弧度        |
| 输入参数 6     | 是否为边框        |
| 输入参数 7     | 线条宽度        |
| 输入参数 8     | 颜色        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制弧线 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制弧线(名称, 中心横坐标, 中心纵坐标, 半径, 起始弧度, 终止弧度, 是否为边框, 线条宽度, 颜色);
```

### 绘制圆

| 事件名称       | 绘制圆 |
| ---           | ----------- |
| 事件原形       | 绘制圆(作用画布, 中心横坐标, 中心纵坐标, 半径, 是否为边框, 线条宽度, 颜色)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 横坐标        |
| 输入参数 3     | 纵坐标        |
| 输入参数 4     | 半径        |
| 输入参数 6     | 是否为边框        |
| 输入参数 7     | 线条宽度        |
| 输入参数 8     | 颜色        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制圆 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制圆(名称, 中心横坐标, 中心纵坐标, 半径, 是否为边框, 线条宽度, 颜色);
```

### 绘制矩形

| 事件名称       | 绘制矩形 |
| ---           | ----------- |
| 事件原形       | 绘制矩形(作用画布, 横坐标, 纵坐标, 宽度, 高度, 是否为边框, 线条宽度, 颜色)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 横坐标        |
| 输入参数 3     | 纵坐标        |
| 输入参数 4     | 宽度        |
| 输入参数 5     | 高度        |
| 输入参数 6     | 是否为边框        |
| 输入参数 7     | 线条宽度        |
| 输入参数 8     | 颜色        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制矩形 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制矩形(名称, 横坐标, 纵坐标, 宽度, 高度, 是否为边框, 线条宽度, 颜色);
```
### 绘制圆角矩形

| 事件名称       | 绘制圆角矩形 |
| ---           | ----------- |
| 事件原形       | 绘制圆角矩形(作用画布, 横坐标, 纵坐标, 宽度, 高度, 圆角半径, 是否为边框, 线条宽度, 颜色)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 横坐标        |
| 输入参数 3     | 纵坐标        |
| 输入参数 4     | 宽度        |
| 输入参数 5     | 高度        |
| 输入参数 5     | 圆角半径        |
| 输入参数 6     | 是否为边框        |
| 输入参数 7     | 线条宽度        |
| 输入参数 8     | 颜色        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制圆角矩形 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制圆角矩形(名称, 横坐标, 纵坐标, 宽度, 高度, 圆角半径, 是否为边框, 线条宽度, 颜色);
```

### 绘制多边形

| 事件名称       | 绘制多边形 |
| ---           | ----------- |
| 事件原形       | 绘制多边形(作用画布, 是否为边框, 线条宽度, 颜色)       |
| 功能描述       |        |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 是否为边框        |
| 输入参数 3     | 线条宽度        |
| 输入参数 4     | 颜色        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制多边形 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制多边形(名称, 是否为边框, 线条宽度, 颜色);
```

### 绘制椭圆

| 事件名称       | 绘制椭圆 |
| ---           | ----------- |
| 事件原形       | 绘制椭圆(作用画布, 中心横坐标, 中心纵坐标, 半长轴, 半短轴, 旋转角度, 是否为边框, 线条宽度, 颜色)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 中心横坐标        |
| 输入参数 3     | 中心纵坐标        |
| 输入参数 4     | 半长轴        |
| 输入参数 5     | 半短轴        |
| 输入参数 6     | 旋转角度        |
| 输入参数 7     | 是否为边框        |
| 输入参数 8     | 线条宽度        |
| 输入参数 9     | 颜色        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制椭圆 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制椭圆(名称, 中心横坐标, 中心纵坐标, 半长轴, 半短轴, 旋转角度, 是否为边框, 线条宽度, 颜色)
```

### 绘制箭头

| 事件名称       | 绘制箭头 |
| ---           | ----------- |
| 事件原形       | 绘制箭头(作用画布, 起点横坐标, 起点纵坐标, 终点横坐标, 终点纵坐标, 连线宽度, 连线颜色)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 起点横坐标        |
| 输入参数 3     | 起点纵坐标        |
| 输入参数 4     | 终点横坐标        |
| 输入参数 5     | 终点纵坐标        |
| 输入参数 6     | 连线宽度        |
| 输入参数 7     | 连线颜色        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制箭头 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制箭头(名称, 起点横坐标, 起点纵坐标, 终点横坐标, 终点纵坐标, 连线宽度, 连线颜色);
```

### 绘制贝塞尔曲线

| 事件名称       | 绘制贝塞尔曲线 |
| ---           | ----------- |
| 事件原形       | 绘制贝塞尔曲线(作用画布, 控制点1横坐标, 控制点1纵坐标, 控制点2横坐标, 控制点2纵坐标, 起点横坐标, 起点纵坐标, 终点横坐标, 终点纵坐标, 线条宽度, 颜色)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 控制点1横坐标        |
| 输入参数 3     | 控制点1纵坐标        |
| 输入参数 4     | 控制点2横坐标        |
| 输入参数 5     | 控制点2纵坐标        |
| 输入参数 6     | 起点横坐标        |
| 输入参数 7     | 起点纵坐标        |
| 输入参数 8     | 终点横坐标        |
| 输入参数 9     | 终点纵坐标        |
| 输入参数 10    | 线条宽度        |
| 输入参数 11    | 颜色        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制贝塞尔曲线 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制贝塞尔曲线(名称, 控制点1横坐标, 控制点1纵坐标, 控制点2横坐标, 控制点2纵坐标, 起点横坐标, 起点纵坐标, 终点横坐标, 终点纵坐标, 线条宽度, 颜色);
```

### 绘制图片

| 事件名称       | 绘制图片 |
| ---           | ----------- |
| 事件原形       | 绘制图片(作用画布, 图片, 裁切点横坐标, 裁切点纵坐标, 裁切宽度, 裁切高度, 绘制点横坐标, 绘制点纵坐标, 绘制宽度, 绘制高度)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 图片        |
| 输入参数 3     | 裁切点横坐标        |
| 输入参数 4     | 裁切点纵坐标        |
| 输入参数 5     | 裁切宽度        |
| 输入参数 6     | 裁切高度        |
| 输入参数 7     | 绘制点横坐标        |
| 输入参数 8     | 绘制点纵坐标        |
| 输入参数 9     | 绘制宽度        |
| 输入参数 10    | 绘制高度        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制图片 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制图片(名称, 图片, 裁切点横坐标, 裁切点纵坐标, 裁切宽度, 裁切高度, 绘制点横坐标, 绘制点纵坐标, 绘制宽度, 绘制高度);
```

### 绘制图标

| 事件名称       | 绘制图标 |
| ---           | ----------- |
| 事件原形       | 绘制图标(作用画布, 图标id, 横坐标, 纵坐标, 帧数)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 图标id        |
| 输入参数 3     | 横坐标        |
| 输入参数 4     | 纵坐标       |
| 输入参数 5     | 宽度       |
| 输入参数 6     | 高度       |
| 输入参数 7     | 帧数：绘制图标的第几帧        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制图标 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制图标(名称, 图标id, 横坐标, 纵坐标, 帧数);
```

### 绘制窗口皮肤

| 事件名称       | 绘制窗口皮肤 |
| ---           | ----------- |
| 事件原形       | 绘制窗口皮肤(作用画布, 皮肤背景, 横坐标, 纵坐标, 宽度, 高度)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 皮肤背景：需为已注册的图片        |
| 输入参数 3     | 横坐标        |
| 输入参数 4     | 纵坐标        |
| 输入参数 5     | 宽度        |
| 输入参数 6     | 高度        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制窗口皮肤 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制窗口皮肤(名称, 皮肤背景, 横坐标, 纵坐标, 宽度, 高度);
```

### 绘制文本

| 事件名称       | 绘制文本 |
| ---           | ----------- |
| 事件原形       | 绘制文本(作用画布, 文字, 横坐标, 纵坐标, 添加描边, 斜体, 字体, 字体大小, 字体粗细, 字体颜色, 描边颜色, 最大宽度)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 文本        |
| 输入参数 3     | 横坐标        |
| 输入参数 4     | 纵坐标        |
| 输入参数 5     | 添加描边        |
| 输入参数 6     | 斜体        |
| 输入参数 7     | 字体        |
| 输入参数 8     | 字体大小        |
| 输入参数 9     | 字体粗细        |
| 输入参数 10    | 字体颜色        |
| 输入参数 11    | 描边颜色        |
| 输入参数 12    | 最大宽度        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制文本 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制文本(名称, 文字, 横坐标, 纵坐标, 添加描边, 斜体, 字体, 字体大小, 字体粗细, 字体颜色, 描边颜色, 最大宽度);
```

### 绘制成段文本

| 事件名称       | 绘制成段文本 |
| ---           | ----------- |
| 事件原形       | 绘制成段文本(作用画布, 文本, 横坐标, 纵坐标, 宽度, 颜色, 对齐, 字体大小, 行间距, 打字机时间间隔, 字体, 字符间距, 加粗, 斜体)       |
| 功能描述       |         |
| 输入参数 1     | 作用画布：画布的名称        |
| 输入参数 2     | 文本        |
| 输入参数 3     | 横坐标        |
| 输入参数 4     | 纵坐标        |
| 输入参数 5     | 宽度        |
| 输入参数 6     | 颜色       |
| 输入参数 7     | 对齐        |
| 输入参数 8     | 字体大小        |
| 输入参数 9     | 行间距        |
| 输入参数 10    | 打字机时间间隔        |
| 输入参数 11    | 字体        |
| 输入参数 12    | 字符间距        |
| 输入参数 13    | 加粗        |
| 输入参数 14    | 斜体        |
| 输出参数       | 无        |
| 返回值         | 无        |
| 先决条件       | 无        |
| 调用函数       | 无        |

例：
```js
/* 这是UI编辑器中 绘制成段文本 的参考例程 */
创建画布(名称, 横坐标, 纵坐标, 宽度, 高度, 纵深);
绘制成段文本(名称, 文本, 横坐标, 纵坐标, 宽度, 颜色, 对齐, 字体大小, 行间距, 打字机时间间隔, 字体, 字符间距, 加粗, 斜体);
```

==========================================================================================

[继续阅读下一章：API](api)