(function(mod){if(typeof exports=="object"&&typeof module=="object"){mod(require("../../lib/codemirror"))}else{if(typeof define=="function"&&define.amd){define(["../../lib/codemirror"],mod)}else{mod(CodeMirror)}}})(function(CodeMirror){var HINT_ELEMENT_CLASS="CodeMirror-hint";var ACTIVE_HINT_ELEMENT_CLASS="CodeMirror-hint-active";CodeMirror.showHint=function(cm,getHints,options){if(!getHints){return cm.showHint(options)}if(options&&options.async){getHints.async=true}var newOpts={hint:getHints};if(options){for(var prop in options){newOpts[prop]=options[prop]}}return cm.showHint(newOpts)};CodeMirror.defineExtension("showHint",function(options){options=parseOptions(this,this.getCursor("start"),options);var selections=this.listSelections();if(selections.length>1){return}if(this.somethingSelected()){if(!options.hint.supportsSelection){return}for(var i=0;i<selections.length;i++){if(selections[i].head.line!=selections[i].anchor.line){return}}}if(this.state.completionActive){this.state.completionActive.close()}var completion=this.state.completionActive=new Completion(this,options);if(!completion.options.hint){return}CodeMirror.signal(this,"startCompletion",this);completion.update(true)});function Completion(cm,options){this.cm=cm;this.options=options;this.widget=null;this.debounce=0;this.tick=0;this.startPos=this.cm.getCursor("start");this.startLen=this.cm.getLine(this.startPos.line).length-this.cm.getSelection().length;var self=this;cm.on("cursorActivity",this.activityFunc=function(){self.cursorActivity()})}var requestAnimationFrame=window.requestAnimationFrame||function(fn){return setTimeout(fn,1000/60)};var cancelAnimationFrame=window.cancelAnimationFrame||clearTimeout;Completion.prototype={close:function(){if(!this.active()){return}this.cm.state.completionActive=null;this.tick=null;this.cm.off("cursorActivity",this.activityFunc);if(this.widget&&this.data){CodeMirror.signal(this.data,"close")}if(this.widget){this.widget.close()}CodeMirror.signal(this.cm,"endCompletion",this.cm)
},active:function(){return this.cm.state.completionActive==this},pick:function(data,i){var completion=data.list[i];if(completion.hint){completion.hint(this.cm,data,completion)}else{this.cm.replaceRange(getText(completion),completion.from||data.from,completion.to||data.to,"complete")}CodeMirror.signal(data,"pick",completion);this.close()},cursorActivity:function(){if(this.debounce){cancelAnimationFrame(this.debounce);this.debounce=0}var pos=this.cm.getCursor(),line=this.cm.getLine(pos.line);if(pos.line!=this.startPos.line||line.length-pos.ch!=this.startLen-this.startPos.ch||pos.ch<this.startPos.ch||this.cm.somethingSelected()||(pos.ch&&this.options.closeCharacters.test(line.charAt(pos.ch-1)))){this.close()}else{var self=this;this.debounce=requestAnimationFrame(function(){self.update()});if(this.widget){this.widget.disable()}}},update:function(first){if(this.tick==null){return}var self=this,myTick=++this.tick;fetchHints(this.options.hint,this.cm,this.options,function(data){if(self.tick==myTick){self.finishUpdate(data,first)}})},finishUpdate:function(data,first){if(this.data){CodeMirror.signal(this.data,"update")}var picked=(this.widget&&this.widget.picked)||(first&&this.options.completeSingle);if(this.widget){this.widget.close()}this.data=data;if(data&&data.list.length){if(picked&&data.list.length==1){this.pick(data,0)}else{this.widget=new Widget(this,data);CodeMirror.signal(data,"shown")}}}};function parseOptions(cm,pos,options){var editor=cm.options.hintOptions;var out={};for(var prop in defaultOptions){out[prop]=defaultOptions[prop]}if(editor){for(var prop in editor){if(editor[prop]!==undefined){out[prop]=editor[prop]}}}if(options){for(var prop in options){if(options[prop]!==undefined){out[prop]=options[prop]}}}if(out.hint.resolve){out.hint=out.hint.resolve(cm,pos)}return out}function getText(completion){if(typeof completion=="string"){return completion}else{return completion.text}}function buildKeyMap(completion,handle){var baseMap={Up:function(){handle.moveFocus(-1)
},Down:function(){handle.moveFocus(1)},PageUp:function(){handle.moveFocus(-handle.menuSize()+1,true)},PageDown:function(){handle.moveFocus(handle.menuSize()-1,true)},Home:function(){handle.setFocus(0)},End:function(){handle.setFocus(handle.length-1)},Enter:handle.pick,Tab:handle.pick,Esc:handle.close};var custom=completion.options.customKeys;var ourMap=custom?{}:baseMap;function addBinding(key,val){var bound;if(typeof val!="string"){bound=function(cm){return val(cm,handle)}}else{if(baseMap.hasOwnProperty(val)){bound=baseMap[val]}else{bound=val}}ourMap[key]=bound}if(custom){for(var key in custom){if(custom.hasOwnProperty(key)){addBinding(key,custom[key])}}}var extra=completion.options.extraKeys;if(extra){for(var key in extra){if(extra.hasOwnProperty(key)){addBinding(key,extra[key])}}}return ourMap}function getHintElement(hintsElement,el){while(el&&el!=hintsElement){if(el.nodeName.toUpperCase()==="LI"&&el.parentNode==hintsElement){return el}el=el.parentNode}}function Widget(completion,data){this.completion=completion;this.data=data;this.picked=false;var widget=this,cm=completion.cm;var hints=this.hints=document.createElement("ul");hints.className="CodeMirror-hints";this.selectedHint=data.selectedHint||0;var completions=data.list;for(var i=0;i<completions.length;++i){var elt=hints.appendChild(document.createElement("li")),cur=completions[i];var className=HINT_ELEMENT_CLASS+(i!=this.selectedHint?"":" "+ACTIVE_HINT_ELEMENT_CLASS);if(cur.className!=null){className=cur.className+" "+className}elt.className=className;if(cur.render){cur.render(elt,data,cur)}else{elt.appendChild(document.createTextNode(cur.displayText||getText(cur)))}elt.hintId=i}var pos=cm.cursorCoords(completion.options.alignWithWord?data.from:null);var left=pos.left,top=pos.bottom,below=true;hints.style.left=left+"px";hints.style.top=top+"px";var winW=window.innerWidth||Math.max(document.body.offsetWidth,document.documentElement.offsetWidth);var winH=window.innerHeight||Math.max(document.body.offsetHeight,document.documentElement.offsetHeight);
(completion.options.container||document.body).appendChild(hints);var box=hints.getBoundingClientRect(),overlapY=box.bottom-winH;var scrolls=hints.scrollHeight>hints.clientHeight+1;var startScroll=cm.getScrollInfo();if(overlapY>0){var height=box.bottom-box.top,curTop=pos.top-(pos.bottom-box.top);if(curTop-height>0){hints.style.top=(top=pos.top-height)+"px";below=false}else{if(height>winH){hints.style.height=(winH-5)+"px";hints.style.top=(top=pos.bottom-box.top)+"px";var cursor=cm.getCursor();if(data.from.ch!=cursor.ch){pos=cm.cursorCoords(cursor);hints.style.left=(left=pos.left)+"px";box=hints.getBoundingClientRect()}}}}var overlapX=box.right-winW;if(overlapX>0){if(box.right-box.left>winW){hints.style.width=(winW-5)+"px";overlapX-=(box.right-box.left)-winW}hints.style.left=(left=pos.left-overlapX)+"px"}if(scrolls){for(var node=hints.firstChild;node;node=node.nextSibling){node.style.paddingRight=cm.display.nativeBarWidth+"px"}}cm.addKeyMap(this.keyMap=buildKeyMap(completion,{moveFocus:function(n,avoidWrap){widget.changeActive(widget.selectedHint+n,avoidWrap)},setFocus:function(n){widget.changeActive(n)},menuSize:function(){return widget.screenAmount()},length:completions.length,close:function(){completion.close()},pick:function(){widget.pick()},data:data}));if(completion.options.closeOnUnfocus){var closingOnBlur;cm.on("blur",this.onBlur=function(){closingOnBlur=setTimeout(function(){completion.close()},100)});cm.on("focus",this.onFocus=function(){clearTimeout(closingOnBlur)})}cm.on("scroll",this.onScroll=function(){var curScroll=cm.getScrollInfo(),editor=cm.getWrapperElement().getBoundingClientRect();var newTop=top+startScroll.top-curScroll.top;var point=newTop-(window.pageYOffset||(document.documentElement||document.body).scrollTop);if(!below){point+=hints.offsetHeight}if(point<=editor.top||point>=editor.bottom){return completion.close()}hints.style.top=newTop+"px";hints.style.left=(left+startScroll.left-curScroll.left)+"px"});CodeMirror.on(hints,"dblclick",function(e){var t=getHintElement(hints,e.target||e.srcElement);
if(t&&t.hintId!=null){widget.changeActive(t.hintId);widget.pick()}});CodeMirror.on(hints,"click",function(e){var t=getHintElement(hints,e.target||e.srcElement);if(t&&t.hintId!=null){widget.changeActive(t.hintId);if(completion.options.completeOnSingleClick){widget.pick()}}});CodeMirror.on(hints,"mousedown",function(){setTimeout(function(){cm.focus()},20)});CodeMirror.signal(data,"select",completions[this.selectedHint],hints.childNodes[this.selectedHint]);return true}Widget.prototype={close:function(){if(this.completion.widget!=this){return}this.completion.widget=null;this.hints.parentNode.removeChild(this.hints);this.completion.cm.removeKeyMap(this.keyMap);var cm=this.completion.cm;if(this.completion.options.closeOnUnfocus){cm.off("blur",this.onBlur);cm.off("focus",this.onFocus)}cm.off("scroll",this.onScroll)},disable:function(){this.completion.cm.removeKeyMap(this.keyMap);var widget=this;this.keyMap={Enter:function(){widget.picked=true}};this.completion.cm.addKeyMap(this.keyMap)},pick:function(){this.completion.pick(this.data,this.selectedHint)},changeActive:function(i,avoidWrap){if(i>=this.data.list.length){i=avoidWrap?this.data.list.length-1:0}else{if(i<0){i=avoidWrap?0:this.data.list.length-1}}if(this.selectedHint==i){return}var node=this.hints.childNodes[this.selectedHint];node.className=node.className.replace(" "+ACTIVE_HINT_ELEMENT_CLASS,"");node=this.hints.childNodes[this.selectedHint=i];node.className+=" "+ACTIVE_HINT_ELEMENT_CLASS;if(node.offsetTop<this.hints.scrollTop){this.hints.scrollTop=node.offsetTop-3}else{if(node.offsetTop+node.offsetHeight>this.hints.scrollTop+this.hints.clientHeight){this.hints.scrollTop=node.offsetTop+node.offsetHeight-this.hints.clientHeight+3}}CodeMirror.signal(this.data,"select",this.data.list[this.selectedHint],node)},screenAmount:function(){return Math.floor(this.hints.clientHeight/this.hints.firstChild.offsetHeight)||1}};function applicableHelpers(cm,helpers){if(!cm.somethingSelected()){return helpers}var result=[];for(var i=0;
i<helpers.length;i++){if(helpers[i].supportsSelection){result.push(helpers[i])}}return result}function fetchHints(hint,cm,options,callback){if(hint.async){hint(cm,callback,options)}else{var result=hint(cm,options);if(result&&result.then){result.then(callback)}else{callback(result)}}}function resolveAutoHints(cm,pos){var helpers=cm.getHelpers(pos,"hint"),words;if(helpers.length){var resolved=function(cm,callback,options){var app=applicableHelpers(cm,helpers);function run(i){if(i==app.length){return callback(null)}fetchHints(app[i],cm,options,function(result){if(result&&result.list.length>0){callback(result)}else{run(i+1)}})}run(0)};resolved.async=true;resolved.supportsSelection=true;return resolved}else{if(words=cm.getHelper(cm.getCursor(),"hintWords")){return function(cm){return CodeMirror.hint.fromList(cm,{words:words})}}else{if(CodeMirror.hint.anyword){return function(cm,options){return CodeMirror.hint.anyword(cm,options)}}else{return function(){}}}}}CodeMirror.registerHelper("hint","auto",{resolve:resolveAutoHints});CodeMirror.registerHelper("hint","fromList",function(cm,options){var cur=cm.getCursor(),token=cm.getTokenAt(cur);var to=CodeMirror.Pos(cur.line,token.end);if(token.string&&/\w/.test(token.string[token.string.length-1])){var term=token.string,from=CodeMirror.Pos(cur.line,token.start)}else{var term="",from=to}var found=[];for(var i=0;i<options.words.length;i++){var word=options.words[i];if(word.slice(0,term.length)==term){found.push(word)}}if(found.length){return{list:found,from:from,to:to}}});CodeMirror.commands.autocomplete=CodeMirror.showHint;var defaultOptions={hint:CodeMirror.hint.auto,completeSingle:true,alignWithWord:true,closeCharacters:/[\s()\[\]{};:>,]/,closeOnUnfocus:true,completeOnSingleClick:true,container:null,customKeys:null,extraKeys:null};CodeMirror.defineOption("hintOptions",null)});
(function(mod){if(typeof exports=="object"&&typeof module=="object"){mod(require("../../lib/codemirror"),require("./matchesonscrollbar"))}else{if(typeof define=="function"&&define.amd){define(["../../lib/codemirror","./matchesonscrollbar"],mod)}else{mod(CodeMirror)}}})(function(CodeMirror){var defaults={style:"matchhighlight",minChars:2,delay:100,wordsOnly:false,annotateScrollbar:false,showToken:false,trim:true};function State(options){this.options={};for(var name in defaults){this.options[name]=(options&&options.hasOwnProperty(name)?options:defaults)[name]}this.overlay=this.timeout=null;this.matchesonscroll=null;this.active=false}CodeMirror.defineOption("highlightSelectionMatches",false,function(cm,val,old){if(old&&old!=CodeMirror.Init){removeOverlay(cm);clearTimeout(cm.state.matchHighlighter.timeout);cm.state.matchHighlighter=null;cm.off("cursorActivity",cursorActivity);cm.off("focus",onFocus)}if(val){var state=cm.state.matchHighlighter=new State(val);if(cm.hasFocus()){state.active=true;highlightMatches(cm)}else{cm.on("focus",onFocus)}cm.on("cursorActivity",cursorActivity)}});function cursorActivity(cm){var state=cm.state.matchHighlighter;if(state.active||cm.hasFocus()){scheduleHighlight(cm,state)}}function onFocus(cm){var state=cm.state.matchHighlighter;if(!state.active){state.active=true;scheduleHighlight(cm,state)}}function scheduleHighlight(cm,state){clearTimeout(state.timeout);state.timeout=setTimeout(function(){highlightMatches(cm)},state.options.delay)}function addOverlay(cm,query,hasBoundary,style){var state=cm.state.matchHighlighter;cm.addOverlay(state.overlay=makeOverlay(query,hasBoundary,style));if(state.options.annotateScrollbar&&cm.showMatchesOnScrollbar){var searchFor=hasBoundary?new RegExp("\\b"+query.replace(/[\\\[.+*?(){|^$]/g,"\\$&")+"\\b"):query;state.matchesonscroll=cm.showMatchesOnScrollbar(searchFor,false,{className:"CodeMirror-selection-highlight-scrollbar"})}}function removeOverlay(cm){var state=cm.state.matchHighlighter;if(state.overlay){cm.removeOverlay(state.overlay);
state.overlay=null;if(state.matchesonscroll){state.matchesonscroll.clear();state.matchesonscroll=null}}}function highlightMatches(cm){cm.operation(function(){var state=cm.state.matchHighlighter;removeOverlay(cm);if(!cm.somethingSelected()&&state.options.showToken){var re=state.options.showToken===true?/[\w$]/:state.options.showToken;var cur=cm.getCursor(),line=cm.getLine(cur.line),start=cur.ch,end=start;while(start&&re.test(line.charAt(start-1))){--start}while(end<line.length&&re.test(line.charAt(end))){++end}if(start<end){addOverlay(cm,line.slice(start,end),re,state.options.style)}return}var from=cm.getCursor("from"),to=cm.getCursor("to");if(from.line!=to.line){return}if(state.options.wordsOnly&&!isWord(cm,from,to)){return}var selection=cm.getRange(from,to);if(state.options.trim){selection=selection.replace(/^\s+|\s+$/g,"")}if(selection.length>=state.options.minChars){addOverlay(cm,selection,false,state.options.style)}})}function isWord(cm,from,to){var str=cm.getRange(from,to);if(str.match(/^\w+$/)!==null){if(from.ch>0){var pos={line:from.line,ch:from.ch-1};var chr=cm.getRange(pos,from);if(chr.match(/\W/)===null){return false}}if(to.ch<cm.getLine(from.line).length){var pos={line:to.line,ch:to.ch+1};var chr=cm.getRange(to,pos);if(chr.match(/\W/)===null){return false}}return true}else{return false}}function boundariesAround(stream,re){return(!stream.start||!re.test(stream.string.charAt(stream.start-1)))&&(stream.pos==stream.string.length||!re.test(stream.string.charAt(stream.pos)))}function makeOverlay(query,hasBoundary,style){return{token:function(stream){if(stream.match(query)&&(!hasBoundary||boundariesAround(stream,hasBoundary))){return style}stream.next();stream.skipTo(query.charAt(0))||stream.skipToEnd()}}}});
(function(mod){if(typeof exports=="object"&&typeof module=="object"){mod(require("../../lib/codemirror"))}else{if(typeof define=="function"&&define.amd){define(["../../lib/codemirror"],mod)}else{mod(CodeMirror)}}})(function(CodeMirror){var GUTTER_ID="CodeMirror-lint-markers";function showTooltip(e,content){var tt=document.createElement("div");tt.className="CodeMirror-lint-tooltip";tt.appendChild(content.cloneNode(true));document.body.appendChild(tt);function position(e){if(!tt.parentNode){return CodeMirror.off(document,"mousemove",position)}tt.style.top=Math.max(0,e.clientY-tt.offsetHeight-5)+"px";tt.style.left=(e.clientX+5)+"px"}CodeMirror.on(document,"mousemove",position);position(e);if(tt.style.opacity!=null){tt.style.opacity=1}return tt}function rm(elt){if(elt.parentNode){elt.parentNode.removeChild(elt)}}function hideTooltip(tt){if(!tt.parentNode){return}if(tt.style.opacity==null){rm(tt)}tt.style.opacity=0;setTimeout(function(){rm(tt)},600)}function showTooltipFor(e,content,node){var tooltip=showTooltip(e,content);function hide(){CodeMirror.off(node,"mouseout",hide);if(tooltip){hideTooltip(tooltip);tooltip=null}}var poll=setInterval(function(){if(tooltip){for(var n=node;;n=n.parentNode){if(n&&n.nodeType==11){n=n.host}if(n==document.body){return}if(!n){hide();break}}}if(!tooltip){return clearInterval(poll)}},400);CodeMirror.on(node,"mouseout",hide)}function LintState(cm,options,hasGutter){this.marked=[];this.options=options;this.timeout=null;this.hasGutter=hasGutter;this.onMouseOver=function(e){onMouseOver(cm,e)};this.waitingFor=0}function parseOptions(_cm,options){if(options instanceof Function){return{getAnnotations:options}}if(!options||options===true){options={}}return options}function clearMarks(cm){var state=cm.state.lint;if(state.hasGutter){cm.clearGutter(GUTTER_ID)}for(var i=0;i<state.marked.length;++i){state.marked[i].clear()}state.marked.length=0}function makeMarker(labels,severity,multiple,tooltips){var marker=document.createElement("div"),inner=marker;
marker.className="CodeMirror-lint-marker-"+severity;if(multiple){inner=marker.appendChild(document.createElement("div"));inner.className="CodeMirror-lint-marker-multiple"}if(tooltips!=false){CodeMirror.on(inner,"mouseover",function(e){showTooltipFor(e,labels,inner)})}return marker}function getMaxSeverity(a,b){if(a=="error"){return a}else{return b}}function groupByLine(annotations){var lines=[];for(var i=0;i<annotations.length;++i){var ann=annotations[i],line=ann.from.line;(lines[line]||(lines[line]=[])).push(ann)}return lines}function annotationTooltip(ann){var severity=ann.severity;if(!severity){severity="error"}var tip=document.createElement("div");tip.className="CodeMirror-lint-message-"+severity;if(typeof ann.messageHTML!="undefined"){tip.innerHTML=ann.messageHTML}else{tip.appendChild(document.createTextNode(ann.message))}return tip}function lintAsync(cm,getAnnotations,passOptions){var state=cm.state.lint;var id=++state.waitingFor;function abort(){id=-1;cm.off("change",abort)}cm.on("change",abort);getAnnotations(cm.getValue(),function(annotations,arg2){cm.off("change",abort);if(state.waitingFor!=id){return}if(arg2&&annotations instanceof CodeMirror){annotations=arg2}cm.operation(function(){updateLinting(cm,annotations)})},passOptions,cm)}function startLinting(cm){var state=cm.state.lint,options=state.options;var passOptions=options.options||options;var getAnnotations=options.getAnnotations||cm.getHelper(CodeMirror.Pos(0,0),"lint");if(!getAnnotations){return}if(options.async||getAnnotations.async){lintAsync(cm,getAnnotations,passOptions)}else{var annotations=getAnnotations(cm.getValue(),passOptions,cm);if(!annotations){return}if(annotations.then){annotations.then(function(issues){cm.operation(function(){updateLinting(cm,issues)})})}else{cm.operation(function(){updateLinting(cm,annotations)})}}}function updateLinting(cm,annotationsNotSorted){clearMarks(cm);var state=cm.state.lint,options=state.options;var annotations=groupByLine(annotationsNotSorted);for(var line=0;
line<annotations.length;++line){var anns=annotations[line];if(!anns){continue}var maxSeverity=null;var tipLabel=state.hasGutter&&document.createDocumentFragment();for(var i=0;i<anns.length;++i){var ann=anns[i];var severity=ann.severity;if(!severity){severity="error"}maxSeverity=getMaxSeverity(maxSeverity,severity);if(options.formatAnnotation){ann=options.formatAnnotation(ann)}if(state.hasGutter){tipLabel.appendChild(annotationTooltip(ann))}if(ann.to){state.marked.push(cm.markText(ann.from,ann.to,{className:"CodeMirror-lint-mark-"+severity,__annotation:ann}))}}if(state.hasGutter){cm.setGutterMarker(line,GUTTER_ID,makeMarker(tipLabel,maxSeverity,anns.length>1,state.options.tooltips))}}if(options.onUpdateLinting){options.onUpdateLinting(annotationsNotSorted,annotations,cm)}}function onChange(cm){var state=cm.state.lint;if(!state){return}clearTimeout(state.timeout);state.timeout=setTimeout(function(){startLinting(cm)},state.options.delay||500)}function popupTooltips(annotations,e){var target=e.target||e.srcElement;var tooltip=document.createDocumentFragment();for(var i=0;i<annotations.length;i++){var ann=annotations[i];tooltip.appendChild(annotationTooltip(ann))}showTooltipFor(e,tooltip,target)}function onMouseOver(cm,e){var target=e.target||e.srcElement;if(!/\bCodeMirror-lint-mark-/.test(target.className)){return}var box=target.getBoundingClientRect(),x=(box.left+box.right)/2,y=(box.top+box.bottom)/2;var spans=cm.findMarksAt(cm.coordsChar({left:x,top:y},"client"));var annotations=[];for(var i=0;i<spans.length;++i){var ann=spans[i].__annotation;if(ann){annotations.push(ann)}}if(annotations.length){popupTooltips(annotations,e)}}CodeMirror.defineOption("lint",false,function(cm,val,old){if(old&&old!=CodeMirror.Init){clearMarks(cm);if(cm.state.lint.options.lintOnChange!==false){cm.off("change",onChange)}CodeMirror.off(cm.getWrapperElement(),"mouseover",cm.state.lint.onMouseOver);clearTimeout(cm.state.lint.timeout);delete cm.state.lint}if(val){var gutters=cm.getOption("gutters"),hasLintGutter=false;
for(var i=0;i<gutters.length;++i){if(gutters[i]==GUTTER_ID){hasLintGutter=true}}var state=cm.state.lint=new LintState(cm,parseOptions(cm,val),hasLintGutter);if(state.options.lintOnChange!==false){cm.on("change",onChange)}if(state.options.tooltips!=false&&state.options.tooltips!="gutter"){CodeMirror.on(cm.getWrapperElement(),"mouseover",state.onMouseOver)}startLinting(cm)}});CodeMirror.defineExtension("performLint",function(){if(this.state.lint){startLinting(this)}})});
(function(mod){if(typeof exports=="object"&&typeof module=="object"){mod(require("../../lib/codemirror"))}else{if(typeof define=="function"&&define.amd){define(["../../lib/codemirror"],mod)}else{mod(CodeMirror)}}})(function(CodeMirror){function validator(text,options){if(!window.JSHINT){if(window.console){window.console.error("Error: window.JSHINT not defined, CodeMirror JavaScript linting cannot run.")}return[]}if(!options.indent){options.indent=1}JSHINT(text,options,options.globals);var errors=JSHINT.data().errors,result=[];if(errors){parseErrors(errors,result)}return result}CodeMirror.registerHelper("lint","javascript",validator);function parseErrors(errors,output){for(var i=0;i<errors.length;i++){var error=errors[i];if(error){if(error.line<=0){if(window.console){window.console.warn("Cannot display JSHint error (invalid line "+error.line+")",error)}continue}var start=error.character-1,end=start+1;if(error.evidence){var index=error.evidence.substring(start).search(/.\b/);if(index>-1){end+=index}}var hint={message:error.reason,severity:error.code?(error.code.startsWith("W")?"warning":"error"):"error",from:CodeMirror.Pos(error.line-1,start),to:CodeMirror.Pos(error.line-1,end)};output.push(hint)}}}});
(function(mod){if(typeof exports=="object"&&typeof module=="object"){mod(require("../../lib/codemirror"))}else{if(typeof define=="function"&&define.amd){define(["../../lib/codemirror"],mod)}else{mod(CodeMirror)}}})(function(CodeMirror){var defaults={pairs:"()[]{}''\"\"",triples:"",explode:"[]{}"};var Pos=CodeMirror.Pos;CodeMirror.defineOption("autoCloseBrackets",false,function(cm,val,old){if(old&&old!=CodeMirror.Init){cm.removeKeyMap(keyMap);cm.state.closeBrackets=null}if(val){ensureBound(getOption(val,"pairs"));cm.state.closeBrackets=val;cm.addKeyMap(keyMap)}});function getOption(conf,name){if(name=="pairs"&&typeof conf=="string"){return conf}if(typeof conf=="object"&&conf[name]!=null){return conf[name]}return defaults[name]}var keyMap={Backspace:handleBackspace,Enter:handleEnter};function ensureBound(chars){for(var i=0;i<chars.length;i++){var ch=chars.charAt(i),key="'"+ch+"'";if(!keyMap[key]){keyMap[key]=handler(ch)}}}ensureBound(defaults.pairs+"`");function handler(ch){return function(cm){return handleChar(cm,ch)}}function getConfig(cm){var deflt=cm.state.closeBrackets;if(!deflt||deflt.override){return deflt}var mode=cm.getModeAt(cm.getCursor());return mode.closeBrackets||deflt}function handleBackspace(cm){var conf=getConfig(cm);if(!conf||cm.getOption("disableInput")){return CodeMirror.Pass}var pairs=getOption(conf,"pairs");var ranges=cm.listSelections();for(var i=0;i<ranges.length;i++){if(!ranges[i].empty()){return CodeMirror.Pass}var around=charsAround(cm,ranges[i].head);if(!around||pairs.indexOf(around)%2!=0){return CodeMirror.Pass}}for(var i=ranges.length-1;i>=0;i--){var cur=ranges[i].head;cm.replaceRange("",Pos(cur.line,cur.ch-1),Pos(cur.line,cur.ch+1),"+delete")}}function handleEnter(cm){var conf=getConfig(cm);var explode=conf&&getOption(conf,"explode");if(!explode||cm.getOption("disableInput")){return CodeMirror.Pass}var ranges=cm.listSelections();for(var i=0;i<ranges.length;i++){if(!ranges[i].empty()){return CodeMirror.Pass}var around=charsAround(cm,ranges[i].head);
if(!around||explode.indexOf(around)%2!=0){return CodeMirror.Pass}}cm.operation(function(){var linesep=cm.lineSeparator()||"\n";cm.replaceSelection(linesep+linesep,null);cm.execCommand("goCharLeft");ranges=cm.listSelections();for(var i=0;i<ranges.length;i++){var line=ranges[i].head.line;cm.indentLine(line,null,true);cm.indentLine(line+1,null,true)}})}function contractSelection(sel){var inverted=CodeMirror.cmpPos(sel.anchor,sel.head)>0;return{anchor:new Pos(sel.anchor.line,sel.anchor.ch+(inverted?-1:1)),head:new Pos(sel.head.line,sel.head.ch+(inverted?1:-1))}}function handleChar(cm,ch){var conf=getConfig(cm);if(!conf||cm.getOption("disableInput")){return CodeMirror.Pass}var pairs=getOption(conf,"pairs");var pos=pairs.indexOf(ch);if(pos==-1){return CodeMirror.Pass}var triples=getOption(conf,"triples");var identical=pairs.charAt(pos+1)==ch;var ranges=cm.listSelections();var opening=pos%2==0;var type;for(var i=0;i<ranges.length;i++){var range=ranges[i],cur=range.head,curType;var next=cm.getRange(cur,Pos(cur.line,cur.ch+1));if(opening&&!range.empty()){curType="surround"}else{if((identical||!opening)&&next==ch){if(identical&&stringStartsAfter(cm,cur)){curType="both"}else{if(triples.indexOf(ch)>=0&&cm.getRange(cur,Pos(cur.line,cur.ch+3))==ch+ch+ch){curType="skipThree"}else{curType="skip"}}}else{if(identical&&cur.ch>1&&triples.indexOf(ch)>=0&&cm.getRange(Pos(cur.line,cur.ch-2),cur)==ch+ch){if(cur.ch>2&&/\bstring/.test(cm.getTokenTypeAt(Pos(cur.line,cur.ch-2)))){return CodeMirror.Pass}curType="addFour"}else{if(identical){var prev=cur.ch==0?" ":cm.getRange(Pos(cur.line,cur.ch-1),cur);if(!CodeMirror.isWordChar(next)&&prev!=ch&&!CodeMirror.isWordChar(prev)){curType="both"}else{return CodeMirror.Pass}}else{if(opening&&(cm.getLine(cur.line).length==cur.ch||isClosingBracket(next,pairs)||/\s/.test(next))){curType="both"}else{return CodeMirror.Pass}}}}}if(!type){type=curType}else{if(type!=curType){return CodeMirror.Pass}}}var left=pos%2?pairs.charAt(pos-1):ch;var right=pos%2?ch:pairs.charAt(pos+1);
cm.operation(function(){if(type=="skip"){cm.execCommand("goCharRight")}else{if(type=="skipThree"){for(var i=0;i<3;i++){cm.execCommand("goCharRight")}}else{if(type=="surround"){var sels=cm.getSelections();for(var i=0;i<sels.length;i++){sels[i]=left+sels[i]+right}cm.replaceSelections(sels,"around");sels=cm.listSelections().slice();for(var i=0;i<sels.length;i++){sels[i]=contractSelection(sels[i])}cm.setSelections(sels)}else{if(type=="both"){cm.replaceSelection(left+right,null);cm.triggerElectric(left+right);cm.execCommand("goCharLeft")}else{if(type=="addFour"){cm.replaceSelection(left+left+left+left,"before");cm.execCommand("goCharRight")}}}}}})}function isClosingBracket(ch,pairs){var pos=pairs.lastIndexOf(ch);return pos>-1&&pos%2==1}function charsAround(cm,pos){var str=cm.getRange(Pos(pos.line,pos.ch-1),Pos(pos.line,pos.ch+1));return str.length==2?str:null}function stringStartsAfter(cm,pos){var token=cm.getTokenAt(Pos(pos.line,pos.ch+1));return/\bstring/.test(token.type)&&token.start==pos.ch&&(pos.ch==0||!/\bstring/.test(cm.getTokenTypeAt(pos)))}});
(function(mod){if(typeof exports=="object"&&typeof module=="object"){mod(require("../../lib/codemirror"))}else{if(typeof define=="function"&&define.amd){define(["../../lib/codemirror"],mod)}else{mod(CodeMirror)}}})(function(CodeMirror){var Pos=CodeMirror.Pos;function forEach(arr,f){for(var i=0,e=arr.length;i<e;++i){f(arr[i])}}function arrayContains(arr,item){if(!Array.prototype.indexOf){var i=arr.length;while(i--){if(arr[i]===item){return true}}return false}return arr.indexOf(item)!=-1}function scriptHint(editor,keywords,getToken,options){var cur=editor.getCursor(),token=getToken(editor,cur);if(/\b(?:string|comment)\b/.test(token.type)){return}token.state=CodeMirror.innerMode(editor.getMode(),token.state).state;if(!/^[\w$_]*$/.test(token.string)){token={start:cur.ch,end:cur.ch,string:"",state:token.state,type:token.string=="."?"property":null}}else{if(token.end>cur.ch){token.end=cur.ch;token.string=token.string.slice(0,cur.ch-token.start)}}var tprop=token;while(tprop.type=="property"){tprop=getToken(editor,Pos(cur.line,tprop.start));if(tprop.string!="."){return}tprop=getToken(editor,Pos(cur.line,tprop.start));if(!context){var context=[]}context.push(tprop)}return{list:getCompletions(token,context,keywords,options),from:Pos(cur.line,token.start),to:Pos(cur.line,token.end)}}function javascriptHint(editor,options){return scriptHint(editor,javascriptKeywords,function(e,cur){return e.getTokenAt(cur)},options)}CodeMirror.registerHelper("hint","javascript",javascriptHint);function getCoffeeScriptToken(editor,cur){var token=editor.getTokenAt(cur);if(cur.ch==token.start+1&&token.string.charAt(0)=="."){token.end=token.start;token.string=".";token.type="property"}else{if(/^\.[\w$_]*$/.test(token.string)){token.type="property";token.start++;token.string=token.string.replace(/\./,"")}}return token}function coffeescriptHint(editor,options){return scriptHint(editor,coffeescriptKeywords,getCoffeeScriptToken,options)}CodeMirror.registerHelper("hint","coffeescript",coffeescriptHint);var stringProps=("charAt charCodeAt indexOf lastIndexOf substring substr slice trim trimLeft trimRight "+"toUpperCase toLowerCase split concat match replace search").split(" ");
var arrayProps=("length concat join splice push pop shift unshift slice reverse sort indexOf "+"lastIndexOf every some filter forEach map reduce reduceRight ").split(" ");var funcProps="prototype apply call bind".split(" ");var javascriptKeywords=("break case catch class const continue debugger default delete do else export extends false finally for function "+"if in import instanceof new null return super switch this throw true try typeof var void while with yield").split(" ");var coffeescriptKeywords=("and break catch class continue delete do else extends false finally for "+"if in instanceof isnt new no not null of off on or return switch then throw true try typeof until void while with yes").split(" ");function forAllProps(obj,callback){if(!Object.getOwnPropertyNames||!Object.getPrototypeOf){for(var name in obj){callback(name)}}else{for(var o=obj;o;o=Object.getPrototypeOf(o)){Object.getOwnPropertyNames(o).forEach(callback)}}}function getCompletions(token,context,keywords,options){var found=[],start=token.string,global=options&&options.globalScope||window;function maybeAdd(str){if(str==null||str==undefined){return}if(str.lastIndexOf(start,0)==0&&!arrayContains(found,str)){found.push(str)}}function gatherCompletions(obj){if(typeof obj=="string"){forEach(stringProps,maybeAdd)}else{if(obj instanceof Array){forEach(arrayProps,maybeAdd)}else{if(obj instanceof Function){forEach(funcProps,maybeAdd)}}}forAllProps(obj,maybeAdd)}if(context&&context.length){var obj=context.pop(),base;if(obj.type&&obj.type.indexOf("variable")===0){if(options&&options.additionalContext){base=options.additionalContext[obj.string]}if(!options||options.useGlobalScope!==false){base=base||global[obj.string]}}else{if(obj.type=="string"){base=""}else{if(obj.type=="atom"){base=1}else{if(obj.type=="function"){if(global.jQuery!=null&&(obj.string=="$"||obj.string=="jQuery")&&(typeof global.jQuery=="function")){base=global.jQuery()}else{if(global._!=null&&(obj.string=="_")&&(typeof global._=="function")){base=global._()
}}}}}}while(base!=null&&context.length){base=base[context.pop().string]}if(base!=null){gatherCompletions(base)}}else{for(var v=token.state.localVars;v;v=v.next){maybeAdd(v.name)}for(var v=token.state.globalVars;v;v=v.next){maybeAdd(v.name)}if(!options||options.useGlobalScope!==false){gatherCompletions(global)}forEach(keywords,maybeAdd)}return found}});
