import { TimingFn } from 'mutate-animate';
import { Undoable } from '../interface';
import { ResourceController } from '../loader/controller';
export declare class BgmController extends ResourceController<HTMLAudioElement> implements Undoable<BgmIds> {
    /** Bgm播放栈，可以undo，最多存放10个 */
    stack: BgmIds[];
    /** Bgm的redo栈，最多存放10个 */
    redoStack: BgmIds[];
    /** 当前播放的bgm */
    now?: BgmIds;
    /** 渐变切歌时长 */
    transitionTime: number;
    /** 渐变切歌的音量曲线 */
    transitionCurve: TimingFn;
    /** 音量 */
    volume: number;
    /** 是否关闭了bgm */
    disable: boolean;
    /** 是否正在播放bgm */
    playing: boolean;
    private transitionData;
    /**
     * 添加一个bgm
     * @param uri bgm的`uri`，由于bgm是一类资源，因此`uri`为`bgms.xxx`的形式
     * @param data bgm音频元素
     */
    add(uri: string, data: HTMLAudioElement): void;
    /**
     * 加载一个bgm
     * @param id 要加载的bgm
     */
    load(id: BgmIds): void;
    /**
     * 切换bgm，具有渐变效果，可以通过监听切换事件，同时调用preventDefault来阻止渐变，
     * 并使用自己的切歌程序。阻止后，不会将切换的歌曲加入播放栈，也不会进行切歌，
     * 所有的切歌操作均由你自己的程序执行
     * @param id 要切换至的bgm
     * @param when 切换至的歌从什么时候开始播放，默认-1，表示不改变，整数表示设置为目标值
     */
    changeTo(id: BgmIds, when?: number, noStack?: boolean): void;
    /**
     * 暂停当前bgm的播放，继续播放时将会延续暂停的时刻，同样可以使用preventDefault使用自己的暂停程序
     * @param transition 是否使用渐变效果，默认使用
     */
    pause(transition?: boolean): void;
    /**
     * 继续当前bgm的播放，从上一次暂停的时刻开始播放，同样可以使用preventDefault使用自己的播放程序
     * @param transition 是否使用渐变效果，默认使用
     */
    resume(transition?: boolean): void;
    /**
     * 播放bgm，不进行渐变操作，效果为没有渐变的切歌，也会触发changeBgm事件，可以被preventDefault
     * @param id 要播放的bgm
     * @param when 从bgm的何时开始播放
     */
    play(id: BgmIds, when?: number, noStack?: boolean): void;
    /**
     * 撤销当前播放，改为播放前一个bgm
     */
    undo(transition?: boolean, when?: number): BgmIds | undefined;
    /**
     * 取消上一次的撤销，改为播放上一次撤销的bgm
     */
    redo(transition?: boolean, when?: number): BgmIds | undefined;
    /**
     * 设置渐变切歌信息
     * @param time 渐变时长
     * @param curve 渐变的音量曲线
     */
    setTransition(time?: number, curve?: TimingFn): void;
    /**
     * 根据id获取bgm
     * @param id 要获取的bgm的id
     */
    get(id: BgmIds): HTMLAudioElement;
    private setTransitionAnimate;
}
export declare const bgm: BgmController;
