import { AudioParamOf, AudioPlayer } from './audio';
import { ResourceController } from '../loader/controller';
type Panner = AudioParamOf<PannerNode>;
type Listener = AudioParamOf<AudioListener>;
export declare class SoundEffect extends AudioPlayer {
    static playIndex: number;
    /** 音量 */
    static volume: number;
    /** 是否关闭音效 */
    static disable: boolean;
    private playing;
    private _stopingAll;
    private playMap;
    private _stereo;
    gain: GainNode;
    panner: PannerNode | null;
    set volumn(value: number);
    get volumn(): number;
    set stereo(value: boolean);
    get stereo(): boolean;
    constructor(data: ArrayBuffer, stereo?: boolean);
    /**
     * 设置音频路由线路
     * ```txt
     * 不启用立体声：source -> gain -> destination
     * 启用立体声：source -> panner -> gain -> destination
     * ```
     * @param stereo 是否启用立体声
     */
    protected initAudio(stereo?: boolean): void;
    /**
     * 播放音频
     * @returns 音频的唯一id
     */
    playSE(): number | undefined;
    /**
     * 停止所有音频
     */
    stopAll(): void;
    /**
     * 根据唯一id停止音频
     * @param index 音频唯一id
     */
    stopByIndex(index: number): void;
    /**
     * 设置立体声信息
     * @param source 立体声声源位置与朝向
     * @param listener 听者的位置、头顶方向、面朝方向
     */
    setPanner(source?: Partial<Panner>, listener?: Partial<Listener>): void;
}
export declare class SoundController extends ResourceController<ArrayBuffer, SoundEffect> {
    private seIndex;
    /**
     * 添加一个新的音频
     * @param uri 音频的uri，由于音频也是一种资源，因此格式为`sounds.xxx`
     * @param data 音频的ArrayBuffer信息，会被解析为AudioBuffer
     */
    add(uri: string, data: ArrayBuffer): SoundEffect;
    /**
     * 播放音频
     * @param sound 音效的名称
     * @returns 本次播放的音效的唯一标识符，如果音效不存在返回-1
     */
    play(sound: SoundIds, end?: () => void): number;
    /**
     * 停止一个音效的播放
     * @param id 音效的唯一标识符
     */
    stop(id: number): void;
    /**
     * 停止一个名称的所有音效的播放
     * @param id 音效名称
     */
    stopById(id: SoundIds): void;
    /**
     * 停止所有音效的播放
     */
    stopAll(): void;
    /**
     * 获取一个音效实例
     * @param sound 音效名称
     */
    get(sound: SoundIds): SoundEffect;
    getPlaying(sound?: SoundIds): string[];
}
export declare const sound: SoundController;
export {};
