export declare class GameStorage<T extends object = any> {
    static list: GameStorage<any>[];
    key: string;
    data: T;
    constructor(key: string);
    /**
     * 从本地存储读取
     */
    read(): T;
    /**
     * 写入本地存储
     */
    write(): void;
    /**
     * 设置存储的值
     * @param key 存储的名称
     * @param value 存储的值
     */
    setValue<K extends keyof T>(key: K, value: T[K]): void;
    setValue(key: string, value: any): void;
    getValue<K extends keyof T>(key: K): T[K] | null;
    getValue<K extends keyof T>(key: K, defaults: T[K]): T[K];
    getValue<T>(key: string, defaults?: T): T;
    toJSON(): string;
    clear(): void;
    keys(): string[];
    values(): any[];
    entries(): [string, any][];
    /**
     * 获取本游戏的存储键
     * @param key 存储名称
     */
    static fromGame(key: string): string;
    /**
     * 获取与作者相关联的存储键
     * @param _ 填充参数，无用
     * @param key 存储名称
     */
    static fromAuthor(_: any, key: string): string;
    /**
     * 根据存储键获取对应的存储实例
     * @param key 存储键
     * @example Storage.get(Storage.fromAuthor('AncTe', 'setting'));
     */
    static get(key: string): GameStorage<any> | undefined;
}
