/**
 * 滑动数组
 * @param arr
 * @param delta
 */
export declare function slide<T>(arr: T[], delta: number): T[];
export declare function backDir(dir: Dir): Dir;
export declare function has<T>(v: T): v is NonNullable<T>;
export declare function maxGameScale(n?: number): void;
export declare function ensureArray<T>(arr: T): T extends any[] ? T : T[];
export declare function ofDir(x: number, y: number, dir: Dir2): LocArr;
/**
 * 计算曼哈顿距离
 */
export declare function manhattan(x1: number, y1: number, x2: number, y2: number): number;
/**
 * 检查一个点是否在当前超大地图 v2 优化范围内
 */
export declare function checkV2(x?: number, y?: number): boolean;
export declare function formatDamage(damage: number): DamageString;
/**
 * 判断一个数组的数值是否全部相等
 * @param arr 要判断的数组
 */
export declare function equal(arr: number[]): boolean;
/**
 * 判断一个数组的元素的某个属性的数值是否全部相等
 * @param arr 要判断的数组
 * @param key 要判断的属性名
 */
export declare function equal<T>(arr: T[], key: keyof T): boolean;
/**
 * 获得一个数组的数值的最大值和最小值
 * @param arr 要获得的数组
 */
export declare function boundary(arr: number[]): [number, number];
/**
 * 获得一个数组的元素的某个属性的数值的最大值和最小值
 * @param arr 要获得的数组
 * @param key 要获得的属性名
 */
export declare function boundary<T>(arr: T[], key: keyof T): [number, number];
/**
 * 获取两个坐标的相对方向
 * @param from 初始坐标
 * @param to 指向坐标
 */
export declare function findDir(from: Loc, to: Loc): Dir2 | 'none';
