import { Camera } from './camera';
import { Renderer } from './render';
export type ParticleColor = [number, number, number, number];
interface ParticleThreshold {
    radius: number;
    color: number;
    posX: number;
    posY: number;
    posZ: number;
}
export interface ParticleOne {
    x: number;
    y: number;
    z: number;
    r: number;
    color: ParticleColor;
}
interface Loc3D extends Loc {
    z: number;
}
export declare class Particle {
    /** 绑定的摄像机 */
    camera?: Camera;
    /** 粒子中心位置 */
    pos: Loc3D;
    /** 粒子密度，即粒子总数 */
    density: number;
    /** 粒子颜色 */
    color: ParticleColor;
    /** 每个粒子的半径 */
    radius: number;
    /** 渲染器 */
    renderer?: Renderer;
    /** 需要渲染的粒子列表 */
    list: ParticleOne[];
    /** 是否需要更新缓冲区数据 */
    needUpdateBuffer: boolean;
    /** 当前缓存信息 */
    cache?: Float32Array;
    /** 是否需要更新 */
    private needUpdate;
    private ticker;
    /** 设置信息前的信息 */
    private originInfo;
    /** 各个属性的阈值 */
    threshold: ParticleThreshold;
    constructor();
    /**
     * 设置粒子中心的位置
     * @param x 横坐标
     * @param y 纵坐标
     */
    setPos(x?: number, y?: number, z?: number): Particle;
    /**
     * 设置粒子的密度，即粒子总数
     * @param density 密度
     */
    setDensity(density: number): Particle;
    /**
     * 设置粒子的颜色
     * @param color 颜色
     */
    setColor(color: ParticleColor): this;
    /**
     * 设置粒子的半径
     * @param radius 半径
     */
    setRadius(radius: number): this;
    /**
     * 设置粒子的阈值信息
     * @param data 阈值信息
     */
    setThreshold(data: Partial<ParticleThreshold>): Particle;
    /**
     * 添加到一个渲染器上
     * @param renderer 渲染器
     */
    appendTo(renderer: Renderer): void;
    /**
     * 从当前渲染器上移除
     */
    remove(): void;
    /**
     * 更新粒子信息
     */
    update(): void;
    /**
     * 生成粒子，注意该函数会删除当前的所有粒子，然后再重新生成
     */
    generate(): void;
    /**
     * 获取粒子的Float32Array信息
     */
    getArrayInfo(): Float32Array;
    /**
     * 每帧执行的粒子更新器
     */
    private updateParticleData;
    /**
     * 生成指定数量的粒子
     * @param num 生成数量
     */
    private generateNewParticles;
    /**
     * 渲染这个粒子
     */
    private render;
}
export {};
