export default function init(): {
    useDrag: typeof useDrag;
    useWheel: typeof useWheel;
    useUp: typeof useUp;
    isMobile: boolean;
};
type DragFn = (x: number, y: number, e: MouseEvent | TouchEvent) => void;
/**
 * 是否是移动设备
 */
export declare let isMobile: boolean;
/**
 * 向一个元素添加拖拽事件
 * @param ele 目标元素，当为全局拖拽时，传入数组表示所有元素共用一个全局拖拽函数
 * @param fn 拖拽时触发的函数，传入x y和鼠标事件或点击事件
 * @param ondown 鼠标按下时执行的函数
 * @param global 是否全局拖拽，即拖拽后鼠标或手指离开元素后是否依然视为正在拖拽
 */
export declare function useDrag(ele: HTMLElement | HTMLElement[], fn: DragFn, ondown?: DragFn, onup?: (e: MouseEvent | TouchEvent) => void, global?: boolean): void;
/**
 * 去除一个全局拖拽函数
 * @param fn 要去除的函数
 */
export declare function cancelGlobalDrag(fn: DragFn): void;
/**
 * 当触发滚轮时执行函数
 * @param ele 目标元素
 * @param fn 当滚轮触发时执行的函数
 */
export declare function useWheel(ele: HTMLElement, fn: (x: number, y: number, z: number, e: WheelEvent) => void): void;
/**
 * 当鼠标或手指松开时执行函数
 * @param ele 目标元素
 * @param fn 当鼠标或手指松开时执行的函数
 */
export declare function useUp(ele: HTMLElement, fn: DragFn): void;
/**
 * 当鼠标或手指按下时执行函数
 * @param ele 目标元素
 * @param fn 当鼠标或手指按下时执行的函数
 */
export declare function useDown(ele: HTMLElement, fn: DragFn): void;
export {};
