export declare class Matrix extends Array<number[]> {
    constructor(...n: number[][]);
    /**
     * 加上某个方阵
     * @param matrix 要加上的方阵
     */
    add(matrix: number[][]): Matrix;
    /**
     * 让该方阵与另一个方阵相乘
     * @param matrix 要相乘的方阵
     */
    multipy(matrix: number[][]): Matrix;
}
export declare class Matrix4 extends Matrix {
    constructor(...n: number[][]);
    /**
     * 平移变换
     * @param x 平移横坐标
     * @param y 平移纵坐标
     * @param z 平移竖坐标
     */
    translate(x: number, y: number, z: number): void;
    /**
     * 缩放变换
     * @param x 沿x轴的缩放比例
     * @param y 沿y轴的缩放比例
     * @param z 沿z轴的缩放比例
     */
    scale(x: number, y: number, z: number): void;
    /**
     * 旋转变换
     * @param x 绕x轴的旋转角度
     * @param y 绕y轴的旋转角度
     * @param z 绕z轴的旋转角度
     */
    rotate(x?: number, y?: number, z?: number): Matrix4;
    /**
     * 转置矩阵
     * @param target 转置目标，是赋给原矩阵还是新建一个矩阵
     */
    transpose(target?: 'this' | 'new'): Matrix4;
    /**
     * 转换成列主序的Float32Array，用于webgl
     */
    toWebGLFloat32Array(): Float32Array;
}
