var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作。
		// 若需要进行切分图片，可以使用 core.splitImage() 函数，或直接在全塔属性-图片切分中操作
		// 
		core.ui.statusBar.init();
	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "resizeTo11": function () {
	if (main.mode == 'editor') {
		return;
	}

	// 在不修改libs的情况下将页面适配为11x11
	core.__SIZE__ = 11;
	core.__PIXELS__ = core.__SIZE__ * 32;
	core.__HALF_SIZE__ = 5;
	// core.bigmap.width = core.__SIZE__;
	// core.bigmap.height = core.__SIZE__;
	core.actions.SIZE = core.__SIZE__;
	core.actions.HSIZE = core.__HALF_SIZE__;
	core.actions.LAST = core.__SIZE__ - 1;
	core.actions.CHOICES_LEFT = 3;
	core.actions.CHOICES_RIGHT = core.actions.LAST - core.actions.CHOICES_LEFT;
	core.ui.SIZE = core.__SIZE__;
	core.ui.HSIZE = core.__HALF_SIZE__;
	core.ui.LAST = core.__SIZE__ - 1;
	core.ui.PIXEL = core.__PIXELS__;
	core.ui.HPIXEL = core.__PIXELS__ / 2;
},
    "statusBar": function () {
	main.dom.floorMsgGroup.style.display = 'none';
	main.dom.statusBar.style.display = 'none';
	main.dom.toolBar.style.display = 'none';

	const GAMEVIEW_WIDTH = 640;
	const GAMEVIEW_HEIGHT = 422;

	const GAMEVIEW_WIDTH_VERTICAL = 388;
	const GAMEVIEW_HEIGHT_VERTICAL = 630;

	const BAR_WIDTH = 125;
	const BAR_HEIGHT_VERTICAL = 130;
	const BORDER_WIDTH = 18;
	const BORDER_HEIGHT = 24;

	const ITEM_BOX_LEFT = 13;
	const ITEM_BOX_TOP = 190;
	const ITEM_BOX_LEFT_VERTICAL = 219;
	const ITEM_BOX_TOP_VERTICAL = 10;

	const ITEM_ICON_OUTER_SIZE = 33;

	const EQUIP_BLOCK_LEFT = 525;
	const EQUIP_BLOCK_TOP = 40;
	const EQUIP_BLOCK_LEFT_VERTICAL = 108;
	const EQUIP_BLOCK_TOP_VERTICAL = 0;

	const KEY_BLOCK_LEFT = EQUIP_BLOCK_LEFT;
	const KEY_BLOCK_LEFT_VERTICAL = EQUIP_BLOCK_LEFT_VERTICAL;
	const KEY_BLOCK_TOP_VERTICAL = 86;

	const INFO_BLOCK_LEFT = EQUIP_BLOCK_LEFT;
	const INFO_BLOCK_TOP = 220;
	const INFO_BLOCK_LEFT_VERTICAL = 8;
	const INFO_BLOCK_TOP_VERTICAL = 538;

	const TOOL_BOX_LEFT = EQUIP_BLOCK_LEFT;
	const TOOL_BOX_TOP = 318;
	const TOOL_BOX_LEFT_VERTICAL = 278;
	const TOOL_BOX_TOP_VERTICAL = INFO_BLOCK_TOP_VERTICAL;

	const TOOL_ICON_OUTER_SIZE = 34;

	const INFO_BAR_HEIGHT = 22;
	const INFO_BAR_HEIGHT_VERTICAL = 18;
	const INFO_BAR_TOP = GAMEVIEW_HEIGHT - INFO_BAR_HEIGHT;
	const INFO_BAR_TOP_VERTICAL = GAMEVIEW_HEIGHT_VERTICAL - INFO_BAR_HEIGHT_VERTICAL;

	const TEXT_COLOR = "#E1E1E1";

	const FORCE_COUNTABLE_ITEMS = ["centerFly", "yellowGem"];

	const outerBackground = document.createElement('canvas');
	outerBackground.style.position = 'absolute';
	outerBackground.style.zIndex = 5;
	outerBackground.id = 'outerBackground';
	main.dom.outerBackground = outerBackground;
	main.dom.startPanel.insertAdjacentElement('afterend', outerBackground);

	const outerUI = document.createElement('canvas');
	outerUI.style.position = 'absolute';
	outerUI.style.zIndex = 165;
	outerUI.id = 'outerUI';
	main.dom.outerUI = outerUI;
	outerBackground.insertAdjacentElement('afterend', outerUI);
	setTimeout(function () {
		// Should be executed immediately after init()
		main.canvas.outerUI = outerUI.getContext('2d');
	});
	outerUI.onclick = function (e) {
		try {
			e.preventDefault();
			if (!core.isPlaying()) return false;
			const left = core.dom.gameGroup.offsetLeft;
			const top = core.dom.gameGroup.offsetTop;
			const px = parseInt((e.clientX - left) / core.domStyle.scale),
				py = parseInt((e.clientY - top) / core.domStyle.scale);
			core.ui.statusBar.onclick(px, py);
		} catch (ee) {
			main.log(ee);
		}
	}

	const _resize_gameGroup = function (obj) {
		const gameGroup = core.dom.gameGroup;
		gameGroup.style.width = obj.totalWidth + "px";
		gameGroup.style.height = obj.totalHeight + "px";
		gameGroup.style.left = (obj.clientWidth - obj.totalWidth) / 2 + "px";
		gameGroup.style.top = (obj.clientHeight - obj.totalHeight) / 2 + "px";

		core.dom.musicBtn.style.right = (obj.clientWidth - obj.totalWidth) / 2 + "px";
		core.dom.musicBtn.style.bottom = (obj.clientHeight - obj.totalHeight) / 2 - 27 + "px";
		core.dom.enlargeBtn.style.right = (obj.clientWidth - obj.totalWidth) / 2 + 31 + "px";
		core.dom.enlargeBtn.style.bottom = (obj.clientHeight - obj.totalHeight) / 2 - 27 + "px";

		main.dom.startBackground.src = main.styles.startBackground;
	}

	const _resize_canvas = function (obj) {
		main.dom.outerBackground.style.width = obj.totalWidth + 'px';
		main.dom.outerBackground.style.height = obj.totalHeight + 'px';
		main.dom.outerUI.style.width = obj.totalWidth + 'px';
		main.dom.outerUI.style.height = obj.totalHeight + 'px';

		const innerSize = (obj.canvasWidth * core.domStyle.scale) + "px";
		for (let i = 0; i < core.dom.gameCanvas.length; ++i)
			core.dom.gameCanvas[i].style.width = core.dom.gameCanvas[i].style.height = innerSize;
		core.dom.gif.style.width = core.dom.gif.style.height = innerSize;
		core.dom.gif2.style.width = core.dom.gif2.style.height = innerSize;
		core.dom.gameDraw.style.width = core.dom.gameDraw.style.height = innerSize;
		core.dom.gameDraw.style.top = obj.gameDrawBox.top * core.domStyle.scale + "px";
		core.dom.gameDraw.style.left = (obj.gameDrawBox.left) * core.domStyle.scale + "px";

		// resize bigmap
		core.bigmap.canvas.forEach(function (cn) {
			const ratio = core.canvas[cn].canvas.hasAttribute('isHD') ? core.domStyle.ratio : 1;
			core.canvas[cn].canvas.style.width = core.canvas[cn].canvas.width / ratio * core.domStyle.scale + "px";
			core.canvas[cn].canvas.style.height = core.canvas[cn].canvas.height / ratio * core.domStyle.scale + "px";
		});
		// resize dynamic canvas
		for (const name in core.dymCanvas) {
			const ctx = core.dymCanvas[name],
				canvas = ctx.canvas;
			const ratio = canvas.hasAttribute('isHD') ? core.domStyle.ratio : 1;
			canvas.style.width = canvas.width / ratio * core.domStyle.scale + "px";
			canvas.style.height = canvas.height / ratio * core.domStyle.scale + "px";
			canvas.style.left = parseFloat(canvas.getAttribute("_left")) * core.domStyle.scale + "px";
			canvas.style.top = parseFloat(canvas.getAttribute("_top")) * core.domStyle.scale + "px";
		}
		// resize next
		main.dom.next.style.width = main.dom.next.style.height = 5 * core.domStyle.scale + "px";
		main.dom.next.style.borderBottomWidth = main.dom.next.style.borderRightWidth = 4 * core.domStyle.scale + "px";

	}

	core.control.resize = function () {
		if (main.mode == 'editor') return;

		const clientWidth = main.dom.body.clientWidth,
			clientHeight = main.dom.body.clientHeight;
		const canvasWidth = core.__PIXELS__;

		const isVertical = clientHeight > clientWidth;
		core.domStyle.isVertical = isVertical;

		const totalWidth = isVertical ? GAMEVIEW_WIDTH_VERTICAL : GAMEVIEW_WIDTH,
			totalHeight = isVertical ? GAMEVIEW_HEIGHT_VERTICAL : GAMEVIEW_HEIGHT;

		const maxRatio = Math.min(clientWidth / totalWidth, clientHeight / totalHeight);

		core.domStyle.availableScale = [];
		[1, 1.25, 1.5, 1.75, 2].forEach(function (v) {
			if (maxRatio >= v) {
				core.domStyle.availableScale.push(v);
			}
		});

		if (core.domStyle.availableScale.indexOf(core.domStyle.scale) < 0) {
			core.domStyle.scale = Math.min(1, maxRatio);
		} else if (core.getLocalStorage('scale') == null && core.domStyle.availableScale.length >= 2) {
			core.domStyle.scale = core.domStyle.availableScale[core.domStyle.availableScale.length - 2];
			core.setLocalStorage('scale', core.domStyle.scale);
		}

		const totalWidthScaled = totalWidth * core.domStyle.scale,
			totalHeightScaled = totalHeight * core.domStyle.scale;

		const gameDrawBox = isVertical ? { left: BORDER_WIDTH, top: BAR_HEIGHT_VERTICAL + BORDER_HEIGHT } : { left: BAR_WIDTH + BORDER_WIDTH, top: BORDER_HEIGHT };

		const obj = {
			clientWidth: clientWidth,
			clientHeight: clientHeight,
			canvasWidth: canvasWidth,
			totalWidth: totalWidthScaled,
			totalHeight: totalHeightScaled,
			gameDrawBox: gameDrawBox,
			globalAttribute: core.status.globalAttribute || core.initStatus.globalAttribute,
		};

		_resize_gameGroup(obj);
		_resize_canvas(obj);

		if (core.status.automaticRoute == null) core.status.automaticRoute = {};
		core.control.setViewport(32, 32);
		core.updateStatusBar();
	}

	class StatusBar {
		constructor() {
			this.itemMx = [
				/*
				["book", "wand", "fly"],
				["cross", "superPotion", "pickaxe"],
				["bomb", "centerFly", "upFly"],
				["downFly", "knife", "snow"],
				["bigKey", "earthquake", "coin"],
				*/
				["book", "wand", "fly"],
				["cross", "superPotion", "bomb"],
				["knife", "", "coin"],
				["greenGem", "", "yellowGem"],
				["I333", "", "I334"],
			];
		}
		init() {
			this.toolbarAction = [
				[main.core.openKeyBoard, main.core.openQuickShop, function () { core.insertAction([{ type: "insert", name: "游戏说明" }]); }],
				[main.core.save, main.core.load, main.core.openSettings]
			];
			this.replayAction = [
				[core.triggerReplay, core.stopReplay, core.rewindReplay],
				[core.speedDownReplay, core.speedUpReplay, core.saveReplay]
			];
		}
		update() {
			this._update_background();
			this._update_props();
			this._update_items();
			this._update_equips();
			this._update_keys();
			this._update_infoWindow();
			this._update_infoBar();
		}
		_update_background(updatedFloorTitle) {
			const bgctx = main.dom.outerBackground.getContext("2d");
			const uictx = main.dom.outerUI.getContext("2d");
			if (core.domStyle.isVertical) {
				bgctx.canvas.width = GAMEVIEW_WIDTH_VERTICAL;
				bgctx.canvas.height = GAMEVIEW_HEIGHT_VERTICAL;
				uictx.canvas.width = GAMEVIEW_WIDTH_VERTICAL;
				uictx.canvas.height = GAMEVIEW_HEIGHT_VERTICAL;
				const bg = core.material.images.images["statusBackground_vertical.png"];
				bgctx.drawImage(bg, 0, 0, GAMEVIEW_WIDTH_VERTICAL, GAMEVIEW_HEIGHT_VERTICAL);
				core.setTextAlign('outerUI', 'center');
			} else {
				bgctx.canvas.width = GAMEVIEW_WIDTH;
				bgctx.canvas.height = GAMEVIEW_HEIGHT;
				uictx.canvas.width = GAMEVIEW_WIDTH;
				uictx.canvas.height = GAMEVIEW_HEIGHT;
				const bg = core.material.images.images["statusBackground.jpg"];
				bgctx.drawImage(bg, 0, 0, GAMEVIEW_WIDTH, GAMEVIEW_HEIGHT - INFO_BAR_HEIGHT);
				bgctx.fillStyle = "#676767";
				bgctx.fillRect(0, INFO_BAR_TOP, GAMEVIEW_WIDTH, INFO_BAR_HEIGHT);
				core.setTextAlign('outerUI', 'center');
			}
		}
		// 更新属性
		_update_props(updatedFloorTitle) {
			if (!updatedFloorTitle && core.status.floorId) {
				updatedFloorTitle = core.status.maps[core.status.floorId].title;
			}
			const statusList = ['hp', 'atk', 'def', 'money'];
			const drawStatusList = (baseX, baseY) => {
				let curh = baseY;
				core.setTextAlign('outerUI', 'right');
				statusList.forEach((item) => {
					// 四舍五入
					core.status.hero[item] = Math.round(core.status.hero[item]);
					// 大数据格式化
					let textcolour = TEXT_COLOR;
					if (item === 'money' && core.status.hero.money >= core.getFlag('加属性次数', 0) * 5 + 20) textcolour = '#84C36E';
					core.fillText("outerUI", core.getRealStatus(item), baseX, curh, textcolour);
					curh += 24;
				});
				core.setTextAlign('outerUI', 'center');
			};
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", 10, 0, 105, 120);
				core.setFont("outerUI", 'bold 14px Verdana');
				if (updatedFloorTitle) {
					core.fillText("outerUI", updatedFloorTitle, 54, 22, TEXT_COLOR);
				}
				drawStatusList(96, 46);
			} else {
				core.clearMap("outerUI", 10, 40, 105, 130);
				core.setFont("outerUI", 'bold 16px Verdana');
				if (updatedFloorTitle) {
					core.fillText("outerUI", updatedFloorTitle, 62, 61, TEXT_COLOR);
				}
				drawStatusList(110, 93);
			}
		}
		_update_items() {
			const drawItemMx = (drawFn) => {
				for (let i = 0; i < this.itemMx.length; i++) {
					for (let j = 0; j < this.itemMx[i].length; j++) {
						var item = this.itemMx[i][j];
						drawFn(i, j, item);
					}
				}
			};
			const drawItem = (item, posx, posy) => {
				const icon = core.material.icons.items[item],
					image = core.material.images.items;
				core.drawImage('outerUI', image, 0, 32 * icon, 32, 32, posx, posy, 32, 32);
				const cnt = core.itemCount(item);
				if ((core.items.items[item].cls === "tools" && cnt > 1) || FORCE_COUNTABLE_ITEMS.includes(item)) {
					core.fillText('outerUI', cnt, posx + 25, posy + 28, '#FFFFFF', "bold 12px Verdana");
				}
				// if (this.selectId == item)
				//     core.strokeRect('outerUI', posx + 17, posy - 4, 40, 40, '#FFD700');
				if (item === 'greenGem') core.fillText('outerUI', hero.mdef, posx + 25, posy + 28, '#FFFFFF', "bold 12px Verdana");
				if (item === 'wand') {
					if (core.domStyle.isVertical) {
						if (core.getFlag('special31', 0)) core.fillText('outerUI', '萎', posx + 80, posy + 19, '#FFF442', "bold 14px Verdana");
						if (core.getFlag('special41', 0)) core.fillText('outerUI', '黄', posx + 100, posy + 19, '#CFBA0F', "bold 14px Verdana");
						if (core.getFlag('special42', 0)) core.fillText('outerUI', '脆', posx + 120, posy + 19, '#A0FFF9', "bold 14px Verdana");
						if (core.getFlag('special43', 0)) core.fillText('outerUI', '汞', posx + 140, posy + 19, '#A9A898', "bold 14px Verdana");
					} else {
						if (core.getFlag('special31', 0)) core.fillText('outerUI', '萎', posx + 19, posy + 80, '#FFF442', "bold 14px Verdana");
						if (core.getFlag('special41', 0)) core.fillText('outerUI', '黄', posx + 19, posy + 100, '#CFBA0F', "bold 14px Verdana");
						if (core.getFlag('special42', 0)) core.fillText('outerUI', '脆', posx + 19, posy + 120, '#A0FFF9', "bold 14px Verdana");
						if (core.getFlag('special43', 0)) core.fillText('outerUI', '汞', posx + 19, posy + 140, '#A9A898', "bold 14px Verdana");
					}

				}
			}
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", ITEM_BOX_LEFT_VERTICAL, ITEM_BOX_TOP_VERTICAL, 105, 185);
				drawItemMx((i, j, item) => {
					if (core.hasItem(item) || item === 'greenGem' || item === 'yellowGem') {
						const posx = ITEM_BOX_LEFT_VERTICAL + i * 33,
							posy = ITEM_BOX_TOP_VERTICAL + j * 32;
						drawItem(item, posx, posy);
					}
				});
			} else {
				core.clearMap("outerUI", ITEM_BOX_LEFT, ITEM_BOX_TOP, 105, 185);
				drawItemMx((i, j, item) => {
					if (core.hasItem(item) || item === 'greenGem' || item === 'yellowGem') {
						const posx = ITEM_BOX_LEFT + j * 33,
							posy = ITEM_BOX_TOP + i * 32;
						drawItem(item, posx, posy);
					}
				});
			}
		}
		_update_equips() {
			core.setFont("outerUI", 'bold 16px Verdana');
			const drawEquip = (baseX, baseY, id, color, back) => {
				if (!id) core.fillText("outerUI", back, baseX + 50, baseY + 22, color);
				else {
					core.fillText("outerUI", core.material.items[id].name, baseX + 32, baseY + 22, color);
					var icon = core.material.icons.items[id];
					core.drawImage('outerUI', core.material.images.items, 0, 32 * icon, 32, 32, baseX + 64, baseY, 32, 32);
				}
			};
			const myDrawEquip = (baseX, baseY, id) => {
				if (id) {
					const level = core.getFlag(core.material.items[id].name + '等级', 0);
					const icon = core.material.icons.items[id];
					core.drawImage('outerUI', core.material.images.items, 0, 32 * icon, 32, 32, baseX, baseY, 16, 16);
					if (level >= 1)
						core.fillText('outerUI', level, baseX + 14, baseY + 20, '#FFFFFF', "bold 10px Verdana");
					if (hero.money >= core.getEquipFee(id))
						core.fillCircle('outerUI', baseX + 17, baseY - 2, 2, '#FF3535');
				}
			};
			const swords = ['sword1', 'sword2', 'sword3', 'sword4', 'sword5', 'sword0'];
			const shields = ['shield1', 'shield2', 'shield3', 'shield4', 'shield5', 'shield0'];

			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL, 105, 95);
				swords.forEach(
					(elt, i) => {
						if (core.hasItem(elt)) {
							myDrawEquip(EQUIP_BLOCK_LEFT_VERTICAL + i * 16, EQUIP_BLOCK_TOP_VERTICAL + 15, elt);
						}
					}
				);
				shields.forEach(
					(elt, i) => {
						if (core.hasItem(elt)) {
							myDrawEquip(EQUIP_BLOCK_LEFT_VERTICAL + i * 16, EQUIP_BLOCK_TOP_VERTICAL + 55, elt);
						}
					}
				);
			} else {
				core.clearMap("outerUI", EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP, 105, 95);
				swords.forEach(
					(elt, i) => {
						if (core.hasItem(elt)) {
							myDrawEquip(EQUIP_BLOCK_LEFT + i * 16, EQUIP_BLOCK_TOP + 15, elt);
						}
					}
				);
				shields.forEach(
					(elt, i) => {
						if (core.hasItem(elt)) {
							myDrawEquip(EQUIP_BLOCK_LEFT + i * 16, EQUIP_BLOCK_TOP + 63, elt);
						}
					}
				);
			}

			/*
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL, 105, 95);
				drawEquip(EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL + 9, core.getFlag("nowWeapon"), "#FFCFAE", "无武器");
				drawEquip(EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL + 49, core.getFlag("nowShield"), "#D1CEFF", "无防具");
			} else {
				core.clearMap("outerUI", EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP, 105, 95);
				drawEquip(EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP + 8, core.getFlag("nowWeapon"), "#FFCFAE", "无武器");
				drawEquip(EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP + 56, core.getFlag("nowShield"), "#D1CEFF", "无防具");
			}
			*/
		}
		_update_keys() {
			const drawKeyList = (baseX, baseY, lines, rows) => {
				const todraw = [],
					keyList = ['yellowKey', 'blueKey', 'redKey'];
				let total = 0;
				keyList.forEach(function (key, i) {
					todraw[i] = core.itemCount(key);
					total += todraw[i];
				});
				if (total > lines * rows) {
					let dn = 2;
					for (let i = 0; i <= dn; i++) {
						let deltaX = i * 32,
							deltaY = parseInt((lines - 1) / 2 * 14);
						this.drawKey(keyList[i], baseX + deltaX, baseY + deltaY);
						core.setFont("outerUI", 'bold 14px Verdana');
						core.setTextAlign("outerUI", "left");
						core.fillText("outerUI", todraw[i], baseX + deltaX + 10, baseY + deltaY + 20, TEXT_COLOR);
					}
				} else {
					let dn = 2,
						dc = 0;
					while (dn >= 0 && dc < lines * rows) {
						if (todraw[dn]) {
							this.drawKey(keyList[dn], baseX + (dc % rows) * 14, baseY + parseInt(dc / rows) * 17);
							todraw[dn]--, dc++;
						} else dn--;
					}
				}
			};
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", KEY_BLOCK_LEFT_VERTICAL, KEY_BLOCK_TOP_VERTICAL, 105, 75);
				drawKeyList(KEY_BLOCK_LEFT_VERTICAL + 3, KEY_BLOCK_TOP_VERTICAL + 2, 2, 7);
			} else {
				core.clearMap("outerUI", KEY_BLOCK_LEFT, 140, 105, 75);
				drawKeyList(KEY_BLOCK_LEFT + 3, 142, 3, 7);
			}
		}
		drawKey(key, x, y) {
			let sx = 3,
				sy = 0;
			if (key == "blueKey") sx += 16;
			else if (key == "yellowKey") sy += 16;
			core.drawImage("outerUI", core.statusBar.icons.keys, sx, sy, 10, 16, x, y, 10, 16);
		}
		_update_infoWindow() {
			const itemId = this.selectedItem;
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", INFO_BLOCK_LEFT_VERTICAL, INFO_BLOCK_TOP_VERTICAL, 260, 64);
				if (this.selectedItem) {
					const icon = core.material.icons.items[itemId];
					core.fillText("outerUI", core.material.items[itemId].name, INFO_BLOCK_LEFT_VERTICAL + 32, INFO_BLOCK_TOP_VERTICAL + 35, "#D1CEFF");
					core.drawImage('outerUI', core.material.images.items, 0, 32 * icon, 32, 32, INFO_BLOCK_LEFT_VERTICAL + 64, INFO_BLOCK_TOP_VERTICAL + 15, 32, 32);
					core.ui.drawTextContent("outerUI", core.material.items[itemId].text, {
						left: INFO_BLOCK_LEFT_VERTICAL + 100,
						top: INFO_BLOCK_TOP_VERTICAL + 3,
						maxWidth: 160,
						color: "#D1CEFF"
					});
				}
			} else {
				core.clearMap("outerUI", INFO_BLOCK_LEFT, INFO_BLOCK_TOP, 105, 100);
				if (this.selectedItem) {
					const icon = core.material.icons.items[itemId];
					core.fillText("outerUI", core.material.items[itemId].name, INFO_BLOCK_LEFT + 32, INFO_BLOCK_TOP + 25, "#D1CEFF");
					core.drawImage('outerUI', core.material.images.items, 0, 32 * icon, 32, 32, INFO_BLOCK_LEFT + 64, INFO_BLOCK_TOP + 4, 32, 32);
					core.ui.drawTextContent("outerUI", core.material.items[itemId].text, {
						left: INFO_BLOCK_LEFT + 1,
						top: INFO_BLOCK_TOP + 36,
						maxWidth: 105,
						color: "#D1CEFF"
					});
				}
			}
		}
		showItemInfo(itemId) {
			this.selectedItem = itemId;
			this._update_infoWindow();
		}
		clearItemInfo() {
			this.selectedItem = null;
			this._update_infoWindow();
		}
		_update_toolBox() {
			const tools = core.isReplaying() ? [
				[core.status.replay.pausing ? "play" : "pause", "stop", "rewind"],
				["speedDown", "speedUp", "save"],
			] : [
				["keyboard", "shop", "help"],
				["save", "load", "settings"],
			];
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", TOOL_BOX_LEFT_VERTICAL, TOOL_BOX_TOP_VERTICAL, 115, 80);
				for (let i = 0; i < tools.length; i++) {
					for (let j = 0; j < tools[i].length; j++) {
						core.drawIcon("outerUI", tools[i][j], TOOL_BOX_LEFT_VERTICAL + j * 34, TOOL_BOX_TOP_VERTICAL + i * 34, 32, 32);
					}
				}
			} else {
				core.clearMap("outerUI", TOOL_BOX_LEFT, TOOL_BOX_TOP, 115, 80);
				for (let i = 0; i < tools.length; i++) {
					for (let j = 0; j < tools[i].length; j++) {
						core.drawIcon("outerUI", tools[i][j], TOOL_BOX_LEFT + j * 34, TOOL_BOX_TOP + i * 34, 32, 32);
					}
				}
			}
		}
		onclick(x, y) {
			const makeBox = ([x, y], [w, h]) => {
				return [
					[x, y],
					[x + w, y + h]
				];
			}
			const gridify = ([x, y], [gw, gh]) => {
				return [parseInt(x / gw), parseInt(y / gh)];
			}
			const useItem = (itemId) => {
				if (itemId === 'yellowGem' || itemId === 'greenGem') this.showItemInfo(itemId);
				if (!core.hasItem(itemId)) return;
				if (core.material.items[itemId].cls == "constants") {
					switch (itemId) {
					case "book":
						core.openBook(true);
						break;
					case "fly":
						core.useFly(true);
						break;
					case "wand":
						core.insertAction({
							type: "useItem",
							id: itemId
						});
						break;
					case "snow":
						core.useItem("snow");
						break;
					case "I331":
						core.useItem("I331");
						break;
					case "I332":
						core.useItem("I332");
						break;
					case "I333":
						core.doSL("autoSave", "load");
						break;
					case "I334":
						core.doSL("autoSave", "reload");
						break;
					default:
						this.showItemInfo(itemId);
					}
				} else if (itemId != this.selectedItem) {
					this.showItemInfo(itemId);
				} else {
					switch (itemId) {
					case "centerFly":
						core.ui._drawCenterFly();
						break;
					default:
						core.useItem(itemId);
					}
				}
			}
			const inRect = ([x, y], [
				[sx, sy],
				[dx, dy]
			]) => {
				return sx <= x && x <= dx && sy <= y && y <= dy;
			};
			const relativeTo = ([x, y], [ax, ay]) => {
				return [x - ax, y - ay];
			}
			const pos = [x, y];
			if (core.domStyle.isVertical) {
				const itemBox = makeBox([ITEM_BOX_LEFT_VERTICAL, ITEM_BOX_TOP_VERTICAL], [32 * 5, 33 * 3]);
				if (inRect(pos, itemBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					const [gx, gy] = gridify(relativeTo(pos, itemBox[0]), [32, 33]);
					const itemId = this.itemMx[gx][gy];
					useItem(itemId);
					return;
				}
				const toolBox = makeBox([TOOL_BOX_LEFT_VERTICAL, TOOL_BOX_TOP_VERTICAL], [34 * 3, 34 * 2]);
				if (inRect(pos, toolBox)) {
					const [row, col] = gridify(relativeTo(pos, toolBox[0]), [34, 34]);
					if (core.isReplaying()) {
						this.replayAction[col][row].call(core);
					} else if (core.isPlaying()) {
						this.toolbarAction[col][row].call(core, true);
					}
					return;
				}
				const swordBox = makeBox([EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL], [105, 48]);
				if (inRect(pos, swordBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					//useItem('I331');
					core.openShop('swordLevel');
					return;
				}
				const shieldBox = makeBox([EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL + 48], [105, 47]);
				if (inRect(pos, shieldBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					//useItem('I332');
					core.openShop('shieldLevel');
					return;
				}
				const coinBox = makeBox([KEY_BLOCK_LEFT_VERTICAL - 102, EQUIP_BLOCK_TOP_VERTICAL + 30], [99, 85])
				if (inRect(pos, coinBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					core.openShop('atkdef');
					return;
				}
				const keyBox = makeBox([KEY_BLOCK_LEFT_VERTICAL, KEY_BLOCK_TOP_VERTICAL], [34 * 3, 32]);
				if (inRect(pos, keyBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					core.openShop('keyShop');
					return;
				}

			} else {
				const itemBox = makeBox([ITEM_BOX_LEFT, ITEM_BOX_TOP], [33 * 3, 32 * 5]);
				if (inRect(pos, itemBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					const [gx, gy] = gridify(relativeTo(pos, itemBox[0]), [33, 32]);
					const itemId = this.itemMx[gy][gx];
					useItem(itemId);
					return;
				}
				const toolBox = makeBox([TOOL_BOX_LEFT, TOOL_BOX_TOP], [34 * 3, 34 * 2]);
				if (inRect(pos, toolBox)) {
					const [row, col] = gridify(relativeTo(pos, toolBox[0]), [34, 34]);
					if (core.isReplaying()) {
						this.replayAction[col][row].call(core);
					} else if (core.isPlaying()) {
						this.toolbarAction[col][row].call(core, true);
					}
					return;
				}
				const swordBox = makeBox([EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP], [105, 48]);
				if (inRect(pos, swordBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					//useItem('I331');
					core.openShop('swordLevel');
					return;
				}
				const shieldBox = makeBox([EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP + 48], [105, 47]);
				if (inRect(pos, shieldBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					//useItem('I332');
					core.openShop('shieldLevel');
					return;
				}
				const coinBox = makeBox([ITEM_BOX_LEFT, ITEM_BOX_TOP - 115], [33 * 3, 94]);
				if (inRect(pos, coinBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					core.openShop('atkdef');
					return;
				}
				const keyBox = makeBox([TOOL_BOX_LEFT, INFO_BLOCK_TOP - 79], [34 * 3, 34 * 2]);
				if (inRect(pos, keyBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					core.openShop('keyShop');
					return;
				}
			}
		}
		infoText;
		infocnt = 0;
		_update_infoBar() {
			core.setTextAlign('outerUI', 'left');
			const text = this.infoText;
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", 0, INFO_BAR_TOP_VERTICAL, GAMEVIEW_WIDTH, INFO_BAR_HEIGHT_VERTICAL);
				core.setFont("outerUI", 'bold 14px Verdana');
				if (text) {
					core.fillText("outerUI", text, 10, INFO_BAR_TOP_VERTICAL + 14, TEXT_COLOR);
				}
			} else {
				core.clearMap("outerUI", 0, INFO_BAR_TOP, GAMEVIEW_WIDTH, INFO_BAR_HEIGHT);
				core.setFont("outerUI", 'bold 16px Verdana');
				if (text) {
					core.fillText("outerUI", text, 10, INFO_BAR_TOP + 16, TEXT_COLOR);
				}
			}
			core.setTextAlign('outerUI', 'center');
		}
		print(text, cnt = 1) {
			this.infoText = text;
			this.infocnt = cnt;
			this._update_infoBar();
		}
		static infoRules = [
			{ id: "lava", text: "岩浆好热啊!" },
			{ id: "upFloor", text: "你看到了楼梯" },
			{ id: "downFloor", text: "你看到了楼梯" },
			{ id: "blueShop", text: "你看到了一个祭坛" },
			{ id: "man", text: "你看到了一个老人" },
			{ id: "woman", text: "你看到了一个商人" },
			{ id: "fairy", text: "你看到了一个商人" },
			{ id: "thief", text: "你看到了一个小偷" },
		]
		printEnvironmentInfo() {
			if (!this.infocnt) {
				return;
			}
			const ids = [];
			for (const block of core.status.thisMap.blocks) {
				if (!block.disable && core.nearHero(block.x, block.y)) ids.push(block.event.id);
			}
			for (const infoRule of StatusBar.infoRules) {
				if (ids.indexOf(infoRule.id) >= 0) {
					this.print(infoRule.text);
					return;
				}
			}
		}
		clearInfo(etype) {
			this.clearItemInfo();
			if (this.infocnt == 1) {
				setTimeout(() => {
					if (this.infocnt === 0) {
						this.infoText = void 0;
						this._update_infoBar();
					}
				}, 200);
				this.infocnt = 0;
			} else if (this.infocnt > 1) {
				this.infocnt--;
			}
		}
	}

	core.ui.statusBar = new StatusBar();

	core.control.clearStatusBar = function () {
		core.clearMap("outerUI");
	}
	// init() called in `afterLoadResources`.
},
    "override": function () {

	core.statusBar.icons = {
		'floor': 0,
		'name': null,
		'lv': 1,
		'hpmax': 2,
		'hp': 3,
		'atk': 4,
		'def': 5,
		'mdef': 6,
		'money': 7,
		'experience': 8,
		'up': 9,
		'book': 10,
		'fly': 11,
		'toolbox': 12,
		'keyboard': 13,
		'shop': 14,
		'save': 15,
		'load': 16,
		'settings': 17,
		'play': 18,
		'pause': 19,
		'stop': 20,
		'speedDown': 21,
		'speedUp': 22,
		'rewind': 23,
		'equipbox': 24,
		'mana': 25,
		'skill': 26,
		'paint': 27,
		'erase': 28,
		'empty': 29,
		'exit': 30,
		'btn1': 31,
		'btn2': 32,
		'btn3': 33,
		'btn4': 34,
		'btn5': 35,
		'btn6': 36,
		'btn7': 37,
		'btn8': 38,
		'keys': 39,
		'help': 40,
		'battle': 41
	};

	core.actions._clickCenterFly = function (x, y) {
		var posX = core.status.event.data.posX,
			posY = core.status.event.data.posY;
		core.ui.closePanel();
		if (x == posX && y == posY) {
			if (core.canUseItem('centerFly')) {
				core.useItem('centerFly');
			} else {
				core.drawTip('当前不能使用中心对称飞行器');
			}
		} else core.drawTip('取消使用');
	}

	var _clickSL = core.actions._clickSL;
	core.actions._clickSL = function (x, y) {
		var page = core.status.event.data.page,
			offset = core.status.event.data.offset;
		var index = page * 10 + offset;

		// 上一页
		if ((x == this.HSIZE - 1 || x == this.HSIZE - 2) && y == this.LAST) {
			core.ui._drawSLPanel(10 * (page - 1) + offset);
			return;
		}
		// 下一页
		if ((x == this.HSIZE + 1 || x == this.HSIZE + 2) && y == this.LAST) {
			core.ui._drawSLPanel(10 * (page + 1) + offset);
			return;
		}
		if ((x == this.HSIZE - 3 || x == this.HSIZE + 3) && y == this.LAST) {
			return;
		}
		_clickSL.call(this, x, y);
	}

	var _sys_longClick_lockControl = core.actions._sys_longClick_lockControl;
	core.actions._sys_longClick_lockControl = function (x, y) {
		if (!core.status.lockControl) return false;

		// 长按SL上下页快速翻页
		if (["save", "load", "replayLoad", "replayRemain"].indexOf(core.status.event.id) >= 0) {
			if (y == this.LAST && x <= this.HSIZE + 3 && x >= this.HSIZE - 3) {
				core.actions._clickSL(x, y);
				return true;
			}
		}
		return _sys_longClick_lockControl.call(this, x, y);
	}
	core.registerAction('longClick', '_sys_longClick_lockControl', core.actions._sys_longClick_lockControl, 50);

	core.control._moveHero_moving = function () {
		core.status.heroStop = false;
		core.status.automaticRoute.moveDirectly = false;
		var move = function () {
			if (!core.status.heroStop) {
				if (core.hasFlag('debug') && core.status.ctrlDown) {
					if (core.status.heroMoving != 0) return;
					// 检测是否穿出去
					var nx = core.nextX(),
						ny = core.nextY();
					if (nx < 1 || nx >= core.bigmap.width - 1 || ny < 1 || ny >= core.bigmap.height - 1) return;
					core.eventMoveHero([core.getHeroLoc('direction')], core.values.moveSpeed, move);
				} else {
					core.moveAction();
					setTimeout(move, 50);
				}
			}
		}
		move();
	}

	core.control._drawHero_updateViewport = function (x, y, offset) {}

	var _drawThumbnail_drawTempCanvas = core.maps._drawThumbnail_drawTempCanvas;
	core.maps._drawThumbnail_drawTempCanvas = function (floorId, blocks, options) {
		if (main.mode == 'editor') {
			_drawThumbnail_drawTempCanvas.call(this, floorId, blocks, options);
			return;
		}

		var width = core.floors[floorId].width;
		var height = core.floors[floorId].height;
		// 绘制到tempCanvas上面
		var tempCanvas = core.bigmap.tempCanvas;
		options.v2 = false;
		tempCanvas.canvas.width = width * 32;
		tempCanvas.canvas.height = height * 32;
		options.ctx = tempCanvas;

		var hasHero = core.status.hero != null,
			flags = null;
		if (options.flags) {
			if (!hasHero) core.status.hero = {};
			flags = core.status.hero.flags;
			core.status.hero.flags = options.flags;
		}
		this._drawThumbnail_realDrawTempCanvas(floorId, blocks, options);

		if (!hasHero) delete core.status.hero;
		else if (flags != null) core.status.hero.flags = flags;
		tempCanvas.setTransform(1, 0, 0, 1, 0, 0);
	}

	var _drawThumbnail_drawToTarget = core.maps._drawThumbnail_drawToTarget;
	core.maps._drawThumbnail_drawToTarget = function (floorId, options) {
		if (main.mode == 'editor') {
			_drawThumbnail_drawToTarget.call(this, floorId, options);
			return;
		}

		var ctx = core.getContextByName(options.ctx);
		if (ctx == null) return;
		var x = options.x || 0,
			y = options.y || 0,
			size = options.size || core.__PIXELS__;
		var tempCanvas = core.bigmap.tempCanvas;
		core.drawImage(ctx, tempCanvas.canvas, 32, 32, core.__PIXELS__, core.__PIXELS__, x, y, size, size);
	}

	var _drawWindowSkin = core.ui.drawWindowSkin;
	core.ui.drawWindowSkin = function (background, ctx, x, y, w, h, direction, px, py) {
		_drawWindowSkin.call(this, background, ctx, x, y, w, h, direction, px, py);

		var c = parseInt(w / 2);
		core.drawImage(ctx, background, 160, 90, 16, 6, x + c - 8, y, 16, 6);
	}

	var _drawPagination = ui.prototype.drawPagination;
	core.ui.drawPagination = function (page, totalPage, y) {
		if (["save", "load", "replayLoad", "replayRemain", "replaySince"].indexOf(core.status.event.id) >= 0) {
			if (totalPage <= 1) return;
			if (y == null) y = this.LAST;

			core.setFillStyle('ui', '#DDDDDD');
			var length = core.calWidth('ui', page, this._buildFont(15, true));

			core.setTextAlign('ui', 'left');
			core.fillText('ui', page, parseInt((this.PIXEL - length) / 2), y * 32 + 19);

			core.setTextAlign('ui', 'center');
			if (page > 1)
				core.fillText('ui', '上一页', this.HPIXEL - 48, y * 32 + 19);
			if (page < totalPage)
				core.fillText('ui', '下一页', this.HPIXEL + 48, y * 32 + 19);
			return;
		}
		_drawPagination.call(this, page, totalPage, y);
	}

	core.ui._drawCenterFly = function () {
		core.lockControl();
		core.status.event.id = 'centerFly';
		var fillstyle = 'rgba(255,0,0,0.5)';
		if (core.canUseItem('centerFly')) fillstyle = 'rgba(0,255,0,0.5)';
		var toX = core.bigmap.width - 1 - core.getHeroLoc('x'),
			toY = core.bigmap.height - 1 - core.getHeroLoc('y');
		this.clearUI();
		core.fillRect('ui', 0, 0, this.PIXEL, this.PIXEL, '#000000');
		core.drawThumbnail(null, null, { heroLoc: core.status.hero.loc, heroIcon: core.status.hero.image, ctx: 'ui', centerX: toX, centerY: toY });
		var offsetX = 1,
			offsetY = 1;
		core.fillRect('ui', (toX - offsetX) * 32, (toY - offsetY) * 32, 32, 32, fillstyle);
		core.status.event.data = { "x": toX, "y": toY, "posX": toX - offsetX, "posY": toY - offsetY };
		core.playSound('打开界面');
		core.drawTip("请确认当前" + core.material.items['centerFly'].name + "的位置", 'centerFly');
		return;
	}

	core.ui.drawHelp = function () {
		core.clearUI();
		core.status.event.id = 'help';
		core.lockControl();
		core.setAlpha('ui', 1);
		core.fillRect('ui', 0, 0, this.PIXEL, this.PIXEL, '#FFFFFF');
		core.drawImage('ui', core.material.images.keyboard, 0, 0, 416, 416, 0, 0, 352, 352);
	}

	core.actions._getClickLoc = function (x, y) {
		var size = 32 * core.domStyle.scale;
		var left = main.dom.gameDraw.offsetLeft + main.dom.gameGroup.offsetLeft;
		var top = main.dom.gameDraw.offsetTop + main.dom.gameGroup.offsetTop;
		var loc = { 'x': Math.max(x - left, 0), 'y': Math.max(y - top, 0), 'size': size };
		return loc;
	}

	core.enemys.getDamageString = function (enemy, x, y, floorId) {
		if (typeof enemy == 'string') enemy = core.material.enemys[enemy];
		var damage = this.getDamage(enemy, x, y, floorId);

		var color = '#000000';

		if (damage == null) {
			damage = "???";
			color = '#FF2222';
		} else {
			if (core.hasFlag('addhp')) {
				if (damage < core.status.hero.hp) color = '#11FF11';
				else color = '#FF2222';
			} else if (damage <= 0) color = '#11FF11';
			else if (damage < core.status.hero.hp / 3) color = '#FFFFFF';
			else if (damage < core.status.hero.hp * 2 / 3) color = '#FFFF00';
			else if (damage < core.status.hero.hp) color = '#FF9933';
			else color = '#FF2222';

			damage = core.formatBigNumber(damage, true);
			if (core.enemys.hasSpecial(enemy, 19))
				damage += "+";
			if (core.enemys.hasSpecial(enemy, 21))
				damage += "-";
			if (core.enemys.hasSpecial(enemy, 11))
				damage += "^";
		}

		return {
			"damage": damage,
			"color": color
		};
	}

	core.ui._drawBook_drawDamage = function (index, enemy, offset, position) {
		core.setTextAlign('ui', 'center');
		var damage = enemy.damage,
			color = '#FFFF00';
		if (damage == null) {
			damage = '不可攻击';
			color = '#FF2222';
		}
		if (damage == 0) {
			damage = '无危险';
			color = '#11FF11';
		} else {
			if (damage >= core.status.hero.hp) color = '#FF2222';
			else if (damage >= core.status.hero.hp * 2 / 3) color = '#FF9933';
			else if (damage <= 0) color = '#11FF11';
			damage = core.formatBigNumber(damage);
			if (core.enemys.hasSpecial(enemy, 19)) damage += "+";
			if (core.enemys.hasSpecial(enemy, 21)) damage += "-";
			if (core.enemys.hasSpecial(enemy, 11)) damage += "^";
		}
		if (enemy.notBomb) damage += "[b]";
		core.fillText('ui', damage, offset, position, color, this._buildFont(13, true));
	}

	core.control.checkBlock = function () {
		var x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y'),
			loc = x + "," + y;
		var damage = core.status.checkBlock.damage[loc];
		if (damage) {
			core.status.hero.hp -= damage;
			core.drawTip("你没有神圣盾不能防御，受到 " + damage + " 点魔法伤害");
			core.playSound('zone.mp3');
			this._checkBlock_disableQuickShop();
			core.status.hero.statistics.extraDamage += damage;
			if (core.status.hero.hp <= 0) {
				core.status.hero.hp = 0;
				core.updateStatusBar();
				core.events.lose();
				return;
			} else {
				core.updateStatusBar();
			}
		}
		this._checkBlock_ambush(core.status.checkBlock.ambush[loc]);
		this._checkBlock_repulse(core.status.checkBlock.repulse[loc]);
	}

	core.registerSystemEvent("man", function (data, callback) {
		var a = parseInt(core.status.floorId.substring(2));
		var b = core.nextX();
		var c = core.nextY();
		core.insertAction([
			{ "type": "insert", "name": "对话", "args": [a, b, c, 0] },
		]);
		//console.log(data);
		if (callback) callback();
	});

	core.registerSystemEvent("woman", function (data, callback) {
		var name = core.status.floorId + '@' + core.nextX() + '@' + core.nextY() + '@' + 'A';
		if (core.getFlag(name, 0) == 1) {
			var a = parseInt(core.status.floorId.substring(2));
			var b = core.nextX();
			var c = core.nextY();
			core.insertAction([
				{ "type": "insert", "name": "对话", "args": [a, b, c, 1] },
			]);
		} else {
			core.insertAction([
				{ "type": "insert", "name": "商人", "args": [0] },
			]);
		}
		//console.log(data);
		if (callback) callback();
	});

	core.registerSystemEvent("specialwall", function (data, callback) {
		if (data.event.id == 'whiteWall' || core.getFlag('talking') > 0) {
			core.insertAction({ 'type': 'openDoor', loc: [data.x, data.y] });
			if (data.event.id != 'whiteWall') {
				core.setFlag('end', 1);
			}
			core.setFlag('talking', 0); //穿墙之后不能再次穿墙
		}
		//console.log(data);
		if (callback) callback();
	});

	core.registerSystemEvent("fakeWall", function (data, callback) {
		if (data.event.id == 'blueWall') {
			core.insertAction([
				{ "type": "openDoor", loc: [data.x, data.y] },
			]);
		}
		//console.log(data);
		if (callback) callback();
	});

	core.ui._drawWindowSelector = function (background, x, y, w, h) {
		w = Math.round(w) + 48;
		h = Math.round(h);
		var ctx = core.ui.createCanvas("_selector", x - 24, y, w, h, 165);
		ctx.canvas.id = '';
		this._drawSelector(ctx, background, w, h);
	}

	core.ui._drawSelector = function (ctx, background, w, h, left, top) {
		left = left || 0;
		top = top || 0;
		ctx = this.getContextByName(ctx);
		if (!ctx) return;
		if (typeof background == 'string')
			background = core.material.images.images[background];
		if (!(background instanceof Image)) return;
		// badge
		ctx.drawImage(background, 132, 68, 24, 24, left + 4, top + 4, 24, 24);
		ctx.drawImage(background, 132, 68, 24, 24, w - left - 28, top + 4, 24, 24);
	}

	core.ui.drawTip = function (text, id, clear) {
		core.ui.statusBar.print(text);
	}

	core.ui.clearMap = function (name, x, y, width, height) {
		if (name == 'all') {
			for (var m in core.canvas) {
				core.canvas[m].clearRect(0, 0, core.bigmap.width * 32, core.bigmap.height * 32);
			}
			core.clearMap("outerUI");
			core.dom.gif.innerHTML = "";
			core.removeGlobalAnimate();
		} else {
			var ctx = this.getContextByName(name);
			if (ctx) ctx.clearRect(x || 0, y || 0, width || ctx.canvas.width, height || ctx.canvas.height);
		}
	}

	core.control._updateStatusBar_setToolboxIcon = function () {
		core.ui.statusBar._update_toolBox();
	}

	var _changeFloor_getInfo = core.events._changeFloor_getInfo;
	core.events._changeFloor_getInfo = function (floorId, stair, heroLoc, time) {
		var info = _changeFloor_getInfo.call(this, floorId, stair, heroLoc, time);
		if (info == null) return null;
		info.time = 0;
		info.origin = floorId;
		return info;
	}

	core.events._changeFloor_afterChange = function (info, callback) {
		if (!info.locked) core.unlockControl();
		core.status.replay.animate = false;
		core.events.afterChangeFloor(info.floorId);

		if (info.origin == ':before') core.ui.statusBar.print('走下了楼梯')
		else if (info.origin == ':next') core.ui.statusBar.print('登上了楼梯')
		if (callback) callback();
	}

	if (window.jsinterface && window.jsinterface.requestLandscape) {
		window.jsinterface.requestLandscape();
	}

	maps.prototype._canMoveDirectly_checkStartPoint = function (sx, sy) {
		if (core.status.checkBlock.damage[sx + "," + sy]) return false;
		var block = core.getBlock(sx, sy);
		if (block != null) {
			// 只有起点是传送点才是能无视
			return (block.event.trigger == 'changeFloor' || ['upFloor', 'downFloor', 'portal'].includes(block.event.id));
		}
		return true;
	}

	/// 未破防临界采用二分计算
	enemys.prototype._nextCriticals_overAtk = function (enemy, x, y, floorId) {
		var calNext = function (currAtk, maxAtk) {
			var start = currAtk,
				end = maxAtk;
			if (start > end) return null;

			while (start < end) {
				var mid = Math.floor((start + end) / 2);
				if (mid - start > end - mid) mid--;
				var nextInfo = core.enemys.getDamageInfo(enemy, { "atk": mid }, x, y, floorId);
				if (nextInfo != null) end = mid;
				else start = mid + 1;
			}
			var nextInfo = core.enemys.getDamageInfo(enemy, { "atk": start }, x, y, floorId);
			return nextInfo == null ? null : [start - core.status.hero.atk, nextInfo];
		}
		return calNext(core.status.hero.atk + 1,
			1000 * core.getEnemyValue(enemy, 'hp', x, y, floorId) + 1000 * core.getEnemyValue(enemy, 'def', x, y, floorId));
	}
},
    "shop": function () {
	// 【全局商店】相关的功能
	// 
	// 打开一个全局商店
	// shopId：要打开的商店id；noRoute：是否不计入录像
	this.openShop = function (shopId, noRoute) {
		var shop = core.status.shops[shopId];
		// Step 1: 检查能否打开此商店
		if (!this.canOpenShop(shopId)) {
			core.drawTip("该商店尚未开启");
			return false;
		}

		// Step 2: （如有必要）记录打开商店的脚本事件
		if (!noRoute) {
			core.status.route.push("shop:" + shopId);
		}

		// Step 3: 检查道具商店 or 公共事件
		if (shop.item) {
			if (core.openItemShop) {
				core.openItemShop(shopId);
			} else {
				core.playSound('操作失败');
				core.insertAction("道具商店插件不存在！请检查是否存在该插件！");
			}
			return;
		}
		if (shop.commonEvent) {
			core.insertCommonEvent(shop.commonEvent, shop.args);
			return;
		}

		_shouldProcessKeyUp = true;

		// Step 4: 执行标准公共商店    
		core.insertAction(this._convertShop(shop));
		return true;
	}

	////// 将一个全局商店转变成可预览的公共事件 //////
	this._convertShop = function (shop) {
		return [
			{ "type": "function", "function": "function() {core.addFlag('@temp@shop', 1);}" },
			{
				"type": "while",
				"condition": "true",
				"data": [
					// 检测能否访问该商店
					{
						"type": "if",
						"condition": "core.isShopVisited('" + shop.id + "')",
						"true": [
							// 可以访问，直接插入执行效果
							{ "type": "function", "function": "function() { core.plugin._convertShop_replaceChoices('" + shop.id + "', false) }" },
						],
						"false": [
							// 不能访问的情况下：检测能否预览
							{
								"type": "if",
								"condition": shop.disablePreview,
								"true": [
									// 不可预览，提示并退出
									{ "type": "playSound", "name": "操作失败" },
									"当前无法访问该商店！",
									{ "type": "break" },
								],
								"false": [
									// 可以预览：将商店全部内容进行替换
									{ "type": "tip", "text": "当前处于预览模式，不可购买" },
									{ "type": "function", "function": "function() { core.plugin._convertShop_replaceChoices('" + shop.id + "', true) }" },
								]
							}
						]
					}
				]
			},
			{ "type": "function", "function": "function() {core.addFlag('@temp@shop', -1);}" }
		];
	}

	this._convertShop_replaceChoices = function (shopId, previewMode) {
		var shop = core.status.shops[shopId];
		var choices = (shop.choices || []).filter(function (choice) {
			if (choice.condition == null || choice.condition == '') return true;
			try { return core.calValue(choice.condition); } catch (e) { return true; }
		}).map(function (choice) {
			var ableToBuy = core.calValue(choice.need);
			return {
				"text": choice.text,
				"icon": choice.icon,
				"color": ableToBuy && !previewMode ? choice.color : [153, 153, 153, 1],
				"action": ableToBuy && !previewMode ? [{ "type": "playSound", "name": "商店" }].concat(choice.action) : [
					{ "type": "playSound", "name": "操作失败" },
					{ "type": "tip", "text": previewMode ? "预览模式下不可购买" : "购买条件不足" }
				]
			};
		}).concat({ "text": "离开", "action": [{ "type": "playSound", "name": "取消" }, { "type": "break" }] });
		core.insertAction({ "type": "choices", "text": shop.text, "choices": choices });
	}

	/// 是否访问过某个快捷商店
	this.isShopVisited = function (id) {
		if (!core.hasFlag("__shops__")) core.setFlag("__shops__", {});
		var shops = core.getFlag("__shops__");
		if (!shops[id]) shops[id] = {};
		return shops[id].visited;
	}

	/// 当前应当显示的快捷商店列表
	this.listShopIds = function () {
		return Object.keys(core.status.shops).filter(function (id) {
			return core.isShopVisited(id) || !core.status.shops[id].mustEnable;
		});
	}

	/// 是否能够打开某个商店
	this.canOpenShop = function (id) {
		if (this.isShopVisited(id)) return true;
		var shop = core.status.shops[id];
		if (shop.item || shop.commonEvent || shop.mustEnable) return false;
		return true;
	}

	/// 启用或禁用某个快捷商店
	this.setShopVisited = function (id, visited) {
		if (!core.hasFlag("__shops__")) core.setFlag("__shops__", {});
		var shops = core.getFlag("__shops__");
		if (!shops[id]) shops[id] = {};
		if (visited) shops[id].visited = true;
		else delete shops[id].visited;
	}

	/// 能否使用快捷商店
	this.canUseQuickShop = function (id) {
		// 如果返回一个字符串，表示不能，字符串为不能使用的提示
		// 返回null代表可以使用

		// 检查当前楼层的canUseQuickShop选项是否为false
		if (core.status.thisMap.canUseQuickShop === false)
			return '当前楼层不能使用快捷商店。';
		return null;
	}

	var _shouldProcessKeyUp = true;

	/// 允许商店X键退出
	core.registerAction('keyUp', 'shops', function (keycode) {
		if (!core.status.lockControl || core.status.event.id != 'action') return false;
		if ((keycode == 13 || keycode == 32) && !_shouldProcessKeyUp) {
			_shouldProcessKeyUp = true;
			return true;
		}

		if (!core.hasFlag("@temp@shop") || core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (keycode == 88 || keycode == 27) { // X, ESC
			core.actions._clickAction(core.actions.HSIZE, topIndex + choices.length - 1);
			return true;
		}
		return false;
	}, 60);

	/// 允许长按空格或回车连续执行操作
	core.registerAction('keyDown', 'shops', function (keycode) {
		if (!core.status.lockControl || !core.hasFlag("@temp@shop") || core.status.event.id != 'action') return false;
		if (core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (keycode == 13 || keycode == 32) { // Space, Enter
			core.actions._clickAction(core.actions.HSIZE, topIndex + core.status.event.selection);
			_shouldProcessKeyUp = false;
			return true;
		}
		return false;
	}, 60);

	// 允许长按屏幕连续执行操作
	core.registerAction('longClick', 'shops', function (x, y, px, py) {
		if (!core.status.lockControl || !core.hasFlag("@temp@shop") || core.status.event.id != 'action') return false;
		if (core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (x >= core.actions.CHOICES_LEFT && x <= core.actions.CHOICES_RIGHT && y >= topIndex && y < topIndex + choices.length) {
			core.actions._clickAction(x, y);
			return true;
		}
		return false;
	}, 60);
},
    "16层": function () {
	// 在此增加新插件

	function getFloorNumber(floorId) {
		return parseInt(floorId.substr(2));
	}

	this.yellowGem = function (x) {
		if (x <= 100) return 5 * x;
		else {
			const sx = Math.sqrt(x);
			return Math.round(150 * sx / (2 + sx / 10));
		}
	}

	function getRegion(num) {
		if (num > 0 && num <= 10) return 1;
		if (num > 10 && num <= 20) return 2;
		if (num > 20 && num <= 30) return 3;
		if (num > 30 && num <= 40) return 4;
		if (num > 40 && num <= 50) return 5;
	}

	this.getEquipFee = function (id) {
		const ratios = [3, 1, 1.5, 2, 2.5, 3];
		const ratio = ratios[parseInt(id[id.length - 1])];
		const name = core.material.items[id].name;
		const level = core.getFlag(name + '等级', 0) + 1;
		if (level === 6) return Number.MAX_SAFE_INTEGER;
		return ((flags.天赋 === '圣锻造师') ? 0 : Math.round(level * 50 * ratio));
	}

	function shuffleArray(array) {
		const shuffled = [...array]; // 创建副本，避免修改原数组
		for (let i = shuffled.length - 1; i > 0; i--) {
			const j = core.rand(i + 1); // 随机选取 0~i 的索引
			[shuffled[i], shuffled[j]] = [shuffled[j], shuffled[i]]; // 交换元素
		}
		return shuffled;
	}

	const doorLocIn = [
		[6, 4],
		[8, 6],
		[6, 8],
		[4, 6]
	];

	const doorLocOut = [
		[4, 2],
		[8, 2],
		[10, 4],
		[10, 8],
		[8, 10],
		[4, 10],
		[2, 8],
		[2, 4]
	];

	class Room {
		constructor(centre, stair) {
			this.centre = centre;
			if (stair) this.stair = stair;
		}

		get lefttop() {
			const [x, y] = this.centre;
			return [x - 1, y - 1];
		}

		getDoorLoc() { //这个方法只返回应该是这个房间的门的位置的格子的坐标，不判断是否是门
			const [x, y] = this.centre;
			const locs = [
				[x - 2, y],
				[x + 2, y],
				[x, y - 2],
				[x, y + 2]
			];
			return locs.filter(([nx, ny]) => {
				return nx >= 1 && nx <= 11 && ny >= 1 && ny <= 11;
			});
		}

		getDoorLocIn() { //这个方法只返回应该是这个房间的内圈门的位置的格子的坐标，不判断是否是门
			const doorLoc = this.getDoorLoc();
			return doorLoc.filter((loc) => {
				return doorLocIn.some(([nx, ny]) => { return loc[0] === nx && loc[1] === ny; });
			});
		}
		getDoorLocOut() { //这个方法只返回应该是这个房间的外圈门的位置的格子的坐标，不判断是否是门
			const doorLoc = this.getDoorLoc();
			return doorLoc.filter((loc) => {
				return doorLocOut.some(([nx, ny]) => { return loc[0] === nx && loc[1] === ny; });
			});
		}

		wholeRoom() { //这个方法返回一个数组，每个元素是这个房间的格子的坐标
			const whole = [];
			for (let dx = -1; dx <= 1; dx++) {
				for (let dy = -1; dy <= 1; dy++) {
					whole.push([this.centre[0] + dx, this.centre[1] + dy]);
				}
			}
			return whole;
		}

		getBlockLoc(id) { //这个方法返回这个房间里某图块的所有位置
			const locs = [];
			const whole = this.wholeRoom();
			whole.forEach(
				function ([x, y]) {
					if (core.getBlockId(x, y) === id) locs.push([x, y]);
				}
			);
			return locs;
		}

		hasBlock(id) { //这个方法返回这个房间里是否含有某图块
			return this.getBlockLoc(id).length > 0;
		}

		setContent(content) { //这个方法针对这个房间的T330进行填空，content是一个二维数组
			const T330s = this.getBlockLoc('T330');
			const [cx, cy] = this.centre;
			T330s.forEach(
				function ([x, y]) {
					const id = content[x - cx + 1][y - cy + 1];
					if (id === '空地') core.removeBlock(x, y);
					else core.setBlock(id, x, y);
				}
			)
		}

		setOneBlock(id) { //这个方法随机找一个T330转变为id的图块
			const T330s = this.getBlockLoc('T330');
			const r = core.rand(T330s.length);
			const [x, y] = T330s[r];
			core.setBlock(id, x, y);
		}

		setCentre(id) { //这个方法将id的图块设置在房间中心
			core.setBlock(id, this.centre[0], this.centre[1]);
		}
	}

	const rooms = [
		new Room([2, 2]),
		new Room([6, 2], [6, 1]),
		new Room([10, 2]),
		new Room([2, 6], [1, 6]),
		new Room([6, 6]),
		new Room([10, 6], [11, 6]),
		new Room([2, 10]),
		new Room([6, 10], [6, 11]),
		new Room([10, 10])
	]; //1 3 5 7号房间为边位，0 2 6 8号房间为角位

	function getRandomRoom(condition) { //随机返回一个房间，corner角位，edge边位，exclude不包括（数组）
		let possibleRooms = [0, 1, 2, 3, 4, 5, 6, 7, 8];
		if (condition) {
			if (condition.corner)
				possibleRooms = possibleRooms.filter(num => [0, 2, 6, 8].includes(num));
			if (condition.edge)
				possibleRooms = possibleRooms.filter(num => [1, 3, 5, 7].includes(num));
			if (condition.exclude)
				possibleRooms = possibleRooms.filter(num => !(condition.exclude.includes(num)));
		}
		const a = possibleRooms.length;
		if (a > 0) return rooms[possibleRooms[core.rand(a)]];
		else return null;
	}

	//获取某个坐标对应的房间号，不在房间里返回null
	function getRoomId(x, y) {
		if (x === 4 || y === 4 || x === 8 || y === 8) return null;
		return Math.floor(x / 4) + 3 * Math.floor(y / 4);
	}
	//获取某个坐标对应的房间，不在房间里返回null
	function getRoom(x, y) {
		const id = getRoomId(x, y);
		if (id !== null) return rooms[id];
		return null;
	}

	////////--------------------------------预设相关内容，模式相关内容在其他插件

	function getContent(condition, direction) { //我现在也不知道我在干什么
		const pattern = core.getRandomPattern(condition);
		const content = core.patternToContent(pattern);
		return getDirectionContent(content, direction);
	}

	function getDirectionContent(content, direction) { //根据传入的方向调整content
		let newContent = [
			[0, 0, 0],
			[0, 0, 0],
			[0, 0, 0]
		];
		let i, j;
		switch (direction) {
		case 'down':
			for (i = 0; i < 3; i++) {
				for (j = 0; j < 3; j++) {
					newContent[i][j] = content[2 - i][2 - j];
				}
			}
			return newContent;
		case 'left':
			for (i = 0; i < 3; i++) {
				for (j = 0; j < 3; j++) {
					newContent[i][j] = content[2 - j][i];
				}
			}
			return newContent;
		case 'right':
			for (i = 0; i < 3; i++) {
				for (j = 0; j < 3; j++) {
					newContent[i][j] = content[j][2 - i];
				}
			}
			return newContent;
		case 'up':
			return content;
		default:
			return content;
		}
	}

	////////--------------------------------首次到达YB层
	this.gameStart = function () {
		generateWomans();
		generateThiefs();
		generateEnemyBuffs();
		generateSecrets();
		generateKnives();
	}

	////随机生成商人出售的东西
	function generateWomans() {
		const sell = shuffleArray([{
				word: '我有五把黄钥匙，你出50金币就卖给你',
				item: [{ item: 'yellowKey', num: 5 }],
				money: 50
			},
			{
				word: '我有三把蓝钥匙，你出200金币就卖给你',
				item: [{ item: 'blueKey', num: 3 }],
				money: 200
			},
			{
				word: '我有一把蓝钥匙，四把黄钥匙，你出600金币就卖给你',
				item: [{ item: 'blueKey', num: 1 }, { item: 'yellowKey', num: 4 }],
				money: 600
			},
			{
				word: '你出1000金币, 我就帮你回复2000点生命值',
				item: [{ item: 'hp', num: 2000 }],
				money: 1000
			},
			{
				word: '大甩卖! 三把黄钥匙只要200金币, 先到先得!',
				item: [{ item: 'yellowKey', num: 3 }],
				money: 200
			},
		]);
		core.setFlag('商人出售', sell);
	}
	////随机生成小偷给的东西
	function generateThiefs() {
		const thief = shuffleArray(
			[{
					word: '很高兴遇到你，我送你三个炸弹吧',
					item: [{ item: 'bomb', num: 3 }]
				},
				{
					word: '谢谢你救了我，我从一个老人身上偷了1000金币，全部给你了',
					item: [{ item: 'money', num: 1000 }]
				},
				{
					word: '这魔塔太危险了 我可不想再次被抓 我要离塔回去了 再见',
					item: [{ item: 'hp', num: 1000 }]
				},
				{
					word: '这塔里没有大章鱼，都没有东西能挡住我的去路了，我刚刚用破墙镐挖到一些矿，分你一些',
					item: [{ item: 'yellowGem', num: 3 }, { item: 'greenGem', num: 3 }]
				},
				{
					word: '其实我是魔王，我在这里埋伏你，你完蛋了……哈哈骗你的，我才不是魔王呢，我是个小偷，我有绿钥匙，给你一把吧',
					item: [{ item: 'greenKey', num: 1 }]
				},
			]

		);
		core.setFlag('小偷给的', thief);
	}

	////随机生成怪物的加强幅度
	function generateEnemyBuffs() {
		for (let i = 1; i <= 50; i++) {
			const flagName = 'LC' + i + 'buff';
			let ii = i % 10;
			let re = getRegion(i);
			if (re <= 2) re -= 1;
			if (re === 5) re += 1;
			if (ii === 0) ii = 10;
			const buff = { atk: ii * 10 + re * 20, def: ii * 10 + re * 20, hp: ii * 10 + re * 20 };
			buff.atk += core.rand(10) - 5;
			buff.def += core.rand(10) - 5;
			buff.hp += core.rand(10) - 5;
			core.setFlag(flagName, buff);
		}
	}

	////随机生成密室，每个区选择三层生成密室，将选出来的5 * 3层floorId（乱序）赋值给flags.密室，不会在boss层生成密室
	function generateSecrets() {
		flags.密室 = [...shuffleArray([1, 2, 3, 4, 5, 6, 7, 8, 9]).slice(0, 3).map((n) => 'LC' + n), ...shuffleArray([1, 2, 3, 4, 5, 6, 7, 8, 9]).slice(0, 3).map((n) => 'LC1' + n), ...shuffleArray([1, 2, 3, 4, 5, 6, 7, 8, 9]).slice(0, 3).map((n) => 'LC2' + n), ...shuffleArray([1, 2, 3, 4, 5, 6, 7, 8, 9]).slice(0, 3).map((n) => 'LC3' + n), ...shuffleArray([1, 2, 3, 4, 5, 6, 7, 8, 9]).slice(0, 3).map((n) => 'LC4' + n)];
		for (let i = 1; i <= 15; i++) {
			const flagName1 = flags.密室[i - 1] + 'buff';
			const flagName2 = 'MS' + i + 'buff';
			const buff = core.getFlag(flagName1);
			core.setFlag(flagName2, buff);
		}
	}

	////随机生成屠龙匕，总共选择七层，将选出来的七层floorId（升序）赋值给flags.屠龙匕，最高楼层为最后一个元素
	function generateKnives() {
		flags.屠龙匕 = shuffleArray([1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33, 34, 35, 36, 37, 38, 39, 41, 42, 43, 44, 45, 46, 47, 48, 49]).slice(0, 7).sort((a, b) => a - b).map((n) => 'LC' + n);
		const buff = core.getFlag(flags.屠龙匕[6] + 'buff');
		core.setFlag('ML1buff', buff);
	}

	////////--------------------------------首次到达楼层
	this.myAfterChangingFloor = function (floorId) {
		if (floorId.startsWith('LC')) {
			randomSetStair();
			randomSetSecret(floorId);
			randomSetKnife(floorId);
			randomSetDoor(floorId);
			randomSetDownStairRoomContent();
		} else if (floorId.startsWith('MS')) {
			//randomSetMS();
		} else if (floorId === 'JJ')
			core.setBlock('downFloor', core.getHeroLoc('x'), core.getHeroLoc('y'));
		if (flags.天赋 === '贵族') {
			hero.money += 2 * core.yellowGem(core.itemCount('yellowGem'));
			hero.hp += 2 * hero.mdef;
		} else {
			hero.money += core.yellowGem(core.itemCount('yellowGem'));
			hero.hp += 1 * hero.mdef;
		}
	};

	////随机生成门
	function randomSetDoor(floorId) {
		const floor = getFloorNumber(floorId);
		if (floor % 10) randomSetDoorNoBoss();
		else randomSetDoorBoss();
	}

	//非boss层，内圈生成一扇蓝门两扇黄门，外圈生成五扇黄门一扇蓝门一面暗墙
	function randomSetDoorNoBoss() {
		let a = shuffleArray(['yellowWall', 'blueWall', 'blueDoor', 'yellowDoor', 'yellowDoor', 'yellowDoor', 'yellowDoor', 'yellowDoor']);
		if (flags.天赋 === '幸运儿') {
			if (core.rand(2)) a = shuffleArray(['blueWall', 'blueWall', 'blueDoor', 'yellowDoor', 'yellowDoor', 'yellowDoor', 'yellowDoor', 'yellowDoor']);
		}
		let i, x, y;
		for (i = 0; i < 8; i++) {
			[x, y] = doorLocOut[i];
			core.setBlock(a[i], x, y);
		}
		a = shuffleArray(['yellowWall', 'blueDoor', 'yellowDoor', 'yellowDoor']);
		for (i = 0; i < 4; i++) {
			[x, y] = doorLocIn[i];
			core.setBlock(a[i], x, y);
		}
	}

	//boss层，内圈生成一扇红门一扇机关门，红门向着下楼梯位置，机关门向着上楼梯位置，外圈生成六扇黄门
	function randomSetDoorBoss() {
		let room1, room2, loc1, loc2;
		room1 = rooms.find((room) => room.hasBlock('downFloor'));
		loc1 = room1.getDoorLocIn();
		core.setBlock('redDoor', loc1[0][0], loc1[0][1]);
		room2 = rooms.find((room) => room.hasBlock('upFloor'));
		loc2 = room2.getDoorLocIn();
		core.setBlock('specialDoor', loc2[0][0], loc2[0][1]);
		room2.setContent([
			['0', '0', '0'],
			['0', '0', '0'],
			['0', '0', '0']
		]);

		doorLocOut.forEach(
			function ([x, y]) {
				if (!room2.getDoorLocOut().some(([nx, ny]) => { return x === nx && y === ny; }))
					core.setBlock('yellowDoor', x, y);
			}
		);
	}

	////生成楼梯，下楼梯在勇士脚下生成，上楼梯随机选择一个非当前房间生成，楼梯只会在边位生成
	function randomSetStair() {
		const x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y');
		core.setBlock('downFloor', x, y);
		const currentRoomId = getRoomId(x, y);
		const condition = { edge: true, exclude: [currentRoomId] };
		const room = getRandomRoom(condition);
		core.setBlock('upFloor', room.stair[0], room.stair[1]);
	}

	////生成密室传送门，找到随机房间并放置在中心格
	function randomSetSecret(floorId) {
		const x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y');
		if (flags.密室.includes(floorId)) {
			let room;
			let notFound = true;
			const currentRoomId = getRoomId(x, y);
			const condition = { exclude: [currentRoomId] };
			while (notFound) {
				room = getRandomRoom(condition);
				const [x, y] = room.centre;
				if (core.getBlockId(x, y) === 'T330') notFound = false;
				else condition.exclude.push(getRoomId(x, y));
			}
			room.setCentre('portal');
		}
	}

	////生成屠龙匕，找到随机房间放置
	function randomSetKnife(floorId) {
		const x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y');
		if (flags.屠龙匕.includes(floorId)) {
			const currentRoomId = getRoomId(x, y);
			const condition = { exclude: [currentRoomId] };
			const room = getRandomRoom(condition);
			room.setOneBlock('knife');
		}
	}

	////生成下楼梯房间对应内容
	function randomSetDownStairRoomContent() {
		const x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y');
		const room = getRoom(x, y);
		let direction;
		if (x === 11) direction = 'left';
		if (x === 1) direction = 'right';
		if (y === 11) direction = 'up';
		if (y === 1) direction = 'down';
		const condition = { stair: true };
		const content = getContent(condition, direction);
		room.setContent(content);
	}

	////生成密室内容，四个怪物
	function randomSetMS() {
		const room = rooms[7];
		const content = core.patternToContent([
			['e', '0', 'e'],
			['0', '0', '0'],
			['e', '0', 'e']
		]);
		room.setContent(content);
	}

	////////--------------------------------开门后
	this.myAfterOpenDoor = function (doorId, x, y) {
		if (['yellowDoor', 'blueDoor', 'redDoor'].includes(doorId))
			special32();

		if (core.status.floorId.startsWith('LC')) {
			if (['yellowDoor', 'blueDoor', 'blueWall'].includes(doorId)) {
				if (flags.天赋 === '幸运儿') { if (core.rand(5)) doorId = 'blueWall'; }
				randomSetRoomAfterOpenDoor(doorId);
			}
			if (doorId === 'yellowDoor') {
				if (flags.天赋 === '幸运儿') { if (core.rand(2)) randomSetLava(x, y); } else
					randomSetLava(x, y);
			}
		}

	}

	function randomSetRoomAfterOpenDoor(doorId) {
		let direction = core.getHeroLoc('direction');
		const nx = core.nextX(2),
			ny = core.nextY(2);
		const room = getRoom(nx, ny);
		const condition = {};
		if (room.hasBlock('upFloor')) {
			condition.stair = true;
			const [x, y] = room.getBlockLoc('upFloor')[0];
			if (x === 11) direction = 'left';
			if (x === 1) direction = 'right';
			if (y === 11) direction = 'up';
			if (y === 1) direction = 'down';
		}
		if (doorId === 'blueDoor' || doorId === 'blueWall') condition.blue = true;
		const content = getContent(condition, direction);
		room.setContent(content);
		special36(room.wholeRoom());
	}

	//开门后新怪物出现后，其中突袭特技怪物集体攻击勇者
	function special36(wholeRoom) {
		let damage = 0;
		let a;
		wholeRoom.forEach(
			([i, j]) => {
				const block = core.getBlock(i, j);
				if (block) {
					const { id, cls } = block.event;
					if (cls === 'enemys') {
						const special = core.material.enemys[id].special;
						if (core.hasSpecial(special, 36)) {
							let hero_def = core.getRealStatusOrDefault(undefined, 'def');
							if (core.getFlag('special41', 0)) hero_def = Math.round(hero_def * 0.75);
							a = core.getEnemyInfo(id, undefined, i, j).atk - hero_def;
							if (a > 0)
								damage += a;
						}
					}
				}
			}
		);
		if (damage) {
			damage /= 2;
			if (core.getFlag('special43', false)) damage = Math.round(damage * 1.25);
			const shield3 = core.getFlag('骑士盾等级', 0);
			damage = Math.round(damage * (10 - shield3) / 10);
			core.drawAnimate('sword', core.getHeroLoc('x'), core.getHeroLoc('y'));
			if (damage >= hero.hp) {
				hero.hp = 0;
				core.updateStatusBar();
				core.events.lose('战斗失败');
			} else {
				hero.hp -= damage;
				core.updateStatusBar();
			}
		}
	}

	function randomSetLava(x, y) {
		const k = core.rand(10);
		if (k < 3) core.setBlock('lavaNet', x, y);
	}

	////开门后飞弹特技怪物（应该均拥有魔攻）集体攻击勇者，在新怪物出现之前
	function special32() {
		let damage = 0;
		for (let i = 1; i <= 11; i++) {
			for (let j = 1; j <= 11; j++) {
				const block = core.getBlock(i, j);
				if (block) {
					const { id, cls } = block.event;
					if (cls === 'enemys') {
						const special = core.material.enemys[id].special;
						if (core.hasSpecial(special, 32)) {
							const mon_atk = core.getEnemyInfo(id, undefined, i, j).atk;
							let hero_def = core.getRealStatusOrDefault(undefined, 'def');
							if (core.getFlag('special41', 0)) hero_def = Math.round(hero_def * 0.75);
							let per_damage;
							const shield2 = core.getFlag('银盾等级', 0);
							per_damage = mon_atk - hero_def * (shield2) / 10;
							per_damage = Math.round(per_damage);
							if (per_damage > 0)
								damage += per_damage;
						}
					}
				}
			}
		}
		if (damage) {
			if (core.getFlag('special43', false)) damage = Math.round(damage * 1.25);
			core.drawAnimate('hand', core.getHeroLoc('x'), core.getHeroLoc('y'));
			if (damage >= hero.hp) {
				hero.hp = 0;
				core.updateStatusBar();
				core.events.lose('战斗失败');
			} else {
				hero.hp -= damage;
				core.updateStatusBar();
			}
		}
	}

	////////--------------------------------战后
	this.myAfterBattle = function (enemyId, x, y, enemy, special) {
		special31(special);
		special41(special);
		special42(special);
		special43(special);
		if (core.hasSpecial(special, 30)) special30(enemy.value);
		//if (core.hasSpecial(special, 37)) special37(enemy.value);
		special38(enemy.value);
	}

	////枯萎
	function special31(special) {
		core.setFlag('special31', false);
		if (core.hasSpecial(special, 31)) {
			core.setFlag('special31', true);
		}
	}

	////黄金雨
	function special41(special) {
		core.setFlag('special41', false);
		if (core.hasSpecial(special, 41)) {
			core.setFlag('special41', true);
		}
	}

	////超脆变
	function special42(special) {
		core.setFlag('special42', false);
		if (core.hasSpecial(special, 42)) {
			core.setFlag('special42', true);
		}
	}

	////汞中毒
	function special43(special) {
		core.setFlag('special43', false);
		if (core.hasSpecial(special, 43)) {
			core.setFlag('special43', true);
		}
	}

	////亡灵
	function special30(value) {
		for (let i = 0; i <= 11; i++) {
			for (let j = 0; j <= 11; j++) {
				const block = core.getBlock(i, j);
				if (block) {
					const { id, cls } = block.event;
					if (cls === 'enemys') {
						core.setEnemyOnPoint(i, j, undefined, 'hp', (100 + value) / 100, '*=');
					}
				}
			}
		}
	}

	////脱逃
	/*function special37(value) {
		const knights = [];
		knights.forEach(
			(enemy) => {
				core.setEnemy(enemy, 'def', value, '+=');
			}
		);
	}*/

	////警戒
	function special38(value) {
		for (let i = 0; i <= 11; i++) {
			for (let j = 0; j <= 11; j++) {
				const block = core.getBlock(i, j);
				if (block) {
					const { id, cls } = block.event;
					if (cls === 'enemys') {
						if (core.hasSpecial(id, 38))
							core.setEnemyOnPoint(i, j, undefined, 'atk', value, '+=');
					}
				}
			}
		}
	}

	////////--------------------------------其他怪物特技部分
	////潜行，返回有几个房间没有揭露
	this.special34 = function () {
		return rooms.filter((room) => room.hasBlock('T330')).length;
	}

	////连击，返回连击数，只有怪物自己的时候为1
	this.special35 = function () {
		let n = 0;
		for (let i = 0; i <= 11; i++) {
			for (let j = 0; j <= 11; j++) {
				const block = core.getBlock(i, j);
				if (block) {
					const { id, cls } = block.event;
					if (cls === 'enemys') {
						const special = core.material.enemys[id].special;
						if (core.hasSpecial(special, 35)) {
							n += 1;
						}
					}
				}
			}
		}
		return n;
	}


},
    "各种pattern": function () {
	// 在此增加新插件

	class Patterns {
		constructor(pattern, condition) {
			this.pattern = pattern;
			if (condition) {
				if (condition.region) this.region = condition.region; //若未指定区域，则为通用
				if (condition.blue) this.blue = true; //若未指定则表明是开启黄门得到
				if (condition.stair) this.stair = true;
			}
		}
	}

	const p = []; //i代表道具，e代表怪物，w代表墙壁，0代表空地

	//普通房间
	p.push(
		new Patterns([
			['i', 'e', '0'],
			['i', 'e', '0'],
			['i', 'e', '0'],
		]));

	p.push(
		new Patterns([
			['e', '0', '0'],
			['0', '0', 'e'],
			['i', '0', '0'],
		]));

	p.push( //这个与上一个互为镜像关系
		new Patterns([
			['i', '0', '0'],
			['0', '0', 'e'],
			['e', '0', '0'],
		]));

	p.push(
		new Patterns([
			['i', 'e', '0'],
			['i', 'w', '0'],
			['i', 'e', '0'],
		]));

	p.push(
		new Patterns([
			['0', 'e', '0'],
			['e', 'i', 'e'],
			['0', 'e', '0'],
		]));

	p.push(
		new Patterns([
			['e', 'i', 'e'],
			['0', 'w', '0'],
			['0', 'e', '0'],
		]));

	p.push(
		new Patterns([
			['0', 'e', '0'],
			['0', 'w', '0'],
			['e', 'i', 'e'],
		]));

	p.push(
		new Patterns([
			['w', 'i', 'w'],
			['i', 'e', 'i'],
			['w', 'i', 'w'],
		]));

	p.push(
		new Patterns([
			['w', 'i', 'w'],
			['e', 'i', 'e'],
			['w', 'i', 'w'],
		]));

	p.push(
		new Patterns([
			['e', 'i', 'i'],
			['e', 'w', 'e'],
			['i', 'i', 'e'],
		]));

	p.push(
		new Patterns([
			['i', 'i', 'e'],
			['e', 'w', 'e'],
			['e', 'i', 'i'],
		]));

	p.push(
		new Patterns([
			['0', 'i', 'e'],
			['e', 'w', 'i'],
			['w', '0', 'i'],
		]));

	p.push(
		new Patterns([
			['w', '0', 'i'],
			['e', 'w', 'i'],
			['0', 'i', 'e'],
		]));

	p.push(
		new Patterns([
			['0', 'i', 'i'],
			['e', 'w', '0'],
			['w', 'i', 'e'],
		]));

	p.push(
		new Patterns([
			['w', 'i', 'e'],
			['e', 'w', '0'],
			['0', 'i', 'i'],
		]));

	p.push(
		new Patterns([
			['i', '0', 'e'],
			['0', 'e', '0'],
			['e', '0', 'i'],
		]));

	p.push(
		new Patterns([
			['e', '0', 'i'],
			['0', 'e', '0'],
			['i', '0', 'e'],
		]));

	p.push(
		new Patterns([
			['0', 'i', '0'],
			['e', '0', 'e'],
			['0', 'i', '0'],
		]));

	p.push(
		new Patterns([
			['0', 'i', 'i'],
			['e', '0', 'e'],
			['0', 'e', 'i'],
		]));

	p.push(
		new Patterns([
			['0', 'e', 'i'],
			['e', '0', 'e'],
			['0', 'i', 'i'],
		]));

	//魔法警卫专用房间
	p.push(
		new Patterns([
			['ewk', '0', 'i'],
			['0', 'i', 'e'],
			['ewk', '0', 'i'],
		], {
			region: 5,
		}));

	p.push(
		new Patterns([
			['ewk', 'e', 'i'],
			['0', '0', 'i'],
			['ewk', 'e', 'i'],
		], {
			region: 5,
		}));

	p.push(
		new Patterns([
			['ewk', '0', 'ewk'],
			['0', 'i', '0'],
			['ewk', '0', 'ewk'],
		], {
			region: 5,
		}));

	//蓝门房间
	p.push(
		new Patterns([
			['i', 'i', '0'],
			['i', '0', 'e'],
			['i', 'i', '0'],
		], {
			blue: true,
		}));

	p.push(
		new Patterns([
			['i', 'e', 'i'],
			['e', 'i', 'e'],
			['i', 'e', 'i'],
		], {
			blue: true,
		}));

	p.push(
		new Patterns([
			['i', 'i', 'e'],
			['i', 'e', 'i'],
			['e', 'i', 'i'],
		], {
			blue: true,
		}));

	p.push(
		new Patterns([
			['e', 'i', 'i'],
			['i', 'e', 'i'],
			['i', 'i', 'e'],
		], {
			blue: true,
		}));

	p.push(
		new Patterns([
			['i', 'e', 'i'],
			['i', '0', 'e'],
			['i', 'e', 'i'],
		], {
			blue: true,
		}));

	p.push(
		new Patterns([
			['w', 'i', 'w'],
			['i', '0', 'i'],
			['w', 'i', 'w'],
		], {
			blue: true,
		}));

	//含有楼梯的房间，以楼梯所靠的边界朝向地图中间作为正方向
	p.push(
		new Patterns([
			['e', '0', '0'],
			['0', '0', '0'],
			['e', '0', '0'],
		], {
			stair: true,
		}));

	p.push(
		new Patterns([
			['e', '0', '0'],
			['i', '0', '0'],
			['e', '0', '0'],
		], {
			stair: true,
		}));

	p.push(
		new Patterns([
			['0', 'e', '0'],
			['e', '0', '0'],
			['0', 'e', '0'],
		], {
			stair: true,
		}));

	p.push(
		new Patterns([
			['e', 'e', '0'],
			['0', '0', '0'],
			['e', '0', '0'],
		], {
			stair: true,
		}));

	p.push(
		new Patterns([
			['e', 'e', '0'],
			['i', '0', '0'],
			['e', '0', '0'],
		], {
			stair: true,
		}));

	p.push(
		new Patterns([
			['e', '0', '0'],
			['0', '0', '0'],
			['e', 'e', '0'],
		], {
			stair: true,
		}));

	p.push(
		new Patterns([
			['e', '0', '0'],
			['i', '0', '0'],
			['e', 'e', '0'],
		], {
			stair: true,
		}));

	p.push(
		new Patterns([
			['e', 'e', '0'],
			['0', '0', '0'],
			['e', 'e', '0'],
		], {
			stair: true,
		}));

	p.push(
		new Patterns([
			['e', 'e', '0'],
			['i', '0', '0'],
			['e', 'e', '0'],
		], {
			stair: true,
		}));

	//含有楼梯的蓝门房间，应该只会出现在上楼梯房间
	p.push(
		new Patterns([
			['i', '0', '0'],
			['0', '0', '0'],
			['i', '0', '0'],
		], {
			stair: true,
			blue: true,
		}));

	p.push(
		new Patterns([
			['i', 'e', '0'],
			['0', '0', '0'],
			['i', '0', '0'],
		], {
			stair: true,
			blue: true,
		}));

	p.push(
		new Patterns([
			['i', '0', '0'],
			['0', '0', '0'],
			['i', 'e', '0'],
		], {
			stair: true,
			blue: true,
		}));

	p.push(
		new Patterns([
			['0', 'e', 'i'],
			['e', '0', '0'],
			['0', 'e', 'i'],
		], {
			stair: true,
			blue: true,
		}));

	this.getRandomPattern = function (condition) {
		let pa = [...p];
		if (condition) {
			if ('region' in condition) {
				pa = pa.filter(elt => ('region' in elt) && elt.region === condition.region);
			} else {
				pa = pa.filter(elt => !('region' in elt));
			}
			if (condition.blue) pa = pa.filter(elt => elt.blue);
			else pa = pa.filter(elt => !('blue' in elt));
			if (condition.stair) pa = pa.filter(elt => elt.stair);
			else pa = pa.filter(elt => !('stair' in elt));
		}
		return pa[core.rand(pa.length)].pattern;
	};
},
    "pattern转content概率": function () {
	// 在此增加新插件

	//复制了两个函数过来，因为懒得把那个插件的改成this
	function getFloorNumber(floorId) {
		return parseInt(floorId.substr(2));
	}

	function getRegion(num) {
		if (num > 0 && num <= 10) return 1;
		if (num > 10 && num <= 20) return 2;
		if (num > 20 && num <= 30) return 3;
		if (num > 30 && num <= 40) return 4;
		if (num > 40 && num <= 50) return 5;
	}

	//这里写概率

	//item用作道具的意思，为防止混淆这里用thing，看起来有些奇怪
	function getRandomThing(things) {
		// 实际概率为probability / sum
		const sum = things.reduce((acc, thing) => acc + thing.probability, 0);
		// 生成一个不超过sum的随机数
		const random = core.rand2(sum);
		let cumulativeProbability = 0;

		for (const thing of things) {
			cumulativeProbability += thing.probability;
			if (random < cumulativeProbability) {
				return thing.value;
			}
		}
	}

	function itemToContent(region) {
		let itemPossible;
		switch (region) {
		case 1:
			itemPossible = [
				{ value: 'redGem', probability: 40 },
				{ value: 'blueGem', probability: 40 },
				{ value: 'greenGem', probability: 40 },
				{ value: 'yellowGem', probability: 40 },
				{ value: 'redPotion', probability: 40 },
				{ value: 'bluePotion', probability: 20 },
				{ value: 'yellowKey', probability: 120 },
				{ value: 'blueKey', probability: 20 },
			];
			break;

		case 2:
			itemPossible = [
				{ value: 'redGem', probability: 40 },
				{ value: 'blueGem', probability: 40 },
				{ value: 'greenGem', probability: 30 },
				{ value: 'yellowGem', probability: 30 },
				{ value: 'redPotion', probability: 40 },
				{ value: 'bluePotion', probability: 20 },
				{ value: 'yellowKey', probability: 80 },
				{ value: 'blueKey', probability: 15 },
			];
			break;

		case 3:
			itemPossible = [
				{ value: 'redGem', probability: 40 },
				{ value: 'blueGem', probability: 40 },
				{ value: 'greenGem', probability: 20 },
				{ value: 'yellowGem', probability: 20 },
				{ value: 'redPotion', probability: 40 },
				{ value: 'bluePotion', probability: 20 },
				{ value: 'yellowKey', probability: 60 },
				{ value: 'blueKey', probability: 10 },
			];
			break;

		case 4:
			itemPossible = [
				{ value: 'redGem', probability: 45 },
				{ value: 'blueGem', probability: 45 },
				{ value: 'greenGem', probability: 10 },
				{ value: 'yellowGem', probability: 10 },
				{ value: 'redPotion', probability: 40 },
				{ value: 'bluePotion', probability: 20 },
				{ value: 'yellowKey', probability: 45 },
				{ value: 'blueKey', probability: 5 },
			];
			break;

		case 5:
			itemPossible = [
				{ value: 'redGem', probability: 45 },
				{ value: 'blueGem', probability: 45 },
				{ value: 'greenGem', probability: 5 },
				{ value: 'yellowGem', probability: 5 },
				{ value: 'redPotion', probability: 35 },
				{ value: 'bluePotion', probability: 25 },
				{ value: 'yellowKey', probability: 45 },
				{ value: 'blueKey', probability: 5 },
			];
			break;

		default:

		}
		return getRandomThing(itemPossible);
	}

	function enemyToContent(region, floorNumber) {
		let enemyPossible;
		switch (region) {
		case 1:
			if (floorNumber <= 2) {
				enemyPossible = [
					{ value: 'greenSlime', probability: 10 },
					{ value: 'redSlime', probability: 7 }
				];
			} else if (floorNumber <= 5) {
				enemyPossible = [
					{ value: 'greenSlime', probability: 7 },
					{ value: 'redSlime', probability: 7 },
					{ value: 'bat', probability: 7 },
					{ value: 'bluePriest', probability: 5 },
					{ value: 'skeleton', probability: 5 }
				];
			} else {
				enemyPossible = [
					{ value: 'greenSlime', probability: 7 },
					{ value: 'redSlime', probability: 10 },
					{ value: 'bat', probability: 10 },
					{ value: 'bluePriest', probability: 10 },
					{ value: 'skeleton', probability: 10 },
					{ value: 'skeletonSoilder', probability: 7 },
					{ value: 'yellowGuard', probability: 7 }
				];
			}
			break;

		case 2:
			if (floorNumber <= 12) {
				enemyPossible = [
					{ value: 'blackSlime', probability: 10 },
					{ value: 'bigBat', probability: 10 },
					{ value: 'zombie', probability: 7 },
					{ value: 'bat', probability: 7 }
				];
			} else if (floorNumber <= 15) {
				enemyPossible = [
					{ value: 'blackSlime', probability: 10 },
					{ value: 'bigBat', probability: 10 },
					{ value: 'redPriest', probability: 7 },
					{ value: 'zombie', probability: 10 },
					{ value: 'zombieKnight', probability: 7 },
					{ value: 'yellowGuard', probability: 5 },
					{ value: 'bat', probability: 5 }
				];
			} else {
				enemyPossible = [
					{ value: 'blackSlime', probability: 7 },
					{ value: 'bigBat', probability: 10 },
					{ value: 'redPriest', probability: 10 },
					{ value: 'zombie', probability: 10 },
					{ value: 'zombieKnight', probability: 7 },
					{ value: 'rock', probability: 7 }
				];
			}
			break;

		case 3:
			if (floorNumber <= 22) {
				enemyPossible = [
					{ value: 'slimeMan', probability: 10 },
					{ value: 'ghostSkeleton', probability: 10 },
					{ value: 'soldier', probability: 7 },
					{ value: 'swordsman', probability: 7 },
					{ value: 'zombieKnight', probability: 5 }
				];
			} else if (floorNumber <= 25) {
				enemyPossible = [
					{ value: 'slimeMan', probability: 10 },
					{ value: 'ghostSkeleton', probability: 10 },
					{ value: 'soldier', probability: 10 },
					{ value: 'redKnight', probability: 5 },
					{ value: 'swordsman', probability: 7 },
					{ value: 'zombie', probability: 3 },
					{ value: 'zombieKnight', probability: 3 }
				];
			} else {
				enemyPossible = [
					{ value: 'slimeMan', probability: 7 },
					{ value: 'ghostSkeleton', probability: 7 },
					{ value: 'soldier', probability: 10 },
					{ value: 'redKnight', probability: 10 },
					{ value: 'blueGuard', probability: 7 },
					{ value: 'swordsman', probability: 10 }
				];
			}
			break;

		case 4:
			if (floorNumber <= 35) {
				enemyPossible = [
					{ value: 'brownWizard', probability: 7 },
					{ value: 'redWizard', probability: 7 },
					{ value: 'slimelord', probability: 10 },
					{ value: 'redBat', probability: 10 }
				];
			} else {
				enemyPossible = [
					{ value: 'brownWizard', probability: 10 },
					{ value: 'redWizard', probability: 10 },
					{ value: 'slimelord', probability: 10 },
					{ value: 'redBat', probability: 10 },
					{ value: 'darkKnight', probability: 7 },
					{ value: 'redGuard', probability: 3 }
				];
			}
			break;

		case 5:
			enemyPossible = [
				{ value: 'goldSlime', probability: 10 },
				{ value: 'iceBat', probability: 10 },
				{ value: 'skeletonPriest', probability: 10 },
				{ value: 'redSwordsman', probability: 10 },
				{ value: 'whiteGhost', probability: 10 },
				{ value: 'greenKnight', probability: 7 },
				{ value: 'greenGuard', probability: 5 },
				{ value: 'whiteKing', probability: 3 }
			];
			break;

		default:

		}

		return getRandomThing(enemyPossible);
	}


	this.patternToContent = function (pattern) { //模式是一个二维数组，仅仅包含各个位置是什么图块类型或者空地，在这个函数中变成随机的对应图块，TODO
		const floorId = core.status.floorId;
		const floorNumber = getFloorNumber(floorId);
		const region = getRegion(floorNumber);
		const mapping = { //这有什么用呢
			'w': 'yellowWall',
			'0': '空地',
			'ewk': 'whiteKing'
		};


		const content = [
			[, , ],
			[, , ],
			[, , ]
		];
		let i, j;
		for (i = 0; i < 3; i++) {
			for (j = 0; j < 3; j++) {
				//这里原本有个注释
				switch (pattern[i][j]) {
				case 'i':
					content[i][j] = itemToContent(region);
					break;
				case 'e':
					content[i][j] = enemyToContent(region, floorNumber);
					break;
				default:
					content[i][j] = mapping[pattern[i][j]];
				}

			}
		}
		return content;
	}


},
    "宝石血瓶显示": function () {
	// 在此增加新插件
	/* 宝石血瓶左下角显示数值
	 * 需要将 变量：itemDetail改为true才可正常运行
	 * 请尽量减少勇士的属性数量，否则可能会出现严重卡顿（划掉，现在你放一万个属性也不会卡）
	 * 注意：这里的属性必须是core.status.hero里面的，flag无法显示
	 * 如果不想显示，可以core.setFlag("itemDetail", false);
	 * 然后再core.getItemDetail();
	 * 如有bug在大群或造塔群@古祠
	 */

	// 忽略的道具
	const ignore = ['superPotion'];

	// 取消注释下面这句可以减少超大地图的判定。
	// 如果地图宝石过多，可能会略有卡顿，可以尝试取消注释下面这句话来解决。
	// core.bigmap.threshold = 256;
	const origin = core.control.updateStatusBar;
	core.updateStatusBar = core.control.updateStatusBar = function () {
		if (core.getFlag('__statistics__')) return;
		else return origin.apply(core.control, arguments);
	}

	core.control.updateDamage = function (floorId, ctx) {
		floorId = floorId || core.status.floorId;
		if (!floorId || core.status.gameOver || main.mode != 'play') return;
		const onMap = ctx == null;

		// 没有怪物手册
		if (!core.hasItem('book')) return;
		core.status.damage.posX = core.bigmap.posX;
		core.status.damage.posY = core.bigmap.posY;
		if (!onMap) {
			const width = core.floors[floorId].width,
				height = core.floors[floorId].height;
			// 地图过大的缩略图不绘制显伤
			if (width * height > core.bigmap.threshold) return;
		}
		this._updateDamage_damage(floorId, onMap);
		this._updateDamage_extraDamage(floorId, onMap);
		core.getItemDetail(floorId); // 宝石血瓶详细信息
		this.drawDamage(ctx);
	};
	// 获取宝石信息 并绘制
	this.getItemDetail = function (floorId) {
		if (!core.getFlag('itemDetail')) return;
		if (!core.status.thisMap) return;
		floorId = floorId ?? core.status.thisMap.floorId;
		const beforeRatio = core.status.thisMap.ratio;
		core.status.thisMap.ratio = core.status.maps[floorId].ratio;
		let diff = {};
		const before = core.status.hero;
		const hero = core.clone(core.status.hero);
		const handler = {
			set(target, key, v) {
				diff[key] = v - (target[key] || 0);
				if (!diff[key]) diff[key] = void 0;
				return true;
			}
		};
		core.status.hero = new Proxy(hero, handler);
		core.status.maps[floorId].blocks.forEach(function (block) {
			if (
				block.event.cls !== 'items' ||
				ignore.includes(block.event.id) ||
				block.disable
			)
				return;
			const x = block.x,
				y = block.y;
			// v2优化，只绘制范围内的部分
			if (core.bigmap.v2) {
				if (
					x < core.bigmap.posX - core.bigmap.extend ||
					x > core.bigmap.posX + core._SIZE_ + core.bigmap.extend ||
					y < core.bigmap.posY - core.bigmap.extend ||
					y > core.bigmap.posY + core._SIZE_ + core.bigmap.extend
				) {
					return;
				}
			}
			diff = {};
			const id = block.event.id;
			const item = core.material.items[id];
			if (item.cls === 'equips') {
				// 装备也显示
				const diff = item.equip.value ?? {};
				const per = item.equip.percentage ?? {};
				for (const name in per) {
					diff[name + 'per'] = per[name].toString() + '%';
				}
				drawItemDetail(diff, x, y);
				return;
			}
			// 跟数据统计原理一样 执行效果 前后比较
			core.setFlag('__statistics__', true);
			try {
				eval(item.itemEffect);
			} catch (error) {}
			drawItemDetail(diff, x, y);
		});
		core.status.thisMap.ratio = beforeRatio;
		core.status.hero = before;
		window.hero = before;
		window.flags = before.flags;
	};

	// 绘制
	function drawItemDetail(diff, x, y) {
		const px = 32 * x + 2,
			py = 32 * y + 30;
		let content = '';
		// 获得数据和颜色
		let i = 0;
		for (const name in diff) {
			if (!diff[name]) continue;
			let color = '#fff';

			if (typeof diff[name] === 'number')
				content = core.formatBigNumber(diff[name], true);
			else content = diff[name];
			switch (name) {
			case 'atk':
			case 'atkper':
				color = '#FF7A7A';
				break;
			case 'def':
			case 'defper':
				color = '#00E6F1';
				break;
			case 'mdef':
			case 'mdefper':
				color = '#6EFF83';
				break;
			case 'hp':
				color = '#A4FF00';
				break;
			case 'hpmax':
			case 'hpmaxper':
				color = '#F9FF00';
				break;
			case 'mana':
				color = '#c66';
				break;
			}
			// 绘制
			core.status.damage.data.push({
				text: content,
				px: px,
				py: py - 10 * i,
				color: color
			});
			i++;
		}
	}
},
    "自动清怪自动拾取": function () {
	// 在此增加新插件
	// 自动拾取和自动清怪二合一插件，根据插件库中“磁吸特效+自动拾取物品”和魔塔“纳可物语”中的自动清怪插件进行拼接和微调，清理重复部分
	// 两种功能分开跑bfs，性能不如插件库中的“玩家体验优化 --- 各种自动清”，但是道具后事件和战后事件都能正常触发
	// 使用hasFlag控制，两个flag分别是zdsq和autoBattle，可以在对应的控制开关处更改

	// 插件总开关，取消注释则禁用插件
	return;

	////// 每移动一格后执行的事件 //////
	control.prototype.moveOneStep = function (callback) {
		core.plugin.autoGetItem();
		core.plugin.autoBattle();
		core.plugin.autoGetItem();
		core.plugin.autoBattle();
		return this.controldata.moveOneStep(callback);
	}

	control.prototype.moveDirectly = function (x, y, ignoreSteps) {
		core.plugin.autoGetItem();
		core.plugin.autoBattle();
		core.plugin.autoGetItem();
		core.plugin.autoBattle();
		return this.controldata.moveDirectly(x, y, ignoreSteps);
	}

	function bfsFlood(sx, sy, blockfn) {
		const canMoveArray = core.generateMovableArray();
		const blocksObj = core.getMapBlocksObj();
		const bgMap = core.getBgMapArray();

		let visited = [],
			queue = [];
		visited[sx + "," + sy] = 0;
		queue.push(sx + "," + sy);

		while (queue.length > 0) {
			let now = queue.shift().split(","),
				x = ~~now[0],
				y = ~~now[1];
			for (let direction in core.utils.scan) {
				if (!core.inArray(canMoveArray[x][y], direction)) continue;
				const nx = x + core.utils.scan[direction].x,
					ny = y + core.utils.scan[direction].y,
					nindex = nx + "," + ny;
				if (visited[nindex]) continue;
				if (core.onSki(bgMap[ny][nx])) continue;
				if (blockfn && !blockfn(blocksObj, nx, ny)) continue;
				visited[nindex] = visited[now] + 1;
				queue.push(nindex);
			}
		}
	}

	// 需要同时拦截自动拾取和自动清怪的情况
	function intercept() {
		const loc_x = core.status.hero.loc.x,
			loc_y = core.status.hero.loc.y,
			loc_idx = loc_x + "," + loc_y;
		if (Object.keys(core.status.checkBlock.damage).indexOf(loc_idx) != -1 ||
			Object.keys(core.status.checkBlock.repulse).indexOf(loc_idx) != -1 ||
			Object.keys(core.status.checkBlock.ambush).indexOf(loc_idx) != -1 ||
			core.getBlockId(loc_x, loc_y) === "poisonNet" || core.getBlockId(loc_x, loc_y) === "weakNet" || core.getBlockId(loc_x, loc_y) === "curseNet" ||
			core.getBlockId(loc_x, loc_y) === "none" ||
			core.hasFlag('poison')) return true;
	}

	function attractAnimate() {
		var name = 'attractAnimate';
		var isPlaying = false;
		this.nodes = [];

		this.add = function (id, x, y, callback) {
			this.nodes.push({ id: id, x: x, y: y, callback: callback });
		}
		this.start = function () {
			if (isPlaying) return;
			isPlaying = true;
			core.registerAnimationFrame(name, true, this.update);
			this.ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 120);
		}
		this.remove = function () {
			core.unregisterAnimationFrame(name);
			core.deleteCanvas(name);
			isPlaying = false;
		}
		this.clear = function () {
			this.nodes = [];
			this.remove();
		}
		var lastTime = -1;
		var self = this;
		this.update = function (timeStamp) {
			if (lastTime < 0) lastTime = timeStamp;
			if (timeStamp - lastTime < 20) return;
			lastTime = timeStamp;
			core.clearMap(name);
			var cx = core.status.heroCenter.px - 48,
				cy = core.status.heroCenter.py - 48;
			var thr = 2; //缓动比例倒数 越大移动越慢
			self.nodes.forEach(function (n) {
				var dx = cx - n.x,
					dy = cy - n.y;
				if (Math.abs(dx) <= thr && Math.abs(dy) <= thr) {
					n.dead = true;
				} else {
					n.x += ~~(dx / thr);
					n.y += ~~(dy / thr);
				}
				core.drawIcon(name, n.id, n.x, n.y, 32, 32);
			});
			self.nodes = self.nodes.filter(function (n) {
				if (n.dead && n.callback) {
					n.callback();
				}
				return !n.dead;
			});
			if (self.nodes.length == 0)
				self.remove();
		}
	}


	var animateHwnd = new attractAnimate();

	this.stopAttractAnimate = function () {
		animateHwnd.clear();
	}

	// 自动拾取控制开关
	this.autoGetItem = function () {
		var canGetItems = {};
		if (intercept() ||
			!core.status.floorId || !core.status.checkBlock.damage || core.status.event.id == 'action' || core.status.lockControl ||
			!core.hasFlag('zdsq')) return;

		bfsFlood(core.getHeroLoc('x'), core.getHeroLoc('y'), function (blockMap, x, y) {
			var idx = x + ',' + y;
			if (idx in canGetItems) return false;
			var blk = blockMap[idx];
			if (blk && !blk.disable && blk.event.cls == 'items' && !core.isMapBlockDisabled(core.status.floorId, blk.x, blk.y) && blk.event.trigger == 'getItem') {
				if (!core.status.checkBlock.damage[idx] && !core.status.checkBlock.ambush[idx])
					canGetItems[idx] = { x: x, y: y, id: blk.event.id };
				return !core.status.checkBlock.damage[idx] && !core.status.checkBlock.ambush[idx];
			}
			return core.maps._canMoveDirectly_checkNextPoint(blockMap, x, y);
		});
		for (var k in canGetItems) {
			var x = canGetItems[k].x,
				y = canGetItems[k].y,
				id = canGetItems[k].id;
			core.trigger(x, y);
			animateHwnd.add(id, x * 32, y * 32);
		}
		animateHwnd.start();
	}

	control.prototype._replayAction_moveDirectly = function (action) {
		if (action.indexOf("move:") != 0) return false;
		// 忽略连续的瞬移事件；如果大地图某一边超过计算范围则不合并
		// if (!core.hasFlag('poison') && core.status.thisMap.width < 2 * core.bigmap.extend + core.__SIZE__
		//     && core.status.thisMap.height < 2 * core.bigmap.extend + core.__SIZE__) {
		//     while (core.status.replay.toReplay.length>0 &&
		//         core.status.replay.toReplay[0].indexOf('move:')==0) {
		//             core.status.route.push(action);
		//             action = core.status.replay.toReplay.shift();
		//     }
		// }

		var pos = action.substring(5).split(":");
		var x = parseInt(pos[0]),
			y = parseInt(pos[1]);
		var nowx = core.getHeroLoc('x'),
			nowy = core.getHeroLoc('y');
		var ignoreSteps = core.canMoveDirectly(x, y);
		if (!core.moveDirectly(x, y, ignoreSteps)) return false;
		if (core.status.replay.speed == 24) {
			core.replay();
			return true;
		}

		core.ui.drawArrow('ui', 32 * nowx + 16 - core.bigmap.offsetX, 32 * nowy + 16 - core.bigmap.offsetY,
			32 * x + 16 - core.bigmap.offsetX, 32 * y + 16 - core.bigmap.offsetY, '#FF0000', 3);
		var timeout = this.__replay_getTimeout();
		if (ignoreSteps < 10) timeout = timeout * ignoreSteps / 10;
		setTimeout(function () {
			core.clearMap('ui');
			core.replay();
		}, timeout);
		return true;
	}

	//
	////// 自动清怪 //////
	//

	core.control.registerReplayAction("moveDirectly", core.control._replayAction_moveDirectly);

	//战斗
	core.events.battle = function (id, x, y, force, callback) {
		core.saveAndStopAutomaticRoute();
		id = id || core.getBlockId(x, y);
		if (!id) return core.clearContinueAutomaticRoute(callback);
		// 非强制战斗
		if (!core.enemys.canBattle(id, x, y) && !force && !core.status.event.id) {
			core.stopSound();
			core.playSound('操作失败');
			core.drawTip("你打不过此怪物！", id);
			return core.clearContinueAutomaticRoute(callback);
		}
		// 自动清怪时禁止自动存档
		var need_save = !core.status.event.id && !core.getFlag("disable_autosave2", 0);
		// 自动存档
		if (need_save) core.autosave(true);
		// 战前事件
		if (!this.beforeBattle(id, x, y))
			return core.clearContinueAutomaticRoute(callback);
		// 战后事件
		this.afterBattle(id, x, y);
		core.setFlag("disable_autosave", 0);
		if (callback) callback();
	}


	this.isEnemy = function (x, y) {
		return core.getBlockCls(x, y) === 'enemys' || core.getBlockCls(x, y) === 'enemy48';
	}

	// 战斗控制开关
	this.autoBattle = function () {
		if (intercept() ||
			/*core.status.floorId === 'MT2' ||
			core.hasItem('I361') || core.hasItem('I363') ||*/
			!core.hasFlag('autoBattle')) return;
		var canBattleEnemys = {};
		var index_list = []; // 保序
		var canBattleFunc = function (block, idx, x, y) {
			var blkid = block ? block.event.id : "";
			var result = block && !block.disable && core.plugin.isEnemy(x, y) && !core.isMapBlockDisabled(core.status.floorId, block.x, block.y) &&
				block.event.trigger == 'battle';
			if (!result) return false;
			var enemy = core.material.enemys[blkid];
			if (core.getDamage(blkid, x, y) == null || core.getDamage(blkid, x, y) > 0) return false;

			// 根据怪物特殊属性排除，可根据自身需求更改
			/*
			if (core.enemys.hasSpecial(blkid, 25) ||
				core.enemys.hasSpecial(blkid, 30) ||
				core.enemys.hasSpecial(blkid, 31) ||
				core.enemys.hasSpecial(blkid, 32) ||
				core.enemys.hasSpecial(blkid, 34) ||
				core.enemys.hasSpecial(blkid, 35) ||
				core.enemys.hasSpecial(blkid, 19) && !core.hasItem('cross')) return false;
			*/

			return true;
		}
		var blockfn = function (blockMap, x, y) {
			var idx = x + ',' + y;
			if (idx in canBattleEnemys) return false;
			var blk = blockMap[idx];

			if (canBattleFunc(blk, idx, x, y)) {
				canBattleEnemys[idx] = { x: x, y: y, id: blk.event.id };
				index_list.push(idx);
				return !core.status.checkBlock.damage[idx] && !core.status.checkBlock.repulse[idx] && !core.status.checkBlock.ambush[idx];
			}
			return core.maps._canMoveDirectly_checkNextPoint(blockMap, x, y);
		};
		if (!core.status.floorId || !core.status.checkBlock.damage || core.status.event.id == 'action' || core.status.lockControl) return;

		// 执行自动清怪
		bfsFlood(core.getHeroLoc('x'), core.getHeroLoc('y'), blockfn);

		// 处理存档
		core.setFlag("disable_autosave2", 1);
		for (var i = 0; i < index_list.length; ++i) {
			var k = index_list[i];
			var x = canBattleEnemys[k].x,
				y = canBattleEnemys[k].y,
				id = canBattleEnemys[k].id;
			if (core.plugin.isEnemy(x, y) && core.getDamage(id, x, y) <= 0) { // double check，比如打了某只暴戾之后本来0伤的怪突然非0了
				core.battle(id, x, y);
			}
		}
		core.setFlag("disable_autosave2", 0);
	}
}
}