var data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d = 
{
	"main": {
		"floorIds": [
			"MT0",
			"MT1",
			"MT2",
			"MT3",
			"MT4",
			"MT5"
		],
		"floorPartitions": [],
		"images": [
			"1.png",
			"bg2.jpeg",
			"brave.png",
			"gege.jpeg",
			"gugu3.jpg",
			"hero.png",
			"winskin.png",
			"xue.png"
		],
		"tilesets": [
			"magictower.png"
		],
		"animates": [
			"hand",
			"sword",
			"zone"
		],
		"bgms": [
			"cv5.mp3"
		],
		"sounds": [
			"1.ogg",
			"aa.mp3",
			"aa_1.mp3",
			"attack.mp3",
			"bing.mp3",
			"bomb.mp3",
			"brave.ogg",
			"cancel.mp3",
			"canjiao.ogg",
			"careful.ogg",
			"centerFly.mp3",
			"come.ogg",
			"confirm.mp3",
			"cursor.mp3",
			"development.mp3",
			"die.ogg",
			"dontUnderstand.ogg",
			"door.mp3",
			"equip.mp3",
			"error.mp3",
			"farWild.mp3",
			"floor.mp3",
			"guaijiao.ogg",
			"isBrave.ogg",
			"item.mp3",
			"jian.ogg",
			"jump.mp3",
			"letMeSeeSee.mp3",
			"load.mp3",
			"manRoar.mp3",
			"mo2.mp3",
			"no.mp3",
			"open_ui.mp3",
			"pickaxe.mp3",
			"recovery.mp3",
			"remember.ogg",
			"save.mp3",
			"screamCutted.mp3",
			"screamWai.ogg",
			"shop.mp3",
			"startDoneDuaLong.mp3",
			"weak.mp3",
			"yanjiang.mp3",
			"youTooWeak.ogg",
			"zhadan2.mp3",
			"zone.mp3"
		],
		"fonts": [],
		"nameMap": {
			"确定": "confirm.mp3",
			"取消": "cancel.mp3",
			"操作失败": "error.mp3",
			"光标移动": "cursor.mp3",
			"打开界面": "open_ui.mp3",
			"读档": "load.mp3",
			"存档": "save.mp3",
			"获得道具": "item.mp3",
			"回血": "recovery.mp3",
			"炸弹": "bomb.mp3",
			"飞行器": "centerFly.mp3",
			"开关门": "door.mp3",
			"上下楼": "floor.mp3",
			"跳跃": "jump.mp3",
			"破墙镐": "pickaxe.mp3",
			"阻激夹域": "zone.mp3",
			"穿脱装备": "equip.mp3",
			"背景音乐": "bgm.mp3",
			"攻击": "attack.mp3",
			"背景图": "bg.jpg",
			"领域": "zone"
		},
		"levelChoose": [
			{
				"title": "咕咕咕（出门攻击+5，血+200）",
				"name": "EXeasy",
				"hard": 0,
				"color": [
					7,
					255,
					0,
					1
				],
				"action": [
					{
						"type": "setValue",
						"name": "status:hp",
						"operator": "+=",
						"value": "2000"
					},
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "5"
					}
				]
			},
			{
				"title": "不咕（出门血加1000）",
				"name": "easy",
				"hard": 1,
				"color": [
					223,
					255,
					0,
					1
				],
				"action": [
					{
						"type": "setValue",
						"name": "status:hp",
						"operator": "+=",
						"value": "1000"
					}
				]
			},
			{
				"title": "咕了",
				"name": "hard",
				"hard": 2,
				"color": [
					188,
					33,
					8,
					1
				],
				"action": []
			}
		],
		"equipName": [
			"武器",
			"盾牌",
			"上衣",
			"腰带",
			"饰品",
			"饰品"
		],
		"startBgm": "cv5.mp3",
		"styles": {
			"startBackground": "project/images/gugu3.jpg",
			"startVerticalBackground": "project/images/gugu3.jpg",
			"startLogoStyle": "color: white",
			"startButtonsStyle": "background-color: #32369F; opacity: 0.85; color: #FFFFFF; border: #FFFFFF 2px solid; caret-color: #FFD700;",
			"statusLeftBackground": "url(project/materials/ground.png) repeat",
			"statusTopBackground": "url(project/materials/ground.png) repeat",
			"toolsBackground": "url(project/materials/ground.png) repeat",
			"floorChangingStyle": "background-color: black; color: white",
			"statusBarColor": [
				232,
				218,
				208,
				1
			],
			"borderColor": [
				22,
				210,
				35,
				1
			],
			"selectColor": [
				255,
				215,
				0,
				1
			],
			"font": "Verdana"
		}
	},
	"firstData": {
		"title": "5层咕咕塔1",
		"name": "5storiesgugu",
		"version": "Ver 1.0",
		"floorId": "MT1",
		"hero": {
			"image": "1.png",
			"animate": false,
			"name": "鸽子",
			"lv": 1,
			"hpmax": 99999999,
			"hp": 100,
			"manamax": 1000,
			"mana": 0,
			"atk": 1,
			"def": 1,
			"mdef": 0,
			"money": 0,
			"exp": 0,
			"equipment": [],
			"items": {
				"constants": {},
				"tools": {},
				"equips": {}
			},
			"loc": {
				"direction": "up",
				"x": 6,
				"y": 8
			},
			"flags": {},
			"followers": [],
			"steps": 0
		},
		"startCanvas": [
			{
				"type": "comment",
				"text": "在这里可以用事件来自定义绘制标题界面的背景图等"
			},
			{
				"type": "comment",
				"text": "也可以直接切换到其他楼层（比如某个开始剧情楼层）进行操作。"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 0,
						"y": 0,
						"width": "core.__PIXELS__",
						"height": "core.__PIXELS__",
						"style": [
							82,
							82,
							82,
							1
						]
					},
					{
						"type": "setAttribute",
						"align": "center"
					},
					{
						"type": "fillBoldText",
						"x": "core.__PIXELS__ / 2",
						"y": 80,
						"style": [
							255,
							255,
							255,
							1
						],
						"strokeStyle": [
							0,
							0,
							0,
							1
						],
						"font": "bold 40px Verdana",
						"text": "${core.firstData.title}"
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "0"
			},
			{
				"type": "comment",
				"text": "在右下方自绘一个对话框进行显示选择项"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							50,
							54,
							159,
							0.85
						]
					},
					{
						"type": "strokeRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							255,
							255,
							255,
							1
						],
						"lineWidth": 2
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 290,
						"style": [
							255,
							255,
							255,
							1
						],
						"font": "bold 25px Verdana",
						"text": "开始游戏"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 330,
						"font": "bold 25px Verdana",
						"text": "读取存档"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 370,
						"font": "bold 25px Verdana",
						"text": "回放录像"
					}
				]
			},
			{
				"type": "while",
				"condition": "1",
				"data": [
					{
						"type": "drawSelector",
						"image": "winskin.png",
						"code": 1,
						"x": 245,
						"y": "261 + 40*flag:selection",
						"width": 120,
						"height": 40
					},
					{
						"type": "wait",
						"data": [
							{
								"case": "keyboard",
								"keycode": "13,32",
								"break": true,
								"action": [
									{
										"type": "switch",
										"condition": "flag:selection",
										"caseList": [
											{
												"case": "0",
												"action": [
													{
														"type": "comment",
														"text": "在“开始游戏”确定"
													},
													{
														"type": "break",
														"n": 1
													}
												]
											},
											{
												"case": "1",
												"action": [
													{
														"type": "comment",
														"text": "在“读取存档”确定"
													},
													{
														"type": "callLoad"
													}
												]
											},
											{
												"case": "2",
												"action": [
													{
														"type": "comment",
														"text": "在“回放录像”确定"
													},
													{
														"type": "if",
														"condition": "(!core.isReplaying())",
														"true": [
															{
																"type": "function",
																"function": "function(){\ncore.chooseReplayFile()\n}"
															}
														]
													}
												]
											}
										]
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "38",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标上键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 2) % 3"
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "40",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标下键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 1) % 3"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									261,
									300
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“开始游戏”"
									},
									{
										"type": "break",
										"n": 1
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									301,
									340
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“读取存档”"
									},
									{
										"type": "callLoad"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									341,
									380
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“播放录像”"
									},
									{
										"type": "if",
										"condition": "(!core.isReplaying())",
										"true": [
											{
												"type": "function",
												"function": "function(){\ncore.chooseReplayFile()\n}"
											}
										]
									}
								]
							}
						]
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "null"
			},
			{
				"type": "drawSelector",
				"code": 1
			},
			{
				"type": "clearMap"
			},
			{
				"type": "function",
				"function": "function(){\ncore.control.checkBgm()\n}"
			},
			{
				"type": "if",
				"condition": "(main.levelChoose.length == 0)",
				"true": [
					{
						"type": "comment",
						"text": "没有难度选择：直接开始游戏"
					}
				],
				"false": [
					{
						"type": "comment",
						"text": "难度选择：作为样例，这里只提供了一个显示选择项。"
					},
					{
						"type": "function",
						"function": "function(){\nvar choices = [];\nmain.levelChoose.forEach(function (one) {\n\tchoices.push({\n\t\t\"text\": one.title || '',\n\t\t\"action\": [\n\t\t\t{ \"type\": \"function\", \"function\": \"function() { core.status.hard = '\" + (one.name || '') + \"'; }\" }\n\t\t]\n\t});\n})\ncore.insertAction({ \"type\": \"choices\", \"choices\": choices });\n}"
					},
					{
						"type": "comment",
						"text": "你也可以仿照上面的样例进行自己创建等待用户操作来处理不同的难度分歧。\n如需自己处理，请设置 core.status.hard \n（例如，自定义js脚本：core.status.hard = 'Easy' ）"
					}
				]
			},
			{
				"type": "clearMap"
			},
			{
				"type": "comment",
				"text": "接下来会执行startText中的事件"
			},
			{
				"type": "comment",
				"text": "状态栏默认处于隐藏状态；可以使用“显示状态栏”事件进行显示。"
			}
		],
		"startText": [
			"累累看到站桩神的5层塔有感而发学做5层的塔。",
			"此塔很简单，轻松夺蚌没问题！",
			{
				"type": "playSound",
				"name": "item.mp3"
			},
			{
				"type": "playSound",
				"name": "item.mp3"
			}
		],
		"shops": [
			{
				"id": "thief",
				"text": "\t[商贩,thief]给我${20+1*flag:shop1}金币就可以：",
				"textInList": "4F金币商店",
				"mustEnable": false,
				"disablePreview": false,
				"choices": [
					{
						"text": "攻击+2",
						"need": "status:money>=20+1*flag:shop1",
						"color": [
							95,
							238,
							153,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "20+1*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:atk",
								"operator": "+=",
								"value": "2"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "防御+3",
						"need": "status:money>=20+1*flag:shop1",
						"color": [
							255,
							215,
							0,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "20+1*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:def",
								"operator": "+=",
								"value": "3"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "护盾+50，生命+125",
						"need": "status:money>=20+1*flag:shop1",
						"color": [
							171,
							35,
							233,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "20+1*flag:shop1"
							},
							{
								"type": "setValue",
								"name": "flag:shop1",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "125"
							},
							{
								"type": "setValue",
								"name": "status:mdef",
								"operator": "+=",
								"value": "50"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					}
				]
			},
			{
				"id": "youngMan",
				"text": "\t[尸魂商店,N403]给我${30+1*flag:shop2}金币就可以：",
				"textInList": "29F恶魔金币商店",
				"mustEnable": false,
				"disablePreview": false,
				"choices": [
					{
						"text": "攻击+7",
						"need": "status:money>=30+1*flag:shop2",
						"color": [
							228,
							193,
							7,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "30+1*flag:shop2"
							},
							{
								"type": "setValue",
								"name": "flag:shop2",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:atk",
								"operator": "+=",
								"value": "7"
							}
						]
					},
					{
						"text": "护盾+155，生命+555",
						"need": "status:money>=30+1*flag:shop2",
						"color": [
							98,
							220,
							211,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "30+1*flag:shop2"
							},
							{
								"type": "setValue",
								"name": "flag:shop2",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:mdef",
								"operator": "+=",
								"value": "155"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "555"
							}
						]
					},
					{
						"text": "防御+12",
						"need": "status:money>=30+1*flag:shop2",
						"color": [
							222,
							58,
							154,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "30+1*flag:shop2"
							},
							{
								"type": "setValue",
								"name": "flag:shop2",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:def",
								"operator": "+=",
								"value": "12"
							}
						]
					}
				]
			},
			{
				"id": "fairy",
				"text": "\t[精灵,fairy]给我足够的魔力来兑换你要的道具，同时供参考道具价值",
				"textInList": "27层道具商店",
				"mustEnable": false,
				"disablePreview": false,
				"choices": [
					{
						"text": "黄钥匙+1(消耗魔力10)",
						"need": "status:mana>=10",
						"color": [
							95,
							238,
							153,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:mana",
								"operator": "-=",
								"value": "10"
							},
							{
								"type": "setValue",
								"name": "item:yellowKey",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3",
								"sync": true
							}
						]
					},
					{
						"text": "蓝钥匙+1(消耗魔力25)",
						"need": "status:mana>=25",
						"color": [
							255,
							215,
							0,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:mana",
								"operator": "-=",
								"value": "25"
							},
							{
								"type": "setValue",
								"name": "item:blueKey",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "红钥匙+1(消耗魔力65)",
						"need": "status:mana>=65",
						"color": [
							236,
							110,
							239,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:mana",
								"operator": "-=",
								"value": "65"
							},
							{
								"type": "setValue",
								"name": "item:redKey",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "铁门钥匙+1(消耗魔力28)",
						"need": "status:mana>=28",
						"color": [
							235,
							56,
							144,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:mana",
								"operator": "-=",
								"value": "28"
							},
							{
								"type": "setValue",
								"name": "item:steelKey",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "破墙镐+1(消耗魔力33)",
						"need": "status:mana>=33",
						"color": [
							163,
							221,
							51,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:mana",
								"operator": "-=",
								"value": "33"
							},
							{
								"type": "setValue",
								"name": "item:pickaxe",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "炸弹(消耗魔力30)",
						"need": "status:mana>=30",
						"color": [
							63,
							159,
							239,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:mana",
								"operator": "-=",
								"value": "30"
							},
							{
								"type": "setValue",
								"name": "item:bomb",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "对称飞行器(消耗魔力30)",
						"need": "status:mana>=30",
						"color": [
							124,
							133,
							75,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:mana",
								"operator": "-=",
								"value": "30"
							},
							{
								"type": "setValue",
								"name": "item:centerFly",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "破冰镐(消耗魔力50)",
						"need": "status:mana>=50",
						"color": [
							111,
							220,
							195,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:mana",
								"operator": "-=",
								"value": "50"
							},
							{
								"type": "setValue",
								"name": "item:icePickaxe",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "熔岩镐(消耗魔力50)",
						"need": "status:mana>=50",
						"color": [
							109,
							24,
							213,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:mana",
								"operator": "-=",
								"value": "50"
							},
							{
								"type": "setValue",
								"name": "item:freezeBadge",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "紫门钥匙等于80魔力",
						"need": "status:mana>=80",
						"color": [
							215,
							81,
							20,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							}
						]
					}
				]
			},
			{
				"id": "shop5",
				"text": "\t[钥匙商人,thief]给我一定的生命就可以获得资源：",
				"textInList": "11楼钥匙商人",
				"mustEnable": true,
				"disablePreview": false,
				"choices": [
					{
						"text": "一把黄钥匙（消耗${200+450*flag:shop5}的生命）",
						"need": "status:hp>=200+450*flag:shop5",
						"color": [
							238,
							238,
							95,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "-=",
								"value": "200+450*flag:shop5"
							},
							{
								"type": "setValue",
								"name": "flag:shop5",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "item:yellowKey",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "一把蓝钥匙（减少${600+1350*flag:shop5}的生命）",
						"need": "status:hp>=600+1350*flag:shop5",
						"color": [
							38,
							0,
							255,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "-=",
								"value": "600+1350*flag:shop5"
							},
							{
								"type": "setValue",
								"name": "flag:shop5",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "item:blueKey",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "一把铁门钥匙（减少${700+1500*flag:shop5}的生命）",
						"need": "status:hp>=700+1500*flag:shop5",
						"color": [
							175,
							156,
							134,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "-=",
								"value": "700+1500*flag:shop5"
							},
							{
								"type": "setValue",
								"name": "flag:shop5",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "item:steelKey",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					}
				]
			},
			{
				"id": "shop6",
				"text": "\t[神秘长者,man]给我一定的资源就可以续命，当然要付出点代价：",
				"textInList": "11楼续命长者",
				"mustEnable": true,
				"disablePreview": false,
				"choices": [
					{
						"text": "给一个破墙镐（增加${3000-150*flag:shop6}的生命）",
						"need": "item:pickaxe>=1",
						"color": [
							21,
							255,
							0,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "3000-150*flag:shop6"
							},
							{
								"type": "setValue",
								"name": "flag:shop6",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "item:pickaxe",
								"operator": "-=",
								"value": "1"
							}
						]
					},
					{
						"text": "给一个冰冻徽章（增加${3700-180*flag:shop6}的生命）",
						"need": "item:freezeBadge>=1",
						"color": [
							255,
							0,
							47,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "3700-180*flag:shop6"
							},
							{
								"type": "setValue",
								"name": "flag:shop6",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "item:freezeBadge",
								"operator": "-=",
								"value": "1"
							}
						]
					},
					{
						"text": "给一把破冰镐（增加${4000-200*flag:shop6}的生命）",
						"need": "item:icePickaxe>=1",
						"color": [
							38,
							0,
							255,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "4000-200*flag:shop6"
							},
							{
								"type": "setValue",
								"name": "flag:shop6",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "item:icePickaxe",
								"operator": "-=",
								"value": "1"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							}
						]
					},
					{
						"text": "给一个中心对称飞行器（增加${2800-50*flag:shop6}的生命）",
						"need": "item:centerFly>=1",
						"color": [
							23,
							183,
							229,
							1
						],
						"action": [
							{
								"type": "comment",
								"text": "新版商店中需要手动扣减金币和增加访问次数"
							},
							{
								"type": "playSound",
								"name": "item.mp3"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "2800-50*flag:shop6"
							},
							{
								"type": "setValue",
								"name": "flag:shop6",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "item:steelKey",
								"operator": "+=",
								"value": "1"
							}
						]
					}
				]
			}
		],
		"levelUp": [
			{
				"need": "0",
				"title": "",
				"action": [
					{
						"type": "comment",
						"text": "此处是初始等级，只需填写称号"
					}
				]
			},
			{
				"need": "16",
				"title": "初变咕咕",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "2"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "2"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"operator": "+=",
						"value": "4"
					},
					{
						"type": "playSound",
						"name": "recovery.mp3"
					},
					"升级了，攻防+2，盾+4"
				]
			},
			{
				"need": "27",
				"title": "足月咕咕",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "3"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "3"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"operator": "+=",
						"value": "8"
					},
					{
						"type": "setValue",
						"name": "status:hp",
						"operator": "+=",
						"value": "500"
					},
					{
						"type": "playSound",
						"name": "recovery.mp3"
					},
					"升级了，攻防+3，盾+8，生命+500"
				]
			},
			{
				"need": "88",
				"title": "半岁咕咕",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "5"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "5"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"operator": "+=",
						"value": "20"
					},
					{
						"type": "playSound",
						"name": "recovery.mp3"
					},
					"攻防+5，盾+20"
				]
			},
			{
				"need": "160",
				"title": "砂眼咕咕",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "10"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "10"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"operator": "+=",
						"value": "40"
					},
					{
						"type": "playSound",
						"name": "recovery.mp3"
					},
					"攻防+10，盾+40"
				]
			},
			{
				"need": "300",
				"title": "黄眼咕咕",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "20"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "20"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"operator": "+=",
						"value": "80"
					},
					{
						"type": "playSound",
						"name": "recovery.mp3"
					},
					"攻防+20，盾+80"
				]
			},
			{
				"need": "450",
				"title": "牛眼咕咕",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "40"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "40"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"operator": "+=",
						"value": "160"
					},
					{
						"type": "playSound",
						"name": "recovery.mp3"
					},
					"攻防+40，盾+160"
				]
			},
			{
				"need": "622",
				"title": "凤彩咕咕",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "70"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "70"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"operator": "+=",
						"value": "400"
					},
					{
						"type": "playSound",
						"name": "recovery.mp3"
					},
					"攻防+70，盾+400"
				]
			},
			{
				"need": "782",
				"title": "神之游龙",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "150"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "150"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"operator": "+=",
						"value": "1000"
					},
					{
						"type": "playSound",
						"name": "recovery.mp3"
					},
					"攻防+150，盾+1000"
				]
			},
			{
				"need": "950",
				"title": "神之帝皇",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "300"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "300"
					},
					{
						"type": "setValue",
						"name": "status:mdef",
						"operator": "+=",
						"value": "2000"
					},
					{
						"type": "playSound",
						"name": "recovery.mp3"
					},
					"攻防+300，盾+2000"
				]
			}
		]
	},
	"values": {
		"lavaDamage": 100,
		"poisonDamage": 25,
		"weakValue": 20,
		"redGem": 1,
		"blueGem": 1,
		"greenGem": 2,
		"redPotion": 50,
		"bluePotion": 200,
		"yellowPotion": 500,
		"greenPotion": 800,
		"breakArmor": 0.8,
		"counterAttack": 0.15,
		"purify": 1,
		"hatred": 2,
		"animateSpeed": 400,
		"statusCanvasRowsOnMobile": 3,
		"floorChangeTime": 500
	},
	"flags": {
		"statusBarItems": [
			"enableFloor",
			"enableLv",
			"enableHP",
			"enableMana",
			"enableAtk",
			"enableDef",
			"enableMDef",
			"enableMoney",
			"enableLevelUp",
			"levelUpLeftMode",
			"enableKeys",
			"enablePZF"
		],
		"flyNearStair": true,
		"flyRecordPosition": false,
		"steelDoorWithoutKey": false,
		"itemFirstText": true,
		"equipboxButton": false,
		"enableAddPoint": false,
		"enableNegativeDamage": false,
		"betweenAttackMax": true,
		"useLoop": false,
		"startUsingCanvas": false,
		"statusCanvas": false,
		"enableEnemyPoint": true,
		"displayEnemyDamage": true,
		"displayCritical": true,
		"displayExtraDamage": true,
		"enableGentleClick": true,
		"ignoreChangeFloor": true,
		"canGoDeadZone": true,
		"enableMoveDirectly": true,
		"enableRouteFolding": true,
		"disableShopOnDamage": false,
		"blurFg": false
	}
}