import { isNil } from 'lodash-es';
import { IDamageEnemy } from '@motajs/types';

export interface CurrentEnemy {
    enemy: IDamageEnemy;
    // 这个是干啥的？
    onMapEnemy: IDamageEnemy[];
}

export interface ToShowEnemy extends CurrentEnemy {
    critical: string;
    criticalDam: string;
    defDam: string;
    /** [名称, 描述, 颜色] */
    special: [string, string, string][];
    damageColor: string;
    showSpecial: [string, string, string][];
    damage: string;
}

interface BookDetailInfo {
    /** 怪物手册详细信息展示的怪物 */
    enemy?: ToShowEnemy;
    /** 怪物手册的怪物详细信息的初始位置 */
    pos?: number;
}

export const detailInfo: BookDetailInfo = {};

/**
 * 获取怪物的特殊技能描述
 * @param enemy 怪物实例
 */
export function getSpecialHint(enemy: ToShowEnemy) {
    return (
        <div>
            {enemy.special.map((v, i) => {
                return (
                    <div class="special">
                        <span style={{ color: v[2] }}>
                            &nbsp;&nbsp;&nbsp;&nbsp;{v[0]}：
                        </span>
                        <span innerHTML={v[1]}></span>
                    </div>
                );
            })}
        </div>
    );
}

/**
 * 获得怪物的最近100个加防减伤
 * @param enemy 怪物实例
 */
export function getDefDamage(
    enemy: ToShowEnemy,
    addDef: number = 0,
    addAtk: number = 0
) {
    const ratio = core.status.thisMap.ratio;
    const res: [number, number][] = [];

    let origin: number | undefined;
    let last = 0;

    const max = 100 - Math.floor(addDef / ratio);

    for (let i = 0; i <= max; i++) {
        const dam = enemy.enemy.calDamage({
            atk: core.status.hero.atk + addAtk,
            def: core.status.hero.def + addDef + i * ratio
        });

        if (res.length === 0) {
            origin = dam.damage;
            if (!isNil(origin)) {
                res.push([addDef + i * ratio, origin]);
                last = origin;
            }
            continue;
        }
        if (!isFinite(dam.damage)) continue;
        if (dam.damage === res.at(-1)?.[1]) continue;
        last = dam.damage;
        res.push([ratio * i + addDef, dam.damage]);
    }

    return res;
}

/**
 * 获取怪物的临界信息
 * @param enemy 怪物实例
 */
export function getCriticalDamage(
    enemy: ToShowEnemy,
    addAtk: number = 0,
    addDef: number = 0
): [number, number][] {
    const ratio = core.status.thisMap.ratio;
    const res: [number, number][] = [];

    let origin: number | undefined;
    let last = 0;

    const max = 100 - Math.floor(addAtk / ratio);

    for (let i = 0; i <= max; i++) {
        const dam = enemy.enemy.calDamage({
            atk: core.status.hero.atk + addAtk + i * ratio,
            def: core.status.hero.def + addDef
        });

        if (res.length === 0) {
            origin = dam.damage;
            if (!isNil(origin)) {
                res.push([addAtk + i * ratio, origin]);
                last = origin;
            }
            continue;
        }
        if (!isFinite(dam.damage)) continue;
        if (dam.damage === res.at(-1)?.[1]) continue;
        last = dam.damage;
        res.push([ratio * i + addAtk, dam.damage]);
    }

    return res;
}
