var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
"multiHero": function () {
	this.init_hero = function(name, imageName, blockId,x,y,floorId){
		flags.heros = flags.heros || {};
		flags.heros[name] = {
			'img': imageName,
			'block': blockId,
			'x':x,
			'y':y,
			'floorId':floorId,
			"hp": 1000,
			"atk": 100,
			"def": 100,
			"mdef": 0,
			"money": 0,
			"items": {
				"keys": {
					"yellowKey": 0,
					"blueKey": 0,
					"redKey": 0
				},
				"constants": {},
				"tools": {},
				"equips": {}
			},
		};
	}

	this.init_two_hero = function(){
		core.init_hero('hero','hero.png','hero',6,11,'MT1');
		core.init_hero('greenSlime','greenSlime.png','greenSlime',3,1,'MT1');
		flags.heros.greenSlime.hp = 35;
		flags.heros.greenSlime.atk = 18;
		flags.heros.greenSlime.def = 1;
		flags.name = 'hero';
	}

	this.changeHero = function(name){
		var info = flags.heros[name];
		var loc = core.status.hero.loc;
		var cur = flags.heros[flags.name];

		cur.x = loc.x;
		cur.y = loc.y; 
		cur.floorId = core.status.floorId;
		flags.name = name;
		
		for(var k in core.status.hero){
			if(core.isset(info[k])){
				cur[k] = core.clone(core.status.hero[k]);
				core.status.hero[k] = info[k];
			}
		}
		core.setBlock(cur.block, cur.x,cur.y);
		core.removeBlock(info.x,info.y,info.floorId);
		core.setHeroIcon(info.img, true);
		core.changeFloor(info.floorId, null, info, 0, function(){core.replay();});
	}

	this.changeLife = function(name,floorIds){
		name = name || 'greenSlime';
		var dst = null;
		var floorId = null;
		floorIds = floorIds || core.floorIds;
		for(var ff in floorIds){
			floorId = floorIds[ff];
			if(floorId==core.status.floorId){
				var loc = core.status.hero.loc;
				var dis = function(a,b){return (a.x-b.x)*(a.x-b.x)+ (a.y-b.y)*(a.y-b.y)}
				core.status.maps[floorId].blocks.sort(function(blk1,blk2){
					return dis(blk1, loc) - dis(blk2, loc);
				})
			}else {
				core.status.maps[floorId].blocks.sort(function(blk1,blk2){
					return (blk1.y*100+blk1.x) - (blk2.y*100+blk2.x) 
				})
			}

			dst = core.status.maps[floorId].blocks.find(function(b){
				return b.event.id == name;
			});
			if(dst)break;
		}
		if(!dst){
			flags.nolife = true;
			core.drawTip('没有转生对象');
			return false;
		}

		flags.heros[name].x = dst.x;
		flags.heros[name].y = dst.y;
		flags.heros[name].floorId = floorId;
		
		if(flags.name==name){
			if(core.status.hero.hp > 0){
				var loc = core.status.hero.loc;
				core.setBlock(flags.heros[name].block, loc.x, loc.y);
			}
			core.removeBlock(dst.x, dst.y, floorId);
			core.changeFloor(floorId, null, dst, 0);
		}
		return true;
	}

	this.deadSlime = function(){
		if(core.changeLife()){
			core.drawTip('转生成功！');
			if(flags.name=='greenSlime')
				core.status.hero.hp = 35;
			core.updateStatusBar();
		}else{
			core.status.hero.hp = 0;
			core.updateStatusBar();
			core.events.lose('转生失败');
		}
	}
},


"rewrite":function(){
	////// 某个点是否不可通行 //////
	var nameNoPass= {
		'hero':['poisonNet'],
		'greenSlime':['curseNet'],
	};
	var nameName = {
		'hero':'勇士',
		'greenSlime':'史莱姆',
	};
	var dirPortals = {
		'rightPortal': 'leftPortal',
		'leftPortal': 'rightPortal',
		'upPortal': 'downPortal',
		'downPortal': 'upPortal'
	};
	var findBlock = function(id){
		return core.status.thisMap.blocks.find(function(blk){
			return blk.event && blk.event.id == id;
		});
	}
	core.registerSystemEvent('custom', function(data, callback) {
		if(data.x==5 && data.y==10 && core.status.floorId=='MT3'){
			core.insertAction([{"type": "insert", "loc": [0,0], "floorId": "MT3"},]);
			if(callback)callback();
			return;
		}
		if(nameNoPass[flags.name].indexOf(data.event.id)>=0){
			core.drawTip(nameName[flags.name]+'不可通行');
		}
		if(dirPortals[data.event.id]){
			var blk = findBlock(dirPortals[data.event.id]);
			core.insertAction([
				{"type": "changePos", "loc": [blk.x,blk.y]},
			  ]);
		}
		switch(data.event.id){
			case 'switch':
				core.insertAction([
					{"type": "choices", "text": "【说明书】摸我一下，当前层绿网变蓝网，蓝网变绿网。", "choices": [
					  {"text": "使用", "action": [
						{"type": "function", "function": "function(){\ncore.changeNet()\n}"},
					  ]},
					  {"text": "否", "action": [
				  
					  ]},
					]},
				  ]);
				break;
			case 'starPortal':
				core.removeBlock(data.x, data.y);
				if(!findBlock('starPortal')){
					var blk = findBlock('specialDoor');
					core.insertAction([
						{"type": "openDoor", "loc": [blk.x, blk.y]},
					]);
				}
				break;
			default:
				break;
		}
		if(callback)callback();
	});

	this.changeNet = function(){
		var blks1 = core.status.thisMap.blocks.filter(function(blk){
			return blk.event.id == 'poisonNet';
		});
		var blks2 = core.status.thisMap.blocks.filter(function(blk){
			return blk.event.id == 'curseNet';
		});
		var id1 = 12,  ids1 = 'poisonNet';
		var id2 = 14,  ids2 = 'curseNet';
		blks1.forEach(function(blk){
			blk.id = id2; blk.event.id = ids2;
		})
		blks2.forEach(function(blk){
			blk.id = id1; blk.event.id = ids1;
		})
		core.drawMap();
	}

	this.checkFlower = function(){
		var loc = core.status.hero.loc;
		var f = core.status.floorId;
		var map = core.floors[f].bgmap;
		var x = loc.x, y = loc.y;
		if(map[y] && map[y][x] == 168){
			flags[f+'_s'] = flags[f+'_s'] || {};
			var evt = core.floors[f].afterGetItem[x+','+y];
			if(evt){
				var b = evt[0].split(',');
				b = (core.getBlock(parseInt(b[0]), parseInt(b[1]))||{}).block;
			}else {
				var b = findBlock('steelDoor');
			}
			if(b){
				flags[f+'_s'][x+','+y] = {x:b.x, y:b.y};
				core.insertAction([
					{"type": "openDoor", "loc": [b.x,b.y]},
				  ]);
			}else if(Object.keys(flags[f+'_s']).length>0){
				flags[f+'_s'][x+','+y] = core.clone(flags[f+'_s'][Object.keys(flags[f+'_s'])[0]]);
			}
		}
		if(flags[f+'_s']){
			var flws = flags[f+'_s'];
			var bloc = [];
			var still = {};
			for(var k in flws){
				var flw = flws[k];
				var pos = k.split(',');
				var px = parseInt(pos[0]), py = parseInt(pos[1]);
				if((loc.x != px || loc.y != py) && !core.getBlock(px, py)){
					bloc.push({x:flw.x, y:flw.y});
					delete flws[k];
				}else {
					still[px+','+py] = true;
				}
			}
			bloc.forEach(function(b) {
				if(core.getBlock(b.x, b.y)){
					flws[b.x+','+b.y] = {x:b.x, y:b.y};
				}else if(!still[b.x+','+b.y]){
					core.insertAction([
						{"type": "closeDoor", "id": "steelDoor", "loc": [b.x, b.y]},
					  ]);
				}

			})
		}
	}


	maps.prototype.noPass = function (x, y, floorId) {
		var block = core.getBlock(x, y, floorId);
		if (block == null) return false;
		if(block.block.event.trigger=='custom' && nameNoPass[flags.name].indexOf(block.block.event.id)>=0){
			return true;
		}
		return block.block.event.noPass;
	}
	////// 能否获胜 //////
	enemys.prototype.canBattle = function (enemy, x, y, floorId) {
		if (typeof enemy == 'string') enemy = core.material.enemys[enemy];
		var damage = this.getDamage(enemy, x, y, floorId);
		return damage != null && damage < core.status.hero.hp;  // || flags.name=='greenSlime';
	}


	////// 点击状态栏中的虚拟键盘时 //////
	main.statusBar.image.keyboard.onclick = function (e) {
		e.stopPropagation();
		if (core.isReplaying()) {
			core.bookReplay();
			return;
		}
		if (main.core.isPlaying()){	
			core.keyUp(87);
		}
	}


	////// 实际进行存读档事件 //////
	control.prototype.doSL = function (id, type) {
		if(core.hasFlag('noSL')){
			core.drawTip('未知错误！');
			return;
		}
		switch (type) {
			case 'save': this._doSL_save(id); break;
			case 'load': this._doSL_load(id, this._doSL_load_afterGet); break;
			case 'replayLoad': this._doSL_load(id, this._doSL_replayLoad_afterGet); break;
			case 'replayRemain': this._doSL_load(id, this._doSL_replayRemain_afterGet); break;
		}
	}


}
}