# 第一章：伤害计算函数（getDamageInfo）

要求：读懂脚本编辑 - 伤害计算函数（getDamageInfo）的全部脚本代码（无需理解支援的实现）。

回答如下几个问题：

1. 如下几个局部变量分别是什么意义？

    `mon_atk`, `init_damage`, `per_damage`, `hero_per_damage`, `turn`, `damage`

2. 如何理解下面这几句话？

    `if (core.hasSpecial(mon_special, 2)) per_damage = mon_atk;`  

    `var turn = Math.ceil(mon_hp / hero_per_damage);`  
    
    `var damage = init_damage + (turn - 1) * per_damage + turn * counterDamage;`

3. 负伤在哪里实现的？

依次实现如下几个怪物属性（仅允许修改`getDamageInfo`函数）：

1. **闪避（编号31）：** 受到伤害降低40%。

2. **穿刺（编号32）：** 无视角色70%防御力。

3. **冰冻（编号33）：** 怪物首先冰冻角色3回合，冰冻期间每回合额外造成角色护盾的20%伤害。

4. **中子束（编号34）：** 每回合普攻两次，魔攻一次。

5. **残暴斩杀（编号35）：** 战斗开始时，如果角色血量不大于怪物血量的200%，则直接暴毙。

6. **窥血为攻（编号36）：** 战斗开始时，自身攻击力变为角色当前生命值的10%，向下取整。

7. **匙之力（编号37）：** 角色身上每存在一把黄钥匙，最终伤害提升5%；蓝钥匙视为三把黄钥匙，红钥匙视为九把黄钥匙，线性叠加。

8. **崩甲（编号38）：** 怪物每回合附加勇士战斗开始时的护盾数值的0.1倍作为伤害。

9. **混乱（编号39）：** 战斗中，勇士攻防互换。

10. **强击（编号40）：** 怪物第一回合三倍攻击。

11. **暗影庇护（编号41）：** 处于无敌状态，但每回合损耗自身2%的最大生命值。

再依次实现如下几个角色技能：

1. 角色每回合回复`flag:x1`%倍护盾的生命值。（如，`flag:x1`是10时，每回合回复10%护盾值的生命）

2. 角色每回合造成和受到的伤害均提升`flag:x2`%。（如，`flag:x2`为10时，每回合造成和受到伤害都提升10%）

3. 角色攻击在战斗时减少`flag:x3`，防御力增加`flag:x3`。

4. 角色无视怪物的`flag:x4`%的防御力。（如，`flag:x4`是10时，无视怪物的10%防御力）

5. 角色额外抢攻`flag:x5`回合。

[点此查看答案](L1_answer)
