var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。

	this.loadCss = function (href) {
		var style = document.createElement('link');
		style.type = 'text/css';
		style.href = href;
		style.rel = 'stylesheet';
		document.getElementsByTagName('head')[0].appendChild(style);
	}
	if (core.platform.isPC && main.mode == 'play') {
		core.plugin.loadCss('stars.css');
	}

	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作。
		// 若需要进行切分图片，可以使用 core.splitImage() 函数，或直接在全塔属性-图片切分中操作
	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "shop": function () {
	// 【全局商店】相关的功能
	// 
	// 打开一个全局商店
	// shopId：要打开的商店id；noRoute：是否不计入录像
	this.openShop = function (shopId, noRoute) {
		var shop = core.status.shops[shopId];
		// Step 1: 检查能否打开此商店
		if (!this.canOpenShop(shopId)) {
			core.drawTip("该商店尚未开启");
			return false;
		}

		// Step 2: （如有必要）记录打开商店的脚本事件
		if (!noRoute) {
			core.status.route.push("shop:" + shopId);
		}

		// Step 3: 检查道具商店 or 公共事件
		if (shop.item) {
			if (core.openItemShop) {
				core.openItemShop(shopId);
			} else {
				core.playSound('操作失败');
				core.insertAction("道具商店插件不存在！请检查是否存在该插件！");
			}
			return;
		}
		if (shop.commonEvent) {
			core.insertCommonEvent(shop.commonEvent, shop.args);
			return;
		}

		_shouldProcessKeyUp = true;

		// Step 4: 执行标准公共商店    
		core.insertAction(this._convertShop(shop));
		return true;
	}

	////// 将一个全局商店转变成可预览的公共事件 //////
	this._convertShop = function (shop) {
		return [
			{ "type": "function", "function": "function() {core.addFlag('@temp@shop', 1);}" },
			{
				"type": "while",
				"condition": "true",
				"data": [
					// 检测能否访问该商店
					{
						"type": "if",
						"condition": "core.isShopVisited('" + shop.id + "')",
						"true": [
							// 可以访问，直接插入执行效果
							{ "type": "function", "function": "function() { core.plugin._convertShop_replaceChoices('" + shop.id + "', false) }" },
						],
						"false": [
							// 不能访问的情况下：检测能否预览
							{
								"type": "if",
								"condition": shop.disablePreview,
								"true": [
									// 不可预览，提示并退出
									{ "type": "playSound", "name": "操作失败" },
									"当前无法访问该商店！",
									{ "type": "break" },
								],
								"false": [
									// 可以预览：将商店全部内容进行替换
									{ "type": "tip", "text": "当前处于预览模式，不可购买" },
									{ "type": "function", "function": "function() { core.plugin._convertShop_replaceChoices('" + shop.id + "', true) }" },
								]
							}
						]
					}
				]
			},
			{ "type": "function", "function": "function() {core.addFlag('@temp@shop', -1);}" }
		];
	}

	this._convertShop_replaceChoices = function (shopId, previewMode) {
		var shop = core.status.shops[shopId];
		var choices = (shop.choices || []).filter(function (choice) {
			if (choice.condition == null || choice.condition == '') return true;
			try { return core.calValue(choice.condition); } catch (e) { return true; }
		}).map(function (choice) {
			var ableToBuy = core.calValue(choice.need);
			return {
				"text": choice.text,
				"icon": choice.icon,
				"color": ableToBuy && !previewMode ? choice.color : [153, 153, 153, 1],
				"action": ableToBuy && !previewMode ? [{ "type": "playSound", "name": "商店" }].concat(choice.action) : [
					{ "type": "playSound", "name": "操作失败" },
					{ "type": "tip", "text": previewMode ? "预览模式下不可购买" : "购买条件不足" }
				]
			};
		}).concat({ "text": "离开", "action": [{ "type": "playSound", "name": "取消" }, { "type": "break" }] });
		core.insertAction({ "type": "choices", "text": shop.text, "choices": choices });
	}

	/// 是否访问过某个快捷商店
	this.isShopVisited = function (id) {
		if (!core.hasFlag("__shops__")) core.setFlag("__shops__", {});
		var shops = core.getFlag("__shops__");
		if (!shops[id]) shops[id] = {};
		return shops[id].visited;
	}

	/// 当前应当显示的快捷商店列表
	this.listShopIds = function () {
		return Object.keys(core.status.shops).filter(function (id) {
			return core.isShopVisited(id) || !core.status.shops[id].mustEnable;
		});
	}

	/// 是否能够打开某个商店
	this.canOpenShop = function (id) {
		if (this.isShopVisited(id)) return true;
		var shop = core.status.shops[id];
		if (shop.item || shop.commonEvent || shop.mustEnable) return false;
		return true;
	}

	/// 启用或禁用某个快捷商店
	this.setShopVisited = function (id, visited) {
		if (!core.hasFlag("__shops__")) core.setFlag("__shops__", {});
		var shops = core.getFlag("__shops__");
		if (!shops[id]) shops[id] = {};
		if (visited) shops[id].visited = true;
		else delete shops[id].visited;
	}

	/// 能否使用快捷商店
	this.canUseQuickShop = function (id) {
		// 如果返回一个字符串，表示不能，字符串为不能使用的提示
		// 返回null代表可以使用

		// 检查当前楼层的canUseQuickShop选项是否为false
		if (core.status.thisMap.canUseQuickShop === false)
			return '当前楼层不能使用快捷商店。';
		return null;
	}

	var _shouldProcessKeyUp = true;

	/// 允许商店X键退出
	core.registerAction('keyUp', 'shops', function (keycode) {
		if (!core.status.lockControl || core.status.event.id != 'action') return false;
		if ((keycode == 13 || keycode == 32) && !_shouldProcessKeyUp) {
			_shouldProcessKeyUp = true;
			return true;
		}

		if (!core.hasFlag("@temp@shop") || core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (keycode == 88 || keycode == 27) { // X, ESC
			core.actions._clickAction(core.actions.HSIZE, topIndex + choices.length - 1);
			return true;
		}
		return false;
	}, 60);

	/// 允许长按空格或回车连续执行操作
	core.registerAction('keyDown', 'shops', function (keycode) {
		if (!core.status.lockControl || !core.hasFlag("@temp@shop") || core.status.event.id != 'action') return false;
		if (core.status.event.data.type != 'choices') return false;
		core.status.onShopLongDown = true;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (keycode == 13 || keycode == 32) { // Space, Enter
			core.actions._clickAction(core.actions.HSIZE, topIndex + core.status.event.selection);
			_shouldProcessKeyUp = false;
			return true;
		}
		return false;
	}, 60);

	// 允许长按屏幕连续执行操作
	core.registerAction('longClick', 'shops', function (x, y, px, py) {
		if (!core.status.lockControl || !core.hasFlag("@temp@shop") || core.status.event.id != 'action') return false;
		if (core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (x >= core.actions.CHOICES_LEFT && x <= core.actions.CHOICES_RIGHT && y >= topIndex && y < topIndex + choices.length) {
			core.actions._clickAction(x, y);
			return true;
		}
		return false;
	}, 60);
},
    "removeMap": function () {
		// 高层塔砍层插件，删除后不会存入存档，不可浏览地图也不可飞到。
		// 推荐用法：
		// 对于超高层或分区域塔，当在1区时将2区以后的地图删除；1区结束时恢复2区，进二区时删除1区地图，以此类推
		// 这样可以大幅减少存档空间，以及加快存读档速度

		// 删除楼层
		// core.removeMaps("MT1", "MT300") 删除MT1~MT300之间的全部层
		// core.removeMaps("MT10") 只删除MT10层
		this.removeMaps = function (fromId, toId) {
			toId = toId || fromId;
			var fromIndex = core.floorIds.indexOf(fromId),
				toIndex = core.floorIds.indexOf(toId);
			if (toIndex < 0) toIndex = core.floorIds.length - 1;
			flags.__visited__ = flags.__visited__ || {};
			flags.__removed__ = flags.__removed__ || [];
			flags.__disabled__ = flags.__disabled__ || {};
			flags.__leaveLoc__ = flags.__leaveLoc__ || {};
			for (var i = fromIndex; i <= toIndex; ++i) {
				var floorId = core.floorIds[i];
				if (core.status.maps[floorId].deleted) continue;
				delete flags.__visited__[floorId];
				flags.__removed__.push(floorId);
				delete flags.__disabled__[floorId];
				delete flags.__leaveLoc__[floorId];
				(core.status.autoEvents || []).forEach(function (event) {
					if (event.floorId == floorId && event.currentFloor) {
						core.autoEventExecuting(event.symbol, false);
						core.autoEventExecuted(event.symbol, false);
					}
				});
				core.status.maps[floorId].deleted = true;
				core.status.maps[floorId].canFlyTo = false;
				core.status.maps[floorId].canFlyFrom = false;
				core.status.maps[floorId].cannotViewMap = true;
			}
		}

		// 恢复楼层
		// core.resumeMaps("MT1", "MT300") 恢复MT1~MT300之间的全部层
		// core.resumeMaps("MT10") 只恢复MT10层
		this.resumeMaps = function (fromId, toId) {
			toId = toId || fromId;
			var fromIndex = core.floorIds.indexOf(fromId),
				toIndex = core.floorIds.indexOf(toId);
			if (toIndex < 0) toIndex = core.floorIds.length - 1;
			flags.__removed__ = flags.__removed__ || [];
			for (var i = fromIndex; i <= toIndex; ++i) {
				var floorId = core.floorIds[i];
				if (!core.status.maps[floorId].deleted) continue;
				flags.__removed__ = flags.__removed__.filter(function (f) { return f != floorId; });
				core.status.maps[floorId] = core.loadFloor(floorId);
			}
		}

		// 分区砍层相关
		var inAnyPartition = function (floorId) {
			var inPartition = false;
			(core.floorPartitions || []).forEach(function (floor) {
				var fromIndex = core.floorIds.indexOf(floor[0]);
				var toIndex = core.floorIds.indexOf(floor[1]);
				var index = core.floorIds.indexOf(floorId);
				if (fromIndex < 0 || index < 0) return;
				if (toIndex < 0) toIndex = core.floorIds.length - 1;
				if (index >= fromIndex && index <= toIndex) inPartition = true;
			});
			return inPartition;
		}

		// 分区砍层
		this.autoRemoveMaps = function (floorId) {
			if (main.mode != 'play' || !inAnyPartition(floorId)) return;
			// 根据分区信息自动砍层与恢复
			(core.floorPartitions || []).forEach(function (floor) {
				var fromIndex = core.floorIds.indexOf(floor[0]);
				var toIndex = core.floorIds.indexOf(floor[1]);
				var index = core.floorIds.indexOf(floorId);
				if (fromIndex < 0 || index < 0) return;
				if (toIndex < 0) toIndex = core.floorIds.length - 1;
				if (index >= fromIndex && index <= toIndex) {
					core.resumeMaps(core.floorIds[fromIndex], core.floorIds[toIndex]);
				} else {
					core.removeMaps(core.floorIds[fromIndex], core.floorIds[toIndex]);
				}
			});
		}
	},
    "fiveLayers": function () {
	// 是否启用五图层（增加背景2层和前景2层） 将__enable置为true即会启用；启用后请保存后刷新编辑器
	// 背景层2将会覆盖背景层 被事件层覆盖 前景层2将会覆盖前景层
	// 另外 请注意加入两个新图层 会让大地图的性能降低一些
	// 插件作者：ad
	var __enable = false;
	if (!__enable) return;

	// 创建新图层
	function createCanvas(name, zIndex) {
		if (!name) return;
		var canvas = document.createElement('canvas');
		canvas.id = name;
		canvas.className = 'gameCanvas';
		// 编辑器模式下设置zIndex会导致加入的图层覆盖优先级过高
		if (main.mode != "editor") canvas.style.zIndex = zIndex || 0;
		// 将图层插入进游戏内容
		document.getElementById('gameDraw').appendChild(canvas);
		var ctx = canvas.getContext('2d');
		core.canvas[name] = ctx;
		canvas.width = core.__PIXELS__;
		canvas.height = core.__PIXELS__;
		return canvas;
	}

	var bg2Canvas = createCanvas('bg2', 20);
	var fg2Canvas = createCanvas('fg2', 63);
	// 大地图适配
	core.bigmap.canvas = ["bg2", "fg2", "bg", "event", "event2", "fg", "damage"];
	core.initStatus.bg2maps = {};
	core.initStatus.fg2maps = {};

	if (main.mode == 'editor') {
		/*插入编辑器的图层 不做此步新增图层无法在编辑器显示*/
		// 编辑器图层覆盖优先级 eui > efg > fg(前景层) > event2(48*32图块的事件层) > event(事件层) > bg(背景层)
		// 背景层2(bg2) 插入事件层(event)之前(即bg与event之间)
		document.getElementById('mapEdit').insertBefore(bg2Canvas, document.getElementById('event'));
		// 前景层2(fg2) 插入编辑器前景(efg)之前(即fg之后)
		document.getElementById('mapEdit').insertBefore(fg2Canvas, document.getElementById('ebm'));
		// 原本有三个图层 从4开始添加
		var num = 4;
		// 新增图层存入editor.dom中
		editor.dom.bg2c = core.canvas.bg2.canvas;
		editor.dom.bg2Ctx = core.canvas.bg2;
		editor.dom.fg2c = core.canvas.fg2.canvas;
		editor.dom.fg2Ctx = core.canvas.fg2;
		editor.dom.maps.push('bg2map', 'fg2map');
		editor.dom.canvas.push('bg2', 'fg2');

		// 创建编辑器上的按钮
		var createCanvasBtn = function (name) {
			// 电脑端创建按钮
			var input = document.createElement('input');
			// layerMod4/layerMod5
			var id = 'layerMod' + num++;
			// bg2map/fg2map
			var value = name + 'map';
			input.type = 'radio';
			input.name = 'layerMod';
			input.id = id;
			input.value = value;
			editor.dom[id] = input;
			input.onchange = function () {
				editor.uifunctions.setLayerMod(value);
			}
			return input;
		};

		var createCanvasBtn_mobile = function (name) {
			// 手机端往选择列表中添加子选项
			var input = document.createElement('option');
			var id = 'layerMod' + num++;
			var value = name + 'map';
			input.name = 'layerMod';
			input.value = value;
			editor.dom[id] = input;
			return input;
		};
		if (!editor.isMobile) {
			var input = createCanvasBtn('bg2');
			var input2 = createCanvasBtn('fg2');
			// 获取事件层及其父节点
			var child = document.getElementById('layerMod'),
				parent = child.parentNode;
			// 背景层2插入事件层前
			parent.insertBefore(input, child);
			// 不能直接更改背景层2的innerText 所以创建文本节点
			var txt = document.createTextNode('bg2');
			// 插入事件层前(即新插入的背景层2前)
			parent.insertBefore(txt, child);
			// 向最后插入前景层2(即插入前景层后)
			parent.appendChild(input2);
			var txt2 = document.createTextNode('fg2');
			parent.appendChild(txt2);
			parent.childNodes[2].replaceWith("bg");
			parent.childNodes[6].replaceWith("事件");
			parent.childNodes[8].replaceWith("fg");
		} else {
			var input = createCanvasBtn_mobile('bg2');
			var input2 = createCanvasBtn_mobile('fg2');
			// 手机端因为是选项 所以可以直接改innerText
			input.innerText = '背景层2';
			input2.innerText = '前景层2';
			var parent = document.getElementById('layerMod');
			parent.insertBefore(input, parent.children[1]);
			parent.appendChild(input2);
		}
	}

	var _loadFloor_doNotCopy = core.maps._loadFloor_doNotCopy;
	core.maps._loadFloor_doNotCopy = function () {
		return ["bg2map", "fg2map"].concat(_loadFloor_doNotCopy());
	}
	////// 绘制背景和前景层 //////
	core.maps._drawBg_draw = function (floorId, toDrawCtx, cacheCtx, config) {
		config.ctx = cacheCtx;
		core.maps._drawBg_drawBackground(floorId, config);
		// ------ 调整这两行的顺序来控制是先绘制贴图还是先绘制背景图块；后绘制的覆盖先绘制的。
		core.maps._drawFloorImages(floorId, config.ctx, 'bg', null, null, config.onMap);
		core.maps._drawBgFgMap(floorId, 'bg', config);
		if (config.onMap) {
			core.drawImage(toDrawCtx, cacheCtx.canvas, core.bigmap.v2 ? -32 : 0, core.bigmap.v2 ? -32 : 0);
			core.clearMap('bg2');
			core.clearMap(cacheCtx);
		}
		core.maps._drawBgFgMap(floorId, 'bg2', config);
		if (config.onMap) core.drawImage('bg2', cacheCtx.canvas, core.bigmap.v2 ? -32 : 0, core.bigmap.v2 ? -32 : 0);
		config.ctx = toDrawCtx;
	}
	core.maps._drawFg_draw = function (floorId, toDrawCtx, cacheCtx, config) {
		config.ctx = cacheCtx;
		// ------ 调整这两行的顺序来控制是先绘制贴图还是先绘制前景图块；后绘制的覆盖先绘制的。
		core.maps._drawFloorImages(floorId, config.ctx, 'fg', null, null, config.onMap);
		core.maps._drawBgFgMap(floorId, 'fg', config);
		if (config.onMap) {
			core.drawImage(toDrawCtx, cacheCtx.canvas, core.bigmap.v2 ? -32 : 0, core.bigmap.v2 ? -32 : 0);
			core.clearMap('fg2');
			core.clearMap(cacheCtx);
		}
		core.maps._drawBgFgMap(floorId, 'fg2', config);
		if (config.onMap) core.drawImage('fg2', cacheCtx.canvas, core.bigmap.v2 ? -32 : 0, core.bigmap.v2 ? -32 : 0);
		config.ctx = toDrawCtx;
	}
	////// 移动判定 //////
	core.maps._generateMovableArray_arrays = function (floorId) {
		return {
			bgArray: this.getBgMapArray(floorId),
			fgArray: this.getFgMapArray(floorId),
			eventArray: this.getMapArray(floorId),
			bg2Array: this._getBgFgMapArray('bg2', floorId),
			fg2Array: this._getBgFgMapArray('fg2', floorId)
		};
	}
},
    "itemShop": function () {
	// 道具商店相关的插件
	// 可在全塔属性-全局商店中使用「道具商店」事件块进行编辑（如果找不到可以在入口方块中找）

	var shopId = null; // 当前商店ID
	var type = 0; // 当前正在选中的类型，0买入1卖出
	var selectItem = 0; // 当前正在选中的道具
	var selectCount = 0; // 当前已经选中的数量
	var page = 0;
	var totalPage = 0;
	var totalMoney = 0;
	var list = [];
	var shopInfo = null; // 商店信息
	var choices = []; // 商店选项
	var use = 'money';
	var useText = '金币';

	var bigFont = core.ui._buildFont(20, false),
		middleFont = core.ui._buildFont(18, false);

	this._drawItemShop = function () {
		// 绘制道具商店

		// Step 1: 背景和固定的几个文字
		core.ui._createUIEvent();
		core.clearMap('uievent');
		core.ui.clearUIEventSelector();
		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'top');
		core.fillRect('uievent', 0, 0, 416, 416, 'black');
		core.drawWindowSkin('winskin.png', 'uievent', 0, 0, 416, 56);
		core.drawWindowSkin('winskin.png', 'uievent', 0, 56, 312, 56);
		core.drawWindowSkin('winskin.png', 'uievent', 0, 112, 312, 304);
		core.drawWindowSkin('winskin.png', 'uievent', 312, 56, 104, 56);
		core.drawWindowSkin('winskin.png', 'uievent', 312, 112, 104, 304);
		core.setFillStyle('uievent', 'white');
		core.setStrokeStyle('uievent', 'white');
		core.fillText("uievent", "购买", 32, 74, 'white', bigFont);
		core.fillText("uievent", "卖出", 132, 74);
		core.fillText("uievent", "离开", 232, 74);
		core.fillText("uievent", "当前" + useText, 324, 66, null, middleFont);
		core.setTextAlign("uievent", "right");
		core.fillText("uievent", core.formatBigNumber(core.status.hero[use]), 405, 89);
		core.setTextAlign("uievent", "left");
		core.ui.drawUIEventSelector(1, "winskin.png", 22 + 100 * type, 66, 60, 33);
		if (selectItem != null) {
			core.setTextAlign('uievent', 'center');
			core.fillText("uievent", type == 0 ? "买入个数" : "卖出个数", 364, 320, null, bigFont);
			core.fillText("uievent", "<   " + selectCount + "   >", 364, 350);
			core.fillText("uievent", "确定", 364, 380);
		}

		// Step 2：获得列表并展示
		list = choices.filter(function (one) {
			if (one.condition != null && one.condition != '') {
				try { if (!core.calValue(one.condition)) return false; } catch (e) {}
			}
			return (type == 0 && one.money != null) || (type == 1 && one.sell != null);
		});
		var per_page = 6;
		totalPage = Math.ceil(list.length / per_page);
		page = Math.floor((selectItem || 0) / per_page) + 1;

		// 绘制分页
		if (totalPage > 1) {
			var half = 156;
			core.setTextAlign('uievent', 'center');
			core.fillText('uievent', page + " / " + totalPage, half, 388, null, middleFont);
			if (page > 1) core.fillText('uievent', '上一页', half - 80, 388);
			if (page < totalPage) core.fillText('uievent', '下一页', half + 80, 388);
		}
		core.setTextAlign('uievent', 'left');

		// 绘制每一项
		var start = (page - 1) * per_page;
		for (var i = 0; i < per_page; ++i) {
			var curr = start + i;
			if (curr >= list.length) break;
			var item = list[curr];
			core.drawIcon('uievent', item.id, 10, 125 + i * 40);
			core.setTextAlign('uievent', 'left');
			core.fillText('uievent', core.material.items[item.id].name, 50, 132 + i * 40, null, bigFont);
			core.setTextAlign('uievent', 'right');
			core.fillText('uievent', (type == 0 ? core.calValue(item.money) : core.calValue(item.sell)) + useText + "/个", 300, 133 + i * 40, null, middleFont);
			core.setTextAlign("uievent", "left");
			if (curr == selectItem) {
				// 绘制描述，文字自动放缩
				var text = core.material.items[item.id].text || "该道具暂无描述";
				try { text = core.replaceText(text); } catch (e) {}
				for (var fontSize = 20; fontSize >= 8; fontSize -= 2) {
					var config = { left: 10, fontSize: fontSize, maxWidth: 403 };
					var height = core.getTextContentHeight(text, config);
					if (height <= 50) {
						config.top = (56 - height) / 2;
						core.drawTextContent("uievent", text, config);
						break;
					}
				}
				core.ui.drawUIEventSelector(2, "winskin.png", 8, 120 + i * 40, 295, 40);
				if (type == 0 && item.number != null) {
					core.fillText("uievent", "存货", 324, 132, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", item.number, 406, 132, null, null, 40);
				} else if (type == 1) {
					core.fillText("uievent", "数量", 324, 132, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", core.itemCount(item.id), 406, 132, null, null, 40);
				}
				core.setTextAlign("uievent", "left");
				core.fillText("uievent", "预计" + useText, 324, 250);
				core.setTextAlign("uievent", "right");
				totalMoney = selectCount * (type == 0 ? core.calValue(item.money) : core.calValue(item.sell));
				core.fillText("uievent", core.formatBigNumber(totalMoney), 405, 280);

				core.setTextAlign("uievent", "left");
				core.fillText("uievent", type == 0 ? "已购次数" : "已卖次数", 324, 170);
				core.setTextAlign("uievent", "right");
				core.fillText("uievent", (type == 0 ? item.money_count : item.sell_count) || 0, 405, 200);
			}
		}

		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'alphabetic');
	}

	var _add = function (item, delta) {
		if (item == null) return;
		selectCount = core.clamp(
			selectCount + delta, 0,
			Math.min(type == 0 ? Math.floor(core.status.hero[use] / core.calValue(item.money)) : core.itemCount(item.id),
				type == 0 && item.number != null ? item.number : Number.MAX_SAFE_INTEGER)
		);
	}

	var _confirm = function (item) {
		if (item == null || selectCount == 0) return;
		if (type == 0) {
			core.status.hero[use] -= totalMoney;
			core.getItem(item.id, selectCount);
			core.stopSound();
			core.playSound('确定');
			if (item.number != null) item.number -= selectCount;
			item.money_count = (item.money_count || 0) + selectCount;
		} else {
			core.status.hero[use] += totalMoney;
			core.removeItem(item.id, selectCount);
			core.playSound('确定');
			core.drawTip("成功卖出" + selectCount + "个" + core.material.items[item.id].name, item.id);
			if (item.number != null) item.number += selectCount;
			item.sell_count = (item.sell_count || 0) + selectCount;
		}
		selectCount = 0;
	}

	this._performItemShopKeyBoard = function (keycode) {
		var item = list[selectItem] || null;
		// 键盘操作
		switch (keycode) {
		case 38: // up
			if (selectItem == null) break;
			if (selectItem == 0) selectItem = null;
			else selectItem--;
			selectCount = 0;
			break;
		case 37: // left
			if (selectItem == null) {
				if (type > 0) type--;
				break;
			}
			_add(item, -1);
			break;
		case 39: // right
			if (selectItem == null) {
				if (type < 2) type++;
				break;
			}
			_add(item, 1);
			break;
		case 40: // down
			if (selectItem == null) {
				if (list.length > 0) selectItem = 0;
				break;
			}
			if (list.length == 0) break;
			selectItem = Math.min(selectItem + 1, list.length - 1);
			selectCount = 0;
			break;
		case 13:
		case 32: // Enter/Space
			if (selectItem == null) {
				if (type == 2)
					core.insertAction({ "type": "break" });
				else if (list.length > 0)
					selectItem = 0;
				break;
			}
			_confirm(item);
			break;
		case 27: // ESC
			if (selectItem == null) {
				core.insertAction({ "type": "break" });
				break;
			}
			selectItem = null;
			break;
		}
	}

	this._performItemShopClick = function (px, py) {
		var item = list[selectItem] || null;
		// 鼠标操作
		if (px >= 22 && px <= 82 && py >= 71 && py <= 102) {
			// 买
			if (type != 0) {
				type = 0;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 122 && px <= 182 && py >= 71 && py <= 102) {
			// 卖
			if (type != 1) {
				type = 1;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 222 && px <= 282 && py >= 71 && py <= 102) // 离开
			return core.insertAction({ "type": "break" });
		// < >
		if (px >= 318 && px <= 341 && py >= 348 && py <= 376)
			return _add(item, -1);
		if (px >= 388 && px <= 416 && py >= 348 && py <= 376)
			return _add(item, 1);
		// 确定
		if (px >= 341 && px <= 387 && py >= 380 && py <= 407)
			return _confirm(item);

		// 上一页/下一页
		if (px >= 45 && px <= 105 && py >= 388) {
			if (page > 1) {
				selectItem -= 6;
				selectCount = 0;
			}
			return;
		}
		if (px >= 208 && px <= 268 && py >= 388) {
			if (page < totalPage) {
				selectItem = Math.min(selectItem + 6, list.length - 1);
				selectCount = 0;
			}
			return;
		}

		// 实际区域
		if (px >= 9 && px <= 300 && py >= 120 && py < 360) {
			if (list.length == 0) return;
			var index = parseInt((py - 120) / 40);
			var newItem = 6 * (page - 1) + index;
			if (newItem >= list.length) newItem = list.length - 1;
			if (newItem != selectItem) {
				selectItem = newItem;
				selectCount = 0;
			}
			return;
		}
	}

	this._performItemShopAction = function () {
		if (flags.type == 0) return this._performItemShopKeyBoard(flags.keycode);
		else return this._performItemShopClick(flags.px, flags.py);
	}

	this.openItemShop = function (itemShopId) {
		shopId = itemShopId;
		type = 0;
		page = 0;
		selectItem = null;
		selectCount = 0;
		core.isShopVisited(itemShopId);
		shopInfo = flags.__shops__[shopId];
		if (shopInfo.choices == null) shopInfo.choices = core.clone(core.status.shops[shopId].choices);
		choices = shopInfo.choices;
		use = core.status.shops[shopId].use;
		if (use != 'exp') use = 'money';
		useText = use == 'money' ? '金币' : '经验';

		core.insertAction([{
				"type": "while",
				"condition": "true",
				"data": [
					{ "type": "function", "function": "function () { core.plugin._drawItemShop(); }" },
					{ "type": "wait" },
					{ "type": "function", "function": "function() { core.plugin._performItemShopAction(); }" }
				]
			},
			{
				"type": "function",
				"function": "function () { core.deleteCanvas('uievent'); core.ui.clearUIEventSelector(); }"
			}
		]);
	}

},
    "enemyLevel": function () {
	// 此插件将提供怪物手册中的怪物境界显示
	// 使用此插件需要先给每个怪物定义境界，方法如下：
	// 点击怪物的【配置表格】，找到“【怪物】相关的表格配置”，然后在【名称】仿照增加境界定义：
	/*
	 "level": {
		  "_leaf": true,
		  "_type": "textarea",
		  "_string": true,
		  "_data": "境界"
	 },
	 */
	// 然后保存刷新，可以看到怪物的属性定义中出现了【境界】。再开启本插件即可。
	// 
	// 怪物手册文字颜色
	core.ui._drawBook_drawRow1 = function (index, enemy, top, left, width, position) {
		// 绘制第一行
		core.setTextAlign('ui', 'left');
		var b13 = this._buildFont(13, true),
			f13 = this._buildFont(13, false);
		var col1 = left,
			col2 = left + width * 9 / 25,
			col3 = left + width * 17 / 25;
		core.fillText('ui', '生命', col1, position, '#A0F753', f13);
		core.fillText('ui', core.formatBigNumber(enemy.hp || 0), col1 + 30, position, null, b13);
		core.fillText('ui', '攻', col2, position, '#FF5555', f13);
		core.fillText('ui', core.formatBigNumber(enemy.atk || 0), col2 + 15, position, null, b13);
		core.fillText('ui', '防', col3, position, '#45D1E0', f13);
		core.fillText('ui', core.formatBigNumber(enemy.def || 0), col3 + 15, position, null, b13);
	};

	// 是否开启本插件，默认禁用；将此改成 true 将启用本插件。
	var __enable = false;
	if (!__enable) return;

	// 这里定义每个境界的显示颜色；可以写'red', '#RRGGBB' 或者[r,g,b,a]四元数组
	var levelToColors = {
		"萌新一阶": "red",
		"萌新二阶": "#FF0000",
		"萌新三阶": [255, 0, 0, 1],
	};

	// 复写 _drawBook_drawName
	var originDrawBook = core.ui._drawBook_drawName;
	core.ui._drawBook_drawName = function (index, enemy, top, left, width) {
		// 如果没有境界，则直接调用原始代码绘制
		if (!enemy.level) return originDrawBook.call(core.ui, index, enemy, top, left, width);
		// 存在境界，则额外进行绘制
		core.setTextAlign('ui', 'center');
		if (enemy.specialText.length == 0) {
			core.fillText('ui', enemy.name, left + width / 2,
				top + 27, '#DDDDDD', this._buildFont(17, true));
			core.fillText('ui', enemy.level, left + width / 2,
				top + 51, core.arrayToRGBA(levelToColors[enemy.level] || '#DDDDDD'), this._buildFont(14, true));
		} else {
			core.fillText('ui', enemy.name, left + width / 2,
				top + 20, '#DDDDDD', this._buildFont(17, true), width);
			switch (enemy.specialText.length) {
			case 1:
				core.fillText('ui', enemy.specialText[0], left + width / 2,
					top + 38, core.arrayToRGBA((enemy.specialColor || [])[0] || '#FF6A6A'),
					this._buildFont(14, true), width);
				break;
			case 2:
				// Step 1: 计算字体
				var text = enemy.specialText[0] + "  " + enemy.specialText[1];
				core.setFontForMaxWidth('ui', text, width, this._buildFont(14, true));
				// Step 2: 计算总宽度
				var totalWidth = core.calWidth('ui', text);
				var leftWidth = core.calWidth('ui', enemy.specialText[0]);
				var rightWidth = core.calWidth('ui', enemy.specialText[1]);
				// Step 3: 绘制
				core.fillText('ui', enemy.specialText[0], left + (width + leftWidth - totalWidth) / 2,
					top + 38, core.arrayToRGBA((enemy.specialColor || [])[0] || '#FF6A6A'));
				core.fillText('ui', enemy.specialText[1], left + (width + totalWidth - rightWidth) / 2,
					top + 38, core.arrayToRGBA((enemy.specialColor || [])[1] || '#FF6A6A'));
				break;
			default:
				core.fillText('ui', '多属性...', left + width / 2,
					top + 38, '#FF6A6A', this._buildFont(14, true), width);
			}
			core.fillText('ui', enemy.level, left + width / 2,
				top + 56, core.arrayToRGBA(levelToColors[enemy.level] || '#DDDDDD'), this._buildFont(14, true));
		}
	}

	// 也可以复写其他的属性颜色如怪物攻防等，具体参见下面的例子的注释部分
	core.ui._drawBook_drawRow1 = function (index, enemy, top, left, width, position) {
		// 绘制第一行
		core.setTextAlign('ui', 'left');
		var b13 = this._buildFont(13, true),
			f13 = this._buildFont(13, false);
		var col1 = left,
			col2 = left + width * 9 / 25,
			col3 = left + width * 17 / 25;
		core.fillText('ui', '生命', col1, position, '#DDDDDD', f13);
		core.fillText('ui', core.formatBigNumber(enemy.hp || 0), col1 + 30, position, /*'red' */ null, b13);
		core.fillText('ui', '攻击', col2, position, null, f13);
		core.fillText('ui', core.formatBigNumber(enemy.atk || 0), col2 + 30, position, /* '#FF0000' */ null, b13);
		core.fillText('ui', '防御', col3, position, null, f13);
		core.fillText('ui', core.formatBigNumber(enemy.def || 0), col3 + 30, position, /* [255, 0, 0, 1] */ null, b13);
	}


},
    "dynamicHp": function () {
		// 此插件允许人物血量动态进行变化
		// 原作：Fux2（老黄鸡）

		// 是否开启本插件，默认禁用；将此改成 true 将启用本插件。
		var __enable = false;
		if (!__enable) return;

		var speed = 0.05; // 动态血量变化速度，越大越快。

		var _currentHp = null;
		var _lastStatus = null;
		var _check = function () {
			if (_lastStatus != core.status.hero) {
				_lastStatus = core.status.hero;
				_currentHp = core.status.hero.hp;
			}
		}

		core.registerAnimationFrame('dynamicHp', true, function () {
			_check();
			if (core.status.hero.hp != _currentHp) {
				var dis = (_currentHp - core.status.hero.hp) * speed;
				if (Math.abs(dis) < 2) {
					_currentHp = core.status.hero.hp;
				} else {
					_currentHp -= dis;
				}
				core.setStatusBarInnerHTML('hp', _currentHp);
			}
		});
	},
    "multiHeros": function () {
		// 多角色插件
		// Step 1: 启用本插件
		// Step 2: 定义每个新的角色各项初始数据（参见下方注释）
		// Step 3: 在游戏中的任何地方都可以调用 `core.changeHero()` 进行切换；也可以 `core.changeHero(1)` 来切换到某个具体的角色上

		// 是否开启本插件，默认禁用；将此改成 true 将启用本插件。
		var __enable = false;
		if (!__enable) return;

		// 在这里定义全部的新角色属性
		// 请注意，在这里定义的内容不会多角色共用，在切换时会进行恢复。
		// 你也可以自行新增或删除，比如不共用金币则可以加上"money"的初始化，不共用道具则可以加上"items"的初始化，
		// 多角色共用hp的话则删除hp，等等。总之，不共用的属性都在这里进行定义就好。
		var hero1 = {
			"floorId": "MT0", // 该角色初始楼层ID；如果共用楼层可以注释此项
			"image": "brave.png", // 角色的行走图名称；此项必填不然会报错
			"name": "1号角色",
			"lv": 1,
			"hp": 10000, // 如果HP共用可注释此项
			"atk": 1000,
			"def": 1000,
			"mdef": 0,
			// "money": 0, // 如果要不共用金币则取消此项注释
			// "exp": 0, // 如果要不共用经验则取消此项注释
			"loc": { "x": 0, "y": 0, "direction": "up" }, // 该角色初始位置；如果共用位置可注释此项
			"items": {
				"tools": {}, // 如果共用消耗道具（含钥匙）则可注释此项
				// "constants": {}, // 如果不共用永久道具（如手册）可取消注释此项
				"equips": {}, // 如果共用在背包的装备可注释此项
			},
			"equipment": [], // 如果共用装备可注释此项；此项和上面的「共用在背包的装备」需要拥有相同状态，不然可能出现问题
		};
		// 也可以类似新增其他角色
		// 新增的角色，各项属性共用与不共用的选择必须和上面完全相同，否则可能出现问题。
		// var hero2 = { ...

		var heroCount = 2; // 包含默认角色在内总共多少个角色，该值需手动修改。

		this.initHeros = function () {
			core.setFlag("hero1", core.clone(hero1)); // 将属性值存到变量中
			// core.setFlag("hero2", core.clone(hero2)); // 更多的角色也存入变量中；每个定义的角色都需要新增一行

			// 检测是否存在装备
			if (hero1.equipment) {
				if (!hero1.items || !hero1.items.equips) {
					alert('多角色插件的equipment和道具中的equips必须拥有相同状态！');
				}
				// 存99号套装为全空
				var saveEquips = core.getFlag("saveEquips", []);
				saveEquips[99] = [];
				core.setFlag("saveEquips", saveEquips);
			} else {
				if (hero1.items && hero1.items.equips) {
					alert('多角色插件的equipment和道具中的equips必须拥有相同状态！');
				}
			}
		}

		// 在游戏开始注入initHeros
		var _startGame_setHard = core.events._startGame_setHard;
		core.events._startGame_setHard = function () {
			_startGame_setHard.call(core.events);
			core.initHeros();
		}

		// 切换角色
		// 可以使用 core.changeHero() 来切换到下一个角色
		// 也可以 core.changeHero(1) 来切换到某个角色（默认角色为0）
		this.changeHero = function (toHeroId) {
			var currHeroId = core.getFlag("heroId", 0); // 获得当前角色ID
			if (toHeroId == null) {
				toHeroId = (currHeroId + 1) % heroCount;
			}
			if (currHeroId == toHeroId) return;

			var saveList = Object.keys(hero1);

			// 保存当前内容
			var toSave = {};
			// 暂时干掉 drawTip 和 音效，避免切装时的提示
			var _drawTip = core.ui.drawTip;
			core.ui.drawTip = function () { };
			var _playSound = core.control.playSound;
			core.control.playSound = function () { }
			// 记录当前录像，因为可能存在换装问题
			core.clearRouteFolding();
			var routeLength = core.status.route.length;
			// 优先判定装备
			if (hero1.equipment) {
				core.items.quickSaveEquip(100 + currHeroId);
				core.items.quickLoadEquip(99);
			}

			saveList.forEach(function (name) {
				if (name == 'floorId') toSave[name] = core.status.floorId; // 楼层单独设置
				else if (name == 'items') {
					toSave.items = core.clone(core.status.hero.items);
					Object.keys(toSave.items).forEach(function (one) {
						if (!hero1.items[one]) delete toSave.items[one];
					});
				} else toSave[name] = core.clone(core.status.hero[name]); // 使用core.clone()来创建新对象
			});

			core.setFlag("hero" + currHeroId, toSave); // 将当前角色信息进行保存
			var data = core.getFlag("hero" + toHeroId); // 获得要切换的角色保存内容

			// 设置角色的属性值
			saveList.forEach(function (name) {
				if (name == "floorId");
				else if (name == "items") {
					Object.keys(core.status.hero.items).forEach(function (one) {
						if (data.items[one]) core.status.hero.items[one] = core.clone(data.items[one]);
					});
				} else {
					core.status.hero[name] = core.clone(data[name]);
				}
			});
			// 最后装上装备
			if (hero1.equipment) {
				core.items.quickLoadEquip(100 + toHeroId);
			}

			core.ui.drawTip = _drawTip;
			core.control.playSound = _playSound;
			core.status.route = core.status.route.slice(0, routeLength);
			core.control._bindRoutePush();

			// 插入事件：改变角色行走图并进行楼层切换
			var toFloorId = data.floorId || core.status.floorId;
			var toLoc = data.loc || core.status.hero.loc;
			core.insertAction([
				{ "type": "setHeroIcon", "name": data.image || "hero.png" }, // 改变行走图
				// 同层则用changePos，不同层则用changeFloor；这是为了避免共用楼层造成触发eachArrive
				toFloorId != core.status.floorId ? {
					"type": "changeFloor",
					"floorId": toFloorId,
					"loc": [toLoc.x, toLoc.y],
					"direction": toLoc.direction,
					"time": 0 // 可以在这里设置切换时间
				} : { "type": "changePos", "loc": [toLoc.x, toLoc.y], "direction": toLoc.direction }
				// 你还可以在这里执行其他事件，比如增加或取消跟随效果
			]);
			core.setFlag("heroId", toHeroId); // 保存切换到的角色ID
		}
	},
    "itemCategory": function () {
	// 物品分类插件。此插件允许你对消耗道具和永久道具进行分类，比如标记「宝物类」「剧情道具」「药品」等等。
	// 使用方法：
	// 1. 启用本插件
	// 2. 在下方数组中定义全部的物品分类类型
	// 3. 点击道具的【配置表格】，找到“【道具】相关的表格配置”，然后在【道具描述】之后仿照增加道具的分类：
	/*
	 "category": {
		  "_leaf": true,
		  "_type": "textarea",
		  "_string": true,
		  "_data": "道具分类"
	 },
	 */
	// （你也可以选择使用下拉框的方式定义每个道具的分类，写法参见上面的cls）
	// 然后刷新编辑器，就可以对每个物品进行分类了

	// 是否开启本插件，默认禁用；将此改成 true 将启用本插件。
	var __enable = false;
	if (!__enable) return;

	// 在这里定义所有的道具分类类型，一行一个
	var categories = [
		"宝物类",
		"辅助类",
		"技能类",
		"剧情道具",
		"增益道具",
	];
	// 当前选中的道具类别
	var currentCategory = null;

	// 重写 core.ui._drawToolbox 以绘制分类类别
	var _drawToolbox = core.ui._drawToolbox;
	core.ui._drawToolbox = function (index) {
		_drawToolbox.call(this, index);
		core.setTextAlign('ui', 'left');
		core.fillText('ui', '类别[E]：' + (currentCategory || "全部"), 15, this.PIXEL - 13);
	}

	// 获得所有应该在道具栏显示的某个类型道具
	core.ui.getToolboxItems = function (cls) {
		// 检查类别
		return Object.keys(core.status.hero.items[cls])
			.filter(function (id) {
				return !core.material.items[id].hideInToolbox &&
					(currentCategory == null || core.material.items[id].category == currentCategory);
			}).sort();
	}

	// 注入道具栏的点击事件（点击类别）
	var _clickToolbox = core.actions._clickToolbox;
	core.actions._clickToolbox = function (x, y) {
		if (x >= 0 && x <= this.HSIZE - 4 && y == this.LAST) {
			drawToolboxCategory();
			return;
		}
		return _clickToolbox.call(core.actions, x, y);
	}

	// 注入道具栏的按键事件（E键）
	var _keyUpToolbox = core.actions._keyUpToolbox;
	core.actions._keyUpToolbox = function (keyCode) {
		if (keyCode == 69) {
			// 按E键则打开分类类别选择
			drawToolboxCategory();
			return;
		}
		return _keyUpToolbox.call(core.actions, keyCode);
	}

	// ------ 以下为选择道具分类的相关代码 ------ //

	// 关闭窗口时清除分类选择项
	var _closePanel = core.ui.closePanel;
	core.ui.closePanel = function () {
		currentCategory = null;
		_closePanel.call(core.ui);
	}

	// 弹出菜单以选择具体哪个分类
	// 直接使用 core.drawChoices 进行绘制
	var drawToolboxCategory = function () {
		if (core.status.event.id != 'toolbox') return;
		var selection = categories.indexOf(currentCategory) + 1;
		core.ui.closePanel();
		core.status.event.id = 'toolbox-category';
		core.status.event.selection = selection;
		core.lockControl();
		// 给第一项插入「全部」
		core.drawChoices('请选择道具类别', ["全部"].concat(categories));
	}

	// 选择某一项
	var _selectCategory = function (index) {
		core.ui.closePanel();
		if (index <= 0 || index > categories.length) currentCategory = null;
		else currentCategory = categories[index - 1];
		core.openToolbox();
	}

	var _clickToolBoxCategory = function (x, y) {
		if (!core.status.lockControl || core.status.event.id != 'toolbox-category') return false;

		if (x < core.actions.CHOICES_LEFT || x > core.actions.CHOICES_RIGHT) return false;
		var choices = core.status.event.ui.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (y >= topIndex && y < topIndex + choices.length) {
			_selectCategory(y - topIndex);
		}
		return true;
	}

	// 注入点击事件
	core.registerAction('onclick', 'toolbox-category', _clickToolBoxCategory, 100);

	// 注入光标跟随事件
	core.registerAction('onmove', 'toolbox-category', function (x, y) {
		if (!core.status.lockControl || core.status.event.id != 'toolbox-category') return false;
		core.actions._onMoveChoices(x, y);
		return true;
	}, 100);

	// 注入键盘光标事件
	core.registerAction('keyDown', 'toolbox-category', function (keyCode) {
		if (!core.status.lockControl || core.status.event.id != 'toolbox-category') return false;
		core.actions._keyDownChoices(keyCode);
		return true;
	}, 100);

	// 注入键盘按键事件
	core.registerAction('keyUp', 'toolbox-category', function (keyCode) {
		if (!core.status.lockControl || core.status.event.id != 'toolbox-category') return false;
		core.actions._selectChoices(core.status.event.ui.choices.length, keyCode, _clickToolBoxCategory);
		return true;
	}, 100);

},
    "heroFourFrames": function () {
	// 样板的勇士/跟随者移动时只使用2、4两帧，观感较差。本插件可以将四帧全用上。

	// 是否启用本插件
	var __enable = false;
	if (!__enable) return;

	["up", "down", "left", "right"].forEach(function (one) {
		// 指定中间帧动画
		core.material.icons.hero[one].midFoot = 2;
	});

	var heroMoving = function (timestamp) {
		if (core.status.heroMoving <= 0) return;
		if (timestamp - core.animateFrame.moveTime > core.values.moveSpeed) {
			core.animateFrame.leftLeg++;
			core.animateFrame.moveTime = timestamp;
		}
		core.drawHero(['stop', 'leftFoot', 'midFoot', 'rightFoot'][core.animateFrame.leftLeg % 4], 4 * core.status.heroMoving);
	}
	core.registerAnimationFrame('heroMoving', true, heroMoving);

	core.events._eventMoveHero_moving = function (step, moveSteps) {
		var curr = moveSteps[0];
		var direction = curr[0],
			x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y');
		// ------ 前进/后退
		var o = direction == 'backward' ? -1 : 1;
		if (direction == 'forward' || direction == 'backward') direction = core.getHeroLoc('direction');
		var faceDirection = direction;
		if (direction == 'leftup' || direction == 'leftdown') faceDirection = 'left';
		if (direction == 'rightup' || direction == 'rightdown') faceDirection = 'right';
		core.setHeroLoc('direction', direction);
		if (curr[1] <= 0) {
			core.setHeroLoc('direction', faceDirection);
			moveSteps.shift();
			return true;
		}
		if (step <= 4) core.drawHero('stop', 4 * o * step);
		else if (step <= 8) core.drawHero('leftFoot', 4 * o * step);
		else if (step <= 12) core.drawHero('midFoot', 4 * o * (step - 8));
		else if (step <= 16) core.drawHero('rightFoot', 4 * o * (step - 8)); // if (step == 8) {
		if (step == 8 || step == 16) {
			core.setHeroLoc('x', x + o * core.utils.scan2[direction].x, true);
			core.setHeroLoc('y', y + o * core.utils.scan2[direction].y, true);
			core.updateFollowers();
			curr[1]--;
			if (curr[1] <= 0) moveSteps.shift();
			core.setHeroLoc('direction', faceDirection);
			return step == 16;
		}
		return false;
	}
},
    "startCanvas": function () {
	// 使用本插件可以将自绘的标题界面居中。仅在【标题开启事件化】后才有效。
	// 由于一些技术性的原因，标题界面事件化无法应用到覆盖状态栏的整个界面。
	// 这是一个较为妥协的插件，会在自绘标题界面时隐藏状态栏、工具栏和边框，并将画布进行居中。
	// 本插件仅在全塔属性的 "startCanvas" 生效；进入 "startText" 时将会离开居中状态，回归正常界面。

	// 是否开启本插件，默认禁用；将此改成 true 将启用本插件。
	var __enable = false;
	if (!__enable) return;

	// 检查【标题开启事件化】是否开启
	if (!core.flags.startUsingCanvas || main.mode != 'play') return;

	var _isTitleCanvasEnabled = false;
	var _getClickLoc = core.actions._getClickLoc;
	this._setTitleCanvas = function () {
		if (_isTitleCanvasEnabled) return;
		_isTitleCanvasEnabled = true;

		// 禁用窗口resize
		window.onresize = function () {};
		core.resize = function () {}

		// 隐藏状态栏
		core.dom.statusBar.style.display = 'none';
		core.dom.statusCanvas.style.display = 'none';
		core.dom.toolBar.style.display = 'none';
		// 居中画布
		if (core.domStyle.isVertical) {
			core.dom.gameDraw.style.top =
				(parseInt(core.dom.gameGroup.style.height) - parseInt(core.dom.gameDraw.style.height)) / 2 + "px";
		} else {
			core.dom.gameDraw.style.right =
				(parseInt(core.dom.gameGroup.style.width) - parseInt(core.dom.gameDraw.style.width)) / 2 + "px";
		}
		core.dom.gameDraw.style.border = '3px transparent solid';
		core.actions._getClickLoc = function (x, y) {
			var left = core.dom.gameGroup.offsetLeft + core.dom.gameDraw.offsetLeft + 3;
			var top = core.dom.gameGroup.offsetTop + core.dom.gameDraw.offsetTop + 3;
			var loc = { 'x': Math.max(x - left, 0), 'y': Math.max(y - top, 0), 'size': 32 * core.domStyle.scale };
			return loc;
		}
	}

	this._resetTitleCanvas = function () {
		if (!_isTitleCanvasEnabled) return;
		_isTitleCanvasEnabled = false;
		window.onresize = function () { try { main.core.resize(); } catch (ee) { console.error(ee) } }
		core.resize = function () { return core.control.resize(); }
		core.resize();
		core.actions._getClickLoc = _getClickLoc;
	}

	// 复写“开始游戏”
	core.events._startGame_start = function (hard, seed, route, callback) {
		console.log('开始游戏');
		core.resetGame(core.firstData.hero, hard, null, core.cloneArray(core.initStatus.maps));
		core.setHeroLoc('x', -1);
		core.setHeroLoc('y', -1);

		if (seed != null) {
			core.setFlag('__seed__', seed);
			core.setFlag('__rand__', seed);
		} else core.utils.__init_seed();

		core.clearStatusBar();
		core.plugin._setTitleCanvas();

		var todo = [];
		core.hideStatusBar();
		core.push(todo, core.firstData.startCanvas);
		core.push(todo, { "type": "function", "function": "function() { core.plugin._resetTitleCanvas(); core.events._startGame_setHard(); }" })
		core.push(todo, core.firstData.startText);
		this.insertAction(todo, null, null, function () {
			core.events._startGame_afterStart(callback);
		});

		if (route != null) core.startReplay(route);
	}

	var _loadData = core.control.loadData;
	core.control.loadData = function (data, callback) {
		core.plugin._resetTitleCanvas();
		_loadData.call(core.control, data, callback);
	}
},
    "宝石血瓶显值": function () {
	/* 宝石血瓶左下角显示数值
	 * 需要将 变量：itemDetail改为true才可正常运行
	 * 请尽量减少勇士的属性数量，否则可能会出现严重卡顿
	 * 注意：这里的属性必须是core.status.hero里面的，flag无法显示
	 * 如果不想显示，可以core.setFlag("itemDetail", false);
	 * 然后再core.getItemDetail();
	 * 如有bug在大群或造塔群@古祠
	 */

	// 谁tm在即捡即用效果里面调用带有含刷新状态栏的函数
	var origin = core.control.updateStatusBar;
	core.updateStatusBar = core.control.updateStatusBar = function () {
		if (core.getFlag('__statistics__')) return;
		else return origin.apply(core.control, arguments);
	}

	core.bigmap.threshold = 256;

	core.control.updateDamage = function (floorId, ctx) {
		floorId = floorId || core.status.floorId;
		if (!floorId || core.status.gameOver || main.mode != 'play') return;
		var onMap = ctx == null;

		// 没有怪物手册
		if (!core.hasItem('book')) return;
		core.status.damage.posX = core.bigmap.posX;
		core.status.damage.posY = core.bigmap.posY;
		if (!onMap) {
			var width = core.floors[floorId].width,
				height = core.floors[floorId].height;
			// 地图过大的缩略图不绘制显伤
			if (width * height > core.bigmap.threshold) return;
		}
		this._updateDamage_damage(floorId, onMap);
		this._updateDamage_extraDamage(floorId, onMap);
		core.getItemDetail(floorId); // 宝石血瓶详细信息
		this.drawDamage(ctx);
	};
	// 绘制地图显示
	control.prototype._drawDamage_draw = function (ctx, onMap) {
		if (!core.hasItem('book')) return;
		// *** 下一句话可以更改你想要的显示字体
		core.setFont(ctx, "bold 10px pixelmix");
		// ***
		core.setTextAlign(ctx, 'left');
		core.status.damage.data.forEach(function (one) {
			var px = one.px,
				py = one.py;
			if (onMap && core.bigmap.v2) {
				px -= core.bigmap.posX * 32;
				py -= core.bigmap.posY * 32;
				if (px < -32 * 2 || px > core.__PX__ + 32 || py < -32 || py > core.__PY__ + 32)
					return;
			}
			core.fillBoldText(ctx, one.text, px, py, one.color);
		});
		core.setTextAlign(ctx, 'center');
		core.status.damage.extraData.forEach(function (one) {
			var px = one.px,
				py = one.py;
			if (onMap && core.bigmap.v2) {
				px -= core.bigmap.posX * 32;
				py -= core.bigmap.posY * 32;
				if (px < -32 || px > core.__PX__ + 32 || py < -32 || py > core.__PY__ + 32)
					return;
			}
			core.fillBoldText(ctx, one.text, px, py, one.color);
		});
	};
	// 获取宝石信息 并绘制
	this.getItemDetail = function (floorId) {
		if (!core.getFlag("itemDetail")) return;
		floorId = floorId || core.status.thisMap.floorId;
		core.status.maps[floorId].blocks.forEach(function (block) {
			if (block.event.cls !== 'items' || block.event.id === 'superPotion') return;
			var x = block.x,
				y = block.y;
			// v2优化，只绘制范围内的部分
			if (core.bigmap.v2) {
				if (x < core.bigmap.posX - core.bigmap.extend || x > core.bigmap.posX + core.__SIZE__ + core.bigmap.extend ||
					y < core.bigmap.posY - core.bigmap.extend || y > core.bigmap.posY + core.__SIZE__ + core.bigmap.extend) {
					return;
				}
			}
			var id = block.event.id;
			var item = core.material.items[id];
			if (item.cls === 'equips') {
				// 装备也显示
				var diff = core.clone(item.equip.value || {});
				var per = item.equip.percentage;
				for (var name in per) {
					diff[name + 'per'] = per[name].toString() + '%';
				}
				drawItemDetail(diff, x, y);
				return;
			}
			var before = core.clone(core.status.hero);
			// 跟数据统计原理一样 执行效果 前后比较
			core.setFlag("__statistics__", true);
			let tmp = core.status.maps[floorId].ratio;
			let ans = '';
			if (item.itemEffect !== undefined) ans = item.itemEffect.replace(/core.status.thisMap.ratio/g, tmp);
			try {
				eval(ans);
			} catch (error) {}
			var diff = compareObject(before, core.status.hero);
			core.status.hero = hero = before;
			flags = core.status.hero.flags;
			drawItemDetail(diff, x, y);
		});
	};
	// 比较两个对象之间每一项的数值差异（弱等于） 返回数值差异
	function compareObject(a, b) {
		a = a || {};
		b = b || {};
		var diff = {}; // 差异
		for (var name in a) {
			diff[name] = b[name] - (a[name] || 0);
			if (!diff[name]) diff[name] = void 0;
		}
		return diff;
	};
	// 绘制
	function drawItemDetail(diff, x, y) {
		var px = 32 * x + 2,
			py = 32 * y + 30;
		var content = "";
		// 获得数据和颜色
		var i = 0;
		for (var name in diff) {
			if (!diff[name]) continue;
			var color = "#ffffff";
			if (typeof diff[name] === 'number')
				diff[name] = core.formatBigNumber(diff[name], true);
			switch (name) {
			case 'atk':
			case 'atkper':
				color = "#FF7A7A";
				break;
			case 'def':
			case 'defper':
				color = "#00E6F1";
				break;
			case 'mdef':
			case 'mdefper':
				color = "#6EFF83";
				break;
			case 'hp':
				color = "#A4FF00";
				break;
			case 'hpmax':
			case 'hpmaxper':
				color = "#FF9858";
				break;
			case 'mana':
				color = "#cc6666";
				break;
			case 'exp':
				color = "#EC8FC6";
				break;
			case 'money':
				color = "#EBE44E";
				break;
			}
			content = diff[name];
			// 绘制
			core.status.damage.data.push({ text: content, px: px, py: py - 10 * i, color: color });
			i++;
		}
	}

},
    "高级动画": function () {// -------------------- 插件说明 -------------------- //

// github仓库：https://github.com/unanmed/animate
// npm包名：mutate-animate
// npm地址：https://www.npmjs.com/package/mutate-animate

// 不要去尝试读这个插件，这个插件是经过了打包的，不是人类可读的(
// 想读的话可以去github读

// 该插件是一个轻量型多功能动画插件，可以允许你使用内置或自定义的速率曲线或轨迹等
// 除此之外，你还可以自定义绘制函数，来让你的动画可视化

// -------------------- 安装说明 -------------------- //

// 直接复制到插件中即可，注意所有插件中不能出现插件名为animate的插件
// 该插件分为动画和渐变两部分，教程分开，动画在前，渐变在后

// -------------------- 动画使用教程 -------------------- //

// 1. 首先创建一个异步函数
//   async function ani() { }

// 2. 引入插件中的类和函数，引入内容要看个人需求，所有可用的函数在本插件末尾可以看到
//   const { Animation, linear, bezier, circle, hyper, trigo, power, inverseTrigo, shake, sleep } = core.plugin.animate

// 3. 在函数内部创建一个动画
//   const animate = new Animation();

// 4. 为动画创建一个绘制函数，这里以绘制一个矩形为例，当然也可以使用core.fillRect替代ctx.fillRect来绘制矩形
//   const ctx = core.createCanvas('animate', 0, 0, 416, 416, 100);
//   ctx.save();
//   const fn = () => {
//      ctx.restore();
//      ctx.save();
//      ctx.clearRect(0, 0, 800, 800);
//      ctx.translate(animate.x, animate.y);
//      ctx.rotate(animate.angle * Math.PI / 180);
//      const size = animate.size;
//      ctx.fillRect(-30 * size, -30 * size, 60 * size, 60 * size);
//   }
//   animate.ticker.add(fn);

// 5. 执行动画

//   下面先对一些概念进行解释

//   动画分为很多种，内置的有move(移动至某一点)  rotate(旋转)  scale(放缩)  moveAs(以指定路径移动)  shake(震动)
//   对于不同的动画种类，其所对应的属性也不同，move moveAs shake均对应x和y这两个属性
//   rotate对应angle，scale对应size。你也可以自定义属性，这个之后会提到

//   除了执行动画之外，这里还提供了三个等待函数，可以等待某个动画执行完毕，以及一个等待指定时长的函数
//   分别是animate.n(等待指定数量的动画执行完毕)
//   animate.w(等待指定类型的动画执行完毕，也可以是自定义类型)
//   animate.all(等待所有动画执行完毕)
//   sleep(等待指定时长)

//   执行动画时，要求一个渐变函数，当然这个插件内置了非常丰富的渐变函数，也就是速率曲线。

//   线性渐变函数  linear()，该函数返回一个线性变化函数

//   三角渐变函数  trigo('sin' | 'sec', EaseMode)，该函数返回一个指定属性的三角函数变化函数
//       其中EaseMode可以填'in' 'out' 'in-out' 'center'
//       分别表示 慢-快  快-慢  慢-快-慢  快-慢-快

//   幂函数渐变  power(n, EaseMode)，该函数返回一个以x^n变化的函数，n是指数

//   双曲渐变函数  hyper('sin' | 'tan' | 'sec', EaseMode)，该函数返回一个双曲函数，分别是双曲正弦、双曲正切、双曲正割

//   反三角渐变函数  inverseTrigo('sin' | 'tan', EaseMode)，该函数返回一个反三角函数

//   贝塞尔曲线渐变函数  bezier(...cps)，参数为贝塞尔曲线的控制点纵坐标（横坐标不能自定义，毕竟一个时刻不能对应多个速率）
//       示例：bezier(0.4, 0.2, 0.7); // 三个控制点的四次贝塞尔曲线渐变函数

//   了解完渐变函数以后，这里还有一个特殊的渐变函数-shake
//   shake(power, timing)，这个函数是一个震荡函数，会让一个值来回变化，实现震动的效果
//       其中power是震动的最大值，timing是渐变函数，描述了power在震动时大小的变化

//   下面，我们就可以进行动画的执行了，我们以 运动 + 旋转 + 放缩为例

//   animate.mode(hyper('sin', 'out'))  // 设置渐变函数为 双曲正弦 快 -> 慢，注意不能加分号
//       .time(1000)  // 设置动画的执行时间为1000毫秒
//       .move(300, 300)  // 移动至[300, 300]的位置
//       .relative()  // 设置相对模式为相对之前，与之前为相加的关系
//       .mode(power(3, 'center'))  // 设置为 x^3 快-慢-快 的渐变函数
//       .time(3000)
//       .rotate(720)  // 旋转720度
//       .absolute()  // 设置相对模式为绝对
//       .mode(trigo('sin', 'in'))  // 设置渐变函数为 正弦 慢 -> 快
//       .time(1500)
//       .scale(3);  // 放缩大小至3倍

//   这样，我们就把三种基础动画都执行了一遍，同时，这种写法非常直观，出现问题时也可以很快地找到问题所在
//   下面，我们需要等待动画执行完毕，因为同一种动画不可能同时执行两个

//   await animate.n(1); // 等待任意一个动画执行完毕，别把await忘了
//   await animate.w('scale'); // 等待放缩动画执行完毕
//   await animate.all(); // 等待所有动画执行完毕
//   await sleep(1000); // 等待1000毫秒

//   下面，还有一个特殊的动画函数-moveAs
//   这是一个非常强大的函数，它允许你让你的物体按照指定路线运动
//   说到这，我们需要先了解一下运动函数。
//   该插件内置了两个运动函数，分别是圆形运动和贝塞尔曲线运动

//   圆形运动 circle(r, n, timing, inverse)，r是圆的半径，n是圈数，timing描述半径大小的变化，inverse说明了是否翻转timing函数，后面三个可以不填

//   贝塞尔曲线 bezierPath(start, end, ...cps)
//       其中start和end是起点和结束点，应当填入[x, y]数组，cps是控制点，也是[x, y]数组
//       示例：bezierPath([0, 0], [200, 200], [100, 50], [300, 150], [200, 180]);
//       这是一个起点为 [0, 0]，终点为[200, 200]，有三个控制点的四次贝塞尔曲线

//   下面，我们就可以使用路径函数了

//   animate.mode(hyper('sin', 'in-out'))  // 设置渐变曲线
//       .time(5000)
//       .relative()  // 设置为相对模式，这个比较必要，不然的话很可能出现瞬移
//       .moveAs(circle(100, 5, linear()))  // 创建一个5圈的半径从0至100逐渐变大的圆轨迹（是个螺旋线）并让物体沿着它运动
//       
//   最后，还有一个震动函数 shake(x, y)，x和y表示了在横向上和纵向上的震动幅度，1表示为震动幅度的100%
//   示例：
//   animate.mode(shake(5, hyper('sin', 'in')), true) // 这里第二个参数说明是震动函数
//       .time(2000)
//       .shake(1, 0.5)

//   这样，所有内置动画就已经介绍完毕

// 6. 自定义动画属性

//   本插件允许你自定义一个动画属性，但功能可能不会像自带的属性那么强大
//   你可以在创建动画之后使用animate.register(key, init)来注册一个自定义属性
//   其中key是自定义属性的名称，init是自定义属性的初始值，这个值应当在0-1之间变化

//   你可以通过animate.value[key]来获取你注册的自定义属性

//   对于自定义属性的动画，你应当使用animate.apply(key, n, first)
//   其中，key是你的自定义属性的名称，n是其目标值，first是一个布尔值，说明了是否将该动画插入到目前所有的动画之前，即每帧会优先执行该动画

//   下面是一个不透明度的示例

//   animate.register('opacity', 1); // 这句话应该放到刚创建动画之后

//   ctx.globalAlpha = animate.value.opacity; // 这句话应当放到每帧绘制的函数里面，放在绘制之前

//   animate.mode(bezier(0.9, 0.1, 0.05))  // 设置渐变函数
//       .time(2000)
//       .absolute()
//       .apply('opacity', 0.3);  // 将不透明度按照渐变曲线更改为0.3

// 7. 运行动画

//   还记得刚开始定义的async function 吗，直接调用它就能执行动画了！
//   示例：ani(); // 执行刚刚写的所有动画

// 8. 自定义速率曲线和路径

//   该插件中，速率曲线和路径均可自定义

//   对于速率曲线，其类型为  (input: number) => number
//   它接受一个范围在 0-1 的值，输出一个 0-1 的值，表示了动画的完成度，1表示动画已完成，0表示动画刚开始（当前大于1小于0也不会报错，也会执行相应的动画）

//   对于路径，其类型为  (input: number) => [number, number]
//   它与速率曲线类似，接收一个 0-1 的值，输出一个坐标数组

// 9. 多个属性绑定

//   该插件中，你可以绑定多个动画属性，你可以使用ani.bind(...attr)来绑定。
//   绑定之后，这三个动画属性可以被一个返回了长度为3的数组的渐变函数执行。
//   绑定使用ani.bind，设置渐变函数仍然使用ani.mode，注意它与单个动画属性是分开的，也就是它不会影响正常的渐变函数。
//   然后使用ani.applyMulti即可执行动画

//   例如：
//   // 自定义的一个三属性渐变函数
//   function b(input) {
//       return [input * 100, input ** 2 * 100, input ** 3 * 100];
//   }
//   ani.bind('a', 'b', 'c') // 这样会绑定abc这三个动画属性
//       .mode(b) // 自定义的一个返回了长度为3的数组的函数
//       .time(5000)
//       .absolute()
//       .applyMulti(); // 执行这个动画

// 9. 监听  动画的生命周期钩子

//   这个插件还允许你去监听动画的状态，可以监听动画的开始、结束、运行
//   你可以使用 animate.listen(type, fn)来监听，fn的类型是 (a: Animation, type: string) => void
//   当然，一般情况下你不会用到这个功能，插件中已经帮你包装了三个等待函数，他们就是以这些监听为基础的

// 10. 内置功能函数

//   这个插件还内置了一些功能函数，它们包括
//   add(...nums)  对一组数求和
//   multi(...nums)  对一组数求积
//   factorial(n)  求正整数n的阶乘
//   comNum(m, n)  求组合数 C_n^m
//   has(v) 判断v是否不为undefined和null

// -------------------- 渐变使用教程 -------------------- //

// 相比于动画，渐变属于一种较为简便的动画，它可以让你在设置一个属性后使属性缓慢变化值目标值而不是突变至目标值
// 现在假设你已经了解了动画的使用，下面我们来了解渐变。

// 1. 创建一个渐变实例
//   与动画类似，你需要使用new来实例化一个渐变，当然别忘了引入
//   const { Transition } = core.plugin.animate;
//   const tran = new Transition();

// 2. 绘制
//   const ctx = core.createCanvas('transition', 0, 0, 416, 416, 100);
//   ctx.save();
//   const fn = () => {
//      ctx.restore();
//      ctx.save();
//      ctx.clearRect(0, 0, 800, 800);
//      ctx.beginPath();
//      ctx.arc(tran.value.x, tran.value.y, 50, 0, Math.PI * 2); // 使用tran.value.xxx获取当前的属性
//      ctx.fill();
//      // 当然也可以用样板的api，例如core.fillCircle();等
//   }
//   animate.ticker.add(fn);

// 3. 设置渐变
//   同样，与动画类似，你可以使用tran.time()设置渐变时间，使用tran.mode()设置渐变函数，使用tran.absolute()和tran.relative()设置相对模式
//   例如：
//   tran.time(1000)
//       .mode(hyper('sin', 'out'))
//       .absolute();

// 4. 初始化渐变属性
//   与动画不同的是，动画在执行一个自定义属性前都需要register，而渐变不需要。
//   你可以通过tran.value.xxx = yyy来设置动画属性或使用tran.transition('xxx', yyy)来设置
//   你的首次赋值即是初始化了渐变属性，这时是不会执行渐变的，例如：
//   tran.value.x = 200;
//   tran.transition('y', 200);
//   上述例子便是将 x 和 y 初始化成了200

// 5. 执行渐变
//   初始化完成后，便可以直接执行渐变了，有两种方法
//   tran.value.x = 400; // 将 x 缓慢移动至400
//   tran.transition('y', 400); // 将 y 缓慢移动至400

if (main.replayChecking) return core.plugin.animate = {};

var M = Object.defineProperty;
var E = (n, s, t) => s in n ? M(n, s, { enumerable: !0, configurable: !0, writable: !0, value: t }) : n[s] = t;
var o = (n, s, t) => (E(n, typeof s != "symbol" ? s + "" : s, t), t);
let b = [];
const k = (n) => {
	for (const s of b)
		if (s.status === "running")
			try {
				for (const t of s.funcs)
					t(n - s.startTime);
			} catch (t) {
				s.destroy(), console.error(t);
			}
	requestAnimationFrame(k);
};
requestAnimationFrame(k);
class I {
	constructor() {
		o(this, "funcs", []);
		o(this, "status", "stop");
		o(this, "startTime", 0);
		this.status = "running", b.push(this), requestAnimationFrame((s) => this.startTime = s);
	}
	add(s, t = !1) {
		return t ? this.funcs.unshift(s) : this.funcs.push(s), this;
	}
	remove(s) {
		const t = this.funcs.findIndex((e) => e === s);
		if (t === -1)
			throw new ReferenceError(
				"You are going to remove nonexistent ticker function."
			);
		return this.funcs.splice(t, 1), this;
	}
	clear() {
		this.funcs = [];
	}
	destroy() {
		this.clear(), this.stop();
	}
	stop() {
		this.status = "stop", b = b.filter((s) => s !== this);
	}
}
class F {
	constructor() {
		o(this, "timing");
		o(this, "relation", "absolute");
		o(this, "easeTime", 0);
		o(this, "applying", {});
		o(this, "ticker", new I());
		o(this, "value", {});
		o(this, "listener", {});
		this.timing = (s) => s;
	}
	async all() {
		if (Object.values(this.applying).every((s) => s === !0))
			throw new ReferenceError("There is no animates to be waited.");
		await new Promise((s) => {
			const t = () => {
				Object.values(this.applying).every((e) => e === !1) && (this.unlisten("end", t), s("all animated."));
			};
			this.listen("end", t);
		});
	}
	async n(s) {
		const t = Object.values(this.applying).filter((i) => i === !0).length;
		if (t < s)
			throw new ReferenceError(
				`You are trying to wait ${s} animate, but there are only ${t} animate animating.`
			);
		let e = 0;
		await new Promise((i) => {
			const r = () => {
				e++, e === s && (this.unlisten("end", r), i(`${s} animated.`));
			};
			this.listen("end", r);
		});
	}
	async w(s) {
		if (this.applying[s] === !1)
			throw new ReferenceError(`The ${s} animate is not animating.`);
		await new Promise((t) => {
			const e = () => {
				this.applying[s] === !1 && (this.unlisten("end", e), t(`${s} animated.`));
			};
			this.listen("end", e);
		});
	}
	listen(s, t) {
		var e, i;
		(i = (e = this.listener)[s]) != null || (e[s] = []), this.listener[s].push(t);
	}
	unlisten(s, t) {
		const e = this.listener[s].findIndex((i) => i === t);
		if (e === -1)
			throw new ReferenceError(
				"You are trying to remove a nonexistent listener."
			);
		this.listener[s].splice(e, 1);
	}
	hook(...s) {
		const t = Object.entries(this.listener).filter(
			(e) => s.includes(e[0])
		);
		for (const [e, i] of t)
			for (const r of i)
				r(this, e);
	}
}

function x(n) {
	return n != null;
}
async function S(n) {
	return new Promise((s) => setTimeout(s, n));
}
class R extends F {
	constructor() {
		super();
		o(this, "shakeTiming");
		o(this, "path");
		o(this, "multiTiming");
		o(this, "value", {});
		o(this, "size", 1);
		o(this, "angle", 0);
		o(this, "targetValue", {
			system: {
				move: [0, 0],
				moveAs: [0, 0],
				resize: 0,
				rotate: 0,
				shake: 0,
				"@@bind": []
			},
			custom: {}
		});
		o(this, "animateFn", {
			system: {
				move: [() => 0, () => 0],
				moveAs: () => 0,
				resize: () => 0,
				rotate: () => 0,
				shake: () => 0,
				"@@bind": () => 0
			},
			custom: {}
		});
		o(this, "ox", 0);
		o(this, "oy", 0);
		o(this, "sx", 0);
		o(this, "sy", 0);
		o(this, "bindInfo", []);
		this.timing = (t) => t, this.shakeTiming = (t) => t, this.multiTiming = (t) => [t, t], this.path = (t) => [t, t], this.applying = {
			move: !1,
			scale: !1,
			rotate: !1,
			shake: !1
		}, this.ticker.add(() => {
			const { running: t } = this.listener;
			if (x(t))
				for (const e of t)
					e(this, "running");
		});
	}
	get x() {
		return this.ox + this.sx;
	}
	get y() {
		return this.oy + this.sy;
	}
	mode(t, e = !1) {
		return typeof t(0) == "number" ? e ? this.shakeTiming = t : this.timing = t : this.multiTiming = t, this;
	}
	time(t) {
		return this.easeTime = t, this;
	}
	relative() {
		return this.relation = "relative", this;
	}
	absolute() {
		return this.relation = "absolute", this;
	}
	bind(...t) {
		return this.applying["@@bind"] === !0 && this.end(!1, "@@bind"), this.bindInfo = t, this;
	}
	unbind() {
		return this.applying["@@bind"] === !0 && this.end(!1, "@@bind"), this.bindInfo = [], this;
	}
	move(t, e) {
		return this.applying.move && this.end(!0, "move"), this.applySys("ox", t, "move"), this.applySys("oy", e, "move"), this;
	}
	rotate(t) {
		return this.applySys("angle", t, "rotate"), this;
	}
	scale(t) {
		return this.applySys("size", t, "resize"), this;
	}
	shake(t, e) {
		this.applying.shake === !0 && this.end(!0, "shake"), this.applying.shake = !0;
		const { easeTime: i, shakeTiming: r } = this, h = Date.now();
		this.hook("start", "shakestart");
		const c = () => {
			const l = Date.now() - h;
			l > i && (this.ticker.remove(c), this.applying.shake = !1, this.sx = 0, this.sy = 0, this.hook("end", "shakeend"));
			const a = l / i,
				m = r(a);
			this.sx = m * t, this.sy = m * e;
		};
		return this.ticker.add(c), this.animateFn.system.shake = c, this;
	}
	moveAs(t) {
		this.applying.moveAs && this.end(!0, "moveAs"), this.applying.moveAs = !0, this.path = t;
		const { easeTime: e, relation: i, timing: r } = this, h = Date.now(), [c, u] = [this.x, this.y], [l, a] = (() => {
			if (i === "absolute")
				return t(1); {
				const [d, f] = t(1);
				return [c + d, u + f];
			}
		})();
		this.hook("start", "movestart");
		const m = () => {
			const f = Date.now() - h;
			if (f > e) {
				this.end(!0, "moveAs");
				return;
			}
			const w = f / e,
				[g, v] = t(r(w));
			i === "absolute" ? (this.ox = g, this.oy = v) : (this.ox = c + g, this.oy = u + v);
		};
		return this.ticker.add(m, !0), this.animateFn.system.moveAs = m, this.targetValue.system.moveAs = [l, a], this;
	}
	register(t, e) {
		if (typeof this.value[t] == "number")
			return this.error(
				`Property ${t} has been regietered twice.`,
				"reregister"
			);
		this.value[t] = e, this.applying[t] = !1;
	}
	apply(t, e, i = !1) {
		this.applying[t] === !0 && this.end(!1, t), t in this.value || this.error(
			`You are trying to execute nonexistent property ${t}.`
		), this.applying[t] = !0;
		const r = this.value[t],
			h = Date.now(),
			{ timing: c, relation: u, easeTime: l } = this,
			a = u === "absolute" ? e - r : e;
		this.hook("start");
		const m = () => {
			const f = Date.now() - h;
			if (f > l) {
				this.end(!1, t);
				return;
			}
			const w = f / l,
				g = c(w);
			this.value[t] = r + g * a;
		};
		return this.ticker.add(m, i), this.animateFn.custom[t] = m, this.targetValue.custom[t] = a + r, this;
	}
	applyMulti(t = !1) {
		this.applying["@@bind"] === !0 && this.end(!1, "@@bind"), this.applying["@@bind"] = !0;
		const e = this.bindInfo,
			i = e.map((m) => this.value[m]),
			r = Date.now(),
			{ multiTiming: h, relation: c, easeTime: u } = this,
			l = h(1);
		if (l.length !== i.length)
			throw new TypeError(
				`The number of binded animate attributes and timing function returns's length does not match. binded: ${e.length}, timing: ${l.length}`
			);
		this.hook("start");
		const a = () => {
			const d = Date.now() - r;
			if (d > u) {
				this.end(!1, "@@bind");
				return;
			}
			const f = d / u,
				w = h(f);
			e.forEach((g, v) => {
				c === "absolute" ? this.value[g] = w[v] : this.value[g] = i[v] + w[v];
			});
		};
		return this.ticker.add(a, t), this.animateFn.custom["@@bind"] = a, this.targetValue.system["@@bind"] = l, this;
	}
	applySys(t, e, i) {
		i !== "move" && this.applying[i] === !0 && this.end(!0, i), this.applying[i] = !0;
		const r = this[t],
			h = Date.now(),
			c = this.timing,
			u = this.relation,
			l = this.easeTime,
			a = u === "absolute" ? e - r : e;
		this.hook("start", `${i}start`);
		const m = () => {
			const f = Date.now() - h;
			if (f > l) {
				this.end(!0, i);
				return;
			}
			const w = f / l,
				g = c(w);
			this[t] = r + a * g, t !== "oy" && this.hook(i);
		};
		this.ticker.add(m, !0), t === "ox" ? this.animateFn.system.move[0] = m : t === "oy" ? this.animateFn.system.move[1] = m : this.animateFn.system[i] = m, i === "move" ? (t === "ox" && (this.targetValue.system.move[0] = a + r), t === "oy" && (this.targetValue.system.move[1] = a + r)) : i !== "shake" && (this.targetValue.system[i] = a + r);
	}
	error(t, e) {
		throw e === "repeat" ? new Error(
			`Cannot execute the same animation twice. Info: ${t}`
		) : e === "reregister" ? new Error(
			`Cannot register a animated property twice. Info: ${t}`
		) : new Error(t);
	}
	end(t, e) {
		if (t === !0)
			if (this.applying[e] = !1, e === "move" ? (this.ticker.remove(this.animateFn.system.move[0]), this.ticker.remove(this.animateFn.system.move[1])) : e === "moveAs" ? this.ticker.remove(this.animateFn.system.moveAs) : e === "@@bind" ? this.ticker.remove(this.animateFn.system["@@bind"]) : this.ticker.remove(
					this.animateFn.system[e]
				), e === "move") {
				const [i, r] = this.targetValue.system.move;
				this.ox = i, this.oy = r, this.hook("moveend", "end");
			} else if (e === "moveAs") {
			const [i, r] = this.targetValue.system.moveAs;
			this.ox = i, this.oy = r, this.hook("moveend", "end");
		} else
			e === "rotate" ? (this.angle = this.targetValue.system.rotate, this.hook("rotateend", "end")) : e === "resize" ? (this.size = this.targetValue.system.resize, this.hook("resizeend", "end")) : e === "@@bind" ? this.bindInfo.forEach((r, h) => {
				this.value[r] = this.targetValue.system["@@bind"][h];
			}) : (this.sx = 0, this.sy = 0, this.hook("shakeend", "end"));
		else
			this.applying[e] = !1, this.ticker.remove(this.animateFn.custom[e]), this.value[e] = this.targetValue.custom[e], this.hook("end");
	}
}
class Y extends F {
	constructor() {
		super();
		o(this, "now", {});
		o(this, "target", {});
		o(this, "transitionFn", {});
		o(this, "value");
		o(this, "handleSet", (t, e, i) => (this.transition(e, i), !0));
		o(this, "handleGet", (t, e) => this.now[e]);
		this.timing = (t) => t, this.value = new Proxy(this.target, {
			set: this.handleSet,
			get: this.handleGet
		});
	}
	mode(t) {
		return this.timing = t, this;
	}
	time(t) {
		return this.easeTime = t, this;
	}
	relative() {
		return this.relation = "relative", this;
	}
	absolute() {
		return this.relation = "absolute", this;
	}
	transition(t, e) {
		if (e === this.target[t])
			return this;
		if (!x(this.now[t]))
			return this.now[t] = e, this;
		this.applying[t] && this.end(t, !0), this.applying[t] = !0, this.hook("start");
		const i = Date.now(),
			r = this.easeTime,
			h = this.timing,
			c = this.now[t],
			u = e + (this.relation === "absolute" ? 0 : c),
			l = u - c;
		this.target[t] = u;
		const a = () => {
			const d = Date.now() - i;
			d >= r && this.end(t);
			const f = d / r;
			this.now[t] = h(f) * l + c, this.hook("running");
		};
		return this.transitionFn[t] = a, this.ticker.add(a), this;
	}
	end(t, e = !1) {
		const i = this.transitionFn[t];
		if (!x(i))
			throw new ReferenceError(
				`You are trying to end an ended transition: ${t}`
			);
		this.ticker.remove(this.transitionFn[t]), delete this.transitionFn[t], this.applying[t] = !1, this.hook("end"), e || (this.now[t] = this.target[t]);
	}
}
const T = (...n) => n.reduce((s, t) => s + t, 0),
	y = (n) => {
		if (n === 0)
			return 1;
		let s = n;
		for (; n > 1;)
			n--, s *= n;
		return s;
	},
	A = (n, s) => Math.round(y(s) / (y(n) * y(s - n))),
	p = (n, s, t = (e) => 1 - s(1 - e)) => n === "in" ? s : n === "out" ? t : n === "in-out" ? (e) => e < 0.5 ? s(e * 2) / 2 : 0.5 + t((e - 0.5) * 2) / 2 : (e) => e < 0.5 ? t(e * 2) / 2 : 0.5 + s((e - 0.5) * 2) / 2,
	$ = Math.cosh(2),
	z = Math.acosh(2),
	V = Math.tanh(3),
	D = Math.atan(5);

function j() {
	return (n) => n;
}

function O(...n) {
	const s = [0].concat(n);
	s.push(1);
	const t = s.length,
		e = Array(t).fill(0).map((i, r) => A(r, t - 1));
	return (i) => {
		const r = e.map((h, c) => h * s[c] * (1 - i) ** (t - c - 1) * i ** c);
		return T(...r);
	};
}

function q(n, s) {
	if (n === "sin") {
		const t = (i) => Math.sin(i * Math.PI / 2);
		return p(s, (i) => 1 - t(1 - i), t);
	}
	if (n === "sec") {
		const t = (i) => 1 / Math.cos(i);
		return p(s, (i) => t(i * Math.PI / 3) - 1);
	}
	throw new TypeError(
		"Unexpected parameters are delivered in trigo timing function."
	);
}

function U(n, s) {
	if (!Number.isInteger(n))
		throw new TypeError(
			"The first parameter of power timing function only allow integer."
		);
	return p(s, (e) => e ** n);
}

function C(n, s) {
	if (n === "sin")
		return p(s, (e) => (Math.cosh(e * 2) - 1) / ($ - 1));
	if (n === "tan") {
		const t = (i) => Math.tanh(i * 3) * 1 / V;
		return p(s, (i) => 1 - t(1 - i), t);
	}
	if (n === "sec") {
		const t = (i) => 1 / Math.cosh(i);
		return p(s, (i) => 1 - (t(i * z) - 0.5) * 2);
	}
	throw new TypeError(
		"Unexpected parameters are delivered in hyper timing function."
	);
}

function G(n, s) {
	if (n === "sin") {
		const t = (i) => Math.asin(i) / Math.PI * 2;
		return p(s, (i) => 1 - t(1 - i), t);
	}
	if (n === "tan") {
		const t = (i) => Math.atan(i * 5) / D;
		return p(s, (i) => 1 - t(1 - i), t);
	}
	throw new TypeError(
		"Unexpected parameters are delivered in inverse trigo timing function."
	);
}

function N(n, s = () => 1) {
	let t = -1;
	return (e) => (t *= -1, e < 0.5 ? n * s(e * 2) * t : n * s((1 - e) * 2) * t);
}

function B(n, s = 1, t = [0, 0], e = 0, i = (h) => 1, r = !1) {
	return (h) => {
		const c = s * h * Math.PI * 2 + e * Math.PI / 180,
			u = Math.cos(c),
			l = Math.sin(c),
			a = n * i(i(r ? 1 - h : h));
		return [a * u + t[0], a * l + t[1]];
	};
}

function H(n, s, ...t) {
	const e = [n].concat(t);
	e.push(s);
	const i = e.length,
		r = Array(i).fill(0).map((h, c) => A(c, i - 1));
	return (h) => {
		const c = r.map((l, a) => l * e[a][0] * (1 - h) ** (i - a - 1) * h ** a),
			u = r.map((l, a) => l * e[a][1] * (1 - h) ** (i - a - 1) * h ** a);
		return [T(...c), T(...u)];
	};
}


if ('animate' in core.plugin) throw new ReferenceError(`插件中已存在名为animate的属性！`);

core.plugin.animate = {
	Animation: R,
	AnimationBase: F,
	Ticker: I,
	Transition: Y,
	sleep: S,
	circle: N,
	bezierPath: H,
	add: T,
	comNum: A,
	factorial: y,
	linear: j,
	bezier: O,
	trigo: q,
	power: U,
	hyper: C,
	inverseTrigo: G,
	shake: N
}},
    "tanshang": function () {
	/*
 * 把下面的脚本放到
 * 编辑器→插件编写→新建→给插件起名(popupDamage)
 * 确认后刷新页面（注意保存）在新增的插件内插入以下代码
 * （插件默认会编写开头和结尾，把插件粘贴到中间）
 * 例：
 * function () {
	这里粘贴插件
  }
*/

	// 版本控制
	if (!core.registerAnimationFrame) {
		throw new Error('require 2.6.1 or higher version');
	}

	window.Fux2 = window.Fux2 || {};
	Fux2.MorePerform = Fux2.MorePerform || {};

	Fux2.MorePerform.ShowDamagePop = {};
	Fux2.MorePerform.ShowDamagePop.version = 1.0;

	Fux2.MorePerform.ShowDamagePop.AllPopingCanvas = [];
	core.events.popStr = function (str, color, x, y) {
		if (core.isReplaying() || (!core.getFlag('popDamage1', false))) { return; }
		Fux2.MorePerform.ShowDamagePop.PopDamage(str, color, x, y);
	}


	// 每帧的处理
	Fux2.MorePerform.ShowDamagePop.Update = function () {
		this.AllPopingCanvas = this.AllPopingCanvas.filter(function (spr) {
			spr.update();
			return spr.isAlive();
		});
		if (!this.AllPopingCanvas.length) PopSprite._count = 0;
	};

	// 弹出伤害气泡
	Fux2.MorePerform.ShowDamagePop.PopDamage = function (damageValue) {
		if (core.getFlag('popDamage1', false) == true && (!core.isReplaying())) {
			if (damageValue) {
				var poper = new PopSprite(core.getHeroLoc('x') * 32, core.getHeroLoc('y') * 32, damageValue);
				Fux2.MorePerform.ShowDamagePop.AllPopingCanvas.push(poper);
			}
		}
	};

	// 战斗发生前后记录生命值并处理
	Fux2.MorePerform.ShowDamagePop.OnBattle = core.events.battle;
	core.events.battle = function () {
		var hpBeforeBattle = core.status.hero.hp;
		Fux2.MorePerform.ShowDamagePop.OnBattle.apply(core.events, arguments);
		Fux2.MorePerform.ShowDamagePop.PopDamage(Math.floor(core.status.hero.hp - hpBeforeBattle));
	};

	// 注册每帧事件
	core.registerAnimationFrame("ShowDamagePop", true, Fux2.MorePerform.ShowDamagePop.Update.bind(Fux2.MorePerform.ShowDamagePop));

	// 弹出精灵类
	function PopSprite() {
		this.initialize.apply(this, arguments);
	}

	PopSprite.prototype = Object.create(Object.prototype);
	PopSprite.prototype.constructor = PopSprite;

	// 常量
	PopSprite._count = 0;
	PopSprite._baseZOrder = 30;
	PopSprite._floorDis = 30;
	PopSprite._font = '14px bold hanyifengshanghei45w';
	PopSprite._damageColor = '#FF8888';
	PopSprite._healColor = '#A0F753';
	PopSprite._outLineColor1 = '#FF8888';
	PopSprite._outLineColor2 = '#A0F753';
	PopSprite._maxLife = 80;

	// 初始化
	PopSprite.prototype.initialize = function (x, y, damage) {
		this._x = x;
		this._y = y;
		this._damage = damage;
		this.initAllMembers();
		this.requestCanvas();
	};

	// 自更新
	PopSprite.prototype.update = function () {
		if (this._timer < PopSprite._maxLife) {
			this._x += this._vx;
			this._y += this._vy;
			this._vy += this._gravity;
			if (this._y >= this._floorY) {
				this._y = this._floorY;
				this._vy *= -0.75;
			}
			core.relocateCanvas(this._symbol, this._x, this._y);
			core.setOpacity(this._symbol, 1 - this._timer / PopSprite._maxLife);
		} else {
			this.dispose();
		}
		this._timer++;
	};

	// 申请并描绘canvas
	PopSprite.prototype.requestCanvas = function () {
		core.createCanvas(this._symbol, this._x, this._y, this._width, this._height, this._z);
		var canvas = core.ui.getContextByName(this._symbol);
		canvas.font = PopSprite._font;
		if (this._damage <= 0) {
			canvas.fillStyle = PopSprite._damageColor;
			canvas.strokeStyle = PopSprite._outLineColor1;
			canvas.strokeText(this._text, 2, this._height);
			canvas.fillText(this._text, 2, this._height);
		} else if (this._damage > 0) {
			canvas.fillStyle = PopSprite._healColor;
			canvas.strokeStyle = PopSprite._outLineColor2;
			canvas.strokeText(this._text, 2, this._height);
			canvas.fillText(this._text, 2, this._height);
		}
	};

	// 初始化所有成员变量

	PopSprite.prototype.initAllMembers = function () {
		this._text = String(this._damage);
		if (flags.fkjx === 1) {
			this._text += ' ↑';
			core.playSound('回血');
			core.drawAnimate('recover', core.getHeroLoc('x'), core.getHeroLoc('y'))
		}

		var uiContext = core.ui.getContextByName('ui');
		uiContext.font = PopSprite._font;
		var textRect = uiContext.measureText(this._text);
		this._width = Math.round(textRect.width + 4);
		this._height = 16;
		this._z = PopSprite._baseZOrder + PopSprite._count;
		this._symbol = 'popSprite' + PopSprite._count++;
		this._alive = true;
		this._vx = -2 + Math.random() * 4;
		this._vy = -3 - Math.random() * 4;
		this._gravity = 0.5;
		this._floorY = this._y + PopSprite._floorDis;
		this._timer = 0;
	};

	// 判断是否存活
	PopSprite.prototype.isAlive = function () {
		return this._alive;
	};

	// 释放
	PopSprite.prototype.dispose = function () {
		this._alive = false;
		core.deleteCanvas(this._symbol);
	};

},
    "NPC悬停": function () {
	//怪物显示复写而成
	//使用方法：启用useEnemyInfoDisplay为true，并且在想要显示信息的npc处，events事件最开头添加注释，内容为想要显示的片段，多行用多个注释，每个注释一行
	this.startEnemyInfoDisplay = function (enemy_x, enemy_y) {
		var blk = core.getBlock(enemy_x, enemy_y);
		if (!blk || !blk.event || !blk.event.data) return;
		var dt = core.getBlock(enemy_x, enemy_y).event.data;
		if (!dt || !dt[0] || !dt[0].type || dt[0].type != 'comment') return;
		var cls = core.getBlockCls(enemy_x, enemy_y)
		if (cls != 'npcs' && cls != 'npc48' && cls != 'enemys' && cls != 'enemy48') return;
		var text = [dt[0].text];
		var lines = 1;
		while (lines < dt.length && dt[lines].type == 'comment') {
			text.push(dt[lines].text);
			lines++;
		}
		//在下面设置你的字体和字体大小
		var font = "hanyifengshanghei45w"; //这里"......"填写你的字体。
		var fontSize = 14;
		core.setFont('enemyInfo', "14px hanyifengshanghei45w");
		var width = core.ui.calWidth('enemyInfo', text, font) - 220;
		var height = 68 + 40 * lines;
		var cell_x = (enemy_x + 0.5) * 32 - core.bigmap.offsetX;
		var cell_y = (enemy_y + 0.5) * 32 - core.bigmap.offsetY;

		//绘制窗口
		core.plugin.addBasics(width, height, cell_x, cell_y, fontSize, core.getBlockId(enemy_x, enemy_y), font, text);
	}

	//这个子程序用来绘制怪物的基本信息
	this.addBasics = function (width, height, cell_x, cell_y, fontSize, mon_id, font, text) {
		//绘制窗口外观
		width = 0;
		for (let i = 0; i < text.length; i++) {
			let tmp = core.drawTextContent('enemyInfo', core.replaceValue(text[i]), { left: cell_x + 10, top: cell_y + 60 + i * 40, align: 'mid', font: font, fontSize: fontSize });
			let tt = tmp.blocks[tmp.blocks.length - 1];
			width = Math.max(width, tt.left + tt.width + 20);
		}
		core.clearMap('enemyInfo');
		if (cell_x > 32 * core.__SIZE__ - width) cell_x -= width;
		if (cell_y > 32 * core.__SIZE__ - height) cell_y -= height;

		core.fillRoundRect("enemyInfo", cell_x, cell_y, width, height, 5, [0, 0, 0, 0.7]);
		core.strokeRoundRect("enemyInfo", cell_x, cell_y, width, height, 5, [255, 255, 255, 1], 2);
		//绘制抬头、怪物图标和怪物名称
		core.drawIcon('enemyInfo', mon_id, cell_x + width / 2 - 16, cell_y + 10);
		// 		core.fillText("enemyInfo", info[mon_id].name, cell_x + width / 2 - info[mon_id].name.length * fontSize / 8 -
		// 			info[mon_id].name.replace(/[()]/g, '').length * fontSize / 8 - info[mon_id].name.replace(/[-_ ()0-9a-zA-Z]/g, '').length *
		// 			fontSize / 4, cell_y + 78 + bigEnemy, [255, 255, 255, 1], fontSize + "px " + font);
		for (let i = 0; i < text.length; i++) {
			core.drawTextContent('enemyInfo', core.replaceValue(text[i]), { left: cell_x + 10, top: cell_y + 60 + i * 40, align: 'mid', font: font, fontSize: fontSize });
		}
	}

	//这个子程序调整字体的亮度
	this.changeColor = function (color, Increment) {
		var r = parseInt(color.slice(1, 3), 16);
		var g = parseInt(color.slice(3, 5), 16);
		var b = parseInt(color.slice(5, 7), 16);
		//I代表灰度
		var I = (r + g + b) / 3 + 0.001;
		//PS亮度算法
		var I_new = I + Increment - 128.0;
		var r_new = core.clamp(Math.round(r + (256.0 - r) * I_new / 128.0), 0, 255);
		var g_new = core.clamp(Math.round(g + (256.0 - g) * I_new / 128.0), 0, 255);
		var b_new = core.clamp(Math.round(b + (256.0 - b) * I_new / 128.0), 0, 255);
		r = r_new.toString(16);
		g = g_new.toString(16);
		b = b_new.toString(16);
		color = "#" + r + g + b;
		return color;
	}

	//如果鼠标移动，则Register Action
	core.registerAction('onmove', 'enemyInfoDisplay', function (mouse_x, mouse_y) {
		core.plugin.enemyInfoDisplay(mouse_x, mouse_y);
		return false;
	}, 100);

	//主程序，当鼠标移动时进行判断
	this.enemyInfoDisplay = function (mouse_x, mouse_y) {
		//使用需要3个条件：打开开关、拥有怪物手册和玩家在电脑端上游戏
		if (core.getFlag("useEnemyInfoDisplay") == true && core.hasItem("book") && core.platform.isPC == true) {
			core.createCanvas("enemyInfo", 0, 0, 486, 486, 81);
			//这里处理大地图带来的影响
			offsetX = core.bigmap.offsetX;
			offsetY = core.bigmap.offsetY;
			//获得鼠标对应的图块坐标位置
			var enemy_x = core.clamp(Math.floor((mouse_x + offsetX / (32 * core.domStyle.scale))), core.bigmap.offsetX /
				(32 * core.domStyle.scale), core.__SIZE__ - 1 + core.bigmap.offsetX / (32 * core.domStyle.scale));
			var enemy_y = core.clamp(Math.floor((mouse_y + offsetY / (32 * core.domStyle.scale))), core.bigmap.offsetY /
				(32 * core.domStyle.scale), core.__SIZE__ - 1 + core.bigmap.offsetY / (32 * core.domStyle.scale));
			//如果该图块有怪物，则绘制窗口
			core.plugin.startEnemyInfoDisplay(enemy_x, enemy_y);
		}
	}

	//备用程序，获得鼠标的位置，出错时使用
	main.dom.data.onmousemove2 = function (e) {
		e.stopPropagation();
		var loc = main.core.actions._getClickLoc(e.clientX, e.clientY);
		if (loc == null) return;
		main.core.onmove(loc);
		return [e.clientX, e.clientY];
	}

	//楼层转换后，怪物消失。但是如果鼠标不移动，窗口会继续显示降低玩家体验
	//复写一下楼层转换，使得楼层转换后窗口不再继续显示
	events.prototype.changeFloor = function (floorId, stair, heroLoc, time, callback) {
		var info = this._changeFloor_getInfo(floorId, stair, heroLoc, time);
		if (info == null) {
			if (callback) callback();
			return;
		}
		floorId = info.floorId;
		info.locked = core.status.lockControl;

		core.dom.floorNameLabel.innerText = core.status.maps[floorId].title;
		core.lockControl();
		core.stopAutomaticRoute();
		core.clearContinueAutomaticRoute();
		core.status.replay.animate = true;
		clearInterval(core.interval.onDownInterval);
		core.interval.onDownInterval = 'tmp';
		core.clearMap("enemyInfo");
		this._changeFloor_beforeChange(info, callback);
	}
},
    "连通岩浆": function () {
	// 在此增加新插件
	core.continuousShovel = function () {
		flags._lavaBox_ = []
		var sand = [
			[core.nextX(), core.nextY()]
		];
		var width = core.floors[core.status.floorId].width;
		var height = core.floors[core.status.floorId].height;
		var visited = [];
		for (var i = 0; i < core.floors[core.status.floorId].width; ++i) {
			for (var j = 0; j < core.floors[core.status.floorId].height; ++j) {
				visited[j * width + i] = false;
			}
		}
		visited[core.nextY() * width + core.nextX()] = true;
		var floodId = core.status.floorId;
		core.status.floorId = null;
		while (sand.length != 0) {
			var f = sand.shift();
			//此处可写破次数
			flags._lavaBox_.push([f[0], f[1]])
			var nw = [
				[f[0] + 1, f[1]],
				[f[0] - 1, f[1]],
				[f[0], f[1] + 1],
				[f[0], f[1] - 1]
			];
			for (var t in nw) {
				if (nw[t][0] < 0 || nw[t][0] >= width || nw[t][1] < 0 || nw[t][1] >= height) continue;
				if (visited[nw[t][1] * width + nw[t][0]]) continue;
				visited[nw[t][1] * width + nw[t][0]] = true;
				var blk = core.getBlock(nw[t][0], nw[t][1], floodId);
				if (blk && blk.id == 5) {
					sand.push(nw[t]);
				}
			}
		}
		core.status.floorId = floodId;
	}
}
}