﻿var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 =
{
	"init": function () {

		console.log("插件编写测试");

		// 可以写一些直接执行的代码
		// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
		// 请勿在这里对包括bgm，图片等资源进行操作。


		this._afterLoadResources = function () {
			// 本函数将在所有资源加载完毕后，游戏开启前被执行
			// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

			// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
			// var arr = core.splitImage("assets.png", 32, 32);
			// for (var i = 0; i < arr.length; i++) {
			//     core.material.images.images["asset"+i+".png"] = arr[i];
			// }

		}
		
		this.moveGuard = function(){
			if(core.getFlag("type")==1){
				var x = core.getFlag("x"),y = core.getFlag("y");
				if(core.getBlock(x,y) || core.getBgNumber(x,y)!=316){
					core.drawTip("不能移动到此处！");
					return;
				}else{
					var blk = core.getBlock(core.status.event.data.x, core.status.event.data.y);
					blk.block.x = x;
					blk.block.y = y;
					core.removeFlag("temp");
					core.drawMap();
					core.clearMap("ui");
				}
			}
		}

		this.equipShop = function(){
			var swdId = Math.min(5,core.getFlag("sword",1));
			var shdId = Math.min(5,core.getFlag("shield",1));
			var sword = "sword"+swdId;
			var shield = "shield"+shdId;
			var atk = core.material.items[sword].equip.atk;
			var def = core.material.items[shield].equip.def;
			var cost = [0,10,17,25,34,45];
			var data = [
				{"type": "choices", "text": "\t[助手,man]选择剑或者盾（购买后需要按Q或者装备栏进行装备）", "choices": [
					{"text": core.material.items[sword].name+"("+atk+"攻击力:"+cost[swdId]+"金币）", "icon": sword, "action": [
						{"type": "if", "condition": "status:money>="+cost[swdId],
						"true": [
							{"type": "addValue", "name": "item:"+sword, "value": "1"},
							{"type": "addValue", "name": "flag:sword", "value": "1"},
							{"type": "addValue", "name": "status:money", "value": "-"+cost[swdId]},
						],
						"false": [
						  "\t[助手,man]钱不够。",
						]
						},
					  ]},
					{"text": core.material.items[shield].name+"("+def+"防御力:"+cost[shdId]+"金币）", "icon": shield, "action": [
					{"type": "if", "condition": "status:money>="+cost[shdId],
					"true": [
						{"type": "addValue", "name": "item:"+shield, "value": "1"},
						{"type": "addValue", "name": "flag:shield", "value": "1"},
						{"type": "addValue", "name": "status:money", "value": "-"+cost[shdId]},
					],
					"false": [
						"\t[助手,man]钱不够。",
					]
					},
					]},
				  {"text": "离开", "action": [
				  ]},
				]},
			  ];
			core.insertAction(data);
		}


		//table
		var table = {
			's': {
				name: "水",
				special: 29,
				mons: [327, 232],
				item: 32,
				weak: 'h',
				gen: 'm',
				dir: "down",
				pos: { x: 6, y: 1 },
				color:[0,255,254,1]
			},
			"m": {
				name: "木",
				special: 28,
				mons: [204, 260],
				item: 29,
				weak: 't',
				gen: 'h',
				dir: "left",
				pos: { x: 11, y: 6 },
				color:[10,255,0,1]
			},
			"h": {
				name: "火",
				special: 30,
				mons: [218, 326],
				item: 27,
				weak: 'j',
				gen: 't',
				dir: "up",
				pos: { x: 6, y: 11 },
				color: [255,0,0,1]
			},
			"j": {
				name: "金",
				special: 27,
				mons: [244, 226],
				item: 28,
				weak: 'm',
				gen: 's',
				dir: "right",
				pos: { x: 1, y: 6 },
				color: [221,255,0,1],
			},
			"t": {
				name: "土",
				special: 31,
				mons: [30, 30],
				item: 30,
				weak: 's',
				gen: 'j',
				dir: "up",
				pos: { x: 6, y: 7 },
				color:[143,100,57,1]
			}
		}
		
		this.drawRelation = function(){
			var attr = core.status.hero.attr;
			var color = [255,255,255,1];
			var name = "无";
			if(attr){
				color = table[attr].color;
				name = table[attr].name;
			}
			var t1 = "无";
			var t2 = "";
			if(attr){
				t1 = name+"克"+table[table[attr].weak].name;
				t2 = name + "生" + table[table[attr].gen].name;
			}
			var data = [
				{"type": "previewUI", "action": [
				  {"type": "fillRect", "x": 0, "y": 325, "width": 96, "height": 96, "style": [0,0,0,1]},
				  {"type": "fillText", "x": 6, "y": 345, "style": [255,255,255,1], "font": "17px Verdana", "text": "当前属性"},
				  {"type": "fillText", "x": 36, "y": 388, "style": color, "font": "bold 30px Verdana", "text": name},
				  {"type": "fillRect", "x": 320, "y": 325, "width": 96, "height": 96, "style": [0,0,0,1]},
				  {"type": "fillText", "x": 326, "y": 345, "style": [255,255,255,1], "font": "17px Verdana", "text": "生克关系"},
				  {"type": "fillText", "x": 346, "y": 375, "style": [255,255,255,1], "font": "bold 17px Verdana", "text": t1},
				  {"type": "fillText", "x": 346, "y": 400, "style": [255,255,255,1], "font": "bold 17px Verdana", "text": t2},
				]},
			  ];
			
			core.insertAction(data);
		}

		// 时间步动作：
		// 1. 检查各个怪物位置，如果在守护者旁边就进行消灭
		// 2. 检查当前时间点。是否需要产生新的兵
		// 3. 
		this.goTime = function () {
			var genSep = core.getFlag("genSep", 5);//按回合生成新怪物
			var timeStep = core.getFlag("timeStep", 0);//时间戳
			genSep = Math.max(1,parseInt(genSep));
			timeStep += 1;
			core.setFlag("timeStep", timeStep);
			if (timeStep % genSep == 0) {
				core.addFlag("genTime",1);
				for (var a in table) {
					if(a!='t'){
						var big = false;
						var bigSep =  Math.max(1,core.getFlag("bigSep",3));
						if(core.getFlag("genTime",0) % bigSep==0)big=true;
						core.genMonster(a,big);
					}
				}
			}
			core.events._trigger(2,0);
		}

		var back_attr = {
			167: "s",
			304: "j",
			319: "h",
			301: "m",
			316: "t",
		}
		this.getAttrByBg = function (x, y) {
			var num = core.getBgNumber(x, y);
			var attr = back_attr[num];
			return attr;
		}
		this.getGenAttr = function (attr) {
			return table[attr].gen;
		}
		this.getAttrBySpecial = function (special) {
			for (a in table) {
				if (core.hasSpecial(special, table[a].special)) {
					return a;
				}
			}
			return null;
		}
		this.getAttrName = function (attr) {
			if (attr)
				return table[attr].name;
			return "无";
		}

		//1克制2
		this.isWeakTo = function (attr1, attr2) {
			return table[attr1].weak == attr2;
		}

		this.genMonster = function (attr, big, callback) {
			if (attr == "t") { core.setBlock(123, 6, 6); if(callback)callback();return; };
			var info = table[attr];
			var monId = info.mons[0];
			if (big) {
				monId = info.mons[1];
			}
			var dir = info.dir;
			var pos = info.pos;
			var x = pos.x, y = pos.y;
			var dx = core.utils.scan[dir].x,
				dy = core.utils.scan[dir].y;
			var todo = [];
			if (!core.getBlock(x - dx, y - dy)) return;

			var guardList = [];
			core.status.thisMap.blocks.forEach(function(blk){
				if(blk.id==123){
					guardList.push(blk.x+","+blk.y);
				}
			});
			while (x != 6 || y != 6) {
				var blk = core.getBlock(x, y);
				
				if (blk && blk.block.id!=123){
					var idx = guardList.indexOf((x+dx)+","+(y+dy));
					if(idx>=0){
						core.removeBlock(x,y);
						core.removeBlock(x+dx,y+dy);
						delete guardList[idx];
						core.genItem("j");
					}else{
						todo.push({ "type": "move", "loc": [x, y], "time": 300, "keep": true, "async": true, "steps": [dir] });
					}
				}
				x += dx; y += dy;
			}
			todo.push({ "type": "waitAsync" });
			todo.push({ "type": "setBlock", "number": monId, "loc": [pos.x, pos.y] });
			core.insertAction(todo,null,null,function(){
				if(callback)callback();
				var checkLoseFunc = function(){
					var blk = core.getBlock(6,6);
					if(blk && blk.block.id!=123){
						core.lose("be");
					}
				}
				var hx = core.getHeroLoc("x"),
					hy = core.getHeroLoc("y");
				blk = core.getBlock(hx,hy);
				if(blk && blk.block.event.cls=="enemys"){
					core.battle(blk.block.event.id,hx,hy,true,checkLoseFunc);
				}else{
					checkLoseFunc();
				}
				
			});
		}

		this.genItem = function (attr) {
			var info = table[attr];
			var dir = info.dir;
			var pos = info.pos;
			var dx = 1 - Math.abs(core.utils.scan[dir].x),
				dy = 1 - Math.abs(core.utils.scan[dir].y);

			//if (attr != 't' && !core.getBlock(pos.x - core.utils.scan[dir].x, pos.y - core.utils.scan[dir].y)) return;
			var ret = [-2, -1, 1, 2].some(function (i) {
				var x = pos.x + dx * i,
					y = pos.y + dy * i;
				if (!core.getBlock(x, y)) {
					core.setBlock(info.item, x, y);
					return true;
				}
			});
			if (!ret) {
				core.getItem("yellowKey", 1);
			}
		}

		core.registerSystemEvent('custom', function(data, callback){
			core.insertAction([
				{"type": "insert", "loc": [1,0]},
			  ],data.x,data.y,callback);
		});

		events.prototype.battle = function (id, x, y, force, callback) {
			core.saveAndStopAutomaticRoute();
			id = id || core.getBlockId(x, y);
			if (!id) return core.clearContinueAutomaticRoute(callback);
			// 非强制战斗
			if (!core.enemys.canBattle(id, x, y) && !force && !core.status.event.id) {
				core.drawTip("你打不过此怪物！");
				return core.clearContinueAutomaticRoute(callback);
			}
			// 自动存档
			if (!core.status.event.id && !force) core.autosave(true);
			// 战前事件
			if (!this.beforeBattle(id, x, y))
				return core.clearContinueAutomaticRoute(callback);
			// 战后事件
			this.afterBattle(id, x, y, callback);
		}

		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
		// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
	},
	"drawLight": function () {

		// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
		// 【参数说明】
		// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
		// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
		// lights：可选，一个数组，定义了每个独立的灯光。
		//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
		// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
		//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
		// 【调用样例】
		// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
		// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
		// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
		// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
		// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
		this.drawLight = function (name, color, lights, lightDec) {

			// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
			var ctx = core.getContextByName(name);
			if (ctx == null) {
				if (typeof name == 'string')
					ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
				else return;
			}

			ctx.mozImageSmoothingEnabled = false;
			ctx.webkitImageSmoothingEnabled = false;
			ctx.msImageSmoothingEnabled = false;
			ctx.imageSmoothingEnabled = false;

			core.clearMap(name);
			// 绘制色调层，默认不透明度
			if (color == null) color = 0.9;
			ctx.fillStyle = "rgba(0,0,0," + color + ")";
			ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

			lightDec = core.clamp(lightDec, 0, 1);

			// 绘制每个灯光效果
			ctx.globalCompositeOperation = 'destination-out';
			lights.forEach(function (light) {
				// 坐标，半径，中心不透明度
				var x = light[0],
					y = light[1],
					r = light[2];
				// 计算衰减距离
				var decDistance = parseInt(r * lightDec);
				// 正方形区域的直径和左上角坐标
				var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
				grd.addColorStop(0, "rgba(0,0,0,1)");
				grd.addColorStop(1, "rgba(0,0,0,0)");
				ctx.beginPath();
				ctx.fillStyle = grd;
				ctx.arc(x, y, r, 0, 2 * Math.PI);
				ctx.fill();
			});
			ctx.globalCompositeOperation = 'source-over';
			// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
		}
	},
}