# 第二章：怪物特殊属性定义（getSpecials），表格配置

要求：读懂脚本编辑 - 怪物特殊属性定义（getSpecials）的实现。理解如何定义一个新的怪物属性。同时，还需要理解如何给怪物表格增加新项目。

回答如下问题：

1. 如何定义一个新的怪物属性？

2. 如何取得当前怪物的各项数值？

3. 第五项参数在哪些情况下写1？为什么需要？

4. 如何给怪物表格定义新项目？如何在伤害计算等地方取用定义的新项目？

5. 当前，有一部分怪物属性使用了相同的表格项，如阻激夹域都使用了`value`等；这样无法同时给怪物增加吸血和领域两个属性。那应该怎么做才能同时支持这两项？

6. 理解《咕工智障》的下述怪物特殊属性并回答：
    - 如果一个该属性怪物设置了`hpValue = 10, range = 2`，那么怪物手册中显示该怪物的特殊属性名和描述是什么？
    - 如果一个该属性怪物设置了`hpValue = -20, defValue = 30`，那么怪物手册中显示该怪物的特殊属性名和描述是什么？
    - 如果一个该属性怪物设置了`hpValue = 10, atkValue = 20, defValue = 30, add = true`，那么怪物手册中显示该怪物的特殊属性名和描述是什么？
    - 如果怪物手册中的描述是`周围方形范围内5格的友军生命提升10%，攻击降低20%，线性叠加`，那么该怪物的哪些项被设置了成了多少？该怪物的特殊属性名是什么？
    - 如果怪物手册中的描述是`周围十字范围内3格的友军生命提升20%，攻击提升10%，防御提升5%，不可叠加`，那么该怪物的哪些项被设置了成了多少？该怪物的特殊属性名是什么？

    ```js
    [25, function (enemy) {
        if (enemy.auraName) return enemy.auraName;
        if (enemy.hpValue && enemy.atkValue && enemy.defValue) return "魔力光环";
        if (enemy.hpValue) {
            if (enemy.hpValue > 0) return "活力光环";
            return "懒散光环";
        }
        if (enemy.atkValue) {
            if (enemy.atkValue > 0) return "狂暴光环";
            return "静谧光环";
        }
        if (enemy.defValue) {
            if (enemy.defValue > 0) return "坚毅光环";
            return "软弱光环";
        }
        return "光环";
    }, function (enemy) {
        var str;
        if (!enemy.range) {
            str = "同楼层所有友军";
        } else {
            str = "周围" + (enemy.zoneSquare ? "方形" : "十字") 
                + "范围内\r[yellow]" + (enemy.range || 1) + "\r格的友军";
        }
        if (enemy.hpValue) {
            if (enemy.hpValue > 0) str += "生命提升\r[yellow]" + enemy.hpValue + "%\r，";
            else str += "生命降低\r[yellow]" + (-enemy.hpValue) + "%\r，";
        }
        if (enemy.atkValue) {
            if (enemy.atkValue > 0) str += "攻击提升\r[yellow]" + enemy.atkValue + "%\r，";
            else str += "攻击降低\r[yellow]" + (-enemy.atkValue) + "%\r，";
        }
        if (enemy.defValue) {
            if (enemy.defValue > 0) str += "防御提升\r[yellow]" + enemy.defValue + "%\r，";
            else str += "防御降低\r[yellow]" + (-enemy.defValue) + "%\r，";
        }
        str += (enemy.add ? "线性叠加" : "不可叠加");
        return str;
    }, "#e6e099", 1],
    ```

7. 理解《咕工智障》的下述怪物特殊属性并回答：
    - 吸血数值是如何计算在怪物手册之中的？
    - 如何根据角色当前拥有的道具或者变量来修改怪物属性描述？
    - 如果要让简单难度下，怪物吸血值减半，特殊属性定义中应该怎么修改？

    ```js
    [11, "吸血", function (enemy) {
        var str = "\r[\#e525ff]【红海技能】\r战斗前，首先吸取对方的" 
            + Math.floor(100 * enemy.value || 0) + "%生命（约" 
            + Math.floor((enemy.value || 0) * core.getRealStatus('hp')) + "点）作为伤害" 
            + (enemy.add ? "，并把伤害数值加到自身生命上" : "");
        if (core.hasItem("I_noVampire")) str += "\r[yellow]（对你无效）\r";
        return str;
    }, "#ff00d2"],
    ```

8. 定义同时满足如下条件的特殊属性（编号`28`），并和《咕工智障》的写法进行比较。
    - 当怪物的 `value28 > 0` 时，特殊属性名为`迅捷光环`
    - 当怪物的 `value28 <= 0` 时，特殊属性名为`怠惰光环`
    - 当难度为简单（`flag:hard = 1`）时，描述为`此技能在简单难度下无效！`
    - 当角色拥有道具 `I123` 时，描述为`此技能已被魔杖抵消！`
    - 当怪物的 `range > 0` 时，描述存在`周围[方形/十字]范围内[?]格的友军`；其中这`[]`里面内容由怪物的 `zoneSquare` 和 `range` 决定。
    - 当怪物的 `range = null` 时，描述存在`当前楼层的友军`
    - 当怪物的 `value28 > 0` 时，描述存在`先攻X回合`，其中X由`value28`决定（如，`value28 = 5`时，描述存在`先攻5回合`）
    - 当怪物的 `value28 <= 0` 时，描述存在`被先攻X回合`，其中X由`value28`决定（如，`value28 = -5`时，描述存在`被先攻5回合`）

9. 定义同时满足如下条件的特殊属性（编号`30`），并和《咕工智障》的写法进行比较。
    - 特殊属性名：匙之力
    - 当怪物的 `range > 0` 时，描述存在`周围[方形/十字]范围内[?]格内`；其中这`[]`里面内容由怪物的 `zoneSquare` 和 `range` 决定。
    - 当怪物的 `range = null` 时，描述存在`同楼层内`
    - 描述存在 `每存在一个黄钥匙，生命增加X点，攻击增加Y点，防御增加Z点`，其中`X, Y, Z`由怪物的`value, atkValue, defValue`决定。如果其中某一项为0或null则不显示对应项。（例如，如果`value = 30, defValue = 20`则只显示`生命增加30点，防御增加20点`）

10. 将阻击、激光、领域、吸血所使用的特殊属性值（当前均为`value`）分离，并实现一个怪物同时拥有`阻击伤害100点，激光伤害50点，领域伤害200点，且吸血20%`这四个特殊属性。
    - 需在怪物手册正确显示
    - 需正确实现对应的效果（需要修改`伤害计算（getDamageInfo）和阻激夹域伤害（updateCheckBlock）`两个函数）

[点此查看答案](L2_answer)
