var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}
	this.drawCursor = function (cursorX, cursorY) {
		core.clearMap('curtain');
		var width = 4;
		core.strokeRect('curtain', 32*cursorX+width/2, 32*cursorY+width/2,
			32-width, 32-width, '#FFD700', width);
	}

	
	var dir = ['up','left','down','right'];
	var inv = {
		'down':'up',
		'left':'right',
		'up':'down',
		'right':'left',
	}
	var turn = ['up','right','down','left'];

	var customBlock = function(data, callback){
		var x = data.x,
			y = data.y,
			id = data.id;
		var heroDir = core.getHeroLoc('direction');
		switch(id){
			case 13:
			case 14:
			core.turnHero(turn[(turn.indexOf(heroDir) + (27-id*2) + 4)%4]);
			if(core.getFlag('switch',0)>0){
				core.addFlag('switch',-1);
				core.setBlock(id==13?14:13,x,y);
			}
			break;
			case 91:
			case 92:
			case 93:
			case 94:
			core.turnHero(dir[id - 91]);
			if(core.getFlag('switch',0)>0){
				core.addFlag('switch',-1);
				core.setBlock(dir.indexOf(inv[dir[id - 91]])+91,x,y);
			}
			break;
			case 89:
			core.turnHero(inv[heroDir]);
			break;
			case 104:
			core.removeBlock(x,y);
			core.addFlag('switch',1);
			break;
		}
	}

	var originReplay = core.control.replay;
	var tempQueue = [];
	this.startGo = function(){
		if(core.isReplaying())return;
		core.setFlag('play',true);
		core.closePanel();
		core.lockControl();
		core.replay = core.goAhead;
		tempQueue = []
		core.goAhead();
		if(core.hasFlag('canCho') && core.getFlag('chooseIdx',-1)>=0){
			var blk = core.status.thisMap.blocks[core.getFlag('chooseIdx')];
			core.setFlag('choX',blk.x);
			core.setFlag('choY',blk.y);
		}
	}
	this.endGo = function(newOpt){
		tempQueue = [];
		if(newOpt)
			core.insertAction([{"type":"insert","loc":[1,1],"floorId":"ET"}]);
		if(core.isReplaying())return;
		core.setFlag('play',false);
		core.replay = originReplay;
	}

	this.goAhead = function(){
		if(core.hasFlag('play')){
			core.lockControl();
			if(core.status.route.length > 3000 || core.status.hero.steps > 1000){
				core.events.win('be3',1);
				return;
			}
			if(core.status.replay.pausing || core.status.replay.animate || core.status.event.id)return;
			tempQueue.push(core.status.hero.steps);
			if(tempQueue.length>=3 && tempQueue[0]== tempQueue[1] &&  tempQueue[1] ==  tempQueue[2]){
				if(tempQueue.length<5 && core.getFlag('chooseIdx',-1)>=0){
					core.events._trigger(core.getFlag('choX'),core.getFlag('choY'));
					tempQueue=[];
				}else{
					core.endGo();
					core.events.win('be2',1);
					return true;
				}
			}else if(tempQueue.length>=4){
				tempQueue.shift();
			}
			core.control._doReplayAction(core.getHeroLoc('direction'));
		}
		return false;
	}

	core.registerSystemEvent('custom', customBlock);
	//  
	this.clickHero = function(){
		if(!core.hasFlag('play')){
			setTimeout(core.startGo);
		}else{
			core.endGo(true);
		}
		core.updateStatusBar();
	}
	main.statusBar.hard.onclick = function(e){
		e.stopPropagation();
		if(core.hasFlag('play')){
			core.endGo();
			core.control._doSL_load('autoSave');
		}
	}
	
	// rewrite
	var originAutoSave = core.control.autosave;
	core.control.autosave = function(removeLast){
		if(removeLast)return;
		originAutoSave();
	}

	////// 战斗 //////
	core.events.battle = function (id, x, y, force, callback) {
		core.saveAndStopAutomaticRoute();
		id = id || core.getBlockId(x, y);
		if (!id) return core.clearContinueAutomaticRoute(callback);
		// 非强制战斗
		if (!core.enemys.canBattle(id, x, y) && !force && !core.status.event.id) {
			core.drawTip("你打不过此怪物！");
			core.turnHero(inv[core.getHeroLoc('direction')]);
			return core.clearContinueAutomaticRoute(callback);
		}
		// 自动存档
		if (!core.status.event.id) core.autosave(true);
		// 战前事件
		if (!this.beforeBattle(id, x, y))
			return core.clearContinueAutomaticRoute(callback);
		// 战后事件
		this.afterBattle(id, x, y, callback);
	}


	// dom 
	////// 点击状态栏中的存档按钮时 //////
	main.statusBar.image.save.onclick = function (e) {
		e.stopPropagation();
		if(main.core.isPlaying() && !core.hasFlag('play')){
			if(core.status.event.id != 'action'){//通过点book来关闭book时会导致bug 所以加此判断
				core.closePanel();
				core.insertAction(core.floors['ET'].events['1,1']);
			}else{
				core.insertAction([
					{"type": "callSave"},
				]);
				core.doAction();// 不可少？也可用触发事件
			}
			return ;
		}
		if (core.isReplaying()) {
			if(core.getFlag('myReplay',false))return;
			core.speedDownReplay();
			return;
		}

		if (main.core.isPlaying() && (core.status.event||{}).id=='paint') {
			core.actions.savePaint();
			return;
		}

		if (main.core.isPlaying())
			main.core.save(true);
	}
	
	////// 点击状态栏中的怪物手册时 //////
	main.statusBar.image.book.onclick = function (e) {
		e.stopPropagation();
		if(main.core.isPlaying() && !core.hasFlag('play')){
			if(core.status.event.id != 'action'){//通过点book来关闭book时会导致bug 所以加此判断
				core.closePanel();
				core.insertAction(core.floors['ET'].events['1,1']);
			}else{
				core.insertAction([
					{"type": "callBook"},
				]);
				core.doAction();// 不可少？也可用触发事件
			}
			return ;
		}
		if (core.isReplaying()) {
			core.triggerReplay();
			return;
		}

		if (main.core.isPlaying() && (core.status.event||{}).id=='paint') {
			core.actions.setPaintMode('paint');
			return;
		}

	}

	////// 点击状态栏中的读档按钮时 //////
	main.statusBar.image.load.onclick = function (e) {
		e.stopPropagation();

		if(main.core.isPlaying() && !core.hasFlag('play')){
			if(core.status.event.id != 'action'){//通过点book来关闭book时会导致bug 所以加此判断
				core.closePanel();
				core.insertAction(core.floors['ET'].events['1,1']);
			}else{
				core.insertAction([
					{"type": "callLoad"},
				]);
				core.doAction();// 不可少？也可用触发事件
			}
			return ;
		}

		if (core.isReplaying()) {
			core.speedUpReplay();
			return;
		}

		if (main.core.isPlaying() && (core.status.event||{}).id=='paint') {
			core.actions.loadPaint();
			return;
		}
	}




	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
"statusBar": function () {
	//新建一个名为statusBar的地图
	//状态栏和道具栏均为双层图层，且较高图层也低于字体层
	//事件层前四行是手机statusBar的底层，最后两行是手机toolBar的底层
	//前景层前四行是手机statusBar的较高层，最后两行是手机toolBar的较高层
	//背景层左边四列是电脑statusBar的较低层，右边四列是statusBar的较高层

	//创建statusBar画布和toolBar画布
	this.drawMyStatus = function () {
		if (!core.isset(core.floors.statusBar)) return;
		if (core.isset(document.getElementById("myStatusCanvas1"))) {
			document.getElementById("myStatusCanvas1").remove();
			document.getElementById("myStatusCanvas2").remove();
		}
		if (core.isset(document.getElementById("myToolBar1"))) {
			document.getElementById("myToolBar1").remove();
			document.getElementById("myToolBar2").remove();
		}
		//画布的动画采用
		core.statusAnimate = [];
		core.autotileAnimate = [];
		var bar = document.getElementById('statusBar');
		var toolBar = document.getElementById('toolBar');
		//var myStatusCanvas1=core.createMyStatusCanvas();
		if (!core.isset(core.arrayMap)) {
			//change
			core.arrayMap = new Object();
			core.myCanvas = new Object();
			var i;
			for (i = 0; i < bar.childElementCount; i++) {
				bar.children[i].style.zIndex = 10;
			}
			for (i = 0; i < toolBar.childElementCount; i++) {
				toolBar.children[i].style.zIndex = 10;
			}
			//这些数组，主要是判断autotile
			core.arrayMap.statusArray = core.splitMaps(core.floors.statusBar.map, 0, 0, 13, 4);
			core.arrayMap.statusArray2 = core.splitMaps(core.floors.statusBar.fgmap, 0, 0, 13, 4);
			core.arrayMap.toolBarArray = core.splitMaps(core.floors.statusBar.map, 11, 0, 13, 2);
			core.arrayMap.toolBarArray2 = core.splitMaps(core.floors.statusBar.fgmap, 11, 0, 13, 2);
			core.arrayMap.statusPCArray = core.splitMaps(core.floors.statusBar.bgmap, 0, 0, 4, 13);
			core.arrayMap.statusPCArray2 = core.splitMaps(core.floors.statusBar.bgmap, 0, 9, 4, 13);
		}
		core.createMyStatusCanvas();
		//根据屏幕垂直或者水平判断采用的toolbar
		if (core.domStyle.isVertical) {
			//手机
			core.createToolbarCanvas();
			core.plugin.fillStatusByMap();
			return;
		} else {
			//电脑
			core.plugin.fillPCStatusByMap();
			return;
		}
		//core.plugin.fillTheBlock(height,width,ctx);
		//core.dom.statusBar.style.borderTopWidth="3.5px";
		//core.dom.statusBar.style.borderLeftWidth="4px";
	}
	//分割地图,主要用于autotile的绘制
	this.splitMaps = function (arr, x, y, width, height) {
		if(arr.length==0)
		{
			var newArr = new Array();
			for (var i = x; i < x + height; i++) {
				newArr[i - x] = new Array();
				for (var j = y; j < y + width; j++) {
					newArr[i - x][j - y] = 0;
				}
			}
			return newArr;
		}
		var newArr = new Array();
		for (var i = x; i < x + height; i++) {
			newArr[i - x] = new Array();
			for (var j = y; j < y + width; j++) {
				newArr[i - x][j - y] = arr[i][j];
			}
		}
		return newArr;
	}
	core.maps.drawMyAutotileAnimate = function (block, animate, ctx,arr) {
		var x = block.x,
			y = block.y;
		// ------ 界面外的动画不绘制
		if (32 * x < core.bigmap.offsetX - 64 || 32 * x > core.bigmap.offsetX + core.__PIXELS__ + 32 ||
			32 * y < core.bigmap.offsetY - 64 || 32 * y > core.bigmap.offsetY + core.__PIXELS__ + 32 + 16) {
			return;
		}
		var cv = ctx;
		cv.clearRect(32 * x, 32 * y, 32, 32);
		core.maps._drawAutotile(cv, arr, block, 32, 0, 0, animate);
	}
	//电脑部分
	this.fillPCStatusByMap = function (ctx) {
		var i;
		var j;
		var block;
		var number;
		var statusBar=core.floors.statusBar;
		var arr = core.arrayMap.statusPCArray;
		var arr2 = core.arrayMap.statusPCArray2;
		ctx1 = core.myCanvas.myStatusCanvas1;
		ctx2 = core.myCanvas.myStatusCanvas2;
		for (i = 0; i <= 12; i++) {
			for (j = 0; j <= 3; j++) {
				//绘制图层及autotile
				number = arr[i][j];
				number1 = arr2[i][j];
				if (number != 0 )
				{
					block = core.initBlock(j, i, number, true, null);
					core.doMyBlock(block,ctx1,arr,0,0);	
				}				
				if (number1 != 0)
				{
					block = core.initBlock(j, i, number1, true, null);
					core.doMyBlock(block,ctx2,arr2,0,1);
				}
			}
		}
	}
	this.doMyBlock = function (block,ctx,arr,location,zIndex) {
		if (block.event.cls == "autotile") {
			core.maps._drawAutotile(ctx, arr, block, 32, 0, 0);
		} else core.maps.drawBlock(block, null, ctx);
		block.location = location;
		block.depth=zIndex;
		core.addStatusAnimate(block);

	}
	//手机statusBar和toolBar的显示
	this.fillStatusByMap = function () {
		var statusBar = core.floors.statusBar;
		var i;
		var j;
		var block;
		var number;
		var arr = core.arrayMap.statusArray;
		var arr2 = core.arrayMap.statusArray2;
		ctx1 = core.myCanvas.myStatusCanvas1;
		ctx2 = core.myCanvas.myStatusCanvas2;
		//statusbar的绘制
		for (i = 0; i <= 3; i++) {
			for (j = 0; j <= 12; j++) {
				//绘制图层及autotile
				number = arr[i][j];
				number1 = arr2[i][j];
				if (number != 0 )
				{
					block = core.initBlock(j, i, number, true, null);
					core.doMyBlock(block,ctx1,arr,0,0);	
				}				
				if (number1 != 0)
				{
					block = core.initBlock(j, i, number1, true, null);
					core.doMyBlock(block,ctx2,arr2,0,1);
				}
			}
		}
		//toolbar的绘制
		arr = core.arrayMap.toolBarArray;
		arr2 = core.arrayMap.toolBarArray2;
		toolBar1 = core.myCanvas.myToolBar1;
		toolBar2 = core.myCanvas.myToolBar2;
		for (i = 11; i <= 12; i++) {
			for (j = 0; j <= 12; j++) {
				//绘制图层及autotile
				number = arr[i-11][j];
				number1 = arr2[i-11][j];
				//block=core.initBlock(j,i-11,number,true,null);
				//core.maps.drawBlock(block,null,toolBar1,true);
				if (number != 0 )
				{
					block = core.initBlock(j, i-11, number, true, null);
					core.doMyBlock(block,toolBar1,arr,1,0);	
				}				
				if (number1 != 0)
				{
					block = core.initBlock(j, i-11, number1, true, null);
					core.doMyBlock(block,toolBar2,arr2,1,1);
				}
			}
		}

	}
	//加动画，在绘制动画里加入这些动画的绘制
	this.addStatusAnimate = function (block) {
		if (!block.event || block.event.animate == null) return;
		if (block.event.cls == 'autotile') {
			var id = block.event.id,
				img = core.material.images.autotile[id];
			if (!img || img.width == 96) return;
			core.autotileAnimate.push(block);
		} else {
			if (!block.event.animate || block.event.animate == 1) return;
			core.statusAnimate.push(block);
		}
	}
	//toolBar Canvas的创建
	this.createToolbarCanvas = function (bar) {

		var newCanvas = document.createElement('canvas');
		var newCanvas2;
		newCanvas.id = "myToolBar1";
		newCanvas.style.display = 'block';
		var width = 422;
		var height = 50;
		newCanvas.width = width;
		newCanvas.height = height;
		var x = 0.5;
		var y = 0;
		newCanvas.setAttribute("_left", x);
		newCanvas.setAttribute("_top", y);
		newCanvas.style.width = width * core.domStyle.scale + 'px';
		newCanvas.style.height = height * core.domStyle.scale + 'px';
		newCanvas.style.left = x * core.domStyle.scale + 'px';
		newCanvas.style.top = y * core.domStyle.scale + 'px';
		newCanvas.style.position = 'absolute';
		newCanvas.style.zIndex = 5;
		newCanvas2 = newCanvas.cloneNode();
		newCanvas2.style.zIndex = 6;
		newCanvas2.id = "myToolBar2";
		//core.dymCanvas[name] = newCanvas.getContext('2d');
		core.dom.toolBar.appendChild(newCanvas);
		core.dom.toolBar.appendChild(newCanvas2);
		core.myCanvas.myToolBar1 = newCanvas.getContext('2d');
		core.myCanvas.myToolBar2 = newCanvas2.getContext('2d');
		//core.dom.toolBar.style.borderRight="3px solid white";
		//core.dom.toolBar.style.borderRight="3px solid white";
		//return newCanvas.getContext('2d');
	}
	//statusBar Canvas的创建
	this.createMyStatusCanvas = function (bar) {
		var newCanvas1 = core.dom.statusCanvasCtx.canvas.cloneNode();
		var newCanvas2 = core.dom.statusCanvasCtx.canvas.cloneNode();
		newCanvas1.id = "myStatusCanvas1";
		newCanvas2.id = "myStatusCanvas2";
		newCanvas1.style.display = 'block';
		newCanvas2.style.display = 'block';
		newCanvas1.style.zIndex = 5;
		newCanvas2.style.zIndex = 6;
		//core.dom.statusCanvas.style.zIndex = 10;
		core.dom.statusBar.appendChild(newCanvas1);
		core.dom.statusBar.appendChild(newCanvas2);
		core.myCanvas.myStatusCanvas1 = newCanvas1.getContext('2d');
		core.myCanvas.myStatusCanvas2 = newCanvas2.getContext('2d');
	}
	//以下为复写函数
	//增加了参数ctx
	core.maps.drawBlock = function (block, animate, ctx, notClear) {
		if (block.event.id == 'none') return;
		var redraw = animate != null;
		if (!redraw) animate = 0;
		var x = block.x,
			y = block.y;
		// --- 在界面外的动画不绘制
		if (redraw && block.event.animate > 1 &&
			(32 * x < core.bigmap.offsetX - 64 || 32 * x > core.bigmap.offsetX + core.__PIXELS__ + 32 ||
				32 * y < core.bigmap.offsetY - 64 || 32 * y > core.bigmap.offsetY + core.__PIXELS__ + 32 + 16)) {
			return;
		}

		var blockInfo = this.getBlockInfo(block);
		if (blockInfo == null) return;
		if (blockInfo.cls != 'tileset') blockInfo.posX = animate % block.event.animate;
		if (!block.name)
			this._drawBlockInfo(blockInfo, block.x, block.y, ctx, notClear);
		else
			this._drawBlockInfo_bgfg(blockInfo, block.name, block.x, block.y);
	}

	core.maps._drawBlockInfo = function (blockInfo, x, y, ctx, notClear) {
		var image = blockInfo.image,
			posX = blockInfo.posX,
			posY = blockInfo.posY,
			height = blockInfo.height;
		if (!notClear) {
			core.clearMap(ctx || 'event', x * 32, y * 32, 32, 32);
		}
		core.drawImage(ctx || 'event', image, posX * 32, posY * height + height - 32, 32, 32, x * 32, y * 32, 32, 32);
		if (height > 32) {
			core.clearMap(ctx || 'event2', x * 32, y * 32 + 32 - height, 32, height - 32)
			core.drawImage(ctx || 'event2', image, posX * 32, posY * height, 32, height - 32, x * 32, y * 32 + 32 - height, 32, height - 32);
		}
	}
	core.control.resize = function () {
		if (main.mode == 'editor') return;
		var clientWidth = main.dom.body.clientWidth,
			clientHeight = main.dom.body.clientHeight;
		var CANVAS_WIDTH = core.__PIXELS__ + 6,
			BAR_WIDTH = Math.round(core.__PIXELS__ * 0.31) + 3;

		if (clientWidth >= CANVAS_WIDTH + BAR_WIDTH || (clientWidth > clientHeight && clientHeight < CANVAS_WIDTH)) {
			// 横屏
			core.domStyle.isVertical = false;
			core.domStyle.scale = Math.min(1, clientHeight / CANVAS_WIDTH);
		} else {
			// 竖屏
			core.domStyle.isVertical = true;
			core.domStyle.scale = Math.min(1, clientWidth / CANVAS_WIDTH);
		}

		var statusDisplayArr = this._shouldDisplayStatus(),
			count = statusDisplayArr.length;
		var statusCanvas = core.flags.statusCanvas,
			statusCanvasRows = core.flags.statusCanvasRowsOnMobile || 3;
		var col = statusCanvas ? statusCanvasRows : Math.ceil(count / 3);
		if (col > 4) {
			if (statusCanvas) alert("自绘状态栏的在竖屏下的行数应不超过4！");
			else alert("当前状态栏数目(" + count + ")大于12，请调整到不超过12以避免手机端出现显示问题。");
		}
		var globalAttribute = core.status.globalAttribute || core.initStatus.globalAttribute;

		var obj = {
			clientWidth: clientWidth,
			clientHeight: clientHeight,
			CANVAS_WIDTH: CANVAS_WIDTH,
			BAR_WIDTH: BAR_WIDTH,
			outerSize: CANVAS_WIDTH * core.domStyle.scale,
			globalAttribute: globalAttribute,
			border: '3px ' + globalAttribute.borderColor + ' solid',
			statusDisplayArr: statusDisplayArr,
			count: count,
			col: col,
			statusBarHeightInVertical: core.domStyle.isVertical ? (32 * col + 6) * core.domStyle.scale + 6 : 0,
			toolbarHeightInVertical: core.domStyle.isVertical ? 44 * core.domStyle.scale + 6 : 0,
			is15x15: core.__SIZE__ == 15
		};

		this._doResize(obj);
		this.setToolbarButton();
		core.updateStatusBar();
		//change
		if (core.start == 0) {
			core.drawMyStatus();
		}
		core.start = 0;
	}
	this._animationFrame_globalAnimate = function (timestamp) {
		if (timestamp - core.animateFrame.globalTime <= core.values.animateSpeed) return;
		core.status.globalAnimateStatus++;
		if (core.status.floorId) {
			// Global Animate
			core.status.globalAnimateObjs.forEach(function (block) {
				core.drawBlock(block, core.status.globalAnimateStatus % (block.event.animate||1));
			});
			if(core.isset(core.statusAnimate) && core.isset(core.autotileAnimate))
			{
				if(core.statusAnimate.length!=0 || core.autotileAnimate.length!=0)
				{
					ctx1 = core.myCanvas.myStatusCanvas1;
					ctx2 = core.myCanvas.myStatusCanvas2;
					if(core.domStyle.isVertical)
					{
						toolBar1 = core.myCanvas.myToolBar1;
						toolBar2 = core.myCanvas.myToolBar2;
						var statusArray=core.arrayMap.statusArray;
						var statusArray2=core.arrayMap.statusArray2;
					}
					else 
					{
						var statusArray=core.arrayMap.statusPCArray;
						var statusArray2=core.arrayMap.statusPCArray2;
					}
					core.statusAnimate.forEach(function(block){
						if(block.location==0)
						{
							if(block.depth==0)
							{
								core.maps.drawBlock(block, core.status.globalAnimateStatus % (block.event.animate||1),ctx1);
							}
							else{
								core.maps.drawBlock(block, core.status.globalAnimateStatus % (block.event.animate||1),ctx2);
							}
						}
						else 
						{
							if(block.depth==0)
							{
								core.maps.drawBlock(block, core.status.globalAnimateStatus % (block.event.animate||1),toolBar1);
							}
							else{
								core.maps.drawBlock(block, core.status.globalAnimateStatus % (block.event.animate||1),toolBar2);
							}
						}
					})
					core.autotileAnimate.forEach(function(block){                 
						if(block.location==0)
						{
							
							if(block.depth==0)
							{
								core.maps.drawMyAutotileAnimate(block, core.status.globalAnimateStatus,ctx1,statusArray);
							}
							else{
								core.maps.drawMyAutotileAnimate(block, core.status.globalAnimateStatus,ctx2,statusArray2);
							}
						}
						else 
						{
							if(block.depth==0)
							{
								core.maps.drawMyAutotileAnimate(block, core.status.globalAnimateStatus,toolBar1,core.arrayMap.toolBarArray);
							}
							else{
								core.maps.drawMyAutotileAnimate(block, core.status.globalAnimateStatus,toolBar2,core.arrayMap.toolBarArray2);
							}
						}
					})
				}
				}
					//
			// Global floor images
			core.maps._drawFloorImages(core.status.floorId, core.canvas.bg, 'bg', core.status.floorAnimateObjs||[], core.status.globalAnimateStatus);
			core.maps._drawFloorImages(core.status.floorId, core.canvas.fg, 'fg', core.status.floorAnimateObjs||[], core.status.globalAnimateStatus);
	
			// Global Autotile Animate
			core.status.autotileAnimateObjs.blocks.forEach(function (block) {
				core.maps._drawAutotileAnimate(block, core.status.globalAnimateStatus);
			});
		}
		// Box animate
		core.drawBoxAnimate();
		core.animateFrame.globalTime = timestamp;
	}
	//加了一个启动游戏初始项
	core.events.startGame = function (hard, seed, route, callback) {
		main.dom.levelChooseButtons.style.display = 'none';
		main.dom.startButtonGroup.style.display = 'none';
		hard = hard || "";

		if (main.mode != 'play') return;
		//change
		core.control.registerAnimationFrame("globalAnimate", true, core.plugin._animationFrame_globalAnimate);
		core.plugin.drawMyStatus();
		//
		// 无动画的开始游戏
		if (core.flags.startUsingCanvas || route != null) {
			core.dom.startPanel.style.display = 'none';
			this._startGame_start(hard, seed, route, callback);
		} else {
			core.hideStartAnimate(function () {
				core.events._startGame_start(hard, seed, route, callback);
			});
		}
	}
}

}