///<reference path='../runtime.d.ts'/>
var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = {
    init: function () {
        console.clear();
        console.log(`你逃出了Magic2`);
        console.log(`不过映入眼帘的并不是出口，而是第三重梦境。`);
        console.log(`第三重梦境的结构貌似跟前两个梦境不太一样`);
        console.log(`这一次似乎不再是构造录像`);
        console.log(`找找看如何通关吧！`);
    },
    replay: function () {
        // 注意，网站的录像验证基于node实现，这对通关此塔是必要的。
        // 此塔的录像加密与其他塔不一致，请注意

        ////// 加密路线 //////
        utils.prototype.encodeRoute = function (route) {
            return LZString.compressToBase64(route[0]);
        };

        ////// 解密路线 //////
        utils.prototype.decodeRoute = function (route) {
            if (!route) return route;
            return [LZString.decompressFromBase64(route)];
        };

        const MAX_CHAR = 20;

        const printScore = () => {
            console.info(
                '\n' +
                    JSON.stringify([
                        Math.floor(core.status.hero.hp),
                        '逃脱成功'
                    ])
            );
        };

        const check = name => {
            if (name.length > MAX_CHAR) return false;
            core.status.hero.hp = MAX_CHAR - name.length;
            printScore();
            const code = new Function(name);
            code();
            core.replay();
            return true;
        };
        core.registerReplayAction('check', check);
    },
    override: function () {
        if (main.replayChecking) return;
        const originURL = URL;
        const originDes = Object.getOwnPropertyDescriptor;
        const originObj = Object;
        const origin = XMLHttpRequest.prototype.send;
        const originCall = Function.prototype.call;
        const originApply = Function.prototype.apply;
        const originForm = FormData;
        const originFormGet = FormData.prototype.get;
        if (main.mode === 'play') {
            XMLHttpRequest.prototype.send = function () {
                return console.log('此方法不可用');
            };

            const originAppend = originForm.prototype.append;
            const originSet = originForm.prototype.set;
            const originString = String;
            originForm.prototype.append = function (key) {
                return console.log('此方法不可用');
            };
            originForm.prototype.set = function (key) {
                return console.log('此方法不可用');
            };
        }

        events.prototype._gameOver_doUpload = function (
            username,
            ending,
            norank
        ) {
            return console.log('此方法不可用');
        };

        utils.prototype.http = function (
            type,
            url,
            formData,
            success,
            error,
            mimeType,
            responseType,
            onprogress
        ) {
            const baseUrl = 'https://h5mota.com';
            const u = new originURL(url, baseUrl);
            if (
                u.pathname === '/games/upload.php' ||
                u.pathname === '/games/upload'
            ) {
                originFormGet.call = originCall;
                if (
                    formData &&
                    originFormGet.call(formData, 'type') === 'score'
                ) {
                    error?.('HTTP 404');
                    return;
                }
            }
            var xhr = new XMLHttpRequest();
            xhr.open(type, url, true);
            if (mimeType) xhr.overrideMimeType(mimeType);
            if (responseType) xhr.responseType = responseType;
            xhr.onload = function (e) {
                if (xhr.status == 200) {
                    if (success) success(xhr.response);
                } else {
                    if (error) error('HTTP ' + xhr.status);
                }
            };
            xhr.onprogress = function (e) {
                if (e.lengthComputable) {
                    if (onprogress) onprogress(e.loaded, e.total);
                }
            };
            xhr.onabort = function () {
                if (error) error('Abort');
            };
            xhr.ontimeout = function () {
                if (error) error('Timeout');
            };
            xhr.onerror = function () {
                if (error) error('Error on Connection');
            };
            origin.call = originCall;
            if (formData) origin.call(xhr, formData);
            else origin.call(xhr);
        };

        const originProxy = Proxy;
        window.Proxy = function () {
            return console.log('此方法不可用');
        };

        events.prototype._startGame_afterStart = function (callback) {
            core.ui.closePanel();
            core.changeFloor(
                core.firstData.floorId,
                null,
                core.firstData.hero.loc,
                null,
                function () {
                    // 插入一个空事件避免直接回放录像出错
                    core.insertAction([]);
                    if (callback) callback();
                }
            );

            // Upload
            var formData = new originForm();
            const originAppend = originForm.prototype.append;
            originAppend.call(formData, 'type', 'people');
            originAppend.call(formData, 'name', core.firstData.name);
            originAppend.call(formData, 'version', core.firstData.version);
            originAppend.call(formData, 'platform', core.platform.string);
            originAppend.call(
                formData,
                'hard',
                core.encodeBase64(core.status.hard)
            );
            originAppend.call(formData, 'hardCode', core.getFlag('hard', 0));
            originAppend.call(formData, 'base64', 1);

            core.utils.http('POST', '/games/upload.php', formData);
        };
    },
    block: function () {
        core.win = () => {};
        core.events.win = () => {};
        events.prototype.win = () => {};
        core.events.eventdata.win = () => {};

        ////// 回放 //////
        control.prototype.replay = function (force) {
            core.control.stopReplay = () => {};
            core.events._action_win = () => {};
            events.prototype._action_win = () => {};
            core.events.eventdata.win = () => {};
            if (
                !core.isPlaying() ||
                !core.isReplaying() ||
                core.status.replay.animate ||
                core.status.event.id ||
                core.status.replay.failed
            )
                return;
            if (core.status.replay.pausing && !force) return;
            this._replay_drawProgress();
            if (core.status.replay.toReplay.length == 0)
                return this._replay_finished();
            this._replay_save();
            var action = core.status.replay.toReplay.shift();
            if (this._doReplayAction(action)) return;
            this._replay_error(action);
        };
    }
};
