var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}

var tempSwitch = null;
this.setTempSwitchSound = function(name){
	tempSwitch = name;
}
// 

events.prototype._changeFloor_beforeChange = function (info, callback) {
	if(tempSwitch){
		core.playSound(tempSwitch);
		tempSwitch = null;
	}else {
		core.playSound('floor.ogg');
	}
	// 需要 setTimeout 执行，不然会出错
	window.setTimeout(function () {
		if (info.time == 0)
			core.events._changeFloor_changing(info, callback);
		else
			core.showWithAnimate(core.dom.floorMsgGroup, info.time / 2, function () {
				core.events._changeFloor_changing(info, callback);
			});
	}, 25)
}

////// 记录语句
events.prototype._action_text = function (data, x, y, prefix) {
	if(data.text.endsWith('@quote')){
		var content = core.ui._getTitleAndIcon(core.ui._getPosition(data.text).content).content;
		data.text = data.text.substr(0,data.text.length-6);
		content = content.substr(0,content.length-6);
		var q = core.getFlag('quote',[]);
		if(q.indexOf(content)<0)q.push(content);
		core.setFlag('quote', q);
	}
	if (this.__action_checkReplaying()) return;
	core.ui.drawTextBox(data.text, data.showAll);
}


////// 踩点不能瞬移
maps.prototype.canMoveDirectlyArray = function (locs) {
    var ans = [], number = locs.length;

    var fromX = core.getHeroLoc('x'), fromY = core.getHeroLoc('y');
    if (!this._canMoveDirectly_checkGlobal()) {
        for (var i = 0; i < number; ++i) ans.push(-1);
        return ans;
	}
	var arr = core.getBgMapArray();
	var stopList = [168];

    for (var i = 0; i < number; ++i) {
        if (locs[i][0] == fromX && locs[i][1] == fromY) {
            ans.push(0);
            number--;
        }
        else if (locs[i][0] < 0 || locs[i][0] >= core.bigmap.width || locs[i][1] < 0 || locs[i][1] >= core.bigmap.height || stopList.indexOf(arr[locs[i][1]][locs[i][0]])>=0 || stopList.indexOf(arr[fromY][fromX])>=0) {
            ans.push(-1);
            number--;
        }
        else ans.push(null);
    }
    if (number == 0) return ans;

    // 检查起点事件
    if (!this._canMoveDirectly_checkStartPoint(fromX, fromY)) {
        for (var i in ans) {
            if (ans[i] == null) ans[i] = -1;
        }
        return ans;
    }

    return this._canMoveDirectly_bfs(fromX, fromY, locs, number, ans);
}

////// 推箱子 //////
events.prototype.pushBox = function (data) {
    if (data.event.id != 'box' && data.event.id != 'boxed') return;

    // 判断还能否前进，看看是否存在事件
    var direction = core.getHeroLoc('direction'),
        nx = data.x + core.utils.scan[direction].x, ny = data.y + core.utils.scan[direction].y;

	
	var getCanGoDirByFunc = function(func){
		var lst = ["up", "left", "down", "right"];
		var canGo = {};
		var canGoBias = function(d){
			d = lst[(lst.indexOf(direction) + d + 4) % 4];
			canGo[d] =  func(data.x, data.y, d);
			return d;
		}	
		var l = canGoBias(-1), r = canGoBias(1);
		if(canGo[l] && canGo[r] || !canGo[l] && !canGo[r]){
			return null;
		}
		return canGo[l] ? l: r;
	}

	var nextId = core.getBlockId(nx, ny);
	var dir = direction;
	// 检测能否推上去
	if (!core.canMoveHero() || !core.canMoveHero(data.x, data.y, direction)){
		if(core.canMoveHero()){
			if(nx >= 0 && nx < core.__SIZE__ && ny>=0 && ny < core.__SIZE__ && !core.getBlock(nx, ny)){
				dir = direction; // 死区影响
			}else{
				dir = getCanGoDirByFunc(function(x,y,dir){
					return core.canMoveHero(x,y,dir) && !core.getBlock(x + core.utils.scan[dir].x, y + core.utils.scan[dir].y);
				});
			}
		}else{
			return;
		}
	}else if (nextId != null && nextId != 'flower'){
		dir = getCanGoDirByFunc(function(x, y, dir){
			return core.canMoveHero(x,y,dir) && !core.getBlock(x + core.utils.scan[dir].x, y + core.utils.scan[dir].y);
		});
	}
	if(!dir) return;
	nx = data.x + core.utils.scan[dir].x, ny = data.y + core.utils.scan[dir].y;
	nextId = null;
    core.setBlock(nextId == null ? 169 : 170, nx, ny);

    if (data.event.id == 'box')
        core.removeBlock(data.x, data.y);
    else
        core.setBlock(168, data.x, data.y);

	core.updateLightMap();
	core.clearMap('fg');
	core.drawFg();
    core.updateStatusBar();
    this._pushBox_moveHero(direction);
}
	
events.prototype.changeFloor = function (floorId, stair, heroLoc, time, callback, fromLoad) {
	time = 0;
    var info = this._changeFloor_getInfo(floorId, stair, heroLoc, time);
    if (info == null) {
        if (callback) callback();
        return;
    }
    info.fromLoad = fromLoad;
    floorId = info.floorId;
    info.locked = core.status.lockControl;

    core.dom.floorNameLabel.innerText = core.status.maps[floorId].title;
    core.lockControl();
    core.stopAutomaticRoute();
    core.clearContinueAutomaticRoute();
    core.status.replay.animate = true;
    clearInterval(core.interval.onDownInterval);
    core.interval.onDownInterval = 'tmp';

    this._changeFloor_beforeChange(info, callback);
}

control.prototype._updateDamage_extraDamage = function (floorId, ctx, refresh) {
    core.setTextAlign(ctx, 'center');
    if (refresh) this.updateCheckBlock(floorId);
    if (core.flags.displayExtraDamage) {
        var width = core.floors[floorId].width, height = core.floors[floorId].height;
        for (var x=0;x<width;x++) {
            for (var y=0;y<height;y++) {
                var damage = core.status.checkBlock.damage[x+","+y]||0;
				if (damage>0) { // 该点伤害
					if(core.getFlag('hard',0)==1){
						core.fillBoldText(ctx, '?', 32*x+16, 32*(y+1)-14, '#FF7F00');
					}else {
						damage = core.formatBigNumber(damage, true);
						core.fillBoldText(ctx, damage, 32*x+16, 32*(y+1)-14, '#FF7F00');
					}
                }
                else { // 检查捕捉
                    if (core.status.checkBlock.ambush[x+","+y]) {
                        core.fillBoldText(ctx, '!', 32*x+16, 32*(y+1)-14, '#FF7F00');
                    }
                }
            }
        }
    }
}



	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "itemShop": function () {
	// 道具商店相关的插件
	// 可在全塔属性-全局商店中使用「道具商店」事件块进行编辑（如果找不到可以在入口方块中找）

	var shopId = null; // 当前商店ID
	var type = 0; // 当前正在选中的类型，0买入1卖出
	var selectItem = 0; // 当前正在选中的道具
	var selectCount = 0; // 当前已经选中的数量
	var page = 0;
	var totalPage = 0;
	var totalMoney = 0;
	var list = [];

	var bigFont = core.ui._buildFont(20, false),
		middleFont = core.ui._buildFont(18, false);

	this.drawItemShop = function () {
		// 绘制道具商店

		// Step 1: 背景和固定的几个文字
		core.ui._createUIEvent();
		core.clearMap('uievent');
		core.ui._uievent_drawSelector({ "code": 1 });
		core.ui._uievent_drawSelector({ "code": 2 });
		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'top');
		core.fillRect('uievent', 0, 0, 416, 416, 'black');
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 0, width: 416, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 56, width: 312, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 112, width: 312, height: 304 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 312, y: 56, width: 104, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 312, y: 112, width: 104, height: 304 });
		core.setFillStyle('uievent', 'white');
		core.setStrokeStyle('uievent', 'white');
		core.fillText("uievent", "购买", 32, 74, 'white', bigFont);
		core.fillText("uievent", "卖出", 132, 74);
		core.fillText("uievent", "离开", 232, 74);
		core.fillText("uievent", "当前金币", 324, 66, null, middleFont);
		core.setTextAlign("uievent", "right");
		core.fillText("uievent", core.formatBigNumber(core.status.hero.money), 405, 89);
		core.setTextAlign("uievent", "left");
		core.ui._uievent_drawSelector({
			"type": "drawSelector",
			"image": "winskin.png",
			"code": 2,
			"x": 22 + 100 * type,
			"y": 66,
			"width": 60,
			"height": 33
		});
		if (selectItem != null) {
			core.setTextAlign('uievent', 'center');
			core.fillText("uievent", type == 0 ? "买入个数" : "卖出个数", 364, 320, null, bigFont);
			core.fillText("uievent", "◀   " + selectCount + "   ▶", 364, 350);
			core.fillText("uievent", "确定", 364, 380);
		}

		// Step 2：获得列表并展示
		var choices = core.status.shops[shopId].choices;
		list = choices.filter(function (one) {
			if (one.condition != null) {
				try { if (!core.calValue(one.condition)) return false; } catch (e) {}
			}
			return (type == 0 && one.money != null) || (type == 1 && one.sell != null);
		});
		var per_page = 6;
		totalPage = Math.ceil(list.length / per_page);
		page = Math.floor((selectItem || 0) / per_page) + 1;

		// 绘制分页
		if (totalPage > 1) {
			var half = 156;
			core.setTextAlign('uievent', 'center');
			core.fillText('uievent', page + " / " + totalPage, half, 388, null, middleFont);
			if (page > 1) core.fillText('uievent', '上一页', half - 80, 388);
			if (page < totalPage) core.fillText('uievent', '下一页', half + 80, 388);
		}
		core.setTextAlign('uievent', 'left');

		// 绘制每一项
		var start = (page - 1) * per_page;
		for (var i = 0; i < per_page; ++i) {
			var curr = start + i;
			if (curr >= list.length) break;
			var item = list[curr];
			core.drawIcon('uievent', item.id, 10, 125 + i * 40);
			core.setTextAlign('uievent', 'left');
			core.fillText('uievent', core.material.items[item.id].name, 50, 132 + i * 40, null, bigFont);
			core.setTextAlign('uievent', 'right');
			core.fillText('uievent', (type == 0 ? core.calValue(item.money) : core.calValue(item.sell)) + "金币/个", 300, 133 + i * 40, null, middleFont);
			core.setTextAlign("uievent", "left");
			if (curr == selectItem) {
				// 绘制描述，文字自动放缩
				var text = core.material.items[item.id].text || "该道具暂无描述";
				try { text = core.replaceText(text); } catch (e) {}
				for (var fontSize = 20; fontSize >= 8; fontSize -= 2) {
					var config = { left: 10, fontSize: fontSize, maxWidth: 403, lineHeight: 1.4 };
					var height = core.getTextContentHeight(text, config);
					if (height <= 50) {
						config.top = (56 - height) / 2;
						core.drawTextContent("uievent", text, config);
						break;
					}
				}
				core.ui._uievent_drawSelector({ "type": "drawSelector", "image": "winskin.png", "code": 1, "x": 8, "y": 120 + i * 40, "width": 295, "height": 40 });
				if (type == 0 && item.number != null) {
					core.fillText("uievent", "存货", 324, 132, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", item.number, 406, 132, null, null, 40);
				} else if (type == 1) {
					core.fillText("uievent", "数量", 324, 132, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", core.itemCount(item.id), 406, 132, null, null, 40);
				}
				core.setTextAlign("uievent", "left");
				core.fillText("uievent", "预计金额", 324, 250);
				core.setTextAlign("uievent", "right");
				totalMoney = selectCount * (type == 0 ? core.calValue(item.money) : core.calValue(item.sell));
				core.fillText("uievent", core.formatBigNumber(totalMoney), 405, 280);

				core.setTextAlign("uievent", "left");
				core.fillText("uievent", type == 0 ? "已购次数" : "已卖次数", 324, 170);
				core.setTextAlign("uievent", "right");
				core.fillText("uievent", (type == 0 ? item.money_count : item.sell_count) || 0, 405, 200);
			}
		}

		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'alphabetic');
	}

	var _add = function (item, delta) {
		if (item == null) return;
		selectCount = core.clamp(
			selectCount + delta, 0,
			Math.min(type == 0 ? Math.floor(core.status.hero.money / core.calValue(item.money)) : core.itemCount(item.id),
				type == 0 && item.number != null ? item.number : Number.MAX_SAFE_INTEGER)
		);
	}

	var _confirm = function (item) {
		if (item == null || selectCount == 0) return;
		if (type == 0) {
			core.status.hero.money -= totalMoney;
			core.getItem(item.id, selectCount);
			if (item.number != null) item.number -= selectCount;
			item.money_count = (item.money_count || 0) + selectCount;
		} else {
			core.status.hero.money += totalMoney;
			core.removeItem(item.id, selectCount);
			core.drawTip("成功卖出" + selectCount + "个" + core.material.items[item.id].name, item.id);
			if (item.number != null) item.number += selectCount;
			item.sell_count = (item.sell_count || 0) + selectCount;
		}
		selectCount = 0;
	}

	this._performItemShopKeyBoard = function (keycode) {
		var item = list[selectItem] || null;
		// 键盘操作
		switch (keycode) {
		case 38: // up
			if (selectItem == null) break;
			if (selectItem == 0) selectItem = null;
			else selectItem--;
			selectCount = 0;
			break;
		case 37: // left
			if (selectItem == null) {
				if (type > 0) type--;
				break;
			}
			_add(item, -1);
			break;
		case 39: // right
			if (selectItem == null) {
				if (type < 2) type++;
				break;
			}
			_add(item, 1);
			break;
		case 40: // down
			if (selectItem == null) {
				if (list.length > 0) selectItem = 0;
				break;
			}
			if (list.length == 0) break;
			selectItem = Math.min(selectItem + 1, list.length - 1);
			selectCount = 0;
			break;
		case 13:
		case 32: // Enter/Space
			if (selectItem == null) {
				if (type == 2)
					core.insertAction({ "type": "break" });
				else if (list.length > 0)
					selectItem = 0;
				break;
			}
			_confirm(item);
			break;
		case 27: // ESC
			if (selectItem == null) {
				core.insertAction({ "type": "break" });
				break;
			}
			selectItem = null;
			break;
		}
	}

	this._performItemShopClick = function (px, py) {
		var item = list[selectItem] || null;
		// 鼠标操作
		if (px >= 22 && px <= 82 && py >= 71 && py <= 102) {
			// 买
			if (type != 0) {
				type = 0;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 122 && px <= 182 && py >= 71 && py <= 102) {
			// 卖
			if (type != 1) {
				type = 1;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 222 && px <= 282 && py >= 71 && py <= 102) // 离开
			return core.insertAction({ "type": "break" });
		// ◀，▶
		if (px >= 318 && px <= 341 && py >= 348 && py <= 376)
			return _add(item, -1);
		if (px >= 388 && px <= 416 && py >= 348 && py <= 376)
			return _add(item, 1);
		// 确定
		if (px >= 341 && px <= 387 && py >= 380 && py <= 407)
			return _confirm(item);

		// 上一页/下一页
		if (px >= 45 && px <= 105 && py >= 388) {
			if (page > 1) selectItem -= 6;
			return;
		}
		if (px >= 208 && px <= 268 && py >= 388) {
			if (page < totalPage) selectItem = Math.min(selectItem + 6, list.length - 1);
			return;
		}

		// 实际区域
		if (px >= 9 && px <= 300 && py >= 120 && py < 360) {
			if (list.length == 0) return;
			var index = parseInt((py - 120) / 40);
			var newItem = 6 * (page - 1) + index;
			if (newItem >= list.length) newItem = list.length - 1;
			if (newItem != selectItem) {
				selectItem = newItem;
				selectCount = 0;
			}
			return;
		}
	}

	this.performItemShopAction = function () {
		if (flags.type == 0) return this._performItemShopKeyBoard(flags.keycode);
		else return this._performItemShopClick(flags.px, flags.py);
	}

	this.openItemShop = function (itemShopId) {
		shopId = itemShopId;
		type = 0;
		page = 0;
		selectItem = null;
		selectCount = 0;
		core.insertAction([{
				"type": "while",
				"condition": "true",
				"data": [
					{ "type": "function", "function": "function () { core.drawItemShop(); }" },
					{ "type": "wait" },
					{ "type": "function", "function": "function() { core.performItemShopAction(); }" }
				]
			},
			{ "type": "function", "function": "function () { " +
					"core.deleteCanvas('uievent'); " +
					"core.ui._uievent_drawSelector({ \"code\": 1 }); " +
					"core.ui._uievent_drawSelector({ \"code\": 2 }); " +
					"}" }
		]);
	}

	// Write item number to save
	core.control.saveData = function () {
		var data = this.controldata.saveData();
		for (var shopId in core.status.shops) {
			if (core.status.shops[shopId].item) {
				data.shops[shopId].choices = core.status.shops[shopId].choices.map(function (t) {
					return {
						number: t.number,
						money_count: t.money_count || 0,
						sell_count: t.sell_count || 0
					}
				});
			}
		}
		return data;
	}

	core.control.loadData = function (data, callback) {
		this.controldata.loadData(data, callback);
		for (var shopId in data.shops) {
			if (data.shops[shopId].choices) {
				for (var i = 0; i < data.shops[shopId].choices.length; ++i) {
					core.status.shops[shopId].choices[i].number = data.shops[shopId].choices[i].number;
					core.status.shops[shopId].choices[i].money_count = data.shops[shopId].choices[i].money_count;
					core.status.shops[shopId].choices[i].sell_count = data.shops[shopId].choices[i].sell_count;
				}
			}
		}
	}

},
    "smoothCamera": function () {

    // 是否启用本插件，默认不启用
	this.__enableSmoothCamera = false;
	if (!this.__enableSmoothCamera) return;

	this.Camera = function () {

		// 下面这个变量决定本插件的开关
		// 你可以在游戏中使用core.setFlag('smoothCamera',false)来关闭本插件的功能
		// 同时也可以core.setFlag('smoothCamera',true)重新开启
		// 此项默认为true
		// 
		this.__switchName = 'smoothCamera';

		// 初始化成员变量
		this._cameraNeedRefresh = true;
		this._nowOffsetX = 0;
		this._nowOffsetY = 0;
		this._targetOffsetX = 0;
		this._targetOffsetY = 0;
		this._currentFloorId = null;

		// 重置镜头，在楼层变更时使用
		this.resetCamera = function () {
			this._targetOffsetX = core.bigmap.offsetX;
			this._targetOffsetY = core.bigmap.offsetY;
			this._nowOffsetX = this._targetOffsetX;
			this._nowOffsetY = this._targetOffsetY;
			this._cameraNeedRefresh = true;
		};

		// 设置焦点坐标，目前没有用
		this.setTarget = function (x, y) {
			this._targetOffsetX = x;
			this._targetOffsetY = y;
		};

		// 请求镜头更新
		this.requestCameraUpdate = function () {
			this._cameraNeedRefresh = true;
		};

		// 更新焦点坐标，目前仅根据大地图偏移决定
		this.updateTargetPosition = function () {
			this._targetOffsetX = core.bigmap.offsetX;
			this._targetOffsetY = core.bigmap.offsetY;
		};

		// 更新额外的刷新条件，即镜头未指向焦点时
		this.updateRefreshFlag = function () {
			if (this._nowOffsetX != this._targetOffsetX || this._nowOffsetY != this._targetOffsetY) {
				this._cameraNeedRefresh = true;
			}
		};

		// 判断是否禁止了弹性滚动
		this.canDirectMove = function () {
			return !core.getFlag(this.__switchName, true);
		};

		// 更新镜头坐标
		this.updateCameraPosition = function () {
			if (this._cameraNeedRefresh) {
				this._cameraNeedRefresh = false;
				var disX = this._targetOffsetX - this._nowOffsetX;
				var disY = this._targetOffsetY - this._nowOffsetY;
				if (Math.abs(disX) <= 2 && Math.abs(disY) <= 2 || this.canDirectMove()) {
					this._nowOffsetX = this._targetOffsetX;
					this._nowOffsetY = this._targetOffsetY;
				} else {
					this._nowOffsetX += disX / 10;
					this._nowOffsetY += disY / 10;
				}
				var x = -Math.floor(this._nowOffsetX);
				var y = -Math.floor(this._nowOffsetY);
				core.bigmap.canvas.forEach(function (cn) {
					core.control.setGameCanvasTranslate(cn, x, y);
				});
				core.relocateCanvas('route', core.status.automaticRoute.offsetX + x, core.status.automaticRoute.offsetY + y);
				core.setGameCanvasTranslate('hero', x + this._targetOffsetX, y + this._targetOffsetY);
			}
		};

		// 更新逻辑主体
		this.update = function () {
			this.updateTargetPosition();
			this.updateRefreshFlag();
			this.updateCameraPosition();
		};
	};

	// 其实只注释了最后一行，只能这样了
	control.drawHero = function (status, offset) {
		if (!core.isPlaying() || !core.status.floorId || core.status.gameOver) return;
		var x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y'),
			direction = core.getHeroLoc('direction');
		status = status || 'stop';
		offset = offset || 0;
		var way = core.utils.scan[direction];
		var dx = way.x,
			dy = way.y,
			offsetX = dx * offset,
			offsetY = dy * offset;
		core.bigmap.offsetX = core.clamp((x - core.__HALF_SIZE__) * 32 + offsetX, 0, 32 * core.bigmap.width - core.__PIXELS__);
		core.bigmap.offsetY = core.clamp((y - core.__HALF_SIZE__) * 32 + offsetY, 0, 32 * core.bigmap.height - core.__PIXELS__);
		core.clearAutomaticRouteNode(x + dx, y + dy);
		core.clearMap('hero');

		if (!core.hasFlag('hideHero')) {
			this._drawHero_getDrawObjs(direction, x, y, status, offset).forEach(function (block) {
				core.drawImage('hero', block.img, block.heroIcon[block.status] * block.width,
					block.heroIcon.loc * block.height, block.width, block.height,
					block.posx + (32 - block.width) / 2, block.posy + 32 - block.height, block.width, block.height);
			});
		}

		core.control.updateViewport();
		//core.setGameCanvasTranslate('hero', 0, 0);
	};

	// 复写转发
	core.drawHero = function (status, offset) {
		return core.control.drawHero(status, offset);
	};

	// 创建摄像机对象
	this.camera = new this.Camera();

	// 帧事件 更新摄像机
	this.updateCameraEx = function () {
		this.camera.update();
	};

	// 代理原本的镜头事件
	control.updateViewport = function () {
		core.plugin.camera.requestCameraUpdate();
	};

	// 更变楼层的行为追加，重置镜头
	events.prototype.changingFloor = function (floorId, heroLoc, fromLoad) {
		this.eventdata.changingFloor(floorId, heroLoc, fromLoad);
		core.plugin.camera.resetCamera();
	};

	// 注册帧事件
	core.registerAnimationFrame('smoothCameraFlash', true, this.updateCameraEx.bind(this));
},
    "dljgs1_light": function () {
		// 2020.1.4 改实现方式，光源各自确定颜色，交叉不再融合颜色，对射会阻断
		////// rewrite ////// 
		var origin_drawFg = core.maps.drawFg;
		core.maps.drawFg = function (floorId, ctx) {
			origin_drawFg.call(core.maps,floorId,ctx);
			ctx = ctx || core.canvas.fg;
			core.renderLight(ctx, floorId);
		}
		////// 点击工具栏时 //////
		main.dom.hard.onclick = function () {
			if (core.isReplaying()){
				return;
			}else {
				var list = ['I311','I315','I319'];
				var cur = core.getFlag('curKey', 'I315');
				var idx = (list.indexOf(cur)+1)%3;
				core.setFlag('curKey',list[idx]);
				core.updateStatusBar();
			}
			// main.core.control.setToolbarButton(!core.domStyle.toolbarBtn);
		}
		
		////// 获得面前的物品（轻按） //////
		events.prototype.getNextItem = function (noRoute) {
			if (core.isMoving() || !core.flags.enableGentleClick) return false;
			if(core.tryRemoveLightElem()){
				core.status.route.push("getNext");
				return true;
			}
			if (this._canGetNextItem())
				return this._getNextItem(null, noRoute);
			var directions = ["up", "down", "left", "right"].filter(function (dir) {
				return core.events._canGetNextItem(dir);
			});
			return directions.length == 1 ? this._getNextItem(directions[0]) : false;
		}

		////// 
		var _openDoor_check = function (id, x, y, needKey) {
			// 是否存在门或暗墙
			if (!core.terrainExists(x, y, id) || !(id.endsWith("Door") || id.endsWith("Wall"))
				|| core.material.icons.animates[id] == null) {
				core.clearContinueAutomaticRoute();
				return false;
			}
		
			if (id == 'steelDoor' && core.flags.steelDoorWithoutKey)
				needKey = false;
		
			if (needKey && id.endsWith("Door")) {
				var keyMap = {'redDoor':'I311', 'yellowDoor':'I315', 'blueDoor':'I319'};
				var key = keyMap[id];
				if (!core.hasItem(key)) {
					if (key != "specialKey")
						core.drawTip("你没有" + ((core.material.items[key] || {}).name || "钥匙"), null, true);
					else core.drawTip("无法开启此门", null, true);
					core.clearContinueAutomaticRoute();
					return false;
				}else {
					if(core.canUseItem(key)){
						if (!core.status.event.id) core.autosave(true);
						return key;
					}else {
							core.drawTip("无法使用");
					}
				}
				// core.removeItem(key);
			}
			return null;
		}
		events.prototype._sys_openDoor = function (data, callback) {
			var id = core.getBlockId(data.x, data.y);
			core.saveAndStopAutomaticRoute();
			if(data.id==86 && core.flags.steelDoorWithoutKey){
				core.playSound("door.mp3");
				this._openDoor_animate(id, data.x, data.y, function(){
					core.replay();
					if (callback) callback();
				});
				return;
			}
			var key = _openDoor_check(id, data.x, data.y, true);
			if(key){
				core.useItem(key, true, callback);
			}else {
			}
		}

		this.initLight = function(){
		}
		// 工具
		this.genMap = function(val){
			var m = [];
			for(var x =0;x<core.__SIZE__;x++){
				m[x] = [];
				for(var y = 0;y < core.__SIZE__;y++){
					m[x][y] = val;
				}
			}
			return m;
		}
		
		this.myDrawLine = function (ctx, x1, y1, x2, y2, style, lineWidth) {
			if (style) ctx.strokeStyle = style;
			if (lineWidth != null)ctx.lineWidth=lineWidth;
			ctx.beginPath();
			ctx.moveTo(x1, y1);
			ctx.lineTo(x2, y2);
			ctx.stroke();
		}


		// 模拟照射
		// s = {color,dir,x,y} 光源
		var shine = function(s, tmap, floorId, procfun){
			if(core.status.floorId != floorId)return;
			floorId = floorId || core.status.floorId;
			var dir_change_left = ['left', 'down', 'up', 'right'];
			var dir_change_right = ['right', 'left', 'up', 'down'];
			var odir = s.dir;
			var ox = s.x, oy = s.y, ocolor = s.color;
			var x = s.x, y = s.y;
			tmap[x][y] = 'source';
			var stop = false;
			var ret = null;
			var log = {};
			do{
				x += core.utils.scan[s.dir].x;
				y += core.utils.scan[s.dir].y;
				var blk = core.getBlock(x,y);
				// 默认穿透
				if(blk&&['enemys','enemy48','items'].indexOf(blk.block.event.cls)<0){
					var canPassList = ['lava','box','blueWater','jStone','sStone']// 可穿透列表
					if(canPassList.indexOf(blk.block.event.id)<0){
						switch(blk.block.event.id){
							case 'portal':
								tmap[x][y] = 'portal';
								var data = core.floors[floorId].events[x+','+y][0];
								if(procfun && procfun(x,y));
								x = data.loc[0]; y = data.loc[1];
								s.dir = data.direction;
								if(log[x+','+y]){
									stop = true;break;
								}
								log[x+','+y]=true;
								break;
							default:
								ret = blk.block;//撞停块
								stop=true;
								break;
						}
					}
				}
				if(stop)break;
				if(x>=0 && x<core.__SIZE__ && y>=0 && y<core.__SIZE__)
				switch(tmap[x][y]){
					case 'source':
						stop=true;
						break;
					case 'left': 
						s.dir = dir_change_left[(dir_change_left.indexOf(s.dir)+2)%4];
						break;
					case 'right':
						s.dir = dir_change_right[(dir_change_right.indexOf(s.dir)+2)%4];				break;
					default:
						if(procfun && procfun(x,y,blk))
							stop=true;
				}else break;
			}while(!stop);
			s.x = ox; s.y = oy; s.color = ocolor; s.dir = odir;
			return ret;
		}

		// 更新光照数据
		this.updateLightMap = function(floorId){
			if(main.mode=='editor')return;
			floorId = floorId || core.status.floorId;
			var sL = core.getFlag("sourceLight",{})[floorId] || [];
			var mirror = core.getFlag("mirror_list",{})[floorId] || [];

			var tmap = core.genMap(0);
			mirror.forEach(function(m){
				tmap[m.x][m.y] = m.dir;
			});
			
			var lock_pts = core.getFlag("lock_pts",{})[floorId] || {};
			var todo = [];
			// init
			sL.forEach(function(s){
				tmap[s.x][s.y] = 'source';
				s.lock = null;
			});
			for(var p in lock_pts){
				lock_pts[p].ct = 0;
			}

			// 照射:
			sL.forEach(function(s){
				var blk = shine(s, tmap, floorId, function(x,y){
					if(['left','right','portal'].indexOf(tmap[x][y])>=0)return false;
					tmap[x][y] = s.color;
					if(lock_pts[x+','+y]){ // 已有钥
						s.lock = {x:x,y:y};
						lock_pts[x+','+y].ct += 1;
						tmap[x][y] = 'lock';
						return true;
					}
					return false;
				});
				if(blk){
					// 碰撞，需开门
					if(blk.event.id.endsWith("Door") && blk.event.id.indexOf(s.color)==0){
						todo.push({"type": "autoSave", "nohint": true});
						todo.push({"type": "openDoor", "loc": [blk.x,blk.y], "async": true});
						tmap[blk.x][blk.y] = "lock";
						lock_pts[blk.x+','+blk.y] = {id:blk.event.id, ct:1, x:blk.x, y:blk.y};
						s.lock = {x:blk.x,y:blk.y};
					}
					if(blk.event.cls.indexOf('npc')==0 && core.getHeroLoc('x')==s.x && core.getHeroLoc('y')==s.y){
						todo.push({"type": "setValue", "name": "flag:tmp_light", "value": "true", "norefresh": true});
						todo.push({"type": "trigger", "loc": [blk.x,blk.y], "keep": true});
					}
				}
			});


			flags.light_map = flags.light_map || {};
			core.getFlag("light_map")[floorId]=tmap;

			// 需要关闭的门
			for(var p in lock_pts){
				var it = lock_pts[p];
				if(it.ct == 0){
					if(core.getBlock(it.x,it.y)){
						core.playSound("door.mp3");
						core.playSound("explosion.mp3");
						core.removeBlock(it.x,it.y)
					}else {
						todo.push({"type": "closeDoor", "id": it.id, "loc": [it.x,it.y], "async": true})
					}
					delete lock_pts[p];
				}
			}
			flags.lock_pts = flags.lock_pts || {};
			core.getFlag('lock_pts')[floorId] = lock_pts;

			// 检查宝石门
			var evts = core.floors[floorId].afterGetItem;
			var posct = {};
			for(var i in evts){
				var e = evts[i];
				if(e[0].type == 'openDoor'){
					var idx = i.split(',');
					var x = ~~idx[0], y = ~~idx[1];
					var c = core.getCurrentColor(x, y) ? 1:0;
					core.setBlock(c?353:352, x, y);
					idx = e[0].loc[0] + ',' + e[0].loc[1];
					posct[idx] = posct[idx]||{ct:0,x:x,y:y,evt:e};
					posct[idx].ct += 1 - c;
				}
			}
			for(var i in posct){
				if(posct[i].ct==0){
					todo = todo.concat(posct[i].evt);
					// todo.push({"type":"openDoor","loc":[posct[i].x,posct[i].y], "async": true});
				}
			}
			if(todo.length>0){
				todo.push({"type": "waitAsync"});
				core.insertAction(todo);
			}
		}

		// 实际照射渲染
		var code2color = function(code){
			return "#"+((code & 1)?"FF":"00") + ((code & 2)?"FF":"00") + ((code & 4)?"FF":"00");
		}
		var drawItem = function(ctx, x, y, itemId){
			var img = core.material.images.items;
			var bias = core.material.icons.items[itemId];
			ctx.drawImage(img, 0, 32*bias, 32, 32, x*32, y*32, 32, 32);
		}
		var dirCode = {'up':0, 'left':3, 'right':1, 'down':2};
		this.renderLight = function(ctx, floorId){
			floorId = floorId || core.status.floorId;
			var sL = core.getFlag("sourceLight",{})[floorId] || [];
			var tmap = core.getFlag("light_map",{})[floorId] || [];
			var locks = core.getFlag('lock_pts',{})[floorId] || {};
			var mirror = core.getFlag("mirror_list",{})[floorId] || [];

			mirror.forEach(function(m){
				ctx.globalAlpha = 1.0;
				drawItem(ctx, m.x, m.y, m.id, m.dir);
			})
			sL.forEach(function(s){
				ctx.globalAlpha = 0.5;
				drawItem(ctx, s.x, s.y, 'I' + s.n, s.dir);
				var dx = core.utils.scan[s.dir].x, dy = core.utils.scan[s.dir].y;
				core.myDrawLine(ctx, s.x*32+16, s.y*32+16, s.x*32+16+32*dx, s.y*32+16+32*dy, s.color, 2);
				shine(s, tmap, floorId, function(x,y){
					if(tmap[x][y]=="lock")return true;
					var dx = core.utils.scan[s.dir].x, dy = core.utils.scan[s.dir].y;
					var prex = x - dx, prey = y - dy;
					var nxtx = x + dx, nxty = y + dy;
					if(tmap[x][y]=="portal"){
						nxtx = x; nxty = y;
					}
					// var blk = core.getBlock(x,y);
					core.myDrawLine(ctx, prex*32+16, prey*32+16, nxtx*32+16, nxty*32+16, tmap[x][y], 2);
					s.color = tmap[x][y];
				});
			});

			for(var pos in locks){
				pos = pos.split(',');
				ctx.globalAlpha = 0.3;
				ctx.drawImage(core.material.images.animates, 0, 32 * core.material.icons.animates[locks[pos].id],32,32,32*parseInt(pos[0]), 32*parseInt(pos[1]),32,32);	
				ctx.globalAlpha = 0.8;
			}

		}


		// item
		this.canUseKeyLight = function(itemId,x,y){
			var cur = core.getFlag("sourceLight",{})[core.status.floorId] || [];
			var loc = core.status.hero.loc;
			if(core.isset(x) && core.isset(y))loc = {x:x,y:y};
			var mirror = core.getFlag("mirror_list",{})[core.status.floorId] || [];
			var lock = core.getFlag("lock_pts",{})[core.status.floorId] || {};
			if(core.getBlock(loc.x, loc.y))return false;
			if(cur.find(function(it){return it.x==loc.x && it.y == loc.y}))return false;
			if(mirror.find(function(it){return it.x==loc.x && it.y == loc.y}))return false;
			if(lock[loc.x+','+loc.y])return false;			
			return true;
		}
		this.useKeyLight = function(itemId){
			var item = core.items.items[itemId];
			var loc = core.status.hero.loc;
			var n = dirCode[loc.direction] + parseInt(itemId.substr(1));
			core.addSourceLight(loc.x, loc.y, n, item.equip.color, loc.direction, itemId);
		}

		// 添加
		this.addSourceLight = function(x,y,n,color,dir,itemId){
			//core.insertAction({ "type": "setBgFgBlock", "name": "bg", "number": "I" + n, "loc": [x, y] });
			var sL = core.getFlag("sourceLight",{});
			sL[core.status.floorId] = sL[core.status.floorId] || [];
			var dir_list = ['up', 'right', 'down', 'left'];
			var newSource = { x: x, y: y, color: color, dir: dir, id: itemId, n:n};
			sL[core.status.floorId].push(newSource);
			flags.sourceLight = sL;
			var passFlag = {};
			shine(newSource, core.genMap(0), core.status.floorId, function(x, y, blk){
				if(blk){
					if(blk.block.event.cls.indexOf('enemy')>=0)
						passFlag.hasPassEnemy = true;
					if(blk.block.event.id.indexOf('Stone')>=0)
						passFlag.hasPassStone = true;
				}
				if(blk && blk.block.event.cls.indexOf('enemy')>=0)
					passFlag.hasPassEnemy = true;
			});
			if(passFlag.hasPassEnemy)core.playSound('light.ogg');
			if(passFlag.hasPassStone)core.playSound('light.ogg');// TODO:
			core.updateLightMap();
			core.drawMap();
		}

		this.addMirror = function(x,y,dir){
			var mirror = core.getFlag("mirror_list",{});
			var blk = {'right':323,'left':324};
			var id = "I" + blk[dir];
			mirror[core.status.floorId] = mirror[core.status.floorId] || [];
			mirror[core.status.floorId].push({'x':x,'y':y,'dir':dir,'id': id});
			//core.insertAction({ "type": "setBgFgBlock", "name": "bg", "number": id, "loc": [x, y] });
			core.setFlag("mirror_list",mirror);
			core.updateLightMap();
			core.drawMap();
		}

		this.tryRemoveLightElem = function(x,y){
			if(!core.isset(x))x = core.status.hero.loc.x;
			if(!core.isset(y))y = core.status.hero.loc.y;
			var mirror = core.getFlag("mirror_list",{})[core.status.floorId] || [];
			var sL = core.getFlag("sourceLight",{})[core.status.floorId]||[];
			function tryRemove(list){
				var m = list.find(function(it){
					return it.x == x && it.y == y;
				});
				if(m){
					core.getItem(m.id);
					list.splice(list.indexOf(m),1);
					return true;
				}
				return false;
			}
			if(tryRemove(mirror) || tryRemove(sL)){
				core.updateLightMap();
				//core.insertAction(todo);
				core.drawMap();
				return true;
			}
			return false;
		}

		// 判断当前所在光色 1 red 2 green 4 blue
		this.getCurrentColor = function(x, y){
			if(!core.isset(x))x = core.getHeroLoc('x');
			if(!core.isset(y))y = core.getHeroLoc('y');
			var tmap = core.getFlag('light_map',{})[core.status.floorId];
			if(tmap && tmap[x])
				return tmap[x][y];
			return null;
		}

		this.clearLight = function(floorId){
			floorId = floorId || core.status.floorId;
			delete core.getFlag('light_map',{})[floorId];
			delete core.getFlag('sourceLight',{})[floorId];
			delete core.getFlag('lock_pts',{})[floorId];
			core.drawMap();
		}

		this.initLight();
},
"gestureAction": function(){
	///// ----- 手势识别 ----- 
	// dljgs1 2020.1.4
	var mx, my, moving=false;
	var route = [];
	var vecs = [];
	var thrLen = 2; // 判断路径的点数阈值
	var thrDist2 = 32*32; // 记录距离的阈值

	// 基本向量操作
	var Vector = function(x, y){
		this.x = x;
		this.y = y;
		this.multiply = function(vec){
			return this.x*vec.x + this.y*vec.y;
		}
		this.norm2 = function(){
			return this.x*this.x + this.y*this.y;
		}
		this.calAngle = function(vec){
			return Math.acos(this.multiply(vec)/Math.sqrt(this.norm2()*vec.norm2()))/Math.PI*180;
		}
		this.add = function(vec){
			this.x += vec.x;
			this.y += vec.y;
		}
		// 编成方向码
		this.encode = function(){
			if(Math.abs(this.x)>Math.abs(this.y)){
				return this.x>0 ? 'right':'left';
			}else{
				return this.y < 0 ? 'up' : 'down';
			}
		}
	}

	// 路径融合
	var packRoute = function(){
		var dx=0,dy=0;
		vecs.forEach(function(v){
			dx += v.x; dy += v.y;
		})
		var r = new Vector(dx,dy);
		vecs = [];
		if(r.norm2()<thrDist2){
			vecs.push(r);
			return;
		}
		if(route.length){
			var lastRoute = route[route.length-1];
			var ang =  Math.abs(lastRoute.calAngle(r));
			if (ang < 30 || lastRoute.encode()==r.encode()){ // 如果偏差较小 则认为方向累积
				lastRoute.add(r);
			}else{// 否则 产生新的方向
				route.push(r);
			}
		}else{
			route.push(r);
		}
		
	}

	var _ondown = function (_x, _y, px, py) {
		if (core.isPlaying() && !core.hasFlag('disableGesture') && !core.status.lockControl) {
			mx = px;
			my = py;
			moving = true;
			route = [];
			vecs = [];
		}
	}
	var _onup = function () {
		if (moving) {
			moving = false;
			core.clearMap('ui');
			core.actions.doRegisteredAction('gesture', route.map(function(v){return v.encode()}));
			if(route.length){
				core.status.stepPostfix = [];
				route = [];
				return true;
			}
		}
	}

	var gestureAction = function(route, prepare){
		var curKey = core.getFlag('curKey', 'I315');
		if(route.length==1){
			if(prepare){
				var dict = {'left':'左','right':'右','up':'上','down':'下',};
				if(core.hasItem(curKey)){
					return {'name': dict[route[0]]+"钥", 'id': curKey};
				}
				else{
					return ;
				}
			}else{
				if(core.canUseItem(curKey)){
					core.setHeroLoc('direction', route[0]);
					core.status.route.push("turn:"+core.getHeroLoc('direction'));
					core.useItem(curKey);
				}else {
					if(core.tryRemoveLightElem()){
						core.status.route.push("getNext");
						core.drawTip("回收成功");
					}else {
						core.drawTip('无法使用');
					}
				}
				return;
			}
		}
		var code = '';
		route.forEach(function(r){
			code += r[0];
		});
		flags.gestureAction = flags.gestureAction || {};
		var it = flags.gestureAction[code];
		var items = core.material.items;
		if(!it){
			var stop = false;
			[core.status.hero.items.constants,core.status.hero.items.tools].forEach(function(lst){
				if(stop)return;
				for(var k in lst){
					if(items[k]){
						var g = items[k].gesture || items[k].equip && items[k].equip.gesture || '';
						if(g && g==code){
							stop = true;
							it = k;
							return ;
						}
					}
				}
			})
		}
		if(it){
			if(prepare){
				return {'name': items[it].name, 'id': it};
			}
			if(core.canUseItem(it)){
				core.drawTip('使用'+items[it].name, it);
				core.useItem(it);
				return true;
			}else{
				core.drawTip('无法使用');
			}
		}else{

		}
	}

	var _onmove = function (_x, _y, px, py) {
		var color = core.material.items[core.getFlag('curKey', 'I315')].equip.color;
		if(moving){
			vecs.push(new Vector(px-mx, py-my));
			core.drawLine('ui', mx, my, px, py, color, 2);//"#ffd700"
			mx = px; my = py;
			if(vecs.length >= thrLen){
				packRoute();
				if(route.length>0){
					var ret = gestureAction(route.map(function(v){return v.encode()}), true);
					if(ret && !core.timeout.tipTimeout){
						if(typeof ret == 'string'){
							core.drawTip(ret);
						}else{
							core.drawTip(ret.name, ret.id);
						}
					}
				}
			}
			return true;
		}
	}
	this.bindGesture = function(code, it){
		flags.gestureAction = flags.gestureAction || {};
		flags.gestureAction[code] = it;
	}

	var gesture2direction = function(code){
		var txt = {
			'u':'↑',
			'd':'↓',
			'l':'←',
			'r':'→',
		}
		var ret = '';
		for(var i in code){
			ret += txt[code[i]];
		}
		return ret;
	}

	core.registerAction('ondown', 'gestureOnDown', _ondown, 50);
	core.registerAction('onup', 'gestureOnUp', _onup, 50);
	core.registerAction('onmove','gestureOnMove', _onmove, 50);
	core.registerAction('gesture', 'gestureAction', gestureAction, 50);

	// 道具显示手势
	ui.prototype._drawToolbox_drawDescription = function (info, max_height) {
		core.setTextAlign('ui', 'left');
		if (!info.selectId) return;
		var item=core.material.items[info.selectId];
		var name = item.name;
		
		if(item.gesture || item.equip && item.equip.gesture){
			var g = item.gesture || item.equip && item.equip.gesture;
			name += '【'+gesture2direction(g)+'】';
		}
		core.fillText('ui', name, 10, 32, '#FFD700', this._buildFont(20, true))
		var text = item.text||"该道具暂无描述。";
		try {
			// 检查能否eval
			text = core.replaceText(text);
		} catch (e) {}
	
		for (var font_size = 17; font_size >= 14; font_size -= 3) {
			var lines = core.splitLines('ui', text, this.PIXEL - 15, this._buildFont(font_size, false));
			var line_height = parseInt(font_size * 1.4), curr = 37 + line_height;
			if (curr + lines.length * line_height < max_height) break;
		}
		core.setFillStyle('ui', '#FFFFFF');
		for (var i=0;i<lines.length;++i) {
			core.fillText('ui', lines[i], 10, curr);
			curr += line_height;
			if (curr>=max_height) break;
		}
		if (curr < max_height) {
			core.fillText('ui', '<继续点击该道具即可进行使用>', 10, curr, '#CCCCCC', this._buildFont(14, false));
		}
	}
	core.registerAction('ondown', 'gestureOnDown', _ondown, 50);
	core.registerAction('onup', 'gestureOnUp', _onup, 50);
	core.registerAction('onmove','gestureOnMove', _onmove, 50);
	core.registerAction('gesture', 'gestureAction', gestureAction, 50);

},

"specialAnimate":function(){ // 特效动画
		window.dljgs1 = window.dljgs1 || {};
		// 雷电特效
		var thunderAnimate = function(fps){
			if(!core.isset(fps))fps = 15;
			var canvas, ctx, w, h, thunder, text, particles, input;
			function Thunder(options) {
				options = options || {};
				this.lifespan = options.lifespan || Math.round(Math.random() * 10 + 10);
				this.maxlife = this.lifespan;
				this.color = options.color || '#fefefe';
				this.glow = options.glow || '#2323fe';
				this.x = options.x || Math.random() * w;
				this.y = options.y || Math.random() * h;
				this.sx = options.sx || Math.random() * w;
				this.sy = options.sy || Math.random() * h;
				this.width = options.width || 2;

				this.x += Math.floor(Math.random()*4-4);
				this.y += Math.floor(Math.random()*4-4);
				this.sx += Math.floor(Math.random()*4-4);
				this.sy += Math.floor(Math.random()*4-4);

				var dw = (this.sx - this.x);
				var dh = (this.sy - this.y);
				var thunderLen = Math.sqrt(dw*dw + dh*dh);
				var minSeg = 3;//至少有三段才出效果
				var segLen = Math.min(32, thunderLen/minSeg);
				if(Math.abs(dw)<1){
					this.direct = dh>=0?Math.PI/2:Math.PI+Math.PI/2;
				}else{
					var angle = Math.atan(dh/Math.abs(dw));
					this.direct = dw>=0?angle:Math.PI-angle;
				}
				this.segments = [];
				var tdis = 0;
				while(tdis < thunderLen-segLen){
					var temp = {
						direct: this.direct + (Math.PI * (0.05-Math.random() * 0.1)),
						length: Math.random() * 10 - 10 + segLen,//80
						change: Math.random() * 0.01 - 0.02
					};
					tdis += temp.length;
					this.segments.push(temp);
				}
				this.max = this.segments.length;

				this.update = function(index, array) {
					this.segments.forEach(
						function(s){ (s.direct += s.change) && Math.random() > 0.96 && (s.change *= -1)
						});
					(this.lifespan > 0 && this.lifespan--) || this.remove(index, array);
				};
				this.render = function(ctx) {
					if (this.lifespan <= 0) return;
					ctx.beginPath();
					ctx.globalAlpha = this.lifespan / this.maxlife;
					ctx.strokeStyle = this.color;
					ctx.lineWidth = this.width;
					ctx.shadowBlur = 32;
					ctx.shadowColor = this.glow;
					ctx.moveTo(this.x, this.y);
					var prev = { x: this.x, y: this.y };
					var x,y;
					this.segments.forEach(function(s) {
						x = prev.x + Math.cos(s.direct) * s.length;
						y = prev.y + Math.sin(s.direct) * s.length;
						prev = { x: x+0, y: y+0 };
						ctx.lineTo(x, y);
					});
					ctx.lineTo(this.sx,this.sy);//***
					ctx.stroke();
					ctx.closePath();
					ctx.shadowBlur = 0;
					var strength = Math.random() * 80 + 40;
					var light = ctx.createRadialGradient(this.x, this.y, 0, this.x, this.y, strength);
					light.addColorStop(0, 'rgba(250, 200, 50, 0.6)');
					light.addColorStop(0.1, 'rgba(250, 200, 50, 0.2)');
					light.addColorStop(0.4, 'rgba(250, 200, 50, 0.06)');
					light.addColorStop(0.65, 'rgba(250, 200, 50, 0.01)');
					light.addColorStop(0.8, 'rgba(250, 200, 50, 0)');
					ctx.beginPath();
					ctx.fillStyle = light;
					ctx.arc(this.x, this.y, strength, 0, Math.PI * 2);
					ctx.fill();
					ctx.closePath();
				};

				this.remove = function(index, array) {
					array.splice(index, 1);
				}
			}
			function Spark(options) {
				options = options || {};
				this.x = options.x || w * 0.5;
				this.y = options.y || h * 0.5;
				this.v = options.v || { direct: Math.random() * Math.PI * 2, weight: Math.random() * 14 + 2, friction: 0.88 };
				this.a = options.a || { change: Math.random() * 0.4 - 0.2, min: this.v.direct - Math.PI * 0.4, max: this.v.direct + Math.PI * 0.4 };
				this.g = options.g || { direct: Math.PI * 0.5 + (Math.random() * 0.4 - 0.2), weight: Math.random() * 0.25 + 0.25 };
				this.width = options.width || Math.random() * 3;
				this.lifespan = options.lifespan || Math.round(Math.random() * 20 + 40);
				this.maxlife = this.lifespan;
				this.color = options.color || '#feca32';
				this.prev = { x: this.x, y: this.y };

				this.update = function(index, array) {
					this.prev = { x: this.x, y: this.y };
					this.x += Math.cos(this.v.direct) * this.v.weight;
					this.x += Math.cos(this.g.direct) * this.g.weight;
					this.y += Math.sin(this.v.direct) * this.v.weight;
					this.y += Math.sin(this.g.direct) * this.g.weight;
					this.v.weight > 0.2 && (this.v.weight *= this.v.friction);
					this.v.direct += this.a.change;
					(this.v.direct > this.a.max || this.v.direct < this.a.min) && (this.a.change *= -1);
					this.lifespan > 0 && this.lifespan--;
					this.lifespan <= 0 && this.remove(index, array);
				}

				this.render = function(ctx) {
					if (this.lifespan <= 0) return;
					ctx.beginPath();
					ctx.globalAlpha = this.lifespan / this.maxlife;
					ctx.strokeStyle = this.color;
					ctx.lineWidth = this.width;
					ctx.moveTo(this.x, this.y);
					ctx.lineTo(this.prev.x, this.prev.y);
					ctx.stroke();
					ctx.closePath();
				}

				this.remove = function(index, array) {
					array.splice(index, 1);
				}
			}
			function Particles(options) {
				options = options || {};
				this.max = options.max || Math.round(Math.random() * 5 + 2);
				//this.sparks = []; // .map(function() {return });
				//var sparks = [...new Array(this.max)].map(function(){return new Spark(options)});
				var sparks = [];
				for(var i = 0;i < this.max;i++){
					sparks.push(new Spark(options));
				}
				this.update = function() {
					sparks.forEach(
						function(s, i) {s.update(i, sparks)});
				}

				this.render = function(ctx) {
					sparks.forEach(function(s){s.render(ctx)});
				}
			}


			var loopPool = [];
			var buffPool = [];

			this.addLoop = function(x,y,sx,sy,ptc){
				loopPool.push(
					{x:x,y:y,sx:sx,sy:sy,ptc:ptc}
				);
			};
			this.clearLoop = function(){
				loopPool = [];
			};

			var last_time = 0;
			function loop(timeStamp) {
				if(timeStamp - last_time > fps) {
					last_time = timeStamp;
					loopPool.forEach(function (l) {
						thunder.push(new Thunder(l));
						if (l.ptc) {
							particles.push(new Particles(l));
						}
					});
					buffPool.forEach(function (l, i) {
						if (l.num <= 0) {
							buffPool.splice(i, 1);
							return;
						} else {
							l.num--;
						}
						thunder.push(new Thunder(l));
						if (l.ptc) {
							particles.push(new Particles(l));
						}
					});
				}
				update();
				render();
			}

			function update() {
				thunder.forEach(function(l, i) { l.update(i, thunder)});
				particles.forEach(function(p){p.update()});
			}

			function render() {
				ctx.globalCompositeOperation = 'source-over';
				ctx.clearRect(0, 0, w, h);
				thunder.forEach(function(l){l.render(ctx)});
				particles.forEach(function(p){p.render(ctx)});
			}

			this.add = function(x,y,sx,sy,num){
				if(!core.dymCanvas.thunder)ctx = core.createCanvas('thunder',0,0,w,h,63);
				core.registerAnimationFrame('thunder', true, loop);
				buffPool.push({x:x,y:y,sx:sx,sy:sy,num:num,ptc:true});
			};
			this.clear = function(){
				thunder = [];
				particles = [];
			};
			w = core.__PIXELS__; h=core.__PIXELS__;
			ctx = core.createCanvas('thunder',0,0,w,h,63);
			thunder = [];
			particles = [];
		};

		// 默认按最高效果的特效进行展示 后续在系统中添加屏蔽设置
		dljgs1.thunderAnimate = new thunderAnimate();

		////// 检查并执行领域、夹击、阻击事件 //////
		var _checkBlock = function () {
			var x=core.getHeroLoc('x'), y=core.getHeroLoc('y'), loc = x+","+y;
			var damage = core.status.checkBlock.damage[loc];
			if (damage) {
				core.status.hero.hp -= damage;
				core.drawTip("受到"+(core.status.checkBlock.type[loc]||"伤害")+damage+"点");
				if(core.status.checkBlock.type[loc]=='电弧伤害'){
					core.status.checkBlock.source[loc].split('|').forEach(function(it){
						if(it){
							var s = it.split(','), sx = parseInt(s[0]), sy = parseInt(s[1]);
							dljgs1.thunderAnimate.add(x*32+16,y*32+16,sx*32+16,sy*32+9,(core.flags.specialLevel || 4) * 2);
						}
						core.playSound('thunder.ogg');
					});
				}else core.drawAnimate("zone", x, y);
				this._checkBlock_disableQuickShop();
				core.status.hero.statistics.extraDamage += damage;
				if (core.status.hero.hp <= 0) {
					core.status.hero.hp=0;
					core.updateStatusBar();
					core.events.lose();
					return;
				}
			}
			this._checkBlock_snipe(core.status.checkBlock.snipe[loc]);
			this._checkBlock_ambush(core.status.checkBlock.ambush[loc]);
		}


	/////////////////特效///////////////////
	// ========== 粒子通用动画接口 ===========

		// 击败敌人 飞灰会飞向勇士的朝向
		this.beatEnemy = function (x, y, w, h, num, dir) {
			if (core.isReplaying()) return;
			if (!core.isset(dir)) dir = core.clone(core.getHeroLoc('direction'));
			var dx = core.utils.scan[dir].x;
			var dy = core.utils.scan[dir].y;
			var cenx = Math.floor(x * 32 + w / 2), ceny = Math.floor(y * 32 + h / 2);
			var focallength = 12;
			if (!core.isset(num)) num = 2;

			this.particleAnimate('event', x, y, w, h, 2, 500,
				null,
				function () {
					this.x = this.dx + 5 * dx + parseInt(focallength / 2 - focallength * Math.random());
					this.y = this.dy + 5 * dy + parseInt(focallength / 2 - focallength * Math.random());
				});
		}

		// 剧情：聚散梦魇 - 对事件层的梦魇王先打散然后飞到另一处聚集 callBack是聚集即将消散（一半）的时候调用的
		this.scatterGather = function (sx, sy, dx, dy, w, h, time, callback) {
			if (core.isReplaying()) return;
			var src_x = sx * 32, src_y = sy * 32;
			var dst_x = dx * 32, dst_y = dy * 32;
			var dif_x = (dst_x - src_x), dif_y = dst_y - src_y;
			var calcuDist = function (x1, y1, x2, y2) {
				return Math.sqrt(Math.pow((x1 - x2), 2) + Math.pow((y1 - y2), 2));
			}
			var dist = parseInt(Math.sqrt(src_x, src_y, dst_x, dst_y));
			var focallength = 3 * dist//飘散范围
			if (!core.isset(time)) time = 2000;
			var nFrame = Math.ceil(time / 50);
			var resFrame = Math.floor(nFrame / 4);// 留1/4帧聚合停留
			nFrame -= resFrame;
			var vx = parseInt(dif_x / nFrame), vy = parseInt(dif_y / nFrame);
			this.particleAnimate("event", sx, sy, w, h, 2, time,
				function (ct) {//首次paint记录在目标应该处于的位置
					if (ct >= nFrame) {
						this.context.globalAlpha = 1.0 - (ct - nFrame) / resFrame;
						if (core.isset(callback)) {
							callback();
							callback = null;
						}
					} else this.context.globalAlpha = 1.0;
					if (!core.isset(this.tx)) {
						this.tx = this.x - src_x + dst_x;
						this.ty = this.y - src_y + dst_y;
					}
					this.context.beginPath();
					this.context.strokeStyle = this.color;
					this.context.arc(this.x, this.y, 1, 0, 2 * Math.PI);
					this.context.stroke();
					this.dx = this.x;
					this.dy = this.y;
				},
				function (ct) {
					if (ct > nFrame / 2) {
						var dif = Math.max(1, (nFrame - ct));
						this.x = this.dx + parseInt((this.tx - this.x) / dif);
						this.y = this.dy + parseInt((this.ty - this.y) / dif);
					} else {
						this.x = this.dx + parseInt(focallength / 2 - focallength * Math.random());
						this.y = this.dy + parseInt(focallength / 2 - focallength * Math.random());
						this.x += vx;
						this.y += vy;
					}
				}
			);
		}


		// 扭曲黑洞  用来收取物体 这个最好在勇士层上面绘制 不然会被挡住
		this.blackHole = function (canvasName, x, y, w, h, time) {
			if (core.isReplaying()) return;
			// 移动计算：模仿银河旋臂，越靠近中心旋转越快，即旋转速度取距离的倒数，同时进行匀速的径向移动
			// 颜色计算：越靠近中心，越接近黑色（0），需要取出color进行削减
			if (!core.isset(w)) w = 32;
			if (!core.isset(h)) h = 32;
			if (!core.isset(time)) time = 500;
			var cenx = Math.floor(x * 32 + w / 2), ceny = Math.floor(y * 32 + h / 2);
			var R = Math.sqrt((w * w + h * h)) / 2;// 半径
			var vR = 50 * R / time; // 径向速度

			var toRectCord = function (r, a) {//转直角坐标系
				var x = r * Math.cos(a);
				var y = r * Math.sin(a);
				return {'x': x, 'y': y};
			}
			var toPolarCord = function (x, y) {//转极坐标系
				x = x - cenx;
				y = ceny - y;
				var r = Math.sqrt(x * x + y * y);
				var a = Math.atan(y / (x + 0.1));
				if (x < 0) {
					a += Math.PI
				}
				;//*重要啊 不然就只会显示一半出来
				return {'r': r, 'a': a};
			}
			var num = 2;
			if (w * h > 2000) {
				num = 5;
			}
			;
			this.particleAnimate(canvasName, x, y, w, h, num, time,
				function () {//交换move paint顺序
					if (!core.isset(this.r)) {
						var polar = toPolarCord(this.x, this.y);
						this.r = polar.r;
						this.a = polar.a;
						this.colorList = this.color.split('(')[1].split(')')[0].split(',');
						this.originColor = core.clone(this.colorList);
					} else {
						this.r = Math.max(0, this.dr - vR);
						;
						this.a = this.da + 5 / (0.1 + this.r);
						if (this.r < R / 6) {
							this.colorList[0] = parseInt(this.originColor[0] * this.r / R);
							this.colorList[1] = parseInt(this.originColor[1] * this.r / R);
							this.colorList[2] = parseInt(this.originColor[2] * this.r / R);
						} else if (this.r < R / 4) {
							this.colorList[0] = parseInt(this.originColor[0] * this.r * 3 / R);
							this.colorList[1] = parseInt(this.originColor[1] * this.r * 3 / R);
							this.colorList[2] = parseInt(this.originColor[2] * this.r * 3 / R);
						}
					}
					this.color = 'rgba(' + this.colorList.join(',') + ')';
					//console.log(this.color);
				},
				function () {
					this.context.beginPath();
					this.context.strokeStyle = this.color;
					var pos = toRectCord(this.r, this.a);
					this.context.arc(parseInt(cenx + pos.x), parseInt(ceny + pos.y), 1, 0, 2 * Math.PI);
					this.context.stroke();
					this.dr = this.r;
					this.da = this.a;
					//move
				}
			);
		}
		
		function setCss3(obj, objAttr) {
			//循环属性对象
			for (var i in objAttr) {
				var newi = i;
				//判断是否存在transform-origin这样格式的属性
				if (newi.indexOf("-") > 0) {
					var num = newi.indexOf("-");
					newi = newi.replace(newi.substr(num, 2), newi.substr(num + 1, 1).toUpperCase());
				}
				//考虑到css3的兼容性问题,所以这些属性都必须加前缀才行
				obj.style[newi] = objAttr[i];
				newi = newi.replace(newi.charAt(0), newi.charAt(0).toUpperCase());
				obj.style[newi] = objAttr[i];
				obj.style["webkit" + newi] = objAttr[i];
				obj.style["moz" + newi] = objAttr[i];
				obj.style["o" + newi] = objAttr[i];
				obj.style["ms" + newi] = objAttr[i];
			}
		}

		// ====== CSS 动画通用接口 ========


		// 特效类 执行完毕后释放数据  canvasName为需要进行特效的canvas（并非最终播放的图层
		var specialAnimate = function (canvasName, fps) {
			this.fps = fps || 20;
			this.ctx = core.getContextByName(canvasName);
		}
		this.specialAnimateInterface = new specialAnimate('hero');
		specialAnimate.prototype.animateCanvas = [];
		specialAnimate.prototype.cur = 0;
		specialAnimate.prototype.max = 100;
		//获得人物中心和鼠标坐标连线，与y轴正半轴之间的夹角
		specialAnimate.prototype.getAngle = function (px, py, mx, my) {
			var x = Math.abs(px - mx);
			var y = Math.abs(py - my);
			var z = Math.sqrt(Math.pow(x, 2) + Math.pow(y, 2));
			var cos = y / z;
			var radina = Math.acos(cos);//用反三角函数求弧度
			var angle = Math.floor(180 / (Math.PI / radina));//将弧度转换成角度
			if (mx > px && my > py) {//鼠标在第4象限
				;//angle = 180 - angle;
			}
			if (mx > px && my < py) {
				angle = 180 - angle;
			}
			if (mx == px && my > py) {//鼠标在y轴负方向上
				angle = 0;
			}
			if (mx > px && my == py) {//鼠标在x轴正方向上
				angle = 90;
			}
			if (mx < px && my > py) {//鼠标在第三象限
				angle = 360 - angle;//angle = 180+angle;
			}
			if (mx < px && my == py) {//鼠标在x轴负方向
				angle = 270;
			}
			if (mx == px && my < py) {//鼠标在x轴负方向
				angle = 180;
			}
			if (mx < px && my < py) {//鼠标在第二象限*
				angle = 180 + angle;//
				//angle = 360 - angle;
			}
			return angle;
		}
		// 获取图片数据的拷贝 返回图片数据
		specialAnimate.prototype.getImageCopy = function (rect, dstCanvas) {
//			console.log(rect);
			var imgData = this.ctx.getImageData.apply(this.ctx, rect);
			//var imgData = this.ctx.getImageData(rect[0],rect[1],rect[2],rect[3])
			if (dstCanvas) {
				var ctx = core.getContextByName(dstCanvas)
				//var ctx = core.createCanvas.apply(core,[dstCanvas].concat(rect));
				ctx.putImageData(imgData, rect[0], rect[1]);
			}
			this.imgData = imgData;
			return imgData;
		}
		// 按一定角度切分成两张图 deg为与y轴的夹角 0~180 保持宽长不变
		specialAnimate.prototype.splitDeg = function (imgData, deg) {
			var w = imgData.width,
				h = imgData.height;
			var cx = w / 2, cy = h / 2;
			var ret1 = new ImageData(w, h);
			var ret2 = new ImageData(w, h);
			ret1.data = core.clone(imgData.data);
			ret2.data = core.clone(imgData.data);
			for (var ox = 0; ox < w; ox += 1) {
				for (var oy = 0; oy < h; oy += 1) {
					var i = (oy * imgData.width + ox) * 4;
					if (imgData.data[i + 3] >= 128) {
						var ang = this.getAngle(cx, cy, ox, oy);
						if (ang < deg || ang > (180 + deg)) {
							ret2.data[i + 3] = 0;
							ret1.data[i + 3] = imgData.data[i + 3];
						} else {
							ret1.data[i + 3] = 0;
							ret2.data[i + 3] = imgData.data[i + 3];
						}
					}
					ret1.data[i] = ret2.data[i] = imgData.data[i];
					ret1.data[i + 1] = ret2.data[i + 1] = imgData.data[i + 1];
					ret1.data[i + 2] = ret2.data[i + 2] = imgData.data[i + 2];
				}
			}
			var ct1 = 0, ct2 = 0;
			ret1.data.forEach(function (i) {
				if (parseInt(i) > 0) {
					ct1 += 1;
				}
			});
			ret2.data.forEach(function (i) {
				if (parseInt(i) > 0) {
					ct2 += 1;
				}
			});
			return {'up': ret1, 'down': ret2};
		}

		specialAnimate.prototype.newCanvas = function (layer, rect) {
			var arr = specialAnimate.prototype.animateCanvas;
			var name = 'special_animate_' + (specialAnimate.prototype.cur % specialAnimate.prototype.max);
			specialAnimate.prototype.cur += 1;
			rect = rect || [0, 0, this.ctx.canvas.width, this.ctx.canvas.height];
			core.createCanvas.apply(core, [name].concat(rect).concat(layer));
			arr.push(name);
			return name;
		}
		specialAnimate.prototype.delCanvas = function (name) {
			var arr = specialAnimate.prototype.animateCanvas;
			var idx = arr.indexOf(name);
			if (idx >= 0) {
				core.deleteCanvas(name);
				arr.splice(idx, 1);
			}
		}
		// 申请一段动画 播放在layer层 保证期间运行正常 如果不给layer 不申请canvas
		specialAnimate.prototype.playAnimate = function (layer, rect, animateFun, time, callback) {
			var ct = time * this.fps / 1000;
			var canvas;
			if (!layer)
				canvas = this.newCanvas(layer, rect);
			//var delCanvas = this.delCanvas;
			var itv = setInterval(
				function () {
					if (ct <= 0 || (layer && !core.getContextByName(canvas))) {
						clearInterval(itv);
						core.plugin.specialAnimateInterface.delCanvas(canvas);
						if (callback) callback();
						return;
					}
					animateFun(canvas, ct);
					ct -= 1;
				}, 50);
		}


		// 随机切分成两片 然后飞向相对的两个方向
		this.splitAnimate = function (canvasName, x, y, w, h, time, layer, v, deg) {
			time = time || 500;
			w = w || 32;
			h = h || 32;
			layer = layer || 50;
			v = v || 10;
			deg = deg || core.rand(180);
			var animate = new specialAnimate(canvasName);
			var rect = [x, y, w, h];
			var imgData = animate.getImageCopy(rect);
			var splitImg = animate.splitDeg(imgData, deg);
			var tp1 = animate.newCanvas(layer, rect);
			var tp2 = animate.newCanvas(layer, rect);
			var ctx1 = core.getContextByName(tp1),
				ctx2 = core.getContextByName(tp2);
			ctx1.putImageData(splitImg.up, 0, 0);
			ctx2.putImageData(splitImg.down, 0, 0);
			var mxct = 0;
			var mv = 1;
			var dx = v * Math.sin(deg / 180 * Math.PI);
			var dy = v * Math.cos(deg / 180 * Math.PI);
			animate.playAnimate(
				null, null,
				function (name, ct) {
					mxct = Math.max(ct, mxct);
					core.setOpacity(tp1, ct / mxct);
					core.setOpacity(tp2, ct / mxct);
					core.relocateCanvas(tp1, x + dx * mv, y + dy * mv);
					core.relocateCanvas(tp2, x - dx * mv, y - dy * mv);
					mv += 1;
				}, time, function () {
					animate.delCanvas(tp1);
					animate.delCanvas(tp2);
				});
		}

		// canvasName指示要复制图像的画布
		// x,y,w,h指示复制区域
		// num是粒子的间隔数目，越大粒子越少
		// time是动画时间
		// paint、如何paint的函数 move：如何移动的函数
		this.particleAnimate = function (canvasName, x, y, w, h, num, time, paint, move, layer, vanish) {
			layer = layer || 100;
			x = x || core.getHeroLoc('x');
			y = y || core.getHeroLoc('x');

			var animate = new specialAnimate(canvasName);
			var canvas = animate.newCanvas(layer, [0, 0, core.__PIXELS__, core.__PIXELS__]);
			var context = core.getContextByName(canvas);
			if (!core.isset(w)) w = 32;
			if (!core.isset(h)) h = 48;
			if (!core.isset(num)) num = 2;
			if (!core.isset(time)) time = 500;
			if (!core.isset(vanish)) vanish = true;
			// 坐标变换
			x *= 32;
			y *= 32;
			if (h > 32) y -= 16;
			var focallength = 10;
			var Dot = function (x, y, color, context) {
				this.x = x;
				this.y = y;
				this.dx = x;
				this.dy = y;
				this.color = color;
				this.context = context;
				var focallength = 15;
			}
			if (core.isset(paint)) Dot.prototype.paint = paint;
			else Dot.prototype.paint = function () {
				this.context.beginPath();
				this.context.strokeStyle = this.color;
				this.context.arc(this.x, this.y, 1, 0, 2 * Math.PI);
				this.context.stroke();
				this.dx = this.x;
				this.dy = this.y;
			}
			if (core.isset(move)) Dot.prototype.move = move;
			else Dot.prototype.move = function () {
				this.x = this.dx + parseInt(focallength / 2 - focallength * Math.random());
				this.y = this.dy + parseInt(focallength / 2 - focallength * Math.random());
			}

			var imgData = animate.getImageCopy([x, y, w, h]);
			var dots = [];
			for (var ox = 0; ox < imgData.width; ox += num) {
				for (var oy = 0; oy < imgData.height; oy += num) {
					var i = (oy * imgData.width + ox) * 4;
					if (imgData.data[i + 3] >= 128) {
						var dot = new Dot(ox + x, oy + y, 'rgba(' + imgData.data[i] + ',' + imgData.data[i + 1] + ',' + imgData.data[i + 2] + ',1.0)', context);
						dots.push(dot);
					}
				}
			}
			console.log(dots.length);
			var ct = 0, nFrame = Math.ceil(time / 50);
			context.globalAlpha = 1.0;
			animate.playAnimate(null, null,
				function () {
					ct += 1;
					core.clearMap(canvas);
					context.globalAlpha = (nFrame - ct) / nFrame;
					dots.forEach(function (v) {
						v.paint(ct);
						v.move(ct);
					})
				}, time, function () {
					animate.delCanvas(canvas)
				});
		}


		// 对敌人切片 播放带角度的singleSword
		this.splitEnemy = function (x, y, deg) {
			var blk = core.getBlock(x, y);
			var ang = deg || core.rand(180);
			core.drawAnimate('baseSword', (x + 100 * ang), y, null);
			x *= 32;
			y *= 32;
			if (blk.block.event.cls == "enemy48") {
				var ctx = core.createCanvas('temp', 0, 0, core.__PIXELS__, core.__PIXELS__);
				var img1 = core.getContextByName('event').getImageData(x, y, 32, 32);
				var img2 = core.getContextByName('event2').getImageData(x, y - 16, 32, 16);
				ctx.putImageData(img2, x, y - 16);
				ctx.putImageData(img1, x, y);
				core.splitAnimate('temp', x, y, 32, 48, 500, 100, 5, ang);
			} else {
				core.splitAnimate('event', x, y, 32, 32, 500, 100, 5, ang);
			}
		}

		// 特效-瞬步斩 : blur
		this.drawSword = function (direction) {
			var loc = core.status.hero.loc;
			direction = direction || loc.direction;
			var rect = [loc.x * 32, loc.y * 32 - 16, 32, 48];
			var animate = new specialAnimate('hero');
			var dx = core.utils.scan[direction].x,
				dy = core.utils.scan[direction].y;
			var canvas = animate.newCanvas(100, [0, 0, core.__PIXELS__, core.__PIXELS__]);
			animate.getImageCopy(rect, canvas);
			core.particleAnimate(canvas, loc.x, loc.y, 32, 48, null, 400,
				null,
				function (ct) {
					//console.log(ct);
					this.context.canvas.style.filter = 'blur(' + ct / 4 + 'px)';
					this.x += dx * Math.max(1, 8 - ct) + dx * core.rand(ct);
					this.y += dy * Math.max(1, 8 - ct) + dy * core.rand(ct);
				});
			animate.delCanvas(canvas);
		}


		// 特效-拿宝物（旋转缩小）——css尝试——除非向上 都是显示在勇士层上面的（向上就用下面的层）

		this.catchItem = function (canvasName, x, y, w, h, time) {
			if (core.isReplaying()) return;
			if (!core.isset(canvasName)) canvasName = 'event';
			if (!core.isset(x)) x = core.getHeroLoc('x');
			if (!core.isset(y)) y = core.getHeroLoc('y');
			if (!core.isset(w)) w = 32;
			if (!core.isset(h)) h = 32;
			if (!core.isset(time)) time = 500;
			var hx = core.getHeroLoc('x'), hy = core.getHeroLoc('y');
			//var dx = hx - x, dy = hy - y;
			x *= 32;
			y *= 32;
			var dir = core.getHeroLoc('direction');
			//dx += core.utils.scan[dir].x/10, dy +=  core.utils.scan[dir].y/10;
			var animate = new specialAnimate(canvasName);
			var rect = [x, y, w, h];
			var layer = dir == 'up' ? 35 : 55;
			var canvas = animate.newCanvas(layer, rect);
			var imgData = animate.getImageCopy([x, y, w, h], canvas);
			var ctx = core.getContextByName(canvas);

			//var ctx = core.createCanvas(canvas,x,y,w,h,parseInt(canvas.split('_')[1]));
			//var imgData = core.getContextByName(canvasName).getImageData(x,Math.max(0,y-(h-w)),w,h);
			ctx.putImageData(imgData, 0, 0);
			var obj = ctx.canvas;
			var angle = 0;
			var ct = 0;
			var nFrame = parseInt(time / 50);
			setCss3(obj, {transform: "rotate(0deg)", "transform-origin": "50% 50%"})
			animate.playAnimate(null, null, function () {
				angle += 27;
				ct += 1;
				//core.relocateCanvas(canvas,(x+ct*dx),(x+ct*dy));
				var scale = (nFrame - ct) / nFrame;
				setCss3(obj, {
					transform: "rotate(" + angle + "deg)scale(" + scale + "," + scale + ")",
					"transform-origin": "" + (50) + "% " + (50 - ct * 3) + "%"
				});
			}, time, function () {
				animate.delCanvas(canvas);
			})
		}

		// 特效-飞升：拉长变模糊 最后变成白色分解掉?（基础粒子动画） CANVAS + CSS
		this.flyToGod = function (canvasName, x, y, w, h, time) {
			if (core.isReplaying()) return;
			if (!core.isset(canvasName)) canvasName = 'event';
			if (!core.isset(x)) x = core.getHeroLoc('x');
			if (!core.isset(y)) y = core.getHeroLoc('y');
			if (!core.isset(w)) w = 32;
			if (!core.isset(h)) h = 32;
			if (!core.isset(time)) time = 500;
			x *= 32;
			y *= 32;
			var ct = 0;
			var canvas = core.plugin.getAnmiateCanvas();
			var ctx = core.createCanvas(canvas, x, y, w, h, parseInt(canvas.split('_')[1]));
			var imgData = core.getContextByName(canvasName).getImageData(x, Math.max(0, y - (h - w)), w, h);
			ctx.putImageData(imgData, 0, 0);
			var obj = ctx.canvas;
			var nFrame = time / 50;
			ctx.globalAlpha = 1.0;
			setCss3(obj, {transform: "rotate(0deg)scale(1,1)", "transform-origin": "50% 100%"})
			var itv = setInterval(function () {
				ct += 1;
				if (ct >= nFrame || !core.plugin.isExistCanvas(canvas)) {
					core.plugin.clearAnimateCanvas(canvas);
					core.deleteCanvas(canvas);//CSS用完肯定就脏了 必须删了
					clearInterval(itv);
					return;
				}
				var x_scale = (nFrame - Math.floor(ct / 2)) / nFrame;
				var y_scale = (nFrame + 4 * ct) / nFrame;
				setCss3(obj, {
					opacity: "" + (nFrame - ct) / nFrame,
					transform: "rotate(0deg)scale(" + x_scale + "," + y_scale + ")",
					"transform-origin": "50% 100%"
				});

			}, 50);
		}

		/////////////////技能////////////////
		this.canUseSkill = function (id) {
			var skill = core.getFlag('skill');
			var rt = true;
			if (skill[id]) {
				if (skill[id].maxcd) {
					rt = (skill[id].cd >= skill[id].maxcd) && rt;
				}
			}
			return rt;
		}

		// 能否使用瞬步斩
		this.canUseMovesword = function () { // 剑气消耗值在能否使用物品中判断
			if (core.status.hero.mdef <= 0) return false;
			var loc = core.status.hero.loc;
			var x = loc.x, y = loc.y, dir = loc.direction;
			var dx = core.utils.scan[dir].x, dy = core.utils.scan[dir].y;
			var blk1 = core.getBlock(x + dx, y + dy),
				blk2 = core.getBlock(x + 2 * dx, y + 2 * dy);
			if (!blk1 || (blk1.block.event.cls != 'enemys' && blk1.block.event.cls != 'enemy48'))
				return false;
			if (blk2 && blk2.block.event.noPass) return false;
			blk2 = blk2 || {'block': {'x': x + 2 * dx, 'y': y + 2 * dy}};
			core.status.event.ui = [blk1, blk2];
			return true;
		};
		// 使用瞬步斩的实际过程
		this.skillMovesword = function () {
			core.status.hero.mdef -= 1;
			var floorId = core.status.floorId;
			var blk = core.status.event.ui[0].block,
				dst = core.status.event.ui[1].block;
			var id = core.status.event.ui[0].index;
			var enemy = core.enemys.getEnemyInfo(blk.event.id);
			var damage = Math.max(0, core.status.hero.atk - enemy.def);//* core.getFlag('moveSwordProp', 0.3);
			var idxs = blk.x + ',' + blk.y + floorId;
			var bombBlock = core.getFlag('bombBlock');
			var removeBlocks = [];
			if (enemy.hp - (damage + (bombBlock[idxs] || 0)) <= 0) {
				removeBlocks.push(id);
				delete core.status.hero.flags.bombBlock[idxs];
			} else {
				core.status.hero.flags.bombBlock[idxs] = core.status.hero.flags.bombBlock[idxs] || 0;
				core.status.hero.flags.bombBlock[idxs] += damage;
			}
			core.plugin.drawSword();
			core.status.hero.loc.x = dst.x;
			core.status.hero.loc.y = dst.y;
			core.checkBlock();
			core.clearMap('hero');
			// TODO: 绘制伤害
			setTimeout(function () {
				core.drawHero()
			}, 150);
			if (removeBlocks.length > 0) {
				console.log('del:' + id);
				core.plugin.splitEnemy(blk.x, blk.y);
				core.removeBlock(blk.x, blk.y);
			} else {
				core.drawAnimate('baseSword', blk.x + 100 * core.rand(180), blk.y);
			}
			//core.removeBlockByIds(floorId,removeBlocks);
			core.insertAction([
				{"type": "trigger"},
				{"type": "update"},
				{"type": "updateEnemys"},
			], dst.x, dst.y);
		}
		
		
},
    "components": function () {
    	// ui组件移植差分文件：
		// _server/editor_blickly.js
		// _server/MotaAction.g4
		// libs/events.js
		// libs/ui.js

		////// 解锁状态栏 //////
		control.prototype.unLockControl = function () {
			if(core.status.hero && core.status.hero.eventlock)return;
			core.status.lockControl = false;
		}

        // 一个UI可以注册多个组件，但每一类组件只能注册一个
        // 组件编写方法： 必须要返回一个至少包含启动（install）、卸载（uninstall）的对象，这个对象会被绑定作为UI的成员。UI会在注册组件时，为组件提供自身的访问接口，可以通过 this.ui 进行访问。可以获取的数据：this.ui.x this.ui.y this.ui.width this.ui.height
	
        // 范例1：触摸/点击交互 (使用ondown 可以捕获像素级精度)
        this.component_click = function (data) {
            var compName = data.name;
            var action = data.action;
            action.push({ "type": "function", "function": "function(){['name','x','y','width','height'].forEach(function(it){core.removeFlag('arg_'+it)})}" });

            function install() {
                // 点击时执行调用
                var x = this.ui.x;
                var y = this.ui.y;
                var w = this.ui.width;
                var h = this.ui.height;
                var name = this.ui.name;
                var self = this;

                function tmpfunc(_x, _y, px, py) {
                    if (!self.ui.enable) return false;
                    if (px >= x && px <= x + w && py > y && py <= y + h) {
                        if (core.hasFlag('arg_name')) return false;
                        core.setFlag('arg_x', x);
                        core.setFlag('arg_y', y);
                        core.setFlag('arg_px', px);
                        core.setFlag('arg_py', py);
                        core.setFlag('arg_width', w);
                        core.setFlag('arg_height', h);
                        core.setFlag('arg_name', name);
                        core.insertAction(action);
                        return true;
                    }
                    return false;
                }
                core.registerAction('ondown', name + compName, tmpfunc, data.param || 100); //优先级？
            }

            function uninstall() {
                var name = this.ui.name;
                core.unregisterAction('ondown', name + compName);
            }
            return { 'install': install, 'uninstall': uninstall };
        }
        // 范例2：拖动交互 (使用ondown/onup/onmove)
        this.component_drag = function (data) {
            var compName = data.name;
            var action = data.action;
            action.push({ "type": "function", "function": "function(){['name','x','y','width','height'].forEach(function(it){core.removeFlag('arg_'+it)})}" });
            var isdown = false;
            var lastX = 0;
            var lastY = 0;

            function install() {
                var x = this.ui.x;
                var y = this.ui.y;
                var w = this.ui.width;
                var h = this.ui.height;
                var name = this.ui.name;
                var self = this;

                function down(_x, _y, px, py) {
                    if (!self.ui.enable) return false;
                    if (px >= x && px <= x + w && py > y && py <= y + h) {
                        isdown = true;
                        lastX = px;
                        lastY = py;
                        return false;
                    }
                }

                function up(_x, _y, px, py) {
                    if (!self.ui.enable) return false;
                    if (isdown) {
                        isdown = false;
                    }
                }

                function move(_x, _y, px, py) {
                    if (!self.ui.enable) return false;
                    if (core.hasFlag('arg_name') || !isdown) return false;
                    core.setFlag('arg_lastx', lastX);
                    core.setFlag('arg_lasty', lastY);
                    core.setFlag('arg_x', x);
                    core.setFlag('arg_y', y);
                    core.setFlag('arg_px', px);
                    core.setFlag('arg_py', py);
                    core.setFlag('arg_width', w);
                    core.setFlag('arg_height', h);
                    core.setFlag('arg_name', name);
                    core.insertAction(action);
                    lastX = px;
                    lastY = py;
                    return true;
                }
                core.registerAction('ondown', name + compName, down, data.param || 100); //优先级？
                core.registerAction('onup', name + compName, up, data.param || 100);
                core.registerAction('onmove', name + compName, move, data.param || 100);
            }

            function uninstall() {
                var name = this.ui.name;
                core.unregisterAction('ondown', name + compName);
                core.unregisterAction('onup', name + compName);
                core.unregisterAction('onmove', name + compName);
            }
            return { 'install': install, 'uninstall': uninstall, isdown: false };
        }


        var keyTable = { "0": "96", "1": "97", "2": "98", "3": "99", "4": "100", "5": "101", "6": "102", "7": "103", "8": "104", "9": "105", "A": "65", "J": "74", "S": "83", "B": "66", "K": "75", "T": "84", "C": "67", "L": "76", "U": "85", "D": "68", "M": "77", "V": "86", "E": "69", "N": "78", "W": "87", "F": "70", "O": "79", "X": "88", "G": "71", "P": "80", "Y": "89", "H": "72", "Q": "81", "Z": "90", "I": "73", "R": "82", "F1": "112", "F7": "118", "F2": "113", "F8": "119", "*": "106", "F3": "114", "F9": "120", "+": "107", "F4": "115", "F10": "121", "Enter": "13", "F5": "116", "F11": "122", "-": "109", "F6": "117", "F12": "123", ".": "110", "/": "111", "BackSpace": "8", "Esc": "27", "Right": "39", "-_": "189", "Tab": "9", "Spacebar": "32", "Down": "40", ".>": "190", "Clear": "12", "PageUp": "33", "Insert": "45", "PageDown": "34", "Delete": "46", "~": "192", "Shift": "16", "End": "35", "NumLock": "144", "[{": "219", "Control": "17", "Home": "36", ";:": "186", "Alt": "18", "Left": "37", "=+": "187", "}": "221", "CapeLock": "20", "Up": "38", "<": "188", "\'": "222" };

        // 范例3：按键 (使用onkeyup)
        this.component_keyup = function (data) {
            var compName = data.name;
            var action = data.action;
            action.push({ "type": "function", "function": "function(){['name','key'].forEach(function(it){core.removeFlag('arg_'+it)})}" });
            var isdown = false;
            var lastX = 0;
            var lastY = 0;
            var piror = 0;
            var keys = {};
            var blocke = false;
            data.param.split(',').forEach(function (k) {
                if (keyTable[k]) {
                    keys[keyTable[k]] = k;
                } else {
                    var tmp = parseInt(k);
                    if (tmp > 0) piror = tmp;
                    else blocke = true;
                }
            });

            function install() {
                var x = this.ui.x;
                var y = this.ui.y;
                var w = this.ui.width;
                var h = this.ui.height;
                var name = this.ui.name;
                var self = this;

                function keydown(e) {
                    if (!self.ui.enable) return false;
                    if (core.hasFlag('arg_name') || !keys[e]) return blocke;
                    core.setFlag('arg_key', keys[e]);
                    core.setFlag('arg_name', name);
                    core.insertAction(action);
                    return true;
                }
                core.registerAction('keyUp', name + compName, keydown, piror);
            }

            function uninstall() {
                var name = this.ui.name;
                core.unregisterAction('keyUp', name + compName);
            }
            return { 'install': install, 'uninstall': uninstall, isdown: false };
        }

        // 范例4：延时按键 (使用onkeyup)
        this.component_keydelaydown = function (data) {
            var compName = data.name;
            var action = data.action;
            action.push({ "type": "function", "function": "function(){['name','key'].forEach(function(it){core.removeFlag('arg_'+it)})}" });
            var isdown = false;
            var lastX = 0;
            var lastY = 0;
            var piror = 0;
            var keys = {};
            var blocke = false;
            data.param.split(',').forEach(function (k) {
                if (keyTable[k]) {
                    keys[keyTable[k]] = k;
                } else {
                    var tmp = parseInt(k);
                    if (tmp > 0) piror = tmp;
                    else blocke = true;
                }
            });

            function install() {
                var x = this.ui.x;
                var y = this.ui.y;
                var w = this.ui.width;
                var h = this.ui.height;
                var name = this.ui.name;
                var self = this;

                function keydown(e) {
                    if (!self.ui.enable) return false;
                    if (core.hasFlag('arg_name') || !keys[e] || self.isdown) return blocke;
                    core.setFlag('arg_key', keys[e]);
                    core.setFlag('arg_name', name);
                    self.isdown = true;
                    self.itv = setTimeout(function () { self.isdown = false; }, 100); // 按住后会按每秒四次执行
                    core.insertAction(action);
                    return true;
                }

                function keyup(e) {
                    if (core.hasFlag('arg_name') || !keys[e]) return blocke;
                    if (self.itv) clearTimeout(self.itv);
                    self.isdown = false;
                    return true;
                }
                core.registerAction('keyUp', name + compName, keyup, piror);
                core.registerAction('keyDown', name + compName, keydown, piror);
            }

            function uninstall() {
                var name = this.ui.name;
                core.unregisterAction('keyUp', name + compName);
                core.unregisterAction('keyDown', name + compName);
            }
            return { 'install': install, 'uninstall': uninstall, isdown: false };
        }


        // 析构组件 当删除时调用action
        this.component_deconstruct = function (data) {
            var action = data.action;

            function install() {}

            function uninstall() {
                core.insertAction(action);
            }
            return { 'install': install, 'uninstall': uninstall };
        }
    },

"specialSkills":function(){

	// 
	var origin_drawBg = core.maps.drawBg;
	core.maps.drawBg = function (floorId, ctx) {
		origin_drawBg.call(core.maps,floorId,ctx);
		var bg = core.getFlag('bgAnimate', {});
		for(var i in bg){
			var f = bg[i];
			if((!ctx || ctx === core.canvas.bg) && floorId == f.floorId && core.status.floorId == floorId){
				var blk = core.initBlock(f.x,f.y,f.num,true);
				blk.name = 'bg';
				core.addGlobalAnimate(blk);
			}
		};
	}


	this.setBgAnimateBlock = function(name,floorId,x,y,num){
		var bgAnimate = core.getFlag('bgAnimate', {});
		bgAnimate[name]={
			floorId:floorId,
			x: x,
			y: y,
			num: num,
		};
		core.setFlag('bgAnimate', bgAnimate);
	}
	this.getBgAnimateInfo = function(name, defValue){
		return (flags.bgAnimate = flags.bgAnimate || {})[name] || defValue;
	}
	this.removeBgAnimateBlock = function(name){
		var bgAnimate = core.getFlag('bgAnimate', {});
		delete bgAnimate[name];
		core.setFlag('bgAnimate', bgAnimate);
	}




	// space recover
	this.useLocation = function(){
		var f = {
			floorId:core.status.floorId,
			x: core.getHeroLoc('x'),
			y: core.getHeroLoc('y'),
		};
		var fl = core.getFlag('fLocation', {});
		var name = core.getFlag('hard', 1)==1?'fLocation':f.floorId;
		if(fl[f.floorId] && fl[f.floorId].x == f.x && fl[f.floorId].y == f.y){
			core.removeBgAnimateBlock(name);
			delete fl[f.floorId];
			core.drawMap();
			return;
		}
		if(core.getFlag('hard', 1)==1)fl = {};
		core.setBgAnimateBlock(name, f.floorId, f.x, f.y, 345);
		fl[core.status.floorId] = f;
		core.setFlag('fLocation', fl);
		core.drawMap();
	}

	var checkDead = true;
	this.bfsFlood = function (startX, startY, banLoc) {
		checkDead = false;
		var route = {},
			canMoveArray = core.maps.generateMovableArray();
		canMoveArray[startX][startY] = ["left", "down", "up", "right"];
		var blockArr = core.getMapBlocksObj();
		blockArr[startX + "," + startY] = null;
		// 使用优先队列
		var queue =  new PriorityQueue({ comparator: function (a, b) { return a.depth - b.depth; } });
		route[startX + "," + startY] = { 'step': 0, 'x': startX, 'y':startY};
		queue.queue({ depth: 0, x: startX, y: startY });
		var dirSort = Object.keys(core.utils.scan);
		var hDir = core.getHeroLoc('direction');
		dirSort = dirSort.sort(function(a,b){
			return (a==hDir? 100:0)-(b==hDir? 100:0);
		})

		while (queue.length != 0) {
			var curr = queue.dequeue(),
				deep = curr.depth,
				nowX = curr.x,
				nowY = curr.y;
			for (var i in dirSort) {
				var direction = dirSort[i];
				if (!core.inArray(canMoveArray[nowX][nowY], direction)) continue;
				var nx = nowX + core.utils.scan[direction].x;
				var ny = nowY + core.utils.scan[direction].y;
				if (nx < 0 || nx >= core.bigmap.width || ny < 0 || ny >= core.bigmap.height || route[nx + "," + ny] != null) continue;
				if (blockArr[nx + "," + ny]) continue; //只要是块就绕过
				if((banLoc || []).indexOf(nx + "," + ny)>=0)continue;
				route[nx + "," + ny] = { 'direction': direction, 'step': deep + 1, 'x': nx, 'y': ny};
				queue.queue({ depth: deep + 1, x: nx, y: ny });
			}
		}
		checkDead = true;
		return route;
	}
	maps.prototype._canMoveHero_checkPoint = function (x, y, direction, floorId, extraData) {
		// 1. 检查该点 cannotMove
		if (core.inArray((core.floors[floorId].cannotMove || {})[x + "," + y], direction))
			return false;
	
		var nx = x + core.utils.scan[direction].x, ny = y + core.utils.scan[direction].y;
		if (nx < 0 || ny < 0 || nx >= core.floors[floorId].width || ny >= core.floors[floorId].height)
			return false;
	
		// 2. 检查该点素材的 cannotOut 和下一个点的 cannotIn
		if (this._canMoveHero_checkCannotInOut([
				extraData.bgArray[y][x], extraData.fgArray[y][x], extraData.eventArray[y][x]
			], "cannotOut", direction))
			return false;
		if (this._canMoveHero_checkCannotInOut([
				extraData.bgArray[ny][nx], extraData.fgArray[ny][nx], extraData.eventArray[ny][nx]
			], "cannotIn", direction))
			return false;
	
		   // 3. 检查是否能进将死的领域
		if(checkDead)
			if (floorId == core.status.floorId
				&& core.status.hero.hp <= (core.status.checkBlock.damage[nx + "," + ny]||0)
				&& !core.flags.canGoDeadZone && extraData.eventArray[ny][nx] == 0)
				return false;
		return true;
	}

	// 陷进掉落
	var trapSound = {348:'drop.mp3',354:'centerFly.mp3'};
	this.nextFloorId = function(dir){
		return core.floorIds[core.floorIds.indexOf(core.status.floorId ) +dir];
	}
	maps.prototype._moveJumpBlock_finished = function (blockInfo, canvases, info, animate, callback) {
		if (info.keep) info.opacity = 0;
		else info.opacity -= 0.06;
		if (info.opacity <= 0) {
			delete core.animateFrame.asyncId[animate];
			clearInterval(animate);
			this._deleteDetachedBlock(canvases);
			// 不消失
			if (info.keep) {
				var num = core.getBgNumber(info.x, info.y);
				var dir = {348:-1,354:1};
				var floor = core.status.floorId;
				if(num && dir[num]){
					core.playSound(trapSound[num]);
					var nextFloor = core.nextFloorId(dir[num]); 
					if(!core.getBlock(info.x, info.y, nextFloor)){
						floor = nextFloor;
					}
				}
				core.setBlock(blockInfo.number, info.x, info.y, floor);
				core.showBlock(info.x, info.y, floor);
			}
			if (callback) callback();
		}
		else {
			this._moveDetachedBlock(blockInfo, info.px, info.py, info.opacity, canvases);
		}
	}


	// 计算逃跑路线
	this.runAway = function(x, y, maxStep){
		var heroLoc = core.status.hero.loc;
		var route = core.bfsFlood(x, y, [heroLoc.x+','+heroLoc.y]);
		var bg = core.getBgMapArray();
		function dist(o){
			return Math.abs(route[o].x - heroLoc.x) + Math.abs(route[o].y - heroLoc.y) + (bg[route[o].y][route[o].x]?-0.5:0);
		}
		var lst = Object.keys(route).filter(function(o){
			return route[o].step<=maxStep;
		})
		lst = lst.sort(function(a, b){
			return dist(b) - dist(a);
		});
		var dst = lst[0];
		var ret = [];
		var dest = {x:x,y:y};
		var trap = [348, 354];
		if(dst){
			var nowX = route[dst].x, nowY = route[dst].y;
			dest.x = nowX; dest.y = nowY;
			while (nowX != x || nowY != y) {
				if(trap.indexOf(bg[nowY][nowX])>=0){ // 路上陷阱
					dest.x = nowX; dest.y = nowY; ret = [];
				}
				var dir = route[nowX + "," + nowY].direction;
				ret.push(dir);
				nowX -= core.utils.scan[dir].x;
				nowY -= core.utils.scan[dir].y;
			}
		}
		ret.reverse();
		return {route:ret,dest:dest};
	}

	// 脱衣次数
	this.getTakeOff = function(sx,sy){
		var src = core.status.floorId + '@' + sx +','+sy;
		var flag = core.getFlag('takeOff',{});
		return flag[src] || 0;
	}
	this.addTakeOff = function(sx,sy,dx,dy){
		var src = core.status.floorId + '@' + sx +','+sy;
		var dst = core.status.floorId + '@' + dx +','+dy;
		var flag = core.getFlag('takeOff',{});
		flag[dst] = (flag[src] || 0) + 1;
		delete flag[src];
		core.setFlag('takeOff', flag);
	}
	this.removeTakeOff = function(sx,sy){
		var src = core.status.floorId + '@' + sx +','+sy;
		var flag = core.getFlag('takeOff',{});
		delete flag[src];
		core.setFlag('takeOff', flag);
	}


},

"specialTrick":function(){
	this.checkFlower = function(floorId){
		if(main.mode=='editor')return;
		if(core.getFlag('over',false))return;
		// 用afterOpenDoor做标记
		floorId = floorId || core.status.floorId || null;
		if(!floorId)return;
		var evts = core.floors[floorId].afterOpenDoor;
		var lock = core.getFlag('flowerLocks',{});
		var todo = [];
		var hloc = core.getHeroLoc('x')+','+core.getHeroLoc('y');
		for(var pos in evts){
			var e = evts[pos][0];
			var ex = [];
			for(var i = 1; i < evts[pos].length ; i++){
				ex.push(evts[pos][i]);
			}
			if(e.type!='openDoor')continue;
			var p = pos.split(',');
			var x = parseInt(p[0]), y = parseInt(p[1]);
			var blk = core.getBlock(x,y,floorId);
			if(pos==hloc)blk=true;
			var f = floorId + pos;
			if(!blk && lock[f]){
				todo.push({"type": "closeDoor", "id": "specialDoor", "loc": e.loc, "async": true});
				if(ex.length>0)todo.push({"type": "waitAsync"});
				todo = todo.concat(ex);
				delete lock[f];
			}
			if(blk && !lock[f]){
				todo.push({"type": "openDoor", "loc": e.loc, "async": true});
				if(ex.length>0)todo.push({"type": "waitAsync"});
				todo = todo.concat(ex);
				lock[f] = true;
			}
		}
		if(todo.length>0){
			todo.push({"type": "waitAsync"});
			todo.push({"type": "function", "function": "function(){\ncore.updateLightMap()\n}"});
			core.insertAction(todo);
		}
		core.setFlag('flowerLocks',lock);
		core.clearMap('fg');
		core.drawFg();
	}

	function getEndBlock(x,y,d){
		var blk = null;
		do{
			x += core.utils.scan[d].x;
			y += core.utils.scan[d].y;
			blk = core.getBlock(x, y);
		}while(!blk && x<core.__SIZE__ && x>=0 && y<core.__SIZE__ && y>=0);
		return blk;
	}
	this.checkMonster = function(){
		if(!core.floors[core.status.floorId].cannotMoveDirectly)return;// 不能瞬移才起作用
		var x = core.getHeroLoc('x'), y = core.getHeroLoc('y');
		if(core.getBlock(x,y))return;
		var todo = [];
		var inv_dir = {'left':'right','up':'down','right':'left','down':'up'};
		for(var d in core.utils.scan){
			var blk = getEndBlock(x,y,d);
			if(blk && blk.block.event.cls.indexOf('enemy')>=0 && core.hasSpecial(blk.block.event.id, 30) && !core.getCurrentColor(blk.block.x,blk.block.y)){
				todo.push(
					{"type": "move", "loc": [blk.block.x,blk.block.y], "time": 200, "keep": true, "steps": [inv_dir[d]], "async": true, }
				);
			}
		}
		if(todo.length > 0){
			todo.push({"type": "waitAsync"});
			todo.push({"type": "function", "function": "function(){core.checkBlock()}"});
			core.insertAction(todo);
		}
	}

	this.isHeroThere = function(x, y){
		return core.getHeroLoc('x') == x && core.getHeroLoc('y') == y; 
	}



	var numBlock = [10185,10186,10187,10188,10189,10193,10194,10195,10196,10197];
	var poses = [[1,3],[1,2],[1,1],[1,6],[1,5],[1,4]];
	this.endMissionUpdate = function(pos){
		pos = pos || poses;
		function getNum(s,e){
			var num = 0;
			var d = 1;
			for(var i = s; i<e; i++){
				if(!core.getBlock(pos[i][0],pos[i][1])){
					num += d;
				}
				d <<= 1;
			}
			return num;
		}
		var n1 = getNum(0, 3), n2 = getNum(3, 6);
		core.setBgFgBlock('bg', numBlock[n1], 7, 8);
		core.setBgFgBlock('bg', numBlock[n2], 9, 8);
		
		console.log(n1*10 + n2)
		return n1*10 + n2;
	}
	var yline = 12;
	var st = 2;
	this.endMissionCheck = function(pos){
		var inputs = core.getFlag('inputNums', []);
		var res = core.endMissionUpdate(pos);
		switch(res){
			case 0:
				if(inputs.length>0){
					core.setBgFgBlock('fg', 0, st + inputs.length - 1, yline)
					inputs.pop();
				}
				res = null;
				break;
			case 22:
				var pos = Object.keys(core.floors[core.status.floorId].afterOpenDoor).find(function(idx){
					idx = idx.split(',');
					var x = ~~idx[0], y = ~~idx[1];
					if(!core.getBlock(x, y)){
						core.setBlock('box', x, y);
						return true;
					}
					return;
				});
				if(!pos){
					core.drawTip("位置已满");
				}
				return;
			case 33:
				res = 9;
				break;
			default:
				break;
		}
		if(inputs.length>=11){
			core.drawTip("输入超过上限！");
			return ;
		}
		var ns = [];
		if(res != null){
			if((res%10)>8){
				ns.push(res);
			}else{
				ns = [~~(res/10), res%10];
			}
		}
		inputs = inputs.concat(ns);
		var num = 0;
		for(var i = 0; i< inputs.length; i++){
			num *= 10;
			num += inputs[i];
			core.setBgFgBlock('fg', numBlock[inputs[i]], ~~i + st, yline);
		}
		if(num==539113091){
			core.setBlock('computer', 6, 0);// TODO
		}
		core.setFlag('inputNums', inputs);
		core.drawFg();
	}

},
"showing": function(){
	// --- 公共方法 ---

	// 准备离屏canvas
	this.canvasPrepare = function(){
		var newCanvas = document.createElement("canvas");
		newCanvas.width = core.__PIXELS__;
		newCanvas.height = core.__PIXELS__;
		var ctx = newCanvas.getContext('2d');
		return ctx;

	}
	// 当前视窗的掩码图
	this.maskPrepare = function() {
		var ctx = core.canvasPrepare();
		for (var m in core.canvas) {
			ctx.drawImage(core.canvas[m].canvas, 0, 0);
		};
		return ctx;
	}
	//生成从minNum到maxNum的随机数
	function randomNum(range){ 
		var minNum = range[0];
		var maxNum = range[1];
		switch(range.length){ 
			case 1: 
				return parseInt(Math.random()*minNum+1,10); 
			break; 
			case 2: 
				return parseInt(Math.random()*(maxNum-minNum+1)+minNum,10); 
			break; 
				default: 
					return 0; 
				break; 
		} 
	}

	// canvas特效类
	function canvasEffect(name,frameFunc,exConfig){
		// 基本设置
		var config = {
			sx: 0,
			sy: 0,
			sw: core.__PIXELS__,
			sh: core.__PIXELS__,
			freq: 10,
			prior: 151,
		};
		for(var it in exConfig){
			config[it] = exConfig[it];
		}
		var self = this;
		var lastTime = -1;
		var frame = function(timeStamp){
			if(lastTime<0)lastTime = timeStamp;
			if(timeStamp - lastTime>=config.freq){
				lastTime = timeStamp;
				frameFunc(config, this);
			}
		}
		this.getConfig = function(name){
			return config[name];
		}
		this.setConfig = function(name,value){
			config[name] = value;
		}
		this.keep = function() {
			core.createCanvas(name,config.sx,config.sy,config.sw,config.sh,config.prior);
			core.registerAnimationFrame(name, true, frame);
		}
		this.close = function() {
			core.unregisterAnimationFrame(name);
			core.deleteCanvas(name);
			lastTime = -1;
		}
	}
	window.dljgs1 = window.dljgs1 || {};
	dljgs1['effect'] = {};
	this.registerCanvasEffect = function(name, func, defaultConfig){
		dljgs1['effect'][name] = new canvasEffect(name, func, defaultConfig);
	}


	// --- 注册特效

	// 信号失真效果
	this.registerCanvasEffect('signal',
		function(signalConfig){
			var name = 'signal';
			core.clearMap(name);
			var randomRectDraw = function(img){
				var ctx = core.canvasPrepare();
				var num = signalConfig.num;
				while(num--){
					var x = randomNum(signalConfig.xRange), y = randomNum(signalConfig.yRange);
					var w = randomNum(signalConfig.width), h = randomNum(signalConfig.height);
					var mx = randomNum(signalConfig.xMove), my = randomNum(signalConfig.yMove);
					ctx.drawImage(img, x, y, w, h, x+mx, y+my, w, h);
				}
				return ctx;
			}
			var mask = core.maskPrepare();
			var ctx = randomRectDraw(mask.canvas);
			//var c = core.createCanvas('mask',0,0,core.__PIXELS__,core.__PIXELS__,signalConfig.prior);
			//c.canvas.style.opacity = signalConfig.alpha;
			core.drawImage(name, ctx.canvas, 0, 0);
		},{
			'num': 50,
			'freq':50,
			'prior': 150,
			'xMove': [-30,30],
			'yMove': [-5,5],
			'xRange': [-30,380],
			'yRange': [0,380],
			'width': [40,200],
			'height': [1,28],
			'alpha': 1.0,
		}
	);
	// 电波屏幕效果
	this.registerCanvasEffect('screen',
		function(){
			var curScreen = 0;
			var curBias = 0;
			return function(screenConfig){
				var name = 'screen';
				core.setAlpha(name, screenConfig.alpha || 1.0);
				var y = curBias;
				core.clearMap(name);
				while(y<screenConfig.sh){
					var w = (y<curScreen + screenConfig.width*screenConfig.sep && y>=curScreen || (curScreen + screenConfig.width*screenConfig.sep >= screenConfig.sh && (y>=curScreen || y<(curScreen + screenConfig.width*screenConfig.sep) % screenConfig.sh))) ? 3:1;
					core.drawLine(name,0,y,screenConfig.sw,y,'0x000000',w);
					y += screenConfig.sep;
				}
				curScreen += screenConfig.speed*screenConfig.sep;
				curScreen %= screenConfig.sh;
				curBias += screenConfig.speed;
				curBias %= screenConfig.sep;
			}
		}(),{
			prior: 151,
			sep: 10,
			width: 6,
			speed: 2,
		}
	);
},

"commentNet": function(){
	// 获取与增加留言
	
	var tname = 'OriginRule';// 测试用

	this.getCommentInfo = function(callback){
		if(!callback)return;
		core.http('get','https://h5mota.com/games/info.php?type=comment&name='+tname,null, function(data){
			callback(eval(data));
		});
	}


	var uid2name = {};
	this.getUserName = function(uid, callback){
		if(uid2name[uid]) return callback(uid2name[uid]);
		core.http('get','https://h5mota.com/user/info.php?type=name&uid='+uid,null, function(data){
			uid2name[uid] = data;
			if(callback)callback(data);
		});
	}

	// 格式化为便于显示的形式
	this.formatComment = function(data){
		var lz = data.filter(function(it){return it.pid==0});
		var re = data.filter(function(it){return it.pid!=0});
		var ans = [];
		var lzs = {};
		lz.forEach(function(it){
			var d = {id:it.id, uid:it.username, content:it.comment, replys: []};
			ans.push(d);
			lzs[it.id] = d; 
		});
		re.forEach(function(it){
			if(lzs[it.pid]){
				lzs[it.pid].replys.push({uid:it.username, content:it.comment, replys: []});
			}
		});
		return ans;
	}


	function makeTag(floorId){
		if(floorId)
		return '#'+floorId+'#';
		else return '';
	}

	// 读取关于某一层的留言
	this.readFloorComment = function(floorId, callback){
		var tag = makeTag(floorId);
		core.getCommentInfo(
			function(data){
				data = data.filter(function(it){return it.comment.indexOf(tag)==0});
				data.forEach(function(it){it.comment = it.comment.substr(tag.length)});
				callback(data);
			}
		);
	}

	// 添加留言
	this.addComment = function(content, pid, tag, callback){
		var form = new FormData();
		form.append("comment", 1);
		form.append("pid", pid || 0);
		form.append("name", tname);
		form.append("content", makeTag(tag) + content);
		core.http('post','https://h5mota.com/score.php',form, callback);
	}


	// 事件专用：
	this.inputComment = function(hint, pid, tag){
		var callback = function (content) {
			if (content) {
				core.addComment(content, pid, tag, function () {
					core.makeCommentData(tag, function () {
						core.doAction();
					})
				});
			} else {
				core.doAction();
			}
		}
		core.authenticLogin(
			function (isLog) {
				if (isLog) {
					core.myprompt(hint, null, callback);
				} else {
					alert('请先在网站h5mota.com登录并在线进行游戏！');
					core.doAction();
				}
			}
		)
	}

	// 
	var srcData = null;
	var index = 0;
	var replyPage = 0;
	this.commentBoardInit = function(){
		index = 0;
		flags._reIndex = 0;
	}
	this.makeCommentData = function(tag, callback){
		var back = function(data){
			srcData = core.formatComment(data);
			if(callback)callback();
		};
		if(!tag){
			core.getCommentInfo(back);
		}else {
			core.readFloorComment(tag, back);
		}
	}
	this.getCurCommentData = function(){
		if(srcData){
			var data = srcData[index];
			if(!data){
				return false;
			}
			flags._pid = srcData[index].id;
			flags._uid = srcData[index].uid;
			flags._content = srcData[index].content;
			flags._content = flags._content.substr(0,100) + (flags._content.length > 100 ? '...': '');
			flags._replys = srcData[index].replys;
			flags._reIndex = flags._reIndex || 0;
			if(flags._content){
				return true;
			}
		}
		return false;
	}
	this.canTurnPage = function(dir){
		if(dir + index < 0 || dir + index >= (srcData||[]).length){
			return false;
		}
		return true;
	}
	this.turnPage = function(dir){
		index = core.utils.clamp(index+dir,0,(srcData||[]).length-1)
	}
	





	//////////////// ============ web ==============
	this.getCommentInfo = function(callback){
		if(!callback)return;
		core.http('get','https://h5mota.com/games/info.php?type=comment&name='+tname,null, function(data){
			callback(eval(data));
		});
	}

	// 认证
	this.authenticLogin = function(callback){
		if(callback)
		core.http('get','https://h5mota.com/user/info.php?type=auth',null, function(data){
			if(data=='true'){
				callback(true);
			}else{
				callback(false);
			}
		});
	}

},

}