# V2.0版本介绍

?> 目前版本**v2.6.2**，上次更新时间：* {docsify-updated} *

目前样板已经更新到V2.0版本以上，本章将对V2.0的一些内容进行介绍。

请确保已经看过前面的几个文档（2.0都有部分更新），前面已经描述过的东西这里将不再赘述。

也欢迎通过看B站的视频教程来具体了解2.0版本的使用方法。

## 目录结构的改变

在1.x中，所有数据和逻辑都是一体的，例如怪物数据和怪物伤害计算公式等等。这导致样板的版本更新时会十分不便。

在2.0中，我们将数据和逻辑进行了分离，拆分成了libs和project两个目录。

- libs目录为游戏核心库文件，包括一些游戏逻辑等内容
- project目录为针对每个塔的目录，是和游戏逻辑是分离的。

我们只需要修改project目录下的各项内容，而无需去动libs目录（有特殊需求除外）；
将来如果想把塔迁移到新的版本上，也只需要迁移project即可。

另外一点的就是，我们将libs目录中的core.js进行了拆分，从而使每个文件的具体工作更加一目了然，也避免了接近6K行的大文件会导致打开IDE的卡顿问题。

## 全GUI造塔

在1.X版本中，我们提供了一个地图编辑器。但是它的功能十分弱，只能进行绘图的功能，实际的各项操作还是需要通过VSCode打开js文件实际进行编写代码。

但是在2.0中，我们大大拓展了地图编辑器的功能，从而达到了“全GUI造塔”的功能，用户再也不用手动打开任何一个文件进行编辑了。

GUI界面分为`地图编辑器`，`事件编辑器`和`文本编辑器`。

!> 即使现在可以全GUI造塔，也强烈建议对1.X的造塔方式进行了解，因为这是一切的基础。

### 地图编辑器

地图编辑器分为三个区域，左侧的`编辑区`,中间的`画布区`,右侧的`素材区`。

画布区下方有切换地图和编辑器模式的下拉菜单,点击`保存地图`后画布的内容才会真正写入到js文件中。

在素材区点击图块时，会选中该图块，此时tips会显示该图块的信息，编辑区会进入图块属性模式，怪物或物品可以直接在里面编辑数值。如果图块的数字和ID没有被定义，则可以直接在左侧定义，**定义新图块后需要保存并刷新页面后才能生效**。

在tips中有图块信息时，在画布上点击或拖拽可以把图块画上去，可以使用ctrl+Z撤销操作以及对应的ctrl+Y恢复撤销。擦除方块可以使用素材区最左上角的擦除块。

点击界面中的空白，tips中的图块信息会被清空，此时再点击画布上的点，则编辑器会进入地图选点模式。此模式下可以编辑改点的`events`,`afterBattle`,`changeFloor`等事件或者是`canMove`来改变各方向的通行状态。

切换地图会使编辑区进入楼层属性模式，这里可以修改首次到达该楼层时会触发的事件`firstArrive`，楼层显示的名称，默认的前景背景图片，默认天气和色调等等。

!> 这里不允许编辑楼层的ID，需要修改ID的场合请直接改js文件，并保持三个标识符完全一致。`data.js`中的`floorIds`也需要对应进行修改。

全塔属性中编辑整个塔为单位的属性，例如起始剧情`startText`，`name`，提供哪些难度，主角的起始属性，全局商店，各种数值以及系统FLAG等。**创建新塔时需要认真编辑这里面的所有选项。**

脚本编辑模式可以修改常用的需要更改的函数。例如，给不同的难度设置不同的内容`setInitData`，加点`addPoint`，以及修改游戏中的关于界面`drawAbout`等等。

追加素材模式可以导入一个图片到该标签的画板中，然后依次点击画板中的图块，点追加就可以按顺序把这些图片添加到对应的画布区素材的最下方，**需要刷新来生效**。

地图编辑模式中可以导入来自地图生成器的地图数组，同时创建新楼层需要在这里通过另存为来实现，可以点清除地图把另存为出的新楼层清空。

!> 编辑区的表格可以直接修改，推荐通过双击，在事件编辑器和文本编辑器中进行编辑。编辑区中的修改需要点保存才会生效。

### 事件编辑器

地图选点中的事件类表格，以及楼层属性中的`firstArrive`和全塔属性的`startText`，在双击时会进入事件编辑器，是由[antlr-blockly](https://github.com/zhaouv/antlr-blockly)生成的图块式的可视化编辑器.

把左侧的方块拖到面板中，下方就会实时的显示对应的js的代码(以及数值不正确时的提示).

每个方块点击右键会展开一个菜单，点帮助可以跳转到此文档中对应的内容。利用好复制功能可以极大提高编辑的效率。注释选项请不要使用，编辑器并不会保留这里的注释。

`template`中提供了一些模板事件，例如战前剧情，打怪开门。

`显示文章`的两个方块，以及`自动剧情文本`，`选项`和`自定义JS脚本`这5个方块，可以通过双击在文本编辑器中(以多行的方式)编辑其中的文字。

### 文本编辑器

事件编辑器之外的内容双击后由文本编辑器来编辑，是有js高亮支持的多行文本编辑器[CodeMirror](https://github.com/codemirror/CodeMirror)，点confirm即可使编辑的文本替换到表格中。

### 拓展地图编辑器

> 面向有一定编程基础的用户

修改`_server/`下的`*comment.js`可以让地图编辑器对自己添加的属性有更好的支持.例如:
+ 给`comment.js`中`enemys`加入新的键值对,就可以更方便的给怪物在UI界面中添加对应的值.
+ 在`data.comment.js`中把自己添加的内容标记为叶节点,不再在表格中展开到最末端.

地图编辑器的部分API见`_server/README.md`

## 部分事件和API更新

在2.0中，有部分的事件和API存在更新，也增加了包括48x32素材的支持，在这里将不再赘述，请仔细阅读前面的几个文档进行了解。
