var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}

	//////////////////////////重 写/////////////////////////
	var drawFg = core.maps.drawFg;

	// 画线
	var drawLine = function(ctx,sx,sy,dx,dy){
		ctx.beginPath();
		ctx.moveTo(sx*32,sy*32);
		ctx.lineTo(dx*32,dy*32);
		ctx.stroke();
		ctx.closePath();
	}
	core.maps.drawFg = function (floorId, ctx) {
		drawFg.call(core.maps, floorId, ctx);
		floorId = floorId || core.status.floorId;
		var onMap = ctx == null;
		if (onMap) ctx = core.canvas.fg;
		var line = core.floors[floorId].line;
		if(line){
			ctx.fillStyle = '#FFD700';
			ctx.strokeStyle = '#FFD700';
			ctx.lineWidth = 3;
			line.x = line.x || [];
			line.y = line.y || [];
			line.x.forEach(function(it){
				drawLine(ctx,it[0],it[1],it[0],it[2]);
			});
			line.y.forEach(function(it){
				drawLine(ctx,it[1],it[0],it[2],it[0]);
			});
		}
	}

	this.symetricInfo = function(floorId){
		floorId = floorId || core.status.floorId;
		var line = core.status.maps[floorId].line;
		if(!line)return true;
		line.x = line.x || [];
		line.y = line.y || [];
		var array = core.maps._getMapArrayFromBlocks(floorId);
		var ret = [];
		var judgePos = function(pos,dim){
			var l = line[dim];
			var vdim = dim =='x'?'y':'x';
			var retpos = [];
			for(var i in l){
				var c = l[i][0],st = l[i][1],ed = l[i][2];
				var vpos = {'x':parseInt(pos.x)+0,'y':parseInt(pos.y)+0,'type':1};
				vpos[dim] = c*2 - pos[dim] - 1;
				if(st <= vpos[vdim] && vpos[vdim] < ed && vpos[dim] >= 0 && vpos[dim]<core.__SIZE__){ // in range
					var id = array[pos.y][pos.x];
					if(array[vpos.y][vpos.x]==0 && id>0){
						array[vpos.y][vpos.x] -= 2;
						if(id>20 && id<300){//不可消除:1 ; 可消除:2 优先级没有不可消除高
							array[vpos.y][vpos.x] = Math.max(-2,array[vpos.y][vpos.x]);
						}else{
							array[vpos.y][vpos.x] = Math.max(-1,array[vpos.y][vpos.x]);;
						}
						retpos.push(vpos);
					}
				}
			}
			return retpos;
		}
		for(var x = 0;x<core.__SIZE__;x++){
			for(var y = 0;y<core.__SIZE__;y++){
				var pos = {'x':x,'y':y};
				var lst = judgePos(pos,'x').concat(judgePos(pos,'y'));
				ret = ret.concat(lst);
			}
		}
		ret.forEach(function(pt){
			pt.type = -array[pt.y][pt.x];
		});
		return ret;
	}

	this.getSymetricPoints = function(x,y,floorId){
		floorId = floorId || core.status.floorId;
		var line = core.status.maps[floorId].line;
		if(!line)return true;
		line.x = line.x || [];
		line.y = line.y || [];
		var set = {};
		var pos = {'x':x,'y':y};
		var getPos = function(pos,dim){
			var l = line[dim];
			var vdim = dim =='x'?'y':'x';
			for(var i in l){
				var c = l[i][0],st = l[i][1],ed = l[i][2];
				var vpos = {'x':parseInt(pos.x)+0,'y':parseInt(pos.y)+0};
				vpos[dim] = c*2 - pos[dim] - 1;
				if(st <= vpos[vdim] && vpos[vdim] < ed && vpos[dim] >= 0 && vpos[dim]<core.__SIZE__){ // in range
					set[vpos.x+','+vpos.y]=1;
				}
			}
		}
		getPos(pos,'x');
		getPos(pos,'y');
		var ret = [];
		Object.keys(set).forEach(function(s){
			lst = s.split(',');
			ret.push([parseInt(lst[0]),parseInt(lst[1])]);
		});
		return ret;
	}

	this.drawBlockInfo = function(info, canvas, clear){
		canvas = canvas || 'ui';
		if(clear)core.clearMap(canvas);
		core.setAlpha(canvas, 0.5);
		var color = ['#ebebeb','#ebebeb','#eed700']
		info.forEach(function(it){
			var x = it.x, y = it.y;
			core.fillRect(canvas, x*32, y*32, 32, 32, color[it.type]);	
		});
		core.setAlpha(canvas, 1);
		
	}
	//// 
	this.checkSymmetric = function(){
		var info = core.symetricInfo();
		if(info.length==0){
			core.insertAction([{"type": "insert", "loc": [0,0], "floorId": "ET"},]);
		} else return info;
	}

	var idnum = 312;
	this.useBrick = function(){
		var x = core.getHeroLoc('x'), y = core.getHeroLoc('y');
		var block = core.getBlock(x, y);
		if (block == null){
			core.setBlock(idnum,x,y);
			core.playSound("put.ogg");
			core.checkSymmetric();
			return true;
		}
		return false;
	}
	core.events.getNextItem = function (noRoute) {
		if (core.isMoving() ||  !core.flags.enableGentleClick) return false;
		if (!noRoute) core.status.route.push("getNext");
		var x = core.getHeroLoc('x'), y = core.getHeroLoc('y');
		var block = core.getBlock(x, y);
		if(block && block.block.id==idnum){
			core.removeBlock(x,y);
			core.getItem('brick',1);
		}else{
			if(core.canUseItem('brick')){
				core.useBrick();
				core.removeItem('brick');
			}else{
				core.drawTip("砖块不够！");
			}
		}
		return true;
	}

	core.useFly = function(e){
		core.drawBlockInfo(core.symetricInfo(core.status.floorId), 'hero', false);
		//if(core.getFlag('useFly',false)==false){
		//	core.setFlag('useFly',true);
		//}else{
		//	core.drawHero();
		//	core.setFlag('useFly',false);
		//}
		//setTimeout(function() {
		//	core.clearMap('data');
		//}, 1000);
	}

	core.registerSystemEvent('custom', function(data, callback){
		core.insertAction([
			{"type": "insert", "loc": [data.x,data.y], "floorId": "ET"},
		  ],data.x,data.y);
	})

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
}
}