var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "monsterBox": function () {
	this.openMonsterbox = function (fromUserAction) {
		if (core.isReplaying()) return;
		if (!core.events._checkStatus('monster', fromUserAction)) return;
		core.ui.drawMonsterbox();
	};

	core.openEquipbox = function (fromUserAction) {
		return core.openMonsterbox(fromUserAction);
	};

	core.items._resetItems = function () {
		return;
	};

	core.events.pushBox = function (data) {
		if (data.event.id != 'box' && data.event.id != 'boxed') return;

		// 判断还能否前进，看看是否存在事件
		var direction = core.getHeroLoc('direction'),
			nx = data.x + core.utils.scan[direction].x,
			ny = data.y + core.utils.scan[direction].y;

		// 检测能否推上去
		if (!core.canMoveHero() || !core.canMoveHero(data.x, data.y, direction)) return;
		var nextId = core.getBlockId(nx, ny);
		if (nextId != null && nextId != 'flower' && nextId != 'darkLight') return;

		if (nextId == 'darkLight') core.removeBlock(nx, ny);
		else core.setBlock(nextId == null ? 169 : 170, nx, ny);

		if (data.event.id == 'box')
			core.removeBlock(data.x, data.y);
		else
			core.setBlock(168, data.x, data.y);

		core.updateStatusBar();
		this._pushBox_moveHero(direction);
	}

	////// 绘制技能界面 //////
	core.ui.drawMonsterbox = function (index) {
		// 设定eventdata
		if (!core.isset(core.status.event.data) || !core.isset(core.status.event.data.page))
			core.status.event.data = { "page": 1, "selectId": null };

		// 获取物品列表
		var equips = core.getFlag('monsterArray');

		// 处理页数
		var page = core.status.event.data.page;
		var totalPage = Math.ceil(equips.length / 12);

		// 处理index
		if (!core.isset(index)) {
			index = 0;
		}
		core.status.event.selection = index;

		// 确认选择对象
		var select;
		var selectId;
		select = index + (page - 1) * 6;
		if (select >= equips.length) select = Math.max(0, equips.length - 1);
		selectId = equips[select];
		core.status.event.data.selectId = selectId;

		// 绘制
		core.clearMap('ui');
		core.setAlpha('ui', 0.85);
		core.fillRect('ui', 0, 0, 416, 416, '#000000');
		core.setAlpha('ui', 1);
		core.setFillStyle('ui', '#DDDDDD');
		core.setStrokeStyle('ui', '#DDDDDD');
		core.canvas.ui.lineWidth = 2;
		core.canvas.ui.strokeWidth = 2;

		var ydelta = 20;

		// 画线
		core.canvas.ui.beginPath();
		core.canvas.ui.moveTo(0, 270 - ydelta);
		core.canvas.ui.lineTo(416, 270 - ydelta);
		core.canvas.ui.stroke();

		// 文字
		var globalFont = core.status.globalAttribute.font;
		core.setTextAlign('ui', 'left');

		// 描述
		if (core.isset(selectId)) {
			var item = core.enemys.enemys[selectId];
			var order = selectId.substring(selectId.length - 1, selectId.length);

			core.fillText('ui', item.name, 10, 32, '#FFD700', "bold 20px " + globalFont);
			var curr = 62;
			var line_height = 27;

			/*var text = item.name;
			var lines = core.splitLines('ui', text, 465 - 32 * 2, '17px ' + globalFont);
			for (var i = 0; i < lines.length; i++) {
				core.fillText('ui', lines[i], 10, curr, '#FFFFFF', '17px ' + globalFont);
				curr += line_height;
			}*/

			var color = '#FFFFFF';
			var msg = '生命：' + (core.getFlag('standardAtk') + core.getFlag('extraAtk_' + core.status.event.data.selectId) + core.getFlag('standardDef') + core.getFlag('extraDef_' + core.status.event.data.selectId)) * core.getFlag('hpTimes');
			lines = core.splitLines('ui', msg, 465 - 32 * 2, '17px ' + globalFont);
			for (var i = 0; i < lines.length; i++) {
				core.fillText('ui', lines[i], 10, curr, color, '17px ' + globalFont);
				curr += line_height;
			}

			var msg = '攻击：' + (core.getFlag('standardAtk') + core.getFlag('extraAtk_' + core.status.event.data.selectId)) + '(+' + core.getFlag('extraAtk_' + core.status.event.data.selectId) + ')';
			lines = core.splitLines('ui', msg, 465 - 32 * 2, '17px ' + globalFont);
			for (var i = 0; i < lines.length; i++) {
				core.fillText('ui', lines[i], 10, curr, color, '17px ' + globalFont);
				curr += line_height;
			}

			var msg = '防御：' + (core.getFlag('standardDef') + core.getFlag('extraDef_' + core.status.event.data.selectId)) + '(+' + core.getFlag('extraDef_' + core.status.event.data.selectId) + ')';
			lines = core.splitLines('ui', msg, 465 - 32 * 2, '17px ' + globalFont);
			for (var i = 0; i < lines.length; i++) {
				core.fillText('ui', lines[i], 10, curr, color, '17px ' + globalFont);
				curr += line_height;
			}

			core.material.enemys.slimelord.hp = (core.getFlag('standardAtk') + core.getFlag('extraAtk_' + core.status.event.data.selectId) + core.getFlag('standardDef') + core.getFlag('extraDef_' + core.status.event.data.selectId)) * core.getFlag('hpTimes');
			core.material.enemys.slimelord.atk = core.getFlag('standardAtk') + core.getFlag('extraAtk_' + core.status.event.data.selectId);
			core.material.enemys.slimelord.def = core.getFlag('standardDef') + core.getFlag('extraDef_' + core.status.event.data.selectId);

			var damage = core.getDamage('slimelord')
			var msg = '伤害：' + (damage == null ? "???" : damage);
			lines = core.splitLines('ui', msg, 465 - 32 * 2, '17px ' + globalFont);
			for (var i = 0; i < lines.length; i++) {
				core.fillText('ui', lines[i], 10, curr, color, '17px ' + globalFont);
				curr += line_height;
			}

			var msg = '临界，减伤：' + core.nextCriticals('slimelord');
			lines = core.splitLines('ui', msg, 465 - 32 * 2, '17px ' + globalFont);
			for (var i = 0; i < lines.length; i++) {
				core.fillText('ui', lines[i], 10, curr, color, '17px ' + globalFont);
				curr += line_height;
			}

			var msg = '当前分数：' + core.status.hero.money;
			lines = core.splitLines('ui', msg, 465 - 32 * 2, '17px ' + globalFont);
			for (var i = 0; i < lines.length; i++) {
				core.fillText('ui', lines[i], 10, curr, color, '17px ' + globalFont);
				curr += line_height;
			}

			var msg = '快捷键：减攻Q/加攻W/减防A/加防S/确认ENTER';
			lines = core.splitLines('ui', msg, 465 - 32 * 2, '17px ' + globalFont);
			for (var i = 0; i < lines.length; i++) {
				core.fillText('ui', lines[i], 10, curr, color, '17px ' + globalFont);
				curr += line_height;
			}
		} else {
			var curr = 62;
			var line_height = 27;

			var msg = '基准攻击：' + core.getFlag('standardAtk');
			lines = core.splitLines('ui', msg, 465 - 32 * 2, '17px ' + globalFont);
			for (var i = 0; i < lines.length; i++) {
				core.fillText('ui', lines[i], 10, curr, color, '17px ' + globalFont);
				curr += line_height;
			}

			var msg = '基准防御：' + core.getFlag('standardDef');
			lines = core.splitLines('ui', msg, 465 - 32 * 2, '17px ' + globalFont);
			for (var i = 0; i < lines.length; i++) {
				core.fillText('ui', lines[i], 10, curr, color, '17px ' + globalFont);
				curr += line_height;
			}

			var msg = '当前分数：' + core.status.hero.money;
			lines = core.splitLines('ui', msg, 465 - 32 * 2, '17px ' + globalFont);
			for (var i = 0; i < lines.length; i++) {
				core.fillText('ui', lines[i], 10, curr, color, '17px ' + globalFont);
				curr += line_height;
			}
		}

		core.setTextAlign('ui', 'right');
		var images = core.material.images.enemys;

		// 道具
		for (var i = 0; i < equips.length; i++) {
			var tool = equips[equips.length * (page - 1) + i];
			if (!core.isset(tool)) break;
			var yoffset = 284 + Math.floor(i / 6) * 54 + 5 - ydelta;
			var icon = core.material.icons.enemys[tool];
			core.drawImage('ui', images, 0, icon * 32, 32, 32, 16 * (4 * (i % 6) + 1) + 5, yoffset, 32, 32);
			// 个数
			if (selectId == tool)
				core.strokeRect('ui', 16 * (4 * (i % 6) + 1) + 1, yoffset - 4, 40, 40, '#FFD700');
		}

		// 分页
		this.drawPagination(page, totalPage);

		// 退出按钮
		core.fillText('ui', '返回游戏', 390, 400, '#DDDDDD', 'bold 15px ' + globalFont);

		if (core.status.event.data.selectId) {
			core.myShowImage('left', 5, 2);
			core.myShowImage('left', 5, 3);
			core.myShowImage('right', 6, 2);
			core.myShowImage('right', 6, 3);
			core.myShowImage('fly', 11, 1);
		}
	};

	////// 技能界面的点击操作 //////
	this.clickMonsterbox = function (x, y) {
		// 返回
		if (x >= 10 && x <= 12 && y == 12) {
			core.ui.closePanel();
			return;
		}
		if (core.status.event.data.selectId) {
			if (x == 5 && y == 2) {
				if (eval(core.items.canUseItemEffect['decAtkId_' + core.status.event.data.selectId])) {
					eval(core.items.useItemEffect['decAtkId_' + core.status.event.data.selectId]);
				}
				core.ui.drawMonsterbox(core.status.event.selection);
				return;
			}
			if (x == 6 && y == 2) {
				if (eval(core.items.canUseItemEffect['incAtkId_' + core.status.event.data.selectId])) {
					eval(core.items.useItemEffect['incAtkId_' + core.status.event.data.selectId]);
				}
				core.ui.drawMonsterbox(core.status.event.selection);
				return;
			}
			if (x == 5 && y == 3) {
				if (eval(core.items.canUseItemEffect['decDefId_' + core.status.event.data.selectId])) {
					eval(core.items.useItemEffect['decDefId_' + core.status.event.data.selectId]);
				}
				core.ui.drawMonsterbox(core.status.event.selection);
				return;
			}
			if (x == 6 && y == 3) {
				if (eval(core.items.canUseItemEffect['incDefId_' + core.status.event.data.selectId])) {
					eval(core.items.useItemEffect['incDefId_' + core.status.event.data.selectId]);
				}
				core.ui.drawMonsterbox(core.status.event.selection);
				return;
			}
			if (x == 11 && y == 1) {
				core.tryUseItem('ok_' + core.status.event.data.selectId);
				return;
			}
		}
		var index = parseInt(x / 2);
		if (y == 8 || y == 9) index += 0;
		else if (y == 10 || y == 11) index += 6;
		else index = -1;
		if (index >= 0) {
			core.clickMonsterIndex(index);
		}
	};

	////// 选择技能界面中某个Index后的操作 //////
	this.clickMonsterIndex = function (index) {
		var items = core.getFlag('monsterArray');;
		var select;
		select = index + 12 * (core.status.event.data.page - 1);
		var equips = core.getFlag('monsterArray');

		if (items == null) return;
		if (select >= items.length) return;
		var itemId = items[select];
		if (itemId == core.status.event.data.selectId) {
			//core.events.tryUseItem(itemId);
		} else {
			core.ui.drawMonsterbox(index);
		}
	};

	////// 选择技能界面时，按下某个键的操作 //////
	this.keyDownMonsterbox = function (keycode) {
		if (core.status.event.data == null) return;

		var equips = core.getFlag('monsterArray');
		var index = core.status.event.selection;
		var page = core.status.event.data.page - 1;

		var order = page * 12 + index;
		if (order < 0) order = 0;
		if (order > equips.length - 1) order = equips.length - 1;
		var oldOlder = order;
		if (keycode == 37) { //left
			order--;
		}
		if (keycode == 38) { //up
			order -= 6;
		}
		if (keycode == 39) { //right
			order++;
		}
		if (keycode == 40) { //down
			order += 6;
		}
		if (order < 0) order = 0;
		if (order > equips.length - 1) order = equips.length - 1;
		if (order == oldOlder) return;
		core.status.event.data.page = Math.floor(order / 12) + 1;
		index = order % 12;
		this.clickMonsterIndex(index);
	};

	////// 选择技能界面时，放开某个键的操作 //////
	this.keyUpMonsterbox = function (keycode, altKey) {
		if (keycode == 27 || keycode == 88) {
			core.ui.closePanel();
			return;
		}
		if (!core.status.event.data.selectId) return;
		if (keycode == 13 || keycode == 32 || keycode == 67) {
			//this.clickMonsterIndex(core.status.event.selection);
			core.tryUseItem('ok_' + core.status.event.data.selectId);
			return;
		}
		if (keycode == 81) {
			if (eval(core.items.canUseItemEffect['decAtkId_' + core.status.event.data.selectId])) {
				eval(core.items.useItemEffect['decAtkId_' + core.status.event.data.selectId]);
			}
			core.ui.drawMonsterbox(core.status.event.selection);
			return;
		}
		if (keycode == 87) {
			if (eval(core.items.canUseItemEffect['incAtkId_' + core.status.event.data.selectId])) {
				eval(core.items.useItemEffect['incAtkId_' + core.status.event.data.selectId]);
			}
			core.ui.drawMonsterbox(core.status.event.selection);
			return;
		}
		if (keycode == 65) {
			if (eval(core.items.canUseItemEffect['decDefId_' + core.status.event.data.selectId])) {
				eval(core.items.useItemEffect['decDefId_' + core.status.event.data.selectId]);
			}
			core.ui.drawMonsterbox(core.status.event.selection);
			return;
		}
		if (keycode == 83) {
			if (eval(core.items.canUseItemEffect['incDefId_' + core.status.event.data.selectId])) {
				eval(core.items.useItemEffect['incDefId_' + core.status.event.data.selectId]);
			}
			core.ui.drawMonsterbox(core.status.event.selection);
			return;
		}
	};

	//以下为注册事件
	var _plugin_onclick_lockControl = function (x, y) {
		if (!core.status.lockControl) return false;
		switch (core.status.event.id) {
		case 'monster':
			core.clickMonsterbox(x, y);
			return true;
		}
		return false;
	};

	var _plugin_keyDown_lockControl = function (keyCode) {
		if (!core.status.lockControl) return false;
		switch (core.status.event.id) {
		case 'monster':
			core.keyDownMonsterbox(keyCode);
			return true;
		}
		return false;
	};

	var _plugin_keyUp_lockControl = function (keyCode, altKey) {
		if (!core.status.lockControl) return false;
		switch (core.status.event.id) {
		case 'monster':
			core.status.holdingKeys = [];
			core.keyUpMonsterbox(keyCode, altKey);
			return true;
		}
		return false;
	};

	this.plugin_onclick_lockControl = _plugin_onclick_lockControl;
	core.registerAction('onclick', 'plugin_onclick_lockControl', _plugin_onclick_lockControl, 51);
	this.plugin_keyDown_lockControl = _plugin_keyDown_lockControl;
	core.registerAction('keyDown', 'plugin_keyDown_lockControl', _plugin_keyDown_lockControl, 51);
	this.plugin_keyUp_lockControl = _plugin_keyUp_lockControl;
	core.registerAction('keyUp', 'plugin_keyUp_lockControl', _plugin_keyUp_lockControl, 51);
},
    "myShowImage": function () {
	// 在此增加新插件
	this.myShowImage = function (id, x, y, px, py) {
		x = x || 0;
		y = y || 0;
		px = px || 0;
		py = py || 0;
		var ix = x * 32 + px;
		var iy = y * 32 + py;
		var image;
		var icon;
		if (id == 0 || id == "ground") {
			image = core.material.images.terrains;
			icon = 10;
		} else if (core.isset(core.maps.blocksInfo[id])) {
			image = core.material.images[core.maps.blocksInfo[id].cls];
			icon = core.material.icons[core.maps.blocksInfo[id].cls][core.maps.blocksInfo[id].id];
			if (core.isset(image.autotile4)) image = image.autotile4;
		} else {
			for (var i in core.maps.blocksInfo) {
				if (core.maps.blocksInfo[i].id == id) {
					arguments.callee(i, x, y, px, py);
					return;
				}
			}
		}
		core.drawImage('ui', image, 0, icon * 32, 32, 32, ix, iy, 32, 32);
	};

	//批量注册道具
	this.initTools = function () {
		for (var i = 1; i < 3; i++) {
			for (var j in core.getFlag('monsterArray' + i)) {
				var monsterId = core.getFlag('monsterArray' + i)[j];
				var incAtkId = 'incAtkId_' + monsterId;
				var incDefId = 'incDefId_' + monsterId;
				var decAtkId = 'decAtkId_' + monsterId;
				var decDefId = 'decDefId_' + monsterId;
				var okId = 'ok_' + monsterId;
				core.material.items[incAtkId] = {};
				core.material.items[incDefId] = {};
				core.material.items[decAtkId] = {};
				core.material.items[decDefId] = {};
				core.material.items[okId] = {};
				core.material.items[incAtkId].cls = "keys";
				core.material.items[incDefId].cls = "keys";
				core.material.items[decAtkId].cls = "keys";
				core.material.items[decDefId].cls = "keys";
				core.material.items[okId].cls = "keys";
				core.material.items[incAtkId].hideInReplay = true;
				core.material.items[incDefId].hideInReplay = true;
				core.material.items[decAtkId].hideInReplay = true;
				core.material.items[decDefId].hideInReplay = true;
				core.material.items[okId].hideInReplay = true;
				core.items.canUseItemEffect[incAtkId] = '!!' + core.canUseIncAtk.toString() + '("' + monsterId + '")';
				core.items.useItemEffect[incAtkId] = '!!' + core.useIncAtk.toString() + '("' + monsterId + '")';
				core.items.canUseItemEffect[incDefId] = '!!' + core.canUseIncDef.toString() + '("' + monsterId + '")';
				core.items.useItemEffect[incDefId] = '!!' + core.useIncDef.toString() + '("' + monsterId + '")';
				core.items.canUseItemEffect[decAtkId] = '!!' + core.canUseDecAtk.toString() + '("' + monsterId + '")';
				core.items.useItemEffect[decAtkId] = '!!' + core.useDecAtk.toString() + '("' + monsterId + '")';
				core.items.canUseItemEffect[decDefId] = '!!' + core.canUseDecDef.toString() + '("' + monsterId + '")';
				core.items.useItemEffect[decDefId] = '!!' + core.useDecDef.toString() + '("' + monsterId + '")';
				core.items.canUseItemEffect[okId] = '!!' + core.canUseOK.toString() + '("' + monsterId + '")';
				core.items.useItemEffect[okId] = '!!' + core.useOK.toString() + '("' + monsterId + '")';
				if (!core.hasItem(incAtkId)) core.addItem(incAtkId);
				if (!core.hasItem(incDefId)) core.addItem(incDefId);
				if (!core.hasItem(decAtkId)) core.addItem(decAtkId);
				if (!core.hasItem(decDefId)) core.addItem(decDefId);
				if (!core.hasItem(okId)) core.addItem(okId);
				core.status.hero.flags['extraAtk_' + monsterId] = core.status.hero.flags['extraAtk_' + monsterId] || 0;
				core.status.hero.flags['extraDef_' + monsterId] = core.status.hero.flags['extraDef_' + monsterId] || 0;
				core.status.hero.flags['ok_' + monsterId] = core.status.hero.flags['ok_' + monsterId] || 0;
				core.status.hero.flags['finalAtk_' + monsterId] = core.status.hero.flags['finalAtk_' + monsterId] || 0;
				core.status.hero.flags['finalDef_' + monsterId] = core.status.hero.flags['finalDef_' + monsterId] || 0;
			}
		}
	};

	this.canUseIncAtk = function (monsterId) {
		return core.getFlag('extraAtk_' + monsterId) < 99;
	};

	this.canUseIncDef = function (monsterId) {
		var atk = core.getFlag('standardAtk') + core.getFlag('extraAtk_' + monsterId);
		var def = core.getFlag('standardDef') + core.getFlag('extraDef_' + monsterId);
		return def * 2 + 1 < atk;
	};

	this.canUseDecAtk = function (monsterId) {
		var extraAtk = core.getFlag('extraAtk_' + monsterId);
		var atk = core.getFlag('standardAtk') + core.getFlag('extraAtk_' + monsterId);
		var def = core.getFlag('standardDef') + core.getFlag('extraDef_' + monsterId);
		return extraAtk > 0 && atk > def * 2;
	};

	this.canUseDecDef = function (monsterId) {
		var extraDef = core.getFlag('extraDef_' + monsterId);
		return extraDef > 0;
	};

	this.canUseOK = function (monsterId) {
		return true;
	};

	this.useIncAtk = function (monsterId) {
		core.status.hero.flags['extraAtk_' + monsterId]++;
		if (!core.isReplaying()) core.status.route.push('item:incAtkId_' + monsterId);
	};

	this.useIncDef = function (monsterId) {
		core.status.hero.flags['extraDef_' + monsterId]++;
		if (!core.isReplaying()) core.status.route.push('item:incDefId_' + monsterId);
	};

	this.useDecAtk = function (monsterId) {
		core.status.hero.flags['extraAtk_' + monsterId]--;
		if (!core.isReplaying()) core.status.route.push('item:decAtkId_' + monsterId);
	};

	this.useDecDef = function (monsterId) {
		core.status.hero.flags['extraDef_' + monsterId]--;
		if (!core.isReplaying()) core.status.route.push('item:decDefId_' + monsterId);
	};

	this.useOK = function (monsterId) {
		core.status.hero.flags['ok_' + monsterId] = 1;
		core.status.hero.flags['finalAtk_' + monsterId] = core.status.hero.flags.standardAtk + core.status.hero.flags['extraAtk_' + monsterId];
		core.status.hero.flags['finalDef_' + monsterId] = core.status.hero.flags.standardDef + core.status.hero.flags['extraDef_' + monsterId];
		//core.status.hero.flags.point += (core.status.hero.flags.standardAtk + core.status.hero.flags['extraAtk_' + monsterId] + core.status.hero.flags.standardDef + core.status.hero.flags['extraDef_' + monsterId]) * core.getFlag('hpTimes');
		core.status.hero.flags.point += 1;
		core.status.hero.flags.monsterArray.splice(core.status.hero.flags.monsterArray.indexOf(monsterId), 1);
		core.status.hero.flags.standardAtk += 2 + core.status.hero.flags['extraAtk_' + monsterId];
		core.status.hero.flags.standardDef += 1 + core.status.hero.flags['extraDef_' + monsterId];
	};
}
}