var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {
	// 在这里写的代码，在所有模块加载完毕后，游戏开始前会被执行
	console.log("插件编写测试");

	// 可以写一些其他的被直接执行的代码


	this.test = function () {
		console.log("插件函数执行测试");
		console.log(this);
	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}


	window.dljgs1 = {}

	// ======  组件？ ===========
	// 绑定显示和控制的画布 显示时绘制在UI上(不进存档)
	window.dljgs1.componentList = [];
	var componentCanvas = function(name,x,y,w,h,draw,actions,rootCanvas){
		var ctx = null;
		//console.log(name)
		//console.log(ctx)
		var pior=50;
		var isEnable = false;
		this.rootCanvas = rootCanvas || 'ui';
		this.children = [];
		
		this.flush = function(callback){
			var canvas = this.rootCanvas;
			var ct = this.children.length;
			var children = this.children;
			if(!isEnable){
				core.clearMap(canvas);
				return;
			}
			
			var tmp = function(){
				//console.log(name+'draw to :'+canvas+', '+x+','+y);
				if(canvas=='ui')core.clearMap('ui');//只有根画布才能清UI 根画布只有一个
				core.getContextByName(canvas).drawImage(ctx.canvas,x,y);
				if(callback)callback();
			}
			core.clearMap(name);
			draw(name,function(){
				if(ct==0)tmp();
				children.forEach(function(it){it.flush(function(){
					ct -= 1;
					if(ct==0)tmp();
				});});
				//
			});
		}

		this.resize = function(_x,_y,_w,_h){//重建画布
			if (main.replayChecking) return;
			_x = _x || x;
			_y = _y || y;
			_w = _w || w;
			_h = _h || h;
			var tmp = core.getContextByName(this.rootCanvas).canvas;
			
			if(_w>1.0){
				w = _w;h = _h;
			}else{
				w = parseInt(tmp.width*_w);
				h = parseInt(tmp.height*_h);
			}
			if(_x>1.0 || x==0){
				x = _x; y = _y; 
			}else{//根据指定的xywh比例自适应调控位置 _x_y指定画布中心相对于整个父画布的偏移 xy最终还是左上角
				var ox = tmp.width*_x, oy = tmp.height*_y;
				x = parseInt(ox - w/2);
				y = parseInt(oy - h/2);
			}
			ctx = core.createCanvas(name,x,y,w,h);
			//console.log("create "+name+","+ x+','+y+','+w+','+h);
			this.flush();
		}
		this.reMapAll = function(){//读档后重建所有画布
			this.resize();
			this.children.forEach(function(it){it.reMapAll()});
		}
		this.resize();
		
		var controlCon = function(){
			if(isEnable)core.lockControl();
			else core.unLockControl();
		}
		this.switchEnable = function(flag){//切换开关
			isEnable =  flag || !isEnable;
			if(!core.getContextByName(name)){
				console.log(name+'重建画布');
				this.reMapAll();
			}
			if(isEnable && this.rootCanvas=='ui'){//根画布才需要控制
				core.lockControl();
				dljgs1.objs.SLtree.tree.stash();
			}
			for(var a in actions){
				this.procRegister(a,actions[a]);
			}
			
			this.children.forEach(function(it){it.switchEnable(flag)});
			this.flush();
			if(!isEnable && this.rootCanvas=='ui'){
				core.ui.closePanel();
				dljgs1.objs.SLtree.tree.recover();
			}
		}
		this.procRegister = function(type, dofun, unReg){//注册与撤销
			var packFun = function(){if(isEnable)return dofun.apply(this,arguments)};
			var fun = packFun;
			if(isEnable){//首次启用时进行注册
				if(type=='ondown'){
					fun = function(_x,_y,px,py){
						if(px<x+w && px>x && py<y+h &&py>y){
							return packFun();
						}
					}
					//console.log('type'+type+','+x+','+y+','+w+','+h+' name:'+name);
				}
				core.registerAction(type,name,fun,pior);
			}else if(unReg){
				console('un reg : ' + unReg + '')
				core.unregisterAction(type,name)//不再注销 除非明示注销（通过遍历组件数组操作
			}	
		}
		this.appendComponent = function(comp){
			comp.rootCanvas = name;
			this.children.push(comp);
		}
	}
	window.dljgs1.registerComponent = function(name,rect,drawFlush,actionsFlush,parent){
		this.componentList = this.componentList || [];
		var name = name || ('cmp'+window.dljgs1.componentList.length);
		var tmp = new componentCanvas(name,rect[0],rect[1],rect[2],rect[3],drawFlush,actionsFlush,parent);
		this.componentList.push(tmp);
		return tmp;
	}
	window.dljgs1.unregisterComponent = function(name){
		window.dljgs1.componentList = window.dljgs1.componentList.filter(function(val,idx){
			return val.name != name;
		});
	}
	window.dljgs1.getComponent = function(name){
		for(var i in this.componentList){
			if(this.componentList[i].name == name)return this.componentList[i];
		}
	}
	// ====================树存档======================== 
	
	window.dljgs1.SLtree = function(){// 存档管理二叉树 
		var nodeDict = {};
		var node = function(id,last,top){
			this.cur = id;
			this.next = null;//下一个时间节点
			this.last = last;//上一个时间节点
			this.bottom = null;//下一个世界线(当前节点的相邻)
			this.top = top;//前一个世纪线
			nodeDict[id] = this;
			this.append = function(id){//添加新节点
				var newNode = new node(id);
				this.appendNode(newNode);
				return newNode;
			}
			this.appendNode = function(v){//往后添加一个新节点 如果有冲突 就产生分支
				if(!core.isset(v))return this;
				if(this.next==null){
					this.next = v;
					v.last = this;
				}else{//新的世界线插入——是后继的bottom
					this.next.branchNode(v);
				}
			}
			this.branch = function(id){//分支与当前结点是平级
				var newNode = new node(id);
				this.branchNode(newNode);
				return newNode;
			}
			this.branchNode = function(v){//分支新节点进来 原分支会被挤到下面去
				if(!core.isset(v))return this;
				var temp = this.bottom;
				// 插入：
				this.bottom = v;
				v.top = this;
				v.last = this.last;
				var bt = v;
				while(bt.bottom){
					bt = bt.bottom;
					bt.last = this.last;
				}//找到插入进来的最后一行
				bt.bottom = temp;
				if(temp){
					temp.top = bt;
				}
				return v;
			}
			this.flushLast = function(ptr){//刷新last
				this.last = ptr;
				if(this.bottom)this.bottom.flushLast(ptr);
			}
			this.remove = function(){
				console.log('remove: ' + this.cur);
				// 删除自己——如果是分叉点 这会导致当前后续时间线全部悬空(然后全部连接到父节点)
				// ——如果是单链 那么会直接合并（这是推荐的操作）
				if(this.bottom && this.next){//分叉点
					if(!this.top){//连接前后
						this.last.next = null;
						this.last.appendNode(this.next);
						this.next.branchNode(this.bottom);//把下家并入后继的下家 保持并行关系
					}
					else{//连接上下
						console.log('top - bottom')
						this.top.bottom = null;
						this.next.branchNode(this.bottom);
						this.top.branchNode(this.next);
					}
				}else{
					if(this.next){//下家悬空：单链 
						this.next.top = this.top;
						this.next.last = this.last;
						if(this.top)this.top.bottom = this.next;
						else this.last.next = this.next;
					}else if(this.top){//后继悬空：孤立三叉点
						this.top.bottom = this.bottom;
						//this.last.next = null;//!
					}else if(this.bottom){//后继悬空：孤立二叉点  
						this.last.next = this.bottom;
						this.bottom.top = null;
					}else{//独立悬空点
						this.last.next = null;
					}
				}
				// 最后排查 保证删干净了
				if(this.top && this.top.bottom != this){

				}
				return this;
			}
			this.backFind = function(id){//回溯查询id是否存在
				var temp = this;
				while(temp.last!=null){
					if(temp.cur == id){
						return temp;
					}
				}
			}

			/// 递归将所有节点数据取出（采用化为链或者三叉树的方式）
			this.toData = function(){
				var tmp = this;
				var ret = [this.cur];
				var keys = ['cur','next','bottom'];
				
				for(var i=1;i<3;i++){
					ret[i]=tmp[keys[i]]?tmp[keys[i]].toData():null;
				}
				return ret;
			}
			/// 从数据生成树
			this.fromData = function(data,last,top){
				if(!core.isset(data))return this;
				var root = new node(data[0],last,top);
				var keys = ['cur','next','bottom'];
				for(var i=1;i<3;i++){
					var k = keys[i];
					if(k=='next'){
						last = root;
						top = null;
					}else if(k=='bottom'){
						top = root;
						last = root.last;
					}
					if(data[i]){
						root[k] = root.fromData(data[i],last,top);
					}else{
						root[k] = null;
					}
				}
				return root;
			}
		}
		var root = new node(-1);// 所有新开的存档 都在根节点之下
		var curNode = root;
		
		// DATA IO
		this.saveSotrage = function(key){//存储到localForage里（不知道数据量大小）
			key = key || 'treeNodeDict';
			core.setLocalStorage(key,root.toData());
		}
		this.loadStorage = function(key){//初始化——只有游戏一开始执行一次 
			key = key || 'treeNodeDict';
			nodeDict = {};
			var data = core.getLocalStorage(key,{});
			if(data.length>0){
				root = root.fromData(data);
			}
			else{
				root = new node(-1);
			}
			curNode = root;//!zhoya
		}
		this.flushCurNode = function(){//保证curNode一定存在
			if(core.isset(core.saves.saveIndex)){
				curNode = nodeDict[core.saves.saveIndex] || root;
			}else{
				curNode = curNode || root;
			}
		}

		/////test
		this.getCur = function(){
			return curNode;
		}
		this.getDict = function(){
			return nodeDict;
		}
		// 重新开始游戏 或者初始化的时候：
		this.reset = function(){
			curNode = root;
		}
		
		//////与系统接轨：
		//暂存与恢复
		var tempCur = null;
		this.stash = function(){
			tempCur = curNode;
		}
		this.recover = function(){
			curNode = tempCur;
			tempCur = null;
		}
		//存储之前
		this.beforeSave = function(id){//新的时间点
			// 创建新的存档和覆盖旧存档是不一样的
			// 新存档只需判断是新的时间点还是世界线 
			// 覆盖需要判断被覆盖的节点是不是在当前世界线 如果是删除原节点 再补到最新
			this.beforeRemove(id);
			//if(nodeDict[id]){
				//nodeDict[id].remove();
			//}
			//this.flushCurNode();
			curNode = curNode.append(id);
			this.saveSotrage();
		}
		//读取之前
		this.afterLoad = function(id){
			if(nodeDict && nodeDict[id])
				curNode = nodeDict[id];
		}
		//删除存档前
		this.beforeRemove = function(id){
			if(nodeDict && nodeDict[id]){
				console.log('remove: '+id);
				var last = nodeDict[id].last;
				nodeDict[id].remove();
				if(!last)return;//试图删除根
				if(tempCur)//在存档树界面操作
				{
					curNode = last;
					if(tempCur.cur==id){//如果真实的当前ID被删除了 才需要去找下一个解盘的 而且是回到上一个节点
						console.log('cur node change: '+curNode.cur);
						this.stash();//更新存储的curNode
					}
				}else{//在系统界面操作
					if(curNode.cur == id){
						curNode = last;
					}
				}
				//else if(nodeDict[id].top)curNode = nodeDict[id].top;
				//else if(nodeDict[id].next)curNode = nodeDict[id].next;
				//else if(nodeDict[id].bottom)curNode = nodeDict[id].bottom;
				delete nodeDict[id];
				this.saveSotrage();
			}
		}

		//////组件相关///////
		// actions : 输入键 向接口返回是否关闭组件
		this.onkeyDown = function(dir){
			if(!curNode)return;
			if(dir=='cur')return this.onClick(dir);
			else if(curNode[dir]){
				curNode = curNode[dir];
				return false;
			}else if(dir=='del'){//删除操作
				core.control.removeSave(dljgs1.objs.SLtree.tree.getCur().cur,
				function(){
					dljgs1.objs.SLtree.comp.flush();
				});
				return false;
			}
		}
		this.onClick = function(dir){//说是onclick其实是ondown
			//console.log('click:'+dir);
			if(!curNode)return;
			var id = dir;
			if(dir=='cur'){
				core.doSL(curNode[dir],'load');
				return true;
			}
			else if(curNode[dir]){//// TODO:加特殊前置
				core.doSL(curNode[dir].cur,'load');
				return true;
			}else{//方向按钮
				var f = dir.split('_')[1];
				if(f=='back')return true;
				else this.onkeyDown(f);
				return false;
			}
		}
		this.draw = function(dir,callback){
			//console.log(curNode);
			if(!curNode){
				//console.log(dir+': no Node');
				return;}
			if(dir == 'treeBack'){//画背景
				core.setAlpha(dir, 0.85);
				core.drawImage(dir,'slbg.jpg',0,0);//,core.__PIXELS__,core.__PIXELS__
				core.setAlpha(dir, 1);
				if(callback)callback();
			}
			else if(curNode[dir]){//画存档
				if(!core.isset(dir))return;
				var id = dir=='cur'?curNode[dir]:curNode[dir].cur;
				var canvas = core.getContextByName(dir).canvas;
				core.getLocalForage("save"+id, null, function(data) {
					var w = canvas.width;
					var title = (((core.saves.favoriteName||{})[id]) || ('节点' + id));
					if(!id || id<0){
						title = '未知的起点';
						data = null;
					}
					core.ui._drawSLPanel_drawRecord(title,
							data,w/2,20,w/2,dir=='cur',null,dir,dir=='top');
					if(callback)callback();
				}, function(err) {main.log(err);});
			}else{//画箭头和按钮
				var f = dir.split('_')[1];
				if(!f){callback();return;}
				var txtChar = {'last':'←','next':'→','top':'↑','bottom':'↓','back':'返回','del':'删除'};
				var w = core.getContextByName(dir).canvas.width;
				core.setAlpha(dir, 0.2);
				core.setTextBaseline(dir, 'middle');
				core.setTextAlign(dir, 'center');
				if(curNode[f] || f=='back' || f=='del')core.setAlpha(dir, 1.0);
				core.setFont(dir, core.ui._buildFont(20, true));
				core.fillText(dir, txtChar[f], w/2, w/2, '#fff');
				if(callback)callback();
			}
		}
	}
	this.initTreeSL = function(){
		console.log("SL Tree 初始化...")
		var tree = new dljgs1.SLtree(); //TODO: 数据需要存储到localStorage 需要压缩
		////// 组件注册初始化
		// 背景（根）
		var treeBackComp = dljgs1.registerComponent(
			'treeBack',
			[0,0,core.__PIXELS__,core.__PIXELS__],
			tree.draw, {
				'onkeyUp':function(e){
					if(e.keyCode==27){
						console.log('esc');
						treeBackComp.switchEnable(false);
						treeBackComp.flush();
						core.rememberFlag(false);//清除记忆
						return true;
					}else if(e.keyCode==46){
						core.control.removeSave(tree.getCur().cur,
						function(){
							treeBackComp.flush();
						});
						return true;
					}
				}
			});

		//存档记录的点击与移动 键盘操作
		[
			['last',[1/6,1/2,1/3,1/3],37,],
			['cur',[1/2,1/2,1/2,1/2],32,],
			['next',[5/6,1/2,1/3,1/3],39,],
			['bottom',[1/2,5/6,1/3,1/3],40,],
			['top',[1/2,1/6,1/3,1/3],38,],
		].forEach(
			function(it){
				treeBackComp.appendComponent(dljgs1.registerComponent(
					it[0],it[1],
					tree.draw, {
						'ondown':function(){
							console.log('on down !!!');
							if(tree.onClick(it[0])){//读档
								//treeBackComp.reMapAll(); //remap的操作由全局调用
								treeBackComp.switchEnable(false);
							}
							treeBackComp.flush();
							return true;
						},
						'onkeyUp':function(e){
							if(e.keyCode==it[2]){
								console.log('key up');
								if(tree.onkeyDown(it[0])){
									//treeBackComp.reMapAll();//remap的操作由全局调用
									treeBackComp.switchEnable(false);
								}
								treeBackComp.flush();
								return true;
							}
						}
					},'treeBack'));//注册时注明其父类
			}
		);
		// 方向虚拟按钮与退出 触点操作
		[
			['go_last',[5/6-1/12,5/6,1/10,1/10]],
			['go_next',[5/6+1/12,5/6,1/10,1/10]],
			['go_top',[5/6,5/6-1/12,1/10,1/10]],
			['go_bottom',[5/6,5/6+1/12,1/10,1/10]],
			['go_back',[7/8,1/10,1/5,1/5]],
			['go_del',[1/10,9/10,1/10,1/10]]
		].forEach(
			function(it){
				treeBackComp.appendComponent(dljgs1.registerComponent(
					it[0],it[1],
					tree.draw, {
						'ondown':function(){
							console.log('on down !!!');
							if(tree.onClick(it[0])){//切换当前节点
								treeBackComp.switchEnable(false);
								core.rememberFlag(false);//清除记忆
							}
							treeBackComp.flush();
							return true;
						},
					},'treeBack'));//注册时注明其父类
			}
		);

		
		////// 数据载入初始化
		tree.loadStorage();
		return {'tree':tree,'comp':treeBackComp};
	}

	//////////////////剧情插件相关////////////////////////////////
	this.rememberFlag = function(flag){//穿越之前记住
		if(!core.isset(flag))flag = false;
		if(!flag){core.clearMap('data');}
		dljgs1.objs.specialFlag = flag;
		dljgs1.objs.flags = dljgs1.objs.flags || {};
		dljgs1.objs.flags.mana = core.status.hero.mana;
		dljgs1.objs.flags.gameProc = core.status.hero.flags.gameProc;
	}
	

	this.calcuTimeConsume = function(procFlag){//计算时间能量的消耗 异或
		if(core.getFlag('hard',1)==0){
			return 0;
		}
		var diff = (procFlag ^ core.getFlag('gameProc'));
		var ct = 0;
		while(diff!=0){
			ct += (diff & 1);
			diff>>= 1;
		}
		return ct;
	}
	
	// 录像：穿越后的记忆保留 —— 修改读档后处理 获取当前的进程变量
	var _replayAction_remember = function (action) {
		if (action.indexOf("remb:")!=0) return false;
		var procFlag = parseInt(action.substring(5));
		//增加的情报都会导致时间能量损失
		core.status.hero.mana -= core.calcuTimeConsume(procFlag);
		core.setFlag('gameProc',procFlag);
		core.status.route.push(action);
		core.replay();
		return true;
	}


	// flag开关位处理 —— 
	this.getFlagBit = function(name,bit){//获取位存在
		return ((core.getFlag(name,0)&(1<<bit))>>bit);
	}
	this.setFlagBit = function(name,bit){
		var flg = core.getFlag(name,0);
		flg |= (1<<bit);
		core.setFlag(name, flg);
	} 
	// 需要设置的情报位一览：
	// 0 一开始的老头的击杀情报 —— 需要一楼拿到情报，二周目即可干掉他
	// 1 左大门的幻觉（一条世界线只产生一次的剧情）
	// 2 小偷开墙，需要一楼商人的情报
	// 3 二楼修行者传功，需要一楼商人的另一个情报，并且拿到了圣盾
	// 4 “杀完发现没有遗物”——找放假的魔法老头拿到真正的遗物
	// 5 阅读完公主日记

	this.infoBook = function(){//情报记录显示：
		var data = [
			" - 据说大门的老头有红钥匙和公主遗物",			// 0
			" - 我似乎产生了幻觉，好像看到了她……这怎么忘不掉了。",	// 1
			" - 小偷会破墙，也许我应该找他帮忙开一条路",		// 2
			" - 有个修行者很需要圣盾，我可以拿到给他",	// 3
			" - 大门的老头根本没有公主遗物，那个魔法师骗了我。",// 4
			" - 那个卖盾的商人有一枚徽章，我应该找他买下来",     	//5
			" - 公主的日记里记录了一个小法术，似乎可以用来保留国王和王子的灵魂印记？",// 6
			" - 王子的灵魂碎片已经得到",				// 7
			" - 国王的灵魂碎片已经得到",				// 8
			" - \\r[red]【重要】\\r[]击杀国王和王子拿到他们的灵魂印记才能去打开堕落大精灵的封印门。大门口有一个净化阵可以净化魔化者。", // 9
		];
		var text = "   \\r[yellow]【情报记忆】\\r[]    \\n";
		var ct = 0;
		for(var i in data){
			if(core.getFlagBit('gameProc',i)){
				text += data[i]+'\\n';ct+=1;
			}
		}
		if(ct==0){
			text += "'\\n\\n当前尚无有效情报，在获取情报后可通过点击\\i[shop]或者按下\\r[yellow] V \\r[]进行选择查看。\\n\\n"
		}
		core.insertAction([text]);
	// 1 左大门的幻觉（一条世界线只产生一次的剧情）
	// 2 小偷开墙，需要一楼商人的情报
	// 3 二楼修行者传功，需要一楼商人的另一个情报，并且拿到了圣盾
	// 4 “杀完发现没有遗物”——找放假的魔法老头拿到真正的遗物
	// 5 阅读完公主日记

	}

	core.registerReplayAction('remb',_replayAction_remember);


	this.TestBeforeSave = function(id){
		//tree.beforeSave(id);
		var tmp = core.plugin.initTreeSL();
		tmp.tree.beforeSave(1);
	}
	this.drawSL = function(){
		//treeBackComp.switchEnable(true);
	}
	this.componentCanvas = componentCanvas;
	// ===========数据初始化==============
	window.dljgs1.objs = {};
	//window.dljgs1.objs.SLtree = new core.plugin.initTreeSL(); 

	// ================================= 重写
	var originHasSpecial = core.enemys.hasSpecial;
	var myHasSpecial = function(special, test){
		if(test == 22 && core.getFlag('hard',-1)==0){
			return false;
		}else{
			return originHasSpecial(special,test);
		}
	}
	/*
	core.enemys.hasSpecial = myHasSpecial.bind(core.enemys);
	var originGetExtraDamage = core.enemys.getExtraDamage;
	core.enemys.getExtraDamage = function(enemy){
		if(core.getFlag('hard',-1)==0){
			return 0;
		}else{
			return originGetExtraDamage(enemy);
		}
	}*/
	
	// 主动存档时 记录id（自动存档暂时不做 自动存档可以是一个curNode的next 但在切换后会失效 懒得弄了）
	control.prototype._doSL_save = function (id) {
		if (id=='autoSave') return core.drawTip('不能覆盖自动存档！');
		// 在事件中的存档
		if (core.status.event.interval != null)
			core.setFlag("__events__", core.status.event.interval);
		core.setLocalForage("save"+id, core.saveData(), function() {
			core.saves.saveIndex=id;
			dljgs1.objs.SLtree.tree.beforeSave(id);//!***记录存档信息
			core.setLocalStorage('saveIndex', core.saves.saveIndex);
			// 恢复事件
			if (!core.events.recoverEvents(core.status.event.interval))
				core.ui.closePanel();
			core.drawTip('存档成功！');
		}, function(err) {
			main.log(err);
			if (core.platform.useLocalForage) {
				alert("存档失败，错误信息：\n"+err);
			}
			else {
				alert("存档失败，错误信息：\n"+err+"\n建议使用垃圾存档清理工具进行清理！");
			}
		});
		core.removeFlag("__events__");
		return;
	}
	var originRemoveSave = core.control.removeSave;
	core.control.removeSave = function(index, callback){
		if (index != 0 && index != "autoSave") {
			window.dljgs1.objs.SLtree.tree.beforeRemove(index);
		}
		originRemoveSave(index,callback);
	}

	// 支持指定画布的画存档
	core.ui._drawSLPanel_drawRecord = function(title, data, x, y, size, cho, highLight,canvas,noText){//
		var strokeColor = '#FFD700';
		
		if (core.status.event.selection) strokeColor = '#FF6A6A';
		if (!data || !data.floorId) highLight = false;
		canvas = canvas || 'ui';
		
		core.setTextAlign(canvas, 'center');
		core.fillText(canvas, title, x, y, highLight?'#FFD700':'#FFFFFF', this._buildFont(17, true));
		core.strokeRect(canvas, x-size/2, y+15, size, size, cho?strokeColor:'#FFFFFF', cho?6:2);
		if (data && data.floorId) {
			core.drawThumbnail(data.floorId, core.maps.loadMap(data.maps, data.floorId).blocks, {
				heroLoc: data.hero.loc, heroIcon: data.hero.flags.heroIcon, flags: data.hero.flags
			}, {
				ctx: canvas, x: x-size/2, y: y+15, size: size, centerX: data.hero.loc.x, centerY: data.hero.loc.y
			});
			if(noText)return;
			var v = core.formatBigNumber(data.hero.hp,true)+"/"+core.formatBigNumber(data.hero.atk,true)+"/"+core.formatBigNumber(data.hero.def,true);
			var v2 = "/"+core.formatBigNumber(data.hero.mdef,true);
			if (core.calWidth(canvas, v + v2, this._buildFont(10, false)) <= size) v += v2;
			core.fillText(canvas, v, x, y+30+size, '#FFD700');
			core.fillText(canvas, core.formatDate(new Date(data.time)), x, y+43+size, data.hero.flags.__consoleOpened__?'#FF6A6A':'#FFFFFF');
		}
		else {
			core.fillRect(canvas, x-size/2, y+15, size, size, '#333333', 2);
			core.fillText(canvas, '空', x, parseInt(y+22+size/2), '#FFFFFF', this._buildFont(30,true));
		}
		////// 特殊 : 显示能量损耗///////
		if(dljgs1.objs.specialFlag && canvas=='cur' && data){
			core.clearMap('data');
			core.fillText('data', '能量损耗：'+ core.calcuTimeConsume(data.hero.flags.gameProc), 50, 50, '#DDDDDD', this._buildFont(18, true));
		}
		
	}
	//var origin_drawSLPanel_drawBackground = core.ui._drawSLPanel_drawBackground;
	//core.ui._drawSLPanel_drawBackground = function() {
	//	origin_drawSLPanel_drawBackground();		
//	}


}
}