const axios = require('axios');
const fs = require('fs/promises');
const fss = require('fs');
const fse = require('fs-extra');
const path = require('path');
const FormData = require('form-data');
const compressing = require('compressing');
const Fontmin = require('fontmin');

const id = 1000; // 用户id
const password = 'password'; // 密码

const hexcase = 0; /* hex output format. 0 - lowercase; 1 - uppercase        */
const chrsz = 8; /* bits per input character. 8 - ASCII; 16 - Unicode      */

// ---------- md5码

/*
 *  * A JavaScript implementation of the RSA Data Security, Inc. MD5 Message
 *   * Digest Algorithm, as defined in RFC 1321.
 *    * Version 2.1 Copyright (C) Paul Johnston 1999 - 2002.
 *     * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet
 *      * Distributed under the BSD License
 *       * See http://pajhome.org.uk/crypt/md5 for more info.
 *        */

/*
 *  * Configurable letiables. You may need to tweak these to be compatible with
 *   * the server-side, but the defaults work in most cases.
 *    */

/*
 *  * These are the functions you'll usually want to call
 *   * They take string arguments and return either hex or base-64 encoded strings
 *    */
function hex_md5(s) {
    return binl2hex(core_md5(str2binl(s), s.length * chrsz));
}

/*
 *  * Calculate the MD5 of an array of little-endian words, and a bit length
 *   */
function core_md5(x, len) {
    /* append padding */
    x[len >> 5] |= 0x80 << len % 32;
    x[(((len + 64) >>> 9) << 4) + 14] = len;

    let a = 1732584193;
    let b = -271733879;
    let c = -1732584194;
    let d = 271733878;

    for (let i = 0; i < x.length; i += 16) {
        const olda = a;
        const oldb = b;
        const oldc = c;
        const oldd = d;

        a = md5_ff(a, b, c, d, x[i + 0], 7, -680876936);
        d = md5_ff(d, a, b, c, x[i + 1], 12, -389564586);
        c = md5_ff(c, d, a, b, x[i + 2], 17, 606105819);
        b = md5_ff(b, c, d, a, x[i + 3], 22, -1044525330);
        a = md5_ff(a, b, c, d, x[i + 4], 7, -176418897);
        d = md5_ff(d, a, b, c, x[i + 5], 12, 1200080426);
        c = md5_ff(c, d, a, b, x[i + 6], 17, -1473231341);
        b = md5_ff(b, c, d, a, x[i + 7], 22, -45705983);
        a = md5_ff(a, b, c, d, x[i + 8], 7, 1770035416);
        d = md5_ff(d, a, b, c, x[i + 9], 12, -1958414417);
        c = md5_ff(c, d, a, b, x[i + 10], 17, -42063);
        b = md5_ff(b, c, d, a, x[i + 11], 22, -1990404162);
        a = md5_ff(a, b, c, d, x[i + 12], 7, 1804603682);
        d = md5_ff(d, a, b, c, x[i + 13], 12, -40341101);
        c = md5_ff(c, d, a, b, x[i + 14], 17, -1502002290);
        b = md5_ff(b, c, d, a, x[i + 15], 22, 1236535329);

        a = md5_gg(a, b, c, d, x[i + 1], 5, -165796510);
        d = md5_gg(d, a, b, c, x[i + 6], 9, -1069501632);
        c = md5_gg(c, d, a, b, x[i + 11], 14, 643717713);
        b = md5_gg(b, c, d, a, x[i + 0], 20, -373897302);
        a = md5_gg(a, b, c, d, x[i + 5], 5, -701558691);
        d = md5_gg(d, a, b, c, x[i + 10], 9, 38016083);
        c = md5_gg(c, d, a, b, x[i + 15], 14, -660478335);
        b = md5_gg(b, c, d, a, x[i + 4], 20, -405537848);
        a = md5_gg(a, b, c, d, x[i + 9], 5, 568446438);
        d = md5_gg(d, a, b, c, x[i + 14], 9, -1019803690);
        c = md5_gg(c, d, a, b, x[i + 3], 14, -187363961);
        b = md5_gg(b, c, d, a, x[i + 8], 20, 1163531501);
        a = md5_gg(a, b, c, d, x[i + 13], 5, -1444681467);
        d = md5_gg(d, a, b, c, x[i + 2], 9, -51403784);
        c = md5_gg(c, d, a, b, x[i + 7], 14, 1735328473);
        b = md5_gg(b, c, d, a, x[i + 12], 20, -1926607734);

        a = md5_hh(a, b, c, d, x[i + 5], 4, -378558);
        d = md5_hh(d, a, b, c, x[i + 8], 11, -2022574463);
        c = md5_hh(c, d, a, b, x[i + 11], 16, 1839030562);
        b = md5_hh(b, c, d, a, x[i + 14], 23, -35309556);
        a = md5_hh(a, b, c, d, x[i + 1], 4, -1530992060);
        d = md5_hh(d, a, b, c, x[i + 4], 11, 1272893353);
        c = md5_hh(c, d, a, b, x[i + 7], 16, -155497632);
        b = md5_hh(b, c, d, a, x[i + 10], 23, -1094730640);
        a = md5_hh(a, b, c, d, x[i + 13], 4, 681279174);
        d = md5_hh(d, a, b, c, x[i + 0], 11, -358537222);
        c = md5_hh(c, d, a, b, x[i + 3], 16, -722521979);
        b = md5_hh(b, c, d, a, x[i + 6], 23, 76029189);
        a = md5_hh(a, b, c, d, x[i + 9], 4, -640364487);
        d = md5_hh(d, a, b, c, x[i + 12], 11, -421815835);
        c = md5_hh(c, d, a, b, x[i + 15], 16, 530742520);
        b = md5_hh(b, c, d, a, x[i + 2], 23, -995338651);

        a = md5_ii(a, b, c, d, x[i + 0], 6, -198630844);
        d = md5_ii(d, a, b, c, x[i + 7], 10, 1126891415);
        c = md5_ii(c, d, a, b, x[i + 14], 15, -1416354905);
        b = md5_ii(b, c, d, a, x[i + 5], 21, -57434055);
        a = md5_ii(a, b, c, d, x[i + 12], 6, 1700485571);
        d = md5_ii(d, a, b, c, x[i + 3], 10, -1894986606);
        c = md5_ii(c, d, a, b, x[i + 10], 15, -1051523);
        b = md5_ii(b, c, d, a, x[i + 1], 21, -2054922799);
        a = md5_ii(a, b, c, d, x[i + 8], 6, 1873313359);
        d = md5_ii(d, a, b, c, x[i + 15], 10, -30611744);
        c = md5_ii(c, d, a, b, x[i + 6], 15, -1560198380);
        b = md5_ii(b, c, d, a, x[i + 13], 21, 1309151649);
        a = md5_ii(a, b, c, d, x[i + 4], 6, -145523070);
        d = md5_ii(d, a, b, c, x[i + 11], 10, -1120210379);
        c = md5_ii(c, d, a, b, x[i + 2], 15, 718787259);
        b = md5_ii(b, c, d, a, x[i + 9], 21, -343485551);

        a = safe_add(a, olda);
        b = safe_add(b, oldb);
        c = safe_add(c, oldc);
        d = safe_add(d, oldd);
    }
    return Array(a, b, c, d);
}

/*
 *  * These functions implement the four basic operations the algorithm uses.
 *   */
function md5_cmn(q, a, b, x, s, t) {
    return safe_add(bit_rol(safe_add(safe_add(a, q), safe_add(x, t)), s), b);
}
function md5_ff(a, b, c, d, x, s, t) {
    return md5_cmn((b & c) | (~b & d), a, b, x, s, t);
}
function md5_gg(a, b, c, d, x, s, t) {
    return md5_cmn((b & d) | (c & ~d), a, b, x, s, t);
}
function md5_hh(a, b, c, d, x, s, t) {
    return md5_cmn(b ^ c ^ d, a, b, x, s, t);
}
function md5_ii(a, b, c, d, x, s, t) {
    return md5_cmn(c ^ (b | ~d), a, b, x, s, t);
}

/*
 *  * Add integers, wrapping at 2^32. This uses 16-bit operations internally
 *   * to work around bugs in some JS interpreters.
 *    */
function safe_add(x, y) {
    const lsw = (x & 0xffff) + (y & 0xffff);
    const msw = (x >> 16) + (y >> 16) + (lsw >> 16);
    return (msw << 16) | (lsw & 0xffff);
}

/*
 *  * Bitwise rotate a 32-bit number to the left.
 *   */
function bit_rol(num, cnt) {
    return (num << cnt) | (num >>> (32 - cnt));
}

/*
 *  * Convert a string to an array of little-endian words
 *   * If chrsz is ASCII, characters >255 have their hi-byte silently ignored.
 *    */
function str2binl(str) {
    let bin = Array();
    let mask = (1 << chrsz) - 1;
    for (let i = 0; i < str.length * chrsz; i += chrsz)
        bin[i >> 5] |= (str.charCodeAt(i / chrsz) & mask) << i % 32;
    return bin;
}

/*
 *  * Convert an array of little-endian words to a hex string.
 *   */
function binl2hex(binarray) {
    let hex_tab = hexcase ? '0123456789ABCDEF' : '0123456789abcdef';
    let str = '';
    for (let i = 0; i < binarray.length * 4; i++) {
        str +=
            hex_tab.charAt((binarray[i >> 2] >> ((i % 4) * 8 + 4)) & 0xf) +
            hex_tab.charAt((binarray[i >> 2] >> ((i % 4) * 8)) & 0xf);
    }
    return str;
}

const comment = process.argv[2];

const data = fss.readFileSync(
    path.resolve(__dirname, 'project/data.js'),
    'utf-8'
);
eval(data);

// 压缩打包
async function compress() {
    console.log('开始清空打包文件');
    try {
        await fs.rm(path.resolve(__dirname, 'dist.zip'));
    } catch {}

    try {
        await fs.mkdir(path.resolve(__dirname, 'dist'));
    } catch {}

    try {
        await fse.emptyDir(path.resolve(__dirname, 'dist'));
    } catch {
        return console.log('清空打包文件失败');
    }

    // 开始打包
    const edit = process.argv[4];
    console.log(
        `开始打包, ${
            edit === 'true' ? '允许在线查看编辑器' : '不允许在线查看编辑器'
        }`
    );
    try {
        await Promise.all([
            fse.copy(
                path.resolve(__dirname, 'libs'),
                path.resolve(__dirname, 'dist/libs')
            ),
            fse.copy(
                path.resolve(__dirname, 'project'),
                path.resolve(__dirname, 'dist/project')
            ),
            fse.copyFile(
                path.resolve(__dirname, 'main.js'),
                path.resolve(__dirname, 'dist/main.js')
            ),
            fse.copyFile(
                path.resolve(__dirname, 'index.html'),
                path.resolve(__dirname, 'dist/index.html')
            ),
            fse.copyFile(
                path.resolve(__dirname, 'styles.css'),
                path.resolve(__dirname, 'dist/styles.css')
            ),
            fse.copyFile(
                path.resolve(__dirname, 'logo.png'),
                path.resolve(__dirname, 'dist/logo.png')
            ),
            edit &&
                fse.copyFile(
                    path.resolve(__dirname, 'editor.html'),
                    path.resolve(__dirname, 'dist/editor.html')
                ),
            edit &&
                fse.copyFile(
                    path.resolve(__dirname, 'editor-mobile.html'),
                    path.resolve(__dirname, 'dist/editor-mobile.html')
                ),
            edit &&
                fse.copy(
                    path.resolve(__dirname, '_server'),
                    path.resolve(__dirname, 'dist/_server')
                )
        ]);
        await fse.emptyDir(path.resolve(__dirname, 'dist/project/fonts'));
    } catch {
        return console.log('打包失败');
    }

    // 去除未使用的文件
    console.log('开始去除未使用的文件');
    try {
        const main = data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.main;
        const data = [
            ['dist/project/floors', '.js', 'floorIds'],
            ['dist/project/bgms', '', 'bgms'],
            ['dist/project/sounds', '', 'sounds'],
            ['dist/project/images', '', 'images'],
            ['dist/project/animates', '.animate', 'animates'],
            ['dist/project/tilesets', '', 'tilesets']
        ];
        await Promise.all(
            data.map(async v => {
                const all = await fs.readdir(path.resolve(__dirname, v[0]));
                const data = main[v[2]].map(vv => vv + v[1]);
                all.forEach(async vv => {
                    if (!data.includes(vv)) {
                        await fs.rm(path.resolve(__dirname, `${v[0]}/${vv}`));
                    }
                });
            })
        );
        console.log('未使用文件去除成功');
    } catch (e) {
        console.log('去除未使用文件失败，尝试执行下一步骤');
    }

    // 压缩字体
    if (!process.argv[3] || process.argv[3] === 'false') {
        console.log('开始压缩字体');
        try {
            // 获取要压缩的文字列表，libs & projects下的所有js文件
            let texts = ``;
            const exclude = `\n \t`;
            const libs = await fs.readdir(path.resolve(__dirname, 'libs'));
            const project = await fs.readdir(
                path.resolve(__dirname, 'project')
            );
            const floors = await fs.readdir(
                path.resolve(__dirname, 'project/floors')
            );
            const all = [
                ...libs.map(v => path.resolve(__dirname, `libs/${v}`)),
                ...project.map(v => path.resolve(__dirname, `project/${v}`)),
                ...floors.map(v =>
                    path.resolve(__dirname, `project/floors/${v}`)
                )
            ];
            for await (const dir of all) {
                const stat = await fs.stat(dir);
                if (!stat.isFile()) continue;
                const file = await fs.readFile(dir, 'utf-8');
                for (let i = 0; i < file.length; i++) {
                    const char = file[i];
                    if (!texts.includes(char) && !exclude.includes(char))
                        texts += char;
                }
            }

            // 获取所有字体（直接压缩字体会报错
            let fonts = [];
            try {
                fonts = data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.main.fonts;
            } catch (e) {
                return console.log('字体压缩失败');
            }

            await Promise.all([
                ...fonts.map(v =>
                    (async () => {
                        const fontmin = new Fontmin();
                        fontmin
                            .src(
                                path.resolve(
                                    __dirname,
                                    `project/fonts/${v}.ttf`
                                )
                            )
                            .dest('dist/project/fonts')
                            .use(
                                Fontmin.glyph({
                                    text: texts
                                })
                            );
                        await new Promise(res => {
                            fontmin.run(err => {
                                if (err) throw err;
                                res();
                            });
                        });
                    })()
                )
            ]);
            console.log('字体压缩成功');
        } catch (e) {
            await fse.copy(
                path.resolve(__dirname, 'project/fonts'),
                path.resolve(__dirname, 'dist/project/fonts')
            );
            console.log('字体压缩失败，使用压缩前字体');
        }
    } else {
        await fse.copy(
            path.resolve(__dirname, 'project/fonts'),
            path.resolve(__dirname, 'dist/project/fonts')
        );
    }

    // 打包为zip
    console.log('开始压缩为zip');
    try {
        await compressing.zip.compressDir(
            path.resolve(__dirname, 'dist'),
            path.resolve(__dirname, 'dist.zip')
        );
    } catch {
        return console.log('压缩为zip失败');
    }
    console.log('压缩成功');
}

(async function () {
    const error = await compress();
    if (error) return console.log('压缩失败');
    console.log('打包成功');
    const pass = hex_md5(password);
    // 登录
    const res = await axios.postForm(
        'https://h5mota.com/backend/user/login.php',
        {
            nid: id,
            npass: pass
        }
    );
    if (res.data.code === 0) console.log('登录成功');
    else return console.log('登录失败');

    const data = await axios.post(
        'https://h5mota.com/up2cos/getData.php',
        void 0,
        {
            headers: {
                'Access-Control-Allow-Origin': '*',
                Cookie: `id=${id}; password=${pass}`
            }
        }
    );
    if (data.data.code !== 1) return console.log('获取自助更新信息失败');

    const name = data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.firstData.name;

    const tower = data.data.list.find(v => v.name === name);

    if (!tower) return console.log('不能更新不是你的塔');

    const dir = path.resolve(__dirname, 'dist.zip');

    const stat = await fs.stat(dir);
    let size = '';
    size = `${stat.size}B`;
    if (stat.size > 1024) size = `${(stat.size / 1024).toFixed(2)}KB`;
    if (stat.size > 1024 ** 2) size = `${(stat.size / 1024 ** 2).toFixed(2)}MB`;
    if (stat.size > 1024 ** 3) size = `${(stat.size / 1024 ** 3).toFixed(2)}GB`;

    const stream = fss.createReadStream(dir);

    const form = new FormData();
    form.append('type', 'upload');
    form.append('name', name);
    form.append('comment', comment || tower.comment);
    form.append('file', stream);

    const headers = form.getHeaders(); // 获取headers
    const [err, length] = await new Promise(res =>
        form.getLength((e, l) => res([e, l]))
    );
    if (err) return console.log('获取content-length失败');
    headers['content-length'] = length;
    headers['cookie'] = `id=${id}; password=${pass}`;

    console.log(`开始上传, 文件大小: ${size}`);
    const ans = await axios.post(
        'https://h5mota.com/up2cos/setData.php',
        form,
        {
            headers
        }
    );
    if (ans.data.error === 0 && ans.data.upload === true && ans.data.code === 1)
        console.log('上传成功');
    else console.log(`上传失败, 失败信息: `, ans.data);
})();
