functions_d6ad677b_427a_4623_b50f_a445a3b0ef8a = 
{
    "events": {
        "initGame": function () {
	// 游戏开始前的一些初始化操作

	// 根据flag来对道具进行修改
	if (core.flags.bigKeyIsBox)
		core.material.items.bigKey = {'cls': 'items', 'name': '钥匙盒'};
	// 面前的墙？四周的墙？
	if (core.flags.pickaxeFourDirections)
		core.material.items.pickaxe.text = "可以破坏勇士四周的墙";
	if (core.flags.bombFourDirections)
		core.material.items.bomb.text = "可以炸掉勇士四周的怪物";
	if (core.flags.equipment) {
		core.material.items.sword1 = {'cls': 'constants', 'name': '铁剑', 'text': '一把很普通的铁剑'};
		core.material.items.sword2 = {'cls': 'constants', 'name': '银剑', 'text': '一把很普通的银剑'};
		core.material.items.sword3 = {'cls': 'constants', 'name': '骑士剑', 'text': '一把很普通的骑士剑'};
		core.material.items.sword4 = {'cls': 'constants', 'name': '圣剑', 'text': '一把很普通的圣剑'};
		core.material.items.sword5 = {'cls': 'constants', 'name': '神圣剑', 'text': '一把很普通的神圣剑'};
		core.material.items.shield1 = {'cls': 'constants', 'name': '铁盾', 'text': '一个很普通的铁盾'};
		core.material.items.shield2 = {'cls': 'constants', 'name': '银盾', 'text': '一个很普通的银盾'};
		core.material.items.shield3 = {'cls': 'constants', 'name': '骑士盾', 'text': '一个很普通的骑士盾'};
		core.material.items.shield4 = {'cls': 'constants', 'name': '圣盾', 'text': '一个很普通的圣盾'};
		core.material.items.shield5 = {'cls': 'constants', 'name': '神圣盾', 'text': '一个很普通的神圣盾'};
	}


},
        "setInitData": function (hard) {
	core.setFlag('hard', 2);
	if (hard=='Easy') { // 简单难度
		core.setFlag('hard', 1);
		core.setStatus("hp", 1000);
		core.setStatus("atk", 40);
		core.setStatus("def", 2);
		core.setStatus("mdef", 18);
		core.setItem("yellowKey", 1);
	}
	core.events.afterLoadData();
},
        "win": function (reason) {
	// 游戏获胜事件 
	core.ui.closePanel();
	var replaying = core.status.replay.replaying;
	core.stopReplay();
	core.waitHeroToStop(function() {
		core.removeGlobalAnimate(0,0,true);
		core.clearMap('all'); // 清空全地图
		core.drawText([
			"\t[" + (reason||"恭喜通关") + "]你的分数是${status:hp}。"
		], function () {
			core.events.gameOver(reason||'', replaying);
		})
	});
},
        "lose": function (reason) {
	// 游戏失败事件
	core.ui.closePanel();
	var replaying = core.status.replay.replaying;
	core.stopReplay();
	core.waitHeroToStop(function() {
		core.drawText([
			"\t["+(reason||"结局1")+"]你死了。\n如题。"
		], function () {
			core.events.gameOver(null, replaying);
		});
	})
},
        "afterChangeFloor": function (floorId) {
	// 转换楼层结束的事件
	if (!core.hasFlag("visited_"+floorId)) {
		core.insertAction(core.floors[floorId].firstArrive);
		core.setFlag("visited_"+floorId, true);
	}
},
        "addPoint": function (enemy) {
	// 加点事件
	var point = enemy.point;
	if (!core.flags.enableAddPoint || !core.isset(point) || point<=0) return [];

	// 加点，返回一个choices事件
	return [
		{"type": "choices",
			"choices": [
				{"text": "攻击+"+(1*point), "action": [
					{"type": "setValue", "name": "status:atk", "value": "status:atk+"+(1*point)}
				]},
				{"text": "防御+"+(2*point), "action": [
					{"type": "setValue", "name": "status:def", "value": "status:def+"+(2*point)}
				]},
				{"text": "生命+"+(200*point), "action": [
					{"type": "setValue", "name": "status:hp", "value": "status:hp+"+(200*point)}
				]},
			]
		}
	];
},
        "afterBattle": function (enemyId,x,y,callback) {
	// 战斗结束后触发的事件

	var enemy = core.material.enemys[enemyId];

	var damage = core.enemys.getDamage(enemyId);
	if (damage == null) damage = core.status.hero.hp+1;

	// 扣减体力值
	core.status.hero.hp -= damage;
	if (core.status.hero.hp<=0) {
		core.status.hero.hp=0;
		core.updateStatusBar();
		core.events.lose('battle');
		return;
	}
	// 获得金币和经验
	var money = enemy.money;
	if (core.hasItem('coin')) money *= 2;
	if (core.hasFlag('curse')) money=0;
	core.status.hero.money += money;
	var experience =enemy.experience;
	if (core.hasFlag('curse')) experience=0;
	core.status.hero.experience += experience;
	var hint = "打败 " + enemy.name;
	if (core.flags.enableMoney)
		hint += "，金币+" + money;
	if (core.flags.enableExperience)
		hint += "，经验+" + experience;
	core.drawTip(hint);

	// 删除该块
	if (core.isset(x) && core.isset(y)) {
		core.removeBlock(x, y);
		core.canvas.event.clearRect(32 * x, 32 * y, 32, 32);
	}
	
	core.plugin.processBattleEnd(enemy);

// 	// 毒衰咒的处理
// 	var special = enemy.special;
// 	// 中毒
// 	if (core.enemys.hasSpecial(special, 12) && !core.hasFlag('poison')) {
// 		core.setFlag('poison', true);
// 	}
// 	// 衰弱
// 	if (core.enemys.hasSpecial(special, 13) && !core.hasFlag('weak')) {
// 		core.setFlag('weak', true);
// 		core.status.hero.atk-=core.values.weakValue;
// 		core.status.hero.def-=core.values.weakValue;
// 	}
// 	// 诅咒
// 	if (core.enemys.hasSpecial(special, 14) && !core.hasFlag('curse')) {
// 		core.setFlag('curse', true);
// 	}
// 	// 仇恨属性：减半
// 	if (core.flags.hatredDecrease && core.enemys.hasSpecial(special, 17)) {
// 		core.setFlag('hatred', parseInt(core.getFlag('hatred', 0)/2));
// 	}
// 	// 自爆
// 	if (core.enemys.hasSpecial(special, 19)) {
// 		core.status.hero.hp = 1;
// 	}
// 	// 退化
// 	if (core.enemys.hasSpecial(special, 21)) {
// 		core.status.hero.atk -= (enemy.atkValue||0);
// 		core.status.hero.def -= (enemy.defValue||0);
// 		if (core.status.hero.atk<0) core.status.hero.atk=0;
// 		if (core.status.hero.def<0) core.status.hero.def=0;
// 	}
// 	// 增加仇恨值
// 	core.setFlag('hatred', core.getFlag('hatred',0)+core.values.hatred);
 	core.updateStatusBar();


	// 事件的处理
	var todo = [];
	// 如果不为阻击，且该点存在，且有事件
	if (core.isset(x) && core.isset(y)) {
		var event = core.floors[core.status.floorId].afterBattle[x+","+y];
		if (core.isset(event)) {
			// 插入事件
			core.unshift(todo, event);
		}
	}
	// 如果有加点
	var point = core.material.enemys[enemyId].point;
	if (core.isset(point) && point>0) {
		core.unshift(todo, core.events.addPoint(core.material.enemys[enemyId]));
	}

	// 如果事件不为空，将其插入
	if (todo.length>0) {
		core.events.insertAction(todo,x,y);
	}

	// 如果已有事件正在处理中
	if (core.status.event.id == null) {
		core.continueAutomaticRoute();
	}
	else {
		core.clearContinueAutomaticRoute();
	}
	if (core.isset(callback)) callback();

},
        "afterOpenDoor": function (doorId,x,y,callback) {
	// 开一个门后触发的事件
	
	var todo = [];
	if (core.isset(x) && core.isset(y)) {
		var event = core.floors[core.status.floorId].afterOpenDoor[x+","+y];
		if (core.isset(event)) {
			core.unshift(todo, event);
		}
	}

	if (todo.length>0) {
		core.events.insertAction(todo,x,y);
	}

	if (core.status.event.id == null) {
		core.continueAutomaticRoute();
	}
	else {
		core.clearContinueAutomaticRoute();
	}
	if (core.isset(callback)) callback();
},
        "afterChangeLight": function (x,y) {
	// 改变亮灯之后，可以触发的事件

},
        "afterPushBox": function () {
	// 推箱子后的事件

	var noBoxLeft = function () {
		// 地图上是否还存在未推到的箱子，如果不存在则返回true，存在则返回false
		for (var i=0;i<core.status.thisMap.blocks.length;i++) {
			var block=core.status.thisMap.blocks[i];
			if (core.isset(block.event) && block.event.id=='box') return false;
		}
		return true;
	}

	if (noBoxLeft()) {
		// 可以通过if语句来进行开门操作
		/*
		if (core.status.floorId=='xxx') { // 在某个楼层
			core.insertAction([ // 插入一条事件
				{"type": "openDoor", "loc": [x,y]} // 开门
			])
		}
		*/
	}
},
        "afterUseBomb": function () {
	// 使用炸弹/圣锤后的事件

	// 这是一个使用炸弹也能开门的例子
	/*
	if (core.status.floorId=='xxx' && core.terrainExists(x0,y0,'specialDoor') // 某个楼层，该机关门存在
		&& !core.enemyExists(x1,y1) && !core.enemyExists(x2,y2)) // 且守门的怪物都不存在
	{
		core.insertAction([ // 插入事件
			{"type": "openDoor", "loc": [x0,y0]} // 开门
		])
	}
	*/

},
        "beforeSaveData": function (data) {
	// 即将存档前可以执行的操作

},
        "afterLoadData": function (data) {
	// 读档事件后，载入事件前，可以执行的操作
	// 可以在这里对怪物数据进行动态修改，详见文档——事件——怪物数据的动态修改


}
    },
    "ui": {
        "drawAbout": function () {
	// 绘制“关于”界面
	if (!core.isPlaying()) {
		core.status.event = {'id': null, 'data': null};
		core.dom.startPanel.style.display = 'none';
	}
	core.lockControl();
	core.status.event.id = 'about';

	core.clearMap('ui', 0, 0, 416, 416);
	var left = 48, top = 36, right = 416 - 2 * left, bottom = 416 - 2 * top;

	core.setAlpha('ui', 0.85);
	core.fillRect('ui', left, top, right, bottom, '#000000');
	core.setAlpha('ui', 1);
	core.strokeRect('ui', left - 1, top - 1, right + 1, bottom + 1, '#FFFFFF', 2);

	var text_start = left + 24;

	// 名称
	core.canvas.ui.textAlign = "left";
	core.fillText('ui', "泰拳打码女怒爆次元树", text_start, top+35, "#FFD700", "bold 22px Verdana");
	core.fillText('ui', "版本： "+core.firstData.version, text_start, top + 80, "#FFFFFF", "bold 17px Verdana");
	core.fillText('ui', "作者： 老黄鸡", text_start, top + 112);
	core.fillText('ui', 'HTML5魔塔交流群：539113091', text_start, top+112+32);
	// TODO: 写自己的“关于”页面，每次增加32像素即可
}
    },
    "plugins": {
        "plugin": function () {
	
	this.SPEC_NAMES = ["","洗经伐髓","生息两仪","魔功荒咬","五佛咒轮","紫晶无芒","苍穹云吐","神道微光","死亡之握","明镜水止",10,11,12,13,14,"荼吉尼天"];

	this.processBattleEnd = function(enemy) {
		var specs = this.getSpecHash(enemy.special);
		if(specs[4]){
			core.setSlimeDebuff(enemy.defValue,enemy.atkValue);
		}else{
			var turn = core.getSlimeTurn();
			if(turn>0) core.setFlag('slimeTurn',turn-1);
		}
		if(specs[5]){
			core.setFuryDebuff(enemy.atkValue);
		}else{
			core.setFuryDebuff(100);
		}
	};
	
	control.prototype.updateCheckBlock = function() {
		core.status.checkBlock = {};
		if (!core.isset(core.status.thisMap)) return;
		var blocks = core.status.thisMap.blocks;

		// Step1: 更新怪物地图
		core.status.checkBlock.map = []; // 记录怪物地图
		for (var n=0;n<blocks.length;n++) {
			var block = blocks[n];
			if (core.isset(block.event) && !(core.isset(block.enable) && !block.enable) && block.event.cls.indexOf('enemy')==0) {
				var id = block.event.id, enemy = core.enemys.getEnemys(id);
				if (core.isset(enemy)) {
					core.status.checkBlock.map[13*block.x+block.y]=id;
				}
			}
		}

		// Step2: 更新领域、阻击伤害
		core.status.checkBlock.damage = []; // 记录(x,y)点的伤害
		for (var x=0;x<13*13;x++) core.status.checkBlock.damage[x]=0;

		for (var x=0;x<13;x++) {
			for (var y=0;y<13;y++) {
				var id = core.status.checkBlock.map[13*x+y];
				if (core.isset(id)) {
					var enemy = core.enemys.getEnemys(id);
					// 存在领域
					if (core.enemys.hasSpecial(enemy.special, 15)) {
						var range = enemy.range || 1;
						var zoneSquare = false;
						if (core.isset(enemy.zoneSquare)) zoneSquare=enemy.zoneSquare;
						for (var dx=-range;dx<=range;dx++) {
							for (var dy=-range;dy<=range;dy++) {
								if (dx==0 && dy==0) continue;
								var nx=x+dx, ny=y+dy;
								if (nx<0 || nx>12 || ny<0 || ny>12) continue;
								if (!zoneSquare && Math.abs(dx)+Math.abs(dy)>range) continue;
								core.status.checkBlock.damage[13*nx+ny]+=core.enemys.attackHeroDamage(enemy);
							}
						}
					}
				}
			}
		}

		core.status.checkBlock.betweenAttack = [];
	}

	enemys.prototype.getSpecialHint = function (enemy, special) {
		if (!core.isset(special)) {
			var hints = [];
			var tarr = core.plugin.getSpecArr(enemy.special);
			for(var i=0;i<tarr.length;i++){
				if(tarr[i]){
					var hint=this.getSpecialHint(enemy, tarr[i]);
					if(hint) hints.push(hint);
				}
			}
			return hints;
		}
		var valueA = enemy.atkValue;
		var valueB = enemy.defValue;
		switch (special) {
			case 1: return "洗经伐髓：战斗中每次所受伤害降低"+valueA+"点";
			case 2: return "生息两仪：角色攻击力低于怪物时，怪物攻击力提高这个差值的4倍，否则怪物防御力提高一倍";
			case 3: return "魔功荒咬：战斗时无视角色"+valueA+"点护甲值";
			case 4: return "五佛咒轮：下"+valueB+"次战斗速度降低"+(100-valueA)+"%";
			case 5: return "紫晶无芒：下次战斗时全属性降低"+(100-valueA)+"%";
			case 6: return "苍穹云吐：角色的生命、攻击、防御、速度某一项低于怪物时，怪物该属性翻倍";
			case 7: return "神道微光：怪物战斗开始时吸取角色60%攻击、速度到自身，并增加吸取总和值x100的生命值";
			case 8: return "死亡之握: 战斗开始时角色攻击力下降与攻速一样的数值";
			case 9: return "明镜水止：角色的攻击、防御、速度某一项高于怪物时，怪物该属性翻倍";
			case 15: return "荼吉尼天：经过怪物周围"+(enemy.range||1)+"格时会受到1次攻击";
			default: break;
		}
		return "";
	};
	
	enemys.prototype.getSpecialText = function (enemyId) {
		if (enemyId == undefined) return "";
		var enemy = this.enemys[enemyId];
		var tarr = core.plugin.getSpecArr(enemy.special);
		var text = [];
		for(var i=0;i<tarr.length;i++){
			if(tarr[i]) text.push(core.plugin.SPEC_NAMES[tarr[i]]);
		}
		return text;
	};
	
	enemys.prototype.attackHeroDamage = function(enemy) {
		var hero_def = core.status.hero.def;
		if(core.isFuryDebuff()) hero_def = Math.floor(hero_def * core.getFlag('fury',100) / 100);
		return Math.max(enemy.atk-hero_def,0);
	};
	
	this.damageReduceRate = function(defv) {
		return 1-(defv*0.06)/(1+0.06*defv);
	};

	enemys.prototype.getCritical = function (monsterId) {
		var monster = core.material.enemys[monsterId];
		var mon_special = core.plugin.getSpecHash(monster.special);
		
		var hero_atk = core.status.hero.atk;
		var hero_speed = core.status.hero.mdef;
		if(core.isSlimeDebuff()) hero_speed = core.getSlimePower(hero_speed);
		if(core.isFuryDebuff()){
			hero_atk = Math.floor(hero_atk * core.getFlag('fury',100) / 100);
			hero_speed = Math.floor(hero_speed * core.getFlag('fury',100) / 100);
		}
		
		if(mon_special[8]) hero_atk -= hero_speed;
		var brate = core.plugin.damageReduceRate(monster.def);
		var spRate = hero_speed / monster.point;
		if(mon_special[7]) return '???';
		if(mon_special[1]){
			var ratk = Math.floor(core.status.hero.atk * brate * spRate);
			if(ratk <= monster.atkValue) return Math.floor((monster.atkValue+1)/brate/spRate)-core.status.hero.atk;
		}
		var info = this.getDamageInfo(monster, core.status.hero.hp, core.status.hero.atk, core.status.hero.def, core.status.hero.mdef);

		if (info == null) return '???';
		
		var mon_hp = info.mon_hp, mon_def = monster.def, turn = info.turn;
		
		if (info.damage <= 0) return 0;

		if (turn<=1) return 0;
		
		var mdec = core.plugin.damageReduceRate(mon_def);
		var fixBlock = 0;
		if(mon_special[1]) fixBlock += monster.atkValue;
		var nextAtk = Math.ceil((mon_hp/(turn-1)+fixBlock)/spRate/mdec);
		if (nextAtk <= hero_atk) return 0;
		return nextAtk - hero_atk;
	};
	
	this.getSpecHash = function(special) {
		if(!special) return {};
		var tarr = this.getSpecArr(special);
		var ret = {};
		for(var i=0;i<tarr.length;i++){
			if(tarr[i]) ret[tarr[i]] = true;
		}
		return ret;
	};
	
	this.getSpecArr = function(special) {
		if (!(special instanceof Array)) special = [special];
		return special.map(function(item){return item%100 || item/100;});
	};

	enemys.prototype.getDamageInfo = function(monster, hero_hp, hero_atk, hero_def, hero_speed) {
		var mon_hp = monster.hp, mon_atk = monster.atk, mon_def = monster.def, mon_special = core.plugin.getSpecHash(monster.special), mon_speed = monster.point;
		hero_hp=Math.max(0, hero_hp);
		hero_atk=Math.max(0, hero_atk);
		hero_def=Math.max(0, hero_def);
		hero_speed=Math.max(0, hero_speed);
		if(core.isSlimeDebuff()) hero_speed = core.getSlimePower(hero_speed);
		if(core.isFuryDebuff()){
			hero_atk = Math.floor(hero_atk * core.getFlag('fury',100) / 100);
			hero_def = Math.floor(hero_def * core.getFlag('fury',100) / 100);
			hero_speed = Math.floor(hero_speed * core.getFlag('fury',100) / 100);
		}
		
		if(mon_special[7]){
			var datk = Math.ceil(hero_atk * 0.6);
			var dspd = Math.ceil(hero_speed * 0.6);
			hero_atk -= datk;
			hero_speed -= dspd;
			mon_atk += datk;
			mon_speed += dspd;
			mon_hp += (datk+dspd)*100;
		}

		if(mon_special[6]){
			if(hero_hp<mon_hp) mon_hp *= 2;
			if(hero_atk<mon_atk) mon_atk *= 2;
			if(hero_def<mon_def) mon_def *= 2;
			if(hero_speed<mon_speed) mon_speed *= 2;
		}
		if(mon_special[9]){
			if(hero_atk>mon_atk) mon_atk *= 2;
			if(hero_def>mon_def) mon_def *= 2;
			if(hero_speed>mon_speed) mon_speed *= 2;
		}
		if(mon_special[2]){
			if(hero_atk<mon_atk){
				mon_atk += (mon_atk-hero_atk)*4;
			}else{
				mon_def *= 2;
			}
		}
		if(mon_special[3]) hero_def -= monster.atkValue;
		if(mon_special[8]) hero_atk -= hero_speed;

		var initDamage = 0;
		var spRate = hero_speed / mon_speed;
		var per_damage = mon_atk * core.plugin.damageReduceRate(hero_def);
		
		hero_atk = hero_atk * core.plugin.damageReduceRate(mon_def) * spRate;
		if(mon_special[1] && monster.atkValue) hero_atk = hero_atk < monster.atkValue ? 0 : hero_atk-monster.atkValue;
		if(hero_atk<=0) return null;
		var counterDamage = 0;
		var turn = Math.ceil(mon_hp / hero_atk );
		var ans = initDamage + (turn - 1) * per_damage + turn * counterDamage;
		ans = Math.floor(ans);
		return {
			"hero_atk": hero_atk,
			"hero_def": hero_def,
			"hero_mdef": hero_speed,
			"mon_hp": mon_hp,
			"mon_atk": mon_atk,
			"mon_def": mon_def,
			"per_damage": per_damage,
			"initDamage": initDamage,
			"turn": turn,
			"damage": ans
		};
	};
	
	enemys.prototype.getCurrentEnemys = function (floorId) {
		floorId=floorId||core.status.floorId;
		var enemys = [];
		var used = {};
		var mapBlocks = core.status.maps[floorId].blocks;
		for (var b = 0; b < mapBlocks.length; b++) {
			if (core.isset(mapBlocks[b].event) && !(core.isset(mapBlocks[b].enable) && !mapBlocks[b].enable) && mapBlocks[b].event.cls.indexOf('enemy')==0) {
				var monsterId = mapBlocks[b].event.id;
				if (core.isset(used[monsterId])) continue;

				var monster = core.material.enemys[monsterId];

				var mon_hp = monster.hp, mon_atk = monster.atk, mon_def = monster.def,mon_speed = monster.point || 0, mon_special = core.plugin.getSpecHash(monster.special);
				var hero_hp = core.status.hero.hp,hero_atk = core.status.hero.atk,hero_def = core.status.hero.def,hero_speed = core.status.hero.mdef;
				if(core.isSlimeDebuff()) hero_speed = core.getSlimePower(hero_speed);
				if(core.isFuryDebuff()){
					hero_atk = Math.floor(hero_atk * core.getFlag('fury',100) / 100);
					hero_def = Math.floor(hero_def * core.getFlag('fury',100) / 100);
					hero_speed = Math.floor(hero_speed * core.getFlag('fury',100) / 100);
				}

				if(mon_special[6]){
					if(core.status.hero.hp<mon_hp) mon_hp *= 2;
					if(hero_atk<mon_atk) mon_atk *= 2;
					if(hero_def<mon_def) mon_def *= 2;
					if(hero_speed<mon_speed) mon_speed *= 2;
				}
				if(mon_special[9]){
					if(hero_atk>mon_atk) mon_atk *= 2;
					if(hero_def>mon_def) mon_def *= 2;
					if(hero_speed>mon_speed) mon_speed *= 2;
				}
				if(mon_special[2]){
					if(core.status.hero.atk<mon_atk){
						mon_atk += (mon_atk-hero_atk)*4;
					}else{
						mon_def *= 2;
					}
				}
				
				var specialText = core.enemys.getSpecialText(monsterId);
				if (specialText.length>=3) specialText = "多属性...";
				else specialText = specialText.join("  ");

				enemys.push({
					'id': monsterId,
					'name': monster.name,
					'hp': mon_hp,
					'atk': mon_atk,
					'def': mon_def,
					'money': monster.money,
					'experience': monster.experience,
					'point': mon_speed, // 加点
					'special': specialText,
					'damage': this.getDamage(monsterId),
					'critical': this.getCritical(monsterId),
					'criticalDamage': this.getCriticalDamage(monsterId),
					'defDamage': this.getDefDamage(monsterId)
				});

				used[monsterId] = true;
			}
		}

		enemys.sort(function (a, b) {
			if (a.damage == b.damage) {
				return a.money - b.money;
			}
			if(a.damage === null) return 999999;
			if(b.damage === null) return -999999;
			return a.damage - b.damage;
		});
		return enemys;
	};
	
	ui.prototype.drawBook = function (index) {
		var enemys = core.enemys.getCurrentEnemys(core.floorIds[core.status.event.selection]);
		var background = core.canvas.ui.createPattern(core.material.ground, "repeat");

		clearInterval(core.interval.tipAnimate);
		core.clearMap('data', 0, 0, 416, 416);
		core.setOpacity('data', 1);

		core.clearMap('ui', 0, 0, 416, 416);
		core.setAlpha('ui', 1);
		core.setFillStyle('ui', background);
		core.fillRect('ui', 0, 0, 416, 416);

		core.setAlpha('ui', 0.6);
		core.setFillStyle('ui', '#000000');
		core.fillRect('ui', 0, 0, 416, 416);

		core.setAlpha('ui', 1);
		core.canvas.ui.textAlign = 'left';
		core.setFont('ui', 'bold 15px Verdana');

		if (enemys.length == 0) {
			core.fillText('ui', "本层无怪物", 83, 222, '#999999', "bold 50px Verdana");
			// 退出
			core.canvas.ui.textAlign = 'center';
			core.fillText('ui', '返回游戏', 370, 403,'#DDDDDD', 'bold 15px Verdana');
			return;
		}

		if (index<0) index=0;
		if (index>=enemys.length) index=enemys.length-1;
		var perpage = 6;
		var page=parseInt(index/perpage)+1;
		var totalPage = parseInt((enemys.length - 1) / perpage) + 1;
		core.status.event.data = index;
		var start = (page - 1) * perpage, end = Math.min(page * perpage, enemys.length);

		enemys = enemys.slice(start, end);
		core.status.boxAnimateObjs = [];
		for (var i = 0; i < enemys.length; i++) {
			// 边框
			var enemy = enemys[i];
			core.strokeRect('ui', 22, 62 * i + 22, 42, 42, '#DDDDDD', 2);

			var cls = 'enemys';
			if (core.isset(core.material.icons.enemy48[enemy.id]))
				cls = 'enemy48';
			var height = cls=='enemy48'?48:32;
			var animate = cls=='enemy48'?4:2;

			// 怪物
			core.status.boxAnimateObjs.push({
				'bgx': 22, 'bgy': 62 * i + 22, 'bgWidth': 42, 'bgHeight': 42,
				'x': 27, 'y': 62 * i + 27, 'height': 32, 'animate': animate,
				'image': core.material.images[cls],
				'pos': core.material.icons[cls][enemy.id] * height
			});

			// 数据
			core.canvas.ui.textAlign = "center";

			if (enemy.special=='') {
				core.fillText('ui', enemy.name, 115, 62 * i + 47, '#DDDDDD', 'bold 17px Verdana');
			}
			else {
				core.fillText('ui', enemy.name, 115, 62 * i + 40, '#DDDDDD', 'bold 17px Verdana');
				core.fillText('ui', enemy.special, 115, 62 * i + 62, '#FF6A6A', 'bold 15px Verdana');
			}
			core.canvas.ui.textAlign = "left";
			core.fillText('ui', '生命', 165, 62 * i + 32, '#DDDDDD', '13px Verdana');
			core.fillText('ui', core.formatBigNumber(enemy.hp), 195, 62 * i + 32, '#DDDDDD', 'bold 13px Verdana');
			core.fillText('ui', '金币', 255, 62 * i + 32, '#DDDDDD', '13px Verdana');
			core.fillText('ui', core.formatBigNumber(enemy.money), 285, 62 * i + 32, '#DDDDDD', 'bold 13px Verdana');
			core.fillText('ui', '经验', 335, 62 * i + 32, '#DDDDDD', '13px Verdana');
			core.fillText('ui', core.formatBigNumber(enemy.experience), 365, 62 * i + 32, '#DDDDDD', 'bold 13px Verdana');

			var expOffset = 165, line_cnt=0;
			core.fillText('ui', '攻击', 165, 62 * i + 50, '#DDDDDD', '13px Verdana');
			core.fillText('ui', core.formatBigNumber(enemy.atk), 195, 62 * i + 50, '#DDDDDD', 'bold 13px Verdana');
			expOffset = 255;
			line_cnt++;

			if (line_cnt<2) {
				core.canvas.ui.textAlign = "left";
				core.fillText('ui', '防御', expOffset, 62 * i + 50, '#DDDDDD', '13px Verdana');
				core.fillText('ui', enemy.def, expOffset + 30, 62 * i + 50, '#DDDDDD', '13px Verdana');
				line_cnt++;
			}

			var damageOffset = 281;
			if (line_cnt==1) damageOffset=326;
			if (line_cnt==2) damageOffset=361;

			core.fillText('ui', '速度', 335, 62 * i + 50, '#DDDDDD', '13px Verdana');
			core.fillText('ui', core.formatBigNumber(enemy.point), 365, 62 * i + 50, '#DDDDDD', 'bold 13px Verdana');

			var damage = enemy.damage;

			var color = '#FFFF00';
			if (damage == null) {
				damage = '无法战斗';
				color = '#FF0000';
			}
			else {
				if (damage >= core.status.hero.hp) color = '#FF0000';
				if (damage<=0) color = '#00FF00';

				damage = core.formatBigNumber(damage);
			}

			core.fillText('ui', '临界', 165, 62 * i + 68, '#DDDDDD', '13px Verdana');
			core.fillText('ui', core.formatBigNumber(enemy.critical), 195, 62 * i + 68, '#DDDDDD', 'bold 13px Verdana');
			core.fillText('ui', '减伤', 255, 62 * i + 68, '#DDDDDD', '13px Verdana');
			core.fillText('ui', core.formatBigNumber(enemy.criticalDamage), 285, 62 * i + 68, '#DDDDDD', 'bold 13px Verdana');
			
			core.canvas.ui.textAlign = "center";
			core.fillText('ui', damage, damageOffset, 62 * i + 68, color, 'bold 13px Verdana');

			if (index == start+i) {
				core.strokeRect('ui', 10, 62 * i + 13, 416-10*2,  62, '#FFD700');
			}

		}
		core.drawBoxAnimate();
		this.drawPagination(page, totalPage);
	};
	
	core.isSlimeDebuff = function() {
		return this.getFlag('slimeTurn',0) > 0;
	};
	
	core.getSlimeTurn = function() {
		return this.getFlag('slimeTurn',0);
	};
	
	core.setSlimeDebuff = function(turn,power) {
		this.setFlag('slimeTurn',turn);
		this.setFlag('slimePower',power);
	};
	
	core.getSlimePower = function(now_speed) {
		return Math.floor(this.getFlag('slimePower',0) * now_speed / 100);
	};
	
	core.setFuryDebuff = function(power) {
		this.setFlag('fury',power);
	};
	
	core.isFuryDebuff = function() {
		return this.getFlag('fury',100) < 100;
	};
	
	core.getFuryPower = function(now_speed) {
		return Math.floor(this.getFlag('fury',100) * now_speed / 100);
	};
	
	this.getAtkDesc = function(){
		var atkv = core.getStatus('atk');
		var ret = {value:atkv,debuff:false};
		if(core.isFuryDebuff()) ret.value = core.getFuryPower(ret.value);
		ret.debuff = (ret.value != atkv);
		return ret;
	};
	
	this.getDefDesc = function(){
		var defv = core.getStatus('def');
		var ret = {value:defv,debuff:false};
		if(core.isFuryDebuff()) ret.value = core.getFuryPower(ret.value);
		var intRate = Math.floor(1000-this.damageReduceRate(ret.value)*1000)/10;
		ret.debuff = (ret.value != defv);
		ret.value = ret.value + "(" + intRate + "%)";
		return ret;
	};
	
	this.getSpeedDesc = function(){
		var spdv = core.getStatus('mdef');
		var ret = {value:spdv,debuff:false};
		if(core.isSlimeDebuff()) ret.value = core.getSlimePower(ret.value);
		if(core.isFuryDebuff()) ret.value = core.getFuryPower(ret.value);
		ret.debuff = (ret.value != spdv);
		return ret;
	};
	
	this.getDefDescByValue = function(defv){
		var intRate = Math.floor(1000-this.damageReduceRate(defv)*1000)/10;
		return intRate + "%";
	};
	
	control.prototype.updateStatusBar = function () {
		core.events.checkLvUp();
		core.updateCheckBlock();
		var lvName = core.getLvName();
		core.statusBar.lv.innerHTML = lvName;
		if (/^[+-]?\d+$/.test(lvName))
			core.statusBar.lv.style.fontStyle = 'italic';
		else core.statusBar.lv.style.fontStyle = 'normal';

		var statusList = ['hpmax', 'hp', 'money', 'experience'];
		statusList.forEach(function (item) {
			core.statusBar[item].innerHTML = core.formatBigNumber(core.getStatus(item));
			core.statusBar[item].style.fontSize = "0.6em";
		});
		var desc = core.plugin.getAtkDesc();
		core.statusBar.atk.innerHTML = desc.value;
		core.statusBar.atk.style.color = desc.debuff ? '#FF80FF' : '#ffffff';
		core.statusBar.atk.style.fontSize = "0.6em";
		desc = core.plugin.getDefDesc();
		core.statusBar.def.innerHTML = desc.value;
		core.statusBar.def.style.color = desc.debuff ? '#FF80FF' : '#ffffff';
		core.statusBar.def.style.fontSize = "0.6em";
		desc = core.plugin.getSpeedDesc();
		core.statusBar.mdef.innerHTML = desc.value;
		core.statusBar.mdef.style.color = desc.debuff ? '#FF80FF' : '#ffffff';
		core.statusBar.mdef.style.fontSize = "0.6em";

		// 进阶
		if (core.flags.enableLevelUp && core.status.hero.lv<core.firstData.levelUp.length) {
			core.statusBar.up.innerHTML = core.firstData.levelUp[core.status.hero.lv].need || " ";
		}
		else core.statusBar.up.innerHTML = " ";

		var keys = ['yellowKey', 'blueKey', 'redKey'];
		keys.forEach(function (key) {
			core.statusBar[key].innerHTML = core.setTwoDigits(core.status.hero.items.keys[key]);
		});
		if(!core.plugin.slimedebuff){
		   var img=new Image();
			core.plugin.slimedebuff = img;
			core.statusBar.poison.appendChild(img);
		}
		if(core.isSlimeDebuff()){
			core.statusBar.poison.innerText = core.getSlimeTurn();
			core.statusBar.poison.style.backgroundImage = 'url('+core.statusBar.icons.lv.src+')';
			core.statusBar.poison.style.display = 'inline-block';
		}else{
			core.statusBar.poison.style.display = 'none';
		}
		if(core.isFuryDebuff()){
			core.statusBar.weak.style.backgroundImage = 'url('+core.statusBar.icons.hpmax.src+')';
			core.statusBar.weak.style.display = 'inline-block';
		}else{
			core.statusBar.weak.style.display = 'none';
		}
		core.statusBar.hard.innerHTML = core.status.hard;


		// 回放
		if (core.status.replay.replaying) {
			core.statusBar.image.book.src = core.status.replay.pausing?core.statusBar.icons.play.src:core.statusBar.icons.pause.src;
			core.statusBar.image.book.style.opacity = 1;

			core.statusBar.image.fly.src = core.statusBar.icons.stop.src;
			core.statusBar.image.fly.style.opacity = 1;

			core.statusBar.image.toolbox.src = core.statusBar.icons.rewind.src;
			core.statusBar.image.toolbox.style.opacity = 1;

			core.statusBar.image.shop.style.opacity = 0;

			core.statusBar.image.save.src = core.statusBar.icons.speedDown.src;
			core.statusBar.image.save.style.opacity = 1;

			core.statusBar.image.load.src = core.statusBar.icons.speedUp.src;
			core.statusBar.image.load.style.opacity = 1;

			core.statusBar.image.settings.style.opacity = 0;

		}
		else {
			core.statusBar.image.book.src = core.statusBar.icons.book.src;
			core.statusBar.image.book.style.opacity = 1;

			core.statusBar.image.fly.src = core.statusBar.icons.fly.src;
			core.statusBar.image.fly.style.opacity = 1;

			core.statusBar.image.toolbox.src = core.statusBar.icons.toolbox.src;
			core.statusBar.image.toolbox.style.opacity = 1;

			core.statusBar.image.shop.style.opacity = 1;

			core.statusBar.image.save.src = core.statusBar.icons.save.src;
			core.statusBar.image.save.style.opacity = 1;

			core.statusBar.image.load.src = core.statusBar.icons.load.src;
			core.statusBar.image.load.style.opacity = 1;

			core.statusBar.image.settings.src = core.statusBar.icons.settings.src;
			core.statusBar.image.settings.style.opacity = 1;
		}

		core.updateFg();
	};
	
	var formatBuffs = [core.statusBar.poison,core.statusBar.weak,core.statusBar.curse];
	formatBuffs.forEach(function(item){
		item.style.color = '#ffffff';
		item.style.textAlign = 'right';
		item.style.fontSize = '0.3em';
		item.style.backgroundPositionX = '-4px';
		item.style.backgroundPositionY = '-4px';
		item.style.marginLeft = '0px';
		item.style.display = 'none';
		item.style.width = '30px';
		item.style.height = '24px';
	});
}
    }
}