var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "itemShop": function () {





},
    "smoothCamera": function () {

	// 是否启用本插件，默认不启用
	this.__enableSmoothCamera = true;
	if (!this.__enableSmoothCamera) return;

	this.Camera = function () {

		// 下面这个变量决定本插件的开关
		// 你可以在游戏中使用core.setFlag('smoothCamera',false)来关闭本插件的功能
		// 同时也可以core.setFlag('smoothCamera',true)重新开启
		// 此项默认为true
		// 
		this.__switchName = 'smoothCamera';

		// 初始化成员变量
		this._cameraNeedRefresh = true;
		this._nowOffsetX = 0;
		this._nowOffsetY = 0;
		this._targetOffsetX = 0;
		this._targetOffsetY = 0;
		this._currentFloorId = null;

		// 重置镜头，在楼层变更时使用
		this.resetCamera = function () {
			this._targetOffsetX = core.bigmap.offsetX;
			this._targetOffsetY = core.bigmap.offsetY;
			this._nowOffsetX = this._targetOffsetX;
			this._nowOffsetY = this._targetOffsetY;
			this._cameraNeedRefresh = true;
		};

		// 设置焦点坐标，目前没有用
		this.setTarget = function (x, y) {
			this._targetOffsetX = x;
			this._targetOffsetY = y;
		};

		// 请求镜头更新
		this.requestCameraUpdate = function () {
			this._cameraNeedRefresh = true;
		};

		// 更新焦点坐标，目前仅根据大地图偏移决定
		this.updateTargetPosition = function () {
			this._targetOffsetX = core.bigmap.offsetX;
			this._targetOffsetY = core.bigmap.offsetY;
		};

		// 更新额外的刷新条件，即镜头未指向焦点时
		this.updateRefreshFlag = function () {
			if (this._nowOffsetX != this._targetOffsetX || this._nowOffsetY != this._targetOffsetY) {
				this._cameraNeedRefresh = true;
			}
		};

		// 判断是否禁止了弹性滚动
		this.canDirectMove = function () {
			return !core.getFlag(this.__switchName, true);
		};

		// 更新镜头坐标
		this.updateCameraPosition = function () {
			if (this._cameraNeedRefresh) {
				this._cameraNeedRefresh = false;
				var disX = this._targetOffsetX - this._nowOffsetX;
				var disY = this._targetOffsetY - this._nowOffsetY;
				if (Math.abs(disX) <= 2 && Math.abs(disY) <= 2 || this.canDirectMove()) {
					this._nowOffsetX = this._targetOffsetX;
					this._nowOffsetY = this._targetOffsetY;
				} else {
					this._nowOffsetX += disX / 10;
					this._nowOffsetY += disY / 10;
				}
				var x = -Math.floor(this._nowOffsetX);
				var y = -Math.floor(this._nowOffsetY);
				core.bigmap.canvas.forEach(function (cn) {
					core.control.setGameCanvasTranslate(cn, x, y);
				});
				core.relocateCanvas('route', core.status.automaticRoute.offsetX + x, core.status.automaticRoute.offsetY + y);
				core.setGameCanvasTranslate('hero', x + this._targetOffsetX, y + this._targetOffsetY);
			}
		};

		// 更新逻辑主体
		this.update = function () {
			this.updateTargetPosition();
			this.updateRefreshFlag();
			this.updateCameraPosition();
		};
	};

	// 其实只注释了最后一行，只能这样了
	control.drawHero = function (status, offset) {
		if (!core.isPlaying() || !core.status.floorId || core.status.gameOver) return;
		var x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y'),
			direction = core.getHeroLoc('direction');
		status = status || 'stop';
		offset = offset || 0;
		var way = core.utils.scan[direction];
		var dx = way.x,
			dy = way.y,
			offsetX = dx * offset,
			offsetY = dy * offset;
		core.bigmap.offsetX = core.clamp((x - core.__HALF_SIZE__) * 32 + offsetX, 0, 32 * core.bigmap.width - core.__PIXELS__);
		core.bigmap.offsetY = core.clamp((y - core.__HALF_SIZE__) * 32 + offsetY, 0, 32 * core.bigmap.height - core.__PIXELS__);
		core.clearAutomaticRouteNode(x + dx, y + dy);
		core.clearMap('hero');

		if (!core.hasFlag('hideHero')) {
			this._drawHero_getDrawObjs(direction, x, y, status, offset).forEach(function (block) {
				core.drawImage('hero', block.img, block.heroIcon[block.status] * block.width,
					block.heroIcon.loc * block.height, block.width, block.height,
					block.posx + (32 - block.width) / 2, block.posy + 32 - block.height, block.width, block.height);
			});
		}

		core.control.updateViewport();
		//core.setGameCanvasTranslate('hero', 0, 0);
	};

	// 复写转发
	core.drawHero = function (status, offset) {
		return core.control.drawHero(status, offset);
	};

	// 创建摄像机对象
	this.camera = new this.Camera();

	// 帧事件 更新摄像机
	this.updateCameraEx = function () {
		this.camera.update();
	};

	// 代理原本的镜头事件
	control.updateViewport = function () {
		core.plugin.camera.requestCameraUpdate();
	};

	// 更变楼层的行为追加，重置镜头
	events.prototype.changingFloor = function (floorId, heroLoc, fromLoad) {
		this.eventdata.changingFloor(floorId, heroLoc, fromLoad);
		core.plugin.camera.resetCamera();
	};

	// 注册帧事件
	core.registerAnimationFrame('smoothCameraFlash', true, this.updateCameraEx.bind(this));
},
    "checkMonster": function () {
	// 漏怪检测，来自于《圣王魔塔》，有少量修改
	// 调用样例：core.plugin.checkMonster(["MT641","MT6700417"]);
	this.checkMonster = function (floorIds) {
		var remainMonsterInfo = [];
		var cnt = 0;
		for (var i in floorIds) {
			var floorId = floorIds[i];
			if (core.enemys.getCurrentEnemys(floorId).length > 0) {
				// 遍历每个图块
				core.status.maps[floorId].blocks.forEach(function (block) {
					if (core.isset(block.event) && !block.disable) {
						// 获得该图块的ID
						var id = block.event.id,
							enemy = core.material.enemys[id];
						// 检查是不是怪物
						if (core.isset(enemy)) {
							cnt++;
							if (enemy.name in remainMonsterInfo)
								remainMonsterInfo[enemy.name]++;
							else
								remainMonsterInfo[enemy.name] = 1;
						}
					}
				});
			}
		}
		core.setFlag("remainMonsterInfo", this.printMonsterInfo(remainMonsterInfo));
		core.setFlag("remainMonsterCount", cnt);
		return;
	};

	this.printMonsterInfo = function (info) {
		var print = "";
		for (var x in info) {
			var y = info[x];
			print += "\n" + x + " * " + y;
		}
		return print;
	};
},
    "popupDamage": function () {
	// 在此增加新插件
	/*
	 * 把下面的脚本放到
	 * 编辑器→插件编写→新建→给插件起名(popupDamage)
	 * 确认后刷新页面（注意保存）在新增的插件内插入以下代码
	 * （插件默认会编写开头和结尾，把插件粘贴到中间）
	 * 例：
	 * function () {
		这里粘贴插件
	  }
	*/
	if (main.replayChecking) return;
	// 版本控制
	if (!core.registerAnimationFrame) {
		throw new Error('require 2.6.1 or higher version');
	}

	window.Fux2 = window.Fux2 || {};
	Fux2.MorePerform = Fux2.MorePerform || {};

	Fux2.MorePerform.ShowDamagePop = {};
	Fux2.MorePerform.ShowDamagePop.version = 1.0;

	Fux2.MorePerform.ShowDamagePop.AllPopingCanvas = [];

	// 每帧的处理
	Fux2.MorePerform.ShowDamagePop.Update = function () {
		this.AllPopingCanvas = this.AllPopingCanvas.filter(function (spr) {
			spr.update();
			return spr.isAlive();
		});
		if (!this.AllPopingCanvas.length) PopSprite._count = 0;
	};

	// 弹出伤害气泡
	Fux2.MorePerform.ShowDamagePop.PopDamage = function (damageValue) {
		if (damageValue) {
			var poper = new PopSprite(core.getHeroLoc('x') * 32, core.getHeroLoc('y') * 32, damageValue);
			Fux2.MorePerform.ShowDamagePop.AllPopingCanvas.push(poper);
		}
	};

	// 战斗发生前后记录生命值并处理
	Fux2.MorePerform.ShowDamagePop.OnBattle = core.events.battle;
	core.events.battle = function () {
		var hpBeforeBattle = core.status.hero.hp;
		Fux2.MorePerform.ShowDamagePop.OnBattle.apply(core.events, arguments);
		Fux2.MorePerform.ShowDamagePop.PopDamage(Math.floor(core.status.hero.hp - hpBeforeBattle));
	};

	// 注册每帧事件
	core.registerAnimationFrame("ShowDamagePop", true, Fux2.MorePerform.ShowDamagePop.Update.bind(Fux2.MorePerform.ShowDamagePop));

	// 弹出精灵类
	function PopSprite() {
		this.initialize.apply(this, arguments);
	}

	PopSprite.prototype = Object.create(Object.prototype);
	PopSprite.prototype.constructor = PopSprite;

	// 常量
	PopSprite._count = 0;
	PopSprite._baseZOrder = 50;
	PopSprite._floorDis = 20;
	PopSprite._font = '12px 宋体';
	PopSprite._damageColor = '#FFFFFF';
	PopSprite._healColor = '#22FF44';
	PopSprite._outLineColor = '#000000';
	PopSprite._maxLife = 180;

	// 初始化
	PopSprite.prototype.initialize = function (x, y, damage) {
		this._x = x;
		this._y = y;
		this._damage = damage;
		this.initAllMembers();
		this.requestCanvas();
	};

	// 自更新
	PopSprite.prototype.update = function () {
		if (this._timer < PopSprite._maxLife) {
			this._x += this._vx;
			this._y += this._vy;
			this._vy += this._gravity;
			if (this._y >= this._floorY) {
				this._y = this._floorY;
				this._vy *= -0.75;
			}
			core.relocateCanvas(this._symbol, this._x, this._y);
			core.setOpacity(this._symbol, 1 - this._timer / PopSprite._maxLife);
		} else {
			this.dispose();
		}
		this._timer++;
	};

	// 申请并描绘canvas
	PopSprite.prototype.requestCanvas = function () {
		core.createCanvas(this._symbol, this._x, this._y, this._width, this._height, this._z);
		var canvas = core.ui.getContextByName(this._symbol);
		canvas.font = PopSprite._font;
		canvas.fillStyle = this._damage > 0 ? PopSprite._healColor : PopSprite._damageColor;
		canvas.strokeStyle = PopSprite._outLineColor;
		canvas.strokeText(this._text, 2, this._height);
		canvas.fillText(this._text, 2, this._height);
	};

	// 初始化所有成员变量
	PopSprite.prototype.initAllMembers = function () {
		this._text = String(this._damage);
		var uiContext = core.ui.getContextByName('ui');
		uiContext.font = PopSprite._font;
		var textRect = uiContext.measureText(this._text);
		this._width = Math.round(textRect.width + 4);
		this._height = 16;
		this._z = PopSprite._baseZOrder + PopSprite._count;
		this._symbol = 'popSprite' + PopSprite._count++;
		this._alive = true;
		this._vx = -2 + Math.random() * 4;
		this._vy = -3 - Math.random() * 4;
		this._gravity = 0.5;
		this._floorY = this._y + PopSprite._floorDis;
		this._timer = 0;
	};

	// 判断是否存活
	PopSprite.prototype.isAlive = function () {
		return this._alive;
	};

	// 释放
	PopSprite.prototype.dispose = function () {
		this._alive = false;
		core.deleteCanvas(this._symbol);
	};
},
    "yuanjiaobook": function () {
	// 在此增加新插件
	//在此设置值opacity，如果值为0，则默认样式，如果不为0，则为透明度
	core.plugin.opacity = 0.8;
	if (core.plugin.opacity) {
		core.plugin.fillStyle = "rgba(0,0,0," + core.plugin.opacity + ")";
	}
	//清晰度调整  不喜欢注释掉就行了
	var getPixelRatio = function (context) {
		var backingStore = context.backingStorePixelRatio ||
			context.webkitBackingStorePixelRatio ||
			context.mozBackingStorePixelRatio ||
			context.msBackingStorePixelRatio ||
			context.oBackingStorePixelRatio ||
			context.backingStorePixelRatio || 1;
		return (window.devicePixelRatio || 1) / backingStore;
	};
	var ratio = getPixelRatio(core.canvas.ui);
	core.plugin.ratio = ratio;
	var ctx = ['ui'];
	ctx.forEach(function (e) {
		core.canvas[e].canvas.width = 416 * ratio;
		core.canvas[e].canvas.height = 416 * ratio;
		core.canvas[e].scale(ratio, ratio);
	})
	//
	//绘制圆角 矩形 抄自：https://blog.csdn.net/xutongbao/article/details/82786929
	core.plugin.drawRoundRectPath = function (cxt, width, height, radius) {
		cxt.beginPath(0);
		//从右下角顺时针绘制，弧度从0到1/2PI  
		cxt.arc(width - radius, height - radius, radius, 0, Math.PI / 2);
		//矩形下边线  
		cxt.lineTo(radius, height);
		//左下角圆弧，弧度从1/2PI到PI  
		cxt.arc(radius, height - radius, radius, Math.PI / 2, Math.PI);

		//矩形左边线  
		cxt.lineTo(0, radius);

		//左上角圆弧，弧度从PI到3/2PI  
		cxt.arc(radius, radius, radius, Math.PI, Math.PI * 3 / 2);

		//上边线  
		cxt.lineTo(width - radius, 0);

		//右上角圆弧  
		cxt.arc(width - radius, radius, radius, Math.PI * 3 / 2, Math.PI * 2);

		//右边线  
		cxt.lineTo(width, height - radius);
		cxt.closePath();
	}
	core.plugin.strokeRoundRect = function (cxt, x, y, width, height, radius, /*optional*/ lineWidth, /*optional*/ strokeColor) {
		//圆的直径必然要小于矩形的宽高          
		if (2 * radius > width || 2 * radius > height) {
			return false;
		}

		cxt.save();
		cxt.translate(x, y);
		//绘制圆角矩形的各个边  
		core.plugin.drawRoundRectPath(cxt, width, height, radius);
		cxt.lineWidth = lineWidth || 2; //若是给定了值就用给定的值否则给予默认值2  
		cxt.strokeStyle = strokeColor || "#000";
		cxt.stroke();
		cxt.restore();
	}
	core.plugin.fillRoundRect = function (cxt, x, y, width, height, radius, /*optional*/ fillColor) {
		//圆的直径必然要小于矩形的宽高          
		if (2 * radius > width || 2 * radius > height) {
			return false;
		}
		cxt.save();
		cxt.translate(x, y);
		//绘制圆角矩形的各个边  
		core.plugin.drawRoundRectPath(cxt, width, height, radius);
		cxt.fillStyle = fillColor || "#000"; //若是给定了值就用给定的值否则给予默认值  
		cxt.fill();
		cxt.restore();
	}
	//绘制圆角存读档
	core.plugin.fillImageRoundRect = function (cxt, x, y, width, height, radius, /*optional*/ image, sx, sy, swidth, sheight) {
		//圆的直径必然要小于矩形的宽高          
		if (2 * radius > width || 2 * radius > height) {
			return false;
		}
		cxt.fillStyle = '#000000';
		//不弄1和2的话  存档边缘显示有一条比较淡的白线
		cxt.fillRect(x - 1, y - 1, width + 2, height + 2);
		cxt.save();
		cxt.translate(x, y);
		//绘制圆角矩形的各个边  
		core.plugin.drawRoundRectPath(cxt, width, height, radius);
		//cxt.fillStyle = fillColor || "#000"; //若是给定了值就用给定的值否则给予默认值  
		//cxt.fill();
		cxt.clip();
		cxt.drawImage(image, sx, sy, swidth, sheight, 0, 0, width, height);
		cxt.restore();
	}
	//想要全局的strokeLine都为圆角 取消注释，但可能图形出现比较丑（图形不是圆角，而图形的strokeLine为圆角）的情况
	/*core.ui.strokeRect = function (name, x, y, width, height, style, lineWidth) {
		if (style) core.setStrokeStyle(name, style);
		if (lineWidth) core.setLineWidth(name, lineWidth);
		var ctx = this.getContextByName(name);
		//if (ctx) ctx.strokeRect(x, y, width, height);
		//改为了圆角
		//change
		if (ctx) core.plugin.strokeRoundRect(ctx,x,y,width,height,Math.floor(height/5),lineWidth/2,style);
	};*/
	core.plugin.myStrokeRect = function (name, x, y, width, height, style, lineWidth) {
		if (style) core.setStrokeStyle(name, style);
		if (lineWidth) core.setLineWidth(name, lineWidth);
		var ctx = core.ui.getContextByName(name);
		//if (ctx) ctx.strokeRect(x, y, width, height);
		//改为了圆角
		//change
		if (ctx) core.plugin.strokeRoundRect(ctx, x, y, width, height, Math.floor(Math.min(width, height) / 5), lineWidth / 2, style);
	};
	core.ui._drawBook_drawOne = function (floorId, index, enemy, pageinfo, selected) {
		// --- 区域规划：每个区域总高度默认为62，宽度为 PIXEL
		var top = pageinfo.per_height * index + pageinfo.padding_top; // 最上面margin默认是12px
		// 横向规划：
		// 22 + 42 = 64 是头像框
		this._drawBook_drawBox(index, enemy, top, pageinfo);
		// 剩余 PIXEL - 64 的宽度，按照 10 : 9 : 8 : 8 的比例划分
		var left = 64,
			total_width = this.PIXEL - left;
		var name_width = total_width * 10 / 35;
		this._drawBook_drawName(index, enemy, top, left, name_width);
		this._drawBook_drawContent(index, enemy, top, left + name_width);
		if (selected)
			//change
			core.plugin.myStrokeRect('ui', 10, top + 1, this.PIXEL - 10 * 2, pageinfo.per_height, '#FFD700');
	}
	core.ui.drawBook = function (index) {
		var floorId = core.floorIds[(core.status.event.ui || {}).index] || core.status.floorId;
		var enemys = core.enemys.getCurrentEnemys(floorId);
		core.clearUI();
		core.clearMap('data');
		// 生成groundPattern
		if (core.plugin.opacity) {
			//ctx.fillStyle=core.plugin.fillStyle;
			core.fillRect('ui', 0, 0, 416, 416, core.plugin.fillStyle);
		} else {
			core.maps.generateGroundPattern(floorId);
			this._drawBook_drawBackground();
		}
		core.setAlpha('ui', 1);
		if (enemys.length == 0) {
			core.setTextAlign('ui', 'center');
			core.fillText('ui', "本层无怪物", this.HPIXEL, this.HPIXEL + 14, '#999999', this._buildFont(50, true));
			core.fillText('ui', '返回游戏', this.PIXEL - 46, this.PIXEL - 13, '#DDDDDD', this._buildFont(15, true));
			return;
		}

		index = core.clamp(index, 0, enemys.length - 1);
		core.status.event.data = index;
		var pageinfo = this._drawBook_pageinfo();
		var perpage = pageinfo.per_page,
			page = parseInt(index / perpage) + 1,
			totalPage = Math.ceil(enemys.length / perpage);

		var start = (page - 1) * perpage;
		enemys = enemys.slice(start, page * perpage);

		for (var i = 0; i < enemys.length; i++)
			this._drawBook_drawOne(floorId, i, enemys[i], pageinfo, index == start + i);

		core.drawBoxAnimate();
		this.drawPagination(page, totalPage);
		core.setTextAlign('ui', 'center');
		core.fillText('ui', '返回游戏', this.PIXEL - 46, this.PIXEL - 13, '#DDDDDD', this._buildFont(15, true));
	}
	core.ui._drawBook_drawBox = function (index, enemy, top, pageinfo) {
		// 横向：22+42；纵向：10 + 42 + 10（正好居中）；内部图像 32x32
		var border_top = top + (pageinfo.per_height - 42) / 2,
			border_left = 22;
		var img_top = border_top + 5,
			img_left = border_left + 5;
		var blockInfo = core.getBlockInfo(enemy.id);
		if (!core.plugin.opacity) {
			core.plugin.fillRoundRect(core.canvas.ui, border_left, border_top, 42, 42, Math.floor(42 / 5), core.material.groundPattern);
			core.plugin.fillStyle = core.material.groundPattern;
		}
		core.plugin.myStrokeRect('ui', 22, border_top, 42, 42, '#DDDDDD', 2);
		core.status.boxAnimateObjs.push({
			'bgx': border_left,
			'bgy': border_top,
			'bgWidth': 42,
			'bgHeight': 42,
			'x': img_left,
			'y': img_top,
			'height': 32,
			'animate': blockInfo.animate,
			'image': blockInfo.image,
			'pos': blockInfo.posY * blockInfo.height
		});
	};
	if (!core.plugin.opacity) {
		core.maps.drawBoxAnimate = function () {
			core.status.boxAnimateObjs.forEach(function (obj) {
				core.clearMap('ui', obj.x, obj.y, 32, obj.height);
				core.fillRect('ui', obj.x, obj.y, 32, obj.height, core.material.groundPattern);
				core.drawImage('ui', obj.image, core.status.globalAnimateStatus % obj.animate * 32, obj.pos,
					32, obj.height, obj.x, obj.y, 32, obj.height);
			});
		}
	} else {
		core.maps.drawBoxAnimate = function () {
			core.status.boxAnimateObjs.forEach(function (obj) {
				core.clearMap('ui', obj.x, obj.y, 32, obj.height);
				core.fillRect('ui', obj.x, obj.y, 32, obj.height, core.plugin.fillStyle);
				//core.fillRect('ui', obj.bgx, obj.bgy, obj.bgWidth, obj.bgHeight, core.plugin.fillStyle);
				//core.plugin.myStrokeRect('ui', 22, obj.bgy+2, 42, 42, '#DDDDDD', 2);
				core.drawImage('ui', obj.image, core.status.globalAnimateStatus % obj.animate * 32, obj.pos,
					32, obj.height, obj.x, obj.y, 32, obj.height);
			});
		}
	}
	ui.prototype.drawBookDetail = function (index) {
		var info = this._drawBookDetail_getInfo(index),
			enemy = info[0];
		if (!enemy) return;
		var content = info[1].join("\n");
		core.status.event.id = 'book-detail';
		clearInterval(core.interval.tipAnimate);
		core.clearMap('data');

		var left = 10,
			width = this.PIXEL - 2 * left,
			right = left + width;
		var content_left = left + 25,
			validWidth = right - content_left - 13;
		var contents = core.splitLines("data", content, validWidth, this._buildFont(16, false));
		var height = Math.max(24 * contents.length + 55, 80),
			top = (this.PIXEL - height) / 2,
			bottom = top + height;

		core.setAlpha('data', 0.9);
		core.plugin.fillRoundRect(core.canvas.data, left, top, width, height, Math.floor(Math.min(height, width) / 5), '#000000');
		core.setAlpha('data', 1);
		core.myStrokeRect('data', left - 1, top - 1, width + 1, height + 1,
			core.status.globalAttribute.borderColor, 2);

		this._drawBookDetail_drawContent(enemy, contents, { top: top, content_left: content_left, bottom: bottom });
	}
},
    "Weather": function () {
	// 在此增加新插件
	// wind值 可以调整云的方向和速度，可以随时调整core.plugin.wind
	this.wind = 2;
	//阳光的透明度
	this.sunOpacity = 0.4;
	//云的透明度
	this.cloudOpacity = 0.3;
	/* 
	阳光的使用
	core.setFlag('__curtain__','sun');
	core.setSun();
	取消
	core.setFlag('__curtain__',null);
	core.setCurtain();
	云的使用
	core.setFlag('__weather__',['cloud',1]);
	core.setWeather('cloud');
	取消
	core.setFlag('__weather__',null);
	core.setWeather();
	*/
	this.setSun = function (alpha) {
		var curtain = core.getFlag('__curtain__', null);
		if (curtain == 'sun') {
			var image = core.material.images.images['light1.png'];
			core.canvas.curtain.globalAlpha = alpha || core.plugin.sunOpacity;
			core.canvas.curtain.drawImage(image, 0, 0, 416, 416, 0, 0, 416, 416);
			core.canvas.curtain.globalAlpha = 1;
		}
	}
	control.prototype.setCurtain = function (color, time, callback) {
		if (time == null) time = 750;
		if (time <= 0) time = 0;
		if (!core.status.curtainColor)
			core.status.curtainColor = [0, 0, 0, 0];
		if (!color) color = [0, 0, 0, 0];
		if (color[3] == null) color[3] = 1;
		color[3] = core.clamp(color[3], 0, 1);

		if (time == 0) {
			// 直接变色
			core.clearMap('curtain');
			core.fillRect('curtain', 0, 0, core.__PIXELS__, core.__PIXELS__, core.arrayToRGBA(color));
			core.status.curtainColor = color;
			//change
			core.plugin.setSun(core.plugin.sunOpacity);
			if (callback) callback();
			return;
		}

		this._setCurtain_animate(core.status.curtainColor, color, time, callback);
	}

	control.prototype._setCurtain_animate = function (nowColor, color, time, callback) {
		time /= Math.max(core.status.replay.speed, 1)
		var per_time = 10,
			step = parseInt(time / per_time);
		var all = step;
		var opacity = core.plugin.sunOpacity;
		var animate = setInterval(function () {
			nowColor = [
				(nowColor[0] * (step - 1) + color[0]) / step,
				(nowColor[1] * (step - 1) + color[1]) / step,
				(nowColor[2] * (step - 1) + color[2]) / step,
				(nowColor[3] * (step - 1) + color[3]) / step,
			];
			core.clearMap('curtain');
			core.fillRect('curtain', 0, 0, core.__PIXELS__, core.__PIXELS__, core.arrayToRGBA(nowColor));
			//change
			core.plugin.setSun(opacity * (all - step) / all);
			step--;
			if (step <= 0) {
				delete core.animateFrame.asyncId[animate];
				clearInterval(animate);
				core.status.curtainColor = color;
				if (core.isset(callback)) callback();
			}
		}, per_time);

		core.animateFrame.asyncId[animate] = true;
	}
	events.prototype.changingFloor = function (floorId, heroLoc, fromLoad) {
		this.eventdata.changingFloor(floorId, heroLoc, fromLoad);
		var time;
		if (fromLoad) time = 0;
		var color = core.getFlag('__color__', null);
		if (!color && core.status.maps[floorId].color)
			color = core.status.maps[floorId].color;
		core.clearMap('curtain');
		core.status.curtainColor = color;
		core.setCurtain(color, time);
	}
	core.plugin.randomNum = function (minNum, maxNum) {
		return parseInt(Math.random() * (maxNum - minNum + 1) + minNum, 10);
	}
	control.prototype.setWeather = function (type, level) {
		// 非雨雪
		if (type == null) {
			core.deleteCanvas('weather')
			core.animateFrame.weather.type = null;
			core.animateFrame.weather.nodes = [];
			return;
		}
		if (type == 'cloud') {
			if (!core.dymCanvas.weather) core.createCanvas('weather', 0, 0, core.__PIXELS__, core.__PIXELS__, 80);
			core.animateFrame.weather.type = type;
			if (core.animateFrame.weather.nodes.length == 1) return;
			var mv = core.plugin.randomNum(0, 832);
			core.animateFrame.weather.nodes = [mv];
			return;
		};
		// 当前天气：则忽略
		if (type == core.animateFrame.weather.type && level == null) return;
		level = core.clamp(parseInt(level) || 5, 1, 10);
		level *= parseInt(20 * core.bigmap.width * core.bigmap.height / (core.__SIZE__ * core.__SIZE__));

		// 计算当前的宽高
		core.createCanvas('weather', 0, 0, core.__PIXELS__, core.__PIXELS__, 80);
		core.animateFrame.weather.type = type;
		core.animateFrame.weather.nodes = [];
		this._setWeather_createNodes(type, level);
	}
	control.prototype._animationFrame_weather_cloud = function () {
		var image = core.material.images.images['cloud1.png'];
		var ctx = core.dymCanvas.weather;
		var dv = core.plugin.wind;
		var width = image.width;
		var height = image.height;
		//var mv=0;
		var mv = core.animateFrame.weather.nodes[0];
		ctx.globalAlpha = core.plugin.cloudOpacity;
		ctx.clearRect(0, 0, 416, 416);
		ctx.drawImage(image, width - mv, 0, mv, height, 0, 0, mv, height);
		if (mv <= 416) {
			ctx.drawImage(image, 0, 0, 416 - mv, height, mv, 0, 416 - mv, height);
		}
		core.animateFrame.weather.nodes[0] += dv;
		if (mv > width) core.animateFrame.weather.nodes[0] = 0;
		if (mv < 0) core.animateFrame.weather.nodes[0] = width;
	}
	//不设置的话   自动读档会闪一下
	ui.prototype.deleteAllCanvas = function () {
		Object.keys(core.dymCanvas).forEach(function (name) {
			if (!(name == 'weather' && flags.__weather__)) {
				core.dom.gameDraw.removeChild(core.dymCanvas[name].canvas);
				delete core.dymCanvas[name];
			}
		});
	}
},
    "changeHero": function () {
	// Step 1：每个角色弄一张行走图，并在全塔属性中的images中注册。
	// Step 2: 覆盖楼传事件，这样可以通过点工具栏的楼层传送按钮来切换角色。当然你也完全可以自己写一个道具，或自定义快捷键来进行绑定。
	// Step 3：将下述代码粘贴到插件中
	// ---------------------------------------------------
	// 所有需要保存的内容；这些保存的内容不会多角色共用，在切换时会进行恢复。
	// 你也可以自行新增或删除，比如不共用金币则可以加上"money"的初始化，不共用道具则可以加上"items"的初始化，
	// 多角色共用hp的话则删除hp，等等。总之，不共用的属性都在这里进行定义就好。
	var hero1 = { // 1号勇士（默认的是0号）
		"floorId": "MT4", // 该角色楼层ID
		"icon": "hero1.png", // 角色的行走图名称
		"name": "Lisa",
		"lv": 1,
		"hp": 1000,
		"atk": 10,
		"def": 10,
		"mdef": 0,
		"experience": 0,
		"loc": { "x": 6, "y": 12, "direction": "up" },
		"mana": 0,
		// 如果装备不共用就将下面这句话取消注释
		"equipment": [],
		// 如果道具不共用就将下面这句话取消注释
		"items": { "keys": { "yellowKey": 0, "blueKey": 0, "redKey": 0 }, "tools": {}, "constants": {} },
	}
	// 也可以类似新增其他勇士
	// var hero2 = { ...

	var heroCount = 2; // 包含默认的在内总共多少个勇士，该值需手动修改。

	// 初始化该勇士
	this.initHeros = function () {
		core.status.hero.icon = "hero.png";
		core.setFlag("hero1", core.clone(hero1)); // 将属性值存到变量中
		// core.setFlag("hero2", core.clone(hero2)); // 更多的勇士...
	}

	// 切换勇士
	this.changeHero = function (toHeroId) {
		var currHeroId = core.getFlag("heroId", 0); // 获得当前角色ID
		if (!core.isset(toHeroId)) {
			toHeroId = (currHeroId + 1) % heroCount;
		}
		if (currHeroId == toHeroId) return;

		var saveList = Object.keys(hero1);

		// 保存当前内容
		var toSave = {};
		saveList.forEach(function (name) {
			if (name == 'floorId') toSave[name] = core.status.floorId; // 楼层单独设置
			else toSave[name] = core.clone(core.status.hero[name]); // 使用core.clone()来创建新对象
		})

		core.setFlag("hero" + currHeroId, toSave); // 将当前角色信息进行保存
		var data = core.getFlag("hero" + toHeroId); // 获得要切换的角色保存内容

		// 设置角色的属性值
		saveList.forEach(function (name) {
			if (name != 'floorId')
				core.status.hero[name] = core.clone(data[name]);
		})

		// 插入事件：改变角色行走图并进行楼层切换
		core.insertAction([
			{ "type": "setHeroIcon", "name": data.icon || "hero.png" }, // 改变行走图
			{
				"type": "changeFloor",
				"floorId": data.floorId,
				"loc": [data.loc.x, data.loc.y],
				"direction": data.loc.direction,
				"time": 0
			} // 楼层切换事件
		])
		core.setFlag("heroId", toHeroId); // 保存切换到的角色ID
	}
	// ---------------------------------------------------
	// Step 4: 在脚本编辑 - setInitData中加上 core.plugin.initHeros() 来初始化新勇士。
	// Step 5: 如果需要切换角色（包括事件、道具或者快捷键等），可以直接调用自定义JS脚本：`core.plugin.changeHero();`进行切换。也可以指定参数调用`core.plugin.changeHero(1)`来切换到某个具体的勇士上。
},
    "UI": function () {
	//对话框和怪物手册透明度
	this.opacity = 0.8;
	//对话字符的间距
	this.fontInterval = 2;
	//是否显示border  为1表示显示，0表示不显示
	this.drawBorder = 0;
	//别看很多，主要还是复写的多，改的并不多...
	//存在的问题 boxAnimate动画的问题（可能会有黑边或者白缝 貌似是因为canvas.scale之后再绘制会有一点问题
	//就像 先clearRect(0,0,x,y)再fillRect(0,0,x,y)会有白缝
	//对话框的三角 （直接给取消掉了
	if (core.plugin.opacity) {
		core.plugin.fillStyle = "rgba(0,0,0," + core.plugin.opacity + ")";
	}
	//清晰度调整 ui 和 伤害 显示的调整 和 字体的清晰度调整
	//（此步骤容易导致清空再绘制不能严丝合缝对齐，使boxAnimate出现白缝）
	var getPixelRatio = function (context) {
		var backingStore = context.backingStorePixelRatio ||
			context.webkitBackingStorePixelRatio ||
			context.mozBackingStorePixelRatio ||
			context.msBackingStorePixelRatio ||
			context.oBackingStorePixelRatio ||
			context.backingStorePixelRatio || 1;
		return (window.devicePixelRatio || 1) / backingStore;
	};
	var ratio = getPixelRatio(core.canvas.ui);
	core.plugin.ratio = ratio;
	var ctx = ['ui', 'damage'];
	ctx.forEach(function (e) {
		core.canvas[e].canvas.width = 416 * ratio;
		core.canvas[e].canvas.height = 416 * ratio;
		core.canvas[e].scale(ratio, ratio);
	})
	/*伤害显示清晰度的调整*/
	//切换楼层时会resizeMap，因此在此对damage图层 做处理
	maps.prototype.resizeMap = function (floorId) {
		floorId = floorId || core.status.floorId;
		if (!floorId) return;
		core.bigmap.width = core.floors[floorId].width;
		core.bigmap.height = core.floors[floorId].height;
		var cwidth = core.bigmap.width * 32;
		var cheight = core.bigmap.height * 32;
		//change
		core.bigmap.canvas.forEach(function (cn) {
			if (cn == 'damage') {
				core.canvas[cn].canvas.setAttribute("width", cwidth * core.plugin.ratio);
				core.canvas[cn].canvas.setAttribute("height", cheight * core.plugin.ratio);
				core.canvas[cn].scale(core.plugin.ratio, core.plugin.ratio);
			} else {
				core.canvas[cn].canvas.setAttribute("width", cwidth);
				core.canvas[cn].canvas.setAttribute("height", cheight);
			}
			core.canvas[cn].canvas.style.width = cwidth * core.domStyle.scale + "px";
			core.canvas[cn].canvas.style.height = cheight * core.domStyle.scale + "px";
			if (main.mode === 'editor' && editor.isMobile) {
				core.canvas[cn].canvas.style.width = core.bigmap.width * 32 / core.__PIXELS__ * 96 + "vw";
				core.canvas[cn].canvas.style.height = core.bigmap.height * 32 / core.__PIXELS__ * 96 + "vw";
			}
		});
	}
	//填充描边也改了一下，觉得这个好看一点
	ui.prototype.fillBoldText = function (name, text, x, y, style, font) {
		var ctx = this.getContextByName(name);
		if (!ctx) return;
		if (font) ctx.font = font;
		if (!style) style = ctx.fillStyle;
		if (style instanceof Array) style = core.arrayToRGBA(style);
		ctx.lineWidth = 2;
		//ctx.fillStyle = '#000000';
		//ctx.fillText(text, x-1, y-1);
		//ctx.fillText(text, x-1, y+1);
		//ctx.fillText(text, x+1, y-1);
		//ctx.fillText(text, x+1, y+1);
		ctx.strokeStyle = "#000000";
		ctx.strokeText(text, x, y);
		ctx.fillStyle = style;
		ctx.fillText(text, x, y);
	}
	/*UI显示清晰度的调整*/
	//因为ui同比放大 ，浏览地图显示过小 因此在此改动
	maps.prototype._drawThumbnail_drawTempCanvas = function (floorId, blocks, options) {
		blocks = blocks || core.status.maps[floorId].blocks;
		options = options || {}

		var width = core.floors[floorId].width;
		var height = core.floors[floorId].height;
		// 绘制到tempCanvas上面
		var tempCanvas = core.bigmap.tempCanvas;
		var tempWidth = width * 32,
			tempHeight = height * 32;
		//change

		tempCanvas.canvas.width = tempWidth;
		tempCanvas.canvas.height = tempHeight;
		tempCanvas.clearRect(0, 0, tempWidth, tempHeight);

		// --- 暂存 flags
		var hasHero = core.status.hero != null,
			flags = null;
		if (options.flags) {
			if (!hasHero) core.status.hero = {};
			flags = core.status.hero.flags;
			core.status.hero.flags = options.flags;
		}

		this._drawThumbnail_realDrawTempCanvas(floorId, blocks, options, tempCanvas);

		// --- 恢复 flags
		if (!hasHero) delete core.status.hero;
		else if (flags != null) core.status.hero.flags = flags;
	}
	//取消了粗体  清晰度调整之后粗体不太好看，因此取消掉
	ui.prototype._buildFont = function (fontSize, bold, italic) {
		var textAttribute = core.status.textAttribute || core.initStatus.textAttribute,
			globalAttribute = core.status.globalAttribute || core.initStatus.globalAttribute;
		if (bold == null) bold = textAttribute.bold;
		//取消了粗体
		//change
		return (bold ? "" : "") + (italic ? "italic " : "") + (fontSize || textAttribute.textfont) + "px " + globalAttribute.font;
	}
	/*字体清晰度的调整*/
	///字体的调整  字体绘制到临时画布时  将临时画布扩大化处理  增加字符间距变量
	ui.prototype.drawTextContent = function (ctx, content, config) {
		ctx = core.getContextByName(ctx);
		// 设置默认配置项
		var textAttribute = core.status.textAttribute || core.initStatus.textAttribute;
		config = core.clone(config || {});
		config.left = config.left || 0;
		config.right = config.left + (config.maxWidth == null ? (ctx != null ? ctx.canvas.width : core.__PIXELS__) : config.maxWidth)
		config.top = config.top || 0;
		config.color = config.color || textAttribute.text;
		if (config.color instanceof Array) config.color = core.arrayToRGBA(config.color);
		if (config.bold == null) config.bold = textAttribute.bold;
		config.italic = false;
		config.align = config.align || textAttribute.align || "left";
		config.fontSize = config.fontSize || textAttribute.textfont;
		config.lineHeight = config.lineHeight || (config.fontSize * 1.3);
		config.time = config.time || 0;

		config.index = 0;
		config.currcolor = config.color;
		config.currfont = config.fontSize;
		config.lineMargin = Math.max(0, config.lineHeight - config.fontSize);
		config.topMargin = parseInt(config.lineMargin / 2);
		config.lineMaxHeight = config.lineMargin + config.fontSize;
		config.offsetX = 0;
		config.offsetY = 0;
		config.line = 0;
		config.blocks = [];

		// 创建一个新的临时画布
		var tempCtx = core.createCanvas('__temp__', 0, 0, ctx == null ? 1 : ctx.canvas.width, ctx == null ? 1 : ctx.canvas.height, -1);
		//change
		var ratio = core.plugin.ratio;
		tempCtx.canvas.width = tempCtx.canvas.width * ratio;
		tempCtx.canvas.height = tempCtx.canvas.height * ratio;
		tempCtx.scale(ratio, ratio);

		tempCtx.textBaseline = 'top';
		tempCtx.font = this._buildFont(config.fontSize, config.bold, config.italic);
		tempCtx.fillStyle = config.color;
		config = this._drawTextContent_draw(ctx, tempCtx, content, config);
		core.deleteCanvas('__temp__');
		return config;
	}
	//显示时  多倍化显示
	ui.prototype._drawTextContent_draw = function (ctx, tempCtx, content, config) {
		// Step 1: 绘制到tempCtx上，并记录下图块信息
		while (this._drawTextContent_next(tempCtx, content, config));

		if (ctx == null) return config;

		// Step 2: 从tempCtx绘制到画布上
		config.index = 0;
		var _drawNext = function () {
			//change  多倍化绘制 显示不模糊
			if (config.index >= config.blocks.length) return false;
			var block = config.blocks[config.index++];
			var ratio = core.plugin.ratio;
			ctx.drawImage(tempCtx.canvas, block.left * ratio, block.top * ratio, block.width * ratio, block.height * ratio,
				config.left + block.left + block.marginLeft, config.top + block.top + block.marginTop,
				block.width, block.height);
			return true;
		}
		if (config.time == 0) {
			while (_drawNext());
		} else {
			core.status.event.interval = setInterval(function () {
				if (!_drawNext()) {
					clearInterval(core.status.event.interval);
					core.status.event.interval = null;
				}
			}, config.time);
		}

		return config;
	}
	//增加 字体间距 为core.plugin.fontInterval
	ui.prototype._drawTextContent_drawChar = function (tempCtx, content, config, ch) {
		// \n, \\n
		if (ch == '\n' || (ch == '\\' && content.charAt(config.index) == 'n')) {
			this._drawTextContent_newLine(tempCtx, config);
			if (ch == '\\') config.index++;
			return this._drawTextContent_next(tempCtx, content, config);
		}
		// \r, \\r
		if (ch == '\r' || (ch == '\\' && content.charAt(config.index) == 'r')) {
			if (ch == '\\') config.index++;
			return this._drawTextContent_changeColor(tempCtx, content, config);
		}
		if (ch == '\\') {
			var c = content.charAt(config.index);
			if (c == 'i') return this._drawTextContent_drawIcon(tempCtx, content, config);
			if (c == 'c') return this._drawTextContent_changeFont(tempCtx, content, config);
			if (c == 'd' || c == 'e') {
				config.index++;
				if (c == 'd') config.bold = !config.bold;
				if (c == 'e') config.italic = !config.italic;
				tempCtx.font = this._buildFont(config.currfont, config.bold, config.italic);
				return true;
			}
		}
		// \\e 斜体切换
		if (ch == '\\' && content.charAt(config.index) == 'e') {
			config.italic = !config.italic;
			tempCtx.font = this._buildFont(config.fontSize, config.bold, config.italic);
		}
		// 检查是不是自动换行
		//change
		var interval = core.plugin.fontInterval;
		var charwidth = core.calWidth(tempCtx, ch) + interval;
		if (config.maxWidth != null && config.offsetX + charwidth > config.maxWidth) {
			this._drawTextContent_newLine(tempCtx, config);
			config.index--;
			return this._drawTextContent_next(tempCtx, content, config);
		}
		// 输出
		var left = config.offsetX,
			top = config.offsetY + config.topMargin;
		core.fillText(tempCtx, ch, left, top);
		config.blocks.push({
			left: config.offsetX,
			top: config.offsetY,
			width: charwidth,
			height: config.currfont + config.lineMargin,
			line: config.line,
			marginLeft: 0
		});
		config.offsetX += charwidth;
		return true;
	}
	//绘制圆角 矩形 抄自：https://blog.csdn.net/xutongbao/article/details/82786929
	core.plugin.drawRoundRectPath = function (cxt, width, height, radius) {
		cxt.beginPath(0);
		//从右下角顺时针绘制，弧度从0到1/2PI  
		cxt.arc(width - radius, height - radius, radius, 0, Math.PI / 2);
		//矩形下边线  
		cxt.lineTo(radius, height);
		//左下角圆弧，弧度从1/2PI到PI  
		cxt.arc(radius, height - radius, radius, Math.PI / 2, Math.PI);
		//矩形左边线  
		cxt.lineTo(0, radius);
		//左上角圆弧，弧度从PI到3/2PI  
		cxt.arc(radius, radius, radius, Math.PI, Math.PI * 3 / 2);
		//上边线  
		cxt.lineTo(width - radius, 0);
		//右上角圆弧  
		cxt.arc(width - radius, radius, radius, Math.PI * 3 / 2, Math.PI * 2);
		//右边线  
		cxt.lineTo(width, height - radius);
		cxt.closePath();
	}
	core.plugin.strokeRoundRect = function (cxt, x, y, width, height, radius, /*optional*/ lineWidth, /*optional*/ strokeColor) {
		//圆的直径必然要小于矩形的宽高          
		if (2 * radius > width || 2 * radius > height) {
			return false;
		}

		cxt.save();
		cxt.translate(x, y);
		//绘制圆角矩形的各个边  
		core.plugin.drawRoundRectPath(cxt, width, height, radius);
		cxt.lineWidth = lineWidth || 2; //若是给定了值就用给定的值否则给予默认值2  
		cxt.strokeStyle = strokeColor || "#000";
		cxt.stroke();
		cxt.restore();
	}
	core.plugin.fillRoundRect = function (cxt, x, y, width, height, radius, /*optional*/ fillColor) {
		//圆的直径必然要小于矩形的宽高          
		if (2 * radius > width || 2 * radius > height) {
			return false;
		}
		cxt.save();
		cxt.translate(x, y);
		//绘制圆角矩形的各个边  
		core.plugin.drawRoundRectPath(cxt, width, height, radius);
		cxt.fillStyle = fillColor || "#000"; //若是给定了值就用给定的值否则给予默认值  
		cxt.fill();
		cxt.restore();
	}
	//绘制圆角存读档
	core.plugin.fillImageRoundRect = function (cxt, x, y, width, height, radius, /*optional*/ image, sx, sy, swidth, sheight) {
		//圆的直径必然要小于矩形的宽高          
		if (2 * radius > width || 2 * radius > height) {
			return false;
		}
		cxt.fillStyle = '#000000';
		//不弄1和2的话  存档边缘显示有一条比较淡的白线
		cxt.fillRect(x - 1, y - 1, width + 2, height + 2);
		cxt.save();
		cxt.translate(x, y);
		//绘制圆角矩形的各个边  
		core.plugin.drawRoundRectPath(cxt, width, height, radius);
		//cxt.fillStyle = fillColor || "#000"; //若是给定了值就用给定的值否则给予默认值  
		//cxt.fill();
		cxt.clip();
		cxt.drawImage(image, sx, sy, swidth, sheight, 0, 0, width, height);
		cxt.restore();
	}
	//想要全局的strokeLine都为圆角 取消注释，但可能图形出现比较丑（图形不是圆角，而图形的strokeLine为圆角）的情况
	core.ui.strokeRect = function (name, x, y, width, height, style, lineWidth) {
		if (style) core.setStrokeStyle(name, style);
		if (lineWidth) core.setLineWidth(name, lineWidth);
		var ctx = this.getContextByName(name);
		//if (ctx) ctx.strokeRect(x, y, width, height);
		//改为了圆角
		//change
		if (ctx) core.plugin.strokeRoundRect(ctx, x, y, width, height, Math.floor(Math.min(width, height) / 5), lineWidth / 2, style);
	};
	core.ui.drawBook = function (index) {
		var floorId = core.floorIds[(core.status.event.ui || {}).index] || core.status.floorId;
		var enemys = core.enemys.getCurrentEnemys(floorId);
		core.clearUI();
		core.clearMap('data');
		// 生成groundPattern
		if (core.plugin.opacity) {
			core.fillRect('ui', 0, 0, 416, 416, core.plugin.fillStyle);
		} else {
			core.maps.generateGroundPattern(floorId);
			this._drawBook_drawBackground();
		}
		core.setAlpha('ui', 1);
		if (enemys.length == 0) {
			core.setTextAlign('ui', 'center');
			core.fillText('ui', "本区无怪物", this.HPIXEL, this.HPIXEL + 14, '#999999', this._buildFont(50, true));
			core.fillText('ui', '返回游戏', this.PIXEL - 46, this.PIXEL - 13, '#DDDDDD', this._buildFont(15, true));
			return;
		}

		index = core.clamp(index, 0, enemys.length - 1);
		core.status.event.data = index;
		var pageinfo = this._drawBook_pageinfo();
		var perpage = pageinfo.per_page,
			page = parseInt(index / perpage) + 1,
			totalPage = Math.ceil(enemys.length / perpage);

		var start = (page - 1) * perpage;
		enemys = enemys.slice(start, page * perpage);

		for (var i = 0; i < enemys.length; i++)
			this._drawBook_drawOne(floorId, i, enemys[i], pageinfo, index == start + i);

		core.drawBoxAnimate();
		this.drawPagination(page, totalPage);
		core.setTextAlign('ui', 'center');
		core.fillText('ui', '返回游戏', this.PIXEL - 46, this.PIXEL - 13, '#DDDDDD', this._buildFont(15, true));
	}
	core.ui._drawBook_drawBox = function (index, enemy, top, pageinfo) {
		// 横向：22+42；纵向：10 + 42 + 10（正好居中）；内部图像 32x32
		var border_top = top + (pageinfo.per_height - 42) / 2,
			border_left = 22;
		var img_top = border_top + 5,
			img_left = border_left + 5;
		var blockInfo = core.getBlockInfo(enemy.id);
		if (!core.plugin.opacity) {
			core.plugin.fillRoundRect(core.canvas.ui, border_left, border_top, 42, 42, Math.floor(42 / 5), core.material.groundPattern);
			core.plugin.fillStyle = core.material.groundPattern;
		}
		core.strokeRect('ui', 22, border_top, 42, 42, '#DDDDDD', 2);
		core.status.boxAnimateObjs.push({
			'bgx': border_left,
			'bgy': border_top,
			'bgWidth': 42,
			'bgHeight': 42,
			'x': img_left,
			'y': img_top,
			'height': 32,
			'animate': blockInfo.animate,
			'image': blockInfo.image,
			'pos': blockInfo.posY * blockInfo.height
		});
	};
	//ui 绘制标题的 调整 将绘制strokeLine 扩大 以便图片的刷新 不影响strokeLine
	ui.prototype._drawTextBox_drawTitleAndIcon = function (titleInfo, hPos, vPos, alpha) {
		core.setTextAlign('ui', 'left');
		var textAttribute = core.status.textAttribute;
		var content_top = vPos.top + 15;
		var image_top = vPos.top + 15;
		if (titleInfo.title != null) {
			var titlefont = textAttribute.titlefont;
			content_top += titlefont + 5;
			image_top = vPos.top + 40;
			core.setFillStyle('ui', core.arrayToRGB(textAttribute.title));
			core.setStrokeStyle('ui', core.arrayToRGB(textAttribute.title));

			// --- title也要居中或者右对齐？
			var title_width = core.calWidth('ui', titleInfo.title, this._buildFont(titlefont, true));
			var title_left = hPos.content_left;
			if (textAttribute.align == 'center')
				title_left = hPos.left + (hPos.width - title_width) / 2;
			else if (textAttribute.align == 'right')
				title_left = hPos.right - title_width - 12;

			core.fillText('ui', titleInfo.title, title_left, vPos.top + 8 + titlefont);
		}
		if (titleInfo.icon != null) {
			//change
			core.setAlpha('ui', alpha);
			core.strokeRect('ui', hPos.left + 15 - 6, image_top - 6, 44, titleInfo.height + 12, core.status.globalAttribute.borderColor, 2);
			core.setAlpha('ui', 1);
			core.status.boxAnimateObjs = [];
			// --- 勇士
			if (titleInfo.image == core.material.images.hero) {
				core.clearMap('ui', hPos.left + 15, image_top, 32, titleInfo.height);
				//change
				core.fillRect('ui', hPos.left + 15, image_top, 32, titleInfo.height, core.plugin.fillStyle || core.material.groundPattern);
				core.drawImage('ui', titleInfo.image, 0, 0, core.material.icons.hero.width || 32, core.material.icons.hero.height,
					hPos.left + 15, image_top, 32, titleInfo.height);
			} else {
				core.fillRect('ui', hPos.left + 15, image_top, 32, titleInfo.height, core.material.groundPattern);
				core.status.boxAnimateObjs.push({
					'bgx': hPos.left + 15,
					'bgy': image_top,
					'bgWidth': 32,
					'bgHeight': titleInfo.height,
					'x': hPos.left + 15,
					'y': image_top,
					'height': titleInfo.height,
					'animate': titleInfo.animate,
					'image': titleInfo.image,
					'pos': titleInfo.icon * titleInfo.height
				});
			}
			core.drawBoxAnimate();
		}
		if (titleInfo.image != null && titleInfo.icon == null) { // 头像图
			core.drawImage('ui', titleInfo.image, 0, 0, titleInfo.image.width, titleInfo.image.height,
				hPos.left + 10, vPos.top + 10, 70, 70);
		}
		return content_top;
	}
	//绘制背景  直接圆角  会导致对话框的小三角 消失掉  懒得改了
	ui.prototype._drawBackground_drawColor = function (background, left, top, right, bottom, position, px, py, xoffset, yoffset) {
		var alpha = core.plugin.opacity || background[3];
		core.setAlpha('ui', alpha);
		var width = right - left,
			height = bottom - top;
		core.plugin.fillRoundRect(core.canvas.ui, left, top, width, height, Math.floor(height / 8), core.arrayToRGB(background));
		//线的显示 如果不显示 直接注释掉下一句
		if (core.plugin.drawBorder) {
			core.plugin.strokeRoundRect(core.canvas.ui, left, top, width, height, Math.floor(height / 8), 2, core.status.globalAttribute.borderColor);
		}
		core.setAlpha('ui', 1);
	}
	//存读档的圆角显示  主要将strokeRect移到最后  图片的圆角直接在drawThumb函数里改
	ui.prototype._drawSLPanel_drawRecord = function (title, data, x, y, size, cho, highLight) {
		var strokeColor = '#FFD700';
		if (core.status.event.selection) strokeColor = '#FF6A6A';
		if (!data || !data.floorId) highLight = false;
		core.fillText('ui', title, x, y, highLight ? '#FFD700' : '#FFFFFF', this._buildFont(17, true));
		//change
		if (data && data.floorId) {
			core.drawThumbnail(data.floorId, core.maps.loadMap(data.maps, data.floorId).blocks, {
				heroLoc: data.hero.loc,
				heroIcon: data.hero.flags.heroIcon,
				flags: data.hero.flags
			}, {
				ctx: 'ui',
				x: x - size / 2,
				y: y + 15,
				size: size,
				centerX: data.hero.loc.x,
				centerY: data.hero.loc.y
			});
			var v = core.formatBigNumber(data.hero.hp, true) + "/" + core.formatBigNumber(data.hero.atk, true) + "/" + core.formatBigNumber(data.hero.def, true);
			var v2 = "/" + core.formatBigNumber(data.hero.mdef, true);
			if (core.calWidth('ui', v + v2, this._buildFont(10, false)) <= size) v += v2;
			core.fillText('ui', v, x, y + 30 + size, '#FFD700');
			core.fillText('ui', core.formatDate(new Date(data.time)), x, y + 43 + size, data.hero.flags.__consoleOpened__ || data.hero.flags.debug ? '#FF6A6A' : '#FFFFFF');
		} else {
			//core.fillRect('ui', x-size/2, y+15, size, size, '#333333', 2);
			//core.fillText('ui', '空', x, parseInt(y+22+size/2), '#FFFFFF', this._buildFont(30,true));
			core.plugin.fillRoundRect(core.canvas.ui, x - size / 2, y + 15, size, size, Math.floor(size / 5), '#333333')
			core.fillText('ui', '空', x, parseInt(y + 22 + size / 2), '#FFFFFF', this._buildFont(30, true));
		}
		core.strokeRect('ui', x - size / 2, y + 15, size, size, cho ? strokeColor : '#FFFFFF', cho ? 6 : 2);
	}
	//缩略图片的圆角显示  排除了 浏览地图和编辑器模式
	maps.prototype._drawThumbnail_drawToTarget = function (floorId, toDraw) {
		if (toDraw == null) return;
		if (typeof toDraw == 'string' || toDraw.canvas) toDraw = {
			ctx: toDraw
		};
		var ctx = core.getContextByName(toDraw.ctx);
		if (ctx == null) return;
		var x = toDraw.x || 0,
			y = toDraw.y || 0,
			size = toDraw.size || core.__PIXELS__;
		var width = core.floors[floorId].width,
			height = core.floors[floorId].height;
		var centerX = toDraw.centerX,
			centerY = toDraw.centerY;
		if (centerX == null) centerX = Math.floor(width / 2);
		if (centerY == null) centerY = Math.floor(height / 2);
		var tempCanvas = core.bigmap.tempCanvas,
			tempWidth = 32 * width,
			tempHeight = 32 * height;

		core.clearMap(ctx, x, y, size, size);
		if (toDraw.all) {
			// 绘制全景图
			if (tempWidth <= tempHeight) {
				var realHeight = size,
					realWidth = realHeight * tempWidth / tempHeight;
				var side = (size - realWidth) / 2;
				core.fillRect(ctx, x, y, side, realHeight, '#000000');
				core.fillRect(ctx, x + size - side, y, side, realHeight);
				ctx.drawImage(tempCanvas.canvas, 0, 0, tempWidth, tempHeight, x + side, y, realWidth, realHeight);
			} else {
				var realWidth = size,
					realHeight = realWidth * tempHeight / tempWidth;
				var side = (size - realHeight) / 2;
				core.fillRect(ctx, x, y, realWidth, side, '#000000');
				core.fillRect(ctx, x, y + size - side, realWidth, side);
				ctx.drawImage(tempCanvas.canvas, 0, 0, tempWidth, tempHeight, x, y + side, realWidth, realHeight);
			}
		} else {
			// 只绘制可见窗口
			var offsetX = core.clamp(centerX - core.__HALF_SIZE__, 0, width - core.__SIZE__),
				offsetY = core.clamp(centerY - core.__HALF_SIZE__, 0, height - core.__SIZE__);
			//change
			//ctx.drawImage(tempCanvas.canvas, offsetX * 32, offsetY * 32, core.__PIXELS__,core.__PIXELS__);
			if (core.status.event.id == 'viewMaps' || main.mode != 'play') {
				ctx.drawImage(tempCanvas.canvas, offsetX * 32, offsetY * 32, core.__PIXELS__, core.__PIXELS__, x, y, size, size);
			} else {
				core.plugin.fillImageRoundRect(ctx, x, y, size, size, Math.floor(size / 5), tempCanvas.canvas, offsetX * 32, offsetY * 32, core.__PIXELS__, core.__PIXELS__);
			}
		}
	}
	if (!core.plugin.opacity) {
		core.maps.drawBoxAnimate = function () {
			core.status.boxAnimateObjs.forEach(function (obj) {
				core.clearMap('ui', obj.x, obj.y, 32, obj.height);
				core.fillRect('ui', obj.x, obj.y, 32, obj.height, core.material.groundPattern);
				core.drawImage('ui', obj.image, core.status.globalAnimateStatus % obj.animate * 32, obj.pos,
					32, obj.height, obj.x, obj.y, 32, obj.height);
			});
		}
	} else {
		core.maps.drawBoxAnimate = function () {
			//core.canvas.ui.resetTransform();
			var a = 0.1;
			core.status.boxAnimateObjs.forEach(function (obj) {
				core.canvas.ui.clearRect(obj.x, obj.y, 32, obj.height);
				core.fillRect('ui', obj.x - a, obj.y - a, 32 + 2 * a, obj.height + 2 * a, core.plugin.fillStyle);
				//core.fillRect('ui', obj.bgx, obj.bgy, obj.bgWidth, obj.bgHeight, core.plugin.fillStyle);
				//core.plugin.myStrokeRect('ui', 22, obj.bgy+2, 42, 42, '#DDDDDD', 2);
				core.drawImage('ui', obj.image, core.status.globalAnimateStatus % obj.animate * 32, obj.pos,
					32, obj.height, obj.x, obj.y, 32, obj.height);
			});
		}
	}
	ui.prototype.drawBookDetail = function (index) {
		var info = this._drawBookDetail_getInfo(index),
			enemy = info[0];
		if (!enemy) return;
		var content = info[1].join("\n");
		core.status.event.id = 'book-detail';
		clearInterval(core.interval.tipAnimate);
		core.clearMap('data');

		var left = 10,
			width = this.PIXEL - 2 * left,
			right = left + width;
		var content_left = left + 25,
			validWidth = right - content_left - 13;
		var contents = core.splitLines("data", content, validWidth, this._buildFont(16, false));
		var height = Math.max(24 * contents.length + 55, 80),
			top = (this.PIXEL - height) / 2,
			bottom = top + height;

		core.setAlpha('data', 0.9);
		core.plugin.fillRoundRect(core.canvas.data, left, top, width, height, Math.floor(Math.min(height, width) / 5), '#000000');
		core.setAlpha('data', 1);
		core.strokeRect('data', left - 1, top - 1, width + 1, height + 1,
			core.status.globalAttribute.borderColor, 2);

		this._drawBookDetail_drawContent(enemy, contents, {
			top: top,
			content_left: content_left,
			bottom: bottom
		});
	}
	ui.prototype._drawTip_drawOne = function (one, offset) {
		core.setAlpha('data', one.opacity);
		//core.fillRect('data', 5, offset+ 5, one.width, 42, '#000000');
		core.plugin.fillRoundRect(core.canvas.data, 5, offset + 5, one.width, 42, 10, '#000000');
		if (one.image)
			core.drawImage('data', one.image, one.posX * 32, one.posY * one.height, 32, 32, 10, offset + 10, 32, 32);
		core.fillText('data', one.text, one.textX, offset + 33, '#FFFFFF');
		core.setAlpha('data', 1);
	}
},
    "DynamicHP": function () {
	// 在此增加新插件
	/*
 * 把下面的脚本放到
 * 编辑器→脚本编辑→plugin（自定义插件编写）
 * 内的函数内
 * 例：
 * function () {
	window.Fux2 = window.Fux2 || {};
	........
  }
*/

	// 版本控制
	if (!core.registerAnimationFrame) {
		throw new Error('require 2.6.1 or higher version');
	}

	window.Fux2 = window.Fux2 || {};
	Fux2.MorePerform = Fux2.MorePerform || {};

	Fux2.MorePerform.DynamicHpStateBar = {};
	Fux2.MorePerform.DynamicHpStateBar.version = 1.1;
	Fux2.MorePerform.DynamicHpStateBar.oldHpObj = null;
	Fux2.MorePerform.DynamicHpStateBar.remStatus = null;

	// 每帧的处理
	Fux2.MorePerform.DynamicHpStateBar.Update = function () {
		this.CheckProperty();
		if (core.status.hero._nowHp != core.status.hero._realHp) {
			var dis = (core.status.hero._nowHp - core.status.hero._realHp) / 10;
			if (Math.abs(dis) < 2) {
				core.status.hero._nowHp = core.status.hero._realHp;
			} else {
				core.status.hero._nowHp -= dis;
			}
			this.oldHpObj.innerHTML = Math.ceil(core.status.hero._nowHp);
		}
	};

	// 检查插件属性是否合法
	Fux2.MorePerform.DynamicHpStateBar.CheckProperty = function () {
		if (this.remStatus != core.status.hero) {
			this.remStatus = core.status.hero;
			core.status.hero._realHp = core.status.hero.hp;
			core.status.hero._nowHp = core.status.hero.hp;
			delete core.status.hp;
			Object.defineProperty(core.status.hero, 'hp', {
				get: function () {
					return this._realHp;
				},
				set: function (v) {
					core.status.hero._realHp = v;
				}
			});
		}
	};

	// 替换原始HP显示元件
	Fux2.MorePerform.DynamicHpStateBar.ReplaceHpObj = function () {
		this.oldHpObj = core.statusBar.hp;
		var newObj = {};
		Object.defineProperty(newObj, 'innerHTML', {
			get: function () {
				return Fux2.MorePerform.DynamicHpStateBar.oldHpObj.innerHTML;
			},
			set: function (v) {
				if (core.isPlaying()) {
					Fux2.MorePerform.DynamicHpStateBar.CheckProperty();
					Fux2.MorePerform.DynamicHpStateBar.oldHpObj.innerHTML = Math.ceil(core.status.hero._nowHp);
				} else {
					Fux2.MorePerform.DynamicHpStateBar.oldHpObj.innerHTML = v;
				}
			}
		});
		core.statusBar.hp = newObj;
	};

	// 初始化插件
	Fux2.MorePerform.DynamicHpStateBar.initialize = function () {
		this.ReplaceHpObj();
	};

	// 注册每帧处理
	Fux2.MorePerform.DynamicHpStateBar.initialize();
	core.registerAnimationFrame("DynamicHpStateBar", true, Fux2.MorePerform.DynamicHpStateBar.Update.bind(Fux2.MorePerform.DynamicHpStateBar));
},
    "BookColor": function () {
	// 怪物手册文字颜色
	core.ui._drawBook_drawRow1 = function (index, enemy, top, left, width, position) {
		// 绘制第一行
		core.setTextAlign('ui', 'left');
		var b13 = this._buildFont(13, true),
			f13 = this._buildFont(13, false);
		var col1 = left,
			col2 = left + width * 9 / 25,
			col3 = left + width * 17 / 25;
		core.fillText('ui', '体力', col1, position, '#A0F753', f13);
		core.fillText('ui', core.formatBigNumber(enemy.hp || 0), col1 + 30, position, null, b13);
		core.fillText('ui', '攻击', col2, position, '#FF5555', f13);
		core.fillText('ui', core.formatBigNumber(enemy.atk || 0), col2 + 30, position, null, b13);
		core.fillText('ui', '防御', col3, position, '#45D1E0', f13);
		core.fillText('ui', core.formatBigNumber(enemy.def || 0), col3 + 30, position, null, b13);
	}

}
}