var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "area": function () {
	// 在此增加新插件
	core.area = [];
	core.area.push({
		"r0": [
			[0, 2],
			[0, 1],
			[0, 0]
		]
	});
	core.area.push({
		"r1": [
			[2, 2],
			[2, 1],
			[2, 0]
		]
	});
	core.area.push({
		"r2": [
			[4, 2],
			[4, 1],
			[4, 0]
		]
	});
	core.area.push({
		"r3": [
			[6, 2],
			[6, 1],
			[6, 0]
		]
	});
	core.area.push({
		"r4": [
			[8, 2],
			[8, 1],
			[8, 0]
		]
	});
	core.area.push({
		"r5": [
			[10, 2],
			[10, 1],
			[10, 0]
		]
	});
	core.area.push({
		"r6": [
			[12, 2],
			[12, 1],
			[12, 0]
		]
	});
	core.area.push({
		"r7": [
			[0, 4],
			[0, 5],
			[0, 6],
			[0, 7]
		]
	});
	core.area.push({
		"r8": [
			[2, 4],
			[2, 5],
			[2, 6],
			[2, 7]
		]
	});
	core.area.push({
		"r9": [
			[4, 4],
			[4, 5],
			[4, 6],
			[4, 7]
		]
	});
	core.area.push({
		"r10": [
			[8, 4],
			[8, 5],
			[8, 6],
			[8, 7]
		]
	});
	core.area.push({
		"r11": [
			[10, 4],
			[10, 5],
			[10, 6],
			[10, 7]
		]
	});
	core.area.push({
		"r12": [
			[12, 4],
			[12, 5],
			[12, 6]
		]
	});
	core.area.push({
		"r13": [
			[8, 8],
			[8, 7],
			[8, 6],
			[8, 5]
		]
	});
	core.area.push({
		"r14": [
			[10, 8],
			[10, 7],
			[10, 6],
			[10, 5]
		]
	});
	core.area.push({
		"r15": [
			[12, 8],
			[12, 7],
			[12, 6]
		]
	});
	core.area.push({
		"r16": [
			[0, 10],
			[0, 11],
			[0, 12]
		]
	});
	core.area.push({
		"r17": [
			[2, 10],
			[2, 11],
			[2, 12]
		]
	});
	core.area.push({
		"r18": [
			[4, 10],
			[4, 11],
			[4, 12]
		]
	});
	core.area.push({
		"r19": [
			[6, 10],
			[6, 11],
			[6, 12]
		]
	});
	core.area.push({
		"r20": [
			[8, 10],
			[8, 11],
			[8, 12]
		]
	});
	core.area.push({
		"r21": [
			[10, 10],
			[10, 11],
			[10, 12]
		]
	});
	core.area.push({
		"r22": [
			[12, 10],
			[12, 11],
			[12, 12]
		]
	});
},
    "route": function () {
	// 在此增加新插件
	this.calculateRoute = function () {
		core.createRainbow();
		var shuffle = function (arr, seedFunc) {
			var arrObj = arr.map(function (x) { return [x, seedFunc()]; });
			arrObj.sort(function (x, y) { return x[1] - y[1]; });
			return arrObj.map(function (x) { return x[0]; });
		};

		var map = core.clone(core.getMapArray());
		for (var i = 0; i < core.bigmap.width; i++) {
			for (var j = 0; j < core.bigmap.height; j++) {
				if (!core.maps.blocksInfo[map[i][j]]) continue;
				map[i][j] = core.maps.blocksInfo[map[i][j]].id;
			}
		}

		var ihp = core.getStatus('hp');
		var iatk = core.getStatus('atk');
		var idef = core.getStatus('def');

		var maxScore = 0;
		var maxRoute = null;
		for (var i = 0; i < 5000; i++) {
			var thismap = core.clone(map);
			var area = core.clone(core.area);
			area = shuffle(area, core.rand);

			var thishp = ihp;
			var thisatk = iatk;
			var thisdef = idef;

			for (var j in area) {
				var areaid = Object.keys(area[j])[0];
				var singleRoute = area[j][areaid];
				for (var k in singleRoute) {
					var x = singleRoute[k][0];
					var y = singleRoute[k][1];
					var id = thismap[y][x];
					eval(core.preHandle(id));
					thismap[y][x] = '';
					if (thishp <= 0) break;
				}
				if (thishp <= 0) {
					break;
				}
			}
			if (thishp > 0 && thishp > maxScore) {
				maxScore = thishp;
				maxRoute = core.clone(area);
			}
		}
		flags.maxScore = maxScore;
		if (maxScore <= 0) {
			core.insertAction(['测塔员太菜了测不过，是时候我亲自来拆了！']);
			core.setStatus('name', 'AD');
			flags.tester = 2;
			return;
		}
		if (core.isReplaying()) {
			return;
		}

		core.createRoute(maxRoute);
		core.drawTip('预计成绩：' + maxScore);
		core.autoMove();
	};

	//根据最大成绩所生成的路线，将路线存在flags.routes里，以备使用
	this.createRoute = function (maxRoute) {
		var routes = [
			[6, 5],
			[6, 4],
			[6, 3]
		];
		for (var m in maxRoute) {
			var singleRoute = maxRoute[m][Object.keys(maxRoute[m])[0]];
			for (var n in singleRoute) {
				var x = singleRoute[n][0];
				var y = singleRoute[n][1];
				routes.push([x, y]);
			}
		}
		flags.routes = core.clone(routes);
	};

	//自动根据路线完成游戏，路线存在flags.routes里
	this.autoMove = function () {
		core.status.replay.replaying = true;
		core.status.replay.pausing = true;
		flags.specialReplaying = true;
		if (flags.routes && flags.routes.length > 0) {
			core.setAutomaticRoute(flags.routes[0][0], flags.routes[0][1], []);
			flags.routes.shift();
			setTimeout(core.autoMove, 500);
		} else {
			core.status.replay.replaying = false;
			core.updateStatusBar();
			core.tryUseItem('submit');
		}
	};

	//预处理，返回字符串，供eval
	//血量，攻击，防御变量名称为thishp,thisatk,thisdef
	this.preHandle = function (id) {
		if (core.rainbowEnemy.indexOf(id) >= 0) return "thishp -= core.rainbow[id + '-' + thisatk + '-' + thisdef]";
		if (id == 'redJewel') return "thisatk += 1";
		if (id == 'blueJewel') return "thisdef += 1";
		if (id == 'redPotion') return "thishp += 50";
		if (id == 'bluePotion') return "thishp += 200";
		if (id == 'superPotion') return "thishp *= 2";
		return "";
	};
},
    "rainbow": function () {
	// 在此增加新插件

	core.rainbowEnemy = ['greenSlime', 'redSlime', 'bat', 'skeleton', 'bluePriest', 'rock', 'swordsman'];
	core.rainbow = {};
	core.createRainbow = function () {
		var iatk = core.getStatus('atk');
		var idef = core.getStatus('def');
		for (var i in core.rainbowEnemy) {
			for (var atk = 10; atk < 20; atk++) {
				for (var def = 10; def < 20; def++) {
					core.setStatus('atk', atk);
					core.setStatus('def', def);
					var dam = core.getDamage(core.rainbowEnemy[i]);
					if (dam == null) dam = 9999;
					core.rainbow[core.rainbowEnemy[i] + '-' + atk + '-' + def] = dam;
				}
			}
		}
		core.setStatus('atk', iatk);
		core.setStatus('def', idef);
	};
},
    "others": function () {
	// 在此增加新插件
	//生成种子
	this.createSeed = function () {
		var name = core.getFlag('input');
		if (name) {
			core.status.hero.name = name;
		} else {
			name = core.status.hero.name;
		}
		if (core.isReplaying()) return;
		var seed = parseInt(hex_md5(name).substring(0, 8), 16);
		core.setFlag('__seed__', seed);
		core.setFlag('__rand__', seed);
	};

	if (!core.control.autosaveOrigin) core.control.autosaveOrigin = core.clone(core.control.autosave);
	core.control.autosave = function () {
		if (flags.specialReplaying) {
			return;
		}
		core.control.autosaveOrigin();
	};

	if (!core.control.pauseReplayOrigin) core.control.pauseReplayOrigin = core.clone(core.control.pauseReplay);
	core.control.pauseReplay = function () {
		if (flags.specialReplaying) {
			core.drawTip('当前不能暂停');
			return;
		}
		core.control.pauseReplayOrigin();
	};

	if (!core.control.stopReplayOrigin) core.control.stopReplayOrigin = core.clone(core.control.stopReplay);
	core.control.stopReplay = function () {
		if (flags.specialReplaying) {
			core.drawTip('当前不能停止');
			return;
		}
		core.control.stopReplayOrigin();
	};

	if (!core.control.resumeReplayOrigin) core.control.resumeReplayOrigin = core.clone(core.control.resumeReplay);
	core.control.resumeReplay = function () {
		if (flags.specialReplaying) {
			core.drawTip('当前不能停止');
			return;
		}
		core.control.resumeReplayOrigin();
	};

	if (!core.control.stepReplayOrigin) core.control.stepReplayOrigin = core.clone(core.control.stepReplay);
	core.control.stepReplay = function () {
		if (flags.specialReplaying) {
			core.drawTip('当前不能停止');
			return;
		}
		core.control.stepReplayOrigin();
	};

	if (!core.control.rewindReplayOrigin) core.control.rewindReplayOrigin = core.clone(core.control.rewindReplay);
	core.control.rewindReplay = function () {
		if (flags.specialReplaying) {
			core.drawTip('当前不能停止');
			return;
		}
		core.control.rewindReplayOrigin();
	};

	if (!core.control.bookReplayOrigin) core.control.bookReplayOrigin = core.clone(core.control.bookReplay);
	core.control.bookReplay = function () {
		if (flags.specialReplaying) {
			core.drawTip('当前不能停止');
			return;
		}
		core.control.bookReplayOrigin();
	};

	if (!core.control.saveReplayOrigin) core.control.saveReplayOrigin = core.clone(core.control.saveReplay);
	core.control.saveReplay = function () {
		if (flags.specialReplaying) {
			core.drawTip('当前不能停止');
			return;
		}
		core.control.saveReplayOrigin();
	};

	if (!core.control.viewMapReplayOrigin) core.control.viewMapReplayOrigin = core.clone(core.control.viewMapReplay);
	core.control.viewMapReplay = function () {
		if (flags.specialReplaying) {
			core.drawTip('当前不能停止');
			return;
		}
		core.control.viewMapReplayOrigin();
	};

	if (!core.control.toolboxReplayOrigin) core.control.toolboxReplayOrigin = core.clone(core.control.toolboxReplay);
	core.control.toolboxReplay = function () {
		if (flags.specialReplaying) {
			core.drawTip('当前不能停止');
			return;
		}
		core.control.toolboxReplayOrigin();
	};

	if (!core.control.equipboxReplayOrigin) core.control.equipboxReplayOrigin = core.clone(core.control.equipboxReplay);
	core.control.equipboxReplay = function () {
		if (flags.specialReplaying) {
			core.drawTip('当前不能停止');
			return;
		}
		core.control.equipboxReplayOrigin();
	};


	core.checkItem = function () {
		var count = core.itemCount('itemGreenSlime') + core.itemCount('itemRedSlime') + core.itemCount('itemBat') + core.itemCount('itemSkeleton') + core.itemCount('itemBluePriest') + core.itemCount('itemRock') + core.itemCount('itemSwordsman');
		if (count <= 1) {
			for (var i = 0; i < core.bigmap.width; i++) {
				for (var j = 0; j < core.bigmap.height; j++) {
					var target = core.getBgNumber(i, j);
					if (target && target > 0) {
						core.setBlock(target, i, j);
					}
					core.setBgFgBlock('bg', 0, i, j);
				}
			}
			core.insertAction(core.getCommonEvent('测塔'));
		}
	};
}
}