// 这里需要改楼层名，请和文件名及下面的floorId保持完全一致
// 楼层唯一标识符仅能由字母、数字、下划线组成，且不能由数字开头
// 推荐用法：第20层就用MT20，第38层就用MT38，地下6层就用MT_6（用下划线代替负号），隐藏3层用MT3h（h表示隐藏），等等
main.floors.MT1 = {
    "floorId": "MT1", // 楼层唯一标识符，需要和名字完全一致
    "title": "练习区", // 楼层中文名
    "name": "1", // 显示在状态栏中的层数
    "canFlyTo": false, // 该楼能否被楼传器飞到（不能的话在该楼也不允许使用楼传器）
    "canUseQuickShop": false, // 该层是否允许使用快捷商店
    "defaultGround": "ground", // 默认地面的图块ID（terrains中）
    "png": [], // 该层默认显示的所有图片；详细用法请查看文档“自定义素材”中的说明。
    // "color": [0,0,0,0.3], // 该层的默认画面色调。本项可不写（代表无色调），如果写需要是一个RGBA数组。
    // "weather": ["snow",5], // 该层的默认天气。本项可忽略表示晴天，如果写则第一项为"rain"或"snow"代表雨雪，第二项为1-10之间的数代表强度。
    "bgm": "TH2-3.mp3", // 到达该层后默认播放的BGM。本项可忽略。
    "map": [ // 地图数据，需要是13x13，建议使用地图生成器来生成
        [205,  0,  0,  0,  0,  1, 31,  1,  0,204,203,  0, 29],
        [  1,  1,  1,  1, 81,  1,  0,  0,202,  1,  1,  1, 28],
        [ 27,  1, 31,  0,  0,  1, 81,  1,  0,  0, 29,  1,  1],
        [201,202,  0,  1, 31,  0,202,  0, 31,  1,  0, 81, 31],
        [ 82,  0,  0,  1,  0,  1,  1,  1,  0,  1,  0,  0,203],
        [ 31,  1, 81,  0,204,  1, 34,  1,204,  1,204,  1, 28],
        [  1,  1, 31,  1,  0,  1, 81,  1,  0,  1,  0,201,201],
        [ 31,  1,  0,  1,203, 27,209,  0, 81,  0, 31,  1, 31],
        [203,  0,204,  1,  0,  1,  0,  1,  1,201,  1,  1,  1],
        [  0,  1, 81,  0,206,  0,201,  1,  0, 31,  0,201,  0],
        [  0,202,  0,  1, 29,  1, 31,  0,203,  1, 28,  1, 29],
        [206,  1,206,  1,  1,  1,  1,  1,  0,  1,204,  1, 31],
        [ 27,  1, 32, 31, 82,  0,  0,121,  0, 31,  0,202,  0]
    ],
    "firstArrive": [ // 第一次到该楼层触发的事件

    ],
    "events": { // 该楼的所有可能事件列表
        "7,12":[
            "\t[老人,man]（按ctrl跳过该对话）\n"+
            "你现在拥有了魔法值，而魔法值将会作为你使用技能的基础。\n"+
            "魔法可以通过战斗自然恢复（每回合可以恢复0.3点mp，向下取整）\n"+
            "也可以在回蓝状态下通过智力来恢复，每场战斗中1智力提供1点魔法恢复\n",
            "\t[老人,man]下面是技能部分：\n"+
            "1) 可切换  将智力的回蓝自由切换为回血，每点智力提供8生命恢复\n"+
            "2) 12(6)mp —— 下次战斗前对敌人先行造成15伤害\n"+
            "3) 12mp —— 解除所有异常状态\n"+
            "4) 32(12)mp —— 破除一堵墙\n"+
            "5) 30(12)mp —— 瞬移到正前方第三格位置并触发事件\n"+
            "6) 40(30)mp —— 将怪物传送至另一层相同位置\n",
            "\t[老人,man]按快捷键1可切换回血/回蓝状态，\n"+
            "2切换火球术状态，3~6可使用对应技能\n"+
            "此外可以花费10/20mp开启一个黄/蓝门\n"+
            "另外击败1楼boss后可获得慧光（简单难度开场即可获得），魔耗将减少至括号内的数值\n"+
            "该塔一楼为练习区，而二楼为加点区，所有怪物在2楼均会提供加点\n",
            {"type": "hide", "time": 300}
        ],
        "0,0":[
            {"type":"changeFloor","floorId": "MT2","loc":[1,0]}
        ]
    },
    "changeFloor": { // 楼层转换事件；该事件不能和上面的events有冲突（同位置点），否则会被覆盖
        //"0,0": {"trigger":12,"floorId": "MT2", "stair": "upFloor"},
    },
    "afterBattle": { // 战斗后可能触发的事件列表
        "0,0":[
            {"type":"setValue","name": "status:mana","value": "0"},
            {"type":"setBlock","number":87},
            {"type":"show","loc":[0,0]}
        ]
    },
    "afterGetItem": { // 获得道具后可能触发的事件列表

    },
    "afterOpenDoor": { // 开完门后可能触发的事件列表

    },
    "cannotMove": { // 每个图块不可通行的方向
        // 可以在这里定义每个点不能前往哪个方向，例如悬崖边不能跳下去
        // "x,y": ["up", "left"], // (x,y)点不能往上和左走
    },
}

/*
添加显示到状态栏的英雄属性字段
1)index.html
2)core.js的状态栏部分和样式部分
3)main.js状态栏部分
4)data.js中新建
5)data.js的flag
6)（仅怪物属性）enemy.js怪物手册部分
7)（仅怪物属性）（次要）ui.js战斗过程
8)events.js上传成绩部分
*/