var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "plugins": function () {
	// 在此增加新插件
	core.events._openDoor_check = function (id, x, y, needKey) {
		// 是否存在门或暗墙
		if (!core.terrainExists(x, y, id) || !(id.endsWith("Door") || id.endsWith("Wall")) || core.material.icons.animates[id] == null) {
			core.clearContinueAutomaticRoute();
			return false;
		}

		if (id == 'steelDoor' && core.flags.steelDoorWithoutKey)
			needKey = false;
		if (core.hasFlag("6") && core.getBlockId(x, y) != "specialDoor") {
			core.removeFlag("6");
			for (var a = 0; a <= 14; a++) {
				for (var b = 0; b <= 14; b++) {
					if (core.getBlockCls(a, b) == "enemys") {
						core.getBlock(a, b).block.event.noPass = true;
					}
				}
			}
			if (!core.status.event.id) core.autosave(true);
		} else {
			if (needKey && id.endsWith("Door")) {
				var key = id.replace("Door", "Key");
				if (!core.hasItem(key)) {
					if (key != "specialKey")
						core.drawTip("你没有" + ((core.material.items[key] || {}).name || "钥匙"));
					else core.drawTip("无法开启此门");
					core.clearContinueAutomaticRoute();
					return false;
				}
				if (!core.status.event.id) core.autosave(true);
				core.removeItem(key);
			}
		}
		return true;
	};
	////// 战斗 //////
	events.prototype.battle = function (id, x, y, force, callback) {
		core.saveAndStopAutomaticRoute();
		id = id || core.getBlockId(x, y);
		if (!id || core.hasFlag("6")) return core.clearContinueAutomaticRoute(callback);
		// 非强制战斗
		if (!core.enemys.canBattle(id, x, y) && !force && !core.status.event.id) {
			core.drawTip("你打不过此怪物！");
			return core.clearContinueAutomaticRoute(callback);
		}
		// 自动存档
		if (!core.status.event.id) core.autosave(true);
		// 战前事件
		if (!this.beforeBattle(id, x, y))
			return core.clearContinueAutomaticRoute(callback);
		// 战后事件
		this.afterBattle(id, x, y, callback);
	}
	////// 获得某个物品 //////
	core.events.getItem = function (id, num, x, y, callback) {
		if (num == null) num = 1;
		num = num || 1;
		var itemCls = core.material.items[id].cls;
		if (itemCls === 'items' && (id.indexOf("Potion") != -1 || id.indexOf("Jewel") != -1 || id == "superWine")) {
			core.setFlag("x", x);
			core.setFlag("y", y);
			core.setFlag("id", id);
			core.removeFlag("input");
			core.insertAction("道具");
		} else {
			core.items.getItemEffect(id, num);
			core.removeBlock(x, y);
			var text = '获得 ' + core.material.items[id].name;
			if (num > 1) text += "x" + num;
			if (itemCls === 'items') text += core.items.getItemEffectTip(id);
			core.drawTip(text, id);
			core.updateStatusBar();

			this.afterGetItem(id, x, y, callback);
		}
	}
	////// 点击楼层传送器时的打开操作 //////
	events.prototype.useFly = function (fromUserAction) {
		if (core.isReplaying()) return;
		//if (!this._checkStatus('fly', fromUserAction, true)) return;
		/*if (core.flags.flyNearStair && !core.nearStair()) {
		    core.drawTip("只有在楼梯边才能使用传送器");
		    core.unLockControl();
		    core.status.event.data = null;
		    core.status.event.id = null;
		    return;
		}
		if (!core.canUseItem('fly')) {
		    core.drawTip("楼层传送器好像失效了");
		    core.unLockControl();
		    core.status.event.data = null;
		    core.status.event.id = null;
		    return;
		}
		core.useItem('fly', true);*/
		var items = ["skill1", "I330", "I331", "lifeWand", "I332", "I333", "I334", "I335"];
		for (var i = 0; i < items.length; i++) {
			if (core.hasItem(items[i])) {
				core.useItem(items[i], true);
				core.status.route.push("key:49");
			}
		}
		return;
	}
	maps.prototype.resetMap = function (floorId) {
		floorId = floorId || core.status.floorId;
		if (!floorId) return;
		if (typeof floorId == 'string') floorId = [floorId];
		var needRefresh = false;
		floorId.forEach(function (t) {
			core.status.maps[t] = core.maps.loadFloor(t);
			if (t == core.status.floorId) needRefresh = true;
		});
		if (needRefresh) this.drawMap();
		core.drawTip("地图重置成功");
		for (var x = 0; x <= 14; x++) {
			for (var y = 0; y <= 14; y++) {
				var id = core.getBlockId(x, y) || "";
				if (id.indexOf("Potion") != -1 || id.indexOf("Jewel") != -1 || id == "superWine") core.getBlock(x, y).block.event.noPass = true;
			}
		}
	}
	core.control._updateDamage_damage = function (floorId, ctx) {
		core.setTextAlign(ctx, 'left');
		core.status.maps[floorId].blocks.forEach(function (block) {
			var x = block.x,
				y = block.y;
			var id = core.getBlockId(x, y) || "";
			var number = core.getFlag(x + "," + y, 8);
			if (!block.disable && number >= 0 && (id.indexOf("Potion") != -1 || id.indexOf("Jewel") != -1 || id == "superWine")) {
				core.fillBoldText(ctx, number, 32 * x + 1, 32 * (y + 1) - 1, '#FFFFFF');
			}
			if (!block.disable && block.event.cls.indexOf('enemy') == 0 && block.event.displayDamage !== false) {
				if (core.flags.displayEnemyDamage) {
					var damageString = core.enemys.getDamageString(block.event.id, x, y, floorId);
					var damage = damageString.damage,
						color = damageString.color;
					core.fillBoldText(ctx, damage, 32 * x + 1, 32 * (y + 1) - 1, color);
				}
				if (core.flags.displayCritical) {
					var critical = core.enemys.nextCriticals(block.event.id, 1, x, y, floorId);
					critical = core.formatBigNumber((critical[0] || [])[0], true);
					if (critical == '???') critical = '?';
					core.fillBoldText(ctx, critical, 32 * x + 1, 32 * (y + 1) - 11, '#FFFFFF');
				}
			}
		});
	}
},
    "hunter": function () {
	// 在此增加新插件
	this.existBlock = function () {
		var x1 = core.getHeroLoc('x'),
			x2 = core.getFlag('5_1_x'),
			y1 = core.getHeroLoc('y'),
			y2 = core.getFlag('5_1_y');
		if (x1 == x2) {
			if (y1 > y2) {
				y1 += y2;
				y2 = y1 - y2;
				y1 -= y2;
			}
			for (var i = y1 + 1; i < y2; i++) {
				var block = core.getBlock(x1, i);
				if (block) return true;
			}

		} else if (y1 == y2) {
			if (x1 > x2) {
				x1 += x2;
				x2 = x1 - x2;
				x1 -= x2;
			}
			for (var i = x1 + 1; i < x2; i++) {
				var block = core.getBlock(i, y1);
				if (block) return true;
			}
		}
		return false;
	}
}
}