var data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d = 
{
	"main": {
		"floorIds": [
			"MT0",
			"MT1"
		],
		"images": [
			"bg.jpg",
			"winskin.png",
			"hero.png"
		],
		"tilesets": [
			"magictower.png"
		],
		"animates": [
			"hand",
			"sword",
			"zone"
		],
		"bgms": [
			"bgm.mp3"
		],
		"sounds": [
			"attack.mp3",
			"bomb.mp3",
			"cancel.mp3",
			"centerFly.mp3",
			"confirm.mp3",
			"cursor.mp3",
			"door.mp3",
			"equip.mp3",
			"error.mp3",
			"floor.mp3",
			"gem.mp3",
			"icePickaxe.mp3",
			"item.mp3",
			"jump.mp3",
			"load.mp3",
			"open_ui.mp3",
			"pickaxe.mp3",
			"recovery.mp3",
			"save.mp3",
			"shop.mp3",
			"zone.mp3"
		],
		"nameMap": {
			"背景图.jpg": "bg.jpg",
			"背景音乐.mp3": "bgm.mp3",
			"回血": "recovery.mp3",
			"宝石": "gem.mp3",
			"获得道具": "item.mp3"
		},
		"levelChoose": [],
		"equipName": [
			"武器"
		],
		"startBgm": null,
		"hardLabelColor": "red",
		"fonts": [],
		"styles": {
			"startBackground": "project/images/bg.jpg",
			"startVerticalBackground": "project/images/bg.jpg",
			"startLogoStyle": "color: black",
			"startButtonsStyle": "background-color: #32369F; opacity: 0.85; color: #FFFFFF; border: #FFFFFF 2px solid; caret-color: #FFD700;",
			"statusLeftBackground": null,
			"statusTopBackground": "url(project/images/ground.png) repeat",
			"toolsBackground": "url(project/images/ground.png) repeat",
			"borderColor": [
				204,
				204,
				204,
				1
			],
			"statusBarColor": [
				255,
				255,
				255,
				1
			],
			"floorChangingStyle": "background-color: black; color: white",
			"font": "Verdana"
		}
	},
	"firstData": {
		"title": "空手入白刃",
		"name": "kongshou2",
		"version": "Ver 2.10.2",
		"floorId": "MT0",
		"hero": {
			"name": "阳光",
			"lv": 1,
			"hpmax": 9999,
			"hp": 1000,
			"manamax": -1,
			"mana": 0,
			"atk": 10,
			"def": 10,
			"mdef": 0,
			"money": 0,
			"equipment": [],
			"items": {
				"constants": {},
				"tools": {
					"yellowKey": 0,
					"blueKey": 0,
					"redKey": 0
				},
				"equips": {}
			},
			"loc": {
				"direction": "up",
				"x": 7,
				"y": 13
			},
			"flags": {},
			"steps": 0,
			"image": "hero.png",
			"followers": [],
			"exp": 0,
			"animate": null
		},
		"startCanvas": [
			{
				"type": "comment",
				"text": "在这里可以用事件来自定义绘制标题界面的背景图等"
			},
			{
				"type": "comment",
				"text": "也可以直接切换到其他楼层（比如某个开始剧情楼层）进行操作。"
			},
			{
				"type": "showImage",
				"code": 1,
				"image": "bg.jpg",
				"loc": [
					0,
					0
				],
				"dw": 100,
				"dh": 100,
				"opacity": 1,
				"time": 0
			},
			{
				"type": "while",
				"condition": "1",
				"data": [
					{
						"type": "comment",
						"text": "给用户提供选择项，这里简单的使用了choices事件"
					},
					{
						"type": "comment",
						"text": "也可以贴按钮图然后使用等待操作来完成"
					},
					{
						"type": "choices",
						"choices": [
							{
								"text": "开始游戏",
								"action": [
									{
										"type": "comment",
										"text": "检查bgm状态，下同"
									},
									{
										"type": "function",
										"function": "function(){\ncore.control.checkBgm()\n}"
									},
									{
										"type": "if",
										"condition": "core.flags.startDirectly",
										"true": [
											{
												"type": "comment",
												"text": "直接开始游戏，设置初始化数据"
											},
											{
												"type": "function",
												"function": "function(){\ncore.events.setInitData('')\n}"
											}
										],
										"false": [
											{
												"type": "comment",
												"text": "动态生成难度选择项"
											},
											{
												"type": "function",
												"function": "function(){\nvar choices = [];\nmain.levelChoose.forEach(function (one) {\n\tchoices.push({\"text\": one[0], \"action\": [\n\t\t{\"type\": \"function\", \"function\": \"function() { core.status.hard = '\"+one[1]+\"'; core.events.setInitData('\"+one[1]+\"'); }\"}\n\t]});\n})\ncore.insertAction({\"type\": \"choices\", \"choices\": choices});\n}"
											}
										]
									},
									{
										"type": "hideImage",
										"code": 1,
										"time": 0
									},
									{
										"type": "comment",
										"text": "成功选择难度"
									},
									{
										"type": "break"
									}
								]
							},
							{
								"text": "读取存档",
								"action": [
									{
										"type": "function",
										"function": "function(){\ncore.control.checkBgm()\n}"
									},
									{
										"type": "comment",
										"text": "简单的使用“呼出读档界面”来处理"
									},
									{
										"type": "callLoad"
									}
								]
							},
							{
								"text": "回放录像",
								"action": [
									{
										"type": "function",
										"function": "function(){\ncore.control.checkBgm()\n}"
									},
									{
										"type": "comment",
										"text": "这段代码会弹框选择录像文件"
									},
									{
										"type": "if",
										"condition": "!core.isReplaying()",
										"true": [
											{
												"type": "function",
												"function": "function(){\ncore.chooseReplayFile()\n}"
											}
										],
										"false": []
									}
								]
							}
						]
					}
				]
			},
			{
				"type": "comment",
				"text": "接下来会执行startText中的事件"
			}
		],
		"startText": [
			"背包可以学会偷剑，只可以偷5次，偷来的剑大多数只能使用2次。但是无视效果放背包就可以生效！",
			"不同武器。效果不同。自行研究。2楼清空武器（人物升级加大量属性！）"
		],
		"shops": [
			{
				"id": "moneyShop1",
				"name": "贪婪之神",
				"icon": "blueShop",
				"textInList": "1F金币商店",
				"commonTimes": false,
				"mustEnable": false,
				"use": "money",
				"need": "20+10*times*(times+1)",
				"text": "勇敢的武士啊，给我${flag:moneyShop1_price}金币就可以：",
				"choices": [
					{
						"text": "生命+800",
						"effect": "status:hp+=800",
						"need": "status:money>=20+10*flag:moneyShop1_times*(flag:moneyShop1_times+1)",
						"action": [
							{
								"type": "setValue",
								"name": "flag:moneyShop1_price",
								"value": "20+10*flag:moneyShop1_times*(flag:moneyShop1_times+1)"
							},
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "flag:moneyShop1_price"
							},
							{
								"type": "setValue",
								"name": "flag:moneyShop1_times",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "800"
							}
						]
					}
				],
				"disablePreview": false
			},
			{
				"id": "expShop1",
				"name": "经验之神",
				"icon": "pinkShop",
				"textInList": "1F经验商店",
				"commonTimes": false,
				"mustEnable": false,
				"use": "experience",
				"need": "-1",
				"text": "勇敢的武士啊，给我若干经验就可以：",
				"choices": [
					{
						"text": "等级+1",
						"need": "status:exp>=100",
						"effect": "status:hp+=1000",
						"action": [
							{
								"type": "setValue",
								"name": "flag:expShop1_price",
								"value": "100"
							},
							{
								"type": "setValue",
								"name": "status:exp",
								"operator": "-=",
								"value": "flag:expShop1_price"
							},
							{
								"type": "setValue",
								"name": "flag:expShop1_times",
								"operator": "+=",
								"value": "1"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "1000"
							}
						]
					}
				],
				"disablePreview": false
			},
			{
				"id": "itemShop",
				"item": true,
				"textInList": "道具商店",
				"mustEnable": false,
				"choices": [
					{
						"id": "yellowKey",
						"number": 10,
						"money": 10
					}
				],
				"use": "money"
			},
			{
				"id": "keyShop1",
				"textInList": "回收钥匙商店",
				"mustEnable": false,
				"commonEvent": "回收钥匙商店"
			}
		],
		"levelUp": [
			{
				"need": "0",
				"title": "剑徒",
				"action": [
					{
						"type": "comment",
						"text": "此处是初始等级，只需填写称号"
					}
				]
			},
			{
				"need": "35",
				"title": "剑魔",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"value": "status:atk+50"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"value": "status:def+50"
					}
				]
			}
		]
	},
	"values": {
		"lavaDamage": 50,
		"poisonDamage": 10,
		"weakValue": 20,
		"redPotion": 100,
		"bluePotion": 200,
		"yellowPotion": 300,
		"greenPotion": 400,
		"breakArmor": 0.9,
		"counterAttack": 0.1,
		"purify": 3,
		"hatred": 2,
		"animateSpeed": 400,
		"statusCanvasRowsOnMobile": 3,
		"redGem": 1,
		"blueGem": 1,
		"greenGem": 3,
		"moveSpeed": null,
		"floorChangeTime": null
	},
	"flags": {
		"enableExperience": true,
		"flyNearStair": true,
		"flyRecordPosition": false,
		"steelDoorWithoutKey": false,
		"itemFirstText": false,
		"equipboxButton": false,
		"enableAddPoint": false,
		"enableNegativeDamage": false,
		"betweenAttackMax": false,
		"useLoop": true,
		"startUsingCanvas": false,
		"statusCanvas": false,
		"displayEnemyDamage": true,
		"displayCritical": true,
		"displayExtraDamage": true,
		"enableGentleClick": true,
		"potionWhileRouting": false,
		"ignoreChangeFloor": true,
		"canGoDeadZone": false,
		"enableMoveDirectly": true,
		"disableShopOnDamage": false,
		"blurFg": false,
		"statusBarItems": [
			"enableHP",
			"enableAtk",
			"enableDef",
			"enableFloor",
			"enableMDef",
			"enableExp",
			"enableLevelUp",
			"enableKeys",
			"enablePZF"
		],
		"autoScale": null,
		"extendToolbar": null,
		"hideLeftStatusBar": null,
		"enableEnemyPoint": true,
		"enableRouteFolding": null
	}
}