var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {
	// 在这里写的代码，在所有模块加载完毕后，游戏开始前会被执行
	console.log("插件编写测试");

	// 可以写一些其他的被直接执行的代码


	this.test = function () {
		console.log("插件函数执行测试");
		console.log(this);
	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	core.registerSystemEvent('hpDoor', function (data, callback) {
		core.autosave(true);
		core.insertAction("血门", data.x, data.y);
	});

	core.events.openQuickShop = function (need) {
		if (core.isMoving()) {
			core.drawTip('请先停止勇士行动');
			return;
		}
		if (core.status.lockControl || core.status.event.id != null) {
			return;
		}
		core.openShop('shop1', true);
	}

	core.items._loadEquipEffect = function (equipId, unloadEquipId, isPercentage) {
		// 比较能力值
		var result = core.compareEquipment(equipId, unloadEquipId);

		if (isPercentage) {
			for (var name in result)
				core.addBuff(name, result[name] / 100);
		} else {
			for (var name in result) {
				if (name == 'money') continue;
				core.status.hero[name] += result[name];
			}
		}
	}

	core.ui._drawEquipbox_drawStatusChanged = function (info, y, equip, equipType) {
		var compare = this._drawEquipbox_getStatusChanged(info, equip, equipType, y);
		if (compare == null) return;
		var obj = { drawOffset: 10, y: y };

		// --- 变化值...
		core.setFont('ui', this._buildFont(14, true));
		for (var name in compare) {
			if (name == 'money') continue;
			var img = core.statusBar.icons[name];
			var text = core.getStatusName(name);
			if (img && core.flags.iconInEquipbox) { // 绘制图标
				core.drawImage('ui', img, 0, 0, 32, 32, obj.drawOffset, obj.y - 13, 16, 16);
				obj.drawOffset += 20;
			} else { // 绘制文字
				this._drawEquipbox_drawStatusChanged_draw(text + " ", '#CCCCCC', obj);
			}
			var nowValue = core.getStatus(name) * core.getBuff(name),
				newValue = (core.getStatus(name) + compare[name]) * core.getBuff(name);
			if (equip.equip.percentage) {
				var nowBuff = core.getBuff(name),
					newBuff = nowBuff + compare[name] / 100;
				nowValue = Math.floor(nowBuff * core.getStatus(name));
				newValue = Math.floor(newBuff * core.getStatus(name));
			}
			nowValue = core.formatBigNumber(nowValue);
			newValue = core.formatBigNumber(newValue);
			this._drawEquipbox_drawStatusChanged_draw(nowValue + "->", '#CCCCCC', obj);
			this._drawEquipbox_drawStatusChanged_draw(newValue, compare[name] > 0 ? '#00FF00' : '#FF0000', obj);
			obj.drawOffset += 8;
		}
	}
	/*this.equipmentStore = function (array) {
		var all = array;
		var choices = [];
		for (var i = 0; i < all.length; i++) {
			var a = 0;
			if (core.isset(core.material.items[all[i]].equip.atk)) { a += 100; }
			if (core.isset(core.material.items[all[i]].equip.def)) { a += 10; }
			if (core.isset(core.material.items[all[i]].equip.mdef)) { a += 1; }
			if (a == 111) {
				choices.push({
					"text": core.material.items[all[i]].name + ' 攻击' + core.material.items[all[i]].equip.atk + ' 防御' + core.material.items[all[i]].equip.def + ' 魔防' + core.material.items[all[i]].equip.mdef + ' ￥' + core.material.items[all[i]].equip.money,
					"action": [{
						"type": "if",
						"condition": "status:money>=" + core.material.items[all[i]].equip.money,
						"true": [
							{ "type": "setValue2", "name": "status:money", "value": -core.material.items[all[i]].equip.money },
							{ "type": "setValue2", "name": "item:" + all[i], "value": "1" },
						],
						"false": ["金钱不足！"]
					}, ]
				});
			} else if (a == 110) {
				choices.push({
					"text": core.material.items[all[i]].name + ' 攻击' + core.material.items[all[i]].equip.atk + ' 防御' + core.material.items[all[i]].equip.def + ' ￥' + core.material.items[all[i]].equip.money,
					"action": [{
						"type": "if",
						"condition": "status:money>=" + core.material.items[all[i]].equip.money,
						"true": [
							{ "type": "setValue2", "name": "status:money", "value": -core.material.items[all[i]].equip.money },
							{ "type": "setValue2", "name": "item:" + all[i], "value": "1" },
						],
						"false": ["金钱不足！"]
					}, ]
				});
			} else if (a == 101) {
				choices.push({
					"text": core.material.items[all[i]].name + ' 攻击' + core.material.items[all[i]].equip.atk + ' 魔防' + core.material.items[all[i]].equip.mdef + ' ￥' + core.material.items[all[i]].equip.money,
					"action": [{
						"type": "if",
						"condition": "status:money>=" + core.material.items[all[i]].equip.money,
						"true": [

							{ "type": "setValue2", "name": "status:money", "value": -core.material.items[all[i]].equip.money },
							{ "type": "setValue2", "name": "item:" + all[i], "value": "1" },
						],
						"false": ["金钱不足！"]
					}, ]
				});
			} else if (a == 100) {
				choices.push({
					"text": core.material.items[all[i]].name + ' 攻击' + core.material.items[all[i]].equip.atk + ' ￥' + core.material.items[all[i]].equip.money,
					"action": [{
						"type": "if",
						"condition": "status:money>=" + core.material.items[all[i]].equip.money,
						"true": [
							{ "type": "setValue2", "name": "status:money", "value": -core.material.items[all[i]].equip.money },
							{ "type": "setValue2", "name": "item:" + all[i], "value": "1" },
						],
						"false": ["金钱不足！"]
					}, ]
				});
			} else if (a == 11) {
				choices.push({
					"text": core.material.items[all[i]].name + ' 防御' + core.material.items[all[i]].equip.def + ' 魔防' + core.material.items[all[i]].equip.mdef + ' ￥' + core.material.items[all[i]].equip.money,
					"action": [{
						"type": "if",
						"condition": "status:money>=" + core.material.items[all[i]].equip.money,
						"true": [
							{ "type": "setValue2", "name": "status:money", "value": -core.material.items[all[i]].equip.money },
							{ "type": "setValue2", "name": "item:" + all[i], "value": "1" },
						],
						"false": ["金钱不足！"]
					}, ]
				});
			} else if (a == 10) {
				choices.push({
					"text": core.material.items[all[i]].name + ' 防御' + core.material.items[all[i]].equip.def + ' ￥' + core.material.items[all[i]].equip.money,
					"action": [{
						"type": "if",
						"condition": "status:money>=" + core.material.items[all[i]].equip.money,
						"true": [
							{ "type": "setValue2", "name": "status:money", "value": -core.material.items[all[i]].equip.money },
							{ "type": "setValue2", "name": "item:" + all[i], "value": "1" },
						],
						"false": ["金钱不足！"]
					}, ]
				});
			} else if (a == 1) {
				choices.push({
					"text": core.material.items[all[i]].name + ' 魔防' + core.material.items[all[i]].equip.mdef + ' ￥' + core.material.items[all[i]].equip.money,
					"action": [{
						"type": "if",
						"condition": "status:money>=" + core.material.items[all[i]].equip.money,
						"true": [
							{ "type": "setValue2", "name": "status:money", "value": -core.material.items[all[i]].equip.money },
							{ "type": "setValue2", "name": "item:" + all[i], "value": "1" },
						],
						"false": ["金钱不足！"]
					}, ]
				});
			}
		}
		choices.push({ "text": "离开", "action": [] });
		core.insertAction({
			"type": "choices",
			"text": "\t[Magdaiene,woman]这里出售各种防具装备。",
			"choices": choices
		});

	}

	this.sell = function () {
		// 在这里用数组形式给出所有可以卖的道具
		var all = ["shield2", "shield3", "shield4", "shield5", "I328", "I329", "I330", "I331", "I332", "I333", "I334", "I335", "I336", "I337", "I338", "I339", "I340", "I341", "I342", "I343", "I344", "I345", "I346", "I347", "I348", "I349", "I350", "I304", "I305", "I306", "I307", "I308", "I309", "I310"];
		var text = "\t[商人,woman]你要出售什么东西呢？";
		var choices = [];
		for (var i = 0; i < all.length; i++) {
			var itemId = all[i],
				item = core.material.items[itemId],
				cnt = core.itemCount(itemId);
			if (cnt > 0) {
				var name = item.name,
					money = Math.floor(item.money / 2) || 0;
				choices.push({
					"text": name + "[" + cnt + "]（" + money + "金币）",
					"action": [
						{ "type": "setValue", "name": "item:" + itemId, "value": "item:" + itemId + "-1" },
						{ "type": "setValue", "name": "status:money", "value": "status:money+" + money },
					]
				});
			}
		}

		var generate = function (start) {
			var ans = [];
			for (var i = start; i < choices.length; i++) {
				ans.push(choices[i]);
				if (ans.length >= 4 && i < choices.length - 1) {
					ans.push({
						"text": "下一页",
						"action": [
							{ "type": "choices", "text": text, "choices": generate(i + 1) }
						]
					})
					break;
				}
			}
			ans.push({ "text": "离开", "action": [] });
			return ans;
		}
		core.insertAction({ "type": "choices", "text": text, "choices": generate(0) });
	}*/


},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "itemShop": function () {
	// 道具商店相关的插件
	// 可在全塔属性-全局商店中使用「道具商店」事件块进行编辑（如果找不到可以在入口方块中找）

	var shopId = null; // 当前商店ID
	var type = 0; // 当前正在选中的类型，0买入1卖出
	var selectItem = 0; // 当前正在选中的道具
	var selectCount = 0; // 当前已经选中的数量
	var page = 0;
	var totalPage = 0;
	var totalMoney = 0;
	var list = [];

	var bigFont = core.ui._buildFont(20, false),
		middleFont = core.ui._buildFont(18, false);

	this.drawItemShop = function () {
		// 绘制道具商店

		// Step 1: 背景和固定的几个文字
		core.ui._createUIEvent();
		core.clearMap('uievent');
		core.ui._uievent_drawSelector({ "code": 1 });
		core.ui._uievent_drawSelector({ "code": 2 });
		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'top');
		core.fillRect('uievent', 0, 0, 416, 416, 'black');
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 0, width: 416, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 56, width: 312, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 112, width: 312, height: 304 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 312, y: 56, width: 104, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 312, y: 112, width: 104, height: 304 });
		core.setFillStyle('uievent', 'white');
		core.setStrokeStyle('uievent', 'white');
		core.fillText("uievent", "购买", 32, 74, 'white', bigFont);
		core.fillText("uievent", "卖出", 132, 74);
		core.fillText("uievent", "离开", 232, 74);
		core.fillText("uievent", "当前金币", 324, 66, null, middleFont);
		core.setTextAlign("uievent", "right");
		core.fillText("uievent", core.formatBigNumber(core.status.hero.money), 405, 89);
		core.setTextAlign("uievent", "left");
		core.ui._uievent_drawSelector({
			"type": "drawSelector",
			"image": "winskin.png",
			"code": 2,
			"x": 22 + 100 * type,
			"y": 66,
			"width": 60,
			"height": 33
		});
		if (selectItem != null) {
			core.setTextAlign('uievent', 'center');
			core.fillText("uievent", type == 0 ? "买入个数" : "卖出个数", 364, 320, null, bigFont);
			core.fillText("uievent", "◀   " + selectCount + "   ▶", 364, 350);
			core.fillText("uievent", "确定", 364, 380);
		}

		// Step 2：获得列表并展示
		var choices = core.status.shops[shopId].choices;
		list = choices.filter(function (one) {
			if (one.condition != null) {
				try { if (!core.calValue(one.condition)) return false; } catch (e) {}
			}
			return (type == 0 && one.money != null) || (type == 1 && core.hasItem(one.id));
		});
		var per_page = 6;
		totalPage = Math.ceil(list.length / per_page);
		page = Math.floor((selectItem || 0) / per_page) + 1;

		// 绘制分页
		if (totalPage > 1) {
			var half = 156;
			core.setTextAlign('uievent', 'center');
			core.fillText('uievent', page + " / " + totalPage, half, 388, null, middleFont);
			if (page > 1) core.fillText('uievent', '上一页', half - 80, 388);
			if (page < totalPage) core.fillText('uievent', '下一页', half + 80, 388);
		}
		core.setTextAlign('uievent', 'left');

		// 绘制每一项
		var start = (page - 1) * per_page;
		for (var i = 0; i < per_page; ++i) {
			var curr = start + i;
			if (curr >= list.length) break;
			var item = list[curr];
			core.drawIcon('uievent', item.id, 10, 125 + i * 40);
			core.setTextAlign('uievent', 'left');
			core.fillText('uievent', core.material.items[item.id].name, 50, 132 + i * 40, null, bigFont);
			core.setTextAlign('uievent', 'right');
			core.fillText('uievent', (type == 0 ? core.calValue(item.money) : core.calValue(Math.floor(item.money / 2))) + "金币/个", 300, 133 + i * 40, null, middleFont);
			core.setTextAlign("uievent", "left");
			if (curr == selectItem) {
				// 绘制描述，文字自动放缩
				//var text = core.material.items[item.id].text || "该道具暂无描述";
				var text = '';
				if (core.material.items[item.id].equip.atk > 0) text += '攻击+' + core.material.items[item.id].equip.atk;
				else if (core.material.items[item.id].equip.atk < 0) text += '攻击' + core.material.items[item.id].equip.atk;
				if (core.material.items[item.id].equip.def > 0) text += ' 防御+' + core.material.items[item.id].equip.def;
				else if (core.material.items[item.id].equip.def < 0) text += ' 防御' + core.material.items[item.id].equip.def;
				if (core.material.items[item.id].equip.mdef > 0) text += ' 魔防+' + core.material.items[item.id].equip.mdef;
				else if (core.material.items[item.id].equip.mdef < 0) text += ' 魔防' + core.material.items[item.id].equip.mdef;
				//try { text = core.replaceText(text); } catch (e) {}
				for (var fontSize = 20; fontSize >= 8; fontSize -= 2) {
					var config = { left: 10, fontSize: fontSize, maxWidth: 403, lineHeight: 1.4 };
					var height = core.getTextContentHeight(text, config);
					if (height <= 50) {
						config.top = (56 - height) / 2;
						core.drawTextContent("uievent", text, config);
						break;
					}
				}
				core.ui._uievent_drawSelector({ "type": "drawSelector", "image": "winskin.png", "code": 1, "x": 8, "y": 120 + i * 40, "width": 295, "height": 40 });
				if (type == 0 && item.number != null) {
					core.fillText("uievent", "存货", 324, 132, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", item.number, 406, 132, null, null, 40);
				} else if (type == 1) {
					core.fillText("uievent", "数量", 324, 132, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", core.itemCount(item.id), 406, 132, null, null, 40);
				}
				core.setTextAlign("uievent", "left");
				core.fillText("uievent", "预计金额", 324, 250);
				core.setTextAlign("uievent", "right");
				totalMoney = selectCount * (type == 0 ? core.calValue(item.money) : core.calValue(Math.floor(item.money / 2)));
				core.fillText("uievent", core.formatBigNumber(totalMoney), 405, 280);

				core.setTextAlign("uievent", "left");
				core.fillText("uievent", type == 0 ? "已购次数" : "已卖次数", 324, 170);
				core.setTextAlign("uievent", "right");
				core.fillText("uievent", (type == 0 ? item.money_count : item.sell_count) || 0, 405, 200);
			}
		}

		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'alphabetic');
	}

	var _add = function (item, delta) {
		if (item == null) return;
		selectCount = core.clamp(
			selectCount + delta, 0,
			Math.min(type == 0 ? Math.floor(core.status.hero.money / core.calValue(item.money)) : core.itemCount(item.id),
				type == 0 && item.number != null ? item.number : Number.MAX_SAFE_INTEGER)
		);
	}

	var _confirm = function (item) {
		if (item == null || selectCount == 0) return;
		if (type == 0) {
			core.status.hero.money -= totalMoney;
			core.getItem(item.id, selectCount);
			if (item.number != null) item.number -= selectCount;
			item.money_count = (item.money_count || 0) + selectCount;
		} else {
			core.status.hero.money += totalMoney;
			core.removeItem(item.id, selectCount);
			core.drawTip("成功卖出" + selectCount + "个" + core.material.items[item.id].name, item.id);
			if (item.number != null) item.number += selectCount;
			item.sell_count = (item.sell_count || 0) + selectCount;
		}
		selectCount = 0;
	}

	this._performItemShopKeyBoard = function (keycode) {
		var item = list[selectItem] || null;
		// 键盘操作
		switch (keycode) {
		case 38: // up
			if (selectItem == null) break;
			if (selectItem == 0) selectItem = null;
			else selectItem--;
			selectCount = 0;
			break;
		case 37: // left
			if (selectItem == null) {
				if (type > 0) type--;
				break;
			}
			_add(item, -1);
			break;
		case 39: // right
			if (selectItem == null) {
				if (type < 2) type++;
				break;
			}
			_add(item, 1);
			break;
		case 40: // down
			if (selectItem == null) {
				if (list.length > 0) selectItem = 0;
				break;
			}
			if (list.length == 0) break;
			selectItem = Math.min(selectItem + 1, list.length - 1);
			selectCount = 0;
			break;
		case 13:
		case 32: // Enter/Space
			if (selectItem == null) {
				if (type == 2)
					core.insertAction({ "type": "break" });
				else if (list.length > 0)
					selectItem = 0;
				break;
			}
			_confirm(item);
			break;
		case 27: // ESC
			if (selectItem == null) {
				core.insertAction({ "type": "break" });
				break;
			}
			selectItem = null;
			break;
		}
	}

	this._performItemShopClick = function (px, py) {
		var item = list[selectItem] || null;
		// 鼠标操作
		if (px >= 22 && px <= 82 && py >= 71 && py <= 102) {
			// 买
			if (type != 0) {
				type = 0;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 122 && px <= 182 && py >= 71 && py <= 102) {
			// 卖
			if (type != 1) {
				type = 1;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 222 && px <= 282 && py >= 71 && py <= 102) // 离开
			return core.insertAction({ "type": "break" });
		// ◀，▶
		if (px >= 318 && px <= 341 && py >= 348 && py <= 376)
			return _add(item, -1);
		if (px >= 388 && px <= 416 && py >= 348 && py <= 376)
			return _add(item, 1);
		// 确定
		if (px >= 341 && px <= 387 && py >= 380 && py <= 407)
			return _confirm(item);

		// 上一页/下一页
		if (px >= 45 && px <= 105 && py >= 388) {
			if (page > 1) selectItem -= 6;
			return;
		}
		if (px >= 208 && px <= 268 && py >= 388) {
			if (page < totalPage) selectItem = Math.min(selectItem + 6, list.length - 1);
			return;
		}

		// 实际区域
		if (px >= 9 && px <= 300 && py >= 120 && py < 360) {
			if (list.length == 0) return;
			var index = parseInt((py - 120) / 40);
			var newItem = 6 * (page - 1) + index;
			if (newItem >= list.length) newItem = list.length - 1;
			if (newItem != selectItem) {
				selectItem = newItem;
				selectCount = 0;
			}
			return;
		}
	}

	this.performItemShopAction = function () {
		if (flags.type == 0) return this._performItemShopKeyBoard(flags.keycode);
		else return this._performItemShopClick(flags.px, flags.py);
	}

	this.openItemShop = function (itemShopId) {
		shopId = itemShopId;
		type = 0;
		page = 0;
		selectItem = null;
		selectCount = 0;
		core.insertAction([{
				"type": "while",
				"condition": "true",
				"data": [
					{ "type": "function", "function": "function () { core.drawItemShop(); }" },
					{ "type": "wait" },
					{ "type": "function", "function": "function() { core.performItemShopAction(); }" }
				]
			},
			{
				"type": "function",
				"function": "function () { " +
					"core.deleteCanvas('uievent'); " +
					"core.ui._uievent_drawSelector({ \"code\": 1 }); " +
					"core.ui._uievent_drawSelector({ \"code\": 2 }); " +
					"}"
			}
		]);
	}

	// Write item number to save
	core.control.saveData = function () {
		var data = this.controldata.saveData();
		for (var shopId in core.status.shops) {
			if (core.status.shops[shopId].item) {
				data.shops[shopId].choices = core.status.shops[shopId].choices.map(function (t) {
					return {
						number: t.number,
						money_count: t.money_count || 0,
						sell_count: t.sell_count || 0
					}
				});
			}
		}
		return data;
	}

	core.control.loadData = function (data, callback) {
		this.controldata.loadData(data, callback);
		for (var shopId in data.shops) {
			if (data.shops[shopId].choices) {
				for (var i = 0; i < data.shops[shopId].choices.length; ++i) {
					core.status.shops[shopId].choices[i].number = data.shops[shopId].choices[i].number;
					core.status.shops[shopId].choices[i].money_count = data.shops[shopId].choices[i].money_count;
					core.status.shops[shopId].choices[i].sell_count = data.shops[shopId].choices[i].sell_count;
				}
			}
		}
	}

}
}