// 这里需要改楼层名，请和文件名及下面的floorId保持完全一致
// 楼层唯一标识符仅能由字母、数字、下划线组成，且不能由数字开头
// 推荐用法：第20层就用MT20，第38层就用MT38，地下6层就用MT_6（用下划线代替负号），隐藏3层用MT3h（h表示隐藏），等等
main.floors.MT0 = {
    "floorId": "MT0", // 楼层唯一标识符，需要和名字完全一致
    "title": "主塔 0 层", // 楼层中文名
    "name": "0", // 显示在状态栏中的层数
    "canFlyTo": true, // 该楼能否被楼传器飞到（不能的话在该楼也不允许使用楼传器）
    "canUseQuickShop": true, // 该层是否允许使用快捷商店
    "defaultGround": "ground", // 默认地面的图块ID（terrains中）
    "png": [], // 该层默认显示的所有图片；详细用法请查看文档“自定义素材”中的说明。
    // "color": [0,0,0,0.3], // 该层的默认画面色调。本项可不写（代表无色调），如果写需要是一个RGBA数组。
    // "weather": ["snow",5], // 该层的默认天气。本项可忽略表示晴天，如果写则第一项为"rain"或"snow"代表雨雪，第二项为1-10之间的数代表强度。
    // "bgm": "bgm.mp3", // 到达该层后默认播放的BGM。本项可忽略。
    "map": [ // 地图数据，需要是13x13，建议使用地图生成器来生成
        [  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4],
        [  4,  4,  4,  3,  4,  3,  4,  3,  4,  3,  4,  4,  4],
        [  4,  4,  3, 27,  3, 28,  3, 27,  3, 28,  3,  4,  4],
        [  4,  3, 28,253,  0,214,  3,228,  0,225, 27,  3,  4],
        [  4,  4,  3,  3,  0,  0,  0,  0,  0,  3,  3,  4,  4],
        [  4,  3, 27,212,  0,  0, 3,  0,  0,222, 28,  3,  4],
        [  4,  4,  3,  3,  0, 3,229, 3,  0,  3,  3,  4,  4],
        [  4,  3, 28,208,  0,  0, 3,  0,  0,246, 27,  3,  4],
        [  4,  4,  3,  3,  0,  0,  0,  0,  0,  3,  3,  4,  4],
        [  4,  3, 27,243,  0,255,  3,210,  0,219, 28,  3,  4],
        [  4,  4,  3, 28,  3, 27,  3, 28,  3, 27,  3,  4,  4],
        [  4,  4,  4,  3,  4,  3,  4,  3,  4,  3,  4,  4,  4],
        [  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4,  4]
    ],
    "firstArrive": [ // 第一次到该楼层触发的事件
        {"type": "if", "condition": "flag:hard==1",
        "true": [
            "该模式下，按P键可以查看路线，不可提交成绩",
        ],
        "false": [
            "该模式下，不可查看路线，满15个轮回可提交成绩"
        ]
        }, 
        {"type": "setValue", "name": "item:book", "value": "item:book+1"},
        {"type": "trigger", "loc": [1, 1]},

    ],

    "events": { // 该楼的所有可能事件列表
        "1,1": [ // 实际执行的事件列表
            {"type": "function", "function": function(){ // 执行一段js脚本
            ClearArray();
            while(!core.isset(path[100]) ||path[100]==0 )
                {
              ClearArray();

               FlagData("hp1","atk1","def1","grayPriest");
               EnemyData("hp1","atk1","def1","grayPriest");

               FlagData("hp2","atk2","def2","zombieKnight");
               EnemyData("hp2","atk2","def2","zombieKnight"); 

               FlagData("hp3","atk3","def3","darkKnight");
               EnemyData("hp3","atk3","def3","darkKnight"); 

               FlagData("hp4","atk4","def4","soldier");
               EnemyData("hp4","atk4","def4","soldier"); 

               FlagData("hp5","atk5","def5","ghostSkeleton");
               EnemyData("hp5","atk5","def5","ghostSkeleton"); 

               FlagData("hp6","atk6","def6","blueGuard");
               EnemyData("hp6","atk6","def6","blueGuard"); 

               FlagData("hp7","atk7","def7","vampire");
               EnemyData("hp7","atk7","def7","vampire"); 

               FlagData("hp8","atk8","def8","whiteKing");
               EnemyData("hp8","atk8","def8","whiteKing"); 

               FlagData("hp9","atk9","def9","demonPriest");
               EnemyData("hp9","atk9","def9","demonPriest"); 

               FlagData("hp10","atk10","def10","whiteGhost");
               EnemyData("hp10","atk10","def10","whiteGhost"); 

               FlagData("hp11","atk11","def11","skeletonSoilder");
               EnemyData("hp11","atk11","def11","skeletonSoilder"); 

               FlagData("hp12","atk12","def12","brownWizard");
               EnemyData("hp12","atk12","def12","brownWizard"); 
 
               dfs(maxc,maxc);
            }
               core.setFlag("atk13", path[100]-1);
               core.material.enemys.blackKing.atk=core.getFlag("atk13", 0);
            
                core.updateStatusBar();
                core.setFlag('OK', 1);
            }},

            {"type": "if", "condition": "flag:hard==1",
            "true": [
                

            ],
            "false": [
                {"type": "function", "function": function(){ // 执行一段js脚本
                    // 这里写js代码
                    path.length=0;
                    //path[100]=0;
                }},
            ]

            }, 

        ],

        "6,6": {//
            "trigger": "action",
            "data": [
            {"type": "battle", "id": "blackKing"},
            {"type": "hide"},
            "\t[blackKing]进入下一轮回……\n\n当前你的的分数是${status:money+status:hp}\n",
            {"type": "if", "condition": "status:money+status:hp>=360", // 一个条件判断事件，条件是"door"这个flag值等于2
                "true": [ // 如果条件成立：打开机关门
                    {"type": "choices", "text": "提交成绩可结束轮回，继续可获得更高的成绩。", // 提示文字
                    "choices": [
                        
                        {"text": "提交成绩", "action": [
                            {"type": "if", "condition": "flag:hard==3", // 判断攻击力是否大于500
                            "true": [ // 条件成立则执行true里面的事件
                                {"type": "setValue", "name": "status:hp", "value": "status:money+status:hp"},
                                {"type": "win"},// 选项1执行的事件
                                {"type": "exit"} // 立刻结束本事件
                            ],
                            "false": [ // 条件不成立则执行false里的事件
                                "练习模式下不能上传成绩",
                                
                            ]
                        },
        
                        ]},
                        {"text": "继续轮回", "action": [
                                // 选项2执行的事件
                        ]},
                ],
                "false": [] // 如果条件不成立则无事件触发
            },
 

            ]
        },
            
            {"type": "setValue", "name": "status:hp", "value": "10000"},
            {"type": "setValue", "name": "status:atk", "value": "36"},
            {"type": "setValue", "name": "status:def", "value": "20"},
            {"type": "changePos", "loc": [6,8], "direction": "down"}, 
            {"type": "show", "loc": [6,6]},
            {"type": "setValue", "name": "flag:number", "value": "0"},
            {"type": "setBlock", "loc": [2,3], "number": 28},
            {"type": "setBlock", "loc": [2,5], "number": 27},
            {"type": "setBlock", "loc": [2,7], "number": 28},
            {"type": "setBlock", "loc": [2,9], "number": 27},
            {"type": "setBlock", "loc": [3,2], "number": 27},
            {"type": "setBlock", "loc": [6,5], "number": 3},
            {"type": "setBlock", "loc": [6,7], "number": 3},
            {"type": "setBlock", "loc": [5,6], "number": 3},
            {"type": "setBlock", "loc": [7,6], "number": 3},
            {"type": "setBlock", "loc": [3,3], "number": 253},
            {"type": "setBlock", "loc": [3,5], "number": 212},
            {"type": "setBlock", "loc": [3,7], "number": 208},
            {"type": "setBlock", "loc": [3,9], "number": 243},
            {"type": "setBlock", "loc": [3,10], "number": 28},
            {"type": "setBlock", "loc": [5,3], "number": 214},
            {"type": "setBlock", "loc": [5,2], "number": 28},
            {"type": "setBlock", "loc": [5,9], "number": 255},
            {"type": "setBlock", "loc": [5,10], "number": 27},
            {"type": "setBlock", "loc": [7,3], "number": 228},
            {"type": "setBlock", "loc": [7,2], "number": 27},
            {"type": "setBlock", "loc": [7,9], "number": 210},
            {"type": "setBlock", "loc": [7,10], "number": 28},
            {"type": "setBlock", "loc": [9,2], "number": 28},
            {"type": "setBlock", "loc": [9,3], "number": 225},
            {"type": "setBlock", "loc": [9,5], "number": 222},
            {"type": "setBlock", "loc": [9,7], "number": 246},
            {"type": "setBlock", "loc": [9,9], "number": 219},
            {"type": "setBlock", "loc": [9,10], "number": 27},
            {"type": "setBlock", "loc": [10,3], "number": 27},
            {"type": "setBlock", "loc": [10,5], "number": 28},
            {"type": "setBlock", "loc": [10,7], "number": 27},
            {"type": "setBlock", "loc": [10,9], "number": 28},

            {"type": "trigger", "loc": [1, 1]},
            ]

        },
    },
    "changeFloor": { // 楼层转换事件；该事件不能和上面的events有冲突（同位置点），否则会被覆盖

    },
    "afterBattle": { // 战斗后可能触发的事件列表

    },
    "afterGetItem": { // 获得道具后可能触发的事件列表

    },
    "afterOpenDoor": { // 开完门后可能触发的事件列表

    },
    "cannotMove": { // 每个图块不可通行的方向
        // 可以在这里定义每个点不能前往哪个方向，例如悬崖边不能跳下去
        // "x,y": ["up", "left"], // (x,y)点不能往上和左走

    },
}

