!async function () {
    window.core = new Core();
    const loadList = ['./enemys.js', '../project/functions.js']
    await core.loadJs(loadList)
    const battleList = [
        "./src/Battler.js",
        "./src/Damage.js",
        "./src/Skill.js",
        "./src/Battle.js",
    ]
    for (let j of battleList) {
        await core._loadJs(j)
    }
    const vm = new Vue({
        el: "#app",
        data: {
            showLog: true,
            enemies: {},
            selectedEnemyId: "",
            HERO: new Hero(),
            output: {},
            logs: [],
            __FACTORS__: [],
            realFactors: [],
            calFactors: {}
        },
        methods: {
            loadEnemies() {
                this.enemies = {}
                for (let e of Object.entries(enemys_fcae963b_31c9_42b4_b48c_bb48d09f3f80)) {
                    if (e[1].atkSpeed) {
                        this.enemies[e[0]] = e[1]
                    }
                }
            },
            handleInput(k, e) {
                this.$set(this.HERO, k, e.target.value);
                this.$forceUpdate()
            },
            testChange(k) {
                return ["atk", "def", "armor", "hp", "hpmax", "magicResistance", "atkSpeed", "shield"].includes(k)
            },
            battle() {
                // this.HERO.buff['skill_no1']=100
                let _e = this.enemies[this.selectedEnemyId]
                if (!_e) return
                let e = new Enemy(_e)
                window.logs = []
                battle(this.HERO, e, this.calFactors);
                this.logs = window.logs
                e.skills = []
                this.output = e;
            },
            getRealFactors() {
                if (!this.__FACTORS__) { this.realFactors = [] } else {
                    this.realFactors = this.__FACTORS__.filter(x => x.choosed)
                    this.realFactors.forEach(x => x.desc2 = x.desc(x.value))
                }
                this.calFactors = {}
                for (let k of this.realFactors) {
                    this.calFactors[k.id] = k.start + k.value * k.range
                }
            }
        },
        computed: {
            selectedEnemy() {
                return this.output;
            },
        },
        mounted() {
            this.loadEnemies();
            this.HERO = new Hero();
            this.__FACTORS__ = window.__FACTORS__
            this.__FACTORS__.forEach(x => { x.value = 1; x.desc1 = x.desc(1); x.choosed = false })
        }
    })
}()
