// core={}
// core.getStatus=function(){}
// core.getFloorCache = function(){}
/*
战斗流程
战斗前预处理（双方成员确定→战前使用的技能→先手判定→部分开场自动生效的装备效果）
之后直到分出胜负前循环进行如下过程：
我方使用技能（如果当前回合我方未被沉默）
我方进行一回合普攻，造成[自身攻击-目标防御]*我方攻速系数*目标护甲减伤*目标闪避减伤的物理伤害（如果当前回合我方未被缴械）
敌方使用技能（如果当前回合敌方未被沉默）
敌方进行一回合普攻，造成[敌方攻击-我方防御]*敌方攻速系数*我方护甲减伤*我方闪避减伤的物理伤害（如果当前回合敌方未被缴械）
如果存在多个敌人，那么直到所有敌人行动完毕（使用技能和普攻）才会结束本回合
*/

//战斗前预处理（双方成员确定→战前使用的技能→先手判定→部分开场自动生效的装备效果）

//获取对战双方
function startBattle(hero, e) {
    log(`${hero.name} VS ${e.name}`)
    e.damge = 0
    e.skills = []
    e.caled = {}
    hero.realAtk = hero.atk
    hero.realAtkSpeed = hero.atkSpeed
    window._realSkillList = []
    e.realAtk = e.atk
    e.realMpCost = 0
    e.realhp = e.hp
}
//根据敌人种类 依次处理开场自动生效的效果
function beforeBattle(hero, e, options) {
    //祝福技能 霜甲术
    if (hero.buff['skill_no1'] > 0 && !e.caled['skill_no1']) {
        e.atkSpeed -= 15
        log(`${hero.name}被动霜甲术,${e.name}攻速变为${e.atkSpeed}`)
        e.caled['skill_no1'] = true
    }
    //101 嗜血 , 敌人血量已损失1%，就能获取"+e.value[101]+"%的攻速
    if (e.hasSpecial(101) && !e.caled[101]) {
        let rate = hero.hp / hero.hpmax
        let percent = 1 - rate
        e.atkSpeed += Math.floor(percent * e.value[101] * 100)
        e.caled[101] = true
        log(`${e.name}被动嗜血,攻速变为${e.atkSpeed}`)
    }
    //102 腐蚀毒素每回合造成无视防御的"+e.value[102]+"点物理伤害
    if (e.hasSpecial(102) && !e.caled[102]) {
        //剧毒伤害
        e.extra_atk["poison"] = e.value[102]
        e.caled[102] = true
        log(`${e.name}被动腐蚀毒素,每回合额外${e.value[102]}点物理伤害`)
    }
    //[105,"致命伤",function(e){return "有"+e.value[105][0]+"%的几率可以在自身攻击时造成"+e.value[105][1]+"倍伤害,第一回合必定暴击"}],
    if (e.hasSpecial(105) && !e.caled[105]) {
        log(`${e.name}发动致命伤,有${e.value[105][0]}%的几率可以在自身攻击时造成${e.value[105][1]}倍伤害,第一回合必定暴击`)
        e.addSkill(hero, 105)
        e.caled[105] = true
    }
    //[106,"炎爆术",function(e){return `连续${e.value[106][0]}回合不攻击,每回合发动炎爆造成${e.value[106][1]}点魔法伤害`}],
    if (e.hasSpecial(106) && !e.caled[106]) {
        log(`${e.name}发动炎爆,有${e.value[106][0]}回合不攻击而是造成${e.value[106][1]}魔法伤害`)
        e.addSkill(hero, 106)
        e.caled[106] = true
    }
    //[107,"撕裂肉体",function(e){return `连续${e.value[106][0]}回合不攻击,每回合发动炎爆造成${e.value[106][1]}点魔法伤害`}],
    if (e.hasSpecial(107) && !e.caled[107]) {
        log(`${e.name}发动撕裂肉体,连续${e.value[107][0]}回合使敌人减少攻速${e.value[107][1]}并使${e.value[107][2]}%伤害量治疗自己`)
        e.addSkill(hero, 107)
        e.caled[107] = true
    }
    //[2, "魔攻", "怪物无视勇士的防御"],
    if (e.hasSpecial(2) && !e.caled[2]) {
        log(`${e.name}发动魔攻,怪物无视勇士的防御(只计算护盾)`)
        e.buff.atkType = 'real'
        e.caled[2] = true
    }
    //[110, "n连击", "怪物每回合攻击n次"],
    if (e.hasSpecial(110) && !e.caled[110]) {
        var value = e.value[110] || 2
        log(`${e.name}发动${value}连击`)
        e.buff.atkPerTurn = value
        e.caled[110] = true
    }
    //111"每有共生属性的怪物的血量增加"+(e.value[111][0]||0)+"%,生命增加"+(e.value[111][1]||0)+"%"
    var floorCache = core.getFloorCache()||{}
    if (e.hasSpecial(111) && floorCache.cnt111 && !e.caled[111]) {
        var cnt = floorCache.cnt111 - 1
        log(`${e.name}发动共生,当前楼层共有${cnt}个额外的共生怪物`)
        if (cnt >= 0) {
            e.hp *= ((1 + (e.value[111][0] || 0) * cnt/100))
            e.atk *= ((1 + (e.value[111][1] || 0) * cnt/100))
            e.caled[111] = true
        }
    }
}
//主处理
//相互进行普通攻击而不进行其他任何操作
function loopAttack(hero, enemy, crit) {
    enemy.resetAttr()
    hero.resetAttr()
    log(`开始互A`)
    //我方进行普通攻击 造成[自身攻击-目标防御]*我方攻速系数
    hero.perdamage = hero.getDefaultAtkDamage(enemy, crit)
    if (hero.perdamage <= 0) {
        log(`打不过,溜了溜了`)
        enemy.damage = null
        return null
    }
    //计算回合数
    let turn = Math.ceil(enemy.realhp / hero.perdamage)
    log(`需要攻击${turn}回合`)
    //敌人对我方伤害
    let defaultPerDamage = enemy.getDefaultAtkDamage(hero)
    log(`每回合被普攻伤害为${defaultPerDamage},${turn - 1}回合 伤害为:${defaultPerDamage * (turn - 1)}`)
    enemy.damage += defaultPerDamage * (turn - 1)
    for (let k in enemy.specialAttr) {
        log(`${enemy}的${k}伤害 ${enemy.specialAttr[k]}点,${turn - 1}回合 伤害为:${enemy.specialAttr[k] * hero.calArmor() * (turn - 1)}`)
        enemy.damage += enemy.specialAttr[k] * hero.calArmor() * (turn - 1)
    }
    //判断敌人是否有反击
    if (enemy.hasSpecial(103)) {
        let counterPerDamage = enemy.getUnparriedCounterAtkDamage(hero)
        log(`${enemy.name}的反击伤害 ${counterPerDamage}点,${turn}回合 伤害为:${counterPerDamage * (turn)}`)
        enemy.damage += counterPerDamage * (turn)
    }
    enemy.turn += turn
    log(`互A回合数:${turn}`)
}
//处理与战斗相关的因子
/*,
    {id:2,name:'前路崎岖',desc:function(x){return '地图变化时,损失'+(10+x)+'生命值'},callback(){}},
    {id:4,name:'固伤射击',desc:function(x){return '怪物增加射击属性,伤害为'+14*x}},
    {id:8,name:'负重练习',desc:function(){return "主角攻速减少30%"}},
 */

function battle(hero, enemy, options) {
    window.logs = []
    startBattle(hero, enemy)
    beforeBattle(hero, enemy, options)
    enemy.turn = 0
    //计算蓝耗
    let _cost = 0;
    let skillData = core.getStatus('__ALL_SKILL_DATA__')
    // hero.skillList = [2]
    for (let _s in hero.skillList) {
        let s = hero.skillList[_s]
        if (!s) {
            _realSkillList.push(0)
        } else {
            if (hero.mp >= _cost + skillData[s].cost) {
                _realSkillList.push(new HeroSkill(skillData[s], hero, enemy))
                _cost += skillData[s].cost
            }
        }
    }
    // _realSkillList = [new HeroSkill({id:2, value: [40, 5, 5],name:'fireball'},hero,enemy)]
    while (_realSkillList.length != 0 || enemy.skills.length != 0) {
        enemy.resetAttr()
        hero.resetAttr()
        enemy.turn++
        log(`第${enemy.turn}回合`)
        if (_realSkillList.length != 0) {
            var s = _realSkillList.shift();
            if (s instanceof HeroSkill && s.id > 0) {
                if (s.cost || 0 + enemy.realMpCost <= hero.mp) {
                    s.doBattle(enemy);
                    enemy.realMpCost += (s.cost || 0)
                }
            }
            if (!hero.buff['silence']) {
                Skill.doAttack(hero, enemy);
                if (enemy.hasSpecial(103)) {
                    let counterPerDamage = enemy.getUnparriedCounterAtkDamage(hero)
                    log(`${enemy.name}的反击伤害 ${counterPerDamage}点`)
                    enemy.damage += counterPerDamage
                }
            }
        } else {
            Skill.doAttack(hero, enemy);
        }
        //判断是否结束
        if (enemy.isDead()) break
        if (enemy.skills.length != 0) {
            let e = enemy.skills.shift()
            e.doBattle(hero);
        } else {
            Skill.doAttack(enemy, hero);
        }
        if (enemy.isDead()) break
        log(`此时${enemy.name}血量为${enemy.realhp},伤害为:${enemy.damage}`)
    }
    if (!enemy.isDead()) {
        loopAttack(hero, enemy)
    }
    if (enemy.damage) {
        enemy.damage = Math.floor(enemy.damage)
    }
    //固伤
    if (enemy.damage != null && enemy.hasSpecial(109)) {
        enemy.damage += enemy.value[109]
        log(`${enemy.name}固定伤害为${enemy.value[109]}`)
    }
    enemy.realMpCost = _cost
    if (hero.mpRegen > 0) {
        enemy.realMpCost -= Math.floor(hero.mpRegen * enemy.turn)
    }
    if(hero.mpLastRegen>0){
        enemy.realMpCost -= hero.mpLastRegen
    }
    if(hero.shield>0){
        log(`${enemy.name}总伤害为${enemy.damage},减去护盾:${hero.shield}`)
        enemy.damage -= hero.shield
        if(enemy.damage<0){
            enemy.damage = 0
        }
    }
    log(`${enemy.name}总伤害为${enemy.damage},回合数为:${enemy.turn},耗蓝为${enemy.realMpCost}`)
}

