
class Battler {
    constructor(option) {
        const __option__ = {
            //基本属性
            name: "",
            //生命 表示战斗者所拥有的生命值，生命值归零,战斗者将死亡
            hp: 200,
            //怒气 表示战斗者所拥有的怒气值，怒气值可以用来施放技能
            mp: 100,
            //攻击 表示攻击力，攻击力大小决定了每次普攻对敌人造成的伤害
            atk: 2,
            //防御 表示防御力，防御力大小决定了每次受到普攻时能够减少的伤害
            def: 1,
            //攻速 表示攻击速度，战斗者每回合普攻造成的伤害会乘上一个攻速带来的系数,具体为[攻速的平方根/10]
            atkSpeed: 100,
            //护甲 表示对物理类伤害的削弱能力，每点护甲会意味着在受到物理伤害时每一点生命将额外多承受6%的伤害
            armor: 0,
            //魔抗
            magicResistance: 0,
            //魔防 固定减少魔法伤害
            mdef: 0,
            hpRegen: 0,
            mpRegen: 0,
            //招架
            parry: 0,
            //暴击
            crit: [0, 1],
            //每回合伤害
            perDamage: 0,
            //额外攻击属性
            extra_atk: {},
            buff: {},
            turnBuff:{},
            lv:1
        }
        Object.assign(this, __option__, option)
        this.realhp = this.hp
        //主动技能
        this.skills = []
        this.skillList = []
        this.realAtkSpeed = this.atkSpeed
    }
    //重置部分属性
    resetAttr() {
        this.realAtkSpeed = this.atkSpeed
        this.realAtk = this.atk
        this.turnBuff={}
    }
    isDead(){
        return this.realhp<=0
    }

    //获取护甲减伤系数
    calArmor() {
        this.armorEffect = parseFloat(100 / (100 + 6 * this.armor))
        return this.armorEffect
    }
    //获取攻速增伤系数
    calAtkSpd() {
        if(this.turnBuff['atkSpeed']){
            this.realAtkSpeed+=this.turnBuff['atkSpeed']
        }
        if (this.realAtkSpeed < 0) { return 0 }
        this.atkSpdEffect = parseFloat(Math.sqrt(this.realAtkSpeed / 100))
        return this.atkSpdEffect
    }
    //获取招架减伤系数
    calParry() {
        this.parryEffect = (100 - this.parry) / 100
        if (this.parryEffect < 0) {
            this.parryEffect = 0
        }
        return this.parryEffect
    }

    calMagicResistance() {
        this.magicResistanceEffect = 1 - this.magicResistance / 100;
        return this.magicResistanceEffect
    }

    calMdef() {
        return this.mdef || 0
    }
    //获取每次普攻伤害造成的伤害值
    getPerDefaultAtkDamage(enemy) {
        let res = [];
        //普攻伤害
        let defaultAtkDamage = this.realAtk
        let atkType = 'normal'
        if(this.buff.atkType){
            atkType = this.buff.atkType
        }
        if (defaultAtkDamage > 0) {
            res.push(new Damage(this, defaultAtkDamage,atkType))
        } else {
            res["defaultAtkDamage"] = 0
        }
        log(`每次普攻造成伤害${this.realAtk}-${enemy.def}=${defaultAtkDamage}`)
        //其他伤害
        if (this.extra_atk) {
            for (let t in this.extra_atk) {
                res.push(new Damage(this, this.extra_atk[t], t))
                log(`伤害类型:${t}---${this.extra_atk[t]}`)
            }
        }
        if(enemy.buff&&enemy.buff.atkPerTurn){
            console.log(enemy.buff.atkPerTurn)
            res*=enemy.buff.atkPerTurn
            log(`每回合攻击${enemy.buff.atkPerTurn}次`)
        }
        return res
    }
    //进行普通攻击伤害 造成[自身攻击-目标防御]*我方攻速系数*目标闪避减伤的物理伤害*暴击系数（如果当前回合我方未被缴械）
    getDefaultAtkDamage(enemy, crit = false) {
        log(`计算${this.name}对${enemy.name}的普攻`)
        let critEffect = 1
        if (crit) {
            critEffect = this.crit[1]
            log(`必定暴击`)
        } else {
            critEffect = (1 + this.crit[0] * (this.crit[1] - 1) / 100)
        }
        this.critEffect = critEffect
        log(`暴击伤害系数为${this.critEffect}`)
        let result = 0
        let perDamage = this.getPerDefaultAtkDamage(enemy)
        perDamage.forEach(d => result += (d.cal(enemy, critEffect) || 0))
        log(`伤害为${result}`)
        return result
    }
    //获取反击伤害(无法招架)
    getUnparriedCounterAtkDamage(enemy) {
        log('计算反击伤害')
        let result = 0
        let perDamage = this.getPerDefaultAtkDamage(enemy).filter(x => x.isCounter)
        perDamage.forEach(d => {
            d.calSpeed = false
            result += (d.cal(enemy) || 0)
        })
        log(`伤害为${result}`)
        return result
    }
    //添加技能
    addSkill(target, id) {
        switch (id) {
            case 106:
                for (let i = 0; i < this.value[106][0]; i++) {
                    this.skills.push(new Skill(this, target, id, this.value[106][1]))
                }
                break;
            case 107:
                for (let i = 0; i < this.value[107][0]; i++) {
                    this.skills.push(new Skill(this, target, id, [this.value[107][1], this.value[107][2]]))
                }
                break;
            default:
                this.skills.push(new Skill(this, target, id, this.value[id]))
        }
    }
}
/*--------------------------------------------------------------*/

//英雄类
class Hero extends Battler {
    constructor(option) {
        super(option)
        const __option__ = {
            //基本属性
            name: "hero",
            hp: 1000,
            hpmax: 1000,
            atk: 38,
            def: 38,
            armor: 3,
            magicResistance: 0,
            //怒气 表示战斗者所拥有的怒气值，怒气值可以用来施放技能
            mp: 100,
            hp_regen: 0,
            mpRegen: 0,
            //法强
            matk:0,
            //护盾
            shield:0,
            //能量最终回复
            mpLastRegen:0
        }
        Object.assign(this, __option__, option)
    }

}
/*--------------------------------------*/


//敌人类
class Enemy extends Battler {
    constructor(option) {
        super(option);
        const __DEFAULT__ = {
            turn: 0, damage: 0, special: null
        }
        Object.assign(this, __DEFAULT__, option)
        this.specialAttr = null
        //每次攻击额外伤害(不计算攻速)
        this.extra_atk_nospeed = 0
        //招架属性
        if (this.hasSpecial(104)) {
            this.parry = this.value[104]
        }
        //暴击属性
        if (this.hasSpecial(105)) {
            this.crit = this.value[105]
        }
        //战斗耗蓝
        this.realMpCost = 0
    }
    //判断是否拥有某特性
    hasSpecial(id) {
        if (this.special) {
            if (this.special instanceof Array) {
                return this.special.indexOf(id) >= 0
            } else if (typeof (this.special) == 'number') {
                return this.special === id
            }
        }
        return false
    }

    addSpecial(specialId, v) {
        if (!this.special) {
            this.special = specialId
        } else if (typeof this.special == 'number') {
            if (this.special != specialId) {
                this.special = [this.special, specialId]
            }
        } else if (this.special instanceof Array && this.special.indexOf(specialId) >= 0) {

        } else {
            this.special = [...this.special, specialId]
        }
        if (!this.value) {
            this.value = {}
            this.value[specialId] = v
        } else if (this.value[specialId]) {
            this.value[specialId] += v
        } else {
            this.value[specialId] = v
        }
    }

}