class Damage {
    constructor(attacker, val, type = "normal", damageType = "physics") {
        //默认为普攻伤害
        //伤害值
        this.value = val;
        this.type = type
        //伤害类型 默认为物理
        this.damageType = damageType
        //是否计算防御
        this.calDef=true
        //是否计算护甲
        this.calArmor = true
        //是否计算攻速
        this.calSpeed = true
        //是否计算暴击
        this.calCrit = true
        //是否计算闪避/招架
        this.calParry = true
        //是否计算魔抗
        this.calMagicResistance = false
        //是否计算魔防
        this.calMdef = false
        //反击时是否计入
        this.isCounter = true
        this.attacker = attacker;
        this.calType()
    }
    calType() {
        let type = this.type || 'normal';
        if (type == 'real') {
            this.damageType = 'real'
            this.calDef=false
            this.calArmor = false
            this.calSpeed = true
            this.calCrit = true
            this.calParry = false
            this.calMagicResistance = false
            this.calMdef = false
            this.isCounter = true
        }
        if (type == "poison") {
            this.calDef=false
            this.calSpeed = false
            this.calCrit = false
            this.calParry = false
        }
        if (this.damageType == "magic") {
            this.calDef=false;
            this.calArmor = false;
            this.calMagicResistance = true
            this.calMdef = true
            this.calSpeed = false
            this.calCrit = false
            this.calParry = false
        }
    }
    cal(b, critVal = 1, direct = false) {
        let res = this.value || 0
        let out = `类型:${this.type},${this.value}(原始值)`
        //非直接计算
        if (!direct) {
            if (this.attacker.buff.percentRealDamage) {
                let v = this.attacker.buff.percentRealDamage;
                let d1 = new Damage()
                Object.assign(d1,this)
                d1.value *=((100-v)/100)
                let d2 = new Damage()
                Object.assign(d2,this)
                d2.value*=(v/100)
                d2.type = 'real'
                d2.calType()
                log(`有${v}%变成了真实伤害!太真实了`)
                return d1.cal(b, critVal, true) + d2.cal(b, critVal, true)
            }
        }
        //处理增伤与减伤buff
        if (this.attacker.buff.damage) {
            let v = this.attacker.buff.damage;
                res*=(100+v)/100
                out += `*${1+v}%${this.attacker.name}的增(减)伤伤buff)`
        }
        if (this.calDef) {
            res -= (b.def||0)
            out += `-${(b.def)||0}(防御)`
        }
        if (this.calArmor) {
            res *= b.calArmor()
            out += `*${b.calArmor()}(护甲)`
        }
        if (this.calSpeed) {
            res *= this.attacker.calAtkSpd()
            out += `*${this.attacker.calAtkSpd()}(攻速)`
        }
        if (this.calCrit) {
            res *= critVal
            out += `*${critVal}(暴击)`
        }
        if (this.calParry) {
            res *= b.calParry()
            out += `*${b.calParry()}(招架)`
        }
        if (this.calMagicResistance) {
            res *= b.calMagicResistance()
            out += `*${b.calMagicResistance()}(魔抗)`
        }
        if (this.calMdef) {
            res -= b.calMdef()
            if (res < 0) {
                res = 0
            }
            out += `-${b.calMdef()}(魔防)`
        }

        log(out + ` = ${res}`)
        return Math.max(res,0);
    }
}