class Skill {
    constructor(caster, target, id = 0, value) {
        this.id = id;
        this.name = this.getName();
        this.value = value
        this.caster = caster
        this.target = target
        this.cost = 0
    }
    getName() {
        switch (this.id) {
            case 0:
                return "普通攻击"
            case 105:
                return "暴击"
            case 106:
                return "炎爆术"
            case 107:
                return "撕裂肉体"
        }
    }
    static doAttack(caster, target) {
        log(`${caster.name}对${target.name}使用了普通攻击`)
        if (caster instanceof Hero) {
            target.realhp -= caster.getDefaultAtkDamage(target)
        } else {
            caster.damage += caster.getDefaultAtkDamage(target)
        }
    }
    doBattle() {
        log(`${this.caster.name}对${this.target.name}使用了${this.name}`)
        switch (this.id) {
            //暴击
            case 105:
                this.caster.damage += this.caster.getDefaultAtkDamage(this.target, true)
                break;
            //106 炎爆术
            case 106:
                this.caster.damage += (new Damage(this.caster, this.value, "Pyroblast", "magic")).cal(this.target)
                break;
            case 107://撕裂肉体 使敌人减少攻速${e.value[107][1]}并使${e.value[107][2]}%伤害量治疗自己
                //临时减攻速
                // this.target.realAtkSpeed= this.target.atkSpeed-this.value[0]
                this.target.turnBuff["atkSpeed"] = -this.value[0]
                let d = this.caster.getDefaultAtkDamage(this.target)
                this.caster.damage += d;
                log(`${this.caster.name}造成了${d}的伤害`)
                this.caster.realhp += d * this.value[1] / 100
                log(`${this.caster.name}回复了${d * this.value[1] / 100}的血量`)
                break;
            default:
        }
    }
}


class HeroSkill extends Skill {
    constructor(s, hero, enemy) {
        super(hero, enemy, s.id)
        this.name = s.name;
        Object.assign(this, s)
        this.caster = hero
        this.target = enemy
    }
    doBattle() {
        log(`${this.caster.name}对${this.target.name}使用了${this.name}`)
        switch (this.id) {
            //2 火球术 在本回合普攻后释放一个巨大的火球攻击敌人,对敌人造成' 40+matk*10 '点魔法伤害,消耗15点魔法,并在接下来的5回合内造成每回合5的灼烧伤害。value:[40,5,5]
            case 2:
                var _d = this.value[0];
                if (this.caster.matk > 0) {
                    _d += this.matkEffect * this.caster.matk;
                }
                this.target.realhp -= (new Damage(this.caster, _d, "fire", "magic")).cal(this.target)
                new HeroSkill({ id: 1002, name: 'firing', value: this.value[2] }, this.caster, this.target).doBattle();
                for (let i = 0; i < this.value[1] - 1; i++) {
                    if (window._realSkillList) {
                        window._realSkillList.unshift(new HeroSkill({ id: 1002, name: 'firing', value: this.value[2] }, this.caster, this.target))
                    }
                }
                break;
            case 1002:
                this.target.realhp -= (new Damage(this.caster, this.value, "firing", "magic")).cal(this.target)
                break;
            //刺骨 消耗全部连击点数及16能量,本回合增加[60,120,200,280,380,500]的攻击力 精英变为1/3
            case 5:
                var point  = this.caster.buff['comboPoints']['number']||0
                var per = this.value[point]
                if(this.target.specialName){
                    per = per/3
                }
                per = 1+per/100
                log(`连击点数为${point},当前回合变为${per}攻击力`)
                this.caster.realAtk *=per;
                break
            default:
        }
    }
}