var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	// 可以写一些直接执行的代码
	// 在这里写的代码将会在【资源加载前】被执行，此时图片等资源尚未被加载。
	// 请勿在这里对包括bgm，图片等资源进行操作。


	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作，比如切分图片等。

		// 这是一个将assets.png拆分成若干个32x32像素的小图片并保存的样例。
		// var arr = core.splitImage("assets.png", 32, 32);
		// for (var i = 0; i < arr.length; i++) {
		//     core.material.images.images["asset"+i+".png"] = arr[i];
		// }

	}

	core.control.drawHero = function (status, offset) {
		if (!core.isPlaying() || !core.status.floorId || core.status.gameOver) return;
		var x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y'),
			direction = core.getHeroLoc('direction');
		status = status || 'stop';
		offset = offset || 0;
		var way = core.utils.scan[direction];
		var dx = way.x,
			dy = way.y,
			offsetX = dx * offset,
			offsetY = dy * offset;
		core.bigmap.offsetX = core.clamp((x - core.__HALF_SIZE__) * 32 + offsetX, 0, 32 * core.bigmap.width - core.__PIXELS__);
		core.bigmap.offsetY = core.clamp((y - core.__HALF_SIZE__) * 32 + offsetY, 0, 32 * core.bigmap.height - core.__PIXELS__);
		core.clearAutomaticRouteNode(x + dx, y + dy);
		core.clearMap('hero');
		core.status.heroCenter.px = 32 * x + offsetX + 16;
		core.status.heroCenter.py = 32 * y + offsetY + 32 - core.material.icons.hero.height / 2;

		if (!core.hasFlag('hideHero')) {
			this._drawHero_getDrawObjs(direction, x, y, status, offset).forEach(function (block) {
				core.drawImage('hero', block.img, block.heroIcon[block.status] * block.width,
					block.heroIcon.loc * block.height, block.width, block.height,
					block.posx + (32 - block.width) / 2, block.posy + 64 - block.height, block.width, block.height);
			});
		}

		core.control.updateViewport();
		core.setGameCanvasTranslate('hero', 0, 0);
	}

	core.registerReplayAction('turn2', function (action) {
		//if (action != 'turn2' && action.indexOf('turn2:') != 0) return false;
		if (action != 'turn2') return false;
		core.turn2Hero();
		//else core.turn2Hero(action.substring(6));
		setTimeout(core.replay);
		return true;
	});

	core.registerReplayAction('move2', function (action) {
		if (["forward", "backward"].indexOf(action) < 0) return false;
		core.eventMoveHero([action], core.values.moveSpeed, function () {
			core.status.route.push(action);
			if (action == 'forward') core.moveOneStep(core.getHeroLoc('x'), core.getHeroLoc('y'));
			else {
				var dir = core.reverseDirection();
				var scan = core.utils.scan[dir];
				var move = core.woodMove({ x: core.getHeroLoc('x'), y: core.getHeroLoc('y'), dirc: dir });
				if (move) {
					core.isLose();
					core.drawWood();
				}
				if (core.isWin()) {
					core.drawTip('关卡完成！');
					var name = core.status.hero.loc.direction + 'Portal';
					var x = core.getHeroLoc('x'),
						y = core.getHeroLoc('y');
					var block = core.getBlockByNumber(core.getBgNumber(x, y));
					if (block.event.id == name) core.insertAction([{ "type": "insert", "name": "成功" }]);
				}
			}
			core.replay();
		});

		return true;
	});

	core.control.turnHero = function (direction) {
		var currDirc = core.getHeroLoc('direction');
		var dirs = { 'up': 'right', 'right': 'down', 'down': 'left', 'left': 'up' };
		if (direction) {
			if (dirs[dirs[currDirc]] == direction) return; //向后
			if (dirs[currDirc] != direction) { //逆时针
				core.turn2Hero();
				return;
			}
		} else direction = dirs[currDirc];

		var scan0 = core.utils.scan[currDirc];
		var scan1 = core.utils.scan[dirs[currDirc]];
		var loc1 = { x: core.getHeroLoc('x') + scan0.x + scan1.x, y: core.getHeroLoc('y') + scan0.y + scan1.y, dirc: dirs[currDirc] };
		var loc2 = { x: core.getHeroLoc('x') + scan1.x, y: core.getHeroLoc('y') + scan1.y, dirc: dirs[dirs[currDirc]] };
		var tryMove = core.woodMoveTry(loc2);
		if (tryMove != false) {
			var move1 = core.woodMove(loc1);
			if (move1 != false) {
				var move2 = core.woodMove(loc2, true);
				core.afterTurn(dirs[currDirc]);
				core.status.route.push("turn");
			}
		}
	}

	this.turn2Hero = function () {
		var currDirc = core.getHeroLoc('direction');
		var dirs = { 'up': 'left', 'right': 'up', 'down': 'right', 'left': 'down' };
		var scan0 = core.utils.scan[currDirc];
		var scan1 = core.utils.scan[dirs[currDirc]];
		var loc1 = { x: core.getHeroLoc('x') + scan0.x + scan1.x, y: core.getHeroLoc('y') + scan0.y + scan1.y, dirc: dirs[currDirc] };
		var loc2 = { x: core.getHeroLoc('x') + scan1.x, y: core.getHeroLoc('y') + scan1.y, dirc: dirs[dirs[currDirc]] };
		var tryMove = core.woodMoveTry(loc2);
		if (tryMove != false) {
			var move1 = core.woodMove(loc1);
			if (move1 != false) {
				var move2 = core.woodMove(loc2, true);
				core.afterTurn(dirs[currDirc]);
				core.status.route.push("turn2");
			}
		}
	}

	this.afterTurn = function (aim) {
		core.status.hero.hp -= 10;
		core.updateStatusBar();
		core.setHeroLoc('direction', aim);
		core.drawHero();
		//core.fire();
		if (core.isLose() != null) {} else {
			core.drawWood();
			if (core.isWin()) {
				core.drawTip('关卡完成！');
			}

			if (core.isWin()) {
				var name = core.status.hero.loc.direction + 'Portal';
				var x = core.getHeroLoc('x'),
					y = core.getHeroLoc('y');
				var block = core.getBlockByNumber(core.getBgNumber(x, y));
				if (block.event.id == name) core.insertAction([{ "type": "insert", "name": "成功" }]);

			}
		}
	}

	core.control._setAutomaticRoute_isTurning = function (destX, destY, stepPostfix) {
		if (destX == core.status.hero.loc.x && destY == core.status.hero.loc.y && stepPostfix.length == 0) {
			if (core.timeout.turnHeroTimeout == null) {
				core.timeout.turnHeroTimeout = setTimeout(function () {
					core.turnHero();
					clearTimeout(core.timeout.turnHeroTimeout);
					core.timeout.turnHeroTimeout = null;
				}, 250);
			} else {
				clearTimeout(core.timeout.turnHeroTimeout);
				core.timeout.turnHeroTimeout = null;
				core.turn2Hero();
			}
			return true;
		}
		if (core.timeout.turnHeroTimeout != null) return true;
		return false;
	}

	this.findWood = function () {
		var floorId = core.status.floorId;
		if (floorId == 'menu') return;
		var flag = 'wood_' + floorId;
		//if (flags[flag] != null) return;
		var woods = [
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
			[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]
		];
		var _woods = [];
		var num = 1;
		for (var i = 0; i < core.status.maps[floorId].width; i++) {
			for (var j = 0; j < core.status.maps[floorId].height; j++) {
				var block = core.getBlock(i, j);
				if (block != null) {
					if (block.block.event.id == 'X10000') {
						var block2 = core.getBlock(i, j + 1);
						if (block2 != null && block2.block.event.id == 'X10008') {
							woods[j][i] = num;
							woods[j + 1][i] = num;
							_woods[num] = { x: i, y: j, con: [0, 0, 0, 0], dirc: 1, pos: 0 };
							num++;
						}
					} else if (block.block.event.id == 'X10032') {
						var block2 = core.getBlock(i + 1, j);
						if (block2 != null && block2.block.event.id == 'X10033') {
							woods[j][i] = num;
							woods[j][i + 1] = num;
							_woods[num] = { x: i, y: j, con: [0, 0, 0, 0], dirc: 2, pos: 0 };
							num++;
						}
					} else if (block.block.event.id != 'lavaNet' && block.block.event.id.substr(0, 1) != 'X') woods[j][i] = -1;
					//else if(block.block.event.id=='blueWater')woods[j][i] = -100;&& block.block.event.id != 'blueWater'
				}
			}
		}
		flags[flag] = woods;
		flags['_' + flag] = _woods;
	}

	this.woodMove = function (loc, notclone) {
		var floorId = core.status.floorId;
		if (floorId == 'menu') return;
		var flag = 'wood_' + floorId;
		var woods = flags[flag];
		var _woods = flags['_' + flag];
		notclone = notclone || false;
		if (notclone != true) flags['_oldWood_' + floorId] = core.clone(_woods);

		var scan = core.utils.scan[loc.dirc];

		if (loc.y + scan.y < 0 || loc.y + scan.y >= core.status.maps[floorId].height) return false;
		if (loc.x + scan.x < 0 || loc.x + scan.x >= core.status.maps[floorId].width) return false;

		if (woods[loc.y][loc.x] < 0) return false;
		if (woods[loc.y][loc.x] == 0) return;
		if (woods[loc.y][loc.x] == woods[loc.y + scan.y][loc.x + scan.x]) {
			if (woods[loc.y + 2 * scan.y][loc.x + 2 * scan.x] > 0) {
				var canMove = this.woodMove({ x: loc.x + 2 * scan.x, y: loc.y + 2 * scan.y, dirc: loc.dirc }, true);
				if (canMove) {
					woods[loc.y + 2 * scan.y][loc.x + 2 * scan.x] = woods[loc.y][loc.x];
					_woods[woods[loc.y][loc.x]].x = Math.min(loc.x + scan.x, loc.x + 2 * scan.x);
					_woods[woods[loc.y][loc.x]].y = Math.min(loc.y + scan.y, loc.y + 2 * scan.y);
					woods[loc.y][loc.x] = 0;

				} else return false;
			} else if (woods[loc.y + 2 * scan.y][loc.x + 2 * scan.x] == 0) {
				woods[loc.y + 2 * scan.y][loc.x + 2 * scan.x] = woods[loc.y][loc.x];
				_woods[woods[loc.y][loc.x]].x = Math.min(loc.x + scan.x, loc.x + 2 * scan.x);
				_woods[woods[loc.y][loc.x]].y = Math.min(loc.y + scan.y, loc.y + 2 * scan.y);
				woods[loc.y][loc.x] = 0;

			} else if (woods[loc.y + 2 * scan.y][loc.x + 2 * scan.x] == -1) {
				return false;
			}
			core.removeBlock(loc.x, loc.y);
			core.removeBlock(loc.x + scan.x, loc.y + scan.y);
			flags[flag] = woods;
			flags['_' + flag] = _woods;
			return true;
		} else {
			for (var i = -1; i <= 1; i += 2) {
				//console.log(loc.x, loc.x + i * scan.x, loc.y, loc.y + i * scan.y)
				if (woods[loc.y][loc.x] == woods[loc.y + i * scan.x][loc.x + i * scan.y]) {
					if (woods[loc.y + scan.y][loc.x + scan.x] == -1 || woods[loc.y + i * scan.x + scan.y][loc.x + i * scan.y + scan.x] == -1) {
						return false;
					} else if (woods[loc.y + scan.y][loc.x + scan.x] > 0 || woods[loc.y + i * scan.x + scan.y][loc.x + i * scan.y + scan.x] > 0) {
						var canMove2 = this.woodMove({ x: loc.x + scan.x, y: loc.y + scan.y, dirc: loc.dirc }, true);
						var canMove3 = this.woodMove({ x: loc.x + i * scan.y + scan.x, y: loc.y + i * scan.x + scan.y, dirc: loc.dirc }, true);
						if (canMove2 != false && canMove3 != false) {
							//console.log(woods[loc.y][loc.x], loc.x + i * scan.y + scan.x, loc.y + i * scan.x + scan.y, loc.y + scan.y)
							woods[loc.y + scan.y][loc.x + scan.x] = woods[loc.y][loc.x];
							woods[loc.y + i * scan.x + scan.y][loc.x + i * scan.y + scan.x] = woods[loc.y][loc.x];
							_woods[woods[loc.y][loc.x]].pos = 1 - _woods[woods[loc.y][loc.x]].pos;
							_woods[woods[loc.y][loc.x]].x = Math.min(loc.x + scan.x, loc.x + i * scan.y + scan.x);
							_woods[woods[loc.y][loc.x]].y = Math.min(loc.y + scan.y, loc.y + i * scan.x + scan.y);
							woods[loc.y][loc.x] = 0;
							woods[loc.y + (i) * scan.x][loc.x + (i) * scan.y] = 0;
						} else return false;
					} else if (woods[loc.y + scan.y][loc.x + scan.x] == 0 && woods[loc.y + i * scan.x + scan.y][loc.x + i * scan.y + scan.x] == 0) {
						woods[loc.y + scan.y][loc.x + scan.x] = woods[loc.y][loc.x];
						woods[loc.y + i * scan.x + scan.y][loc.x + i * scan.y + scan.x] = woods[loc.y][loc.x];
						_woods[woods[loc.y][loc.x]].pos = 1 - _woods[woods[loc.y][loc.x]].pos;
						_woods[woods[loc.y][loc.x]].x = Math.min(loc.x + scan.x, loc.x + i * scan.y + scan.x);
						_woods[woods[loc.y][loc.x]].y = Math.min(loc.y + scan.y, loc.y + i * scan.x + scan.y);
						woods[loc.y][loc.x] = 0;
						woods[loc.y + (i) * scan.x][loc.x + (i) * scan.y] = 0;
					}

					core.removeBlock(loc.x, loc.y);
					core.removeBlock(loc.x + i * scan.y, loc.y + i * scan.x);
					flags[flag] = woods;
					flags['_' + flag] = _woods;
					return true;
				}
			}
		}
	}

	this.woodMoveTry = function (loc) {
		var floorId = core.status.floorId;
		if (floorId == 'menu') return;
		var flag = 'wood_' + floorId;
		var woods = flags[flag];
		var _woods = flags['_' + flag];

		var scan = core.utils.scan[loc.dirc];

		if (loc.y + scan.y < 0 || loc.y + scan.y >= core.status.maps[floorId].height) return false;
		if (loc.x + scan.x < 0 || loc.x + scan.x >= core.status.maps[floorId].width) return false;

		if (woods[loc.y][loc.x] < 0) return false;
		if (woods[loc.y][loc.x] == 0) return;
		if (woods[loc.y][loc.x] == woods[loc.y + scan.y][loc.x + scan.x]) {
			if (woods[loc.y + 2 * scan.y][loc.x + 2 * scan.x] > 0) {
				var canMove = this.woodMoveTry({ x: loc.x + 2 * scan.x, y: loc.y + 2 * scan.y, dirc: loc.dirc });
				if (canMove) {} else return false;
			} else if (woods[loc.y + 2 * scan.y][loc.x + 2 * scan.x] == 0) {} else if (woods[loc.y + 2 * scan.y][loc.x + 2 * scan.x] == -1) {
				return false;
			}
		} else {
			for (var i = -1; i <= 1; i += 2) {
				//console.log(loc.x, loc.x + i * scan.x, loc.y, loc.y + i * scan.y)
				if (woods[loc.y][loc.x] == woods[loc.y + i * scan.x][loc.x + i * scan.y]) {
					if (woods[loc.y + scan.y][loc.x + scan.x] == -1 || woods[loc.y + i * scan.x + scan.y][loc.x + i * scan.y + scan.x] == -1) {
						return false;
					} else if (woods[loc.y + scan.y][loc.x + scan.x] > 0 || woods[loc.y + i * scan.x + scan.y][loc.x + i * scan.y + scan.x] > 0) {
						var canMove2 = this.woodMoveTry({ x: loc.x + scan.x, y: loc.y + scan.y, dirc: loc.dirc });
						var canMove3 = this.woodMoveTry({ x: loc.x + i * scan.y + scan.x, y: loc.y + i * scan.x + scan.y, dirc: loc.dirc });
						if (canMove2 != false && canMove3 != false) {
							//console.log(woods[loc.y][loc.x], loc.x + i * scan.y + scan.x, loc.y + i * scan.x + scan.y, loc.y + scan.y)
						} else return false;
					} else if (woods[loc.y + scan.y][loc.x + scan.x] == 0 && woods[loc.y + i * scan.x + scan.y][loc.x + i * scan.y + scan.x] == 0) {}
					return true;
				}
			}
		}
	}

	this.fire = function (floorId) {
		floorId = floorId || core.status.floorId;
		if (floorId == 'menu') return;
		var flag = 'wood_' + floorId;
		var woods = flags[flag];
		var _woods = flags['_' + flag];
		var _oldWoods = flags['_oldWood_' + floorId];
		var change = [];
		for (var i in _woods) {
			if (i == 0) continue;
			if (_woods[i].x != _oldWoods[i].x || _woods[i].y != _oldWoods[i].y) change[i] = _woods[i];
		}

		for (var i = 0; i < core.status.maps[floorId].width; i++) {
			for (var j = 0; j < core.status.maps[floorId].height; j++) {
				var block = core.getBgNumber(i, j, floorId);
				if (block == 11) {
					if (woods[j][i] > 0) {
						var num = woods[j][i];
						var wood = change[num];
						if (!wood) continue;
						var zeroOrTwo = 2,
							plusOrNot = 0;
						if (wood.x == i && wood.y == j) zeroOrTwo = 0;
						if (wood.pos == 0) plusOrNot = 1;

						if (wood.con[zeroOrTwo + plusOrNot] == 0) wood.con[zeroOrTwo + plusOrNot] = 1;
						else return false;
					}
				}
			}
		}
	}

	this.drawWood = function () {
		var floorId = core.status.floorId;
		if (floorId == 'menu') return;
		var flag = 'wood_' + floorId;
		var woods = flags[flag];
		var _woods = flags['_' + flag];
		core.status.thisMap.blocks = [];
		core.clearMap('event');
		for (var i in _woods) {
			if (i == 0) continue;
			var wood = _woods[i];
			var w0 = wood.con[0];
			var w1 = wood.con[1];
			var w2 = wood.con[2];
			var w3 = wood.con[3];
			var num;
			var num2 = 0;
			if (wood.dirc == 1) {
				if (wood.pos == 0) {
					if (w0 == 0) {
						if (w2 == 0) {
							if (w3 == 0) num = 10000;
							else num = 10004;
						} else {
							if (w3 == 0) num = 10002;
							else num = 10006;
						}
					} else {
						if (w2 == 0) {
							if (w3 == 0) num = 10001;
							else num = 10005;
						} else {
							if (w3 == 0) num = 10003;
							else num = 10007;
						}
					}
				} else {
					if (w1 == 0) {
						if (w2 == 0) {
							if (w3 == 0) num = 10016;
							else num = 10018;
						} else {
							if (w3 == 0) num = 10020;
							else num = 10022;
						}
					} else {
						if (w2 == 0) {
							if (w3 == 0) num = 10017;
							else num = 10019;
						} else {
							if (w3 == 0) num = 10021;
							else num = 10023;
						}
					}

				}
				var num1 = 8;
				var num2 = 0;
			} else {
				if (w0 == 0) {
					if (w1 == 0) {
						if (w2 == 0) {
							if (w3 == 0) num = 10032;
							else num = 10048;
						} else {
							if (w3 == 0) num = 10034;
							else num = 10064;
						}
					} else {
						if (w2 == 0) {
							if (w3 == 0) num = 10038;
							else num = 10052;
						} else {
							if (w3 == 0) num = 10068;
							else num = 10070;
						}
					}
				} else {
					if (w1 == 0) {
						if (w2 == 0) {
							if (w3 == 0) num = 10036;
							else num = 10066;
						} else {
							if (w3 == 0) num = 10050;
							else num = 10080;
						}
					} else {
						if (w2 == 0) {
							if (w3 == 0) num = 10054;
							else num = 10082;
						} else {
							if (w3 == 0) num = 10084;
							else num = 10086;
						}
					}
				}
				var num1 = 1;
			}

			if (wood.pos == 1) {
				if (wood.dirc == 1) var num2 = 0;
				else var num2 = 8;
			}
			var sum = num + num2;
			var id = 'X' + sum,
				id2 = 'X' + (sum + num1);

			core.setBlock(id, wood.x, wood.y);
			var j = 0,
				k = 0;
			if (wood.dirc == 1) j++;
			else k++;
			core.setBlock(id2, wood.x + k, wood.y + j);

		}
	}

	this.woodFall = function () {
		var floorId = core.status.floorId;
		var _woods = flags['_wood_' + floorId];
		for (var i in _woods) {
			if (i == 0) continue;
			var wood = _woods[i];
			if (wood.dirc == 1) {
				if (core.getBgNumber(wood.x, wood.y, floorId) == 15 && core.getBgNumber(wood.x, wood.y + 1, floorId) == 15) return true;
			} else {
				if (core.getBgNumber(wood.x, wood.y, floorId) == 15 && core.getBgNumber(wood.x + 1, wood.y, floorId) == 15) return true;
			}
		}
		return false;
	}

	this.isLose = function () {
		var reason = '';
		if (core.woodFall()) reason += '木头掉入了水中 ';
		if (core.fire() == false) reason += '木头烤焦了';
		if (reason != '') {
			flags.loseReason = reason;
			core.insertAction([{ "type": "insert", "name": "失败" }]);
		}
	}

	this.isWin = function () {
		var floorId = core.status.floorId;
		if (floorId == 'menu') return;
		var flag = 'wood_' + floorId;
		var _woods = flags['_' + flag];
		for (var k in _woods) {
			if (k == 0) continue;
			var wood = _woods[k];
			var con = wood.con;
			for (var i = 0; i <= 3; i++) {
				if (con[i] != 1) return false;
			}
		}
		//core.removeFlag(flag);
		//core.removeFlag('_' + flag);
		return true;
	}

	this._sys_new_keyDown = function (keyCode) {
		if (!core.status.played)
			return true;
		switch (keyCode) {
		case 37:
			//core.moveHero('left');
			//core.turn2Hero();
			break;
		case 38:
			if (core.status.heroMoving != 0) return;
			core.control._moveHero_moving();
			break;
		case 39:
			//core.moveHero('right');
			//core.turnHero();
			break;
		case 40:
			core.plugin._moveHero2_moving();
			break;
		}
		return true;
	}

	core.registerAction('keyDown', '_sys_new_keyDown', '_sys_new_keyDown', 10);

	core.control._moveHero_moving = function () {
		// ------ 我已经看不懂这个函数了，反正好用就行23333333
		core.status.heroStop = false;
		core.status.automaticRoute.moveDirectly = false;
		var move = function () {
			if (!core.status.heroStop) {
				if (core.hasFlag('debug') && core.status.ctrlDown) {
					if (core.status.heroMoving != 0) return;
					// 检测是否穿出去
					var nx = core.nextX(),
						ny = core.nextY();
					if (nx < 0 || nx >= core.bigmap.width || ny < 0 || ny >= core.bigmap.height) return;
					core.status.heroMoving = -1;
					core.eventMoveHero(['forward'], core.values.moveSpeed, function () {
						core.status.heroMoving = 0;
						move();
					});
				} else {
					core.moveAction();
					setTimeout(move, 50);
				}
			}
		}
		move();
	}

	core.control._moveAction_moving = function (callback) {
		core.setHeroMoveInterval(function () {
			core.status.route.push('forward');
			var direction = core.getHeroLoc('direction');
			core.control._moveAction_popAutomaticRoute();

			// 无事件的道具（如血瓶）需要优先于阻激夹域判定
			var nowx = core.getHeroLoc('x'),
				nowy = core.getHeroLoc('y');
			var block = core.getBlock(nowx, nowy);
			var hasTrigger = false;
			if (block != null && block.block.event.trigger == 'getItem' &&
				!core.floors[core.status.floorId].afterGetItem[nowx + "," + nowy]) {
				hasTrigger = true;
				core.events._trigger(nowx, nowy);
			}
			// 执行该点的阻激夹域事件
			core.checkBlock();

			// 执行该点事件
			if (!hasTrigger)
				core.events._trigger(nowx, nowy);
			core.updateStatusBar();

			// 检查该点是否是滑冰
			if (core.getBgNumber() == 167) {
				core.insertAction("滑冰事件", null, null, null, true);
			}

			if (callback) callback();
		});
	}

	this._moveHero2_moving = function () {
		// ------ 我也看不懂这个函数，也不知道好不好用55555555
		if (core.status.heroMoving != 0) return;
		core.status.heroStop = false;
		core.status.automaticRoute.moveDirectly = false;
		var move = function () {
			if (!core.status.heroStop) {
				var nx = core.nextX(-1),
					ny = core.nextY(-1);
				if (core.hasFlag('debug') && core.status.ctrlDown) {
					if (core.status.heroMoving != 0) return;
					// 检测是否穿出去
					if (nx < 0 || nx >= core.bigmap.width || ny < 0 || ny >= core.bigmap.height) return;
					core.status.heroMoving = -1;
					core.eventMoveHero(['backward'], core.values.moveSpeed, function () {
						core.status.heroMoving = 0;
						move();
					});
				} else {
					if (nx < 0 || nx >= core.bigmap.width || ny < 0 || ny >= core.bigmap.height) return;
					var dirs = { 'up': 'left', 'right': 'up', 'down': 'right', 'left': 'down' };
					var canmove = core.woodMove({ x: nx, y: ny, dirc: dirs[dirs[core.getHeroLoc('direction')]] });
					if (canmove != false) {
						if (canmove) {
							//core.fire();
							core.isLose();
							core.drawWood();
						}
						if (!core.noPass(nx, ny)) {
							if (core.status.heroMoving > 0) return;
							core.status.heroMoving = -1;
							core.eventMoveHero(['backward'], core.values.moveSpeed, function () {
								core.status.heroMoving = 0;
								core.status.route.push('backward');
								core.moveOneStep2(nx, ny);
								//
								move();
							});
							flags.daotui = true;

						}
					}
				}
			}
		}
		move();
	}

	core.maps.noPass = function (x, y, floorId) {
		var id = core.getBgNumber(x, y, floorId);
		if (id == 15) return true;
		var block = core.getBlock(x, y, floorId);
		if (block == null) return false;
		return block.block.event.noPass;
	}

	core.findPortal = function () {
		var floorId = core.status.floorId;
		for (var i = 0; i < core.status.maps[floorId].width; i++) {
			for (var j = 0; j < core.status.maps[floorId].height; j++) {
				var id = core.getBgNumber(j, i, floorId);
				if (id <= 90 || id > 94) continue;
				else {
					switch (id) {
					case 91:
						core.status.hero.loc = { x: j, y: i, direction: 'up' };
						break;
					case 92:
						core.status.hero.loc = { x: j, y: i, direction: 'left' };
						break;
					case 93:
						core.status.hero.loc = { x: j, y: i, direction: 'down' };
						break;
					case 94:
						core.status.hero.loc = { x: j, y: i, direction: 'right' };
						break;
					}
					break;
					//core.up
				}
			}
		}
	}

	core.control.setAutomaticRoute = function (destX, destY, stepPostfix) {
		if (!core.status.played || core.status.lockControl) return;
		if (this._setAutomaticRoute_isMoving(destX, destY)) return;
		if (this._setAutomaticRoute_isTurning(destX, destY, stepPostfix)) return;
		if (this._setAutomaticRoute_clickMoveDirectly(destX, destY, stepPostfix)) return;
		// 找寻自动寻路路线
		var moveStep = core.automaticRoute(destX, destY);
		//console.log(destX, destY, stepPostfix, moveStep)
		if (moveStep.length == 0 && (destX != core.status.hero.loc.x || destY != core.status.hero.loc.y || stepPostfix.length == 0))
			return;
		moveStep = moveStep.concat(stepPostfix);
		//this._setAutomaticRoute_drawRoute(moveStep);
		/*core.status.automaticRoute.destX = destX;
		core.status.automaticRoute.destY = destY;
		// 立刻移动
		core.setAutoHeroMove();*/
		//core.transRoute(moveStep);
	}

	this.transRoute = function (moveStep) {
		if (core.status.heroMoving != 0) return;
		var scan = { 'up': 'right', 'right': 'down', 'down': 'left', 'left': 'up' };
		var i = -1;
		var move = function (num) {
			core.status.heroMoving = -1;
			core.status.heroStop = false;
			core.status.lockControl = true;
			i++;
			if (i >= moveStep.length || flags.ry) {
				core.status.heroMoving = 0;
				core.status.heroStop = true;
				flags.ry = null;
				core.status.lockControl = false;
				return;
			}
			var dirc = core.getHeroLoc('direction');
			var aim = moveStep[i].direction;
			var x = moveStep[i].x,
				y = moveStep[i].y;
			if (core.noPass(x, y)) {
				core.status.heroMoving = 0;
				core.status.heroStop = true;
				core.insertAction([{ "type": "trigger", "loc": [x, y] }]);
				return;
			}
			switch (dirc) {
			case aim:
				core.eventMoveHero(['forward'], core.values.moveSpeed, function () {
					var canmove = core.woodMove({ x: x + core.utils.scan[dirc].x, y: y + core.utils.scan[dirc].y, dirc: dirc });
					if (canmove) {
						core.fire();
						core.drawWood();
					}
					if (canmove != false) {
						core.status.route.push('forward');
						core.moveOneStep2(x, y);
						move();
					}
				});
				break;
			case scan[aim]:
				core.turn2Hero();
				core.eventMoveHero(['forward'], core.values.moveSpeed, function () {
					dirc = core.getHeroLoc('direction');
					var canmove = core.woodMove({ x: x + core.utils.scan[dirc].x, y: y + core.utils.scan[dirc].y, dirc: dirc });
					if (canmove) {
						core.fire();
						core.drawWood();
					}
					if (canmove != false) {
						core.status.route.push('forward');
						core.moveOneStep2(x, y);
						move();
					}
				});
				break;
			case scan[scan[aim]]:
				core.eventMoveHero(['backward'], core.values.moveSpeed, function () {
					core.status.route.push('backward');
					flags.daotui = true;
					core.moveOneStep2(x, y);
					move();
				});
				break;
			case scan[scan[scan[aim]]]:
				core.turnHero();
				core.eventMoveHero(['forward'], core.values.moveSpeed, function () {
					dirc = core.getHeroLoc('direction');
					var canmove = core.woodMove({ x: x + core.utils.scan[dirc].x, y: y + core.utils.scan[dirc].y, dirc: dirc });
					if (canmove) {
						core.fire();
						core.drawWood();
					}
					if (canmove != false) {
						core.status.route.push('forward');
						core.moveOneStep2(x, y);

						move();
					}

				});
				break;
			}
			//core.moveOneStep(x + core.utils.scan[aim].x, y + core.utils.scan[aim].y);
		};
		move();
		core.status.lockControl = false;
	}

	this.moveOneStep2 = function (x, y) {

		var bg = core.getBgNumber(x, y);
		if (bg == 11) {
			flags.ry = true;
			core.stopAutomaticRoute();
			core.status.heroMoving = -1;
			if (core.status.route[core.status.route.length - 1] == 'backward') {
				core.eventMoveHero(['forward'], core.values.moveSpeed, function () {
					core.status.heroMoving = 0;
				});
			} else {
				core.eventMoveHero(['backward'], core.values.moveSpeed, function () {
					core.status.heroMoving = 0;
				});

			}

			//core.startEvents();
		}
		var loc = core.status.hero.loc;
		var scan = core.utils.scan[loc.direction];
		if (loc.x + scan.x >= 0 && loc.x + scan.x < core.__SIZE__) {
			if (loc.y + scan.y >= 0 && loc.y + scan.y < core.__SIZE__) {
				var move = core.woodMove({ x: loc.x + scan.x, y: loc.y + scan.y, dirc: loc.direction });
				if (move) {
					core.isLose();
					core.drawWood();
				}
				if (core.isWin()) {
					core.drawTip('关卡完成！');
					var name = loc.direction + 'Portal';
					var block = core.getBlockByNumber(core.getBgNumber(x, y));
					if (block.event.id == name) core.insertAction([{ "type": "insert", "name": "成功" }]);
				}
			}
		}
	}

	core.control._updateStatusBar_setToolboxIcon = function () {
		if (core.isReplaying()) {
			core.statusBar.image.book.src = core.status.replay.pausing ? core.statusBar.icons.play.src : core.statusBar.icons.pause.src;
			core.statusBar.image.book.style.opacity = 1;
			core.statusBar.image.fly.src = core.statusBar.icons.stop.src;
			core.statusBar.image.fly.style.opacity = 1;
			core.statusBar.image.toolbox.src = core.statusBar.icons.rewind.src;
			core.statusBar.image.keyboard.src = core.statusBar.icons.save.src;
			core.statusBar.image.shop.src = core.statusBar.icons.floor.src;
			core.statusBar.image.save.src = core.statusBar.icons.speedDown.src;
			core.statusBar.image.load.src = core.statusBar.icons.speedUp.src;
			core.statusBar.image.settings.src = core.statusBar.icons.save.src;
		} else {
			core.statusBar.image.book.src = core.statusBar.icons.book.src;
			core.statusBar.image.book.style.opacity = 1;
			if (!core.flags.equipboxButton) {
				core.statusBar.image.fly.src = core.statusBar.icons.fly.src;
				core.statusBar.image.fly.style.opacity = 1;
			} else {
				core.statusBar.image.fly.src = core.statusBar.icons.equipbox.src;
				core.statusBar.image.fly.style.opacity = 1;
			}
			core.statusBar.image.toolbox.src = core.statusBar.icons.toolbox.src;
			core.statusBar.image.keyboard.src = core.statusBar.icons.keyboard.src;
			core.statusBar.image.shop.src = core.statusBar.icons.shop.src;
			core.statusBar.image.save.src = core.statusBar.icons.save.src;
			core.statusBar.image.load.src = core.statusBar.icons.load.src;
			core.statusBar.image.settings.src = core.statusBar.icons.settings.src;
		}
	}

	core.events.openBook = function (fromUserAction) {
		if (core.isReplaying()) return;
		// 如果能恢复事件（从callBook事件触发）
		if (core.status.event.id == 'book' && core.events.recoverEvents(core.status.event.interval))
			return;
		// 当前是book，且从“浏览地图”打开
		if (core.status.event.id == 'book' && core.status.event.ui) {
			core.status.boxAnimateObjs = [];
			return;
		}
		// 从“浏览地图”页面打开
		if (core.status.event.id == 'viewMaps') {
			fromUserAction = false;
		}
		if (!this._checkStatus('book', fromUserAction, true)) return;
		if (core.isMoving()) return;
		core.turn2Hero();
	}

	core.events.useFly = function (fromUserAction) {
		if (core.isReplaying()) return;
		if (!this._checkStatus('fly', fromUserAction, true)) return;
		if (core.isMoving()) return;
		core.turnHero();

	}

	core.events._checkStatus = function (name, fromUserAction, checkItem) {
		if (name == 'book' || name === 'fly') return true;
		if (fromUserAction && core.status.event.id == name) {
			core.ui.closePanel();
			return false;
		}
		if (fromUserAction && core.status.lockControl) return false;

		if (core.isMoving()) {
			core.drawTip("请先停止勇士行动");
			return false;
		}
		core.lockControl();
		core.status.event.id = name;
		return true;
	}

	control.prototype.setToolbarButton = function (useButton) {
		if (!core.domStyle.showStatusBar) {
			// 隐藏状态栏时检查竖屏
			if (!core.domStyle.isVertical) {
				for (var i = 0; i < core.dom.tools.length; ++i)
					core.dom.tools[i].style.display = 'none';
				return;
			}
			if (!core.hasFlag('showToolbox')) return;
			else core.dom.tools.hard.style.display = 'block';
		}

		if (useButton == null) useButton = core.domStyle.toolbarBtn;
		if (!core.domStyle.isVertical || core.isReplaying()) useButton = false;
		core.domStyle.toolbarBtn = useButton;

		if (useButton) {
			["book", "fly", "toolbox", "keyboard", "shop", "save", "load", "settings"].forEach(function (t) {
				core.statusBar.image[t].style.display = 'none';
			});
			["btn1", "btn2", "btn3", "btn4", "btn5", "btn6", "btn7", "btn8"].forEach(function (t) {
				core.statusBar.image[t].style.display = 'block';
			})
		} else {
			["btn1", "btn2", "btn3", "btn4", "btn5", "btn6", "btn7", "btn8"].forEach(function (t) {
				core.statusBar.image[t].style.display = 'none';
			});
			["book", "fly", "toolbox", "save", "load", "settings"].forEach(function (t) {
				core.statusBar.image[t].style.display = 'block';
			});
			core.statusBar.image.settings.style.display = core.statusBar.image.shop.style.display = core.domStyle.isVertical ? "block" : "none";
		}
	}

	this.eraseFlag = function () {
		var floorId = core.status.floorId;
		core.removeFlag('wood_' + floorId);
		core.removeFlag('_wood_' + floorId);
		core.removeFlag('_oldWood_' + floorId);
		core.removeFlag('daotui');
		core.removeFlag('loseReason');
		core.removeFlag('arg0');
	}

	main.core.statusBar.image.keyboard.onclick = function (e) {
		e.stopPropagation();
		if (core.isReplaying()) {
			core.saveReplay();
			return;
		}

		if (main.core.isPlaying() && (core.status.event || {}).id == 'paint') {
			core.actions.clearPaint();
			return;
		}
	}

	////// 点击状态栏中的楼层传送器/装备栏时 //////
	main.core.statusBar.image.toolbox.onclick = function (e) {
		e.stopPropagation();
		if (core.isReplaying()) {
			core.rewindReplay();
			return;
		}
		if (main.core.isPlaying() && (core.status.event || {}).id == 'paint') {
			core.actions.clearPaint();
			return;
		}
	}

	main.core.statusBar.image.toolbox.ondblclick = function (e) {}

	main.core.statusBar.image.keyboard.onmousedown = function (e) {
		e.stopPropagation();
		if (core.isReplaying()) {
			return;
		}
		if (main.core.isPlaying()) {
			core.plugin._moveHero2_moving();
		}
	}

	main.core.statusBar.image.toolbox.onmousedown = function (e) {
		e.stopPropagation();
		if (core.isReplaying()) {
			return;
		}
		if (core.status.heroMoving != 0) return;
		if (main.core.isPlaying()) {
			core.control._moveHero_moving();
		}
	}

	main.core.statusBar.image.toolbox.onmouseup = function () {
		if (!core.status.played)
			return true;
		if (core.isReplaying()) {
			return;
		}
		if (main.core.isPlaying()) {
			main.core.actions.actionsdata.onKeyUp(38, false);
			if (core.status.automaticRoute && core.status.automaticRoute.autoHeroMove) {
				core.stopAutomaticRoute();
			}
			core.status.heroStop = true;
			return true;
		}
	}

	main.core.statusBar.image.keyboard.onmouseup = function () {
		if (!core.status.played)
			return true;

		if (core.isReplaying()) {
			return;
		}
		if (main.core.isPlaying()) {
			main.core.actions.actionsdata.onKeyUp(40, false);
			if (core.status.automaticRoute && core.status.automaticRoute.autoHeroMove) {
				core.stopAutomaticRoute();
			}
			core.status.heroStop = true;
			return true;
		}
	}
	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "drawLight": function () {

	// 绘制灯光/漆黑层效果。调用方式 core.plugin.drawLight(...)
	// 【参数说明】
	// name：必填，要绘制到的画布名；可以是一个系统画布，或者是个自定义画布；如果不存在则创建
	// color：可选，只能是一个0~1之间的数，为不透明度的值。不填则默认为0.9。
	// lights：可选，一个数组，定义了每个独立的灯光。
	//        其中每一项是三元组 [x,y,r] x和y分别为该灯光的横纵坐标，r为该灯光的半径。
	// lightDec：可选，0到1之间，光从多少百分比才开始衰减（在此范围内保持全亮），不设置默认为0。
	//        比如lightDec为0.5代表，每个灯光部分内圈50%的范围全亮，50%以后才开始快速衰减。
	// 【调用样例】
	// core.plugin.drawLight('curtain'); // 在curtain层绘制全图不透明度0.9，等价于更改画面色调为[0,0,0,0.9]。
	// core.plugin.drawLight('ui', 0.95, [[25,11,46]]); // 在ui层绘制全图不透明度0.95，其中在(25,11)点存在一个半径为46的灯光效果。
	// core.plugin.drawLight('test', 0.2, [[25,11,46,0.1]]); // 创建一个test图层，不透明度0.2，其中在(25,11)点存在一个半径为46的灯光效果，灯光中心不透明度0.1。
	// core.plugin.drawLight('test2', 0.9, [[25,11,46],[105,121,88],[301,221,106]]); // 创建test2图层，且存在三个灯光效果，分别是中心(25,11)半径46，中心(105,121)半径88，中心(301,221)半径106。
	// core.plugin.drawLight('xxx', 0.3, [[25,11,46],[105,121,88,0.2]], 0.4); // 存在两个灯光效果，它们在内圈40%范围内保持全亮，且40%后才开始衰减。
	this.drawLight = function (name, color, lights, lightDec) {

		// 清空色调层；也可以修改成其它层比如animate/weather层，或者用自己创建的canvas
		var ctx = core.getContextByName(name);
		if (ctx == null) {
			if (typeof name == 'string')
				ctx = core.createCanvas(name, 0, 0, core.__PIXELS__, core.__PIXELS__, 98);
			else return;
		}

		ctx.mozImageSmoothingEnabled = false;
		ctx.webkitImageSmoothingEnabled = false;
		ctx.msImageSmoothingEnabled = false;
		ctx.imageSmoothingEnabled = false;

		core.clearMap(name);
		// 绘制色调层，默认不透明度
		if (color == null) color = 0.9;
		ctx.fillStyle = "rgba(0,0,0," + color + ")";
		ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

		lightDec = core.clamp(lightDec, 0, 1);

		// 绘制每个灯光效果
		ctx.globalCompositeOperation = 'destination-out';
		lights.forEach(function (light) {
			// 坐标，半径，中心不透明度
			var x = light[0],
				y = light[1],
				r = light[2];
			// 计算衰减距离
			var decDistance = parseInt(r * lightDec);
			// 正方形区域的直径和左上角坐标
			var grd = ctx.createRadialGradient(x, y, decDistance, x, y, r);
			grd.addColorStop(0, "rgba(0,0,0,1)");
			grd.addColorStop(1, "rgba(0,0,0,0)");
			ctx.beginPath();
			ctx.fillStyle = grd;
			ctx.arc(x, y, r, 0, 2 * Math.PI);
			ctx.fill();
		});
		ctx.globalCompositeOperation = 'source-over';
		// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为  core.plugin.xxx();
	}
},
    "itemShop": function () {
	// 道具商店相关的插件
	// 可在全塔属性-全局商店中使用「道具商店」事件块进行编辑（如果找不到可以在入口方块中找）

	var shopId = null; // 当前商店ID
	var type = 0; // 当前正在选中的类型，0买入1卖出
	var selectItem = 0; // 当前正在选中的道具
	var selectCount = 0; // 当前已经选中的数量
	var page = 0;
	var totalPage = 0;
	var totalMoney = 0;
	var list = [];

	var bigFont = core.ui._buildFont(20, false),
		middleFont = core.ui._buildFont(18, false);

	this.drawItemShop = function () {
		// 绘制道具商店

		// Step 1: 背景和固定的几个文字
		core.ui._createUIEvent();
		core.clearMap('uievent');
		core.ui._uievent_drawSelector({ "code": 1 });
		core.ui._uievent_drawSelector({ "code": 2 });
		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'top');
		core.fillRect('uievent', 0, 0, 416, 416, 'black');
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 0, width: 416, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 56, width: 312, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 0, y: 112, width: 312, height: 304 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 312, y: 56, width: 104, height: 56 });
		core.ui._uievent_drawBackground({ background: 'winskin.png', x: 312, y: 112, width: 104, height: 304 });
		core.setFillStyle('uievent', 'white');
		core.setStrokeStyle('uievent', 'white');
		core.fillText("uievent", "购买", 32, 74, 'white', bigFont);
		core.fillText("uievent", "卖出", 132, 74);
		core.fillText("uievent", "离开", 232, 74);
		core.fillText("uievent", "当前金币", 324, 66, null, middleFont);
		core.setTextAlign("uievent", "right");
		core.fillText("uievent", core.formatBigNumber(core.status.hero.money), 405, 89);
		core.setTextAlign("uievent", "left");
		core.ui._uievent_drawSelector({
			"type": "drawSelector",
			"image": "winskin.png",
			"code": 2,
			"x": 22 + 100 * type,
			"y": 66,
			"width": 60,
			"height": 33
		});
		if (selectItem != null) {
			core.setTextAlign('uievent', 'center');
			core.fillText("uievent", type == 0 ? "买入个数" : "卖出个数", 364, 320, null, bigFont);
			core.fillText("uievent", "◀   " + selectCount + "   ▶", 364, 350);
			core.fillText("uievent", "确定", 364, 380);
		}

		// Step 2：获得列表并展示
		var choices = core.status.shops[shopId].choices;
		list = choices.filter(function (one) {
			if (one.condition != null) {
				try { if (!core.calValue(one.condition)) return false; } catch (e) {}
			}
			return (type == 0 && one.money != null) || (type == 1 && one.sell != null);
		});
		var per_page = 6;
		totalPage = Math.ceil(list.length / per_page);
		page = Math.floor((selectItem || 0) / per_page) + 1;

		// 绘制分页
		if (totalPage > 1) {
			var half = 156;
			core.setTextAlign('uievent', 'center');
			core.fillText('uievent', page + " / " + totalPage, half, 388, null, middleFont);
			if (page > 1) core.fillText('uievent', '上一页', half - 80, 388);
			if (page < totalPage) core.fillText('uievent', '下一页', half + 80, 388);
		}
		core.setTextAlign('uievent', 'left');

		// 绘制每一项
		var start = (page - 1) * per_page;
		for (var i = 0; i < per_page; ++i) {
			var curr = start + i;
			if (curr >= list.length) break;
			var item = list[curr];
			core.drawIcon('uievent', item.id, 10, 125 + i * 40);
			core.setTextAlign('uievent', 'left');
			core.fillText('uievent', core.material.items[item.id].name, 50, 132 + i * 40, null, bigFont);
			core.setTextAlign('uievent', 'right');
			core.fillText('uievent', (type == 0 ? core.calValue(item.money) : core.calValue(item.sell)) + "金币/个", 300, 133 + i * 40, null, middleFont);
			core.setTextAlign("uievent", "left");
			if (curr == selectItem) {
				// 绘制描述，文字自动放缩
				var text = core.material.items[item.id].text || "该道具暂无描述";
				try { text = core.replaceText(text); } catch (e) {}
				for (var fontSize = 20; fontSize >= 8; fontSize -= 2) {
					var config = { left: 10, fontSize: fontSize, maxWidth: 403, lineHeight: 1.4 };
					var height = core.getTextContentHeight(text, config);
					if (height <= 50) {
						config.top = (56 - height) / 2;
						core.drawTextContent("uievent", text, config);
						break;
					}
				}
				core.ui._uievent_drawSelector({ "type": "drawSelector", "image": "winskin.png", "code": 1, "x": 8, "y": 120 + i * 40, "width": 295, "height": 40 });
				if (type == 0 && item.number != null) {
					core.fillText("uievent", "存货", 324, 132, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", item.number, 406, 132, null, null, 40);
				} else if (type == 1) {
					core.fillText("uievent", "数量", 324, 132, null, bigFont);
					core.setTextAlign("uievent", "right");
					core.fillText("uievent", core.itemCount(item.id), 406, 132, null, null, 40);
				}
				core.setTextAlign("uievent", "left");
				core.fillText("uievent", "预计金额", 324, 250);
				core.setTextAlign("uievent", "right");
				totalMoney = selectCount * (type == 0 ? core.calValue(item.money) : core.calValue(item.sell));
				core.fillText("uievent", core.formatBigNumber(totalMoney), 405, 280);

				core.setTextAlign("uievent", "left");
				core.fillText("uievent", type == 0 ? "已购次数" : "已卖次数", 324, 170);
				core.setTextAlign("uievent", "right");
				core.fillText("uievent", (type == 0 ? item.money_count : item.sell_count) || 0, 405, 200);
			}
		}

		core.setTextAlign('uievent', 'left');
		core.setTextBaseline('uievent', 'alphabetic');
	}

	var _add = function (item, delta) {
		if (item == null) return;
		selectCount = core.clamp(
			selectCount + delta, 0,
			Math.min(type == 0 ? Math.floor(core.status.hero.money / core.calValue(item.money)) : core.itemCount(item.id),
				type == 0 && item.number != null ? item.number : Number.MAX_SAFE_INTEGER)
		);
	}

	var _confirm = function (item) {
		if (item == null || selectCount == 0) return;
		if (type == 0) {
			core.status.hero.money -= totalMoney;
			core.getItem(item.id, selectCount);
			if (item.number != null) item.number -= selectCount;
			item.money_count = (item.money_count || 0) + selectCount;
		} else {
			core.status.hero.money += totalMoney;
			core.removeItem(item.id, selectCount);
			core.drawTip("成功卖出" + selectCount + "个" + core.material.items[item.id].name, item.id);
			if (item.number != null) item.number += selectCount;
			item.sell_count = (item.sell_count || 0) + selectCount;
		}
		selectCount = 0;
	}

	this._performItemShopKeyBoard = function (keycode) {
		var item = list[selectItem] || null;
		// 键盘操作
		switch (keycode) {
		case 38: // up
			if (selectItem == null) break;
			if (selectItem == 0) selectItem = null;
			else selectItem--;
			selectCount = 0;
			break;
		case 37: // left
			if (selectItem == null) {
				if (type > 0) type--;
				break;
			}
			_add(item, -1);
			break;
		case 39: // right
			if (selectItem == null) {
				if (type < 2) type++;
				break;
			}
			_add(item, 1);
			break;
		case 40: // down
			if (selectItem == null) {
				if (list.length > 0) selectItem = 0;
				break;
			}
			if (list.length == 0) break;
			selectItem = Math.min(selectItem + 1, list.length - 1);
			selectCount = 0;
			break;
		case 13:
		case 32: // Enter/Space
			if (selectItem == null) {
				if (type == 2)
					core.insertAction({ "type": "break" });
				else if (list.length > 0)
					selectItem = 0;
				break;
			}
			_confirm(item);
			break;
		case 27: // ESC
			if (selectItem == null) {
				core.insertAction({ "type": "break" });
				break;
			}
			selectItem = null;
			break;
		}
	}

	this._performItemShopClick = function (px, py) {
		var item = list[selectItem] || null;
		// 鼠标操作
		if (px >= 22 && px <= 82 && py >= 71 && py <= 102) {
			// 买
			if (type != 0) {
				type = 0;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 122 && px <= 182 && py >= 71 && py <= 102) {
			// 卖
			if (type != 1) {
				type = 1;
				selectItem = null;
				selectCount = 0;
			}
			return;
		}
		if (px >= 222 && px <= 282 && py >= 71 && py <= 102) // 离开
			return core.insertAction({ "type": "break" });
		// ◀，▶
		if (px >= 318 && px <= 341 && py >= 348 && py <= 376)
			return _add(item, -1);
		if (px >= 388 && px <= 416 && py >= 348 && py <= 376)
			return _add(item, 1);
		// 确定
		if (px >= 341 && px <= 387 && py >= 380 && py <= 407)
			return _confirm(item);

		// 上一页/下一页
		if (px >= 45 && px <= 105 && py >= 388) {
			if (page > 1) selectItem -= 6;
			return;
		}
		if (px >= 208 && px <= 268 && py >= 388) {
			if (page < totalPage) selectItem = Math.min(selectItem + 6, list.length - 1);
			return;
		}

		// 实际区域
		if (px >= 9 && px <= 300 && py >= 120 && py < 360) {
			if (list.length == 0) return;
			var index = parseInt((py - 120) / 40);
			var newItem = 6 * (page - 1) + index;
			if (newItem >= list.length) newItem = list.length - 1;
			if (newItem != selectItem) {
				selectItem = newItem;
				selectCount = 0;
			}
			return;
		}
	}

	this.performItemShopAction = function () {
		if (flags.type == 0) return this._performItemShopKeyBoard(flags.keycode);
		else return this._performItemShopClick(flags.px, flags.py);
	}

	this.openItemShop = function (itemShopId) {
		shopId = itemShopId;
		type = 0;
		page = 0;
		selectItem = null;
		selectCount = 0;
		core.insertAction([{
				"type": "while",
				"condition": "true",
				"data": [
					{ "type": "function", "function": "function () { core.drawItemShop(); }" },
					{ "type": "wait" },
					{ "type": "function", "function": "function() { core.performItemShopAction(); }" }
				]
			},
			{ "type": "function", "function": "function () { " +
					"core.deleteCanvas('uievent'); " +
					"core.ui._uievent_drawSelector({ \"code\": 1 }); " +
					"core.ui._uievent_drawSelector({ \"code\": 2 }); " +
					"}" }
		]);
	}

	// Write item number to save
	core.control.saveData = function () {
		var data = this.controldata.saveData();
		for (var shopId in core.status.shops) {
			if (core.status.shops[shopId].item) {
				data.shops[shopId].choices = core.status.shops[shopId].choices.map(function (t) {
					return {
						number: t.number,
						money_count: t.money_count || 0,
						sell_count: t.sell_count || 0
					}
				});
			}
		}
		return data;
	}

	core.control.loadData = function (data, callback) {
		this.controldata.loadData(data, callback);
		for (var shopId in data.shops) {
			if (data.shops[shopId].choices) {
				for (var i = 0; i < data.shops[shopId].choices.length; ++i) {
					core.status.shops[shopId].choices[i].number = data.shops[shopId].choices[i].number;
					core.status.shops[shopId].choices[i].money_count = data.shops[shopId].choices[i].money_count;
					core.status.shops[shopId].choices[i].sell_count = data.shops[shopId].choices[i].sell_count;
				}
			}
		}
	}

},
    "smoothCamera": function () {

    // 是否启用本插件，默认不启用
	this.__enableSmoothCamera = false;
	if (!this.__enableSmoothCamera) return;

	this.Camera = function () {

		// 下面这个变量决定本插件的开关
		// 你可以在游戏中使用core.setFlag('smoothCamera',false)来关闭本插件的功能
		// 同时也可以core.setFlag('smoothCamera',true)重新开启
		// 此项默认为true
		// 
		this.__switchName = 'smoothCamera';

		// 初始化成员变量
		this._cameraNeedRefresh = true;
		this._nowOffsetX = 0;
		this._nowOffsetY = 0;
		this._targetOffsetX = 0;
		this._targetOffsetY = 0;
		this._currentFloorId = null;

		// 重置镜头，在楼层变更时使用
		this.resetCamera = function () {
			this._targetOffsetX = core.bigmap.offsetX;
			this._targetOffsetY = core.bigmap.offsetY;
			this._nowOffsetX = this._targetOffsetX;
			this._nowOffsetY = this._targetOffsetY;
			this._cameraNeedRefresh = true;
		};

		// 设置焦点坐标，目前没有用
		this.setTarget = function (x, y) {
			this._targetOffsetX = x;
			this._targetOffsetY = y;
		};

		// 请求镜头更新
		this.requestCameraUpdate = function () {
			this._cameraNeedRefresh = true;
		};

		// 更新焦点坐标，目前仅根据大地图偏移决定
		this.updateTargetPosition = function () {
			this._targetOffsetX = core.bigmap.offsetX;
			this._targetOffsetY = core.bigmap.offsetY;
		};

		// 更新额外的刷新条件，即镜头未指向焦点时
		this.updateRefreshFlag = function () {
			if (this._nowOffsetX != this._targetOffsetX || this._nowOffsetY != this._targetOffsetY) {
				this._cameraNeedRefresh = true;
			}
		};

		// 判断是否禁止了弹性滚动
		this.canDirectMove = function () {
			return !core.getFlag(this.__switchName, true);
		};

		// 更新镜头坐标
		this.updateCameraPosition = function () {
			if (this._cameraNeedRefresh) {
				this._cameraNeedRefresh = false;
				var disX = this._targetOffsetX - this._nowOffsetX;
				var disY = this._targetOffsetY - this._nowOffsetY;
				if (Math.abs(disX) <= 2 && Math.abs(disY) <= 2 || this.canDirectMove()) {
					this._nowOffsetX = this._targetOffsetX;
					this._nowOffsetY = this._targetOffsetY;
				} else {
					this._nowOffsetX += disX / 10;
					this._nowOffsetY += disY / 10;
				}
				var x = -Math.floor(this._nowOffsetX);
				var y = -Math.floor(this._nowOffsetY);
				core.bigmap.canvas.forEach(function (cn) {
					core.control.setGameCanvasTranslate(cn, x, y);
				});
				core.relocateCanvas('route', core.status.automaticRoute.offsetX + x, core.status.automaticRoute.offsetY + y);
				core.setGameCanvasTranslate('hero', x + this._targetOffsetX, y + this._targetOffsetY);
			}
		};

		// 更新逻辑主体
		this.update = function () {
			this.updateTargetPosition();
			this.updateRefreshFlag();
			this.updateCameraPosition();
		};
	};

	// 其实只注释了最后一行，只能这样了
	control.drawHero = function (status, offset) {
		if (!core.isPlaying() || !core.status.floorId || core.status.gameOver) return;
		var x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y'),
			direction = core.getHeroLoc('direction');
		status = status || 'stop';
		offset = offset || 0;
		var way = core.utils.scan[direction];
		var dx = way.x,
			dy = way.y,
			offsetX = dx * offset,
			offsetY = dy * offset;
		core.bigmap.offsetX = core.clamp((x - core.__HALF_SIZE__) * 32 + offsetX, 0, 32 * core.bigmap.width - core.__PIXELS__);
		core.bigmap.offsetY = core.clamp((y - core.__HALF_SIZE__) * 32 + offsetY, 0, 32 * core.bigmap.height - core.__PIXELS__);
		core.clearAutomaticRouteNode(x + dx, y + dy);
		core.clearMap('hero');

		if (!core.hasFlag('hideHero')) {
			this._drawHero_getDrawObjs(direction, x, y, status, offset).forEach(function (block) {
				core.drawImage('hero', block.img, block.heroIcon[block.status] * block.width,
					block.heroIcon.loc * block.height, block.width, block.height,
					block.posx + (32 - block.width) / 2, block.posy + 32 - block.height, block.width, block.height);
			});
		}

		core.control.updateViewport();
		//core.setGameCanvasTranslate('hero', 0, 0);
	};

	// 复写转发
	core.drawHero = function (status, offset) {
		return core.control.drawHero(status, offset);
	};

	// 创建摄像机对象
	this.camera = new this.Camera();

	// 帧事件 更新摄像机
	this.updateCameraEx = function () {
		this.camera.update();
	};

	// 代理原本的镜头事件
	control.updateViewport = function () {
		core.plugin.camera.requestCameraUpdate();
	};

	// 更变楼层的行为追加，重置镜头
	events.prototype.changingFloor = function (floorId, heroLoc, fromLoad) {
		this.eventdata.changingFloor(floorId, heroLoc, fromLoad);
		core.plugin.camera.resetCamera();
	};

	// 注册帧事件
	core.registerAnimationFrame('smoothCameraFlash', true, this.updateCameraEx.bind(this));
}
}