///<reference path="../src/types/declaration/core.d.ts" />
function main() {
    //------------------------ 用户修改内容 ------------------------//

    this.version = '1.0.0'; // 游戏版本号；如果更改了游戏内容建议修改此version以免造成缓存问题。

    this.useCompress = false; // 是否使用压缩文件
    this.scriptCompress = true; // 是否经过打包
    this.skipResourcePackage = true; // 跳过资源打包

    this.bgmRemote = false; // 是否采用远程BGM
    this.bgmRemoteRoot = 'https://h5mota.com/music/'; // 远程BGM的根目录

    this.isCompetition = false; // 是否是比赛模式

    this.savePages = 1000; // 存档页数，每页可存5个；默认为1000页5000个存档
    this.criticalUseLoop = 1; // 循环临界的分界

    //------------------------ 用户修改内容 END ------------------------//

    this.dom = {
        body: document.body,
        gameDraw: document.getElementById('game-draw'),
        gameCanvas: document.getElementsByClassName('gameCanvas'),
        inputDiv: document.getElementById('inputDiv'),
        inputMessage: document.getElementById('inputMessage'),
        inputBox: document.getElementById('inputBox'),
        inputYes: document.getElementById('inputYes'),
        inputNo: document.getElementById('inputNo')
    };
    this.mode = 'play';
    this.loadList = [
        'loader',
        'control',
        'utils',
        'items',
        'icons',
        'maps',
        'enemys',
        'events',
        'actions',
        'data',
        'ui',
        'core'
    ];
    this.pureData = [
        'data',
        'enemys',
        'icons',
        'maps',
        'items',
        'functions',
        'events',
        'plugins'
    ];
    this.materials = [
        'animates',
        'enemys',
        'items',
        'npcs',
        'terrains',
        'enemy48',
        'npc48',
        'icons'
    ];

    this.statusBar = {
        image: {},
        icons: {
            floor: 0,
            name: null,
            lv: 1,
            hpmax: 2,
            hp: 3,
            atk: 4,
            def: 5,
            mdef: 6,
            money: 7,
            exp: 8,
            up: 9,
            book: 10,
            fly: 11,
            toolbox: 12,
            keyboard: 13,
            shop: 14,
            save: 15,
            load: 16,
            settings: 17,
            play: 18,
            pause: 19,
            stop: 20,
            speedDown: 21,
            speedUp: 22,
            rewind: 23,
            equipbox: 24,
            mana: 25,
            skill: 26,
            btn1: 27,
            btn2: 28,
            btn3: 29,
            btn4: 30,
            btn5: 31,
            btn6: 32,
            btn7: 33,
            btn8: 34
        }
    };
    this.floors = {};
    this.canvas = {};

    this.__VERSION__ = '2.10.0';
    this.__VERSION_CODE__ = 610;
}

// >>>> body end
function _createForOfIteratorHelper(r,e){var t="undefined"!=typeof Symbol&&r[Symbol.iterator]||r["@@iterator"];if(!t){if(Array.isArray(r)||(t=_unsupportedIterableToArray(r))||e&&r&&"number"==typeof r.length){t&&(r=t);var _n=0,F=function F(){};return{s:F,n:function n(){return _n>=r.length?{done:!0}:{done:!1,value:r[_n++]}},e:function e(r){throw r},f:F}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var o,a=!0,u=!1;return{s:function s(){t=t.call(r)},n:function n(){var r=t.next();return a=r.done,r},e:function e(r){u=!0,o=r},f:function f(){try{a||null==t["return"]||t["return"]()}finally{if(u)throw o}}}}function _unsupportedIterableToArray(r,a){if(r){if("string"==typeof r)return _arrayLikeToArray(r,a);var t={}.toString.call(r).slice(8,-1);return"Object"===t&&r.constructor&&(t=r.constructor.name),"Map"===t||"Set"===t?Array.from(r):"Arguments"===t||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t)?_arrayLikeToArray(r,a):void 0}}function _arrayLikeToArray(r,a){(null==a||a>r.length)&&(a=r.length);for(var e=0,n=Array(a);e<a;e++)n[e]=r[e];return n}function _regenerator(){var e,t,r="function"==typeof Symbol?Symbol:{},n=r.iterator||"@@iterator",o=r.toStringTag||"@@toStringTag";function i(r,n,o,i){var c=n&&n.prototype instanceof Generator?n:Generator,u=Object.create(c.prototype);return _regeneratorDefine2(u,"_invoke",function(r,n,o){var i,c,u,f=0,p=o||[],y=!1,G={p:0,n:0,v:e,a:d,f:d.bind(e,4),d:function d(t,r){return i=t,c=0,u=e,G.n=r,a}};function d(r,n){for(c=r,u=n,t=0;!y&&f&&!o&&t<p.length;t++){var o,i=p[t],d=G.p,l=i[2];r>3?(o=l===n)&&(u=i[(c=i[4])?5:(c=3,3)],i[4]=i[5]=e):i[0]<=d&&((o=r<2&&d<i[1])?(c=0,G.v=n,G.n=i[1]):d<l&&(o=r<3||i[0]>n||n>l)&&(i[4]=r,i[5]=n,G.n=l,c=0))}if(o||r>1)return a;throw y=!0,n}return function(o,p,l){if(f>1)throw TypeError("Generator is already running");for(y&&1===p&&d(p,l),c=p,u=l;(t=c<2?e:u)||!y;){i||(c?c<3?(c>1&&(G.n=-1),d(c,u)):G.n=u:G.v=u);try{if(f=2,i){if(c||(o="next"),t=i[o]){if(!(t=t.call(i,u)))throw TypeError("iterator result is not an object");if(!t.done)return t;u=t.value,c<2&&(c=0)}else 1===c&&(t=i["return"])&&t.call(i),c<2&&(u=TypeError("The iterator does not provide a '"+o+"' method"),c=1);i=e}else if((t=(y=G.n<0)?u:r.call(n,G))!==a)break}catch(t){i=e,c=1,u=t}finally{f=1}}return{value:t,done:y}}}(r,o,i),!0),u}var a={};function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}t=Object.getPrototypeOf;var c=[][n]?t(t([][n]())):(_regeneratorDefine2(t={},n,function(){return this}),t),u=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(c);function f(e){return Object.setPrototypeOf?Object.setPrototypeOf(e,GeneratorFunctionPrototype):(e.__proto__=GeneratorFunctionPrototype,_regeneratorDefine2(e,o,"GeneratorFunction")),e.prototype=Object.create(u),e}return GeneratorFunction.prototype=GeneratorFunctionPrototype,_regeneratorDefine2(u,"constructor",GeneratorFunctionPrototype),_regeneratorDefine2(GeneratorFunctionPrototype,"constructor",GeneratorFunction),GeneratorFunction.displayName="GeneratorFunction",_regeneratorDefine2(GeneratorFunctionPrototype,o,"GeneratorFunction"),_regeneratorDefine2(u),_regeneratorDefine2(u,o,"Generator"),_regeneratorDefine2(u,n,function(){return this}),_regeneratorDefine2(u,"toString",function(){return"[object Generator]"}),(_regenerator=function _regenerator(){return{w:i,m:f}})()}function _regeneratorDefine2(e,r,n,t){var i=Object.defineProperty;try{i({},"",{})}catch(e){i=0}_regeneratorDefine2=function _regeneratorDefine(e,r,n,t){function o(r,n){_regeneratorDefine2(e,r,function(e){return this._invoke(r,n,e)})}r?i?i(e,r,{value:n,enumerable:!t,configurable:!t,writable:!t}):e[r]=n:(o("next",0),o("throw",1),o("return",2))},_regeneratorDefine2(e,r,n,t)}function asyncGeneratorStep(n,t,e,r,o,a,c){try{var i=n[a](c),u=i.value}catch(n){return void e(n)}i.done?t(u):Promise.resolve(u).then(r,o)}function _asyncToGenerator(n){return function(){var t=this,e=arguments;return new Promise(function(r,o){var a=n.apply(t,e);function _next(n){asyncGeneratorStep(a,r,o,_next,_throw,"next",n)}function _throw(n){asyncGeneratorStep(a,r,o,_next,_throw,"throw",n)}_next(void 0)})}}main.prototype.loadScript=function(src,module){var script=document.createElement("script");script.src=src;if(module)script.type="module";document.body.appendChild(script);return new Promise(function(res,rej){script.addEventListener("load",res);script.addEventListener("error",rej)})};main.prototype.init=function(){var _ref=_asyncToGenerator(_regenerator().m(function _callee(mode,callback){return _regenerator().w(function(_context){while(1)switch(_context.n){case 0:if(main.replayChecking){main.loadSync(mode,callback)}else{main.loadAsync(mode,callback)}case 1:return _context.a(2)}},_callee)}));return function(_x,_x2){return _ref.apply(this,arguments)}}();main.prototype.loadSync=function(mode,callback){loadSource("data.process.js");main.mode=mode;if(main.useCompress){main.loadMod("project","project",function(){return 0})}else{main.pureData.forEach(function(v){main.loadMod("project",v,function(){return 0})})}var mainData=data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.main;Object.assign(main,mainData);if(main.useCompress){main.loadMod("libs","libs",function(){return 0})}else{main.loadList.forEach(function(v){main.loadMod("libs",v,function(){return 0})})}main.loading.emit("coreLoaded");var _iterator=_createForOfIteratorHelper(main.loadList),_step;try{for(_iterator.s();!(_step=_iterator.n()).done;){var name=_step.value;if(name==="core")continue;core[name]=new window[name]}}catch(err){_iterator.e(err)}finally{_iterator.f()}main.loadFloors(function(){return 0});var coreData={};["dom","statusBar","canvas","images","tilesets","materials","animates","bgms","sounds","floorIds","floors","floorPartitions"].forEach(function(t){coreData[t]=main[t]});core.initSync(coreData,function(){});main.loading.emit("coreInit");core.resize();main.core=core;callback===null||callback===void 0||callback()};main.prototype.loadAsync=function(){var _ref2=_asyncToGenerator(_regenerator().m(function _callee3(mode,callback){var i,mainData,_iterator2,_step2,name,coreData,mainSetting,auto,height,width,maxScale,target,_t;return _regenerator().w(function(_context3){while(1)switch(_context3.p=_context3.n){case 0:for(i=0;i<main.dom.gameCanvas.length;i++){main.canvas[main.dom.gameCanvas[i].id]=main.dom.gameCanvas[i].getContext("2d")}main.mode=mode;if(!main.useCompress){_context3.n=2;break}_context3.n=1;return main.loadScript("project/project.min.js?v=".concat(main.version));case 1:_context3.n=3;break;case 2:_context3.n=3;return Promise.all(main.pureData.map(function(v){return main.loadScript("project/".concat(v,".js?v=").concat(main.version))}));case 3:mainData=data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.main;Object.assign(main,mainData);if(!main.useCompress){_context3.n=5;break}_context3.n=4;return main.loadScript("libs/libs.min.js?v=".concat(main.version));case 4:if(main.mode==="play")main.loading.emit("coreLoaded");_context3.n=6;break;case 5:_context3.n=6;return Promise.all(main.loadList.map(function(v){return main.loadScript("libs/".concat(v,".js?v=").concat(main.version)).then(function(){if(v==="core"&&main.mode==="play"){main.loading.emit("coreLoaded")}})}));case 6:_iterator2=_createForOfIteratorHelper(main.loadList);_context3.p=7;_iterator2.s();case 8:if((_step2=_iterator2.n()).done){_context3.n=11;break}name=_step2.value;if(!(name==="core")){_context3.n=9;break}return _context3.a(3,10);case 9:core[name]=new window[name];case 10:_context3.n=8;break;case 11:_context3.n=13;break;case 12:_context3.p=12;_t=_context3.v;_iterator2.e(_t);case 13:_context3.p=13;_iterator2.f();return _context3.f(13);case 14:main.setMainTipsText("\u6B63\u5728\u52A0\u8F7D\u697C\u5C42\u6587\u4EF6...");if(!main.useCompress){_context3.n=16;break}_context3.n=15;return main.loadScript("project/floors.min.js?v=".concat(main.version));case 15:_context3.n=17;break;case 16:_context3.n=17;return main.loadScript("/all/__all_floors__.js?v=".concat(main.version,"&id=").concat(main.floorIds.join(","))).then(function(){main.supportBunch=true},_asyncToGenerator(_regenerator().m(function _callee2(){return _regenerator().w(function(_context2){while(1)switch(_context2.n){case 0:_context2.n=1;return Promise.all(mainData.floorIds.map(function(v){return main.loadScript("project/floors/".concat(v,".js"))}));case 1:return _context2.a(2)}},_callee2)})));case 17:coreData={};["dom","statusBar","canvas","images","tilesets","materials","animates","bgms","sounds","floorIds","floors","floorPartitions"].forEach(function(t){coreData[t]=main[t]});if(!(main.mode==="play")){_context3.n=19;break}_context3.n=18;return core.init(coreData,callback);case 18:main.loading.emit("coreInit");core.initStatus.maps=core.maps._initMaps();_context3.n=21;break;case 19:_context3.n=20;return core.init(coreData,function(){callback();core.initStatus.maps=core.maps._initMaps()});case 20:main.loading.emit("coreInit");case 21:core.resize();main.core=core;if(!(main.mode==="editor")){_context3.n=22;break}return _context3.a(2);case 22:mainSetting=Mota.require("@motajs/legacy-ui").mainSetting;auto=mainSetting.getValue("utils.autoScale",true);if(auto){height=window.innerHeight;width=window.innerWidth;maxScale=Math.min(height/core._PY_,width/core._PX_);target=Number((Math.floor(maxScale*4)/4).toFixed(2));mainSetting.setValue("screen.scale",Math.round(target*100)-25)}Mota.r(function(){Mota.require("@user/client-modules").mainRenderer.setScale(core.domStyle.scale)});case 23:return _context3.a(2)}},_callee3,null,[[7,12,13,14]])}));return function(_x3,_x4){return _ref2.apply(this,arguments)}}();main.prototype.setMainTipsText=function(text){};main.prototype.createOnChoiceAnimation=function(){};main.prototype.importFonts=function(fonts){};main.prototype.listen=function(){window.onresize=function(){try{core.resize()}catch(ee){console.error(ee)}};main.dom.body.onkeydown=function(e){if(main.editorOpened)return;try{if(e.keyCode===27)e.preventDefault();if(main.dom.inputDiv.style.display=="block")return;if(core&&(core.isPlaying()||core.status.lockControl))core.onkeyDown(e)}catch(ee){console.error(ee)}};main.dom.body.onselectstart=function(){return false};window.onblur=function(){if(core&&core.control){try{core.control.checkAutosave()}catch(e){}}};main.dom.inputYes.onclick=function(){main.dom.inputDiv.style.display="none";var func=core.platform.successCallback;core.platform.successCallback=core.platform.errorCallback=null;if(func)func(main.dom.inputBox.value)};main.dom.inputNo.onclick=function(){main.dom.inputDiv.style.display="none";var func=core.platform.errorCallback;core.platform.successCallback=core.platform.errorCallback=null;if(func)func(null)}};var main=new main;