///<reference path="../src/types/core.d.ts" />
function main() {
    //------------------------ 用户修改内容 ------------------------//

    this.version = '2.A'; // 游戏版本号；如果更改了游戏内容建议修改此version以免造成缓存问题。

    this.useCompress = false; // 是否使用压缩文件
    this.pluginUseCompress = true; // 是否是构建版样板，不用改动
    // 当你即将发布你的塔时，请使用“JS代码压缩工具”将所有js代码进行压缩，然后将这里的useCompress改为true。
    // 请注意，只有useCompress是false时才会读取floors目录下的文件，为true时会直接读取libs目录下的floors.min.js文件。
    // 如果要进行剧本的修改请务必将其改成false。

    this.bgmRemote = false; // 是否采用远程BGM
    this.bgmRemoteRoot = 'https://h5mota.com/music/'; // 远程BGM的根目录

    this.isCompetition = false; // 是否是比赛模式

    this.savePages = 1000; // 存档页数，每页可存5个；默认为1000页5000个存档
    this.criticalUseLoop = 1; // 循环临界的分界

    //------------------------ 用户修改内容 END ------------------------//

    this.dom = {
        body: document.body,
        gameGroup: document.getElementById('gameGroup'),
        mainTips: document.getElementById('mainTips'),
        musicBtn: document.getElementById('musicBtn'),
        enlargeBtn: document.createElement('img'),
        startPanel: document.getElementById('startPanel'),
        startTop: document.getElementById('startTop'),
        startTopProgressBar: document.getElementById('startTopProgressBar'),
        startTopProgress: document.getElementById('startTopProgress'),
        startTopLoadTips: document.getElementById('startTopLoadTips'),
        floorMsgGroup: document.getElementById('floorMsgGroup'),
        logoLabel: document.getElementById('logoLabel'),
        versionLabel: document.getElementById('versionLabel'),
        floorNameLabel: document.getElementById('floorNameLabel'),
        statusBar: document.getElementById('statusBar'),
        status: document.getElementsByClassName('status'),
        toolBar: document.getElementById('toolBar'),
        tools: document.getElementsByClassName('tools'),
        gameCanvas: document.getElementsByClassName('gameCanvas'),
        gif: document.getElementById('gif'),
        gif2: document.getElementById('gif2'),
        gameDraw: document.getElementById('gameDraw'),
        startButtons: document.getElementById('startButtons'),
        playGame: document.getElementById('playGame'),
        loadGame: document.getElementById('loadGame'),
        replayGame: document.getElementById('replayGame'),
        levelChooseButtons: document.getElementById('levelChooseButtons'),
        data: document.getElementById('data'),
        statusLabels: document.getElementsByClassName('statusLabel'),
        statusTexts: document.getElementsByClassName('statusText'),
        floorCol: document.getElementById('floorCol'),
        nameCol: document.getElementById('nameCol'),
        lvCol: document.getElementById('lvCol'),
        hpmaxCol: document.getElementById('hpmaxCol'),
        hpCol: document.getElementById('hpCol'),
        manaCol: document.getElementById('manaCol'),
        atkCol: document.getElementById('atkCol'),
        defCol: document.getElementById('defCol'),
        mdefCol: document.getElementById('mdefCol'),
        moneyCol: document.getElementById('moneyCol'),
        expCol: document.getElementById('expCol'),
        upCol: document.getElementById('upCol'),
        keyCol: document.getElementById('keyCol'),
        pzfCol: document.getElementById('pzfCol'),
        debuffCol: document.getElementById('debuffCol'),
        skillCol: document.getElementById('skillCol'),
        hard: document.getElementById('hard'),
        statusCanvas: document.getElementById('statusCanvas'),
        statusCanvasCtx: document
            .getElementById('statusCanvas')
            .getContext('2d'),
        inputDiv: document.getElementById('inputDiv'),
        inputMessage: document.getElementById('inputMessage'),
        inputBox: document.getElementById('inputBox'),
        inputYes: document.getElementById('inputYes'),
        inputNo: document.getElementById('inputNo'),
        next: document.getElementById('next')
    };
    this.mode = 'play';
    this.loadList = [
        'loader',
        'control',
        'utils',
        'items',
        'icons',
        'maps',
        'enemys',
        'events',
        'actions',
        'data',
        'ui',
        'core'
    ];
    this.pureData = [
        'data',
        'enemys',
        'icons',
        'maps',
        'items',
        'functions',
        'events',
        'plugins'
    ];
    this.materials = [
        'animates',
        'enemys',
        'items',
        'npcs',
        'terrains',
        'enemy48',
        'npc48',
        'icons'
    ];

    this.statusBar = {
        image: {
            floor: document.getElementById('img-floor'),
            name: document.getElementById('img-name'),
            lv: document.getElementById('img-lv'),
            hpmax: document.getElementById('img-hpmax'),
            hp: document.getElementById('img-hp'),
            mana: document.getElementById('img-mana'),
            atk: document.getElementById('img-atk'),
            def: document.getElementById('img-def'),
            mdef: document.getElementById('img-mdef'),
            money: document.getElementById('img-money'),
            exp: document.getElementById('img-exp'),
            up: document.getElementById('img-up'),
            skill: document.getElementById('img-skill'),
            book: document.getElementById('img-book'),
            fly: document.getElementById('img-fly'),
            toolbox: document.getElementById('img-toolbox'),
            keyboard: document.getElementById('img-keyboard'),
            shop: document.getElementById('img-shop'),
            save: document.getElementById('img-save'),
            load: document.getElementById('img-load'),
            settings: document.getElementById('img-settings'),
            btn1: document.getElementById('img-btn1'),
            btn2: document.getElementById('img-btn2'),
            btn3: document.getElementById('img-btn3'),
            btn4: document.getElementById('img-btn4'),
            btn5: document.getElementById('img-btn5'),
            btn6: document.getElementById('img-btn6'),
            btn7: document.getElementById('img-btn7'),
            btn8: document.getElementById('img-btn8')
        },
        icons: {
            floor: 0,
            name: null,
            lv: 1,
            hpmax: 2,
            hp: 3,
            atk: 4,
            def: 5,
            mdef: 6,
            money: 7,
            exp: 8,
            up: 9,
            book: 10,
            fly: 11,
            toolbox: 12,
            keyboard: 13,
            shop: 14,
            save: 15,
            load: 16,
            settings: 17,
            play: 18,
            pause: 19,
            stop: 20,
            speedDown: 21,
            speedUp: 22,
            rewind: 23,
            equipbox: 24,
            mana: 25,
            skill: 26,
            btn1: 27,
            btn2: 28,
            btn3: 29,
            btn4: 30,
            btn5: 31,
            btn6: 32,
            btn7: 33,
            btn8: 34
        },
        floor: document.getElementById('floor'),
        name: document.getElementById('name'),
        lv: document.getElementById('lv'),
        hpmax: document.getElementById('hpmax'),
        hp: document.getElementById('hp'),
        mana: document.getElementById('mana'),
        atk: document.getElementById('atk'),
        def: document.getElementById('def'),
        mdef: document.getElementById('mdef'),
        money: document.getElementById('money'),
        exp: document.getElementById('exp'),
        up: document.getElementById('up'),
        skill: document.getElementById('skill'),
        yellowKey: document.getElementById('yellowKey'),
        blueKey: document.getElementById('blueKey'),
        redKey: document.getElementById('redKey'),
        greenKey: document.getElementById('greenKey'),
        poison: document.getElementById('poison'),
        weak: document.getElementById('weak'),
        curse: document.getElementById('curse'),
        pickaxe: document.getElementById('pickaxe'),
        bomb: document.getElementById('bomb'),
        fly: document.getElementById('fly'),
        hard: document.getElementById('hard')
    };
    this.floors = {};
    this.canvas = {};

    this.__VERSION__ = '2.A';
    this.__VERSION_CODE__ = 600;

    this.timestamp = 1713540264723;;
}
function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _createForOfIteratorHelper(o,allowArrayLike){var it=typeof Symbol!=="undefined"&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&typeof o.length==="number"){if(it)o=it;var i=0;var F=function F(){};return{s:F,n:function n(){if(i>=o.length)return{done:true};return{done:false,value:o[i++]}},e:function e(_e){throw _e},f:F}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var normalCompletion=true,didErr=false,err;return{s:function s(){it=it.call(o)},n:function n(){var step=it.next();normalCompletion=step.done;return step},e:function e(_e2){didErr=true;err=_e2},f:function f(){try{if(!normalCompletion&&it["return"]!=null)it["return"]()}finally{if(didErr)throw err}}}}function _unsupportedIterableToArray(o,minLen){if(!o)return;if(typeof o==="string")return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);if(n==="Object"&&o.constructor)n=o.constructor.name;if(n==="Map"||n==="Set")return Array.from(o);if(n==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return _arrayLikeToArray(o,minLen)}function _arrayLikeToArray(arr,len){if(len==null||len>arr.length)len=arr.length;for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2}function _regeneratorRuntime(){"use strict";_regeneratorRuntime=function _regeneratorRuntime(){return e};var t,e={},r=Object.prototype,n=r.hasOwnProperty,o=Object.defineProperty||function(t,e,r){t[e]=r.value},i="function"==typeof Symbol?Symbol:{},a=i.iterator||"@@iterator",c=i.asyncIterator||"@@asyncIterator",u=i.toStringTag||"@@toStringTag";function define(t,e,r){return Object.defineProperty(t,e,{value:r,enumerable:!0,configurable:!0,writable:!0}),t[e]}try{define({},"")}catch(t){define=function define(t,e,r){return t[e]=r}}function wrap(t,e,r,n){var i=e&&e.prototype instanceof Generator?e:Generator,a=Object.create(i.prototype),c=new Context(n||[]);return o(a,"_invoke",{value:makeInvokeMethod(t,r,c)}),a}function tryCatch(t,e,r){try{return{type:"normal",arg:t.call(e,r)}}catch(t){return{type:"throw",arg:t}}}e.wrap=wrap;var h="suspendedStart",l="suspendedYield",f="executing",s="completed",y={};function Generator(){}function GeneratorFunction(){}function GeneratorFunctionPrototype(){}var p={};define(p,a,function(){return this});var d=Object.getPrototypeOf,v=d&&d(d(values([])));v&&v!==r&&n.call(v,a)&&(p=v);var g=GeneratorFunctionPrototype.prototype=Generator.prototype=Object.create(p);function defineIteratorMethods(t){["next","throw","return"].forEach(function(e){define(t,e,function(t){return this._invoke(e,t)})})}function AsyncIterator(t,e){function invoke(r,o,i,a){var c=tryCatch(t[r],t,o);if("throw"!==c.type){var u=c.arg,h=u.value;return h&&"object"==_typeof(h)&&n.call(h,"__await")?e.resolve(h.__await).then(function(t){invoke("next",t,i,a)},function(t){invoke("throw",t,i,a)}):e.resolve(h).then(function(t){u.value=t,i(u)},function(t){return invoke("throw",t,i,a)})}a(c.arg)}var r;o(this,"_invoke",{value:function value(t,n){function callInvokeWithMethodAndArg(){return new e(function(e,r){invoke(t,n,e,r)})}return r=r?r.then(callInvokeWithMethodAndArg,callInvokeWithMethodAndArg):callInvokeWithMethodAndArg()}})}function makeInvokeMethod(e,r,n){var o=h;return function(i,a){if(o===f)throw new Error("Generator is already running");if(o===s){if("throw"===i)throw a;return{value:t,done:!0}}for(n.method=i,n.arg=a;;){var c=n.delegate;if(c){var u=maybeInvokeDelegate(c,n);if(u){if(u===y)continue;return u}}if("next"===n.method)n.sent=n._sent=n.arg;else if("throw"===n.method){if(o===h)throw o=s,n.arg;n.dispatchException(n.arg)}else"return"===n.method&&n.abrupt("return",n.arg);o=f;var p=tryCatch(e,r,n);if("normal"===p.type){if(o=n.done?s:l,p.arg===y)continue;return{value:p.arg,done:n.done}}"throw"===p.type&&(o=s,n.method="throw",n.arg=p.arg)}}}function maybeInvokeDelegate(e,r){var n=r.method,o=e.iterator[n];if(o===t)return r.delegate=null,"throw"===n&&e.iterator["return"]&&(r.method="return",r.arg=t,maybeInvokeDelegate(e,r),"throw"===r.method)||"return"!==n&&(r.method="throw",r.arg=new TypeError("The iterator does not provide a '"+n+"' method")),y;var i=tryCatch(o,e.iterator,r.arg);if("throw"===i.type)return r.method="throw",r.arg=i.arg,r.delegate=null,y;var a=i.arg;return a?a.done?(r[e.resultName]=a.value,r.next=e.nextLoc,"return"!==r.method&&(r.method="next",r.arg=t),r.delegate=null,y):a:(r.method="throw",r.arg=new TypeError("iterator result is not an object"),r.delegate=null,y)}function pushTryEntry(t){var e={tryLoc:t[0]};1 in t&&(e.catchLoc=t[1]),2 in t&&(e.finallyLoc=t[2],e.afterLoc=t[3]),this.tryEntries.push(e)}function resetTryEntry(t){var e=t.completion||{};e.type="normal",delete e.arg,t.completion=e}function Context(t){this.tryEntries=[{tryLoc:"root"}],t.forEach(pushTryEntry,this),this.reset(!0)}function values(e){if(e||""===e){var r=e[a];if(r)return r.call(e);if("function"==typeof e.next)return e;if(!isNaN(e.length)){var o=-1,i=function next(){for(;++o<e.length;)if(n.call(e,o))return next.value=e[o],next.done=!1,next;return next.value=t,next.done=!0,next};return i.next=i}}throw new TypeError(_typeof(e)+" is not iterable")}return GeneratorFunction.prototype=GeneratorFunctionPrototype,o(g,"constructor",{value:GeneratorFunctionPrototype,configurable:!0}),o(GeneratorFunctionPrototype,"constructor",{value:GeneratorFunction,configurable:!0}),GeneratorFunction.displayName=define(GeneratorFunctionPrototype,u,"GeneratorFunction"),e.isGeneratorFunction=function(t){var e="function"==typeof t&&t.constructor;return!!e&&(e===GeneratorFunction||"GeneratorFunction"===(e.displayName||e.name))},e.mark=function(t){return Object.setPrototypeOf?Object.setPrototypeOf(t,GeneratorFunctionPrototype):(t.__proto__=GeneratorFunctionPrototype,define(t,u,"GeneratorFunction")),t.prototype=Object.create(g),t},e.awrap=function(t){return{__await:t}},defineIteratorMethods(AsyncIterator.prototype),define(AsyncIterator.prototype,c,function(){return this}),e.AsyncIterator=AsyncIterator,e.async=function(t,r,n,o,i){void 0===i&&(i=Promise);var a=new AsyncIterator(wrap(t,r,n,o),i);return e.isGeneratorFunction(r)?a:a.next().then(function(t){return t.done?t.value:a.next()})},defineIteratorMethods(g),define(g,u,"Generator"),define(g,a,function(){return this}),define(g,"toString",function(){return"[object Generator]"}),e.keys=function(t){var e=Object(t),r=[];for(var n in e)r.push(n);return r.reverse(),function next(){for(;r.length;){var t=r.pop();if(t in e)return next.value=t,next.done=!1,next}return next.done=!0,next}},e.values=values,Context.prototype={constructor:Context,reset:function reset(e){if(this.prev=0,this.next=0,this.sent=this._sent=t,this.done=!1,this.delegate=null,this.method="next",this.arg=t,this.tryEntries.forEach(resetTryEntry),!e)for(var r in this)"t"===r.charAt(0)&&n.call(this,r)&&!isNaN(+r.slice(1))&&(this[r]=t)},stop:function stop(){this.done=!0;var t=this.tryEntries[0].completion;if("throw"===t.type)throw t.arg;return this.rval},dispatchException:function dispatchException(e){if(this.done)throw e;var r=this;function handle(n,o){return a.type="throw",a.arg=e,r.next=n,o&&(r.method="next",r.arg=t),!!o}for(var o=this.tryEntries.length-1;o>=0;--o){var i=this.tryEntries[o],a=i.completion;if("root"===i.tryLoc)return handle("end");if(i.tryLoc<=this.prev){var c=n.call(i,"catchLoc"),u=n.call(i,"finallyLoc");if(c&&u){if(this.prev<i.catchLoc)return handle(i.catchLoc,!0);if(this.prev<i.finallyLoc)return handle(i.finallyLoc)}else if(c){if(this.prev<i.catchLoc)return handle(i.catchLoc,!0)}else{if(!u)throw new Error("try statement without catch or finally");if(this.prev<i.finallyLoc)return handle(i.finallyLoc)}}}},abrupt:function abrupt(t,e){for(var r=this.tryEntries.length-1;r>=0;--r){var o=this.tryEntries[r];if(o.tryLoc<=this.prev&&n.call(o,"finallyLoc")&&this.prev<o.finallyLoc){var i=o;break}}i&&("break"===t||"continue"===t)&&i.tryLoc<=e&&e<=i.finallyLoc&&(i=null);var a=i?i.completion:{};return a.type=t,a.arg=e,i?(this.method="next",this.next=i.finallyLoc,y):this.complete(a)},complete:function complete(t,e){if("throw"===t.type)throw t.arg;return"break"===t.type||"continue"===t.type?this.next=t.arg:"return"===t.type?(this.rval=this.arg=t.arg,this.method="return",this.next="end"):"normal"===t.type&&e&&(this.next=e),y},finish:function finish(t){for(var e=this.tryEntries.length-1;e>=0;--e){var r=this.tryEntries[e];if(r.finallyLoc===t)return this.complete(r.completion,r.afterLoc),resetTryEntry(r),y}},"catch":function _catch(t){for(var e=this.tryEntries.length-1;e>=0;--e){var r=this.tryEntries[e];if(r.tryLoc===t){var n=r.completion;if("throw"===n.type){var o=n.arg;resetTryEntry(r)}return o}}throw new Error("illegal catch attempt")},delegateYield:function delegateYield(e,r,n){return this.delegate={iterator:values(e),resultName:r,nextLoc:n},"next"===this.method&&(this.arg=t),y}},e}function asyncGeneratorStep(gen,resolve,reject,_next,_throw,key,arg){try{var info=gen[key](arg);var value=info.value}catch(error){reject(error);return}if(info.done){resolve(value)}else{Promise.resolve(value).then(_next,_throw)}}function _asyncToGenerator(fn){return function(){var self=this,args=arguments;return new Promise(function(resolve,reject){var gen=fn.apply(self,args);function _next(value){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"next",value)}function _throw(err){asyncGeneratorStep(gen,resolve,reject,_next,_throw,"throw",err)}_next(undefined)})}}main.prototype.loadScript=function(src,module){var script=document.createElement("script");script.src=src;if(module)script.type="module";document.body.appendChild(script);return new Promise(function(res,rej){script.addEventListener("load",res);script.addEventListener("error",rej)})};main.prototype.init=function(){var _ref=_asyncToGenerator(_regeneratorRuntime().mark(function _callee(mode,callback){var a,b;return _regeneratorRuntime().wrap(function _callee$(_context){while(1)switch(_context.prev=_context.next){case 0:_context.prev=0;a={};b={};new Proxy(a,b);new Promise(function(res){return res()});eval("`${0}`");_context.next=13;break;case 8:_context.prev=8;_context.t0=_context["catch"](0);alert("\u6D4F\u89C8\u5668\u7248\u672C\u8FC7\u4F4E\uFF0C\u65E0\u6CD5\u6E38\u73A9\u672C\u5854\uFF01");alert("\u5EFA\u8BAE\u4F7F\u7528Edge\u6D4F\u89C8\u5668\u6216Chrome\u6D4F\u89C8\u5668\u6E38\u73A9\uFF01");return _context.abrupt("return");case 13:if(main.replayChecking){main.loadSync(mode,callback)}else{main.loadAsync(mode,callback)}case 14:case"end":return _context.stop()}},_callee,null,[[0,8]])}));return function(_x,_x2){return _ref.apply(this,arguments)}}();main.prototype.loadSync=function(mode,callback){main.mode=mode;if(main.useCompress){main.loadMod("project","project",function(){return 0})}else{main.pureData.forEach(function(v){main.loadMod("project",v,function(){return 0})})}var mainData=data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.main;Object.assign(main,mainData);if(main.useCompress){main.loadMod("libs","libs",function(){return 0})}else{main.loadList.forEach(function(v){main.loadMod("libs",v,function(){return 0})})}var _iterator=_createForOfIteratorHelper(main.loadList),_step;try{for(_iterator.s();!(_step=_iterator.n()).done;){var name=_step.value;if(name==="core")continue;core[name]=new window[name]}}catch(err){_iterator.e(err)}finally{_iterator.f()}main.loadFloors(function(){return 0});var coreData={};["dom","statusBar","canvas","images","tilesets","materials","animates","bgms","sounds","floorIds","floors","floorPartitions"].forEach(function(t){coreData[t]=main[t]});core.initSync(coreData,callback);main.loading.emit("coreLoaded");main.loading.emit("coreInit");core.initStatus.maps=core.maps._initMaps();core.resize();main.core=core;core.completeAchievement=function(){return 0};core.plugin={drawLight:0}};main.prototype.loadAsync=function(){var _ref2=_asyncToGenerator(_regeneratorRuntime().mark(function _callee3(mode,callback){var i,mainData,_iterator2,_step2,name,coreData,auto;return _regeneratorRuntime().wrap(function _callee3$(_context3){while(1)switch(_context3.prev=_context3.next){case 0:for(i=0;i<main.dom.gameCanvas.length;i++){main.canvas[main.dom.gameCanvas[i].id]=main.dom.gameCanvas[i].getContext("2d")}main.mode=mode;if(!main.useCompress){_context3.next=7;break}_context3.next=5;return main.loadScript("project/project.min.js?v=".concat(main.version));case 5:_context3.next=9;break;case 7:_context3.next=9;return Promise.all(main.pureData.map(function(v){return main.loadScript("project/".concat(v,".js?v=").concat(main.version))}));case 9:mainData=data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.main;Object.assign(main,mainData);main.importFonts(main.fonts);if(!main.useCompress){_context3.next=18;break}_context3.next=15;return main.loadScript("libs/libs.min.js?v=".concat(main.version));case 15:if(main.mode==="play")main.loading.emit("coreLoaded");_context3.next=20;break;case 18:_context3.next=20;return Promise.all(main.loadList.map(function(v){return main.loadScript("libs/".concat(v,".js?v=").concat(main.version)).then(function(){if(v==="core"&&main.mode==="play"){main.loading.emit("coreLoaded")}})}));case 20:_iterator2=_createForOfIteratorHelper(main.loadList);_context3.prev=21;_iterator2.s();case 23:if((_step2=_iterator2.n()).done){_context3.next=30;break}name=_step2.value;if(!(name==="core")){_context3.next=27;break}return _context3.abrupt("continue",28);case 27:core[name]=new window[name];case 28:_context3.next=23;break;case 30:_context3.next=35;break;case 32:_context3.prev=32;_context3.t0=_context3["catch"](21);_iterator2.e(_context3.t0);case 35:_context3.prev=35;_iterator2.f();return _context3.finish(35);case 38:main.setMainTipsText("\u6B63\u5728\u52A0\u8F7D\u697C\u5C42\u6587\u4EF6...");if(!main.useCompress){_context3.next=45;break}_context3.next=42;return main.loadScript("project/floors.min.js?v=".concat(main.version));case 42:main.dom.mainTips.style.display="none";_context3.next=47;break;case 45:_context3.next=47;return new Promise(function(res){var all=main.pluginUseCompress?"":"/all/";main.loadScript("/".concat(all,"__all_floors__.js?v=").concat(main.version,"&id=").concat(main.floorIds.join(","))).then(function(){main.dom.mainTips.style.display="none";main.supportBunch=true;res()},_asyncToGenerator(_regeneratorRuntime().mark(function _callee2(){return _regeneratorRuntime().wrap(function _callee2$(_context2){while(1)switch(_context2.prev=_context2.next){case 0:_context2.next=2;return Promise.all(mainData.floorIds.map(function(v){return main.loadScript("project/floors/".concat(v,".js"))}));case 2:main.dom.mainTips.style.display="none";res();case 4:case"end":return _context2.stop()}},_callee2)})))});case 47:coreData={};["dom","statusBar","canvas","images","tilesets","materials","animates","bgms","sounds","floorIds","floors","floorPartitions"].forEach(function(t){coreData[t]=main[t]});if(!(main.mode==="play")){_context3.next=56;break}_context3.next=52;return core.init(coreData,callback);case 52:main.loading.emit("coreInit");core.initStatus.maps=core.maps._initMaps();_context3.next=59;break;case 56:_context3.next=58;return core.init(coreData,function(){callback();core.initStatus.maps=core.maps._initMaps()});case 58:main.loading.emit("coreInit");case 59:core.resize();main.core=core;if(!(main.mode==="editor")){_context3.next=63;break}return _context3.abrupt("return");case 63:auto=Mota.require("var","mainSetting").getValue("autoScale",true);if(auto&&!core.domStyle.isVertical){try{Mota.Plugin.require("utils_g").maxGameScale(1);requestAnimationFrame(function(){var style=getComputedStyle(main.dom.gameGroup);var height=parseFloat(style.height);if(height>window.innerHeight*0.95){core.control.setDisplayScale(-1);if(!core.isPlaying()&&core.flags.enableHDCanvas){core.domStyle.ratio=Math.max(window.devicePixelRatio||1,core.domStyle.scale);core.resize()}}})}catch(_unused2){}}case 65:case"end":return _context3.stop()}},_callee3,null,[[21,32,35,38]])}));return function(_x3,_x4){return _ref2.apply(this,arguments)}}();main.prototype.setMainTipsText=function(text){main.dom.mainTips.innerHTML=text};main.prototype.createOnChoiceAnimation=function(){var borderColor=main.dom.startButtonGroup.style.caretColor||"rgb(255, 215, 0)";var rgb=/^rgba?\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*\d+\s*)?\)$/.exec(borderColor);if(rgb!=null){var value=rgb[1]+", "+rgb[2]+", "+rgb[3];var style=document.createElement("style");style.type="text/css";var keyFrames="onChoice { "+"0% { border-color: rgba("+value+", 0.9); } "+"50% { border-color: rgba("+value+", 0.3); } "+"100% { border-color: rgba("+value+", 0.9); } "+"}";style.innerHTML="@-webkit-keyframes "+keyFrames+" @keyframes "+keyFrames;document.body.appendChild(style)}};main.prototype.importFonts=function(fonts){if(!(fonts instanceof Array)||fonts.length==0)return;var style=document.createElement("style");style.type="text/css";var html="";fonts.forEach(function(font){html+="@font-face { font-family: \""+font+"\"; src: url(\"project/fonts/"+font+(main.pluginUseCompress?"-"+main.timestamp:"")+".ttf\") format(\"truetype\"); }"});style.innerHTML=html;document.body.appendChild(style)};main.prototype.listen=function(){window.onresize=function(){try{core.resize()}catch(ee){console.error(ee)}};main.dom.body.onkeydown=function(e){if(main.editorOpened)return;try{if(e.keyCode===27)e.preventDefault();if(main.dom.inputDiv.style.display=="block")return;if(core&&(core.isPlaying()||core.status.lockControl))core.onkeyDown(e)}catch(ee){console.error(ee)}};main.dom.body.onkeyup=function(e){if(main.editorOpened)return;try{if(main.dom.startPanel.style.display=="block"&&(main.dom.startButtons.style.display=="block"||main.dom.levelChooseButtons.style.display=="block")){if(e.keyCode==38||e.keyCode==33)main.selectButton((main.selectedButton||0)-1);else if(e.keyCode==40||e.keyCode==34)main.selectButton((main.selectedButton||0)+1);else if(e.keyCode==67||e.keyCode==13||e.keyCode==32)main.selectButton(main.selectedButton);else if(e.keyCode==27&&main.dom.levelChooseButtons.style.display=="block"){core.showStartAnimate(true);e.preventDefault()}e.stopPropagation();return}if(main.dom.inputDiv.style.display=="block"){if(e.keyCode==13){setTimeout(function(){main.dom.inputYes.click()},50)}else if(e.keyCode==27){setTimeout(function(){main.dom.inputNo.click()},50)}return}if(core&&core.isPlaying&&core.status&&(core.isPlaying()||core.status.lockControl))core.onkeyUp(e)}catch(ee){console.error(ee)}};main.dom.body.onselectstart=function(){return false};main.dom.data.onmousedown=function(e){try{e.stopPropagation();var loc=core.actions._getClickLoc(e.clientX,e.clientY);if(loc==null)return;core.ondown(loc)}catch(ee){console.error(ee)}};main.dom.data.onmousemove=function(e){try{var loc=core.actions._getClickLoc(e.clientX,e.clientY);if(loc==null)return;core.onmove(loc)}catch(ee){console.error(ee)}};main.dom.data.onmouseup=function(e){try{var loc=core.actions._getClickLoc(e.clientX,e.clientY);if(loc==null)return;core.onup(loc)}catch(ee){console.error(ee)}};main.dom.data.onmousewheel=function(e){try{if(e.wheelDelta)core.onmousewheel(Math.sign(e.wheelDelta));else if(e.detail)core.onmousewheel(Math.sign(e.detail))}catch(ee){console.error(ee)}};main.dom.data.ontouchstart=function(e){try{e.preventDefault();var loc=core.actions._getClickLoc(e.targetTouches[0].clientX,e.targetTouches[0].clientY);if(loc==null)return;main.lastTouchLoc=loc;core.ondown(loc)}catch(ee){console.error(ee)}};main.dom.data.ontouchmove=function(e){try{e.preventDefault();var loc=core.actions._getClickLoc(e.targetTouches[0].clientX,e.targetTouches[0].clientY);if(loc==null)return;main.lastTouchLoc=loc;core.onmove(loc)}catch(ee){console.error(ee)}};main.dom.data.ontouchend=function(e){try{e.preventDefault();if(main.lastTouchLoc==null)return;var loc=main.lastTouchLoc;delete main.lastTouchLoc;core.onup(loc)}catch(e){console.error(e)}};main.statusBar.image.book.onclick=function(e){e.stopPropagation();if(core.isReplaying()){core.triggerReplay();return}if(core.isPlaying())core.openBook(true)};main.statusBar.image.fly.onclick=function(e){e.stopPropagation();if(core.isReplaying()){core.stopReplay();return}if(core.isPlaying()){if(!core.flags.equipboxButton){core.useFly(true)}else{core.openEquipbox(true)}}};main.statusBar.image.toolbox.onclick=function(e){e.stopPropagation();if(core.isReplaying()){core.rewindReplay();return}if(core.isPlaying()){core.openToolbox(core.status.event.id!="equipbox")}};main.statusBar.image.toolbox.ondblclick=function(e){e.stopPropagation();if(core.isReplaying()){return}if(core.isPlaying())core.openEquipbox(true)};main.statusBar.image.keyboard.onclick=function(e){e.stopPropagation();if(core.isReplaying()){core.control._replay_book();return}if(core.isPlaying())core.openKeyBoard(true)};main.statusBar.image.shop.onclick=function(e){e.stopPropagation();if(core.isReplaying()){core.control._replay_viewMap();return}if(core.isPlaying())core.openQuickShop(true)};main.statusBar.image.money.onclick=function(e){e.stopPropagation();if(core.isPlaying())core.openQuickShop(true)};main.statusBar.image.floor.onclick=function(e){e.stopPropagation();if(core&&core.isPlaying()&&!core.isMoving()&&!core.status.lockControl){core.ui._drawViewMaps()}};main.statusBar.image.save.onclick=function(e){e.stopPropagation();if(core.isReplaying()){core.speedDownReplay();return}if(core.isPlaying())core.save(true)};main.statusBar.image.load.onclick=function(e){e.stopPropagation();if(core.isReplaying()){core.speedUpReplay();return}if(core.isPlaying())core.load(true)};main.statusBar.image.settings.onclick=function(e){e.stopPropagation();if(core.isReplaying()){core.control._replay_SL();return}if(core.isPlaying())core.openSettings(true)};main.dom.hard.onclick=function(){core.control.setToolbarButton(!core.domStyle.toolbarBtn)};main.statusBar.image.btn1.onclick=function(e){e.stopPropagation();core.onkeyUp({keyCode:49,altKey:core.getLocalStorage("altKey")})};main.statusBar.image.btn2.onclick=function(e){e.stopPropagation();core.onkeyUp({keyCode:50,altKey:core.getLocalStorage("altKey")})};main.statusBar.image.btn3.onclick=function(e){e.stopPropagation();core.onkeyUp({keyCode:51,altKey:core.getLocalStorage("altKey")})};main.statusBar.image.btn4.onclick=function(e){e.stopPropagation();core.onkeyUp({keyCode:52,altKey:core.getLocalStorage("altKey")})};main.statusBar.image.btn5.onclick=function(e){e.stopPropagation();core.onkeyUp({keyCode:53,altKey:core.getLocalStorage("altKey")})};main.statusBar.image.btn6.onclick=function(e){e.stopPropagation();core.onkeyUp({keyCode:54,altKey:core.getLocalStorage("altKey")})};main.statusBar.image.btn7.onclick=function(e){e.stopPropagation();core.onkeyUp({keyCode:55,altKey:core.getLocalStorage("altKey")})};main.statusBar.image.btn8.onclick=function(e){e.stopPropagation();if(core.getLocalStorage("altKey")){core.removeLocalStorage("altKey");core.drawTip("Alt\u6A21\u5F0F\u5DF2\u5173\u95ED\u3002");main.statusBar.image.btn8.style.filter=""}else{core.setLocalStorage("altKey",true);core.drawTip("Alt\u6A21\u5F0F\u5DF2\u5F00\u542F\uFF1B\u6B64\u6A21\u5F0F\u4E0B1~7\u6309\u94AE\u89C6\u4E3AAlt+1~7\u3002");main.statusBar.image.btn8.style.filter="sepia(1) contrast(1.5)"}};window.onblur=function(){if(core&&core.control){try{core.control.checkAutosave()}catch(e){}}};main.dom.inputYes.onclick=function(){main.dom.inputDiv.style.display="none";var func=core.platform.successCallback;core.platform.successCallback=core.platform.errorCallback=null;if(func)func(main.dom.inputBox.value)};main.dom.inputNo.onclick=function(){main.dom.inputDiv.style.display="none";var func=core.platform.errorCallback;core.platform.successCallback=core.platform.errorCallback=null;if(func)func(null)}};var main=new main;