import { EmitableEvent, EventEmitter } from './eventEmitter';
interface DisposableEvent<T> extends EmitableEvent {
    active: (value: T) => void;
    dispose: (value: T) => void;
    destroy: () => void;
}
export declare class Disposable<T> extends EventEmitter<DisposableEvent<T>> {
    protected _data?: T;
    set data(value: T | null);
    get data(): T | null;
    protected activated: boolean;
    protected destroyed: boolean;
    constructor(data: T);
    active(): void;
    dispose(): void;
    destroy(): void;
}
export {};
