import { EmitableEvent, EventEmitter } from '../core/common/eventEmitter';
interface GameLoadEvent extends EmitableEvent {
    coreLoaded: () => void;
    autotileLoaded: () => void;
    coreInit: () => void;
    materialLoaded: () => void;
}
declare class GameLoading extends EventEmitter<GameLoadEvent> {
    private autotileLoaded;
    private autotileNum?;
    private autotileListened;
    private materialsNum;
    private materialsLoaded;
    constructor();
    addMaterialLoaded(): void;
    addAutotileLoaded(): void;
    /**
     * 当自动原件加载完毕时
     * @param autotiles 自动原件数组
     */
    onAutotileLoaded(autotiles: Partial<Record<AllIdsOf<'autotile'>, HTMLImageElement>>): void;
}
export declare const loading: GameLoading;
export interface GameEvent extends EmitableEvent {
    /** Emitted in events.prototype.resetGame. */
    reset: () => void;
    /** Emitted in src/App.vue setup. */
    mounted: () => void;
    /** Emitted in plugin/ui.js */
    statusBarUpdate: () => void;
    /** Emitted in core/index.ts */
    renderLoaded: () => void;
}
export declare const hook: EventEmitter<GameEvent>;
interface ListenerEvent extends EmitableEvent {
    hoverBlock: (block: Block, ev: MouseEvent) => void;
    leaveBlock: (block: Block, ev: MouseEvent, leaveGame: boolean) => void;
    clickBlock: (block: Block, ev: MouseEvent) => void;
    mouseMove: (ev: MouseEvent) => void;
}
declare class GameListener extends EventEmitter<ListenerEvent> {
    static num: number;
    num: number;
    constructor();
    private init;
}
export declare const gameListener: GameListener;
declare global {
    interface Main {
        loading: GameLoading;
    }
}
export {};
