type RangeScanFn<C extends Partial<Loc>> = (collection: Range<C>, data: any) => C[];
type InRangeFn<C extends Partial<Loc>> = (collection: Range<C>, data: any, item: Partial<Loc>) => boolean;
interface RangeType<C extends Partial<Loc>> {
    scan: RangeScanFn<C>;
    inRange: InRangeFn<C>;
}
export interface RangeCollection<I extends Partial<Loc>> {
    list: I[];
    range: Range<I>;
}
export declare class Range<C extends Partial<Loc>> {
    collection: RangeCollection<C>;
    cache: Record<string, any>;
    static rangeType: Record<string, RangeType<Partial<Loc>>>;
    constructor(collection: RangeCollection<C>);
    /**
     * 扫描 collection 中在范围内的物品
     * @param type 范围类型
     * @param data 范围数据
     * @returns 在范围内的物品列表
     */
    scan(type: string, data: any): C[];
    inRange(type: string, data: any, item: Partial<Loc>): boolean;
    clearCache(): void;
    static registerRangeType(type: string, scan: RangeScanFn<Partial<Loc>>, inRange: InRangeFn<Partial<Loc>>): void;
}
export {};
