import { Camera } from './camera';
import { Particle, ParticleColor } from './particle';
export declare class Renderer {
    /** 粒子列表 */
    particleList: Particle[];
    /** 渲染画布 */
    canvas: HTMLCanvasElement;
    /** webgl绘制上下文 */
    gl: WebGLRenderingContext;
    /** 绑定的摄像机 */
    camera?: Camera;
    /** 缩放比例 */
    ratio: number;
    /** gl的程序对象 */
    program: WebGLProgram;
    /** 画布缓冲区 */
    private buffer;
    /** 各个attribute的内存地址 */
    private attribLocation;
    /** 各个uniform的内存地址 */
    private uniformLocation;
    private static readonly attributes;
    private static readonly uniforms;
    constructor(width?: number, height?: number);
    /**
     * 初始化粒子画布
     * @param width 画布宽度
     * @param height 画布高度
     */
    initCanvas(width: number, height: number): void;
    /**
     * 绑定摄像机
     * @param camera 摄像机
     */
    bindCamera(camera: Camera): void;
    /**
     * 取消绑定摄像机
     */
    unbindCamera(): void;
    /**
     * 添加到一个html元素中
     * @param ele html元素
     */
    append(ele: HTMLElement): void;
    /**
     * 从当前html元素中移除
     */
    remove(): void;
    /**
     * 添加一个粒子
     * @param particle 粒子
     */
    addParticle(particle: Particle): void;
    /**
     * 移除一个粒子
     * @param particle 粒子
     */
    removeParticle(particle: Particle): void;
    /**
     * 设置画布的背景色
     * @param color 背景色
     */
    setBackground(color: ParticleColor): void;
    /**
     * 渲染所有或单个粒子
     */
    render(particle?: Particle | number): void;
    /**
     * 绑定画布的缓冲区
     * @returns 绑定的缓冲区
     */
    private bindBuffer;
    /**
     * 更新一个粒子的缓冲区数据
     * @param array 粒子的粒子元素数组
     */
    private updateOneParticleBufferData;
    /**
     * 获取gl变量的内存地址
     */
    private getGLVariblesLocation;
    /**
     * 渲染某一个粒子
     * @param particle 要渲染的粒子
     */
    private renderOne;
    private notSupport;
}
